/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.LipidDataAnalyzer;
import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.MzxmlToChromThread;
import at.tugraz.genome.lda.QuantificationMenu;
import at.tugraz.genome.lda.QuantificationThread;
import at.tugraz.genome.lda.RawToMzxmlThread;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.swing.BatchQuantificationTable;
import at.tugraz.genome.lda.swing.BatchQuantificationTableModel;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.RawQuantificationPairVO;
import at.tugraz.genome.maspectras.utils.StringUtils;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class BatchQuantThread
extends Thread {
    private QuantificationThread quantThread_;
    private RawToMzxmlThread rawmzThread_;
    private MzxmlToChromThread mzThread_;
    private BatchQuantificationTable quantTable_;
    private BatchQuantificationTableModel quantTableModel_;
    private JProgressBar progressBar_;
    private JLabel quantifyingLabel_;
    private float minusTime_;
    private float plusTime_;
    private Timer timer_;
    private boolean finished_;
    private int amountOfIsotopes_;
    int isotopesMustMatch_;
    private boolean searchUnknownTime_;
    private float basePeakCutoff_;
    private float rtShift_;
    private boolean ionMode_;
    private boolean cli_;
    private int currentLine_;
    private boolean readFromRaw_;
    int oneThird_;
    private int numberOfProcessors_;
    private int numberOfChromProcessors_;
    private boolean areWiffPresent_;
    private Vector<RawQuantificationPairVO> generatedMzXMLsFromWiff_;

    public BatchQuantThread(QuantificationMenu quantMenu, int amountOfIsotopes, int isotopesMustMatch, float basePeakCutoff, float rtShift, boolean ionMode, boolean cli) {
        this(quantMenu, Float.parseFloat(quantMenu.getTimeMinusTol().getText()), Float.parseFloat(quantMenu.getTimePlusTol().getText()), amountOfIsotopes, isotopesMustMatch, basePeakCutoff, rtShift, ionMode, cli);
    }

    public BatchQuantThread(QuantificationMenu quantMenu, float minusTime, float plusTime, int amountOfIsotopes, int isotopesMustMatch, float basePeakCutoff, float rtShift, boolean ionMode, boolean cli) {
        this(quantMenu.getBatchQuantTable(), quantMenu.getBatchQuantTableModel(), quantMenu.getProgressBar(), quantMenu.getQuantifyingLabel(), minusTime, plusTime, amountOfIsotopes, isotopesMustMatch, quantMenu.getSearchUnknownTime().isSelected(), basePeakCutoff, rtShift, quantMenu.getNrProcessorsChrom(), quantMenu.getNrProcessors(), ionMode, cli);
    }

    public BatchQuantThread(BatchQuantificationTable quantTable, BatchQuantificationTableModel quantTableModel, JProgressBar progressBar, JLabel quantifyingLabel, float minusTime, float plusTime, int amountOfIsotopes, int isotopesMustMatch, boolean searchUnknownTime, float basePeakCutoff, float rtShift, int numberOfChromProcessors, int numberOfProcessors, boolean ionMode, boolean cli) {
        this.quantTable_ = quantTable;
        this.quantTableModel_ = quantTableModel;
        this.progressBar_ = progressBar;
        this.quantifyingLabel_ = quantifyingLabel;
        this.minusTime_ = minusTime;
        this.plusTime_ = plusTime;
        this.currentLine_ = 0;
        this.quantThread_ = null;
        this.rawmzThread_ = null;
        this.mzThread_ = null;
        this.readFromRaw_ = false;
        this.oneThird_ = 100 / (3 * quantTableModel.getRowCount());
        this.amountOfIsotopes_ = amountOfIsotopes;
        this.isotopesMustMatch_ = isotopesMustMatch;
        this.searchUnknownTime_ = searchUnknownTime;
        this.basePeakCutoff_ = basePeakCutoff;
        this.rtShift_ = rtShift;
        this.numberOfProcessors_ = numberOfProcessors;
        this.numberOfChromProcessors_ = numberOfChromProcessors;
        this.generatedMzXMLsFromWiff_ = new Vector();
        this.areWiffPresent_ = false;
        this.ionMode_ = ionMode;
        this.cli_ = cli;
    }

    @Override
    public void run() {
        this.timer_ = new Timer();
        this.timer_.schedule((TimerTask)new ThreadSupervisor(), 10L, 1000L);
    }

    public boolean finished() {
        if (this.finished_) {
            this.timer_.cancel();
        }
        return this.finished_;
    }

    private void handleTimerEvent() {
        if (this.currentLine_ < this.quantTableModel_.getRowCount()) {
            RawQuantificationPairVO filePair;
            if (this.rawmzThread_ != null && this.rawmzThread_.finished()) {
                filePair = this.quantTableModel_.getDataByRow(this.currentLine_);
                if (this.rawmzThread_.getErrorString() != null && this.rawmzThread_.getErrorString().length() > 0) {
                    filePair.setStatus("ERROR");
                    this.quantTableModel_.fileQuantificationError(filePair);
                    ++this.currentLine_;
                } else {
                    this.rawmzThread_ = null;
                    if (filePair.getRawFileName().endsWith(".wiff")) {
                        this.areWiffPresent_ = true;
                        Vector<File> filesToTranslate = BatchQuantThread.getMzXMLFilesOfWiffConversion(filePair.getRawFile().getAbsolutePath());
                        for (File fileToTranslate : filesToTranslate) {
                            boolean isThere = false;
                            for (RawQuantificationPairVO attachedFile : this.generatedMzXMLsFromWiff_) {
                                if (!fileToTranslate.getAbsolutePath().equalsIgnoreCase(attachedFile.getRawFile().getAbsolutePath()) || !filePair.getQuantFile().getAbsolutePath().equalsIgnoreCase(attachedFile.getQuantFile().getAbsolutePath())) continue;
                                isThere = true;
                            }
                            if (isThere) continue;
                            this.generatedMzXMLsFromWiff_.add(new RawQuantificationPairVO(fileToTranslate, filePair.getQuantFile(), true));
                        }
                        this.quantTableModel_.fileQuantified(filePair);
                        ++this.currentLine_;
                    } else {
                        filePair.setStatus("Trans to chrom");
                        this.quantTableModel_.fireTableDataChanged();
                        this.quantifyingLabel_.setText("Translating " + filePair.getRawFileName() + " to chrom");
                        this.progressBar_.setValue(this.currentLine_ * 100 / this.quantTableModel_.getRowCount() + this.oneThird_);
                        this.readFromRaw_ = true;
                        String mzXMLFilePath = filePair.getRawFile().getAbsolutePath().substring(0, filePair.getRawFile().getAbsolutePath().lastIndexOf(".")) + "." + LipidomicsConstants.getIntermediateFileFormat();
                        this.mzThread_ = new MzxmlToChromThread(mzXMLFilePath, this.numberOfChromProcessors_);
                        this.mzThread_.start();
                    }
                }
            }
            if (this.mzThread_ != null && this.mzThread_.finished()) {
                filePair = this.quantTableModel_.getDataByRow(this.currentLine_);
                if (this.mzThread_.getErrorString() != null && this.mzThread_.getErrorString().length() > 0) {
                    filePair.setStatus("ERROR");
                    this.quantTableModel_.fileQuantificationError(filePair);
                    ++this.currentLine_;
                } else {
                    if (this.readFromRaw_ || filePair.isFromWiff()) {
                        this.readFromRaw_ = false;
                        RawToMzxmlThread.deleteMzXMLFiles(filePair.getRawFile().getAbsolutePath().substring(0, filePair.getRawFile().getAbsolutePath().lastIndexOf(".")) + "." + LipidomicsConstants.getIntermediateFileFormat());
                    }
                    boolean quantPossible = true;
                    if (this.mzThread_.isPolaritySwitched()) {
                        this.adaptTableToPolaritySwitchedData();
                        filePair = this.quantTableModel_.getDataByRow(this.currentLine_);
                        if (filePair.getStatus() != null && filePair.getStatus().startsWith("ERROR")) {
                            ++this.currentLine_;
                            quantPossible = false;
                        } else {
                            this.quantTable_.getSelectionModel().setSelectionInterval(this.currentLine_, this.currentLine_);
                        }
                    }
                    if (quantPossible) {
                        filePair.setStatus("Quantifying");
                        this.quantifyingLabel_.setText("Quantifying " + filePair.getRawFileName() + " with " + filePair.getQuantFileName());
                        this.progressBar_.setValue(this.currentLine_ * 100 / this.quantTableModel_.getRowCount() + 2 * this.oneThird_);
                        this.quantThread_ = new QuantificationThread(filePair.getRawFile().getAbsolutePath(), filePair.getQuantFile().getAbsolutePath(), LipidDataAnalyzer.getResultFilePath(filePair.getRawFile().getAbsolutePath(), filePair.getQuantFile().getAbsolutePath()), this.minusTime_, this.plusTime_, this.amountOfIsotopes_, this.isotopesMustMatch_, this.searchUnknownTime_, this.basePeakCutoff_, this.rtShift_, this.numberOfProcessors_, this.ionMode_, this.cli_);
                        this.quantThread_.start();
                    }
                }
                this.mzThread_ = null;
            }
            if (!(this.quantThread_ == null || this.quantThread_.finished() || this.quantThread_.getErrorString() != null && this.quantThread_.getErrorString().length() != 0 || this.quantThread_.getTotalAmountOfLipids() <= 0 || this.quantThread_.getCurrentLipidCount() <= 0)) {
                filePair = this.quantTableModel_.getDataByRow(this.currentLine_);
                this.progressBar_.setValue(this.currentLine_ * 100 / this.quantTableModel_.getRowCount() + 2 * this.oneThird_ + this.oneThird_ * (this.quantThread_.getCurrentLipidCount() - 1) / this.quantThread_.getTotalAmountOfLipids());
                filePair.setStatus("Quantifying " + this.quantThread_.getCurrentLipid() + " (" + this.quantThread_.getCurrentLipidCount() + "/" + this.quantThread_.getTotalAmountOfLipids() + ")");
                this.quantTable_.repaint();
            }
            if (this.quantThread_ != null && this.quantThread_.finished()) {
                filePair = this.quantTableModel_.getDataByRow(this.currentLine_);
                if (this.quantThread_.getErrorString() != null && this.quantThread_.getErrorString().length() > 0) {
                    String errorString = this.quantThread_.getErrorString();
                    if (errorString.indexOf(":") > -1) {
                        errorString = errorString.substring(errorString.indexOf(":") + 1);
                    }
                    filePair.setStatus("ERROR: " + errorString);
                    this.quantTableModel_.fileQuantificationError(filePair);
                } else {
                    filePair.setStatus("Finished");
                    this.quantTableModel_.fileQuantified(filePair);
                }
                this.quantThread_ = null;
                this.quantTable_.getSelectionModel().removeSelectionInterval(0, this.quantTable_.getRowCount());
                this.progressBar_.setValue(this.currentLine_ * 100 / this.quantTableModel_.getRowCount());
                ++this.currentLine_;
            }
            if (this.currentLine_ < this.quantTableModel_.getRowCount() && this.quantTableModel_.getDataByRow(this.currentLine_).getStatus() != null && this.quantTableModel_.getDataByRow(this.currentLine_).getStatus().startsWith("ERROR")) {
                ++this.currentLine_;
            } else if (this.currentLine_ < this.quantTableModel_.getRowCount() && this.rawmzThread_ == null && this.mzThread_ == null && this.quantThread_ == null) {
                File headerFile;
                this.readFromRaw_ = false;
                boolean threadStarted = false;
                RawQuantificationPairVO filePair2 = this.quantTableModel_.getDataByRow(this.currentLine_);
                String suffix = filePair2.getRawFile().getAbsolutePath().substring(filePair2.getRawFile().getAbsolutePath().lastIndexOf("."));
                if (suffix.equalsIgnoreCase(".RAW") || suffix.equalsIgnoreCase(".d") || suffix.equalsIgnoreCase(".wiff")) {
                    File rawFile = new File(filePair2.getRawFile().getAbsolutePath());
                    if (rawFile.isFile() && (Settings.getReadWPath() != null && Settings.getReadWPath().length() > 0 || Settings.getMsConvertPath() != null && Settings.getMsConvertPath().length() > 0) || rawFile.isDirectory() && (suffix.equalsIgnoreCase(".RAW") && (Settings.getMassWolfPath() != null && Settings.getMassWolfPath().length() > 0 || Settings.getMassPlusPlusPath() != null && Settings.getMassPlusPlusPath().length() > 0) || suffix.equalsIgnoreCase(".d") && Settings.getMsConvertPath() != null && Settings.getMsConvertPath().length() > 0)) {
                        File headerFile2 = new File(StringUtils.getChromFilePaths(filePair2.getRawFile().getAbsolutePath())[1]);
                        File mzXMLFile = new File(filePair2.getRawFile().getAbsolutePath().substring(0, filePair2.getRawFile().getAbsolutePath().length() - suffix.length()) + "." + LipidomicsConstants.getIntermediateFileFormat());
                        if (!headerFile2.exists() && !mzXMLFile.exists()) {
                            boolean isMassPlusPlus = false;
                            boolean watersMsConvert = false;
                            filePair2.setStatus("Trans to " + LipidomicsConstants.getIntermediateFileFormat());
                            this.quantTable_.scrollToCenter(this.currentLine_, 0);
                            this.quantTable_.getSelectionModel().setSelectionInterval(this.currentLine_, this.currentLine_);
                            this.quantTable_.repaint();
                            this.quantifyingLabel_.setText("Translating " + filePair2.getRawFileName() + " to " + LipidomicsConstants.getIntermediateFileFormat());
                            this.progressBar_.setValue(this.currentLine_ * 100 / this.quantTableModel_.getRowCount());
                            String[] params = new String[3];
                            if (rawFile.isFile()) {
                                if (Settings.getMsConvertPath() != null && Settings.getMsConvertPath().length() > 0) {
                                    params = BatchQuantThread.getMsConvertParams(filePair2.getRawFile().getAbsolutePath());
                                } else if (Settings.getReadWPath() != null && Settings.getReadWPath().length() > 0) {
                                    params[0] = Settings.getReadWPath();
                                    params[1] = filePair2.getRawFile().getAbsolutePath();
                                    params[2] = "p";
                                }
                            }
                            if (rawFile.isDirectory()) {
                                if (suffix.equalsIgnoreCase(".RAW")) {
                                    if (LipidomicsConstants.useMsconvertForWaters()) {
                                        params = BatchQuantThread.getMsConvertParamsWaters(filePair2.getRawFile().getAbsolutePath());
                                        watersMsConvert = true;
                                    } else if (Settings.getMassPlusPlusPath() != null && Settings.getMassPlusPlusPath().length() > 0) {
                                        params = new String[]{Settings.getMassPlusPlusPath(), "-in", filePair2.getRawFile().getAbsolutePath(), "-out", LipidomicsConstants.getIntermediateFileFormat().toLowerCase(), mzXMLFile.getAbsolutePath(), "-sample", "0"};
                                        if (LipidomicsConstants.isMS2()) {
                                            isMassPlusPlus = true;
                                        }
                                    } else if (Settings.getMassWolfPath() != null && Settings.getMassWolfPath().length() > 0) {
                                        params = new String[]{Settings.getMassWolfPath(), "--" + LipidomicsConstants.getIntermediateFileFormat(), filePair2.getRawFile().getAbsolutePath(), mzXMLFile.getAbsolutePath()};
                                    }
                                } else if (suffix.equalsIgnoreCase(".d") && Settings.getMsConvertPath() != null && Settings.getMsConvertPath().length() > 0) {
                                    params = BatchQuantThread.getMsConvertParams(filePair2.getRawFile().getAbsolutePath());
                                }
                            }
                            this.rawmzThread_ = new RawToMzxmlThread(params, isMassPlusPlus, watersMsConvert);
                            this.rawmzThread_.start();
                            threadStarted = true;
                        }
                    } else {
                        filePair2.setStatus("ERROR");
                        this.quantTableModel_.fileQuantificationError(filePair2);
                        ++this.currentLine_;
                        threadStarted = true;
                        return;
                    }
                }
                if ((suffix.equalsIgnoreCase(".mzXML") || suffix.equalsIgnoreCase(".mzML")) && !(headerFile = new File(StringUtils.getChromFilePaths(filePair2.getRawFile().getAbsolutePath())[1])).exists()) {
                    filePair2.setStatus("Trans to chrom");
                    this.quantTable_.scrollToCenter(this.currentLine_, 0);
                    this.quantTable_.getSelectionModel().setSelectionInterval(this.currentLine_, this.currentLine_);
                    this.quantTable_.repaint();
                    this.quantifyingLabel_.setText("Translating " + filePair2.getRawFileName() + " to chrom");
                    this.progressBar_.setValue(this.currentLine_ * 100 / this.quantTableModel_.getRowCount() + this.oneThird_);
                    this.mzThread_ = new MzxmlToChromThread(filePair2.getRawFile().getAbsolutePath(), this.numberOfChromProcessors_);
                    this.mzThread_.start();
                    threadStarted = true;
                }
                if (!threadStarted) {
                    filePair2.setStatus("Quantifying");
                    this.quantTable_.scrollToCenter(this.currentLine_, 0);
                    this.quantTable_.getSelectionModel().setSelectionInterval(this.currentLine_, this.currentLine_);
                    this.quantTable_.repaint();
                    this.quantifyingLabel_.setText("Quantifying " + filePair2.getRawFileName() + " with " + filePair2.getQuantFileName());
                    this.progressBar_.setValue(this.currentLine_ * 100 / this.quantTableModel_.getRowCount() + 2 * this.oneThird_);
                    this.quantThread_ = new QuantificationThread(filePair2.getRawFile().getAbsolutePath(), filePair2.getQuantFile().getAbsolutePath(), LipidDataAnalyzer.getResultFilePath(filePair2.getRawFile().getAbsolutePath(), filePair2.getQuantFile().getAbsolutePath()), this.minusTime_, this.plusTime_, this.amountOfIsotopes_, this.isotopesMustMatch_, this.searchUnknownTime_, this.basePeakCutoff_, this.rtShift_, this.numberOfProcessors_, this.ionMode_, this.cli_);
                    this.quantThread_.start();
                    threadStarted = true;
                }
                if (!threadStarted) {
                    filePair2.setStatus("ERROR");
                    this.quantTableModel_.fileQuantificationError(filePair2);
                    ++this.currentLine_;
                }
            }
        }
        if (this.currentLine_ >= this.quantTableModel_.getRowCount()) {
            if (this.areWiffPresent_) {
                this.areWiffPresent_ = false;
                this.quantTableModel_.clearFiles();
                this.quantTableModel_.addFiles(this.generatedMzXMLsFromWiff_);
                this.oneThird_ = 100 / (3 * this.quantTableModel_.getRowCount());
                this.currentLine_ = 0;
            } else {
                this.finished_ = true;
            }
        }
    }

    public static String[] getMsConvertParams(String fileToTranslate) {
        String[] params = new String[]{Settings.getMsConvertPath(), "--" + LipidomicsConstants.getIntermediateFileFormat(), fileToTranslate, "-o", StaticUtils.extractDirName(fileToTranslate)};
        return params;
    }

    public static String[] getMsConvertParamsWaters(String fileToTranslate) {
        String[] paramsNormal = BatchQuantThread.getMsConvertParams(fileToTranslate);
        String[] params = new String[paramsNormal.length + 2];
        for (int i = 0; i != paramsNormal.length; ++i) {
            params[i] = paramsNormal[i];
        }
        params[paramsNormal.length] = "--filter";
        params[paramsNormal.length + 1] = "msLevel 1";
        return params;
    }

    public static Vector<File> getMzXMLFilesOfWiffConversion(String filePath) {
        Vector<File> filesToTranslate = new Vector<File>();
        String fileStart = filePath.substring(0, filePath.lastIndexOf("."));
        File[] filesOfDir = new File(StringUtils.extractDirName(fileStart)).listFiles();
        for (int i = 0; i != filesOfDir.length; ++i) {
            String absolutePath = filesOfDir[i].getAbsolutePath();
            if (!absolutePath.startsWith(fileStart) || !absolutePath.endsWith(".mzXML") && !absolutePath.endsWith(".mzML")) continue;
            filesToTranslate.add(filesOfDir[i]);
        }
        return filesToTranslate;
    }

    private void adaptTableToPolaritySwitchedData() {
        String fileName = this.quantTableModel_.getDataByRow(this.currentLine_).getRawFileName();
        for (int i = this.currentLine_; i != this.quantTableModel_.getRowCount(); ++i) {
            File newRawFile;
            String newRawName;
            RawQuantificationPairVO filePair = this.quantTableModel_.getDataByRow(i);
            if (!filePair.getRawFileName().equalsIgnoreCase(fileName)) continue;
            String quantName = filePair.getQuantFileName();
            if (quantName.indexOf("positive") != -1) {
                newRawName = filePair.getRawFile().getAbsolutePath();
                newRawName = newRawName.substring(0, newRawName.lastIndexOf(".")) + "_positive" + ".chrom";
                newRawFile = new File(newRawName);
                this.quantTableModel_.updateRawFile(filePair, newRawFile);
                continue;
            }
            if (quantName.indexOf("negative") != -1) {
                System.out.println("I have a negative file");
                newRawName = filePair.getRawFile().getAbsolutePath();
                newRawName = newRawName.substring(0, newRawName.lastIndexOf(".")) + "_negative" + ".chrom";
                newRawFile = new File(newRawName);
                this.quantTableModel_.updateRawFile(filePair, newRawFile);
                continue;
            }
            filePair.setStatus("ERROR: Quant file must contain positive or negativein the file name for polarity switched data");
            this.quantTableModel_.fileQuantificationError(filePair);
        }
        this.quantTableModel_.fireTableDataChanged();
    }

    private class ThreadSupervisor
    extends TimerTask {
        private ThreadSupervisor() {
        }

        @Override
        public void run() {
            BatchQuantThread.this.handleTimerEvent();
        }
    }
}

