/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda;

import at.tugraz.genome.lda.Lipidomics2DPainter;
import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.parser.LDAResultReader;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.swing.LipidomicsTableCellRenderer;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.maspectras.graphics.MacOSResizer;
import at.tugraz.genome.maspectras.quantification.Analyzer;
import at.tugraz.genome.maspectras.quantification.CgChromatogram;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.quantification.ChromatogramReader;
import at.tugraz.genome.maspectras.utils.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ChromExportThread
extends Thread {
    private String lipidClass_;
    private File fileToStore_;
    private Dimension dim_;
    private Vector<String> expsToExport_;
    private Vector<String> resultsToUse_;
    private Vector<String> chromsToUse_;
    private Vector<String> analsToExport_;
    private String picType_;
    private boolean analInColumn_;
    private String errorString_ = null;
    private boolean finished_ = false;
    private int currentLipidCount_;
    private String currentLipid_;
    private String currentExperiment_;
    private int totalAmountOfLipids_;
    private boolean interrupt_;
    private Double rtTolerance_;
    private Hashtable<String, Integer> isLookup_;
    private Hashtable<String, Integer> esLookup_;

    public ChromExportThread(String lipidClass, File fileToStore, Dimension dim, Vector<String> expsToExport, Vector<String> resultsToUse, Vector<String> chromsToUse, Vector<String> analsToExport, String picType, boolean analInColumn, Double rtTolerance, Hashtable<String, Integer> isLookup, Hashtable<String, Integer> esLookup) {
        this.lipidClass_ = lipidClass;
        this.fileToStore_ = fileToStore;
        this.dim_ = dim;
        this.expsToExport_ = expsToExport;
        this.resultsToUse_ = resultsToUse;
        this.chromsToUse_ = chromsToUse;
        this.analsToExport_ = analsToExport;
        this.picType_ = picType;
        this.analInColumn_ = analInColumn;
        this.errorString_ = null;
        this.finished_ = false;
        this.rtTolerance_ = rtTolerance;
        this.isLookup_ = isLookup;
        this.esLookup_ = esLookup;
    }

    public boolean finished() {
        return this.finished_;
    }

    public String getErrorString() {
        return this.errorString_;
    }

    public int getCurrentLipidCount() {
        return this.currentLipidCount_;
    }

    public String getCurrentLipid() {
        return this.currentLipid_;
    }

    public String getCurrentExperiment() {
        return this.currentExperiment_;
    }

    public int getTotalAmountOfLipids() {
        return this.totalAmountOfLipids_;
    }

    @Override
    public void run() {
        try {
            this.exportChromatograms(this.fileToStore_, this.dim_, this.expsToExport_, this.resultsToUse_, this.chromsToUse_, this.analsToExport_, this.picType_, this.analInColumn_);
        }
        catch (IOException iox) {
            this.errorString_ = iox.getMessage();
        }
        this.finished_ = true;
    }

    private void exportChromatograms(File fileToStore, Dimension dim, Vector<String> expsToExport, Vector<String> resultsToUse, Vector<String> chromsToUse, Vector<String> analsToExport, String picType, boolean analInColumn) throws IOException {
        this.currentLipidCount_ = 0;
        this.currentLipid_ = "";
        this.currentExperiment_ = "";
        this.totalAmountOfLipids_ = expsToExport.size() * analsToExport.size();
        if (picType.equalsIgnoreCase("exportPNG")) {
            BufferedImage chroms = new BufferedImage(dim.width, dim.height, 5);
            this.drawChromatograms(chroms.getGraphics(), false, dim, expsToExport, resultsToUse, chromsToUse, analsToExport, analInColumn);
            ImageIO.write((RenderedImage)chroms, "PNG", fileToStore);
        } else if (picType.equalsIgnoreCase("exportSVG")) {
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            String svgNS = "http://www.w3.org/2000/svg";
            Document document = domImpl.createDocument(svgNS, "svg", null);
            SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
            this.drawChromatograms(svgGenerator, true, dim, expsToExport, resultsToUse, chromsToUse, analsToExport, analInColumn);
            boolean useCSS = true;
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(fileToStore));
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            svgGenerator.stream(out, useCSS);
        }
    }

    private void drawChromatograms(Graphics g, boolean ignorePlatformSpecificSettings, Dimension dim, Vector<String> expsToExport, Vector<String> resultsToUse, Vector<String> chromsToUse, Vector<String> analsToExport, boolean analInColumn) {
        String legend;
        int i;
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, dim.width, dim.height);
        int topMargin = 2;
        int marginLegendPicture = 2;
        int bottomMargin = 2;
        int leftMargin = 2;
        int rightMargin = 2;
        double rotationAngle = -1.5707963267948966;
        Vector<String> columnLegend = new Vector<String>(expsToExport);
        Vector<String> rowLegend = new Vector<String>(analsToExport);
        if (analInColumn) {
            columnLegend = new Vector<String>(analsToExport);
            rowLegend = new Vector<String>(expsToExport);
        }
        g2.setColor(Color.BLACK);
        Font bigFont = new Font("SansSerif", 0, 200);
        g2.setFont(bigFont);
        FontMetrics bigFontMetrics = g2.getFontMetrics();
        Font legendFont = new Font("SansSerif", 0, 12);
        g2.setFont(legendFont);
        FontMetrics legendFontMetrics = g2.getFontMetrics();
        int longestColumnLegend = 0;
        for (String string : columnLegend) {
            int sw = legendFontMetrics.stringWidth(string);
            if (sw <= longestColumnLegend) continue;
            longestColumnLegend = sw;
        }
        int longestRowLegend = 0;
        for (String legend3 : rowLegend) {
            int sw = legendFontMetrics.stringWidth(legend3);
            if (sw <= longestRowLegend) continue;
            longestRowLegend = sw;
        }
        int n = dim.width - leftMargin - rightMargin - marginLegendPicture - longestRowLegend;
        int maxpaintheight = dim.height - topMargin - bottomMargin - marginLegendPicture - longestColumnLegend;
        int widthOnePicture = n / columnLegend.size();
        if (widthOnePicture < legendFontMetrics.getHeight() * 8) {
            this.errorString_ = "The picture width is too small for the selection! Use at least " + (legendFontMetrics.getHeight() * 8 * columnLegend.size() + leftMargin + rightMargin + marginLegendPicture + longestRowLegend) + " or more!";
            return;
        }
        int heightOnePicture = maxpaintheight / rowLegend.size();
        if (heightOnePicture < legendFontMetrics.getHeight() * 2) {
            this.errorString_ = "The picture height is too small for the selection! Use at least " + (legendFontMetrics.getHeight() * 2 * rowLegend.size() + 1 + topMargin + bottomMargin + marginLegendPicture + longestColumnLegend) + " or more!";
            return;
        }
        int leftPictureMargin = leftMargin + marginLegendPicture + longestRowLegend;
        int topPictureMargin = topMargin + marginLegendPicture + longestColumnLegend;
        for (i = 0; i != rowLegend.size(); ++i) {
            legend = rowLegend.get(i);
            int marginFromTheTop = topMargin + longestColumnLegend + marginLegendPicture;
            int xPos = leftMargin + longestRowLegend - legendFontMetrics.stringWidth(legend);
            int yPos = marginFromTheTop + i * maxpaintheight / rowLegend.size() + (heightOnePicture + legendFontMetrics.getHeight()) / 2;
            g2.drawString(legend, xPos, yPos);
        }
        if (!this.useMacSpecificSettings(ignorePlatformSpecificSettings)) {
            g2.rotate(rotationAngle);
        }
        for (i = 0; i != columnLegend.size(); ++i) {
            legend = columnLegend.get(i);
            if (this.useMacSpecificSettings(ignorePlatformSpecificSettings)) {
                BufferedImage image = new BufferedImage(bigFontMetrics.stringWidth(legend), bigFontMetrics.getHeight(), 2);
                Graphics2D g22 = (Graphics2D)image.getGraphics();
                g22.setColor(Color.BLACK);
                g22.setFont(bigFont);
                g22.drawString(legend, 0, bigFontMetrics.getAscent());
                int sw2 = bigFontMetrics.stringWidth(legend);
                int swXExtension2 = (int)((double)sw2 * Math.cos(-rotationAngle));
                int swYExtension2 = (int)((double)sw2 * Math.sin(-rotationAngle));
                int shYExtension2 = (int)((double)bigFontMetrics.getHeight() * Math.cos(-rotationAngle));
                int shXExtension2 = (int)((double)bigFontMetrics.getHeight() * Math.sin(-rotationAngle));
                BufferedImage image2 = new BufferedImage(swXExtension2 + shXExtension2, swYExtension2 + shYExtension2, 2);
                Graphics2D g23 = (Graphics2D)image2.getGraphics();
                g23.rotate(rotationAngle);
                boolean normalStringXCoordinate2 = false;
                int normalStringYCoordinate2 = swYExtension2;
                double coordinateRadius2 = Math.sqrt(Math.pow(0.0, 2.0) + Math.pow(normalStringYCoordinate2, 2.0));
                double angle2 = Math.atan((double)normalStringYCoordinate2 / (double)normalStringXCoordinate2);
                g23.drawImage((Image)image, (int)(coordinateRadius2 * Math.cos(angle2 - rotationAngle)), (int)(coordinateRadius2 * Math.sin(angle2 - rotationAngle)), null);
                g23.rotate(-rotationAngle);
                image2 = MacOSResizer.resizeTrick(image2, legendFontMetrics.getHeight(), legendFontMetrics.stringWidth(legend));
                g2.drawImage((Image)image2, i * n / columnLegend.size() + widthOnePicture / 2, topMargin + longestColumnLegend - legendFontMetrics.stringWidth(legend), null);
                continue;
            }
            g2.drawString(legend, -topMargin - longestColumnLegend, leftMargin + longestRowLegend + marginLegendPicture + i * n / columnLegend.size() + (widthOnePicture + legendFontMetrics.getHeight()) / 2);
        }
        if (!this.useMacSpecificSettings(ignorePlatformSpecificSettings)) {
            g2.rotate(-rotationAngle);
        }
        this.currentLipidCount_ = 0;
        for (i = 0; i != chromsToUse.size(); ++i) {
            File chro;
            String chroFile = chromsToUse.get(i);
            String[] filePaths = StringUtils.getChromFilePaths(chroFile);
            try {
                ChromatogramReader reader_ = new ChromatogramReader(filePaths[1], filePaths[2], filePaths[3], filePaths[0], LipidomicsConstants.isSparseData(), LipidomicsConstants.getChromSmoothRange());
                Hashtable<String, Boolean> showMods = new Hashtable<String, Boolean>();
                QuantificationResult result = LDAResultReader.readResultFile(resultsToUse.get(i), showMods);
                Vector<LipidParameterSet> params = result.getIdentifications().get(this.lipidClass_);
                Hashtable<String, Hashtable> resultHash = new Hashtable<String, Hashtable>();
                for (LipidParameterSet set : params) {
                    String[] molRtAndMod;
                    String displayString = set.getNameString();
                    if (showMods.get(this.lipidClass_).booleanValue()) {
                        displayString = displayString + "_" + set.getModificationName();
                    }
                    if ((molRtAndMod = StaticUtils.extractMoleculeRtAndModFromMoleculeName(displayString))[1] == null) {
                        molRtAndMod[1] = "";
                    }
                    if (molRtAndMod[2] == null) {
                        molRtAndMod[2] = "";
                    }
                    Hashtable rtHash = new Hashtable();
                    if (resultHash.containsKey(molRtAndMod[0])) {
                        rtHash = (Hashtable)resultHash.get(molRtAndMod[0]);
                    }
                    Hashtable modHash = new Hashtable();
                    if (rtHash.containsKey(molRtAndMod[1])) {
                        modHash = (Hashtable)rtHash.get(molRtAndMod[1]);
                    }
                    modHash.put(molRtAndMod[2], set);
                    rtHash.put(molRtAndMod[1], modHash);
                    resultHash.put(molRtAndMod[0], rtHash);
                }
                for (int j = 0; j != analsToExport.size(); ++j) {
                    if (this.interrupt_) {
                        this.errorString_ = "The export has been interrupted! The chroms until this point have been exported!";
                        this.finished_ = true;
                        return;
                    }
                    String anal = analsToExport.get(j);
                    ++this.currentLipidCount_;
                    this.currentLipid_ = anal;
                    this.currentExperiment_ = expsToExport.get(i);
                    String[] molRtAndMod = StaticUtils.extractMoleculeRtAndModFromMoleculeName(anal);
                    if (molRtAndMod[1] == null) {
                        molRtAndMod[1] = "";
                    }
                    if (molRtAndMod[2] == null) {
                        molRtAndMod[2] = "";
                    }
                    if (!resultHash.containsKey(molRtAndMod[0])) continue;
                    Hashtable rtHash = (Hashtable)resultHash.get(molRtAndMod[0]);
                    LipidParameterSet set = null;
                    Vector sets = new Vector();
                    for (String rt : rtHash.keySet()) {
                        if (this.rtTolerance_ != null && !this.isLookup_.containsKey(anal) && !this.esLookup_.containsKey(anal) && !StaticUtils.isWithinTolerance(this.rtTolerance_, Double.valueOf(rt), Double.valueOf(molRtAndMod[1]))) continue;
                        if (((Hashtable)rtHash.get(rt)).containsKey(molRtAndMod[2])) {
                            sets.add(((Hashtable)rtHash.get(rt)).get(molRtAndMod[2]));
                            continue;
                        }
                        if (!molRtAndMod[2].equalsIgnoreCase("") || !showMods.get(this.lipidClass_).booleanValue() || ((Hashtable)rtHash.get(rt)).size() != 1) continue;
                        sets.add(((Hashtable)rtHash.get(rt)).values().iterator().next());
                    }
                    int evidence = 0;
                    if (sets.size() == 1) {
                        set = (LipidParameterSet)sets.get(0);
                        evidence = StaticUtils.checkMS2Evidence(set);
                    } else if (sets.size() > 1) {
                        set = new LipidParameterSet(((LipidParameterSet)sets.get((int)0)).Mz[0], ((LipidParameterSet)sets.get((int)0)).Peptide, ((LipidParameterSet)sets.get(0)).getDoubleBonds(), ((LipidParameterSet)sets.get(0)).getModificationName(), 0.0, ((LipidParameterSet)sets.get(0)).getAnalyteFormula(), ((LipidParameterSet)sets.get(0)).getModificationFormula(), ((LipidParameterSet)sets.get(0)).getCharge(), ((LipidParameterSet)sets.get(0)).getOhNumber());
                        set.LowerMzBand = ((LipidParameterSet)sets.get((int)0)).LowerMzBand;
                        set.UpperMzBand = ((LipidParameterSet)sets.get((int)0)).UpperMzBand;
                        Vector<CgProbe> probes = new Vector<CgProbe>();
                        for (int l = 0; l != sets.size(); ++l) {
                            LipidParameterSet set0 = (LipidParameterSet)sets.get(l);
                            int evd0 = StaticUtils.checkMS2Evidence(set0);
                            if (evd0 > evidence) {
                                evidence = evd0;
                            }
                            for (int k = 0; k != set0.ProbeCount(); ++k) {
                                probes.add(set0.Probe(k));
                            }
                        }
                        set.setProbes(probes);
                    }
                    int x0 = leftPictureMargin;
                    x0 = analInColumn ? (x0 += j * n / columnLegend.size()) : (x0 += i * n / columnLegend.size());
                    int y0 = topPictureMargin;
                    y0 = analInColumn ? (y0 += (i + 1) * maxpaintheight / rowLegend.size()) : (y0 += (j + 1) * maxpaintheight / rowLegend.size());
                    if (set != null) {
                        Vector<CgProbe> storedProbes = new Vector<CgProbe>();
                        for (int k = 0; k != set.ProbeCount(); ++k) {
                            storedProbes.add(set.Probe(k));
                        }
                        CgChromatogram chrom = reader_.readChromatogram(set.Mz[0] - set.LowerMzBand, set.Mz[0] + set.UpperMzBand, result.getMsLevels().get(this.lipidClass_));
                        chrom.Smooth(LipidomicsConstants.getChromSmoothRange(), LipidomicsConstants.getChromSmoothRepeats());
                        chrom.GetMaximumAndAverage();
                        float maxValue = chrom.getM_peakValue();
                        float maxFound = Analyzer.getHighestIntensityOfProbes(storedProbes, chrom);
                        float zoomFactor = 1.0f;
                        if (maxFound > 0.0f) {
                            zoomFactor = maxValue / maxFound;
                        }
                        if (evidence > 0) {
                            if (evidence == 1) {
                                g.setColor(Color.ORANGE);
                            } else if (evidence == 1) {
                                g.setColor(Color.YELLOW);
                            } else if (evidence == 3) {
                                g.setColor(LipidomicsTableCellRenderer.BRIGHT_GREEN);
                            }
                            g.fillRect(x0 + 1, y0 - heightOnePicture + 1, widthOnePicture - 2, heightOnePicture - 2);
                            g.setColor(Color.BLACK);
                        }
                        Lipidomics2DPainter.draw2DDiagram(g2, chrom, storedProbes, x0, y0, widthOnePicture, heightOnePicture, 1, zoomFactor);
                    }
                    if (!LipidomicsConstants.isChromExportShowLegend()) continue;
                    String descr = this.currentExperiment_ + " " + this.currentLipid_;
                    int sw = legendFontMetrics.stringWidth(descr);
                    g2.drawString(descr, x0 + (widthOnePicture - sw) / 2, y0 - heightOnePicture / 2);
                }
                continue;
            }
            catch (CgException e) {
                chro = new File(chroFile);
                new WarningMessage(new JFrame(), "Warning", "The file " + chro.getName() + " does not work because of the following reason: " + e.getMessage());
                continue;
            }
            catch (ExcelInputFileException e) {
                chro = new File(chroFile);
                new WarningMessage(new JFrame(), "Warning", "The file " + chro.getName() + " does not work because of the following reason: " + e.getMessage());
            }
        }
    }

    private boolean useMacSpecificSettings(boolean ignorePlatformSettings) {
        return !ignorePlatformSettings && Settings.isOSMacAndJavaLookAndFeel();
    }

    public void stopThread() {
        this.interrupt_ = true;
    }
}

