/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.analysis;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.analysis.ComparativeNameExtractor;
import at.tugraz.genome.lda.analysis.ComparativeResultsLookup;
import at.tugraz.genome.lda.analysis.IsotopeCorrector;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.parser.LDAResultReader;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.utils.DoubleCalculator;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.AbsoluteSettingsVO;
import at.tugraz.genome.lda.vos.DoubleStringVO;
import at.tugraz.genome.lda.vos.InternalStandardStatistics;
import at.tugraz.genome.lda.vos.LipidClassSettingVO;
import at.tugraz.genome.lda.vos.ProbeVolConcVO;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.lda.vos.ResultAreaVO;
import at.tugraz.genome.lda.vos.ResultCompGroupVO;
import at.tugraz.genome.lda.vos.ResultCompVO;
import at.tugraz.genome.lda.vos.ResultFileVO;
import at.tugraz.genome.lda.vos.VolumeConcVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.utils.Calculator;
import at.tugraz.genome.voutils.GeneralComparator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;

public class ComparativeAnalysis
extends ComparativeNameExtractor
implements ComparativeResultsLookup {
    private Hashtable<String, Hashtable<String, Vector<Hashtable<String, ResultAreaVO>>>> unprocessedResults_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>> isNullResult_;
    private Hashtable<String, Hashtable<String, Vector<ResultAreaVO>>> allResults_;
    private Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> allResultsHash_;
    private Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> isResults_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Double>>> isCorrectionFactors_;
    private Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> esResults_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Double>>> esCorrectionFactors_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactorsToBestIS_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactorsToBestES_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactorsToBestESISCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactorsToBestESMedianCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, Double>>>> correctionFactorsToBestESSingleCorr_;
    private Hashtable<String, Hashtable<String, InternalStandardStatistics>> intStandStatistics_;
    private Hashtable<String, Hashtable<String, InternalStandardStatistics>> extStandStatistics_;
    private Hashtable<String, Hashtable<String, InternalStandardStatistics>> extStandStatisticsISCorrected_;
    private Hashtable<String, Hashtable<String, InternalStandardStatistics>> extStandStatisticsISMedianCorrected_;
    private Hashtable<String, Hashtable<String, Hashtable<String, InternalStandardStatistics>>> extStandStatisticsISSingleCorrected_;
    private Hashtable<String, Vector<String>> standardsOrderedConcerningReliability_;
    private Hashtable<String, Vector<String>> extstandsOrderedConcerningReliability_;
    private Hashtable<String, Vector<String>> extstandsISCorrOrderedConcerningReliability_;
    private Hashtable<String, Vector<String>> extstandsMedianCorrOrderedConcerningReliability_;
    private Hashtable<String, Hashtable<String, Vector<String>>> extstandsSingleCorrOrderedConcerningReliability_;
    private Hashtable<String, Hashtable<String, String>> modifications_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>> applicableStandards_;
    private Hashtable<String, Hashtable<String, String>> bestExpForStandard_;
    private Hashtable<String, Hashtable<String, String>> inProperForBestComparableProbe_;
    private Hashtable<String, Hashtable<String, String>> inProperForBestComparableProbeES_;
    private Hashtable<String, Hashtable<String, String>> inProperForBestComparableProbeESISCorr_;
    private Hashtable<String, Hashtable<String, String>> inProperForBestComparableProbeESMedianCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<String, String>>> inProperForBestComparableProbeESSingleCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>> applicableStandardsES_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>> applicableStandardsESISCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>> applicableStandardsESMedianCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>>> applicableStandardsESSingleCorr_;
    private Hashtable<String, Hashtable<String, String>> bestExpForExtStandard_;
    private Hashtable<String, Hashtable<String, String>> bestExpForExtStandardISCorr_;
    private Hashtable<String, Hashtable<String, String>> bestExpForExtStandardMedianCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<String, String>>> bestExpForExtStandardSingleCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> referenceValues_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> referenceValuesES_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> referenceValuesESISCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> referenceValuesESMedianCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>>> referenceValuesESSingleCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<String, ResultCompVO>>> comparativeRatios_;
    private Hashtable<String, Hashtable<String, Hashtable<String, ResultCompVO>>> comparativeRatiosGroups_;
    private Hashtable<String, Vector<String>> allMoleculeNames_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> medianOfRatios_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> medianOfESRatios_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> medianOfESRatiosISCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> medianOfESRatiosMedianCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>>> medianOfESRatiosSingleCorr_;
    private Hashtable<String, Vector<String>> expNamesOfGroup_;
    private Hashtable<String, Integer> maxIsotopesOfGroup_;
    private ElementConfigParser elementParser_;
    private AbsoluteSettingsVO absSetting_;
    private Hashtable<String, Double> classCutoffs_;
    private int maxCutoffIsotope_;
    private Hashtable<String, Hashtable<Integer, Vector<Double>>> isSingleRefAreas_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Vector<Double>>>> isSingleCorrectiveFactors_;
    private Hashtable<String, Hashtable<String, Integer>> correctionTypeISLookup_;
    private Hashtable<String, Hashtable<Integer, Vector<Double>>> esSingleRefAreasNoCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Vector<Double>>>> esSingleCorrectiveFactorsNoCorr_;
    private Hashtable<String, Hashtable<String, Integer>> correctionTypeESLookup_;
    private Hashtable<String, Hashtable<Integer, Vector<Double>>> esSingleRefAreasIntCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Vector<Double>>>> esSingleCorrectiveFactorsIntCorr_;
    private Hashtable<String, Hashtable<Integer, Vector<Double>>> esSingleRefAreasMedCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Vector<Double>>>> esSingleCorrectiveFactorsMedCorr_;
    private Hashtable<String, Hashtable<Integer, Hashtable<Integer, Vector<Double>>>> esSingleRefAreasSingleCorr_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Hashtable<Integer, Vector<Double>>>>> esSingleCorrectiveFactorsSingleCorr_;
    private Hashtable<String, Hashtable<Integer, VolumeConcVO>> isAmountLookup_;
    private Hashtable<String, Hashtable<Integer, VolumeConcVO>> esAmountLookup_;
    private LinkedHashMap<String, Integer> classSequence_;
    private LinkedHashMap<String, Vector<String>> correctAnalyteSequence_;
    private Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects_;
    private double expRtGroupingTime_;
    private HydroxyEncoding faHydroxyEncoding_;
    private HydroxyEncoding lcbHydroxyEncoding_;
    private Hashtable<String, Integer> chainsOfClass_;

    public ComparativeAnalysis(Vector<File> resultFiles, String isSelectionPrefix, String esSelectionPrefix, AbsoluteSettingsVO absSetting, Hashtable<String, Double> classCutoffs, int maxCutoffIsotope, LinkedHashMap<String, Integer> classSequence, LinkedHashMap<String, Vector<String>> correctAnalyteSequence, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects, double expRtGroupingTime) {
        this(resultFiles, isSelectionPrefix, esSelectionPrefix, absSetting, classCutoffs, maxCutoffIsotope, null, null, classSequence, correctAnalyteSequence, quantObjects, expRtGroupingTime);
    }

    public ComparativeAnalysis(Vector<File> resultFiles, String isSelectionPrefix, String esSelectionPrefix, AbsoluteSettingsVO absSetting, Hashtable<String, Double> classCutoffs, int maxCutoffIsotope, Vector<String> groups, Hashtable<String, Vector<File>> filesOfGroup, LinkedHashMap<String, Integer> classSequence, LinkedHashMap<String, Vector<String>> correctAnalyteSequence, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects, double expRtGroupingTime) {
        super(resultFiles, isSelectionPrefix, esSelectionPrefix, groups, filesOfGroup);
        this.absSetting_ = absSetting;
        this.classSequence_ = classSequence;
        this.correctAnalyteSequence_ = correctAnalyteSequence;
        this.quantObjects_ = quantObjects;
        this.expRtGroupingTime_ = expRtGroupingTime;
        this.classCutoffs_ = classCutoffs;
        this.maxCutoffIsotope_ = maxCutoffIsotope;
        this.faHydroxyEncoding_ = null;
        this.lcbHydroxyEncoding_ = null;
        this.chainsOfClass_ = new Hashtable();
    }

    @Override
    public void parseInput(int statisticsViewMode, boolean combineOxWithNonOx) throws ExcelInputFileException, LipidCombinameEncodingException {
        this.elementParser_ = Settings.getElementParser();
        this.unprocessedResults_ = new Hashtable();
        this.isNullResult_ = new Hashtable();
        this.allResults_ = new Hashtable();
        this.allResultsHash_ = new Hashtable();
        this.modifications_ = new Hashtable();
        this.extractInformation(statisticsViewMode, combineOxWithNonOx);
        if (this.groups_ != null) {
            this.expNamesOfGroup_ = new Hashtable();
            for (String group : this.groups_) {
                Vector<String> expNames = new Vector<String>();
                block1: for (File file : (Vector)this.filesOfGroup_.get(group)) {
                    for (String expName : this.expNameToFile_.keySet()) {
                        if (!file.getAbsolutePath().equalsIgnoreCase(((File)this.expNameToFile_.get(expName)).getAbsolutePath())) continue;
                        expNames.add(expName);
                        continue block1;
                    }
                }
                this.expNamesOfGroup_.put(group, expNames);
            }
        }
    }

    public void calculateStatistics() throws LipidCombinameEncodingException {
        this.extractInternalStandardStatistics();
        this.extractExternalStandardStatistics();
        this.calculateRelativeComparisonValues();
    }

    private void extractExternalStandardStatistics() {
        this.esResults_ = new Hashtable();
        this.allESNames_ = new Hashtable();
        this.extractStandardVOsFromResults(this.esResults_, this.allESNames_, this.esSelectionPrefix_);
        this.calculteESRelativeCorrectionFactors();
        this.calculateStatisticsForESStandards();
        this.selectMostReliableESStandard();
        this.getApplicableESStandardsForExperiment();
        this.selectBestComparableESProbeForStandard();
        this.calculateRelativeCorrectiveValuesComparedToBestES();
        this.calculateESMedians();
        this.extractESAmountValues();
        this.calculateESReferenceValueForExperiments();
    }

    private void extractInternalStandardStatistics() {
        this.isResults_ = new Hashtable();
        this.allISNames_ = new Hashtable();
        this.maxIsotopesOfGroup_ = new Hashtable();
        this.extractStandardVOsFromResults(this.isResults_, this.allISNames_, this.isSelectionPrefix_);
        this.calculteISRelativeCorrectionFactors();
        this.calculateStatisticsForISStandards();
        this.selectMostReliableISStandard();
        this.getApplicableISStandardsForExperiment();
        this.selectBestComparableISProbeForStandard();
        this.calculateRelativeCorrectiveValuesComparedToBestIS();
        this.calculateISMedians();
        this.extractISAmountValues();
        this.calculateISReferenceValueForExperiments();
    }

    private void extractStandardVOsFromResults(Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> standResults, Hashtable<String, Hashtable<String, String>> standNames, String selectionPrefix) {
        for (String molGroupName : this.allResults_.keySet()) {
            String chosenGroupForStandards = this.absSetting_ == null ? molGroupName : this.absSetting_.getChosenClass(molGroupName);
            Hashtable<String, Vector<ResultAreaVO>> resultsMoleculeGroup = this.allResults_.get(chosenGroupForStandards);
            Hashtable<String, Hashtable> isResultOfOneGroup = new Hashtable<String, Hashtable>();
            Hashtable<String, String> isOfOneMolGroup = new Hashtable<String, String>();
            int highestIsoValue = 0;
            for (String experimentName : resultsMoleculeGroup.keySet()) {
                for (ResultAreaVO molecule : resultsMoleculeGroup.get(experimentName)) {
                    if (molecule.getMaxIsotope() > highestIsoValue) {
                        highestIsoValue = molecule.getMaxIsotope();
                    }
                    if (selectionPrefix == null || !molecule.getMoleculeName().startsWith(selectionPrefix)) continue;
                    String isName = molecule.getMoleculeName();
                    Hashtable oneIsResults = new Hashtable();
                    if (isResultOfOneGroup.containsKey(isName)) {
                        oneIsResults = (Hashtable)isResultOfOneGroup.get(isName);
                    }
                    oneIsResults.put(experimentName, molecule);
                    isResultOfOneGroup.put(isName, oneIsResults);
                    isOfOneMolGroup.put(isName, isName);
                }
            }
            if (isResultOfOneGroup.size() > 0) {
                standResults.put(molGroupName, isResultOfOneGroup);
            }
            standNames.put(molGroupName, isOfOneMolGroup);
            this.maxIsotopesOfGroup_.put(molGroupName, highestIsoValue);
        }
    }

    private boolean isISAvailable() {
        boolean isFound = false;
        for (String molGroupName : this.isResults_.keySet()) {
            if (((Hashtable)this.allISNames_.get(molGroupName)).size() <= 0) continue;
            isFound = true;
        }
        return isFound;
    }

    private void calculateStatisticsForESStandards() {
        this.extStandStatistics_ = new Hashtable();
        this.calculateStatisticsForStandard(this.esResults_, this.allESNames_, this.esCorrectionFactors_, this.extStandStatistics_, true, 0);
        boolean isFound = this.isISAvailable();
        if (isFound) {
            this.extStandStatisticsISCorrected_ = new Hashtable();
            this.calculateStatisticsForStandard(this.esResults_, this.allESNames_, this.esCorrectionFactors_, this.extStandStatisticsISCorrected_, true, 1);
            this.extStandStatisticsISMedianCorrected_ = new Hashtable();
            this.calculateStatisticsForStandard(this.esResults_, this.allESNames_, this.esCorrectionFactors_, this.extStandStatisticsISMedianCorrected_, true, 2);
            this.extStandStatisticsISSingleCorrected_ = new Hashtable();
            for (String molGroupName : this.allResults_.keySet()) {
                Hashtable<String, Hashtable<String, InternalStandardStatistics>> extStandStatisticsISSingleCorrectedGroup = new Hashtable<String, Hashtable<String, InternalStandardStatistics>>();
                for (String isName : ((Hashtable)this.allISNames_.get(molGroupName)).keySet()) {
                    Hashtable<String, InternalStandardStatistics> molGroupStatistics = new Hashtable<String, InternalStandardStatistics>();
                    if (((Hashtable)this.allESNames_.get(molGroupName)).size() > 0) {
                        this.calculateStatisticsForStandardGroup(molGroupName, this.esResults_.get(molGroupName), this.esCorrectionFactors_.get(molGroupName), molGroupStatistics, true, this.correctionTypeISLookup_.get(molGroupName).get(isName), isName);
                    }
                    extStandStatisticsISSingleCorrectedGroup.put(isName, molGroupStatistics);
                }
                this.extStandStatisticsISSingleCorrected_.put(molGroupName, extStandStatisticsISSingleCorrectedGroup);
            }
        }
    }

    private void calculateStatisticsForISStandards() {
        this.intStandStatistics_ = new Hashtable();
        this.calculateStatisticsForStandard(this.isResults_, this.allISNames_, this.isCorrectionFactors_, this.intStandStatistics_, false, 0);
    }

    private void calculateStatisticsForStandard(Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> standResults, Hashtable<String, Hashtable<String, String>> standNames, Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactors, Hashtable<String, Hashtable<String, InternalStandardStatistics>> standardsStatistics, boolean respectDilution, int standMethod) {
        for (String molGroupName : standResults.keySet()) {
            if (standNames.get(molGroupName).size() <= 0) continue;
            Hashtable<String, Hashtable<String, ResultAreaVO>> standards = standResults.get(molGroupName);
            Hashtable<String, InternalStandardStatistics> molGroupISStatistics = new Hashtable<String, InternalStandardStatistics>();
            this.calculateStatisticsForStandardGroup(molGroupName, standards, correctionFactors.get(molGroupName), molGroupISStatistics, respectDilution, standMethod, null);
            standardsStatistics.put(molGroupName, molGroupISStatistics);
        }
    }

    private void calculateStatisticsForStandardGroup(String molGroupName, Hashtable<String, Hashtable<String, ResultAreaVO>> standards, Hashtable<String, Hashtable<String, Double>> correctionFactors, Hashtable<String, InternalStandardStatistics> molGroupISStatistics, boolean respectDilution, int standMethod, String correctionStandard) {
        for (String standardName : standards.keySet()) {
            Hashtable<String, ResultAreaVO> standardElements = standards.get(standardName);
            int howOftenFound = standardElements.size();
            float mean = 0.0f;
            float median = 0.0f;
            float stdev = Float.NaN;
            float coefficentOfVariation = Float.NaN;
            float lowerThreshold = Float.NaN;
            float upperThreshold = Float.NaN;
            int amountIsotopesFoundInAll = 0;
            if (howOftenFound > 0) {
                amountIsotopesFoundInAll = standardElements.values().iterator().next().getMaxIsotope();
            }
            Hashtable<String, Double> correctiveFactors = correctionFactors.get(standardName);
            howOftenFound = 0;
            for (String string : standardElements.keySet()) {
                ResultAreaVO resultVO = standardElements.get(string);
                double area = this.correctAreaCorrespondingly(resultVO.getTotalArea(amountIsotopesFoundInAll), molGroupName, string, amountIsotopesFoundInAll, correctiveFactors, respectDilution, standMethod, correctionStandard);
                if (!(area > 0.0) || Double.isNaN(area) || Double.isInfinite(area)) continue;
                ++howOftenFound;
            }
            if (howOftenFound > 1) {
                for (ResultAreaVO resultAreaVO : standardElements.values()) {
                    if (resultAreaVO.getMaxIsotope() >= amountIsotopesFoundInAll) continue;
                    amountIsotopesFoundInAll = resultAreaVO.getMaxIsotope();
                }
            }
            if (howOftenFound > 0) {
                Vector<Float> valuesVector = new Vector<Float>();
                for (String expName : standardElements.keySet()) {
                    ResultAreaVO resultVO2 = standardElements.get(expName);
                    float value = (float)this.correctAreaCorrespondingly(resultVO2.getTotalArea(amountIsotopesFoundInAll), molGroupName, expName, amountIsotopesFoundInAll, correctiveFactors, respectDilution, standMethod, correctionStandard);
                    if (!(value > 0.0f) || Float.isNaN(value) || Float.isInfinite(value)) continue;
                    valuesVector.add(Float.valueOf(value));
                }
                Float[] floatArray = ComparativeAnalysis.medianPlusUpperLowerValues(valuesVector);
                float[] lowerUpperThreshold = ComparativeAnalysis.getLowerUpperOutlierThresholds(floatArray, 2.0f);
                lowerThreshold = lowerUpperThreshold[0];
                upperThreshold = lowerUpperThreshold[1];
                Vector<Float> valuesVector2 = new Vector<Float>();
                for (Float value : valuesVector) {
                    if (!(lowerThreshold <= value.floatValue()) || !(value.floatValue() <= upperThreshold)) continue;
                    valuesVector2.add(value);
                }
                float[] values = new float[howOftenFound];
                howOftenFound = valuesVector2.size();
                for (int i = 0; i != howOftenFound; ++i) {
                    values[i] = ((Float)valuesVector2.get(i)).floatValue();
                }
                mean = Calculator.mean(values);
                median = Calculator.median(valuesVector2).floatValue();
                stdev = Calculator.stddeviation(values);
                coefficentOfVariation = stdev / mean;
            }
            InternalStandardStatistics statVO = new InternalStandardStatistics(standardName, howOftenFound, amountIsotopesFoundInAll, mean, median, stdev, coefficentOfVariation, lowerThreshold, upperThreshold);
            molGroupISStatistics.put(standardName, statVO);
        }
    }

    private double correctAreaCorrespondingly(double area, String molGroupName, String expName, int amountIsotopesFoundInAll, Hashtable<String, Double> correctiveFactors, boolean respectDilution, int standMethod, String preferredStandard) {
        double value = area * correctiveFactors.get(expName);
        if (this.absSetting_ != null && respectDilution) {
            value *= (double)this.absSetting_.getClassSettings().get(molGroupName).getDilutionFactors().get(expName).floatValue();
        }
        if (standMethod == 1 || standMethod == 2 || standMethod > 2) {
            String mostReliableStandard = preferredStandard;
            if ((mostReliableStandard == null || mostReliableStandard.length() < 1) && this.standardsOrderedConcerningReliability_.containsKey(molGroupName) && this.standardsOrderedConcerningReliability_.get(molGroupName).size() > 0) {
                mostReliableStandard = this.standardsOrderedConcerningReliability_.get(molGroupName).get(0);
            }
            if (mostReliableStandard != null && mostReliableStandard.length() > 0) {
                String bestExp = this.bestExpForStandard_.get(molGroupName).get(mostReliableStandard);
                double correctionFactor = 1.0;
                if (standMethod == 1) {
                    correctionFactor = this.isResults_.get(molGroupName).get(mostReliableStandard).get(bestExp).getTotalArea(amountIsotopesFoundInAll) / this.referenceValues_.get(molGroupName).get(expName).get(amountIsotopesFoundInAll - 1);
                } else if (standMethod == 2) {
                    correctionFactor = this.medianOfRatios_.get(molGroupName).get(bestExp).get(amountIsotopesFoundInAll - 1) / this.medianOfRatios_.get(molGroupName).get(expName).get(amountIsotopesFoundInAll - 1);
                } else if (this.isSingleCorrectiveFactors_.get(molGroupName).get(expName) != null && this.isSingleCorrectiveFactors_.get(molGroupName).get(expName).get(standMethod) != null) {
                    correctionFactor = this.isSingleCorrectiveFactors_.get(molGroupName).get(expName).get(standMethod).get(amountIsotopesFoundInAll - 1);
                } else {
                    return 0.0;
                }
                value = correctionFactor > 0.0 ? (value *= correctionFactor) : 0.0;
            }
        }
        return value;
    }

    private void selectMostReliableESStandard() {
        this.extstandsOrderedConcerningReliability_ = new Hashtable();
        this.selectMostReliableStandard(this.extStandStatistics_, this.allESNames_, this.extstandsOrderedConcerningReliability_);
        boolean isFound = this.isISAvailable();
        if (isFound) {
            this.extstandsISCorrOrderedConcerningReliability_ = new Hashtable();
            this.selectMostReliableStandard(this.extStandStatisticsISCorrected_, this.allESNames_, this.extstandsISCorrOrderedConcerningReliability_);
            this.extstandsMedianCorrOrderedConcerningReliability_ = new Hashtable();
            this.selectMostReliableStandard(this.extStandStatisticsISMedianCorrected_, this.allESNames_, this.extstandsMedianCorrOrderedConcerningReliability_);
            this.extstandsSingleCorrOrderedConcerningReliability_ = new Hashtable();
            for (String molGroupName : this.allResults_.keySet()) {
                Hashtable<String, Vector<String>> standardsOrderedCorrSingle = new Hashtable<String, Vector<String>>();
                for (String isName : ((Hashtable)this.allISNames_.get(molGroupName)).keySet()) {
                    Hashtable<String, Vector<String>> standardsGroupCorrSingle = new Hashtable<String, Vector<String>>();
                    if (((Hashtable)this.allESNames_.get(molGroupName)).size() <= 0) continue;
                    this.selectMostReliableStandardGroup(molGroupName, this.extStandStatisticsISSingleCorrected_.get(molGroupName).get(isName), (Hashtable)this.allESNames_.get(molGroupName), standardsGroupCorrSingle);
                    standardsOrderedCorrSingle.put(isName, standardsGroupCorrSingle.get(molGroupName));
                }
                this.extstandsSingleCorrOrderedConcerningReliability_.put(molGroupName, standardsOrderedCorrSingle);
            }
        }
    }

    private void selectMostReliableISStandard() {
        this.standardsOrderedConcerningReliability_ = new Hashtable();
        this.selectMostReliableStandard(this.intStandStatistics_, this.allISNames_, this.standardsOrderedConcerningReliability_);
    }

    private void selectMostReliableStandard(Hashtable<String, Hashtable<String, InternalStandardStatistics>> standStatistics, Hashtable<String, Hashtable<String, String>> standNames, Hashtable<String, Vector<String>> standardsOrdered) {
        for (String molGroupName : standStatistics.keySet()) {
            this.selectMostReliableStandardGroup(molGroupName, standStatistics.get(molGroupName), standNames.get(molGroupName), standardsOrdered);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void selectMostReliableStandardGroup(String molGroupName, Hashtable<String, InternalStandardStatistics> standStatistics, Hashtable<String, String> standNames, Hashtable<String, Vector<String>> standardsOrdered) {
        if (standNames.size() > 0) {
            void var11_15;
            Vector<String> orderedConcerningReliability = new Vector<String>();
            Hashtable<String, InternalStandardStatistics> molGroupISStatistics = standStatistics;
            Vector<InternalStandardStatistics> oftenFound = new Vector<InternalStandardStatistics>();
            ArrayList<InternalStandardStatistics> rarelyFound = new ArrayList<InternalStandardStatistics>();
            int mostOftenFound = 0;
            for (InternalStandardStatistics internalStandardStatistics : molGroupISStatistics.values()) {
                if (internalStandardStatistics.getHowOftenFound() <= mostOftenFound) continue;
                mostOftenFound = internalStandardStatistics.getHowOftenFound();
            }
            int foundThreshold = (int)Calculator.roundFloat((float)mostOftenFound * 0.9f, 0);
            for (InternalStandardStatistics stat : molGroupISStatistics.values()) {
                if (stat.getHowOftenFound() >= foundThreshold) {
                    oftenFound.add(stat);
                    continue;
                }
                rarelyFound.add(stat);
            }
            Collections.sort(oftenFound, new GeneralComparator("at.tugraz.genome.lda.vos.InternalStandardStatistics", "getCoefficentOfVariation", "java.lang.Float"));
            boolean bl = false;
            while (var11_15 != oftenFound.size()) {
                int j;
                Vector sortByArea = new Vector();
                sortByArea.add(oftenFound.get((int)var11_15));
                for (j = var11_15 + true; j < oftenFound.size() && (double)((InternalStandardStatistics)oftenFound.get(j)).getCoefficentOfVariation() < (double)((InternalStandardStatistics)oftenFound.get((int)var11_15)).getCoefficentOfVariation() + 0.05; ++j) {
                    sortByArea.add(oftenFound.get(j));
                }
                Collections.sort(sortByArea, new GeneralComparator("at.tugraz.genome.lda.vos.InternalStandardStatistics", "getMedian", "java.lang.Float"));
                for (j = sortByArea.size() - 1; j != -1; --j) {
                    orderedConcerningReliability.add(((InternalStandardStatistics)sortByArea.get(j)).getStandardName());
                }
                var11_15 += sortByArea.size() - 1;
                ++var11_15;
            }
            if (rarelyFound.size() > 0) {
                void var11_17;
                Collections.sort(rarelyFound, new GeneralComparator("at.tugraz.genome.lda.vos.InternalStandardStatistics", "getHowOftenFound", "java.lang.Integer"));
                int n = rarelyFound.size() - 1;
                while (var11_17 != -1) {
                    orderedConcerningReliability.add(((InternalStandardStatistics)rarelyFound.get((int)var11_17)).getStandardName());
                    --var11_17;
                }
            }
            standardsOrdered.put(molGroupName, orderedConcerningReliability);
        }
    }

    private void selectBestComparableESProbeForStandard() {
        this.bestExpForExtStandard_ = new Hashtable();
        this.selectBestComparableISProbeForStandard(this.esResults_, this.extStandStatistics_, this.allESNames_, this.esCorrectionFactors_, this.extstandsOrderedConcerningReliability_, this.applicableStandardsES_, this.inProperForBestComparableProbeES_, this.bestExpForExtStandard_, true, 0);
        boolean isFound = this.isISAvailable();
        if (isFound) {
            this.bestExpForExtStandardISCorr_ = new Hashtable();
            this.selectBestComparableISProbeForStandard(this.esResults_, this.extStandStatisticsISCorrected_, this.allESNames_, this.esCorrectionFactors_, this.extstandsISCorrOrderedConcerningReliability_, this.applicableStandardsESISCorr_, this.inProperForBestComparableProbeESISCorr_, this.bestExpForExtStandardISCorr_, true, 1);
            this.bestExpForExtStandardMedianCorr_ = new Hashtable();
            this.selectBestComparableISProbeForStandard(this.esResults_, this.extStandStatisticsISMedianCorrected_, this.allESNames_, this.esCorrectionFactors_, this.extstandsMedianCorrOrderedConcerningReliability_, this.applicableStandardsESMedianCorr_, this.inProperForBestComparableProbeESMedianCorr_, this.bestExpForExtStandardMedianCorr_, true, 2);
            this.bestExpForExtStandardSingleCorr_ = new Hashtable();
            for (String molGroupName : this.allResults_.keySet()) {
                Hashtable<String, Hashtable<String, String>> bestExpForExtStandardGroup = new Hashtable<String, Hashtable<String, String>>();
                for (String isName : ((Hashtable)this.allISNames_.get(molGroupName)).keySet()) {
                    Hashtable<String, String> bestExpForExtStandard = new Hashtable<String, String>();
                    if (((Hashtable)this.allESNames_.get(molGroupName)).size() > 0) {
                        this.selectBestComparableISProbeForStandardGroup(molGroupName, this.esResults_.get(molGroupName), this.extStandStatisticsISSingleCorrected_.get(molGroupName).get(isName), this.esCorrectionFactors_.get(molGroupName), this.extstandsSingleCorrOrderedConcerningReliability_.get(molGroupName).get(isName), this.applicableStandardsESSingleCorr_.get(molGroupName).get(isName), this.inProperForBestComparableProbeESSingleCorr_.get(molGroupName).get(isName), bestExpForExtStandard, true, this.correctionTypeISLookup_.get(molGroupName).get(isName), isName);
                    }
                    if (bestExpForExtStandard.size() <= 0) continue;
                    bestExpForExtStandardGroup.put(isName, bestExpForExtStandard);
                }
                if (bestExpForExtStandardGroup.size() <= 0) continue;
                this.bestExpForExtStandardSingleCorr_.put(molGroupName, bestExpForExtStandardGroup);
            }
        }
    }

    private void selectBestComparableISProbeForStandard() {
        this.bestExpForStandard_ = new Hashtable();
        this.selectBestComparableISProbeForStandard(this.isResults_, this.intStandStatistics_, this.allISNames_, this.isCorrectionFactors_, this.standardsOrderedConcerningReliability_, this.applicableStandards_, this.inProperForBestComparableProbe_, this.bestExpForStandard_, false, 0);
    }

    private void selectBestComparableISProbeForStandard(Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> standResults, Hashtable<String, Hashtable<String, InternalStandardStatistics>> standStatistics, Hashtable<String, Hashtable<String, String>> standNames, Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactors, Hashtable<String, Vector<String>> standardsOrderedConcerningReliability, Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>> applicableStandards, Hashtable<String, Hashtable<String, String>> inProperForBestComparableProbe, Hashtable<String, Hashtable<String, String>> bestExpForStandard, boolean respectDilution, int standMethod) {
        for (String molGroupName : standardsOrderedConcerningReliability.keySet()) {
            if (standNames.get(molGroupName).size() <= 0) continue;
            Hashtable<String, String> expForStandard = new Hashtable<String, String>();
            this.selectBestComparableISProbeForStandardGroup(molGroupName, standResults.get(molGroupName), standStatistics.get(molGroupName), correctionFactors.get(molGroupName), standardsOrderedConcerningReliability.get(molGroupName), applicableStandards.get(molGroupName), inProperForBestComparableProbe.get(molGroupName), expForStandard, respectDilution, standMethod, null);
            if (expForStandard.size() <= 0) continue;
            bestExpForStandard.put(molGroupName, expForStandard);
        }
    }

    private void selectBestComparableISProbeForStandardGroup(String molGroupName, Hashtable<String, Hashtable<String, ResultAreaVO>> standResults, Hashtable<String, InternalStandardStatistics> standStatistics, Hashtable<String, Hashtable<String, Double>> correctionFactors, Vector<String> orderedConcerningReliability, Hashtable<String, Hashtable<String, Boolean>> applicableStandards, Hashtable<String, String> inProperForBestComparableProbe, Hashtable<String, String> expForStandard, boolean respectDilution, int standMethod, String corrStandard) {
        for (String isName : orderedConcerningReliability) {
            Hashtable<String, Integer> experimentsThatFoundStandard = new Hashtable<String, Integer>();
            int expFoundHowManyStandardsMax = 0;
            for (String expName : applicableStandards.keySet()) {
                if (!applicableStandards.get(expName).get(isName).booleanValue() || inProperForBestComparableProbe.containsKey(expName)) continue;
                experimentsThatFoundStandard.put(expName, applicableStandards.get(expName).size());
                if ((Integer)experimentsThatFoundStandard.get(expName) <= expFoundHowManyStandardsMax) continue;
                expFoundHowManyStandardsMax = (Integer)experimentsThatFoundStandard.get(expName);
            }
            int lowerThreshold = (int)Calculator.roundFloat((float)expFoundHowManyStandardsMax * 0.8f, 0);
            Hashtable<String, String> expThatAreFine = new Hashtable<String, String>();
            for (String expName : experimentsThatFoundStandard.keySet()) {
                if ((Integer)experimentsThatFoundStandard.get(expName) < lowerThreshold) continue;
                expThatAreFine.put(expName, expName);
            }
            InternalStandardStatistics stat = standStatistics.get(isName);
            float median = stat.getMedian();
            if (!(median > 1.0f)) continue;
            Hashtable<String, ResultAreaVO> isValues = standResults.get(isName);
            Hashtable<String, Double> correctiveFactors = correctionFactors.get(isName);
            String currentExperiment = isValues.keySet().iterator().next();
            float closestToMedian = this.calculateRatioToMedianOneDir((float)this.correctAreaCorrespondingly(isValues.get(currentExperiment).getTotalArea(stat.getAmountIsotopesFoundInAll()), molGroupName, currentExperiment, stat.getAmountIsotopesFoundInAll(), correctiveFactors, respectDilution, standMethod, corrStandard), median);
            for (String experimentName : isValues.keySet()) {
                float area;
                float ratio;
                if (!expThatAreFine.containsKey(experimentName) || !((ratio = this.calculateRatioToMedianOneDir(area = (float)this.correctAreaCorrespondingly(isValues.get(experimentName).getTotalArea(stat.getAmountIsotopesFoundInAll()), molGroupName, experimentName, stat.getAmountIsotopesFoundInAll(), correctiveFactors, respectDilution, standMethod, corrStandard), median)) < closestToMedian)) continue;
                closestToMedian = ratio;
                currentExperiment = experimentName;
            }
            expForStandard.put(isName, currentExperiment);
        }
    }

    private void getApplicableESStandardsForExperiment() {
        this.inProperForBestComparableProbeES_ = new Hashtable();
        this.applicableStandardsES_ = new Hashtable();
        this.getApplicableStandardsForExperiment(this.esResults_, this.allESNames_, this.esCorrectionFactors_, this.extStandStatistics_, this.inProperForBestComparableProbeES_, this.applicableStandardsES_, true, 0);
        boolean isFound = this.isISAvailable();
        if (isFound) {
            this.inProperForBestComparableProbeESISCorr_ = new Hashtable();
            this.applicableStandardsESISCorr_ = new Hashtable();
            this.getApplicableStandardsForExperiment(this.esResults_, this.allESNames_, this.esCorrectionFactors_, this.extStandStatisticsISCorrected_, this.inProperForBestComparableProbeESISCorr_, this.applicableStandardsESISCorr_, true, 1);
            this.inProperForBestComparableProbeESMedianCorr_ = new Hashtable();
            this.applicableStandardsESMedianCorr_ = new Hashtable();
            this.getApplicableStandardsForExperiment(this.esResults_, this.allESNames_, this.esCorrectionFactors_, this.extStandStatisticsISMedianCorrected_, this.inProperForBestComparableProbeESMedianCorr_, this.applicableStandardsESMedianCorr_, true, 2);
            this.applicableStandardsESSingleCorr_ = new Hashtable();
            this.inProperForBestComparableProbeESSingleCorr_ = new Hashtable();
            for (String molGroupName : this.allResults_.keySet()) {
                Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>> applicableStandardsCorrSingle = new Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>>();
                Hashtable<String, Hashtable<String, String>> inProperForBestComparableProbeSingleCorr = new Hashtable<String, Hashtable<String, String>>();
                for (String isName : ((Hashtable)this.allISNames_.get(molGroupName)).keySet()) {
                    Hashtable<String, String> inProperForBestComparableProbe = new Hashtable<String, String>();
                    Hashtable<String, Hashtable<String, Boolean>> applicableStandards = new Hashtable<String, Hashtable<String, Boolean>>();
                    if (((Hashtable)this.allESNames_.get(molGroupName)).size() > 0) {
                        this.getApplicableStandardsForExperimentGroup(molGroupName, this.esResults_.get(molGroupName), this.esCorrectionFactors_.get(molGroupName), this.extStandStatisticsISSingleCorrected_.get(molGroupName).get(isName), inProperForBestComparableProbe, applicableStandards, true, this.correctionTypeISLookup_.get(molGroupName).get(isName), isName);
                    }
                    applicableStandardsCorrSingle.put(isName, applicableStandards);
                    inProperForBestComparableProbeSingleCorr.put(isName, inProperForBestComparableProbe);
                }
                this.applicableStandardsESSingleCorr_.put(molGroupName, applicableStandardsCorrSingle);
                this.inProperForBestComparableProbeESSingleCorr_.put(molGroupName, inProperForBestComparableProbeSingleCorr);
            }
        }
    }

    private void getApplicableISStandardsForExperiment() {
        this.inProperForBestComparableProbe_ = new Hashtable();
        this.applicableStandards_ = new Hashtable();
        this.getApplicableStandardsForExperiment(this.isResults_, this.allISNames_, this.isCorrectionFactors_, this.intStandStatistics_, this.inProperForBestComparableProbe_, this.applicableStandards_, false, 0);
    }

    private void getApplicableStandardsForExperiment(Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> standResults, Hashtable<String, Hashtable<String, String>> standNames, Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactors, Hashtable<String, Hashtable<String, InternalStandardStatistics>> standStatistics, Hashtable<String, Hashtable<String, String>> inproperForBestComparableProbe, Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>> applicableStandards, boolean respectDilution, int standMethod) {
        for (String moleculeGroup : standResults.keySet()) {
            if (standNames.get(moleculeGroup).size() <= 0) continue;
            Hashtable<String, Hashtable<String, Boolean>> groupApplic = new Hashtable<String, Hashtable<String, Boolean>>();
            Hashtable<String, String> inproper = new Hashtable<String, String>();
            this.getApplicableStandardsForExperimentGroup(moleculeGroup, standResults.get(moleculeGroup), correctionFactors.get(moleculeGroup), standStatistics.get(moleculeGroup), inproper, groupApplic, respectDilution, standMethod, null);
            inproperForBestComparableProbe.put(moleculeGroup, inproper);
            applicableStandards.put(moleculeGroup, groupApplic);
        }
    }

    private void getApplicableStandardsForExperimentGroup(String moleculeGroup, Hashtable<String, Hashtable<String, ResultAreaVO>> standResults, Hashtable<String, Hashtable<String, Double>> correctiveFactors, Hashtable<String, InternalStandardStatistics> standStatistics, Hashtable<String, String> inproperForBestComparableProbe, Hashtable<String, Hashtable<String, Boolean>> groupApplic, boolean respectDilution, int standMethod, String corrStandard) {
        for (int i = 1; i != this.maxIsotopesOfGroup_.get(moleculeGroup) + 1; ++i) {
            for (File resultFile : this.resultFiles_) {
                Hashtable<String, ResultAreaVO> areasForStandard;
                String fileName = StaticUtils.extractFileName(resultFile.getAbsolutePath());
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
                fileName = fileName.substring(0, fileName.length() - this.charsToCut_);
                Hashtable<String, Boolean> isApplicable = new Hashtable<String, Boolean>();
                boolean foundOneStandard = false;
                for (String standardName : standResults.keySet()) {
                    areasForStandard = standResults.get(standardName);
                    if (areasForStandard.containsKey(fileName)) {
                        ResultAreaVO areaVO = areasForStandard.get(fileName);
                        InternalStandardStatistics stat = standStatistics.get(standardName);
                        int isosToTake = i;
                        if (stat.getAmountIsotopesFoundInAll() < isosToTake) {
                            isosToTake = stat.getAmountIsotopesFoundInAll();
                        }
                        float comparableArea = (float)this.correctAreaCorrespondingly(areaVO.getTotalArea(isosToTake), moleculeGroup, fileName, isosToTake, correctiveFactors.get(standardName), respectDilution, standMethod, corrStandard);
                        if (stat.getLowerOutlierThreshold() <= comparableArea && comparableArea <= stat.getUpperOutlierThreshold()) {
                            isApplicable.put(standardName, true);
                            foundOneStandard = true;
                            continue;
                        }
                        isApplicable.put(standardName, false);
                        continue;
                    }
                    isApplicable.put(standardName, false);
                }
                if (!foundOneStandard) {
                    inproperForBestComparableProbe.put(fileName, fileName);
                    for (String standardName : standResults.keySet()) {
                        areasForStandard = standResults.get(standardName);
                        if (areasForStandard.containsKey(fileName)) {
                            isApplicable.put(standardName, true);
                            continue;
                        }
                        isApplicable.put(standardName, false);
                    }
                }
                groupApplic.put(fileName, isApplicable);
            }
        }
    }

    private void calculateESReferenceValueForExperiments() {
        this.referenceValuesES_ = new Hashtable();
        this.calculateReferenceValueForExperiments(this.esResults_, this.allESNames_, this.extStandStatistics_, this.correctionFactorsToBestES_, this.applicableStandardsES_, this.extstandsOrderedConcerningReliability_, this.bestExpForExtStandard_, this.referenceValuesES_, true, 0);
        if (this.isISAvailable()) {
            this.referenceValuesESISCorr_ = new Hashtable();
            this.calculateReferenceValueForExperiments(this.esResults_, this.allESNames_, this.extStandStatisticsISCorrected_, this.correctionFactorsToBestESISCorr_, this.applicableStandardsESISCorr_, this.extstandsISCorrOrderedConcerningReliability_, this.bestExpForExtStandardISCorr_, this.referenceValuesESISCorr_, true, 1);
            this.referenceValuesESMedianCorr_ = new Hashtable();
            this.calculateReferenceValueForExperiments(this.esResults_, this.allESNames_, this.extStandStatisticsISMedianCorrected_, this.correctionFactorsToBestESMedianCorr_, this.applicableStandardsESMedianCorr_, this.extstandsMedianCorrOrderedConcerningReliability_, this.bestExpForExtStandardMedianCorr_, this.referenceValuesESMedianCorr_, true, 2);
            this.referenceValuesESSingleCorr_ = new Hashtable();
            for (String molGroupName : this.allResults_.keySet()) {
                Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> referenceValuesESGroup = new Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>>();
                for (String isName : ((Hashtable)this.allISNames_.get(molGroupName)).keySet()) {
                    Hashtable<String, Hashtable<Integer, Double>> refs = new Hashtable<String, Hashtable<Integer, Double>>();
                    if (((Hashtable)this.allESNames_.get(molGroupName)).size() > 0 && this.bestExpForExtStandardSingleCorr_.get(molGroupName) != null && this.bestExpForExtStandardSingleCorr_.get(molGroupName).get(isName) != null) {
                        this.calculateReferenceValueForExperimentsGroup(molGroupName, this.esResults_.get(molGroupName), this.extStandStatisticsISSingleCorrected_.get(molGroupName).get(isName), this.correctionFactorsToBestESSingleCorr_.get(molGroupName).get(isName), this.applicableStandardsESSingleCorr_.get(molGroupName).get(isName), this.extstandsSingleCorrOrderedConcerningReliability_.get(molGroupName).get(isName), this.bestExpForExtStandardSingleCorr_.get(molGroupName).get(isName), refs, true, this.correctionTypeISLookup_.get(molGroupName).get(isName), isName);
                    }
                    referenceValuesESGroup.put(isName, refs);
                }
                this.referenceValuesESSingleCorr_.put(molGroupName, referenceValuesESGroup);
            }
        }
    }

    private void calculateISReferenceValueForExperiments() {
        this.referenceValues_ = new Hashtable();
        this.calculateReferenceValueForExperiments(this.isResults_, this.allISNames_, this.intStandStatistics_, this.correctionFactorsToBestIS_, this.applicableStandards_, this.standardsOrderedConcerningReliability_, this.bestExpForStandard_, this.referenceValues_, false, 0);
    }

    private void calculateReferenceValueForExperiments(Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> standResults, Hashtable<String, Hashtable<String, String>> standNames, Hashtable<String, Hashtable<String, InternalStandardStatistics>> standStatistics, Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactorsGroup, Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>> applicableStandards, Hashtable<String, Vector<String>> standardsOrderedConcerningReliability, Hashtable<String, Hashtable<String, String>> bestExpForStandard, Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> referenceValues, boolean respectDilution, int standMethod) {
        for (String moleculeGroup : applicableStandards.keySet()) {
            if (standNames.get(moleculeGroup).size() <= 0 || bestExpForStandard.get(moleculeGroup) == null) continue;
            Hashtable<String, Hashtable<Integer, Double>> refs = new Hashtable<String, Hashtable<Integer, Double>>();
            this.calculateReferenceValueForExperimentsGroup(moleculeGroup, standResults.get(moleculeGroup), standStatistics.get(moleculeGroup), correctionFactorsGroup.get(moleculeGroup), applicableStandards.get(moleculeGroup), standardsOrderedConcerningReliability.get(moleculeGroup), bestExpForStandard.get(moleculeGroup), refs, respectDilution, standMethod, null);
            referenceValues.put(moleculeGroup, refs);
        }
    }

    private void calculateReferenceValueForExperimentsGroup(String moleculeGroup, Hashtable<String, Hashtable<String, ResultAreaVO>> standResults, Hashtable<String, InternalStandardStatistics> standStatistics, Hashtable<String, Hashtable<String, Double>> correctionFactors, Hashtable<String, Hashtable<String, Boolean>> standsForGroup, Vector<String> standardsOrderedConcerningReliability, Hashtable<String, String> bestExpForStandard, Hashtable<String, Hashtable<Integer, Double>> refs, boolean respectDilution, int standMethod, String corrStandard) {
        if (standardsOrderedConcerningReliability.size() > 0) {
            String mostReliableStandard = standardsOrderedConcerningReliability.get(0);
            String expEverythingHasToBeComparedTo = bestExpForStandard.get(mostReliableStandard);
            InternalStandardStatistics stat = standStatistics.get(mostReliableStandard);
            for (int iso = 1; iso != this.maxIsotopesOfGroup_.get(moleculeGroup) + 1; ++iso) {
                int isoToUse = iso;
                if (iso > stat.getAmountIsotopesFoundInAll()) {
                    isoToUse = stat.getAmountIsotopesFoundInAll();
                }
                double refValue = (float)this.correctAreaCorrespondingly(standResults.get(mostReliableStandard).get(expEverythingHasToBeComparedTo).getTotalArea(isoToUse), moleculeGroup, expEverythingHasToBeComparedTo, isoToUse, correctionFactors.get(mostReliableStandard), respectDilution, standMethod, corrStandard);
                if (iso > stat.getAmountIsotopesFoundInAll()) {
                    refValue = this.correctAreaCorrespondingly(standResults.get(mostReliableStandard).get(expEverythingHasToBeComparedTo).getTheoreticalIsotopeValue(this.elementParser_, iso), moleculeGroup, expEverythingHasToBeComparedTo, 1, correctionFactors.get(mostReliableStandard), respectDilution, standMethod, corrStandard);
                }
                for (String expName : standsForGroup.keySet()) {
                    Hashtable<Object, Object> isoValues = new Hashtable();
                    if (refs.containsKey(expName)) {
                        isoValues = refs.get(expName);
                    }
                    String partner = null;
                    for (int i = 0; i != standardsOrderedConcerningReliability.size(); ++i) {
                        String standard;
                        String expToCompareTo;
                        if (partner != null || !this.doesPartnerFit(expName, expToCompareTo = bestExpForStandard.get(standard = standardsOrderedConcerningReliability.get(i)), standsForGroup) || !this.doesPartnerFit(expToCompareTo, expEverythingHasToBeComparedTo, standsForGroup)) continue;
                        partner = expToCompareTo;
                        break;
                    }
                    double refToPut = Double.NaN;
                    if (partner == null) {
                        System.out.println("!!!!!!!!!!!!!!!!!!!! The experiment " + expName + " cannot be compared to anything !!!!!!!!!!");
                        refToPut = Double.NaN;
                    } else if (expName.equalsIgnoreCase(expEverythingHasToBeComparedTo)) {
                        refToPut = refValue;
                    } else if (partner.equalsIgnoreCase(expEverythingHasToBeComparedTo)) {
                        refToPut = refValue * this.getRelativeValue(standResults, expName, partner, moleculeGroup, iso, correctionFactors, standsForGroup, respectDilution, standMethod, corrStandard);
                    } else {
                        double relativePartnerToExpEverythingHasToBeComparedTo = this.getRelativeValue(standResults, partner, expEverythingHasToBeComparedTo, moleculeGroup, isoToUse, correctionFactors, standsForGroup, respectDilution, standMethod, corrStandard);
                        refToPut = refValue * this.getRelativeValue(standResults, expName, partner, moleculeGroup, iso, correctionFactors, standsForGroup, respectDilution, standMethod, corrStandard) * relativePartnerToExpEverythingHasToBeComparedTo;
                    }
                    isoValues.put(iso - 1, refToPut);
                    refs.put(expName, isoValues);
                }
            }
        }
    }

    private double getRelativeValue(Hashtable<String, Hashtable<String, ResultAreaVO>> standResults, String exp, String partner, String moleculeGroup, int isotopes, Hashtable<String, Hashtable<String, Double>> correctionFactors, Hashtable<String, Hashtable<String, Boolean>> standsForGroup, boolean respectDilution, int standMethod, String corrStandard) {
        Vector<Float> ratioOfIs = new Vector<Float>();
        for (String isName : standsForGroup.get(exp).keySet()) {
            if (!standsForGroup.get(exp).get(isName).booleanValue() || !standsForGroup.containsKey(partner) || !standsForGroup.get(partner).get(isName).booleanValue() || standResults.get(isName).get(exp) == null) continue;
            float areaExp = (float)this.correctAreaCorrespondingly(standResults.get(isName).get(exp).getTotalArea(isotopes), moleculeGroup, exp, isotopes, correctionFactors.get(isName), respectDilution, standMethod, corrStandard);
            if (standResults.get(isName).get(partner) == null) continue;
            float areaPartner = (float)this.correctAreaCorrespondingly(standResults.get(isName).get(partner).getTotalArea(isotopes), moleculeGroup, partner, isotopes, correctionFactors.get(isName), respectDilution, standMethod, corrStandard);
            if (!(areaExp > 0.0f) || !(areaPartner > 0.0f)) continue;
            ratioOfIs.add(Float.valueOf(areaExp / areaPartner));
        }
        Float[] medians = ComparativeAnalysis.medianPlusUpperLowerValues(ratioOfIs);
        float[] lowerUpperThreshold = ComparativeAnalysis.getLowerUpperOutlierThresholds(medians, 2.0f);
        double lowerThreshold = lowerUpperThreshold[0];
        double upperThreshold = lowerUpperThreshold[1];
        Vector<Float> ratioOfIs2 = new Vector<Float>();
        for (Float value : ratioOfIs) {
            if (!(lowerThreshold <= (double)value.floatValue()) || !((double)value.floatValue() <= upperThreshold)) continue;
            ratioOfIs2.add(value);
        }
        if (ratioOfIs2.size() > 0) {
            return Calculator.median(ratioOfIs2).floatValue();
        }
        return Double.NaN;
    }

    private boolean doesPartnerFit(String expName, String expEverythingHasToBeComparedTo, Hashtable<String, Hashtable<String, Boolean>> standsForGroup) {
        if (expName.equalsIgnoreCase(expEverythingHasToBeComparedTo)) {
            return true;
        }
        boolean foundCompareInExpEverythingHasToBeComparedTo = false;
        for (String isName : standsForGroup.get(expName).keySet()) {
            if (!standsForGroup.get(expName).get(isName).booleanValue() || !standsForGroup.containsKey(expEverythingHasToBeComparedTo) || !standsForGroup.get(expEverythingHasToBeComparedTo).get(isName).booleanValue()) continue;
            foundCompareInExpEverythingHasToBeComparedTo = true;
        }
        if (foundCompareInExpEverythingHasToBeComparedTo) {
            return true;
        }
        System.out.println("Must look for a different parnter");
        return false;
    }

    private float calculateRatioToMedianOneDir(float value, float mean) {
        float ratio = value / mean;
        if (ratio == 0.0f) {
            return Float.MAX_VALUE;
        }
        if (ratio < 1.0f) {
            ratio = 1.0f / ratio;
        }
        return ratio;
    }

    @Override
    protected void parseResultFile(File resultFile, String fileName, int statisticsViewMode, boolean combineOxWithNonOx) throws ExcelInputFileException, LipidCombinameEncodingException {
        Hashtable<Object, Object> results = new Hashtable();
        Hashtable<String, Boolean> showMods = new Hashtable<String, Boolean>();
        QuantificationResult quantRes = LDAResultReader.readResultFile(resultFile.getAbsolutePath(), showMods);
        if (quantRes.getConstants().getShotgun() == 1 && !(this.expRtGroupingTime_ < 0.0)) {
            this.disableRtGrouping();
        }
        this.resultFileVO_.add(new ResultFileVO(fileName, resultFile, quantRes));
        if (quantRes.getLcbHydroxyEncoding() != null) {
            this.lcbHydroxyEncoding_ = quantRes.getLcbHydroxyEncoding();
        }
        if (quantRes.getFaHydroxyEncoding() != null) {
            this.faHydroxyEncoding_ = quantRes.getFaHydroxyEncoding();
        }
        results = quantRes.getIdentifications();
        Hashtable mSnHash = new Hashtable();
        Hashtable chainHash = new Hashtable();
        if (statisticsViewMode != 0) {
            for (String string : results.keySet()) {
                Vector params = (Vector)results.get(string);
                Vector<LipidParameterSet> vector = new Vector<LipidParameterSet>();
                Vector<LipidParameterSet> chainSets = new Vector<LipidParameterSet>();
                Iterator iterator = params.iterator();
                while (iterator.hasNext()) {
                    LipidParameterSet param = (LipidParameterSet)iterator.next();
                    if (this.isSelectionPrefix_ != null && param.getName().startsWith(this.isSelectionPrefix_) || this.esSelectionPrefix_ != null && param.getName().startsWith(this.esSelectionPrefix_)) {
                        vector.add(param);
                        chainSets.add(param);
                        continue;
                    }
                    if (!(param instanceof LipidomicsMSnSet)) continue;
                    vector.add(param);
                    LipidomicsMSnSet msn_param = (LipidomicsMSnSet)param;
                    if (msn_param.getChainFragments().isEmpty()) continue;
                    chainSets.add(param);
                }
                mSnHash.put(string, vector);
                chainHash.put(string, chainSets);
            }
        }
        if (statisticsViewMode == 1) {
            results = mSnHash;
        }
        if (statisticsViewMode == 2) {
            results = chainHash;
        }
        Hashtable areaSheetVOs = new Hashtable();
        ElementConfigParser elementConfigParser = Settings.getElementParser();
        try {
            if (LipidomicsConstants.isotopicCorrection()) {
                results = IsotopeCorrector.correctIsotopicPattern(this.elementParser_, results);
            }
            for (String string : results.keySet()) {
                if (!this.chainsOfClass_.containsKey(string)) {
                    this.chainsOfClass_.put(string, 0);
                }
                Hashtable<String, Hashtable> areaVOs = new Hashtable<String, Hashtable>();
                Hashtable<Object, Object> modifications = new Hashtable();
                Vector<String> orderedAnalytes = new Vector<String>();
                if (this.modifications_.containsKey(string)) {
                    modifications = this.modifications_.get(string);
                }
                Vector params = (Vector)results.get(string);
                float highestZeroIsoArea = 0.0f;
                String recentModification = null;
                for (LipidParameterSet param : params) {
                    String rtDef = "";
                    String analId = StaticUtils.generateLipidNameString(param.getName(), param.getDoubleBonds(), -1, param.getOxState());
                    boolean isInternalStandard = this.isSelectionPrefix_ != null && param.getName().startsWith(this.isSelectionPrefix_);
                    boolean isExternalStandard = this.esSelectionPrefix_ != null && param.getName().startsWith(this.esSelectionPrefix_);
                    double retentionTime = -1.0;
                    if (param.getRt() != null && param.getRt().length() > 0) {
                        retentionTime = new Double(param.getRt());
                        if (this.expRtGroupingTime_ > 0.0 && !isInternalStandard && !isExternalStandard) {
                            rtDef = param.getRt();
                        }
                    }
                    double neutralMass = param.Mz[0];
                    double massDiffToNeutral = 0.0;
                    Hashtable<String, Integer> elements = StaticUtils.categorizeFormula(param.getModificationFormula());
                    for (String element : elements.keySet()) {
                        massDiffToNeutral += elementConfigParser.getElementDetails(element).getMonoMass() * (double)elements.get(element).intValue();
                    }
                    neutralMass -= massDiffToNeutral;
                    String formula = this.enterSpacesToFormula(param.getAnalyteFormula());
                    ResultAreaVO areaVO = null;
                    if (areaVOs.containsKey(analId) && param.getArea() > 0.0f) {
                        Hashtable sameMoleculeDiffRet = (Hashtable)areaVOs.get(analId);
                        if (sameMoleculeDiffRet.size() == 1 && ((String)sameMoleculeDiffRet.keySet().iterator().next()).equalsIgnoreCase("")) {
                            areaVO = (ResultAreaVO)sameMoleculeDiffRet.values().iterator().next();
                        } else if (rtDef != null && rtDef.length() > 0) {
                            areaVO = this.hasAreaSameRt(rtDef, sameMoleculeDiffRet);
                            if (areaVO == null) {
                                areaVO = new ResultAreaVO(param, rtDef, fileName, formula, neutralMass, isInternalStandard, isExternalStandard);
                            } else {
                                sameMoleculeDiffRet.remove(areaVO.getRt());
                            }
                        }
                    } else if (param.getArea() > 0.0f) {
                        areaVO = new ResultAreaVO(param, rtDef, fileName, formula, neutralMass, isInternalStandard, isExternalStandard);
                        if (orderedAnalytes.size() == 0 || !((String)orderedAnalytes.get(orderedAnalytes.size() - 1)).equalsIgnoreCase(analId)) {
                            orderedAnalytes.add(analId);
                        }
                    } else {
                        Hashtable<Object, Object> fileHash = new Hashtable();
                        if (this.isNullResult_.containsKey(fileName)) {
                            fileHash = this.isNullResult_.get(fileName);
                        }
                        Hashtable sheetHash = new Hashtable();
                        if (fileHash.containsKey(string)) {
                            sheetHash = (Hashtable)fileHash.get(string);
                        }
                        ResultAreaVO dummyVO = new ResultAreaVO(param, rtDef, fileName, formula, neutralMass, isInternalStandard, isExternalStandard);
                        sheetHash.put(dummyVO.getMoleculeName(), true);
                        fileHash.put(string, sheetHash);
                        this.isNullResult_.put(fileName, fileHash);
                    }
                    if (areaVO == null) continue;
                    highestZeroIsoArea = areaVO.getHighestZeroIsoArea(param.getModificationName());
                    recentModification = param.getModificationName();
                    Vector<CgProbe> zeroIsos = param.getIsotopicProbes().get(0);
                    float sumMass = 0.0f;
                    for (CgProbe probe : zeroIsos) {
                        sumMass += probe.Mz;
                    }
                    areaVO.addResultPart(recentModification, param.getModificationFormula(), param.Mz[0], (double)sumMass / (double)zeroIsos.size(), param.getCharge(), param.getRt());
                    Hashtable<Integer, Boolean> moreThanOnePeak = new Hashtable<Integer, Boolean>();
                    modifications.put(recentModification, recentModification);
                    double totalAreaBefore = areaVO.getTotalArea(recentModification);
                    for (Vector<CgProbe> probes : param.getIsotopicProbes()) {
                        int isotope = 0;
                        if (probes.size() > 0) {
                            isotope = probes.get((int)0).isotopeNumber;
                        }
                        for (CgProbe probe : probes) {
                            int iso;
                            Hashtable<Integer, Boolean> mtp = areaVO.addArea(recentModification, isotope, probe.Area);
                            if (mtp != null) {
                                moreThanOnePeak = mtp;
                            }
                            if (isotope == 0 && probe.Area > highestZeroIsoArea) {
                                retentionTime = probe.Peak / 60.0f;
                                highestZeroIsoArea = probe.Area;
                                areaVO.setRt(rtDef);
                            }
                            if ((iso = isotope) < 0) {
                                iso *= -1;
                            }
                            if (moreThanOnePeak.containsKey(iso)) {
                                moreThanOnePeak.put(iso, true);
                                continue;
                            }
                            moreThanOnePeak.put(iso, false);
                        }
                    }
                    areaVO.addMolecularSpeciesContribution(recentModification, totalAreaBefore, param);
                    areaVO.addLipidParameterSet(param);
                    areaVO.setRetentionTime(recentModification, retentionTime);
                    areaVO.setMoreThanOnePeak(recentModification, moreThanOnePeak);
                    Hashtable sameMoleculeDiffRet = new Hashtable();
                    if (areaVOs.containsKey(areaVO.getMoleculeNameWoRT())) {
                        sameMoleculeDiffRet = (Hashtable)areaVOs.get(areaVO.getMoleculeNameWoRT());
                    }
                    sameMoleculeDiffRet.put(areaVO.getRt(), areaVO);
                    areaVOs.put(areaVO.getMoleculeNameWoRT(), sameMoleculeDiffRet);
                }
                this.modifications_.put(string, modifications);
                Vector inCorrectOrder = new Vector();
                for (String analyte : orderedAnalytes) {
                    inCorrectOrder.add(areaVOs.get(analyte));
                }
                areaSheetVOs.put(string, inCorrectOrder);
            }
        }
        catch (ChemicalFormulaException cfx) {
            cfx.printStackTrace();
            throw new ExcelInputFileException(cfx);
        }
        catch (SpectrummillParserException spx) {
            throw new ExcelInputFileException(spx);
        }
        this.unprocessedResults_.put(fileName, areaSheetVOs);
    }

    @Override
    protected void buildResultHashes() {
        if (this.expRtGroupingTime_ > 0.0) {
            Hashtable<String, Hashtable> groupAndMols = new Hashtable<String, Hashtable>();
            Vector<String> fileNames = new Vector<String>();
            Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>>> resultsInHash = new Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>>>();
            for (String fileName : this.unprocessedResults_.keySet()) {
                fileNames.add(fileName);
                Hashtable<String, Vector<Hashtable<String, ResultAreaVO>>> fileResult = this.unprocessedResults_.get(fileName);
                Hashtable fileResultInHash = new Hashtable();
                for (String groupName : fileResult.keySet()) {
                    Vector mols = (Vector)fileResult.get(groupName);
                    Hashtable molNames = new Hashtable();
                    Hashtable<String, Hashtable> molsInHash = new Hashtable<String, Hashtable>();
                    if (groupAndMols.containsKey(groupName)) {
                        molNames = (Hashtable)groupAndMols.get(groupName);
                    }
                    for (Hashtable diffTime : mols) {
                        if (diffTime.size() <= 0) continue;
                        String name = ((ResultAreaVO)diffTime.values().iterator().next()).getMoleculeNameWoRT();
                        molNames.put(name, name);
                        molsInHash.put(name, diffTime);
                    }
                    fileResultInHash.put(groupName, molsInHash);
                    groupAndMols.put(groupName, molNames);
                }
                resultsInHash.put(fileName, fileResultInHash);
            }
            for (String groupName : groupAndMols.keySet()) {
                for (String molName : ((Hashtable)groupAndMols.get(groupName)).keySet()) {
                    if (this.isSelectionPrefix_ != null && molName.startsWith(this.isSelectionPrefix_) || this.esSelectionPrefix_ != null && molName.startsWith(this.esSelectionPrefix_)) continue;
                    int clusterId = 0;
                    Hashtable<Integer, Hashtable<String, Hashtable<String, ResultAreaVO>>> valuesInClusters = new Hashtable<Integer, Hashtable<String, Hashtable<String, ResultAreaVO>>>();
                    Hashtable<String, Set<String>> usedRts = new Hashtable<String, Set<String>>();
                    Hashtable<Integer, Double> rtClusters = new Hashtable<Integer, Double>();
                    while (this.areThereHitsOutsideClusterRange(groupName, molName, fileNames, rtClusters, usedRts, resultsInHash)) {
                        String[] fileNameAndRt = this.findStrongestHitOutsideExistingClusters(groupName, molName, fileNames, rtClusters, usedRts, resultsInHash);
                        String fileName = fileNameAndRt[0];
                        String rt = fileNameAndRt[1];
                        this.addClosestPeaksToCluster(clusterId, fileName, groupName, molName, rt, fileNames, usedRts, valuesInClusters, resultsInHash);
                        this.addAreaWeightedMeanRt(rtClusters, clusterId, valuesInClusters.get(clusterId));
                        ++clusterId;
                    }
                    this.addRemainingPeaksToClosestClusters(rtClusters, valuesInClusters, usedRts, resultsInHash, groupName, molName, fileNames);
                    rtClusters = new Hashtable();
                    for (int cluster : valuesInClusters.keySet()) {
                        this.addAreaWeightedMeanRt(rtClusters, cluster, valuesInClusters.get(cluster));
                    }
                    while (this.clusterOverlap(rtClusters)) {
                        int[] overlapIds = this.detectClosestOverlap(rtClusters);
                        this.uniteTwoClusters(overlapIds[0], overlapIds[1], valuesInClusters);
                        rtClusters = new Hashtable();
                        for (int cluster : valuesInClusters.keySet()) {
                            this.addAreaWeightedMeanRt(rtClusters, cluster, valuesInClusters.get(cluster));
                        }
                    }
                    for (int i = 0; i != valuesInClusters.size(); ++i) {
                        Hashtable<String, Hashtable<String, ResultAreaVO>> cluster = valuesInClusters.get(i);
                        String newRt = Calculator.FormatNumberToString(rtClusters.get(i), 2.0);
                        for (String fileName : fileNames) {
                            if (!cluster.containsKey(fileName)) continue;
                            Hashtable<String, ResultAreaVO> clusterOfFile = cluster.get(fileName);
                            ResultAreaVO highestArea = null;
                            for (ResultAreaVO vo : clusterOfFile.values()) {
                                if (highestArea != null && !(vo.getTotalArea(Integer.MAX_VALUE) > highestArea.getTotalArea(Integer.MAX_VALUE))) continue;
                                highestArea = vo;
                            }
                            for (ResultAreaVO vo : clusterOfFile.values()) {
                                if (highestArea.getRt().equalsIgnoreCase(vo.getRt())) continue;
                                Vector<Hashtable<String, ResultAreaVO>> resInSequence = this.unprocessedResults_.get(vo.getExpName()).get(groupName);
                                for (int j = 0; j != resInSequence.size(); ++j) {
                                    ResultAreaVO oneVO = resInSequence.get(j).values().iterator().next();
                                    if (!oneVO.getMoleculeNameWoRT().equalsIgnoreCase(vo.getMoleculeNameWoRT())) continue;
                                    resInSequence.get(j).remove(vo.getRt());
                                    break;
                                }
                                highestArea.combineVOs(vo);
                            }
                            highestArea.setRt(newRt);
                        }
                    }
                }
            }
        }
        for (String fileName : this.unprocessedResults_.keySet()) {
            Hashtable<String, Vector<Hashtable<String, ResultAreaVO>>> areaSheetVOs = this.unprocessedResults_.get(fileName);
            for (String sheetName : areaSheetVOs.keySet()) {
                Vector<Hashtable<String, ResultAreaVO>> molecules = areaSheetVOs.get(sheetName);
                Hashtable<String, ResultAreaVO> molHash = new Hashtable<String, ResultAreaVO>();
                Hashtable<Object, Object> resultsMoleculeGroup = new Hashtable();
                Hashtable<Object, Object> resultsMoleculeGroupHash = new Hashtable();
                if (this.allResults_.containsKey(sheetName)) {
                    resultsMoleculeGroup = this.allResults_.get(sheetName);
                    resultsMoleculeGroupHash = this.allResultsHash_.get(sheetName);
                }
                Vector<ResultAreaVO> resMols = new Vector<ResultAreaVO>();
                for (Hashtable<String, ResultAreaVO> mol : molecules) {
                    Vector<DoubleStringVO> forSort = new Vector<DoubleStringVO>();
                    if (this.expRtGroupingTime_ > 0.0 && !mol.keySet().iterator().next().equalsIgnoreCase("")) {
                        for (String rt : mol.keySet()) {
                            forSort.add(new DoubleStringVO(rt, new Double(rt)));
                        }
                        Collections.sort(forSort, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
                        for (DoubleStringVO key : forSort) {
                            ResultAreaVO vo = mol.get(key.getKey());
                            molHash.put(vo.getMoleculeName(), vo);
                            resMols.add(vo);
                        }
                        continue;
                    }
                    ResultAreaVO vo = mol.get(mol.keySet().iterator().next());
                    molHash.put(vo.getMoleculeName(), vo);
                    resMols.add(vo);
                }
                resultsMoleculeGroup.put(fileName, resMols);
                resultsMoleculeGroupHash.put(fileName, molHash);
                this.allResults_.put(sheetName, resultsMoleculeGroup);
                this.allResultsHash_.put(sheetName, resultsMoleculeGroupHash);
            }
        }
        this.unprocessedResults_ = null;
        if (this.classCutoffs_ != null) {
            this.filterOutSmallIntensities();
        }
    }

    private void filterOutSmallIntensities() {
        for (String lipidClass : this.classCutoffs_.keySet()) {
            double cutoff = this.classCutoffs_.get(lipidClass);
            if (!(cutoff > 0.0)) continue;
            Hashtable<String, Vector<ResultAreaVO>> oneClass = this.allResults_.get(lipidClass);
            Hashtable<String, Hashtable<String, ResultAreaVO>> oneClassHash = this.allResultsHash_.get(lipidClass);
            Vector<Hashtable> results = this.calculateCutoffAreas(cutoff, oneClass);
            Hashtable cutoffAreas = results.get(0);
            Hashtable moleculeNames = results.get(1);
            Hashtable<String, String> moleculesToRemove = this.findMoleculesBelowCutoff(oneClassHash, moleculeNames, cutoffAreas);
            for (String expName : oneClass.keySet()) {
                Vector<ResultAreaVO> areasFiltered = new Vector<ResultAreaVO>();
                for (ResultAreaVO vo : oneClass.get(expName)) {
                    if (moleculesToRemove.containsKey(vo.getMoleculeName())) continue;
                    areasFiltered.add(vo);
                }
                oneClass.put(expName, areasFiltered);
            }
            this.allResults_.put(lipidClass, oneClass);
            for (String expName : oneClassHash.keySet()) {
                Hashtable<String, ResultAreaVO> areaHash = oneClassHash.get(expName);
                for (String molecule : moleculesToRemove.keySet()) {
                    if (!areaHash.containsKey(molecule)) continue;
                    areaHash.remove(molecule);
                }
                oneClassHash.put(expName, areaHash);
            }
            this.allResultsHash_.put(lipidClass, oneClassHash);
        }
    }

    private Vector<Hashtable> calculateCutoffAreas(double cutoff, Hashtable<String, Vector<ResultAreaVO>> areas) {
        Hashtable<String, Double> cutoffAreas = new Hashtable<String, Double>();
        Hashtable<String, String> moleculeNames = new Hashtable<String, String>();
        for (String expName : areas.keySet()) {
            Vector<ResultAreaVO> areasOfExp = areas.get(expName);
            double highestIntensity = 0.0;
            for (ResultAreaVO area : areasOfExp) {
                if (this.isSelectionPrefix_ != null && area.getMoleculeName().startsWith(this.isSelectionPrefix_) || this.esSelectionPrefix_ != null && area.getMoleculeName().startsWith(this.esSelectionPrefix_)) continue;
                moleculeNames.put(area.getMoleculeName(), area.getMoleculeName());
                double areaValue = area.getTotalArea(this.maxCutoffIsotope_ + 1);
                if (!(areaValue > highestIntensity)) continue;
                highestIntensity = areaValue;
            }
            cutoffAreas.put(expName, highestIntensity * cutoff);
        }
        Vector<Hashtable> results = new Vector<Hashtable>();
        results.add(cutoffAreas);
        results.add(moleculeNames);
        return results;
    }

    private Hashtable<String, String> findMoleculesBelowCutoff(Hashtable<String, Hashtable<String, ResultAreaVO>> oneClassHash, Hashtable<String, String> moleculeNames, Hashtable<String, Double> cutoffAreas) {
        Hashtable<String, String> belowCutoff = new Hashtable<String, String>();
        for (String molName : moleculeNames.keySet()) {
            boolean oneAboveThreshold = false;
            for (String expName : oneClassHash.keySet()) {
                ResultAreaVO areaVO;
                if (!oneClassHash.get(expName).containsKey(molName) || !((areaVO = oneClassHash.get(expName).get(molName)).getTotalArea(this.maxCutoffIsotope_ + 1) > cutoffAreas.get(expName))) continue;
                oneAboveThreshold = true;
                break;
            }
            if (oneAboveThreshold) continue;
            belowCutoff.put(molName, molName);
        }
        return belowCutoff;
    }

    private ResultAreaVO hasAreaSameRt(String rtDef, Hashtable<String, ResultAreaVO> sameMoleculeDiffRet) {
        ResultAreaVO found = null;
        if (rtDef == null || rtDef.length() < 1) {
            return found;
        }
        for (String refRt : sameMoleculeDiffRet.keySet()) {
            if (!rtDef.equalsIgnoreCase(refRt)) continue;
            return sameMoleculeDiffRet.get(refRt);
        }
        return found;
    }

    public boolean isWithinRtGroupingBoundaries(double rt, double refTime) {
        return StaticUtils.isWithinTolerance(this.expRtGroupingTime_, refTime, rt);
    }

    private String enterSpacesToFormula(String chemicalFormula) {
        String finalFormula = "";
        char[] chars = chemicalFormula.toCharArray();
        boolean previousNumber = false;
        for (char oneChar : chars) {
            if (Character.isLetter(oneChar) && previousNumber) {
                finalFormula = finalFormula + " ";
            }
            previousNumber = Character.isDigit(oneChar);
            finalFormula = finalFormula + String.valueOf(oneChar);
        }
        return finalFormula;
    }

    public static String removeChemicalFormula(String name) {
        if (name != null && name.contains("_")) {
            return name.substring(0, name.lastIndexOf("_"));
        }
        if (name != null && name.contains(":")) {
            char[] nameChars = name.toCharArray();
            int idx = name.lastIndexOf(":") + 1;
            String returnName = name.substring(0, idx);
            for (int i = idx; i != nameChars.length && Character.isDigit(nameChars[i]); ++i) {
                returnName = returnName + String.valueOf(nameChars[i]);
            }
            return returnName;
        }
        return name;
    }

    private static float[] getLowerUpperOutlierThresholds(Float[] medians, float tolerance) {
        float[] thresholds = new float[2];
        float multFactor = medians[0].floatValue() / medians[1].floatValue();
        thresholds[0] = medians[0].floatValue() / (tolerance * multFactor);
        multFactor = medians[2].floatValue() / medians[0].floatValue();
        thresholds[1] = medians[0].floatValue() * multFactor * tolerance;
        return thresholds;
    }

    private static Float[] medianPlusUpperLowerValues(Vector<Float> values) {
        Float upperSectionMedian;
        Float lowerSectionMedian;
        Float median;
        Collections.sort(values);
        Float[] medians = new Float[3];
        if (values.size() > 0) {
            median = values.size() % 2 == 0 ? new Float((values.get(values.size() / 2 - 1).floatValue() + values.get(values.size() / 2).floatValue()) / 2.0f) : new Float(values.get((values.size() + 1) / 2 - 1).floatValue());
            int position = values.size() / 4;
            lowerSectionMedian = position == 0 ? (values.size() > 1 ? new Float((values.get(position).floatValue() + values.get(position + 1).floatValue()) / 2.0f) : new Float(values.get(position).floatValue())) : new Float((values.get(position - 1).floatValue() + values.get(position).floatValue()) / 2.0f);
            position = 3 * values.size() / 4;
            upperSectionMedian = values.size() > 1 ? new Float((values.get(position - 1).floatValue() + values.get(position).floatValue()) / 2.0f) : new Float(values.get(position).floatValue());
        } else {
            median = new Float(0.0f);
            lowerSectionMedian = new Float(0.0f);
            upperSectionMedian = new Float(0.0f);
        }
        medians[0] = median;
        medians[1] = lowerSectionMedian;
        medians[2] = upperSectionMedian;
        return medians;
    }

    private void calculateRelativeComparisonValues() throws LipidCombinameEncodingException {
        this.allMoleculeNames_ = new Hashtable();
        Hashtable<String, Iterator<String>> comparativeAreas = new Hashtable<String, Iterator<String>>();
        Hashtable comparativeMaxIsotopes_ = new Hashtable();
        Hashtable moleculeMassHash = new Hashtable();
        for (String groupName : this.allResults_.keySet()) {
            Vector<String> moleculeNames = new Vector<String>();
            Hashtable<String, Hashtable> moleculeMassHashGroup = new Hashtable<String, Hashtable>();
            Hashtable<String, Vector<ResultAreaVO>> oneGroupResults = this.allResults_.get(groupName);
            Iterator<String> comparativeAreasOneGroup = new Hashtable();
            Hashtable<String, Integer> maxIsotopes = new Hashtable<String, Integer>();
            boolean foundPreviousForOrder = true;
            for (String expName : this.expNamesInSequence_) {
                if (oneGroupResults.containsKey(expName)) {
                    Vector<ResultAreaVO> resVOs = oneGroupResults.get(expName);
                    for (int i = 0; i != resVOs.size(); ++i) {
                        int resIsotopes;
                        ResultAreaVO resVO = resVOs.get(i);
                        Hashtable masses = new Hashtable();
                        if (!moleculeMassHashGroup.containsKey(resVO.getMoleculeName())) {
                            if (moleculeNames.size() == 0) {
                                moleculeNames.add(resVO.getMoleculeName());
                            } else if (i > 0) {
                                int position = this.findPositionOfItem(resVOs.get(i - 1).getMoleculeName(), moleculeNames);
                                if (position == -1) {
                                    moleculeNames.add(resVO.getMoleculeName());
                                } else {
                                    moleculeNames.add(position + 1, resVO.getMoleculeName());
                                }
                            } else if (i + 1 < resVOs.size()) {
                                int position = this.findPositionOfItem(resVOs.get(i + 1).getMoleculeName(), moleculeNames);
                                if (position == -1) {
                                    foundPreviousForOrder = false;
                                    moleculeNames.add(resVO.getMoleculeName());
                                } else {
                                    moleculeNames.add(position, resVO.getMoleculeName());
                                }
                            } else {
                                moleculeNames.add(resVO.getMoleculeName());
                            }
                        } else {
                            masses = (Hashtable)moleculeMassHashGroup.get(resVO.getMoleculeName());
                        }
                        masses.put(expName, resVO.getWeightedNeutralMass());
                        moleculeMassHashGroup.put(resVO.getMoleculeName(), masses);
                        Hashtable resOfOneMolecule = new Hashtable();
                        int isotopes = 1000;
                        if (((Hashtable)((Object)comparativeAreasOneGroup)).containsKey(resVO.getMoleculeName())) {
                            resOfOneMolecule = (Hashtable)((Hashtable)((Object)comparativeAreasOneGroup)).get(resVO.getMoleculeName());
                            isotopes = (Integer)maxIsotopes.get(resVO.getMoleculeName());
                        }
                        if ((resIsotopes = resVO.getMaxIsotope()) > 0 && resVO.getMaxIsotope() < isotopes) {
                            isotopes = resVO.getMaxIsotope();
                        }
                        resOfOneMolecule.put(expName, resVO);
                        ((Hashtable)((Object)comparativeAreasOneGroup)).put(resVO.getMoleculeName(), resOfOneMolecule);
                        maxIsotopes.put(resVO.getMoleculeName(), isotopes);
                    }
                }
                moleculeMassHash.put(groupName, moleculeMassHashGroup);
            }
            if (this.correctAnalyteSequence_ == null) {
                if (!foundPreviousForOrder) {
                    Iterator molNameList = new ArrayList<String>(moleculeNames);
                    Collections.sort(molNameList);
                    moleculeNames = new Vector<String>((Collection<String>)((Object)molNameList));
                }
                moleculeNames = this.sortLipidNames(moleculeNames);
            }
            this.allMoleculeNames_.put(groupName, moleculeNames);
            comparativeAreas.put(groupName, comparativeAreasOneGroup);
            comparativeMaxIsotopes_.put(groupName, maxIsotopes);
        }
        if (this.correctAnalyteSequence_ != null) {
            for (String groupName : this.correctAnalyteSequence_.keySet()) {
                Vector<String> analytesInSequence = this.correctAnalyteSequence_.get(groupName);
                if (!this.allMoleculeNames_.containsKey(groupName)) continue;
                Vector<String> unorderedSequence = this.allMoleculeNames_.get(groupName);
                Vector<String> correctOrder = new Vector<String>();
                for (String anal : analytesInSequence) {
                    Vector<DoubleStringVO> sameRt = new Vector<DoubleStringVO>();
                    for (String isThereAnal : unorderedSequence) {
                        if (this.expRtGroupingTime_ > 0.0 && !isThereAnal.startsWith(this.isSelectionPrefix_) && !isThereAnal.startsWith(this.esSelectionPrefix_)) {
                            if (!isThereAnal.startsWith(anal) || isThereAnal.toCharArray()[anal.length()] != '_') continue;
                            try {
                                String rtString = isThereAnal.substring(anal.length() + 1);
                                double rt = Double.parseDouble(rtString);
                                sameRt.add(new DoubleStringVO(rtString, rt));
                            }
                            catch (NumberFormatException rtString) {}
                            continue;
                        }
                        if (!anal.equalsIgnoreCase(isThereAnal)) continue;
                        correctOrder.add(anal);
                        break;
                    }
                    if (!(this.expRtGroupingTime_ > 0.0)) continue;
                    Collections.sort(sameRt, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
                    for (DoubleStringVO rt : sameRt) {
                        correctOrder.add(anal + "_" + rt.getKey());
                    }
                }
                for (String isThereAnal : unorderedSequence) {
                    boolean found = false;
                    for (String anal : correctOrder) {
                        if (!anal.equalsIgnoreCase(isThereAnal)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    System.out.println("Warning: The molecule " + isThereAnal + " is not in the Quant file! Putting it to the end!!!");
                    correctOrder.add(isThereAnal);
                }
                this.allMoleculeNames_.put(groupName, correctOrder);
            }
        }
        this.comparativeRatios_ = new Hashtable();
        for (String groupName : this.allResults_.keySet()) {
            Hashtable comparativeAreasOneGroup = (Hashtable)comparativeAreas.get(groupName);
            Hashtable isos = (Hashtable)comparativeMaxIsotopes_.get(groupName);
            Vector<String> moleculeNames = this.allMoleculeNames_.get(groupName);
            Hashtable compForOneGroup = new Hashtable();
            String mostReliableStandard = null;
            String bestExp = null;
            ResultAreaVO areaOfBestStandard = null;
            String mostReliableExtStandardNoCorr = null;
            String bestExpESNoCorr = null;
            ResultAreaVO areaOfBestStandardESNoCorr = null;
            String mostReliableExtStandardInternalCorr = null;
            String bestExpESInternalCorr = null;
            ResultAreaVO areaOfBestStandardESInternalCorr = null;
            String mostReliableExtStandardMedianCorr = null;
            String bestExpESMedianCorr = null;
            ResultAreaVO areaOfBestStandardESMedianCorr = null;
            Hashtable<String, String> mostReliableExtStandardSingleCorr = new Hashtable<String, String>();
            Hashtable<String, String> bestExpESSingleCorr = new Hashtable<String, String>();
            Hashtable<String, ResultAreaVO> areaOfBestStandardESSingleCorr = new Hashtable<String, ResultAreaVO>();
            if (((Hashtable)this.allISNames_.get(groupName)).size() > 0) {
                mostReliableStandard = this.standardsOrderedConcerningReliability_.get(groupName).get(0);
                bestExp = this.bestExpForStandard_.get(groupName).get(mostReliableStandard);
                areaOfBestStandard = this.isResults_.get(groupName).get(mostReliableStandard).get(bestExp);
            }
            if (((Hashtable)this.allESNames_.get(groupName)).size() > 0) {
                mostReliableExtStandardNoCorr = this.extstandsOrderedConcerningReliability_.get(groupName).get(0);
                bestExpESNoCorr = this.bestExpForExtStandard_.get(groupName).get(mostReliableExtStandardNoCorr);
                areaOfBestStandardESNoCorr = this.esResults_.get(groupName).get(mostReliableExtStandardNoCorr).get(bestExpESNoCorr);
                if (this.isISAvailable() && this.bestExpForExtStandardISCorr_.get(groupName) != null) {
                    mostReliableExtStandardInternalCorr = this.extstandsISCorrOrderedConcerningReliability_.get(groupName).get(0);
                    bestExpESInternalCorr = this.bestExpForExtStandardISCorr_.get(groupName).get(mostReliableExtStandardInternalCorr);
                    areaOfBestStandardESInternalCorr = this.esResults_.get(groupName).get(mostReliableExtStandardInternalCorr).get(bestExpESInternalCorr);
                    mostReliableExtStandardMedianCorr = this.extstandsMedianCorrOrderedConcerningReliability_.get(groupName).get(0);
                    bestExpESMedianCorr = this.bestExpForExtStandardMedianCorr_.get(groupName).get(mostReliableExtStandardMedianCorr);
                    areaOfBestStandardESMedianCorr = this.esResults_.get(groupName).get(mostReliableExtStandardMedianCorr).get(bestExpESMedianCorr);
                    for (String isName : ((Hashtable)this.allISNames_.get(groupName)).keySet()) {
                        String mostReliable = this.extstandsSingleCorrOrderedConcerningReliability_.get(groupName).get(isName).get(0);
                        if (this.bestExpForExtStandardSingleCorr_.get(groupName).get(isName) == null) continue;
                        String bestExpSingle = this.bestExpForExtStandardSingleCorr_.get(groupName).get(isName).get(mostReliable);
                        ResultAreaVO areaOfBestSingle = this.esResults_.get(groupName).get(mostReliable).get(bestExpSingle);
                        mostReliableExtStandardSingleCorr.put(isName, mostReliable);
                        bestExpESSingleCorr.put(isName, bestExpSingle);
                        areaOfBestStandardESSingleCorr.put(isName, areaOfBestSingle);
                    }
                }
            }
            for (String molecule : moleculeNames) {
                Hashtable<String, ResultCompVO> relativeValues = new Hashtable<String, ResultCompVO>();
                int isoNr = 0;
                Double esVolumeInternalCorr = null;
                Double esConcentrationInternalCorr = null;
                Double esVolumeMedianCorr = null;
                Double esConcentrationMedianCorr = null;
                Hashtable moleculeMasses = new Hashtable();
                if (((Hashtable)moleculeMassHash.get(groupName)).containsKey(molecule)) {
                    moleculeMasses = (Hashtable)((Hashtable)moleculeMassHash.get(groupName)).get(molecule);
                }
                Hashtable<Integer, Double> esVolumeSingleCorr = new Hashtable<Integer, Double>();
                Hashtable<Integer, Double> esConcentrationSingleCorr = new Hashtable<Integer, Double>();
                Double dilutionFactor = 1.0;
                if (this.absSetting_ != null && ((Hashtable)this.allESNames_.get(groupName)).size() > 0) {
                    Hashtable<String, Hashtable<String, VolumeConcVO>> concVOs = this.absSetting_.getClassSettings().get(groupName).getEsStandards();
                    if (this.isISAvailable()) {
                        esVolumeInternalCorr = concVOs.get(mostReliableExtStandardInternalCorr).get(bestExpESInternalCorr).getVolume();
                        esConcentrationInternalCorr = concVOs.get(mostReliableExtStandardInternalCorr).get(bestExpESInternalCorr).getConcentration();
                        esVolumeMedianCorr = concVOs.get(mostReliableExtStandardMedianCorr).get(bestExpESMedianCorr).getVolume();
                        esConcentrationMedianCorr = concVOs.get(mostReliableExtStandardMedianCorr).get(bestExpESMedianCorr).getConcentration();
                        for (String isName : ((Hashtable)this.allISNames_.get(groupName)).keySet()) {
                            int isType = this.correctionTypeISLookup_.get(groupName).get(isName);
                            esVolumeSingleCorr.put(isType, concVOs.get(mostReliableExtStandardSingleCorr.get(isName)).get(bestExpESSingleCorr.get(isName)).getVolume());
                            esConcentrationSingleCorr.put(isType, concVOs.get(mostReliableExtStandardSingleCorr.get(isName)).get(bestExpESSingleCorr.get(isName)).getConcentration());
                        }
                    }
                }
                int resultType = 0;
                if (((Hashtable)this.allISNames_.get(groupName)).size() > 0 && ((Hashtable)this.allISNames_.get(groupName)).containsKey(molecule)) {
                    resultType = 1;
                } else if (((Hashtable)this.allESNames_.get(groupName)).size() > 0 && ((Hashtable)this.allESNames_.get(groupName)).containsKey(molecule)) {
                    resultType = 2;
                }
                if (comparativeAreasOneGroup.containsKey(molecule)) {
                    isoNr = (Integer)isos.get(molecule);
                    Hashtable resultsMolecule = (Hashtable)comparativeAreasOneGroup.get(molecule);
                    Hashtable originalAreasHash = new Hashtable();
                    Hashtable moreThanOnePeakHash = new Hashtable();
                    Hashtable correctionInternalISHash = new Hashtable();
                    Hashtable correctionMedianISHash = new Hashtable();
                    Hashtable bestISAreasHash = new Hashtable();
                    Hashtable medianAreasHash = new Hashtable();
                    Hashtable correctionInternalESNoISCorrHash = new Hashtable();
                    Hashtable bestESAreasNoISCorrHash = new Hashtable();
                    Hashtable correctionMedianESNoISCorrHash = new Hashtable();
                    Hashtable medianAreasESNoISCorrHash = new Hashtable();
                    Hashtable correctionInternalESISInternalCorrHash = new Hashtable();
                    Hashtable bestESAreasISInternalCorrHash = new Hashtable();
                    Hashtable correctionMedianESISInternalCorrHash = new Hashtable();
                    Hashtable medianAreasESISInternalCorrHash = new Hashtable();
                    Hashtable correctionInternalESISMedianCorrHash = new Hashtable();
                    Hashtable bestESAreasISMedianCorrHash = new Hashtable();
                    Hashtable correctionMedianESISMedianCorrHash = new Hashtable();
                    Hashtable medianAreasESISMedianCorrHash = new Hashtable();
                    Hashtable correctionInternalESISSingleCorrHash = new Hashtable();
                    Hashtable bestESAreasISSingleCorrHash = new Hashtable();
                    Hashtable correctionMedianESISSingleCorrHash = new Hashtable();
                    Hashtable medianAreasESISSingleCorrHash = new Hashtable();
                    Hashtable retentionTimes = new Hashtable();
                    Hashtable<String, Boolean> modsFound = new Hashtable<String, Boolean>();
                    for (String expName : this.expNamesInSequence_) {
                        Vector<Double> originalAreas = new Vector<Double>();
                        Vector moreThanOnePeak = new Vector();
                        Vector<Double> correctionInternalIS = new Vector<Double>();
                        Vector<Double> bestISAreas = new Vector<Double>();
                        Vector<Double> correctionMedianIS = new Vector<Double>();
                        Vector<Double> medianAreas = new Vector<Double>();
                        Vector<Double> correctionInternalESNoISCorr = new Vector<Double>();
                        Vector<Double> bestESAreasNoISCorr = new Vector<Double>();
                        Vector<Double> correctionMedianESNoISCorr = new Vector<Double>();
                        Vector<Double> medianAreasESNoISCorr = new Vector<Double>();
                        Vector<Double> correctionInternalESISInternalCorr = new Vector<Double>();
                        Vector<Double> bestESAreasISInternalCorr = new Vector<Double>();
                        Vector<Double> correctionMedianESISInternalCorr = new Vector<Double>();
                        Vector<Double> medianAreasESISInternalCorr = new Vector<Double>();
                        Vector<Double> correctionInternalESISMedianCorr = new Vector<Double>();
                        Vector<Double> bestESAreasISMedianCorr = new Vector<Double>();
                        Vector<Double> correctionMedianESISMedianCorr = new Vector<Double>();
                        Vector<Double> medianAreasESISMedianCorr = new Vector<Double>();
                        Hashtable<Integer, Vector> correctionInternalESISSingleCorr = new Hashtable<Integer, Vector>();
                        Hashtable<Integer, Vector> bestESAreasISSingleCorr = new Hashtable<Integer, Vector>();
                        Hashtable<Integer, Vector> correctionMedianESISSingleCorr = new Hashtable<Integer, Vector>();
                        Hashtable<Integer, Vector> medianAreasESISSingleCorr = new Hashtable<Integer, Vector>();
                        Hashtable<Object, Object> retentionTime = new Hashtable();
                        for (int i = 1; i != isoNr + 1; ++i) {
                            double bestMedianArea;
                            double bestArea;
                            double correctionFactor = 1.0;
                            double medianCorrectionFactor = 1.0;
                            double correctionFactorESNoISCorr = 1.0;
                            double medianCorrectionESNoISCorr = 1.0;
                            double correctionFactorESISInternalCorr = 0.0;
                            double medianCorrectionESISInternalCorr = 0.0;
                            double correctionFactorESISMedianCorr = 0.0;
                            double medianCorrectionESISMedianCorr = 0.0;
                            if (((Hashtable)this.allISNames_.get(groupName)).size() > 0) {
                                bestArea = this.correctAreaCorrespondingly(areaOfBestStandard.getTotalArea(i), groupName, bestExp, i, this.correctionFactorsToBestIS_.get(groupName).get(mostReliableStandard), false, 0, null);
                                bestISAreas.add(bestArea);
                                correctionFactor = bestArea / this.referenceValues_.get(groupName).get(expName).get(i - 1);
                                bestMedianArea = this.medianOfRatios_.get(groupName).get(bestExp).get(i - 1);
                                medianAreas.add(bestMedianArea);
                                medianCorrectionFactor = bestMedianArea / this.medianOfRatios_.get(groupName).get(expName).get(i - 1);
                            }
                            correctionInternalIS.add(correctionFactor);
                            correctionMedianIS.add(medianCorrectionFactor);
                            if (((Hashtable)this.allESNames_.get(groupName)).size() > 0) {
                                bestArea = this.correctAreaCorrespondingly(areaOfBestStandardESNoCorr.getTotalArea(i), groupName, bestExpESNoCorr, i, this.correctionFactorsToBestES_.get(groupName).get(mostReliableExtStandardNoCorr), true, 0, null);
                                bestESAreasNoISCorr.add(bestArea);
                                correctionFactorESNoISCorr = bestArea / this.referenceValuesES_.get(groupName).get(expName).get(i - 1);
                                bestMedianArea = this.medianOfESRatios_.get(groupName).get(bestExpESNoCorr).get(i - 1);
                                medianAreasESNoISCorr.add(bestMedianArea);
                                medianCorrectionESNoISCorr = bestMedianArea / this.medianOfESRatios_.get(groupName).get(expName).get(i - 1);
                                if (this.isISAvailable() && this.bestExpForExtStandardISCorr_.get(groupName) != null) {
                                    bestArea = this.correctAreaCorrespondingly(areaOfBestStandardESInternalCorr.getTotalArea(i), groupName, bestExpESInternalCorr, i, this.correctionFactorsToBestESISCorr_.get(groupName).get(mostReliableExtStandardInternalCorr), true, 1, null);
                                    bestESAreasISInternalCorr.add(bestArea);
                                    correctionFactorESISInternalCorr = bestArea / this.referenceValuesESISCorr_.get(groupName).get(expName).get(i - 1);
                                    bestMedianArea = this.medianOfESRatiosISCorr_.get(groupName).get(bestExpESInternalCorr).get(i - 1);
                                    medianAreasESISInternalCorr.add(bestMedianArea);
                                    medianCorrectionESISInternalCorr = bestMedianArea / this.medianOfESRatiosISCorr_.get(groupName).get(expName).get(i - 1);
                                    bestArea = this.correctAreaCorrespondingly(areaOfBestStandardESMedianCorr.getTotalArea(i), groupName, bestExpESMedianCorr, i, this.correctionFactorsToBestESMedianCorr_.get(groupName).get(mostReliableExtStandardMedianCorr), true, 2, null);
                                    bestESAreasISMedianCorr.add(bestArea);
                                    correctionFactorESISMedianCorr = bestArea / this.referenceValuesESMedianCorr_.get(groupName).get(expName).get(i - 1);
                                    bestMedianArea = this.medianOfESRatiosMedianCorr_.get(groupName).get(bestExpESMedianCorr).get(i - 1);
                                    medianAreasESISMedianCorr.add(bestMedianArea);
                                    medianCorrectionESISMedianCorr = bestMedianArea / this.medianOfESRatiosMedianCorr_.get(groupName).get(bestExpESMedianCorr).get(i - 1);
                                    for (String isName : ((Hashtable)this.allISNames_.get(groupName)).keySet()) {
                                        int isType = this.correctionTypeISLookup_.get(groupName).get(isName);
                                        Vector correctionInternalES = new Vector();
                                        Vector areasESISSingleCorr = new Vector();
                                        Vector correctionMedianES = new Vector();
                                        Vector medianCorrectionESISSingleCorr = new Vector();
                                        if (bestESAreasISSingleCorr.containsKey(isType)) {
                                            correctionInternalES = (Vector)correctionInternalESISSingleCorr.get(isType);
                                            areasESISSingleCorr = (Vector)bestESAreasISSingleCorr.get(isType);
                                            correctionMedianES = (Vector)correctionMedianESISSingleCorr.get(isType);
                                            medianCorrectionESISSingleCorr = (Vector)medianAreasESISSingleCorr.get(isType);
                                        }
                                        if (areaOfBestStandardESSingleCorr.get(isName) == null) continue;
                                        bestArea = this.correctAreaCorrespondingly(((ResultAreaVO)areaOfBestStandardESSingleCorr.get(isName)).getTotalArea(i), groupName, (String)bestExpESSingleCorr.get(isName), i, this.correctionFactorsToBestESSingleCorr_.get(groupName).get(isName).get(mostReliableExtStandardSingleCorr.get(isName)), true, isType, isName);
                                        areasESISSingleCorr.add(bestArea);
                                        double correctionFactorSingle = bestArea / this.referenceValuesESSingleCorr_.get(groupName).get(isName).get(expName).get(i - 1);
                                        correctionInternalES.add(correctionFactorSingle);
                                        bestMedianArea = this.medianOfESRatiosSingleCorr_.get(groupName).get(isName).get(bestExpESSingleCorr.get(isName)).get(i - 1);
                                        medianCorrectionESISSingleCorr.add(bestMedianArea);
                                        double correctionMedianSingle = bestMedianArea / this.medianOfESRatiosSingleCorr_.get(groupName).get(isName).get(expName).get(i - 1);
                                        correctionMedianES.add(correctionMedianSingle);
                                        correctionInternalESISSingleCorr.put(isType, correctionInternalES);
                                        bestESAreasISSingleCorr.put(isType, areasESISSingleCorr);
                                        correctionMedianESISSingleCorr.put(isType, correctionMedianES);
                                        medianAreasESISSingleCorr.put(isType, medianCorrectionESISSingleCorr);
                                    }
                                }
                            }
                            correctionInternalESNoISCorr.add(correctionFactorESNoISCorr);
                            correctionMedianESNoISCorr.add(medianCorrectionESNoISCorr);
                            correctionInternalESISInternalCorr.add(correctionFactorESISInternalCorr);
                            correctionMedianESISInternalCorr.add(medianCorrectionESISInternalCorr);
                            correctionInternalESISMedianCorr.add(correctionFactorESISMedianCorr);
                            correctionMedianESISMedianCorr.add(medianCorrectionESISMedianCorr);
                            if (resultsMolecule.containsKey(expName)) {
                                ResultAreaVO resVO = (ResultAreaVO)resultsMolecule.get(expName);
                                double areaMeasured = resVO.getTotalArea(i);
                                originalAreas.add(areaMeasured);
                                moreThanOnePeak.add(resVO.getMoreThanOnePeak(i));
                                continue;
                            }
                            originalAreas.add(0.0);
                            moreThanOnePeak.add(new Hashtable());
                        }
                        boolean allModsFound = true;
                        if (resultsMolecule.containsKey(expName)) {
                            retentionTime = ((ResultAreaVO)resultsMolecule.get(expName)).getRetentionTimes();
                            allModsFound = ((ResultAreaVO)resultsMolecule.get(expName)).containsAllModifications(this.modifications_.get(groupName));
                        }
                        retentionTimes.put(expName, retentionTime);
                        modsFound.put(expName, allModsFound);
                        originalAreasHash.put(expName, originalAreas);
                        moreThanOnePeakHash.put(expName, moreThanOnePeak);
                        correctionInternalISHash.put(expName, correctionInternalIS);
                        bestISAreasHash.put(expName, bestISAreas);
                        correctionMedianISHash.put(expName, correctionMedianIS);
                        medianAreasHash.put(expName, medianAreas);
                        correctionInternalESNoISCorrHash.put(expName, correctionInternalESNoISCorr);
                        bestESAreasNoISCorrHash.put(expName, bestESAreasNoISCorr);
                        correctionMedianESNoISCorrHash.put(expName, correctionMedianESNoISCorr);
                        medianAreasESNoISCorrHash.put(expName, medianAreasESNoISCorr);
                        correctionInternalESISInternalCorrHash.put(expName, correctionInternalESISInternalCorr);
                        bestESAreasISInternalCorrHash.put(expName, bestESAreasISInternalCorr);
                        correctionMedianESISInternalCorrHash.put(expName, correctionMedianESISInternalCorr);
                        medianAreasESISInternalCorrHash.put(expName, medianAreasESISInternalCorr);
                        correctionInternalESISMedianCorrHash.put(expName, correctionInternalESISMedianCorr);
                        bestESAreasISMedianCorrHash.put(expName, bestESAreasISMedianCorr);
                        correctionMedianESISMedianCorrHash.put(expName, correctionMedianESISMedianCorr);
                        medianAreasESISMedianCorrHash.put(expName, medianAreasESISMedianCorr);
                        correctionInternalESISSingleCorrHash.put(expName, correctionInternalESISSingleCorr);
                        bestESAreasISSingleCorrHash.put(expName, bestESAreasISSingleCorr);
                        correctionMedianESISSingleCorrHash.put(expName, correctionMedianESISSingleCorr);
                        medianAreasESISSingleCorrHash.put(expName, medianAreasESISSingleCorr);
                    }
                    for (String expName : this.expNamesInSequence_) {
                        Double endVolume = null;
                        Double probeVolume = null;
                        Double sampleWeight = null;
                        Double proteinConcentration = null;
                        Double neutralLipidConcentration = null;
                        Vector moleculeMass = null;
                        if (moleculeMasses.containsKey(expName)) {
                            moleculeMass = (Vector)moleculeMasses.get(expName);
                        }
                        if (this.absSetting_ != null) {
                            dilutionFactor = this.absSetting_.getClassSettings().get(groupName).getDilutionFactors().get(expName);
                            ProbeVolConcVO concVO = this.absSetting_.getVolumeSettings().get(expName);
                            endVolume = concVO.getEndVolume();
                            probeVolume = concVO.getProbeVolume();
                            sampleWeight = concVO.getSampleWeight();
                            proteinConcentration = concVO.getProteinConc();
                            neutralLipidConcentration = concVO.getNeutralLipidConc();
                        }
                        Hashtable<Integer, Vector<Double>> isSingleCorrection = new Hashtable();
                        Hashtable<Integer, Vector<Double>> isSingleRefAreas = new Hashtable();
                        if (this.isSingleCorrectiveFactors_ != null && this.isSingleCorrectiveFactors_.get(groupName) != null) {
                            isSingleCorrection = this.isSingleCorrectiveFactors_.get(groupName).get(expName);
                            isSingleRefAreas = this.isSingleRefAreas_.get(groupName);
                        }
                        Hashtable<Integer, Vector<Double>> esSingleNoCorr = new Hashtable();
                        Hashtable<Integer, Vector<Double>> esSingleAreaNoCorr = new Hashtable();
                        if (this.esSingleCorrectiveFactorsNoCorr_ != null && this.esSingleCorrectiveFactorsNoCorr_.get(groupName) != null) {
                            esSingleNoCorr = this.esSingleCorrectiveFactorsNoCorr_.get(groupName).get(expName);
                            esSingleAreaNoCorr = this.esSingleRefAreasNoCorr_.get(groupName);
                        }
                        Hashtable<Integer, Vector<Double>> esSingleIntCorr = new Hashtable();
                        Hashtable<Integer, Vector<Double>> esSingleAreaIntCorr = new Hashtable();
                        Hashtable<Integer, Vector<Double>> esSingleMedCorr = new Hashtable();
                        Hashtable<Integer, Vector<Double>> esSingleAreaMedCorr = new Hashtable();
                        Hashtable<Integer, Hashtable<Integer, Vector<Double>>> esSingleSingleCorr = new Hashtable();
                        Hashtable<Integer, Hashtable<Integer, Vector<Double>>> esSingleAreaSingleCorr = new Hashtable();
                        if (this.esSingleCorrectiveFactorsIntCorr_ != null && this.esSingleCorrectiveFactorsIntCorr_.get(groupName) != null) {
                            esSingleIntCorr = this.esSingleCorrectiveFactorsIntCorr_.get(groupName).get(expName);
                            esSingleAreaIntCorr = this.esSingleRefAreasIntCorr_.get(groupName);
                            esSingleMedCorr = this.esSingleCorrectiveFactorsMedCorr_.get(groupName).get(expName);
                            esSingleAreaMedCorr = this.esSingleRefAreasMedCorr_.get(groupName);
                            esSingleSingleCorr = this.esSingleCorrectiveFactorsSingleCorr_.get(groupName).get(expName);
                            esSingleAreaSingleCorr = this.esSingleRefAreasSingleCorr_.get(groupName);
                        }
                        Vector originalAreas = (Vector)originalAreasHash.get(expName);
                        Vector moreThanOnePeak = (Vector)moreThanOnePeakHash.get(expName);
                        boolean existsInFile = false;
                        if (this.allResultsHash_.containsKey(groupName) && this.allResultsHash_.get(groupName).containsKey(expName) && this.allResultsHash_.get(groupName).get(expName).containsKey(molecule)) {
                            existsInFile = true;
                        }
                        boolean isNullInFile = false;
                        if (!existsInFile && this.isNullResult_.containsKey(expName) && this.isNullResult_.get(expName).containsKey(groupName) && this.isNullResult_.get(expName).get(groupName).containsKey(molecule)) {
                            isNullInFile = true;
                        }
                        relativeValues.put(expName, new ResultCompVO((ResultAreaVO)resultsMolecule.get(expName), existsInFile, isNullInFile, resultType, moleculeMass, (Hashtable)retentionTimes.get(expName), ((File)this.expNameToFile_.get(expName)).getAbsolutePath(), isoNr, (Boolean)modsFound.get(expName), originalAreas, (Vector)correctionInternalISHash.get(expName), (Vector)correctionMedianISHash.get(expName), isSingleCorrection, (Vector)bestISAreasHash.get(expName), (Vector)medianAreasHash.get(expName), isSingleRefAreas, (Vector)correctionInternalESNoISCorrHash.get(expName), (Vector)correctionMedianESNoISCorrHash.get(expName), esSingleNoCorr, (Vector)correctionInternalESISInternalCorrHash.get(expName), (Vector)correctionMedianESISInternalCorrHash.get(expName), esSingleIntCorr, (Vector)correctionInternalESISMedianCorrHash.get(expName), (Vector)correctionMedianESISMedianCorrHash.get(expName), esSingleMedCorr, (Hashtable)correctionInternalESISSingleCorrHash.get(expName), (Hashtable)correctionMedianESISSingleCorrHash.get(expName), esSingleSingleCorr, (Vector)bestESAreasNoISCorrHash.get(expName), (Vector)medianAreasESNoISCorrHash.get(expName), esSingleAreaNoCorr, (Vector)bestESAreasISInternalCorrHash.get(expName), (Vector)medianAreasESISInternalCorrHash.get(expName), esSingleAreaIntCorr, (Vector)bestESAreasISMedianCorrHash.get(expName), (Vector)medianAreasESISMedianCorrHash.get(expName), esSingleAreaMedCorr, (Hashtable)bestESAreasISSingleCorrHash.get(expName), (Hashtable)medianAreasESISSingleCorrHash.get(expName), esSingleAreaSingleCorr, this.isAmountLookup_.get(groupName), dilutionFactor, this.esAmountLookup_.get(groupName), esVolumeInternalCorr, esConcentrationInternalCorr, esVolumeMedianCorr, esConcentrationMedianCorr, esVolumeSingleCorr, esConcentrationSingleCorr, endVolume, probeVolume, sampleWeight, proteinConcentration, neutralLipidConcentration, moreThanOnePeak, this.absSetting_ != null));
                    }
                } else {
                    for (String expName : this.expNamesInSequence_) {
                        relativeValues.put(expName, new ResultCompVO(null, false, false, resultType, new Vector<Double>(), new Hashtable<String, Double>(), ((File)this.expNameToFile_.get(expName)).getAbsolutePath(), isoNr, false, new Vector<Double>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Hashtable<Integer, Vector<Double>>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Vector<Double>(), new Vector<Double>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Vector<Double>>(), new Hashtable<Integer, Hashtable<Integer, Vector<Double>>>(), this.isAmountLookup_.get(groupName), dilutionFactor, this.esAmountLookup_.get(groupName), esVolumeInternalCorr, esConcentrationInternalCorr, esVolumeMedianCorr, esConcentrationMedianCorr, esVolumeSingleCorr, esVolumeSingleCorr, null, null, null, null, null, new Vector<Hashtable<String, Boolean>>(), false));
                    }
                }
                compForOneGroup.put(molecule, relativeValues);
            }
            this.comparativeRatios_.put(groupName, compForOneGroup);
        }
        this.calculateSumAndHighestExp(this.expNamesInSequence_, this.comparativeRatios_);
        if (this.groups_ != null && this.groups_.size() > 0) {
            this.comparativeRatiosGroups_ = new Hashtable();
            for (String molGroup : this.comparativeRatios_.keySet()) {
                Hashtable<String, Hashtable<String, ResultCompVO>> compForOneGroup = this.comparativeRatios_.get(molGroup);
                Hashtable groupedCompForOneGroup = new Hashtable();
                for (String molecule : compForOneGroup.keySet()) {
                    Hashtable<String, ResultCompVO> compForOneMolecule = compForOneGroup.get(molecule);
                    Hashtable<String, ResultCompGroupVO> groupedCompForOneMolecule = new Hashtable<String, ResultCompGroupVO>();
                    for (String groupName : this.expNamesOfGroup_.keySet()) {
                        Hashtable<String, ResultCompVO> participatingExps = new Hashtable<String, ResultCompVO>();
                        for (String expName : this.expNamesOfGroup_.get(groupName)) {
                            participatingExps.put(expName, compForOneMolecule.get(expName));
                        }
                        ResultCompGroupVO groupVO = new ResultCompGroupVO(participatingExps);
                        groupedCompForOneMolecule.put(groupName, groupVO);
                    }
                    groupedCompForOneGroup.put(molecule, groupedCompForOneMolecule);
                }
                this.comparativeRatiosGroups_.put(molGroup, groupedCompForOneGroup);
            }
            this.calculateRatiosGroup(this.groups_, this.comparativeRatiosGroups_);
        }
    }

    private void calculateSumAndHighestExp(Vector<String> expNames, Hashtable<String, Hashtable<String, Hashtable<String, ResultCompVO>>> resultsHash) {
        for (String expName : expNames) {
            Hashtable highestValuesGroup = new Hashtable();
            Hashtable sumValuesGroup = new Hashtable();
            Hashtable massValuesGroup = new Hashtable();
            Vector<Double> highestTotalValue = new Vector<Double>();
            Vector<Double> totalSumValue = new Vector<Double>();
            int highestIso = 0;
            for (String groupName : resultsHash.keySet()) {
                int maxIso = this.maxIsotopesOfGroup_.get(groupName);
                if (maxIso > highestIso) {
                    highestIso = maxIso;
                }
                Hashtable<String, Hashtable<String, ResultCompVO>> results = resultsHash.get(groupName);
                Hashtable<Integer, Double> highestValues = new Hashtable<Integer, Double>();
                Hashtable sumValues = new Hashtable();
                Hashtable<Integer, Double> massValues = new Hashtable<Integer, Double>();
                for (int i = 0; i != maxIso; ++i) {
                    double highestValue = 0.0;
                    double sumValue = 0.0;
                    double weightValue = 0.0;
                    for (String molecule : results.keySet()) {
                        ResultCompVO resultVO = results.get(molecule).get(expName);
                        if (resultVO.getType() != 0) continue;
                        double area = resultVO.getOriginalArea(resultVO.getAvailableIsotopeNr(i));
                        if (area > highestValue) {
                            highestValue = area;
                        }
                        sumValue += area;
                        weightValue += area * resultVO.getMass(resultVO.getAvailableIsotopeNr(i));
                    }
                    highestValues.put(i, highestValue);
                    sumValues.put(i, sumValue);
                    massValues.put(i, weightValue);
                }
                Vector highest = new Vector();
                Vector sum = new Vector();
                Vector mass = new Vector();
                for (int i = 0; i != maxIso; ++i) {
                    highest.add(highestValues.get(i));
                    sum.add(sumValues.get(i));
                    mass.add(massValues.get(i));
                }
                highestValuesGroup.put(groupName, highest);
                sumValuesGroup.put(groupName, sum);
                massValuesGroup.put(groupName, mass);
            }
            for (int i = 0; i != highestIso; ++i) {
                double highest = 0.0;
                double sum = 0.0;
                for (String groupName : highestValuesGroup.keySet()) {
                    Vector valuesOfGroup = (Vector)highestValuesGroup.get(groupName);
                    double oneHighestValue = 0.0;
                    double aSumValue = 0.0;
                    if (i < valuesOfGroup.size()) {
                        oneHighestValue = (Double)valuesOfGroup.get(i);
                        aSumValue = (Double)((Vector)sumValuesGroup.get(groupName)).get(i);
                    } else if (valuesOfGroup.size() > 0) {
                        oneHighestValue = (Double)valuesOfGroup.get(valuesOfGroup.size() - 1);
                        aSumValue = (Double)((Vector)sumValuesGroup.get(groupName)).get(valuesOfGroup.size() - 1);
                    }
                    if (oneHighestValue > highest) {
                        highest = oneHighestValue;
                    }
                    sum += aSumValue;
                }
                highestTotalValue.add(highest);
                totalSumValue.add(sum);
            }
            for (String groupName : resultsHash.keySet()) {
                Hashtable<String, Hashtable<String, ResultCompVO>> results = resultsHash.get(groupName);
                for (String molecule : results.keySet()) {
                    ResultCompVO resultVO = results.get(molecule).get(expName);
                    resultVO.setHighestGroupIntensity((Vector)highestValuesGroup.get(groupName));
                    resultVO.setTotalGroupIntensity((Vector)sumValuesGroup.get(groupName));
                    resultVO.setTotalGroupMass((Vector)massValuesGroup.get(groupName));
                    resultVO.setHighestFoundIntensity(highestTotalValue);
                    resultVO.setTotalFoundIntensity(totalSumValue);
                }
            }
        }
    }

    private void calculateRatiosGroup(Vector<String> groupNames, Hashtable<String, Hashtable<String, Hashtable<String, ResultCompVO>>> groups) {
        for (String groupName : groupNames) {
            int highestIso = 0;
            Hashtable sumMeans = new Hashtable();
            Hashtable sumSds = new Hashtable();
            Vector<Double> sumTotalMeans = new Vector<Double>();
            Vector<Double> sumTotalSds = new Vector<Double>();
            Hashtable<Integer, Double> sumSumTotalMean = new Hashtable<Integer, Double>();
            Vector sdsSumTotalMean = new Vector();
            for (String className : groups.keySet()) {
                int maxIso = this.maxIsotopesOfGroup_.get(className);
                if (maxIso > highestIso) {
                    highestIso = maxIso;
                }
                Hashtable<String, Hashtable<String, ResultCompVO>> groupOfClass = groups.get(className);
                Hashtable<Integer, Double> sumSumMeanHash = new Hashtable<Integer, Double>();
                Vector vector = new Vector();
                for (String molName : groupOfClass.keySet()) {
                    ResultCompGroupVO compVO = (ResultCompGroupVO)groupOfClass.get(molName).get(groupName);
                    Hashtable<Integer, Double> sdsSumMeanMolecule = new Hashtable<Integer, Double>();
                    Hashtable<Integer, Double> sdsSumTotalMeanMolecule = new Hashtable<Integer, Double>();
                    if (compVO.getType() != 0) continue;
                    for (int i = 0; i != maxIso; ++i) {
                        double relativeSumMean = compVO.getMeanOfRatioToTotalIntensity(compVO.getAvailableIsotopeNr(i));
                        double relativeSumSD = compVO.getSDOfRatioToTotalIntensity(compVO.getAvailableIsotopeNr(i));
                        double relativeSumTotalMean = compVO.getMeanRatioToOverallGroupsIntensity(compVO.getAvailableIsotopeNr(i));
                        double relativeSumTotalSD = compVO.getSDRatioToOverallGroupsIntensity(compVO.getAvailableIsotopeNr(i));
                        double sumSumValue = 0.0;
                        double sumSumTotalValue = 0.0;
                        if (sumSumMeanHash.containsKey(i)) {
                            sumSumValue = (Double)sumSumMeanHash.get(i);
                        }
                        if (sumSumTotalMean.containsKey(i)) {
                            sumSumTotalValue = (Double)sumSumTotalMean.get(i);
                        }
                        sumSumMeanHash.put(i, sumSumValue += relativeSumMean);
                        sumSumTotalMean.put(i, sumSumTotalValue += relativeSumTotalMean);
                        sdsSumMeanMolecule.put(i, relativeSumSD);
                        sdsSumTotalMeanMolecule.put(i, relativeSumTotalSD);
                    }
                    vector.add(sdsSumMeanMolecule);
                    sdsSumTotalMean.add(sdsSumTotalMeanMolecule);
                }
                Vector sumSumMean = new Vector();
                Vector<Double> sdSumMean = new Vector<Double>();
                for (int i = 0; i != maxIso; ++i) {
                    sumSumMean.add(i, sumSumMeanHash.get(i));
                    Vector<Double> stdevSumIso = new Vector<Double>();
                    for (Hashtable hashtable : vector) {
                        stdevSumIso.add((Double)hashtable.get(i));
                    }
                    double stdevSumErrorPropagated = Calculator.calculateSumStdevErrorPropagated(stdevSumIso);
                    sdSumMean.add(stdevSumErrorPropagated);
                }
                sumMeans.put(className, sumSumMean);
                sumSds.put(className, sdSumMean);
            }
            for (int i = 0; i != highestIso; ++i) {
                double aSumTotalMean = 0.0;
                if (i < sumSumTotalMean.size()) {
                    aSumTotalMean = (Double)sumSumTotalMean.get(i);
                } else if (sumSumTotalMean.size() > 0) {
                    aSumTotalMean = (Double)sumSumTotalMean.get(sumSumTotalMean.size() - 1);
                }
                sumTotalMeans.add(aSumTotalMean);
                Vector<Double> stdevSumIso = new Vector<Double>();
                for (Hashtable hashtable : sdsSumTotalMean) {
                    double aStdevSumIso = 0.0;
                    if (i < hashtable.size()) {
                        aSumTotalMean = (Double)hashtable.get(i);
                    } else if (hashtable.size() > 0) {
                        aSumTotalMean = (Double)hashtable.get(hashtable.size() - 1);
                    }
                    stdevSumIso.add(aStdevSumIso);
                }
                double stdevSumErrorPropagated = Calculator.calculateSumStdevErrorPropagated(stdevSumIso);
                sumTotalSds.add(stdevSumErrorPropagated);
            }
            for (String className : groups.keySet()) {
                Hashtable<String, Hashtable<String, ResultCompVO>> groupOfClass = groups.get(className);
                for (String molName : groupOfClass.keySet()) {
                    ResultCompGroupVO resultCompGroupVO = (ResultCompGroupVO)groupOfClass.get(molName).get(groupName);
                    resultCompGroupVO.setSumGroupMeans((Vector)sumMeans.get(className));
                    resultCompGroupVO.setSumGroupSds((Vector)sumSds.get(className));
                    resultCompGroupVO.setSumTotalMeans(sumTotalMeans);
                    resultCompGroupVO.setSumTotalSds(sumTotalSds);
                }
            }
        }
    }

    @Override
    protected Vector<String> sortMainGroup(Vector<String> mainGroup) {
        return mainGroup;
    }

    public Hashtable<String, Hashtable<String, Hashtable<String, ResultCompVO>>> getResults() {
        return this.comparativeRatios_;
    }

    public Hashtable<String, Hashtable<String, Hashtable<String, ResultCompVO>>> getGroupedResults() {
        return this.comparativeRatiosGroups_;
    }

    public Hashtable<String, Vector<String>> getAllMoleculeNames() {
        return this.allMoleculeNames_;
    }

    public Hashtable<String, Hashtable<String, String>> getAllISNames() {
        return this.allISNames_;
    }

    public Hashtable<String, Hashtable<String, String>> getAllESNames() {
        return this.allESNames_;
    }

    public LinkedHashMap<String, Integer> getClassSequence() {
        return this.classSequence_;
    }

    public Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> getQuantObjects() {
        return this.quantObjects_;
    }

    public Hashtable<String, Hashtable<String, Integer>> getCorrectionTypeISLookup() {
        return this.correctionTypeISLookup_;
    }

    public Hashtable<String, Hashtable<String, Integer>> getCorrectionTypeESLookup() {
        return this.correctionTypeESLookup_;
    }

    public int getMaxIsotopesOfGroup(String molGroupName) {
        return this.maxIsotopesOfGroup_.get(molGroupName);
    }

    private void calculteESRelativeCorrectionFactors() {
        this.esCorrectionFactors_ = new Hashtable();
        this.calculateRelativeCorrectionFactors(this.esResults_, this.allESNames_, this.esCorrectionFactors_, false);
    }

    private void calculteISRelativeCorrectionFactors() {
        this.isCorrectionFactors_ = new Hashtable();
        this.calculateRelativeCorrectionFactors(this.isResults_, this.allISNames_, this.isCorrectionFactors_, true);
    }

    private void calculateRelativeCorrectionFactors(Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> standResults, Hashtable<String, Hashtable<String, String>> standNames, Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactors, boolean isIS) {
        for (String molGroup : standResults.keySet()) {
            if (standNames.get(molGroup).size() <= 0) continue;
            Hashtable<String, Hashtable<String, ResultAreaVO>> issOfGroup = standResults.get(molGroup);
            Hashtable groupISCorrectionFactors = new Hashtable();
            for (String isName : issOfGroup.keySet()) {
                Hashtable<String, Double> relativeCorrectionFactors = new Hashtable<String, Double>();
                if (this.absSetting_ != null) {
                    LipidClassSettingVO settingVO = this.absSetting_.getClassSettings().get(molGroup);
                    Hashtable<String, VolumeConcVO> standValues = null;
                    standValues = isIS ? settingVO.getIsStandards().get(isName) : settingVO.getEsStandards().get(isName);
                    Vector<Double> amounts = new Vector<Double>();
                    for (VolumeConcVO concVO : standValues.values()) {
                        amounts.add(concVO.getVolume() * concVO.getConcentration());
                    }
                    double median = DoubleCalculator.median(amounts);
                    for (String expName : this.expNamesInSequence_) {
                        VolumeConcVO isVO = standValues.get(expName);
                        relativeCorrectionFactors.put(expName, median / (isVO.getVolume() * isVO.getConcentration()));
                    }
                } else {
                    for (String expName : this.expNamesInSequence_) {
                        relativeCorrectionFactors.put(expName, 1.0);
                    }
                }
                groupISCorrectionFactors.put(isName, relativeCorrectionFactors);
            }
            correctionFactors.put(molGroup, groupISCorrectionFactors);
        }
    }

    private void calculateRelativeCorrectiveValuesComparedToBestES() {
        this.correctionFactorsToBestES_ = new Hashtable();
        this.calculateRelativeCorrectiveValuesComparedToBestStandard(this.esResults_, this.allESNames_, this.esCorrectionFactors_, this.extstandsOrderedConcerningReliability_, this.bestExpForExtStandard_, false, this.correctionFactorsToBestES_);
        boolean isFound = this.isISAvailable();
        if (isFound) {
            this.correctionFactorsToBestESISCorr_ = new Hashtable();
            this.calculateRelativeCorrectiveValuesComparedToBestStandard(this.esResults_, this.allESNames_, this.esCorrectionFactors_, this.extstandsISCorrOrderedConcerningReliability_, this.bestExpForExtStandardISCorr_, false, this.correctionFactorsToBestESISCorr_);
            this.correctionFactorsToBestESMedianCorr_ = new Hashtable();
            this.calculateRelativeCorrectiveValuesComparedToBestStandard(this.esResults_, this.allESNames_, this.esCorrectionFactors_, this.extstandsMedianCorrOrderedConcerningReliability_, this.bestExpForExtStandardMedianCorr_, false, this.correctionFactorsToBestESMedianCorr_);
            this.correctionFactorsToBestESSingleCorr_ = new Hashtable();
            for (String molGroupName : this.allResults_.keySet()) {
                Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactorsToBestGroup = new Hashtable<String, Hashtable<String, Hashtable<String, Double>>>();
                for (String isName : ((Hashtable)this.allISNames_.get(molGroupName)).keySet()) {
                    Hashtable<String, Hashtable<String, Double>> correctionFactors = new Hashtable<String, Hashtable<String, Double>>();
                    if (((Hashtable)this.allESNames_.get(molGroupName)).size() > 0 && this.bestExpForExtStandardSingleCorr_.get(molGroupName) != null) {
                        this.calculateRelativeCorrectiveValuesComparedToBestStandardGroup(molGroupName, this.esResults_.get(molGroupName), this.esCorrectionFactors_.get(molGroupName), this.extstandsSingleCorrOrderedConcerningReliability_.get(molGroupName).get(isName), this.bestExpForExtStandardSingleCorr_.get(molGroupName).get(isName), false, correctionFactors);
                    }
                    correctionFactorsToBestGroup.put(isName, correctionFactors);
                }
                this.correctionFactorsToBestESSingleCorr_.put(molGroupName, correctionFactorsToBestGroup);
            }
        }
    }

    private void calculateRelativeCorrectiveValuesComparedToBestIS() {
        this.correctionFactorsToBestIS_ = new Hashtable();
        this.calculateRelativeCorrectiveValuesComparedToBestStandard(this.isResults_, this.allISNames_, this.isCorrectionFactors_, this.standardsOrderedConcerningReliability_, this.bestExpForStandard_, true, this.correctionFactorsToBestIS_);
    }

    private void calculateRelativeCorrectiveValuesComparedToBestStandard(Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> standResults, Hashtable<String, Hashtable<String, String>> standNames, Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactors, Hashtable<String, Vector<String>> standardsOrderedConcerningReliability, Hashtable<String, Hashtable<String, String>> bestExpForStandard, boolean isIS, Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactorsToBestStandard) {
        for (String groupName : standResults.keySet()) {
            if (standNames.get(groupName).size() <= 0) continue;
            Hashtable<String, Hashtable<String, Double>> groupCorrectionFactors = new Hashtable<String, Hashtable<String, Double>>();
            if (bestExpForStandard.get(groupName) == null) continue;
            this.calculateRelativeCorrectiveValuesComparedToBestStandardGroup(groupName, standResults.get(groupName), correctionFactors.get(groupName), standardsOrderedConcerningReliability.get(groupName), bestExpForStandard.get(groupName), isIS, groupCorrectionFactors);
            correctionFactorsToBestStandard.put(groupName, groupCorrectionFactors);
        }
    }

    private void calculateRelativeCorrectiveValuesComparedToBestStandardGroup(String groupName, Hashtable<String, Hashtable<String, ResultAreaVO>> standResults, Hashtable<String, Hashtable<String, Double>> correctionFactors, Vector<String> standardsOrderedConcerningReliability, Hashtable<String, String> bestExpForStandard, boolean isIS, Hashtable<String, Hashtable<String, Double>> groupCorrectionFactors) {
        String mostReliableStandard = standardsOrderedConcerningReliability.get(0);
        if (this.absSetting_ != null) {
            String bestExp = bestExpForStandard.get(mostReliableStandard);
            Hashtable<String, Hashtable<String, VolumeConcVO>> standValues = null;
            LipidClassSettingVO settingVO = this.absSetting_.getClassSettings().get(groupName);
            standValues = isIS ? settingVO.getIsStandards() : settingVO.getEsStandards();
            double amountBestStand = standValues.get(mostReliableStandard).get(bestExp).getAmount();
            for (String isName : standResults.keySet()) {
                Hashtable<String, Double> isCorrectionFactors = new Hashtable<String, Double>();
                for (String expName : this.expNamesInSequence_) {
                    isCorrectionFactors.put(expName, amountBestStand / standValues.get(isName).get(expName).getAmount());
                }
                groupCorrectionFactors.put(isName, isCorrectionFactors);
            }
        } else {
            groupCorrectionFactors.putAll(correctionFactors);
        }
    }

    private void calculateESMedians() {
        this.medianOfESRatios_ = new Hashtable();
        this.esSingleRefAreasNoCorr_ = new Hashtable();
        this.esSingleCorrectiveFactorsNoCorr_ = new Hashtable();
        this.correctionTypeESLookup_ = new Hashtable();
        this.calculateMedians(this.esResults_, this.allESNames_, this.correctionFactorsToBestES_, this.extStandStatistics_, this.applicableStandardsES_, this.medianOfESRatios_, this.esSingleRefAreasNoCorr_, this.esSingleCorrectiveFactorsNoCorr_, this.correctionTypeESLookup_, this.bestExpForExtStandard_, true, 0);
        if (this.isISAvailable()) {
            this.medianOfESRatiosISCorr_ = new Hashtable();
            this.esSingleRefAreasIntCorr_ = new Hashtable();
            this.esSingleCorrectiveFactorsIntCorr_ = new Hashtable();
            this.calculateMedians(this.esResults_, this.allESNames_, this.correctionFactorsToBestESISCorr_, this.extStandStatisticsISCorrected_, this.applicableStandardsESISCorr_, this.medianOfESRatiosISCorr_, this.esSingleRefAreasIntCorr_, this.esSingleCorrectiveFactorsIntCorr_, this.correctionTypeESLookup_, this.bestExpForExtStandardISCorr_, true, 1);
            this.medianOfESRatiosMedianCorr_ = new Hashtable();
            this.esSingleRefAreasMedCorr_ = new Hashtable();
            this.esSingleCorrectiveFactorsMedCorr_ = new Hashtable();
            this.calculateMedians(this.esResults_, this.allESNames_, this.correctionFactorsToBestESISCorr_, this.extStandStatisticsISMedianCorrected_, this.applicableStandardsESMedianCorr_, this.medianOfESRatiosMedianCorr_, this.esSingleRefAreasMedCorr_, this.esSingleCorrectiveFactorsMedCorr_, this.correctionTypeESLookup_, this.bestExpForExtStandardMedianCorr_, true, 2);
            this.medianOfESRatiosSingleCorr_ = new Hashtable();
            this.esSingleRefAreasSingleCorr_ = new Hashtable();
            this.esSingleCorrectiveFactorsSingleCorr_ = new Hashtable();
            for (String molGroupName : this.allResults_.keySet()) {
                Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> medianOfESRatiosGroup = new Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>>();
                Hashtable<Integer, Hashtable<Integer, Vector<Double>>> esSingleRefAreasGroup = new Hashtable<Integer, Hashtable<Integer, Vector<Double>>>();
                Hashtable<String, Hashtable> esSingleCorrectiveFactorsGroup = new Hashtable<String, Hashtable>();
                for (String isName : ((Hashtable)this.allISNames_.get(molGroupName)).keySet()) {
                    int isType = this.correctionTypeISLookup_.get(molGroupName).get(isName);
                    Hashtable<String, Hashtable<Integer, Double>> medianOfRatiosExps = new Hashtable<String, Hashtable<Integer, Double>>();
                    Hashtable<Integer, Vector<Double>> groupRefAreas = new Hashtable<Integer, Vector<Double>>();
                    Hashtable<String, Hashtable<Integer, Vector<Double>>> groupCorectiveFactors = new Hashtable<String, Hashtable<Integer, Vector<Double>>>();
                    if (((Hashtable)this.allESNames_.get(molGroupName)).size() > 0 && this.bestExpForExtStandardSingleCorr_.get(molGroupName) != null && this.bestExpForExtStandardSingleCorr_.get(molGroupName).get(isName) != null) {
                        this.calculateMediansGroup(molGroupName, this.esResults_.get(molGroupName), this.correctionFactorsToBestESSingleCorr_.get(molGroupName).get(isName), this.extStandStatisticsISSingleCorrected_.get(molGroupName).get(isName), this.applicableStandardsESSingleCorr_.get(molGroupName).get(isName), medianOfRatiosExps, groupRefAreas, groupCorectiveFactors, this.correctionTypeESLookup_.get(molGroupName), this.bestExpForExtStandardSingleCorr_.get(molGroupName).get(isName), true, isType, isName);
                    }
                    medianOfESRatiosGroup.put(isName, medianOfRatiosExps);
                    esSingleRefAreasGroup.put(isType, groupRefAreas);
                    for (String expName : groupCorectiveFactors.keySet()) {
                        Hashtable corrOfStandard = new Hashtable();
                        if (esSingleCorrectiveFactorsGroup.containsKey(expName)) {
                            corrOfStandard = (Hashtable)esSingleCorrectiveFactorsGroup.get(expName);
                        }
                        corrOfStandard.put(isType, groupCorectiveFactors.get(expName));
                        esSingleCorrectiveFactorsGroup.put(expName, corrOfStandard);
                    }
                }
                this.medianOfESRatiosSingleCorr_.put(molGroupName, medianOfESRatiosGroup);
                this.esSingleRefAreasSingleCorr_.put(molGroupName, esSingleRefAreasGroup);
                this.esSingleCorrectiveFactorsSingleCorr_.put(molGroupName, esSingleCorrectiveFactorsGroup);
            }
        }
    }

    private void calculateISMedians() {
        this.medianOfRatios_ = new Hashtable();
        this.isSingleRefAreas_ = new Hashtable();
        this.isSingleCorrectiveFactors_ = new Hashtable();
        this.correctionTypeISLookup_ = new Hashtable();
        this.calculateMedians(this.isResults_, this.allISNames_, this.correctionFactorsToBestIS_, this.intStandStatistics_, this.applicableStandards_, this.medianOfRatios_, this.isSingleRefAreas_, this.isSingleCorrectiveFactors_, this.correctionTypeISLookup_, this.bestExpForStandard_, false, 0);
    }

    private void calculateMedians(Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>> standResults, Hashtable<String, Hashtable<String, String>> standNames, Hashtable<String, Hashtable<String, Hashtable<String, Double>>> correctionFactors, Hashtable<String, Hashtable<String, InternalStandardStatistics>> standardsStatistics, Hashtable<String, Hashtable<String, Hashtable<String, Boolean>>> applicableStandards, Hashtable<String, Hashtable<String, Hashtable<Integer, Double>>> medianOfRatios, Hashtable<String, Hashtable<Integer, Vector<Double>>> singleRefAreas, Hashtable<String, Hashtable<String, Hashtable<Integer, Vector<Double>>>> singleCorrectiveFactors, Hashtable<String, Hashtable<String, Integer>> correctionTypeLookup, Hashtable<String, Hashtable<String, String>> bestExpForStandard, boolean respectDilution, int standMethod) {
        for (String moleculeGroup : standResults.keySet()) {
            if (standNames.get(moleculeGroup).size() <= 0 || bestExpForStandard.get(moleculeGroup) == null) continue;
            Hashtable<String, Hashtable<Integer, Double>> medianOfRatiosExps = new Hashtable<String, Hashtable<Integer, Double>>();
            Hashtable<Integer, Vector<Double>> groupRefAreas = new Hashtable<Integer, Vector<Double>>();
            Hashtable<String, Hashtable<Integer, Vector<Double>>> groupCorectiveFactors = new Hashtable<String, Hashtable<Integer, Vector<Double>>>();
            Hashtable<String, Integer> correctionType = new Hashtable();
            if (correctionTypeLookup.containsKey(moleculeGroup)) {
                correctionType = correctionTypeLookup.get(moleculeGroup);
            }
            this.calculateMediansGroup(moleculeGroup, standResults.get(moleculeGroup), correctionFactors.get(moleculeGroup), standardsStatistics.get(moleculeGroup), applicableStandards.get(moleculeGroup), medianOfRatiosExps, groupRefAreas, groupCorectiveFactors, correctionType, bestExpForStandard.get(moleculeGroup), respectDilution, standMethod, null);
            medianOfRatios.put(moleculeGroup, medianOfRatiosExps);
            singleRefAreas.put(moleculeGroup, groupRefAreas);
            singleCorrectiveFactors.put(moleculeGroup, groupCorectiveFactors);
            correctionTypeLookup.put(moleculeGroup, correctionType);
        }
    }

    private void calculateMediansGroup(String moleculeGroup, Hashtable<String, Hashtable<String, ResultAreaVO>> standResults, Hashtable<String, Hashtable<String, Double>> correctionFactors, Hashtable<String, InternalStandardStatistics> standardsStatistics, Hashtable<String, Hashtable<String, Boolean>> groupApplic, Hashtable<String, Hashtable<Integer, Double>> medianOfRatiosExps, Hashtable<Integer, Vector<Double>> groupRefAreas, Hashtable<String, Hashtable<Integer, Vector<Double>>> groupCorectiveFactors, Hashtable<String, Integer> correctionType, Hashtable<String, String> bestExpForStandard, boolean respectDilution, int standMethod, String corrStandard) {
        for (int i = 1; i != this.maxIsotopesOfGroup_.get(moleculeGroup) + 1; ++i) {
            for (String expName : this.expNamesInSequence_) {
                Hashtable<String, Boolean> isApplicable = groupApplic.get(expName);
                Vector<Float> standardValues = new Vector<Float>();
                Hashtable<Object, Object> medianRatioIsos = new Hashtable();
                if (medianOfRatiosExps.containsKey(expName)) {
                    medianRatioIsos = medianOfRatiosExps.get(expName);
                }
                for (String standardName : isApplicable.keySet()) {
                    Hashtable<String, ResultAreaVO> oneIsSeveralExps = standResults.get(standardName);
                    if (!oneIsSeveralExps.containsKey(expName) || !isApplicable.containsKey(standardName) || !isApplicable.get(standardName).booleanValue()) continue;
                    int isosToTake = i;
                    if (standardsStatistics.get(standardName).getAmountIsotopesFoundInAll() < isosToTake) {
                        isosToTake = standardsStatistics.get(standardName).getAmountIsotopesFoundInAll();
                    }
                    double refValue = this.correctAreaCorrespondingly(oneIsSeveralExps.get(expName).getTotalArea(isosToTake), moleculeGroup, expName, isosToTake, correctionFactors.get(standardName), respectDilution, standMethod, corrStandard);
                    if (standardsStatistics.get(standardName).getAmountIsotopesFoundInAll() < i) {
                        refValue = this.correctAreaCorrespondingly(oneIsSeveralExps.get(expName).getTheoreticalIsotopeValue(this.elementParser_, i), moleculeGroup, expName, 1, correctionFactors.get(standardName), respectDilution, standMethod, corrStandard);
                    }
                    if (!(refValue > 0.0)) continue;
                    standardValues.add(Float.valueOf((float)refValue));
                }
                Float median = Calculator.median(standardValues);
                if (median == null || median.isNaN() || median.isInfinite()) continue;
                medianRatioIsos.put(i - 1, Double.valueOf(median.floatValue()));
                medianOfRatiosExps.put(expName, medianRatioIsos);
            }
        }
        int currentType = 2;
        boolean useExistingTypes = false;
        if (correctionType.size() > 0) {
            useExistingTypes = true;
        }
        for (String standName : standResults.keySet()) {
            ++currentType;
            if (useExistingTypes) {
                currentType = correctionType.get(standName);
            }
            String bestExp = bestExpForStandard.get(standName);
            Hashtable<String, ResultAreaVO> oneStandardSeveralExps = standResults.get(standName);
            Vector<Double> refAreas = new Vector<Double>();
            for (int i = 1; i != this.maxIsotopesOfGroup_.get(moleculeGroup) + 1; ++i) {
                int isosToTake = i;
                if (standardsStatistics.get(standName).getAmountIsotopesFoundInAll() < isosToTake) {
                    isosToTake = standardsStatistics.get(standName).getAmountIsotopesFoundInAll();
                }
                double refValue = this.correctAreaCorrespondingly(oneStandardSeveralExps.get(bestExp).getTotalArea(isosToTake), moleculeGroup, bestExp, isosToTake, correctionFactors.get(standName), respectDilution, standMethod, corrStandard);
                if (standardsStatistics.get(standName).getAmountIsotopesFoundInAll() < i) {
                    refValue = this.correctAreaCorrespondingly(oneStandardSeveralExps.get(bestExp).getTheoreticalIsotopeValue(this.elementParser_, i), moleculeGroup, bestExp, 1, correctionFactors.get(standName), respectDilution, standMethod, corrStandard);
                }
                refAreas.add(refValue /= correctionFactors.get(standName).get(bestExp).doubleValue());
            }
            for (String expName : this.expNamesInSequence_) {
                if (oneStandardSeveralExps.get(expName) != null) {
                    Hashtable<Object, Object> standCorrect = new Hashtable();
                    if (groupCorectiveFactors.containsKey(expName)) {
                        standCorrect = groupCorectiveFactors.get(expName);
                    }
                    Vector<Double> correctiveFactors = new Vector<Double>();
                    for (int i = 1; i != this.maxIsotopesOfGroup_.get(moleculeGroup) + 1; ++i) {
                        int isosToTake = i;
                        if (standardsStatistics.get(standName).getAmountIsotopesFoundInAll() < isosToTake) {
                            isosToTake = standardsStatistics.get(standName).getAmountIsotopesFoundInAll();
                        }
                        double expValue = this.correctAreaCorrespondingly(oneStandardSeveralExps.get(expName).getTotalArea(isosToTake), moleculeGroup, expName, isosToTake, correctionFactors.get(standName), respectDilution, standMethod, corrStandard);
                        if (standardsStatistics.get(standName).getAmountIsotopesFoundInAll() < i) {
                            expValue = this.correctAreaCorrespondingly(oneStandardSeveralExps.get(expName).getTheoreticalIsotopeValue(this.elementParser_, i), moleculeGroup, expName, 1, correctionFactors.get(standName), respectDilution, standMethod, corrStandard);
                        }
                        correctiveFactors.add((Double)refAreas.get(i - 1) / (expValue /= correctionFactors.get(standName).get(bestExp).doubleValue()));
                    }
                    standCorrect.put(currentType, correctiveFactors);
                    groupCorectiveFactors.put(expName, standCorrect);
                    continue;
                }
                Vector<Double> correctiveFactors = new Vector<Double>();
                for (int i = 1; i != this.maxIsotopesOfGroup_.get(moleculeGroup) + 1; ++i) {
                    correctiveFactors.add(Double.NaN);
                }
                Hashtable<Integer, Vector<Double>> standCorrect = new Hashtable<Integer, Vector<Double>>();
                if (groupCorectiveFactors.containsKey(expName)) {
                    standCorrect = groupCorectiveFactors.get(expName);
                }
                standCorrect.put(currentType, correctiveFactors);
                groupCorectiveFactors.put(expName, standCorrect);
            }
            groupRefAreas.put(currentType, refAreas);
            correctionType.put(standName, currentType);
        }
    }

    public Hashtable<String, Boolean> getISAvailability() {
        Hashtable<String, Boolean> availability = new Hashtable<String, Boolean>();
        for (String molGroupName : this.allResults_.keySet()) {
            boolean available = false;
            if (this.allISNames_.containsKey(molGroupName) && ((Hashtable)this.allISNames_.get(molGroupName)).size() > 0) {
                available = true;
            }
            availability.put(molGroupName, available);
        }
        return availability;
    }

    public Hashtable<String, Boolean> getESAvailability() {
        Hashtable<String, Boolean> availability = new Hashtable<String, Boolean>();
        for (String molGroupName : this.allResults_.keySet()) {
            boolean available = false;
            if (this.allESNames_.containsKey(molGroupName) && ((Hashtable)this.allESNames_.get(molGroupName)).size() > 0) {
                available = true;
            }
            availability.put(molGroupName, available);
        }
        return availability;
    }

    public Hashtable<String, Hashtable<String, Double>> getDilutionFactors() {
        Hashtable<String, Hashtable<String, Double>> dilutionFactors = new Hashtable<String, Hashtable<String, Double>>();
        for (String groupName : this.allResults_.keySet()) {
            LipidClassSettingVO setVO = this.absSetting_.getClassSettings().get(groupName);
            dilutionFactors.put(groupName, setVO.getDilutionFactors());
        }
        return dilutionFactors;
    }

    public boolean hasAbsoluteSettings() {
        return this.absSetting_ != null;
    }

    private void extractISAmountValues() {
        this.isAmountLookup_ = new Hashtable();
        for (String groupName : this.allResults_.keySet()) {
            Hashtable<Integer, VolumeConcVO> lookups = new Hashtable<Integer, VolumeConcVO>();
            if (this.absSetting_ != null && ((Hashtable)this.allISNames_.get(groupName)).size() > 0) {
                this.extractAmountValues(lookups, this.absSetting_.getClassSettings().get(groupName).getIsStandards(), this.standardsOrderedConcerningReliability_.get(groupName), this.bestExpForStandard_.get(groupName), this.correctionTypeISLookup_.get(groupName));
            }
            this.isAmountLookup_.put(groupName, lookups);
        }
    }

    private void extractESAmountValues() {
        this.esAmountLookup_ = new Hashtable();
        for (String groupName : this.allResults_.keySet()) {
            Hashtable<Integer, VolumeConcVO> lookups = new Hashtable<Integer, VolumeConcVO>();
            if (this.absSetting_ != null && ((Hashtable)this.allESNames_.get(groupName)).size() > 0) {
                this.extractAmountValues(lookups, this.absSetting_.getClassSettings().get(groupName).getEsStandards(), this.extstandsOrderedConcerningReliability_.get(groupName), this.bestExpForExtStandard_.get(groupName), this.correctionTypeESLookup_.get(groupName));
            }
            this.esAmountLookup_.put(groupName, lookups);
        }
    }

    private void extractAmountValues(Hashtable<Integer, VolumeConcVO> lookups, Hashtable<String, Hashtable<String, VolumeConcVO>> concHash, Vector<String> standardsOrdered, Hashtable<String, String> bestExps, Hashtable<String, Integer> standToInt) {
        String bestStand = standardsOrdered.get(0);
        String bestExp = bestExps.get(bestStand);
        lookups.put(1, concHash.get(bestStand).get(bestExp));
        lookups.put(2, concHash.get(bestStand).get(bestExp));
        for (String standard : standToInt.keySet()) {
            lookups.put(standToInt.get(standard), concHash.get(standard).get(bestExps.get(standard)));
        }
    }

    public Hashtable<String, Vector<String>> getModifications() {
        Hashtable<String, Vector<String>> returnHash = new Hashtable<String, Vector<String>>();
        for (String groupName : this.modifications_.keySet()) {
            Vector<String> modsAsVect = new Vector<String>();
            for (String modName : this.modifications_.get(groupName).keySet()) {
                modsAsVect.add(modName);
            }
            returnHash.put(groupName, modsAsVect);
        }
        return returnHash;
    }

    public double getModificationAreaOfAnalyte(String molGroup, String exp, String mol, String modification, int isotopes) {
        double area = 0.0;
        if (this.allResultsHash_.get(molGroup).containsKey(exp) && this.allResultsHash_.get(molGroup).get(exp).containsKey(mol)) {
            area = this.allResultsHash_.get(molGroup).get(exp).get(mol).getTotalAreaOfModification(modification, isotopes);
        }
        return area;
    }

    public boolean neglectRtInformation(String analyteName) {
        boolean neglectRt = false;
        if (this.getRtTolerance() == null || this.isSelectionPrefix_ != null && analyteName.startsWith(this.isSelectionPrefix_) || this.esSelectionPrefix_ != null && analyteName.startsWith(this.esSelectionPrefix_)) {
            neglectRt = true;
        }
        return neglectRt;
    }

    public Double getRtTolerance() {
        if (this.expRtGroupingTime_ > 0.0) {
            return this.expRtGroupingTime_;
        }
        return null;
    }

    public Vector<String> getExpsOfGroup(String group) {
        if (this.expNamesOfGroup_.containsKey(group)) {
            return this.expNamesOfGroup_.get(group);
        }
        return new Vector<String>();
    }

    @Override
    public ResultAreaVO getResultAreaVO(String molGroup, String molName, String expName) {
        ResultAreaVO areaVO = null;
        if (this.allResultsHash_.containsKey(molGroup) && this.allResultsHash_.get(molGroup).containsKey(expName) && this.allResultsHash_.get(molGroup).get(expName).containsKey(molName)) {
            areaVO = this.allResultsHash_.get(molGroup).get(expName).get(molName);
        }
        return areaVO;
    }

    public boolean isRtGrouped() {
        return this.expRtGroupingTime_ > 0.0;
    }

    private boolean areThereHitsOutsideClusterRange(String groupName, String molName, Vector<String> fileNames, Hashtable<Integer, Double> rtClusters, Hashtable<String, Set<String>> usedRts, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>>> resultsInHash) {
        boolean anyFound = false;
        boolean outsideDetected = false;
        for (String fileName : fileNames) {
            if (!resultsInHash.containsKey(fileName) || !resultsInHash.get(fileName).containsKey(groupName) || !resultsInHash.get(fileName).get(groupName).containsKey(molName) || resultsInHash.get(fileName).get(groupName).get(molName).size() == 0) continue;
            anyFound = true;
            Hashtable<String, ResultAreaVO> results = resultsInHash.get(fileName).get(groupName).get(molName);
            for (String rtHitString : results.keySet()) {
                if (outsideDetected) break;
                if (usedRts.containsKey(fileName) && usedRts.get(fileName).contains(rtHitString)) continue;
                double rtHit = Double.parseDouble(rtHitString);
                boolean insideACluster = false;
                for (double rt : rtClusters.values()) {
                    if (!this.isWithinRtGroupingBoundaries(rtHit, rt)) continue;
                    insideACluster = true;
                    break;
                }
                if (insideACluster) continue;
                outsideDetected = true;
            }
            if (!outsideDetected) continue;
            break;
        }
        if (!anyFound) {
            return false;
        }
        return outsideDetected;
    }

    private String[] findStrongestHitOutsideExistingClusters(String groupName, String molName, Vector<String> fileNames, Hashtable<Integer, Double> rtClusters, Hashtable<String, Set<String>> usedRts, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>>> resultsInHash) {
        String[] fileNameAndRt = new String[2];
        double highestArea = 0.0;
        for (String fileName : fileNames) {
            if (!resultsInHash.containsKey(fileName) || !resultsInHash.get(fileName).containsKey(groupName) || !resultsInHash.get(fileName).get(groupName).containsKey(molName) || resultsInHash.get(fileName).get(groupName).get(molName).size() == 0) continue;
            Hashtable<String, ResultAreaVO> results = resultsInHash.get(fileName).get(groupName).get(molName);
            for (String rtHitString : results.keySet()) {
                ResultAreaVO result;
                double area;
                if (usedRts.containsKey(fileName) && usedRts.get(fileName).contains(rtHitString)) continue;
                double rtHit = Double.parseDouble(rtHitString);
                boolean inCluster = false;
                for (double rt : rtClusters.values()) {
                    if (!this.isWithinRtGroupingBoundaries(rtHit, rt)) continue;
                    inCluster = true;
                    break;
                }
                if (inCluster || (area = (result = results.get(rtHitString)).getTotalArea(Integer.MAX_VALUE)) < highestArea) continue;
                highestArea = area;
                fileNameAndRt[0] = fileName;
                fileNameAndRt[1] = rtHitString;
            }
        }
        return fileNameAndRt;
    }

    private void addClosestPeaksToCluster(int clusterId, String strongestFile, String groupName, String molName, String strongestRt, Vector<String> fileNames, Hashtable<String, Set<String>> usedRts, Hashtable<Integer, Hashtable<String, Hashtable<String, ResultAreaVO>>> clusters, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>>> resultsInHash) {
        ResultAreaVO strongestHit = resultsInHash.get(strongestFile).get(groupName).get(molName).get(strongestRt);
        double strongRt = Double.parseDouble(strongestRt);
        Hashtable closest = new Hashtable();
        for (String fileName : fileNames) {
            if (fileName.equalsIgnoreCase(strongestFile) || !resultsInHash.containsKey(fileName) || !resultsInHash.get(fileName).containsKey(groupName) || !resultsInHash.get(fileName).get(groupName).containsKey(molName) || resultsInHash.get(fileName).get(groupName).get(molName).size() == 0) continue;
            Hashtable<String, ResultAreaVO> results = resultsInHash.get(fileName).get(groupName).get(molName);
            String closestRt = null;
            for (String string : results.keySet()) {
                double rtHit;
                if (usedRts.containsKey(fileName) && usedRts.get(fileName).contains(string) || !this.isWithinRtGroupingBoundaries(rtHit = Double.parseDouble(string), strongRt) || closestRt != null && !(Math.abs(rtHit - strongRt) < Math.abs(Double.valueOf(closestRt) - strongRt))) continue;
                closestRt = string;
            }
            if (closestRt == null) continue;
            Hashtable<String, ResultAreaVO> closestHash = new Hashtable<String, ResultAreaVO>();
            closestHash.put(closestRt, results.get(closestRt));
            closest.put(fileName, closestHash);
        }
        Hashtable cluster = new Hashtable();
        HashSet<String> rts = new HashSet<String>();
        Hashtable<String, ResultAreaVO> oneFile = new Hashtable<String, ResultAreaVO>();
        oneFile.put(strongestRt, strongestHit);
        rts.add(strongestRt);
        cluster.put(strongestFile, oneFile);
        usedRts.put(strongestFile, rts);
        if (closest.size() > 0) {
            float[] differenceToStrongest = new float[closest.size()];
            int count = 0;
            for (String fileName : closest.keySet()) {
                differenceToStrongest[count] = Math.abs(Float.parseFloat((String)((Hashtable)closest.get(fileName)).keySet().iterator().next()) - (float)strongRt);
                ++count;
            }
            float f = Calculator.median(differenceToStrongest).floatValue();
            for (String fileName : closest.keySet()) {
                String rt = (String)((Hashtable)closest.get(fileName)).keySet().iterator().next();
                float diff = Math.abs(Float.parseFloat(rt) - (float)strongRt);
                if ((double)diff > 1.2 * (double)f) continue;
                rts = new HashSet();
                oneFile = new Hashtable();
                oneFile.put(rt, (ResultAreaVO)((Hashtable)closest.get(fileName)).get(rt));
                rts.add(rt);
                cluster.put(fileName, oneFile);
                usedRts.put(fileName, rts);
            }
        }
        clusters.put(clusterId, cluster);
    }

    private void addAreaWeightedMeanRt(Hashtable<Integer, Double> rtClusters, int clusterId, Hashtable<String, Hashtable<String, ResultAreaVO>> cluster) {
        double totalArea = 0.0;
        double rtTimesArea = 0.0;
        for (Hashtable<String, ResultAreaVO> vos : cluster.values()) {
            for (ResultAreaVO vo : vos.values()) {
                double rt = Double.parseDouble(vo.getRt());
                double area = vo.getTotalArea(Integer.MAX_VALUE);
                totalArea += area;
                rtTimesArea += area * rt;
            }
        }
        rtClusters.put(clusterId, rtTimesArea / totalArea);
    }

    private void addRemainingPeaksToClosestClusters(Hashtable<Integer, Double> rtClusters, Hashtable<Integer, Hashtable<String, Hashtable<String, ResultAreaVO>>> valuesInClusters, Hashtable<String, Set<String>> usedRts, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, ResultAreaVO>>>> resultsInHash, String groupName, String molName, Vector<String> fileNames) {
        for (String fileName : fileNames) {
            if (!resultsInHash.containsKey(fileName) || !resultsInHash.get(fileName).containsKey(groupName) || !resultsInHash.get(fileName).get(groupName).containsKey(molName) || resultsInHash.get(fileName).get(groupName).get(molName).size() == 0) continue;
            Hashtable<String, ResultAreaVO> results = resultsInHash.get(fileName).get(groupName).get(molName);
            for (String rtHitString : results.keySet()) {
                if (usedRts.containsKey(fileName) && usedRts.get(fileName).contains(rtHitString)) continue;
                double rtHit = Double.parseDouble(rtHitString);
                int bestClusterId = -1;
                double smallestDiff = Double.MAX_VALUE;
                for (Integer clusterId : rtClusters.keySet()) {
                    double rtCluster = rtClusters.get(clusterId);
                    double diff = Math.abs(rtCluster - rtHit);
                    if (!(diff < smallestDiff)) continue;
                    smallestDiff = diff;
                    bestClusterId = clusterId;
                }
                ResultAreaVO areaVO = results.get(rtHitString);
                Hashtable<String, Hashtable<String, ResultAreaVO>> oneCluster = valuesInClusters.get(bestClusterId);
                Hashtable<String, ResultAreaVO> inCluster = new Hashtable<String, ResultAreaVO>();
                if (oneCluster.containsKey(fileName)) {
                    inCluster = oneCluster.get(fileName);
                }
                inCluster.put(areaVO.getRt(), areaVO);
                oneCluster.put(fileName, inCluster);
                valuesInClusters.put(bestClusterId, oneCluster);
                Set<Object> rts = new HashSet();
                if (usedRts.containsKey(fileName)) {
                    rts = usedRts.get(fileName);
                }
                usedRts.put(fileName, rts);
            }
        }
    }

    private boolean clusterOverlap(Hashtable<Integer, Double> rtClusters) {
        for (int i = 0; i != rtClusters.size(); ++i) {
            double firstRt = rtClusters.get(i);
            for (int j = i + 1; j < rtClusters.size(); ++j) {
                double secondRt = rtClusters.get(j);
                if (!this.isWithinRtGroupingBoundaries(firstRt, secondRt)) continue;
                return true;
            }
        }
        return false;
    }

    private int[] detectClosestOverlap(Hashtable<Integer, Double> rtClusters) {
        double lowestOverlap = this.expRtGroupingTime_;
        int[] clusterIds = new int[2];
        for (int i = 0; i != rtClusters.size(); ++i) {
            double firstRt = rtClusters.get(i);
            for (int j = i + 1; j < rtClusters.size(); ++j) {
                double overlap;
                double secondRt = rtClusters.get(j);
                if (!this.isWithinRtGroupingBoundaries(firstRt, secondRt) || (overlap = Math.abs(firstRt - secondRt)) > lowestOverlap) continue;
                clusterIds[0] = i;
                clusterIds[1] = j;
            }
        }
        return clusterIds;
    }

    private void uniteTwoClusters(int id1, int id2, Hashtable<Integer, Hashtable<String, Hashtable<String, ResultAreaVO>>> valuesInClusters) {
        int lower = id1;
        int upper = id2;
        if (lower > upper) {
            lower = id2;
            upper = id1;
        }
        Hashtable<String, Hashtable<String, ResultAreaVO>> strongerCluster = valuesInClusters.get(lower);
        Hashtable<String, Hashtable<String, ResultAreaVO>> weakerCluster = valuesInClusters.get(upper);
        for (String fileName : weakerCluster.keySet()) {
            Hashtable<Object, Object> toAdd = new Hashtable();
            if (strongerCluster.containsKey(fileName)) {
                toAdd = strongerCluster.get(fileName);
            }
            Hashtable<String, ResultAreaVO> toBeAdded = weakerCluster.get(fileName);
            for (String rt : toBeAdded.keySet()) {
                toAdd.put(rt, toBeAdded.get(rt));
            }
            strongerCluster.put(fileName, toAdd);
        }
        int count = upper;
        while (count + 1 < valuesInClusters.size()) {
            valuesInClusters.put(count, valuesInClusters.get(count + 1));
            ++count;
        }
        valuesInClusters.remove(valuesInClusters.size() - 1);
    }

    @Override
    protected void disableRtGrouping() {
        this.expRtGroupingTime_ = -1.0;
    }

    Vector<Vector<Boolean>> getAllPossibleCombinations(int size) {
        Vector<Vector<Boolean>> combis = new Vector<Vector<Boolean>>();
        if (size > 1) {
            Vector<Boolean> newCombi;
            Vector<Vector<Boolean>> otherCombis = this.getAllPossibleCombinations(size - 1);
            for (Vector<Boolean> combi : otherCombis) {
                newCombi = new Vector<Boolean>(combi);
                newCombi.add(0, true);
                combis.add(newCombi);
            }
            for (Vector<Boolean> combi : otherCombis) {
                newCombi = new Vector<Boolean>(combi);
                newCombi.add(0, false);
                combis.add(newCombi);
            }
        } else {
            Vector<Boolean> newCombi = new Vector<Boolean>();
            newCombi.add(true);
            combis.add(newCombi);
            newCombi = new Vector();
            newCombi.add(false);
            combis.add(newCombi);
        }
        return combis;
    }

    public HydroxyEncoding getFaHydroxyEncoding() {
        return this.faHydroxyEncoding_;
    }

    public HydroxyEncoding getLcbHydroxyEncoding() {
        return this.lcbHydroxyEncoding_;
    }

    public Hashtable<String, Integer> getNrOfChainsOfClass() {
        return this.chainsOfClass_;
    }

    public boolean isISorES(String className, String analyteName) {
        if (this.allISNames_.containsKey(className) && ((Hashtable)this.allISNames_.get(className)).containsKey(analyteName)) {
            return true;
        }
        return this.allESNames_.containsKey(className) && ((Hashtable)this.allESNames_.get(className)).containsKey(analyteName);
    }
}

