/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.analysis;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.analysis.vos.IsoLocationSpaces;
import at.tugraz.genome.lda.analysis.vos.IsoOverlapVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import java.util.Hashtable;
import java.util.Vector;

public class IsotopeCorrector {
    private static final int ISO_MAX_CORRECTION = 5;

    public static Hashtable<String, Vector<LipidParameterSet>> correctIsotopicPattern(ElementConfigParser elementParser, Hashtable<String, Vector<LipidParameterSet>> toCorrect) throws SpectrummillParserException {
        IsoOverlapVO overlap;
        Hashtable<String, LipidParameterSet> correctedParams = new Hashtable<String, LipidParameterSet>();
        Hashtable<String, LipidParameterSet> forCorrection = new Hashtable<String, LipidParameterSet>();
        Hashtable<String, IsoOverlapVO> correctionInfo = new Hashtable<String, IsoOverlapVO>();
        for (String group1 : toCorrect.keySet()) {
            Vector<LipidParameterSet> mols1 = toCorrect.get(group1);
            for (LipidParameterSet mol : mols1) {
                String analId = IsotopeCorrector.uniqueId(group1, mol.getNameIncludingModification());
                overlap = new IsoOverlapVO(analId, mol.getIsotopicProbes().size());
                for (String group2 : toCorrect.keySet()) {
                    Vector<LipidParameterSet> mols2 = toCorrect.get(group2);
                    for (LipidParameterSet compare : mols2) {
                        IsoLocationSpaces overlapLocation;
                        if (group1.equalsIgnoreCase(group2) && mol.getNameIncludingModification().equalsIgnoreCase(compare.getNameIncludingModification()) || !(overlapLocation = IsotopeCorrector.checkIsotopicOverlap(elementParser, mol, compare, group2)).hasOverlap()) continue;
                        overlap.addOverlapLocation(overlapLocation);
                    }
                }
                if (overlap.hasOverlap()) {
                    forCorrection.put(overlap.getId(), mol);
                    correctionInfo.put(overlap.getId(), overlap);
                    continue;
                }
                correctedParams.put(analId, mol);
            }
        }
        int latestSize = forCorrection.size();
        Hashtable<String, String> removedAnalytes = new Hashtable<String, String>();
        while (forCorrection.size() > 0) {
            Hashtable<String, String> correctedIds = new Hashtable<String, String>();
            for (String id : forCorrection.keySet()) {
                LipidParameterSet anal = (LipidParameterSet)forCorrection.get(id);
                overlap = (IsoOverlapVO)correctionInfo.get(id);
                if (!overlap.isCorrectionPossible(correctedParams, removedAnalytes)) continue;
                if (overlap.reinitOverlapLocations(anal, correctedParams, 5)) {
                    LipidParameterSet analCorrected = overlap.makeIsotopicCorrection(anal);
                    if (analCorrected.getArea() > 0.0f) {
                        correctedParams.put(id, anal);
                    } else {
                        removedAnalytes.put(id, id);
                    }
                } else {
                    correctedParams.put(id, anal);
                }
                correctedIds.put(id, id);
            }
            for (String id : correctedIds.keySet()) {
                forCorrection.remove(id);
                correctionInfo.remove(id);
            }
            if (latestSize == forCorrection.size()) break;
            latestSize = forCorrection.size();
        }
        Hashtable<String, Vector<LipidParameterSet>> corrected = new Hashtable<String, Vector<LipidParameterSet>>();
        for (String group : toCorrect.keySet()) {
            Vector<LipidParameterSet> mols = toCorrect.get(group);
            Vector<LipidParameterSet> corr = new Vector<LipidParameterSet>();
            for (LipidParameterSet mol : mols) {
                String analId = IsotopeCorrector.uniqueId(group, mol.getNameIncludingModification());
                if (correctedParams.containsKey(analId)) {
                    corr.add(correctedParams.get(analId));
                    continue;
                }
                if (removedAnalytes.containsKey(analId)) continue;
                corr.add(mol);
                System.out.println("!!!!!!!!!!!!!! " + group + " " + mol.getNameString() + " was not corrected " + analId);
            }
            corrected.put(group, corr);
        }
        return corrected;
    }

    private static IsoLocationSpaces checkIsotopicOverlap(ElementConfigParser elementParser, LipidParameterSet toCheck, LipidParameterSet overlapping, String overlapGroup) throws SpectrummillParserException {
        IsoLocationSpaces over = new IsoLocationSpaces(IsotopeCorrector.uniqueId(overlapGroup, overlapping.getNameIncludingModification()), 5);
        if (toCheck.Mz[0] + 5.0f * LipidomicsConstants.getNeutronMass() + LipidomicsConstants.getCoarseChromMzTolerance(toCheck.Mz[0]) > overlapping.Mz[0] && toCheck.Mz[0] - 5.0f * LipidomicsConstants.getNeutronMass() - LipidomicsConstants.getCoarseChromMzTolerance(toCheck.Mz[0]) < overlapping.Mz[0]) {
            Vector<Double> negDistri;
            boolean negative = false;
            Vector<Vector<Double>> bothDistris = elementParser.calculateChemicalFormulaIntensityDistribution(overlapping.getChemicalFormula(), 5, false);
            Vector<Double> distri = bothDistris.get(0);
            if (bothDistris.size() > 1 && StaticUtils.useNegativeDistribution(distri, negDistri = bothDistris.get(1))) {
                distri = negDistri;
                negative = true;
            }
            if (!negative && toCheck.Mz[0] > overlapping.Mz[0] + LipidomicsConstants.getCoarseChromMzTolerance(toCheck.Mz[0]) || negative && toCheck.Mz[0] < overlapping.Mz[0] - LipidomicsConstants.getCoarseChromMzTolerance(toCheck.Mz[0])) {
                over.setParameterSet(overlapping, distri, negative);
                over.determineOverlappingParts(toCheck);
            }
        }
        return over;
    }

    private static String uniqueId(String overlapGroup, String paramName) {
        return overlapGroup + "_-" + paramName;
    }
}

