/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.analysis.vos;

import at.tugraz.genome.lda.analysis.vos.IsoLocationSpaces;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.util.Hashtable;
import java.util.Vector;

public class IsoOverlapVO {
    private String analyte_;
    private Hashtable<Integer, Vector<Integer>> isoAffectedBy_;
    private Vector<IsoLocationSpaces> overlapingPeaks_;

    public IsoOverlapVO(String name, int maxIsos) {
        this.analyte_ = name;
        this.initHashes();
    }

    private void initHashes() {
        this.isoAffectedBy_ = new Hashtable();
        this.overlapingPeaks_ = new Vector();
    }

    public boolean hasOverlap() {
        return this.overlapingPeaks_.size() != 0;
    }

    public void addOverlapLocation(IsoLocationSpaces overlapLocation) {
        if (!this.isTheSameParam(overlapLocation)) {
            int locNr = this.overlapingPeaks_.size();
            Vector<Integer> isos = overlapLocation.getAffectedIsos();
            for (Integer iso : isos) {
                Vector<Integer> overlapLocs = new Vector<Integer>();
                if (this.isoAffectedBy_.containsKey(iso)) {
                    overlapLocs = this.isoAffectedBy_.get(iso);
                }
                overlapLocs.add(locNr);
                this.isoAffectedBy_.put(iso, overlapLocs);
            }
            this.overlapingPeaks_.add(overlapLocation);
        }
    }

    private boolean isTheSameParam(IsoLocationSpaces overlapLocation) {
        boolean isTheSameThere = false;
        for (IsoLocationSpaces overlap : this.overlapingPeaks_) {
            if (!overlap.isTheSame(overlapLocation)) continue;
            isTheSameThere = true;
        }
        return isTheSameThere;
    }

    public String getId() {
        return this.analyte_;
    }

    public boolean isCorrectionPossible(Hashtable<String, LipidParameterSet> correctedParams, Hashtable<String, String> removed) {
        for (IsoLocationSpaces overlap : this.overlapingPeaks_) {
            if (correctedParams.containsKey(overlap.getId()) || removed.containsKey(overlap.getId())) continue;
            return false;
        }
        return true;
    }

    public LipidParameterSet makeIsotopicCorrection(LipidParameterSet toCorrect) {
        Vector<Vector<CgProbe>> probesToCorrect = toCorrect.getIsotopicProbes();
        Vector<Vector<CgProbe>> correctedProbes = new Vector<Vector<CgProbe>>();
        float totalArea = 0.0f;
        for (int iso = 0; iso != probesToCorrect.size(); ++iso) {
            Vector<Object> corrected = new Vector();
            if (this.isoAffectedBy_.containsKey(iso)) {
                Vector<CgProbe> uncorrected = probesToCorrect.get(iso);
                Vector<Integer> vector = this.isoAffectedBy_.get(iso);
                for (int probeNr = 0; probeNr != uncorrected.size(); ++probeNr) {
                    CgProbe probe = this.correctProbe(uncorrected.get(probeNr), iso, probeNr, vector);
                    if (!(probe.Area > 0.0f)) continue;
                    corrected.add(probe);
                }
            } else {
                corrected = probesToCorrect.get(iso);
            }
            for (CgProbe cgProbe : corrected) {
                totalArea += cgProbe.Area;
            }
            if (corrected.size() <= 0) break;
            correctedProbes.add(corrected);
        }
        toCorrect.setIsotopicProbes(correctedProbes);
        toCorrect.Area = totalArea;
        return toCorrect;
    }

    private CgProbe correctProbe(CgProbe toCorrect, int iso, int probeNr, Vector<Integer> requLocs) {
        boolean hasToBeCorrected = false;
        for (Integer locNr : requLocs) {
            IsoLocationSpaces overlap = this.overlapingPeaks_.get(locNr);
            if (overlap.getOverlapsOfIso(iso, probeNr).size() <= 0) continue;
            hasToBeCorrected = true;
            break;
        }
        if (hasToBeCorrected) {
            float area = toCorrect.Area;
            for (Integer locNr : requLocs) {
                IsoLocationSpaces overlap = this.overlapingPeaks_.get(locNr);
                area -= overlap.getOtherIsotopeArea(iso, probeNr);
            }
            toCorrect.Area = area;
            return toCorrect;
        }
        return toCorrect;
    }

    public boolean reinitOverlapLocations(LipidParameterSet set, Hashtable<String, LipidParameterSet> correctedParams, int maxIso) {
        Vector<String> overlapIds = new Vector<String>();
        Hashtable<Integer, Boolean> negative = new Hashtable<Integer, Boolean>();
        Hashtable<Integer, Vector<Double>> distris = new Hashtable<Integer, Vector<Double>>();
        int count = 0;
        for (IsoLocationSpaces loc : this.overlapingPeaks_) {
            overlapIds.add(loc.getId());
            negative.put(count, loc.getNegative());
            distris.put(count, loc.getDistri());
            ++count;
        }
        this.initHashes();
        boolean hasStillOverlap = false;
        for (int i = 0; i != overlapIds.size(); ++i) {
            String id = (String)overlapIds.get(i);
            if (!correctedParams.containsKey(id)) continue;
            LipidParameterSet overlapSet = correctedParams.get(id);
            IsoLocationSpaces over = new IsoLocationSpaces(id, maxIso);
            over.setParameterSet(overlapSet, (Vector)distris.get(i), (Boolean)negative.get(i));
            over.determineOverlappingParts(set);
            if (!over.hasOverlap()) continue;
            this.addOverlapLocation(over);
            hasStillOverlap = true;
        }
        return hasStillOverlap;
    }
}

