/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.export;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.analysis.ComparativeResultsLookup;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.ExportException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.RetentionTimeGroupingException;
import at.tugraz.genome.lda.export.LDAExporter;
import at.tugraz.genome.lda.export.OmegaCollector;
import at.tugraz.genome.lda.export.vos.SpeciesExportVO;
import at.tugraz.genome.lda.export.vos.SummaryVO;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.parser.LDAResultReader;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.swing.LipidomicsTableCellRenderer;
import at.tugraz.genome.lda.utils.ExcelUtils;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.lda.vos.ExportOptionsVO;
import at.tugraz.genome.lda.vos.ResultAreaVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.apache.commons.math3.util.Pair;
import org.apache.commons.math3.util.Precision;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelAndTextExporter
extends LDAExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToFile(boolean includeResultFiles, short speciesType, boolean exportDoubleBondPositionsForClass, String sheetName, OutputStream out, boolean excelFile, int maxIsotope, Vector<String> molNames, boolean isRtGrouped, boolean isGrouped, Vector<String> expIdNames, Hashtable<String, String> expNames, LinkedHashMap<String, String> expFullPaths, LinkedHashMap<String, Vector<String>> expsOfGroup, Hashtable<String, Hashtable<String, Vector<Double>>> results, String preferredUnit, String headerText, ExportOptionsVO expVO, ComparativeResultsLookup compLookup, ArrayList<String> modifications) throws ExportException, SpectrummillParserException, ExcelInputFileException, IOException, LipidCombinameEncodingException, RetentionTimeGroupingException {
        Hashtable<String, QuantificationResult> originalExcelResults = new Hashtable<String, QuantificationResult>();
        HydroxyEncoding faEncoding = null;
        HydroxyEncoding lcbEncoding = null;
        for (String expId : expFullPaths.keySet()) {
            QuantificationResult result = LDAResultReader.readResultFile(expFullPaths.get(expId), new Hashtable<String, Boolean>(), sheetName);
            if (result.getFaHydroxyEncoding() != null) {
                faEncoding = result.getFaHydroxyEncoding();
            }
            if (result.getLcbHydroxyEncoding() != null) {
                lcbEncoding = result.getLcbHydroxyEncoding();
            }
            originalExcelResults.put(expId, result);
        }
        LinkedHashMap<String, Boolean> adductsSorted = ExcelAndTextExporter.extractAdductsSortedByAbundance(sheetName, originalExcelResults);
        boolean rtGroupingUsed = isRtGrouped;
        LinkedHashMap<String, SummaryVO> molSpeciesDetails = new LinkedHashMap<String, SummaryVO>();
        for (String molName : molNames) {
            Hashtable<String, Hashtable<String, Vector<LipidParameterSet>>> relevantOriginals = null;
            if (includeResultFiles) {
                relevantOriginals = new Hashtable<String, Hashtable<String, Vector<LipidParameterSet>>>();
                for (String expId : expFullPaths.keySet()) {
                    ResultAreaVO areaVO = compLookup.getResultAreaVO(sheetName, molName, expId);
                    if (!isGrouped && !expNames.containsKey(expId) || areaVO == null) continue;
                    if (areaVO.isAStandard()) {
                        rtGroupingUsed = false;
                    }
                    Hashtable<String, Vector<LipidParameterSet>> sets = ExcelAndTextExporter.getRelevantOriginalResults(originalExcelResults.get(expId).getIdentifications().get(sheetName), areaVO, false);
                    relevantOriginals.put(expId, sets);
                }
            }
            SpeciesExportVO exportVO = LDAExporter.extractExportableSummaryInformation(speciesType, exportDoubleBondPositionsForClass, false, 0, 0, false, 0, 0, rtGroupingUsed, adductsSorted, new Vector<String>(expFullPaths.keySet()), expsOfGroup, molName, results.get(molName), relevantOriginals, maxIsotope, faEncoding, lcbEncoding);
            for (SummaryVO sumVO : exportVO.getSummaries()) {
                String id = "";
                if (includeResultFiles) {
                    id = id + sheetName + " ";
                }
                id = id + sumVO.getSpeciesId();
                if (sumVO.getMolecularId() != null) {
                    id = id + " | " + sumVO.getMolecularId();
                }
                molSpeciesDetails.put(id, sumVO);
            }
        }
        try {
            ExcelAndTextExporter.writeToFile(sheetName, out, excelFile, molSpeciesDetails, isGrouped, expIdNames, expNames, expsOfGroup, preferredUnit, expVO, modifications);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void writeToFile(String sheetName, OutputStream out, boolean excelFile, LinkedHashMap<String, SummaryVO> molSpeciesDetails, boolean isGrouped, Vector<String> expIdNames, Hashtable<String, String> expNames, LinkedHashMap<String, Vector<String>> expsOfGroup, String preferredUnit, ExportOptionsVO expVO, ArrayList<String> modifications) throws IOException {
        XSSFWorkbook workbook = null;
        Sheet sheet = null;
        Row row = null;
        CellStyle headerStyle = null;
        CellStyle normalStyle = null;
        CellStyle zeroStyle = null;
        CellStyle ms2Unambiguous = null;
        CellStyle ms2Split = null;
        CellStyle ms2NoSplitPossible = null;
        if (excelFile) {
            workbook = new XSSFWorkbook();
            sheet = workbook.createSheet(sheetName);
            headerStyle = ExcelAndTextExporter.getHeaderStyle(workbook);
            normalStyle = ExcelAndTextExporter.getNormalStyle(workbook);
            zeroStyle = ExcelAndTextExporter.getZeroStyle(workbook);
            ms2Unambiguous = ExcelAndTextExporter.getMs2UnambiguousStyle(workbook);
            ms2Split = ExcelAndTextExporter.getMs2SplitStyle(workbook);
            ms2NoSplitPossible = ExcelAndTextExporter.getMs2NoSplitPossibleStyle(workbook);
            row = sheet.createRow(0);
        }
        boolean expInColumn = false;
        Vector<String> columnNames = new Vector<String>(molSpeciesDetails.keySet());
        Vector<String> rowNames = new Vector<String>(expIdNames);
        if (!expVO.isAnalyteInColumn()) {
            columnNames = new Vector<String>(expIdNames);
            rowNames = new Vector<String>(molSpeciesDetails.keySet());
            expInColumn = true;
        }
        StaticUtils.printOutLabelToFile(sheetName, out, row, headerStyle, (columnNames.size() + 2) / 2, excelFile, false);
        if (!excelFile) {
            out.write("\n".getBytes());
        }
        int rowCount = 1;
        int columnCount = 0;
        Hashtable<Integer, String> headerValues = new Hashtable<Integer, String>();
        Hashtable<Integer, Integer> longestValues = new Hashtable<Integer, Integer>();
        String unit = "Arb.Units / AU";
        if (preferredUnit != null && preferredUnit.length() > 0) {
            unit = preferredUnit;
        }
        String unitString = unit;
        if (excelFile) {
            row = sheet.createRow(rowCount);
        }
        StaticUtils.printOutLabelToFile(unitString, out, row, headerStyle, columnCount, excelFile, false);
        headerValues.put(columnCount, unitString);
        longestValues.put(columnCount, 0);
        StaticUtils.printOutLabelToFile("", out, row, headerStyle, ++columnCount, excelFile, true);
        headerValues.put(columnCount, "");
        longestValues.put(columnCount, 0);
        ++columnCount;
        Iterator<String> iterator = columnNames.iterator();
        while (iterator.hasNext()) {
            String columnName;
            String valueToPrint = columnName = iterator.next();
            if (expInColumn) {
                valueToPrint = expNames.get(columnName);
            }
            StaticUtils.printOutLabelToFile(valueToPrint, out, row, headerStyle, columnCount, excelFile, true);
            headerValues.put(columnCount, valueToPrint);
            longestValues.put(columnCount, 0);
            ++columnCount;
        }
        ++rowCount;
        if (excelFile) {
            row = sheet.createRow(rowCount);
        }
        if (!excelFile) {
            out.write("\n".getBytes());
        }
        for (String rowName : rowNames) {
            CellStyle style;
            columnCount = 0;
            String valueToPrint = rowName;
            if (!expInColumn) {
                valueToPrint = expNames.get(rowName);
            }
            StaticUtils.printOutLabelToFile(valueToPrint, out, row, headerStyle, columnCount, excelFile, false);
            if (valueToPrint.length() > ((String)headerValues.get(columnCount)).length()) {
                headerValues.put(columnCount, valueToPrint);
            }
            StaticUtils.printOutLabelToFile("Value", out, row, headerStyle, ++columnCount, excelFile, true);
            if ("Value".length() > ((String)headerValues.get(columnCount)).length()) {
                headerValues.put(columnCount, "Value");
            }
            ++columnCount;
            for (String string : columnNames) {
                String toWrite = "0";
                String molName = string;
                String expName = rowName;
                if (!expVO.isAnalyteInColumn()) {
                    molName = rowName;
                    expName = string;
                }
                SummaryVO sumVO = molSpeciesDetails.get(molName);
                double area = isGrouped ? sumVO.getMeanArea(expName).doubleValue() : sumVO.getArea(expName).doubleValue();
                toWrite = StaticUtils.extractDisplayValue(area, expVO.getCommaPositions());
                CellStyle style2 = null;
                style2 = toWrite.equalsIgnoreCase("0") || toWrite.equalsIgnoreCase("0.0") ? zeroStyle : ExcelAndTextExporter.getCorrespondingCellStyle(sumVO.getEvidenceReliabilty(expName), normalStyle, ms2Unambiguous, ms2Split, ms2NoSplitPossible);
                StaticUtils.printOutNumberToFile(toWrite, out, row, style2, columnCount, excelFile, true);
                if (toWrite.length() > (Integer)longestValues.get(columnCount)) {
                    longestValues.put(columnCount, toWrite.length());
                }
                ++columnCount;
            }
            ++rowCount;
            if (excelFile) {
                row = sheet.createRow(rowCount);
            }
            if (!excelFile) {
                out.write("\n".getBytes());
            }
            if (expVO != null && expVO.getExportType() != 0) {
                columnCount = 0;
                StaticUtils.printOutLabelToFile("", out, row, headerStyle, columnCount, excelFile, false);
                ++columnCount;
                String title = "";
                if (expVO.getExportType() == 1) {
                    title = title + "SD-" + expVO.getSdValue();
                } else if (expVO.getExportType() == 2) {
                    title = title + "SE";
                }
                StaticUtils.printOutLabelToFile(title, out, row, headerStyle, columnCount, excelFile, true);
                if (title.length() > ((String)headerValues.get(columnCount)).length()) {
                    headerValues.put(columnCount, title);
                }
                ++columnCount;
                for (String columnName2 : columnNames) {
                    SummaryVO sumVO;
                    double value;
                    Object toWrite = "-1.0";
                    String molName = columnName2;
                    String expName = rowName;
                    if (!expVO.isAnalyteInColumn()) {
                        molName = rowName;
                        expName = columnName2;
                    }
                    if (!Double.isInfinite(value = (sumVO = molSpeciesDetails.get(molName)).calculateDeviationValue(expVO, expsOfGroup.get(expName))) && !Double.isNaN(value)) {
                        toWrite = StaticUtils.extractDisplayValue(value);
                    }
                    style = null;
                    style = ((String)toWrite).equalsIgnoreCase("-1") || ((String)toWrite).equalsIgnoreCase("-1.0") ? zeroStyle : ExcelAndTextExporter.getCorrespondingCellStyle(sumVO.getEvidenceReliabilty(expName), normalStyle, ms2Unambiguous, ms2Split, ms2NoSplitPossible);
                    StaticUtils.printOutNumberToFile((String)toWrite, out, row, style, columnCount, excelFile, true);
                    if (((String)toWrite).length() > (Integer)longestValues.get(columnCount)) {
                        longestValues.put(columnCount, ((String)toWrite).length());
                    }
                    ++columnCount;
                }
                ++rowCount;
                if (!excelFile) {
                    out.write("\n".getBytes());
                } else {
                    row = sheet.createRow(rowCount);
                }
            }
            for (String string : modifications) {
                if (expVO != null && expVO.isExportRT()) {
                    columnCount = 0;
                    StaticUtils.printOutLabelToFile("", out, row, headerStyle, columnCount, excelFile, false);
                    ++columnCount;
                    String rtName = "RT";
                    if (modifications.size() > 1) {
                        rtName = rtName + "-" + string;
                    }
                    StaticUtils.printOutLabelToFile(rtName, out, row, headerStyle, columnCount, excelFile, true);
                    if (rtName.length() > ((String)headerValues.get(columnCount)).length()) {
                        headerValues.put(columnCount, rtName);
                    }
                    ++columnCount;
                    for (String columnName : columnNames) {
                        String toWrite = "-1.0";
                        String molName = columnName;
                        String expName = rowName;
                        if (!expVO.isAnalyteInColumn()) {
                            molName = rowName;
                            expName = columnName;
                        }
                        SummaryVO sumVO = molSpeciesDetails.get(molName);
                        Double rt = isGrouped ? sumVO.getMeanRetentionTime(string, expName) : sumVO.getRetentionTime(string, expName);
                        if (rt != null && !Double.isInfinite(rt) && !Double.isNaN(rt)) {
                            toWrite = StaticUtils.extractDisplayValue(rt);
                        }
                        CellStyle style3 = null;
                        style3 = toWrite.equalsIgnoreCase("-1") || toWrite.equalsIgnoreCase("-1.0") ? zeroStyle : ExcelAndTextExporter.getCorrespondingCellStyle(sumVO.getEvidenceReliabilty(expName), normalStyle, ms2Unambiguous, ms2Split, ms2NoSplitPossible);
                        StaticUtils.printOutNumberToFile(toWrite, out, row, style3, columnCount, excelFile, true);
                        if (toWrite.length() > (Integer)longestValues.get(columnCount)) {
                            longestValues.put(columnCount, toWrite.length());
                        }
                        ++columnCount;
                    }
                    ++rowCount;
                    if (excelFile) {
                        row = sheet.createRow(rowCount);
                    } else {
                        out.write("\n".getBytes());
                    }
                }
                if (expVO == null || !expVO.isExportRTDev()) continue;
                columnCount = 0;
                StaticUtils.printOutLabelToFile("", out, row, headerStyle, columnCount, excelFile, false);
                StaticUtils.printOutLabelToFile("RT-StDev", out, row, headerStyle, ++columnCount, excelFile, true);
                if ("RT-StDev".length() > ((String)headerValues.get(columnCount)).length()) {
                    headerValues.put(columnCount, "RT-StDev");
                }
                ++columnCount;
                for (String columnName : columnNames) {
                    SummaryVO sumVO;
                    Double rtStdev;
                    String toWrite = "-1.0";
                    String molName = columnName;
                    String expName = rowName;
                    if (!expVO.isAnalyteInColumn()) {
                        molName = rowName;
                        expName = columnName;
                    }
                    if ((rtStdev = (sumVO = molSpeciesDetails.get(molName)).getStdevRetentionTime(string, expName)) != null && !Double.isInfinite(rtStdev) && !Double.isNaN(rtStdev)) {
                        toWrite = StaticUtils.extractDisplayValue(rtStdev);
                    }
                    style = null;
                    style = toWrite.equalsIgnoreCase("-1") || toWrite.equalsIgnoreCase("-1.0") ? zeroStyle : ExcelAndTextExporter.getCorrespondingCellStyle(sumVO.getEvidenceReliabilty(expName), normalStyle, ms2Unambiguous, ms2Split, ms2NoSplitPossible);
                    StaticUtils.printOutNumberToFile(toWrite, out, row, style, columnCount, excelFile, true);
                    ++columnCount;
                }
                ++rowCount;
                if (excelFile) {
                    row = sheet.createRow(rowCount);
                    continue;
                }
                out.write("\n".getBytes());
            }
        }
        if (excelFile) {
            Iterator<String> iterator2 = headerValues.keySet().iterator();
            while (iterator2.hasNext()) {
                int column = (Integer)((Object)iterator2.next());
                ExcelAndTextExporter.setColumnWidth(sheet, column, (String)headerValues.get(column), (Integer)longestValues.get(column));
            }
            workbook.write(out);
        }
    }

    private static CellStyle getNormalStyle(Workbook wb) {
        CellStyle arialStyle = wb.createCellStyle();
        Font arialfont = ExcelAndTextExporter.getArialFont(wb);
        arialStyle.setFont(arialfont);
        return arialStyle;
    }

    private static CellStyle getZeroStyle(Workbook wb) {
        CellStyle arialStyle = wb.createCellStyle();
        Font arialfont = ExcelAndTextExporter.getArialRedFont(wb);
        arialStyle.setFont(arialfont);
        return arialStyle;
    }

    private static CellStyle getHeaderStyle(Workbook wb) {
        CellStyle arial12style = wb.createCellStyle();
        Font arial12font = ExcelAndTextExporter.getArial12BoldFont(wb);
        arial12style.setFont(arial12font);
        arial12style.setAlignment((short)2);
        return arial12style;
    }

    private static CellStyle getMs2UnambiguousStyle(XSSFWorkbook wb) {
        XSSFCellStyle arialStyleGreen = wb.createCellStyle();
        Font arialfont = ExcelAndTextExporter.getArialFont(wb);
        arialStyleGreen.setFont(arialfont);
        XSSFColor color = new XSSFColor(LipidomicsTableCellRenderer.BRIGHT_GREEN);
        arialStyleGreen.setFillForegroundColor(color);
        arialStyleGreen.setFillPattern((short)1);
        return arialStyleGreen;
    }

    private static CellStyle getMs2SplitStyle(XSSFWorkbook wb) {
        XSSFCellStyle arialStyleYellow = wb.createCellStyle();
        Font arialfont = ExcelAndTextExporter.getArialFont(wb);
        arialStyleYellow.setFont(arialfont);
        XSSFColor color = new XSSFColor(Color.YELLOW);
        arialStyleYellow.setFillForegroundColor(color);
        arialStyleYellow.setFillPattern((short)1);
        return arialStyleYellow;
    }

    private static CellStyle getMs2NoSplitPossibleStyle(XSSFWorkbook wb) {
        XSSFCellStyle arialStyleOrange = wb.createCellStyle();
        Font arialfont = ExcelAndTextExporter.getArialFont(wb);
        arialStyleOrange.setFont(arialfont);
        XSSFColor color = new XSSFColor(Color.ORANGE);
        arialStyleOrange.setFillForegroundColor(color);
        arialStyleOrange.setFillPattern((short)1);
        return arialStyleOrange;
    }

    private static Font getArial12BoldFont(Workbook wb) {
        Font arial12font = ExcelAndTextExporter.getArialFont(wb);
        arial12font.setFontHeightInPoints((short)12);
        arial12font.setBoldweight((short)700);
        return arial12font;
    }

    private static Font getArialRedFont(Workbook wb) {
        Font arialfont = ExcelAndTextExporter.getArialFont(wb);
        arialfont.setColor((short)10);
        return arialfont;
    }

    private static Font getArialFont(Workbook wb) {
        Font arial12font = wb.createFont();
        arial12font.setFontName("Arial");
        return arial12font;
    }

    private static void setColumnWidth(Sheet sheet, int column, String headerValue, int longestValue) {
        int columnWidth = (int)((double)(headerValue.length() * 256) * 1.4);
        if ((longestValue + 1) * 256 > columnWidth) {
            columnWidth = (longestValue + 1) * 256;
        }
        sheet.setColumnWidth(column, columnWidth);
    }

    private static CellStyle getCorrespondingCellStyle(short evidence, CellStyle normalStyle, CellStyle ms2Unambiguous, CellStyle ms2Split, CellStyle ms2NoSplitPossible) {
        if (evidence == 1) {
            return ms2Unambiguous;
        }
        if (evidence == 2) {
            return ms2Split;
        }
        if (evidence == 3) {
            return ms2NoSplitPossible;
        }
        return normalStyle;
    }

    public static void writeExcelSheetOmegaSummary(OmegaCollector omegaCollector, Sheet sheet, XSSFWorkbook workbook, OutputStream out, boolean includeResultFiles, short speciesType, boolean exportDoubleBondPositionsForClass, int maxIsotope, Vector<String> molNames, boolean isRtGrouped, boolean isGrouped, Vector<String> expIdNames, Hashtable<String, String> expNames, LinkedHashMap<String, String> expFullPaths, LinkedHashMap<String, Vector<String>> expsOfGroup, Hashtable<String, Hashtable<String, Vector<Double>>> results, String preferredUnit, String headerText, ExportOptionsVO expVO, ComparativeResultsLookup compLookup, ArrayList<String> modifications) throws ExportException, SpectrummillParserException, ExcelInputFileException, IOException, LipidCombinameEncodingException, RetentionTimeGroupingException {
        Hashtable<String, QuantificationResult> originalExcelResults = new Hashtable<String, QuantificationResult>();
        HydroxyEncoding faEncoding = null;
        HydroxyEncoding lcbEncoding = null;
        for (String expId : expFullPaths.keySet()) {
            QuantificationResult result = LDAResultReader.readResultFile(expFullPaths.get(expId), new Hashtable<String, Boolean>(), sheet.getSheetName());
            if (result.getFaHydroxyEncoding() != null) {
                faEncoding = result.getFaHydroxyEncoding();
            }
            if (result.getLcbHydroxyEncoding() != null) {
                lcbEncoding = result.getLcbHydroxyEncoding();
            }
            originalExcelResults.put(expId, result);
        }
        LinkedHashMap<String, Boolean> adductsSorted = ExcelAndTextExporter.extractAdductsSortedByAbundance(sheet.getSheetName(), originalExcelResults);
        boolean rtGroupingUsed = isRtGrouped;
        LinkedHashMap<String, SummaryVO> molSpeciesDetails = new LinkedHashMap<String, SummaryVO>();
        LinkedHashMap<String, Vector<DoubleBondPositionVO>> omegaSuggestionAvailable = new LinkedHashMap<String, Vector<DoubleBondPositionVO>>();
        for (String molName : molNames) {
            if (!omegaSuggestionAvailable.containsKey(molName)) {
                omegaSuggestionAvailable.put(molName, new Vector());
            }
            Hashtable<String, Hashtable<String, Vector<LipidParameterSet>>> relevantOriginals = null;
            if (includeResultFiles) {
                relevantOriginals = new Hashtable<String, Hashtable<String, Vector<LipidParameterSet>>>();
                for (String expId : expFullPaths.keySet()) {
                    ResultAreaVO areaVO = compLookup.getResultAreaVO(sheet.getSheetName(), molName, expId);
                    for (String mod : modifications) {
                        if (areaVO == null) continue;
                        for (LipidParameterSet set : areaVO.getLipidParameterSets(mod)) {
                            if (set.getOmegaInformation().isEmpty()) continue;
                            omegaSuggestionAvailable.get(molName).addAll(set.getOmegaInformation());
                        }
                    }
                    if (!isGrouped && !expNames.containsKey(expId) || areaVO == null) continue;
                    if (areaVO.isAStandard()) {
                        rtGroupingUsed = false;
                    }
                    Hashtable<String, Vector<LipidParameterSet>> sets = ExcelAndTextExporter.getRelevantOriginalResults(originalExcelResults.get(expId).getIdentifications().get(sheet.getSheetName()), areaVO, false);
                    relevantOriginals.put(expId, sets);
                }
            }
            SpeciesExportVO exportVO = LDAExporter.extractExportableSummaryInformation(speciesType, exportDoubleBondPositionsForClass, false, 0, 0, false, 0, 0, rtGroupingUsed, adductsSorted, new Vector<String>(expFullPaths.keySet()), expsOfGroup, molName, results.get(molName), relevantOriginals, maxIsotope, faEncoding, lcbEncoding);
            for (SummaryVO sumVO : exportVO.getSummaries()) {
                String id = "";
                if (includeResultFiles) {
                    id = id + sheet.getSheetName() + " ";
                }
                id = id + sumVO.getSpeciesId();
                if (sumVO.getMolecularId() != null) {
                    id = id + " | " + sumVO.getMolecularId();
                }
                molSpeciesDetails.put(id, sumVO);
                omegaSuggestionAvailable.put(id, omegaSuggestionAvailable.get(molName));
            }
        }
        ExcelAndTextExporter.writeExcelSheetToFile(omegaCollector, sheet, workbook, out, molSpeciesDetails, isGrouped, expIdNames, expNames, expsOfGroup, preferredUnit, expVO, modifications, omegaSuggestionAvailable);
    }

    private static void writeExcelSheetToFile(OmegaCollector omegaCollector, Sheet sheet, XSSFWorkbook workbook, OutputStream out, LinkedHashMap<String, SummaryVO> molSpeciesDetails, boolean isGrouped, Vector<String> expIdNames, Hashtable<String, String> expNames, LinkedHashMap<String, Vector<String>> expsOfGroup, String preferredUnit, ExportOptionsVO expVO, ArrayList<String> modifications, LinkedHashMap<String, Vector<DoubleBondPositionVO>> omegaSuggestionAvailable) throws IOException {
        CellStyle headerStyle = ExcelAndTextExporter.getHeaderStyle(workbook);
        XSSFCellStyle numberStyle = ExcelUtils.getMassListNumberStyle(workbook);
        CellStyle normalStyle = ExcelAndTextExporter.getNormalStyle(workbook);
        CellStyle zeroStyle = ExcelAndTextExporter.getZeroStyle(workbook);
        CellStyle ms2Unambiguous = ExcelAndTextExporter.getMs2UnambiguousStyle(workbook);
        CellStyle ms2Split = ExcelAndTextExporter.getMs2SplitStyle(workbook);
        CellStyle ms2NoSplitPossible = ExcelAndTextExporter.getMs2NoSplitPossibleStyle(workbook);
        Row row = sheet.createRow(0);
        boolean excelFile = true;
        Vector<String> columnNames = new Vector<String>(expIdNames);
        Collections.sort(columnNames);
        Vector<String> rowNames = new Vector<String>(molSpeciesDetails.keySet());
        boolean expInColumn = true;
        StaticUtils.printOutLabelToFile(sheet.getSheetName(), out, row, headerStyle, (columnNames.size() + 2) / 2, excelFile, false);
        int rowCount = 1;
        int columnCount = 0;
        Hashtable<Integer, String> headerValues = new Hashtable<Integer, String>();
        Hashtable<Integer, Integer> longestValues = new Hashtable<Integer, Integer>();
        String unit = "Arb.Units / AU";
        if (preferredUnit != null && preferredUnit.length() > 0) {
            unit = preferredUnit;
        }
        String unitString = unit;
        row = sheet.createRow(rowCount);
        StaticUtils.printOutLabelToFile(unitString, out, row, headerStyle, columnCount, excelFile, false);
        headerValues.put(columnCount, unitString);
        longestValues.put(columnCount, 0);
        StaticUtils.printOutLabelToFile("", out, row, headerStyle, ++columnCount, excelFile, true);
        headerValues.put(columnCount, "");
        longestValues.put(columnCount, 0);
        ++columnCount;
        Hashtable<String, Hashtable<String, OmegaSummary>> valuesForOmega = new Hashtable<String, Hashtable<String, OmegaSummary>>();
        Iterator<String> iterator = columnNames.iterator();
        while (iterator.hasNext()) {
            String columnName;
            String valueToPrint = columnName = iterator.next();
            if (expInColumn) {
                valueToPrint = expNames.get(columnName);
            }
            StaticUtils.printOutLabelToFile(valueToPrint, out, row, headerStyle, columnCount, excelFile, true);
            headerValues.put(columnCount, valueToPrint);
            longestValues.put(columnCount, 0);
            valuesForOmega.put(valueToPrint, new Hashtable());
            ++columnCount;
        }
        row = sheet.createRow(++rowCount);
        LinkedHashMap weightedRTCollector = new LinkedHashMap();
        for (String rowName : rowNames) {
            CellStyle style;
            double areaSum = 0.0;
            String molNameForWeightedCollector = rowName;
            if ((rowName.contains("|") || rowName.startsWith("L")) && !rowName.contains("IntS") && expVO.isExportRT()) {
                if (rowName.contains("|")) {
                    molNameForWeightedCollector = rowName.substring(rowName.indexOf("|") + 2);
                } else if (rowName.startsWith("L")) {
                    molNameForWeightedCollector = rowName.substring(rowName.indexOf(" ") + 1, rowName.indexOf("_"));
                }
                ArrayList<String> insensitive = new ArrayList<String>();
                insensitive.add(molNameForWeightedCollector);
                if (molNameForWeightedCollector.contains("/")) {
                    insensitive = new ArrayList<String>(Arrays.asList(molNameForWeightedCollector.split("/")));
                } else if (molNameForWeightedCollector.contains("_")) {
                    insensitive = new ArrayList<String>(Arrays.asList(molNameForWeightedCollector.split("_")));
                }
                molNameForWeightedCollector = insensitive.toString();
                if (!weightedRTCollector.containsKey(molNameForWeightedCollector)) {
                    weightedRTCollector.put(molNameForWeightedCollector, new ArrayList());
                }
            }
            ExcelAndTextExporter.fillOmegaCollector(omegaCollector, sheet.getSheetName(), molSpeciesDetails, columnNames, expNames, expsOfGroup, expVO, modifications, rowName, omegaSuggestionAvailable.get(rowName));
            String omegaId = ExcelAndTextExporter.extractOmegaPos(rowName);
            columnCount = 0;
            String valueToPrint = rowName;
            if (!expInColumn) {
                valueToPrint = expNames.get(rowName);
            }
            StaticUtils.printOutLabelToFile(valueToPrint, out, row, headerStyle, columnCount, excelFile, false);
            if (valueToPrint.length() > ((String)headerValues.get(columnCount)).length()) {
                headerValues.put(columnCount, valueToPrint);
            }
            StaticUtils.printOutLabelToFile("Value", out, row, headerStyle, ++columnCount, excelFile, true);
            if ("Value".length() > ((String)headerValues.get(columnCount)).length()) {
                headerValues.put(columnCount, "Value");
            }
            ++columnCount;
            if (!ExcelAndTextExporter.isAreaBelowDetectorLimit(columnNames, rowName, expVO, isGrouped, molSpeciesDetails)) continue;
            for (String string : columnNames) {
                if (!valuesForOmega.get(string).containsKey(omegaId)) {
                    valuesForOmega.get(string).put(omegaId, new OmegaSummary());
                }
                String toWrite = "0";
                String molName = string;
                String expName = rowName;
                if (!expVO.isAnalyteInColumn()) {
                    molName = rowName;
                    expName = string;
                }
                SummaryVO sumVO = molSpeciesDetails.get(molName);
                double area = isGrouped ? sumVO.getMeanArea(expName).doubleValue() : sumVO.getArea(expName).doubleValue();
                areaSum += area;
                valuesForOmega.get(string).get(omegaId).addArea(area);
                toWrite = StaticUtils.extractDisplayValue(area, expVO.getCommaPositions());
                CellStyle style2 = null;
                style2 = toWrite.equalsIgnoreCase("0") || toWrite.equalsIgnoreCase("0.0") ? zeroStyle : numberStyle;
                StaticUtils.printOutNumberToFile(toWrite, out, row, style2, columnCount, excelFile, true);
                if (toWrite.length() > (Integer)longestValues.get(columnCount)) {
                    longestValues.put(columnCount, toWrite.length());
                }
                ++columnCount;
            }
            row = sheet.createRow(++rowCount);
            if (expVO != null && expVO.getExportType() != 0) {
                columnCount = 0;
                StaticUtils.printOutLabelToFile("", out, row, headerStyle, columnCount, excelFile, false);
                ++columnCount;
                String title = "";
                if (expVO.getExportType() == 1) {
                    title = title + "SD-" + expVO.getSdValue();
                } else if (expVO.getExportType() == 2) {
                    title = title + "SE";
                }
                StaticUtils.printOutLabelToFile(title, out, row, headerStyle, columnCount, excelFile, true);
                if (title.length() > ((String)headerValues.get(columnCount)).length()) {
                    headerValues.put(columnCount, title);
                }
                ++columnCount;
                for (String columnName2 : columnNames) {
                    Object toWrite = "-1.0";
                    String molName = columnName2;
                    String expName = rowName;
                    if (!expVO.isAnalyteInColumn()) {
                        molName = rowName;
                        expName = columnName2;
                    }
                    SummaryVO sumVO = molSpeciesDetails.get(molName);
                    double value = sumVO.calculateDeviationValue(expVO, expsOfGroup.get(expName));
                    valuesForOmega.get(columnName2).get(omegaId).addStdev(value);
                    if (!Double.isInfinite(value) && !Double.isNaN(value)) {
                        toWrite = StaticUtils.extractDisplayValue(value);
                    }
                    style = null;
                    style = ((String)toWrite).equalsIgnoreCase("-1") || ((String)toWrite).equalsIgnoreCase("-1.0") ? zeroStyle : numberStyle;
                    StaticUtils.printOutNumberToFile((String)toWrite, out, row, style, columnCount, excelFile, true);
                    if (((String)toWrite).length() > (Integer)longestValues.get(columnCount)) {
                        longestValues.put(columnCount, ((String)toWrite).length());
                    }
                    ++columnCount;
                }
                row = sheet.createRow(++rowCount);
            }
            for (String string : modifications) {
                if (expVO != null && expVO.isExportRT()) {
                    columnCount = 0;
                    StaticUtils.printOutLabelToFile("", out, row, headerStyle, columnCount, excelFile, false);
                    ++columnCount;
                    String rtName = "RT";
                    if (modifications.size() > 1) {
                        rtName = rtName + "-" + string;
                    }
                    StaticUtils.printOutLabelToFile(rtName, out, row, headerStyle, columnCount, excelFile, true);
                    if (rtName.length() > ((String)headerValues.get(columnCount)).length()) {
                        headerValues.put(columnCount, rtName);
                    }
                    ++columnCount;
                    for (String columnName : columnNames) {
                        String toWrite = "-1.0";
                        String molName = columnName;
                        String expName = rowName;
                        if (!expVO.isAnalyteInColumn()) {
                            molName = rowName;
                            expName = columnName;
                        }
                        SummaryVO sumVO = molSpeciesDetails.get(molName);
                        Double rt = isGrouped ? sumVO.getMeanRetentionTime(string, expName) : sumVO.getRetentionTime(string, expName);
                        Double rtForWeighted = rt != null && !Double.isInfinite(rt) && !Double.isNaN(rt) ? rt : 0.0;
                        if (weightedRTCollector.containsKey(molNameForWeightedCollector)) {
                            ((ArrayList)weightedRTCollector.get(molNameForWeightedCollector)).add(new Pair<Double, Double>(areaSum, rtForWeighted));
                        }
                        if (rt != null && !Double.isInfinite(rt) && !Double.isNaN(rt)) {
                            toWrite = StaticUtils.extractDisplayValue(rt);
                        }
                        CellStyle style3 = null;
                        style3 = toWrite.equalsIgnoreCase("-1") || toWrite.equalsIgnoreCase("-1.0") ? zeroStyle : ExcelAndTextExporter.getCorrespondingCellStyle(sumVO.getEvidenceReliabilty(expName), normalStyle, ms2Unambiguous, ms2Split, ms2NoSplitPossible);
                        StaticUtils.printOutNumberToFile(toWrite, out, row, style3, columnCount, excelFile, true);
                        if (toWrite.length() > (Integer)longestValues.get(columnCount)) {
                            longestValues.put(columnCount, toWrite.length());
                        }
                        ++columnCount;
                    }
                    row = sheet.createRow(++rowCount);
                }
                if (expVO == null || !expVO.isExportRTDev()) continue;
                columnCount = 0;
                StaticUtils.printOutLabelToFile("", out, row, headerStyle, columnCount, excelFile, false);
                StaticUtils.printOutLabelToFile("RT-StDev", out, row, headerStyle, ++columnCount, excelFile, true);
                if ("RT-StDev".length() > ((String)headerValues.get(columnCount)).length()) {
                    headerValues.put(columnCount, "RT-StDev");
                }
                ++columnCount;
                for (String columnName : columnNames) {
                    SummaryVO sumVO;
                    Double rtStdev;
                    String toWrite = "-1.0";
                    String molName = columnName;
                    String expName = rowName;
                    if (!expVO.isAnalyteInColumn()) {
                        molName = rowName;
                        expName = columnName;
                    }
                    if ((rtStdev = (sumVO = molSpeciesDetails.get(molName)).getStdevRetentionTime(string, expName)) != null && !Double.isInfinite(rtStdev) && !Double.isNaN(rtStdev)) {
                        toWrite = StaticUtils.extractDisplayValue(rtStdev);
                    }
                    style = null;
                    style = toWrite.equalsIgnoreCase("-1") || toWrite.equalsIgnoreCase("-1.0") ? zeroStyle : ExcelAndTextExporter.getCorrespondingCellStyle(sumVO.getEvidenceReliabilty(expName), normalStyle, ms2Unambiguous, ms2Split, ms2NoSplitPossible);
                    StaticUtils.printOutNumberToFile(toWrite, out, row, style, columnCount, excelFile, true);
                    ++columnCount;
                }
                row = sheet.createRow(++rowCount);
            }
        }
        rowCount += 3;
        for (String molName : weightedRTCollector.keySet()) {
            row = sheet.createRow(++rowCount);
            Cell cell = row.createCell(0, 1);
            cell.setCellValue(molName);
            cell = row.createCell(1, 0);
            Double weightedRT = 0.0;
            Double sum = 0.0;
            Double sumWeights = 0.0;
            Integer num = 0;
            for (Pair pair : (ArrayList)weightedRTCollector.get(molName)) {
                if (!((Double)pair.getFirst() > 0.0) || !((Double)pair.getSecond() > 0.0)) continue;
                sum = sum + (Double)pair.getFirst() * (Double)pair.getSecond();
                sumWeights = sumWeights + (Double)pair.getFirst();
                Integer n = num;
                Integer n2 = num = Integer.valueOf(num + 1);
            }
            weightedRT = sum / sumWeights;
            cell.setCellValue(Precision.round(weightedRT, 2));
        }
        ExcelAndTextExporter.writeValuesForOmega(valuesForOmega, sheet, workbook, out, rowCount + 3, headerStyle, numberStyle);
        if (excelFile) {
            Iterator<String> iterator2 = headerValues.keySet().iterator();
            while (iterator2.hasNext()) {
                int column = (Integer)((Object)iterator2.next());
                ExcelAndTextExporter.setColumnWidth(sheet, column, (String)headerValues.get(column), (Integer)longestValues.get(column));
            }
        }
    }

    private static void fillOmegaCollector(OmegaCollector omegaCollector, String lClass, LinkedHashMap<String, SummaryVO> molSpeciesDetails, Vector<String> columnNames, Hashtable<String, String> expNames, LinkedHashMap<String, Vector<String>> expsOfGroup, ExportOptionsVO expVO, ArrayList<String> modifications, String rowName, Vector<DoubleBondPositionVO> vector) {
        if (lClass.equals("Cer") || lClass.equals("SM") || !rowName.contains("_")) {
            return;
        }
        int numFA = 2;
        if (lClass.startsWith("L")) {
            numFA = 1;
        }
        for (String experimentName : columnNames) {
            SummaryVO sumVO = molSpeciesDetails.get(rowName);
            Double area = sumVO.getMeanArea(experimentName);
            Double stdev = sumVO.calculateDeviationValue(expVO, expsOfGroup.get(experimentName));
            omegaCollector.addToTotalFAPerClass(experimentName, lClass, area * (double)numFA);
            if (!rowName.contains("|") && !rowName.startsWith("L")) continue;
            String molName = rowName;
            if (rowName.contains("|")) {
                molName = rowName.substring(rowName.indexOf("|") + 2);
            } else if (rowName.startsWith("L")) {
                molName = rowName.substring(rowName.indexOf(" ") + 1, rowName.indexOf("_"));
            }
            try {
                Vector<FattyAcidVO> chains = StaticUtils.decodeFAsFromHumanReadableName(molName, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
                Vector<FattyAcidVO> sameChainType = new Vector<FattyAcidVO>();
                for (FattyAcidVO chain : chains) {
                    FattyAcidVO partner;
                    FattyAcidVO sameChain = new FattyAcidVO(chain.getChainType(), "", chain.getcAtoms(), chain.getDoubleBonds(), chain.getOhNumber(), chain.getMass(), chain.getFormula(), chain.getOxState());
                    sameChain.setOmegaPosition(chain.getOmegaPosition());
                    sameChainType.add(sameChain);
                    if (sameChain.getOmegaPosition() > 0) {
                        omegaCollector.addToTotalFAPerDescription(experimentName, "unsaturated assigned", area);
                        omegaCollector.addToTotalOmegaPerClass(experimentName, lClass, sameChain.getOmegaPosition(), area);
                        omegaCollector.addToTotalOmegaPerClassSTD(experimentName, sameChain.getOmegaPosition(), stdev);
                        omegaCollector.addToTotalOmegaFAPerClass(experimentName, lClass, sameChain.getCarbonDbsId(), area);
                        continue;
                    }
                    String description = sameChain.getDoubleBonds() > 0 ? "unsaturated unassigned (u.a.)" : "saturated";
                    omegaCollector.addToTotalFAPerDescription(experimentName, description, area);
                    if (!description.equals("unsaturated unassigned (u.a.)")) continue;
                    if (!vector.isEmpty()) {
                        omegaCollector.addToTotalFAPerDescription(experimentName, "u.a. suggested", area);
                    }
                    if (sameChain.getcAtoms() % 2 == 1) {
                        omegaCollector.addToTotalFAPerDescription(experimentName, "u.a. odd chain", area);
                        if (chains.size() > 1) {
                            FattyAcidVO fattyAcidVO = partner = chains.indexOf(chain) == 1 ? chains.get(0) : chains.get(1);
                            if (partner.getOmegaPosition() > 0 || partner.getDoubleBonds() == 0) {
                                omegaCollector.addToTotalFAPerDescription(experimentName, "u.a. odd chain; partner chain assigned / saturated", area);
                                continue;
                            }
                            omegaCollector.addToTotalFAPerDescription(experimentName, "u.a. odd chain; partner chain unassigned", area);
                            continue;
                        }
                        omegaCollector.addToTotalFAPerDescription(experimentName, "u.a. odd chain; partner chain assigned / saturated", area);
                        continue;
                    }
                    omegaCollector.addToTotalFAPerDescription(experimentName, "u.a. even chain", area);
                    if (chains.size() > 1) {
                        FattyAcidVO fattyAcidVO = partner = chains.indexOf(chain) == 1 ? chains.get(0) : chains.get(1);
                        if (partner.getOmegaPosition() > 0 || partner.getDoubleBonds() == 0) {
                            omegaCollector.addToTotalFAPerDescription(experimentName, "u.a. even chain; partner chain assigned / saturated", area);
                            continue;
                        }
                        omegaCollector.addToTotalFAPerDescription(experimentName, "u.a. even chain; partner chain unassigned", area);
                        continue;
                    }
                    omegaCollector.addToTotalFAPerDescription(experimentName, "u.a. even chain; partner chain assigned / saturated", area);
                }
                if (sameChainType.size() > 1) {
                    FattyAcidVO first = (FattyAcidVO)sameChainType.get(0);
                    FattyAcidVO second = (FattyAcidVO)sameChainType.get(1);
                    if (first.getDoubleBonds() < second.getDoubleBonds()) {
                        sameChainType.clear();
                        sameChainType.add(second);
                        sameChainType.add(first);
                    }
                }
                boolean bothAssigned = true;
                for (FattyAcidVO chain : sameChainType) {
                    if (chain.getDoubleBonds() <= 0 || chain.getOmegaPosition() >= 1) continue;
                    bothAssigned = false;
                }
                if (bothAssigned) {
                    omegaCollector.addToFAContentToPartnerContent(experimentName, lClass, sameChainType.size() > 1 ? StaticUtils.getHumanReadableChainName((FattyAcidVO)sameChainType.get(1), Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), ((FattyAcidVO)sameChainType.get(0)).getOhNumber() > 0) : "", StaticUtils.getHumanReadableChainName((FattyAcidVO)sameChainType.get(0), Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), ((FattyAcidVO)sameChainType.get(0)).getOhNumber() > 0), area * (double)numFA);
                }
                if (!molName.contains("/")) continue;
                omegaCollector.addToSn1ContentToSn2Content(experimentName, lClass, ((FattyAcidVO)sameChainType.get(0)).getCarbonDbsId(), ((FattyAcidVO)sameChainType.get(1)).getCarbonDbsId(), area * (double)numFA);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void writeHeatMapData(OmegaCollector omegaCollector, XSSFWorkbook workbook, OutputStream out) {
        XSSFSheet sheetA = workbook.createSheet("Validation");
        Row headerRowA = sheetA.createRow(0);
        XSSFSheet sheetD = workbook.createSheet("Description Count");
        Row headerRowD = sheetD.createRow(0);
        XSSFSheet sheetE = workbook.createSheet("FAvsFA Combined");
        CellStyle headerStyle = ExcelAndTextExporter.getHeaderStyle(workbook);
        XSSFCellStyle numberStyle = ExcelUtils.getMassListNumberStyle(workbook);
        ArrayList<LinkedHashMap<String, LinkedHashMap<String, Double>>> fafaData = new ArrayList<LinkedHashMap<String, LinkedHashMap<String, Double>>>();
        Vector<String> experimentNames = omegaCollector.getExperimentNames();
        String experimentNameUnsuppl = "F) RAW264.7 unsupplemented";
        for (int i = 0; i < experimentNames.size(); ++i) {
            int columnNr = i + 1;
            String experimentName = experimentNames.get(i);
            System.out.println(experimentName);
            Double totalFAContent = omegaCollector.getTotalFA(experimentName);
            XSSFSheet sheetB = workbook.createSheet("HeatMap LC " + experimentName.substring(0, 2));
            XSSFSheet sheetC = workbook.createSheet("HeatMap FA " + experimentName.substring(0, 2));
            Row headerRowB = sheetB.createRow(0);
            Row headerRowC = sheetC.createRow(0);
            ExcelAndTextExporter.writeValidation(omegaCollector, experimentName, experimentNameUnsuppl, columnNr, i, sheetA, headerRowA, headerStyle, numberStyle, totalFAContent);
            ExcelAndTextExporter.writeFAvsLClassHeatmap(omegaCollector, experimentName, sheetB, headerRowB, headerStyle, numberStyle, totalFAContent);
            fafaData.add(ExcelAndTextExporter.writeFAvsFAHeatmap(omegaCollector, experimentName, sheetC, headerRowC, headerStyle, numberStyle, totalFAContent));
            ExcelAndTextExporter.writeDescription(omegaCollector, experimentName, columnNr, i, sheetD, headerRowD, headerStyle, numberStyle, totalFAContent);
        }
        ExcelAndTextExporter.writeFAvsFABarChartData(fafaData, sheetE, headerStyle, numberStyle);
    }

    private static void writeFAvsFABarChartData(ArrayList<LinkedHashMap<String, LinkedHashMap<String, Double>>> fafaData, Sheet sheet, CellStyle headerStyle, CellStyle numberStyle) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (LinkedHashMap<String, LinkedHashMap<String, Double>> linkedHashMap : fafaData) {
            set.addAll(linkedHashMap.keySet());
        }
        Hashtable valueStd = new Hashtable();
        for (String fa : set) {
            valueStd.put(fa, new Hashtable());
            for (LinkedHashMap<String, LinkedHashMap<String, Double>> data : fafaData) {
                if (!data.containsKey(fa)) continue;
                for (String partner : data.get(fa).keySet()) {
                    if (!((Hashtable)valueStd.get(fa)).containsKey(partner)) {
                        ((Hashtable)valueStd.get(fa)).put(partner, new ArrayList());
                    }
                    ((ArrayList)((Hashtable)valueStd.get(fa)).get(partner)).add(data.get(fa).get(partner));
                }
            }
        }
        ArrayList arrayList = new ArrayList(set);
        int rowNr = 0;
        Row headerRow = sheet.createRow(rowNr);
        for (int i = 0; i < arrayList.size(); ++i) {
            String fa = (String)arrayList.get(i);
            Hashtable values = (Hashtable)valueStd.get(fa);
            int columnNr = i + 1;
            Cell cell = headerRow.createCell(columnNr, 1);
            cell.setCellValue(fa);
            cell.setCellStyle(headerStyle);
            for (int j = 0; j < arrayList.size(); ++j) {
                Row row;
                String partner = (String)arrayList.get(j);
                rowNr = j + 1;
                if (i == 0) {
                    row = sheet.createRow(rowNr);
                    cell = row.createCell(0, 1);
                    cell.setCellValue(partner);
                    cell.setCellStyle(headerStyle);
                } else {
                    row = sheet.getRow(rowNr);
                }
                cell = row.createCell(columnNr, 0);
                double number = 0.0;
                if (values.containsKey(partner)) {
                    ArrayList nonZero = (ArrayList)values.get(partner);
                    nonZero.removeAll(Collections.singleton(0.0));
                    if (!nonZero.isEmpty()) {
                        Iterator iterator = nonZero.iterator();
                        while (iterator.hasNext()) {
                            double x = (Double)iterator.next();
                            number += x;
                        }
                        number /= (double)nonZero.size();
                    }
                }
                cell.setCellValue(number);
                cell.setCellStyle(numberStyle);
            }
        }
        headerRow = sheet.createRow(rowNr += 3);
        int rowNrLocal = rowNr;
        for (int i = 0; i < arrayList.size(); ++i) {
            String fa = (String)arrayList.get(i);
            Hashtable values = (Hashtable)valueStd.get(fa);
            int columnNr = i + 1;
            Cell cell = headerRow.createCell(columnNr, 1);
            cell.setCellValue(fa);
            cell.setCellStyle(headerStyle);
            for (int j = 0; j < arrayList.size(); ++j) {
                Row row;
                String partner = (String)arrayList.get(j);
                rowNr = rowNrLocal + j + 1;
                if (i == 0) {
                    row = sheet.createRow(rowNr);
                    cell = row.createCell(0, 1);
                    cell.setCellValue(partner);
                    cell.setCellStyle(headerStyle);
                } else {
                    row = sheet.getRow(rowNr);
                }
                cell = row.createCell(columnNr, 0);
                double standardDeviation = 0.0;
                if (!values.containsKey(partner) || ((ArrayList)values.get(partner)).size() <= 2) continue;
                ArrayList nonZero = (ArrayList)values.get(partner);
                nonZero.removeAll(Collections.singleton(0.0));
                if (nonZero.size() <= 2) continue;
                double sum = 0.0;
                Iterator iterator = nonZero.iterator();
                while (iterator.hasNext()) {
                    double x = (Double)iterator.next();
                    sum += x;
                }
                if (sum > 0.0) {
                    double mean = sum / (double)nonZero.size();
                    sum = 0.0;
                    Iterator iterator2 = nonZero.iterator();
                    while (iterator2.hasNext()) {
                        double x = (Double)iterator2.next();
                        sum += Math.pow(x - mean, 2.0);
                    }
                    standardDeviation = Math.sqrt(sum / (double)(nonZero.size() - 1));
                }
                cell.setCellValue(standardDeviation);
                cell.setCellStyle(numberStyle);
            }
        }
    }

    private static void writeValuesForOmega(Hashtable<String, Hashtable<String, OmegaSummary>> valuesForOmega, Sheet sheet, XSSFWorkbook workbook, OutputStream out, int rowCount, CellStyle headerStyle, CellStyle normalStyle) {
        Cell number;
        Row row = sheet.createRow(rowCount);
        ArrayList<String> groupNames = new ArrayList<String>(valuesForOmega.keySet());
        Collections.sort(groupNames);
        ArrayList<String> labelList = ExcelAndTextExporter.generateLabelListForOmega();
        int columnCount = 1;
        for (String groupName : groupNames) {
            StaticUtils.addExcelLabel(headerStyle, row, ++columnCount, groupName);
        }
        row = sheet.createRow(++rowCount);
        StaticUtils.addExcelLabel(headerStyle, row, 0, "area [AU]");
        for (String label : labelList) {
            columnCount = 1;
            row = sheet.createRow(++rowCount);
            StaticUtils.addExcelLabel(headerStyle, row, columnCount, label);
            for (String groupName : groupNames) {
                double area = 0.0;
                if (valuesForOmega.get(groupName).containsKey(label) && (Double.isInfinite(area = valuesForOmega.get(groupName).get(label).getAverageArea()) || Double.isNaN(area))) {
                    area = 0.0;
                }
                number = row.createCell(++columnCount, 0);
                number.setCellValue(area);
                number.setCellStyle(normalStyle);
            }
        }
        rowCount += 2;
        row = sheet.createRow(++rowCount);
        StaticUtils.addExcelLabel(headerStyle, row, 0, "SD-1.0");
        for (String label : labelList) {
            columnCount = 1;
            row = sheet.createRow(++rowCount);
            StaticUtils.addExcelLabel(headerStyle, row, columnCount, label);
            for (String groupName : groupNames) {
                double stdev = 0.0;
                if (valuesForOmega.get(groupName).containsKey(label) && (Double.isInfinite(stdev = valuesForOmega.get(groupName).get(label).getStdev()) || Double.isNaN(stdev))) {
                    stdev = 0.0;
                }
                number = row.createCell(++columnCount, 0);
                number.setCellValue(stdev);
                number.setCellStyle(normalStyle);
            }
        }
    }

    private static String extractOmegaPos(String name) {
        String remainder;
        if (!name.contains("(n-")) {
            return "none";
        }
        String omegaId = "";
        ArrayList<Integer> omegaPos = new ArrayList<Integer>();
        omegaPos.add(Integer.parseInt(name.substring(name.indexOf("(n-") + "(n-".length(), name.indexOf(")"))));
        if (name.indexOf(")") + ")".length() < name.length() && (remainder = name.substring(name.indexOf(")") + ")".length(), name.length())).contains("(n-")) {
            omegaPos.add(Integer.parseInt(remainder.substring(remainder.indexOf("(n-") + "(n-".length(), remainder.indexOf(")"))));
            Collections.sort(omegaPos);
        }
        if (omegaPos.size() == 1 && name.contains(":0")) {
            omegaId = String.format("(n-%s)", omegaPos.get(0));
        } else if (omegaPos.size() == 1) {
            omegaId = String.format("(n-%s)+(n-x)", omegaPos.get(0));
        } else if (omegaPos.size() == 2) {
            omegaId = String.format("(n-%s)+(n-%s)", omegaPos.get(0), omegaPos.get(1));
        }
        return omegaId;
    }

    private static ArrayList<String> generateLabelListForOmega() {
        ArrayList<String> labelList = new ArrayList<String>();
        labelList.add("(n-3)");
        labelList.add("(n-3)+(n-3)");
        labelList.add("(n-3)+(n-6)");
        labelList.add("(n-3)+(n-7)");
        labelList.add("(n-3)+(n-9)");
        labelList.add("(n-3)+(n-10)");
        labelList.add("(n-6)");
        labelList.add("(n-6)+(n-6)");
        labelList.add("(n-6)+(n-7)");
        labelList.add("(n-6)+(n-9)");
        labelList.add("(n-6)+(n-10)");
        labelList.add("(n-7)");
        labelList.add("(n-7)+(n-7)");
        labelList.add("(n-7)+(n-9)");
        labelList.add("(n-7)+(n-10)");
        labelList.add("(n-9)");
        labelList.add("(n-9)+(n-9)");
        labelList.add("(n-9)+(n-10)");
        labelList.add("(n-10)");
        labelList.add("(n-10)+(n-10)");
        return labelList;
    }

    private static boolean isAreaBelowDetectorLimit(Vector<String> columnNames, String rowName, ExportOptionsVO expVO, boolean isGrouped, LinkedHashMap<String, SummaryVO> molSpeciesDetails) {
        return true;
    }

    private static void writeValidation(OmegaCollector omegaCollector, String experimentName, String experimentNameUnsuppl, int columnNr, int i, Sheet sheetA, Row headerRowA, CellStyle headerStyle, CellStyle numberStyle, Double totalFAContent) {
        Row row;
        int rowNr;
        Double value;
        Integer omega;
        int j;
        LinkedHashMap<Integer, Double> normTotalOmegaFA = omegaCollector.getNormTotalOmegaFA(experimentName);
        Vector<Integer> omegaPos = new Vector<Integer>(normTotalOmegaFA.keySet());
        Collections.sort(omegaPos);
        Cell cell = headerRowA.createCell(columnNr, 1);
        cell.setCellValue(experimentName);
        cell.setCellStyle(headerStyle);
        for (j = 0; j < omegaPos.size(); ++j) {
            Double normalized;
            omega = omegaPos.get(j);
            value = normalized = normTotalOmegaFA.get(omega);
            rowNr = j + 1;
            if (i == 0) {
                row = sheetA.createRow(rowNr);
                cell = row.createCell(0, 1);
                cell.setCellValue(String.format("omega %s", omega));
                cell.setCellStyle(headerStyle);
            } else {
                row = sheetA.getRow(rowNr);
            }
            cell = row.createCell(columnNr, 0);
            cell.setCellValue(value);
            cell.setCellStyle(numberStyle);
        }
        for (j = 0; j < omegaPos.size(); ++j) {
            omega = omegaPos.get(j);
            Double stdev = omegaCollector.getOmegaSTD(experimentName, omega);
            value = stdev / totalFAContent;
            rowNr = j + (omegaPos.size() + 2);
            if (i == 0) {
                row = sheetA.createRow(rowNr);
                cell = row.createCell(0, 1);
                cell.setCellValue(String.format("omega %s", omega));
                cell.setCellStyle(headerStyle);
            } else {
                row = sheetA.getRow(rowNr);
            }
            cell = row.createCell(columnNr, 0);
            cell.setCellValue(value);
            cell.setCellStyle(numberStyle);
        }
    }

    private static void writeDescription(OmegaCollector omegaCollector, String experimentName, int columnNr, int i, Sheet sheetD, Row headerRowD, CellStyle headerStyle, CellStyle numberStyle, Double totalFAContent) {
        Row row;
        LinkedHashMap<String, Double> descriptionCount = omegaCollector.getTotalFAPerDescription(experimentName);
        Cell cell = headerRowD.createCell(columnNr, 1);
        cell.setCellValue(experimentName);
        cell.setCellStyle(headerStyle);
        if (i == 0) {
            row = sheetD.createRow(1);
            cell = row.createCell(0, 1);
            cell.setCellValue(String.format("%s", "saturated"));
            cell.setCellStyle(headerStyle);
            row = sheetD.createRow(2);
            cell = row.createCell(0, 1);
            cell.setCellValue(String.format("%s", "unsaturated assigned"));
            cell.setCellStyle(headerStyle);
            row = sheetD.createRow(3);
            cell = row.createCell(0, 1);
            cell.setCellValue(String.format("%s", "unsaturated unassigned (u.a.)"));
            cell.setCellStyle(headerStyle);
            row = sheetD.createRow(4);
            cell = row.createCell(0, 1);
            cell.setCellValue(String.format("%s", "u.a. suggested"));
            cell.setCellStyle(headerStyle);
            row = sheetD.createRow(5);
            cell = row.createCell(0, 1);
            cell.setCellValue(String.format("%s", "u.a. even chain"));
            cell.setCellStyle(headerStyle);
            row = sheetD.createRow(6);
            cell = row.createCell(0, 1);
            cell.setCellValue(String.format("%s", "u.a. odd chain"));
            cell.setCellStyle(headerStyle);
            row = sheetD.createRow(7);
            cell = row.createCell(0, 1);
            cell.setCellValue(String.format("%s", "u.a. even chain; partner chain assigned / saturated"));
            cell.setCellStyle(headerStyle);
            row = sheetD.createRow(8);
            cell = row.createCell(0, 1);
            cell.setCellValue(String.format("%s", "u.a. odd chain; partner chain assigned / saturated"));
            cell.setCellStyle(headerStyle);
            row = sheetD.createRow(9);
            cell = row.createCell(0, 1);
            cell.setCellValue(String.format("%s", "u.a. even chain; partner chain unassigned"));
            cell.setCellStyle(headerStyle);
            row = sheetD.createRow(10);
            cell = row.createCell(0, 1);
            cell.setCellValue(String.format("%s", "u.a. odd chain; partner chain unassigned"));
            cell.setCellStyle(headerStyle);
        }
        row = sheetD.getRow(1);
        cell = row.createCell(columnNr, 0);
        cell.setCellValue(descriptionCount.get("saturated") / totalFAContent);
        cell.setCellStyle(numberStyle);
        row = sheetD.getRow(2);
        cell = row.createCell(columnNr, 0);
        cell.setCellValue(descriptionCount.get("unsaturated assigned") / totalFAContent);
        cell.setCellStyle(numberStyle);
        row = sheetD.getRow(3);
        cell = row.createCell(columnNr, 0);
        cell.setCellValue(descriptionCount.get("unsaturated unassigned (u.a.)") / totalFAContent);
        cell.setCellStyle(numberStyle);
        row = sheetD.getRow(4);
        cell = row.createCell(columnNr, 0);
        cell.setCellValue(descriptionCount.get("u.a. suggested") / totalFAContent);
        cell.setCellStyle(numberStyle);
        row = sheetD.getRow(5);
        cell = row.createCell(columnNr, 0);
        cell.setCellValue(descriptionCount.get("u.a. even chain") / totalFAContent);
        cell.setCellStyle(numberStyle);
        row = sheetD.getRow(6);
        cell = row.createCell(columnNr, 0);
        cell.setCellValue(descriptionCount.get("u.a. odd chain") / totalFAContent);
        cell.setCellStyle(numberStyle);
        row = sheetD.getRow(7);
        cell = row.createCell(columnNr, 0);
        cell.setCellValue(descriptionCount.get("u.a. even chain; partner chain assigned / saturated") / totalFAContent);
        cell.setCellStyle(numberStyle);
        row = sheetD.getRow(8);
        cell = row.createCell(columnNr, 0);
        cell.setCellValue(descriptionCount.get("u.a. odd chain; partner chain assigned / saturated") / totalFAContent);
        cell.setCellStyle(numberStyle);
        row = sheetD.getRow(9);
        cell = row.createCell(columnNr, 0);
        cell.setCellValue(descriptionCount.get("u.a. even chain; partner chain unassigned") / totalFAContent);
        cell.setCellStyle(numberStyle);
        row = sheetD.getRow(10);
        cell = row.createCell(columnNr, 0);
        cell.setCellValue(descriptionCount.get("u.a. odd chain; partner chain unassigned") / totalFAContent);
        cell.setCellStyle(numberStyle);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeFAvsLClassHeatmap(OmegaCollector omegaCollector, String experimentName, Sheet sheetB, Row headerRowB, CellStyle headerStyle, CellStyle numberStyle, Double totalFAContent) {
        void var11_14;
        LinkedHashMap<String, LinkedHashMap<String, Double>> totalOmegaFAPerClass = omegaCollector.getTotalOmegaFAPerClass(experimentName);
        Vector<String> lClasses = new Vector<String>(totalOmegaFAPerClass.keySet());
        Collections.sort(lClasses);
        HashSet<String> allFASet = new HashSet<String>();
        for (String string : lClasses) {
            LinkedHashMap<String, Double> entries = totalOmegaFAPerClass.get(string);
            for (String faName : entries.keySet()) {
                Double area = entries.get(faName);
                if (!(area > 0.0)) continue;
                allFASet.add(faName);
            }
        }
        Vector<FattyAcidVO> allFAs = new Vector<FattyAcidVO>();
        for (String faName : allFASet) {
            try {
                FattyAcidVO vo = StaticUtils.decodeHumanReadableChain(faName, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
                allFAs.add(vo);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ExcelAndTextExporter.sortFAs(allFAs);
        boolean bl = false;
        while (var11_14 < lClasses.size()) {
            void columnNr = var11_14 + true;
            Cell cell = headerRowB.createCell((int)columnNr, 1);
            cell.setCellValue(lClasses.get((int)var11_14));
            cell.setCellStyle(headerStyle);
            for (int j = 0; j < allFAs.size(); ++j) {
                Row row;
                int rowNr = j + 1;
                if (var11_14 == false) {
                    row = sheetB.createRow(rowNr);
                    cell = row.createCell(0, 1);
                    cell.setCellValue(allFAs.get(j).getCarbonDbsId());
                    cell.setCellStyle(headerStyle);
                } else {
                    row = sheetB.getRow(rowNr);
                }
                cell = row.createCell((int)columnNr, 0);
                double number = 0.0;
                if (totalOmegaFAPerClass.get(lClasses.get((int)var11_14)).containsKey(allFAs.get(j).getCarbonDbsId())) {
                    number = totalOmegaFAPerClass.get(lClasses.get((int)var11_14)).get(allFAs.get(j).getCarbonDbsId()) / totalFAContent;
                }
                cell.setCellValue(number);
                cell.setCellStyle(numberStyle);
            }
            ++var11_14;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static LinkedHashMap<String, LinkedHashMap<String, Double>> writeFAvsFAHeatmap(OmegaCollector omegaCollector, String experimentName, Sheet sheetC, Row headerRowC, CellStyle headerStyle, CellStyle numberStyle, Double totalFAContent) {
        LinkedHashMap<String, LinkedHashMap<String, Double>> collection = new LinkedHashMap<String, LinkedHashMap<String, Double>>();
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Double>>> faContentToPartnerContent = omegaCollector.getFAContentToPartnerContent(experimentName);
        LinkedHashMap totalFAFA = new LinkedHashMap();
        HashSet<String> allFASet1 = new HashSet<String>();
        HashSet<String> allFASet2 = new HashSet<String>();
        for (String string : faContentToPartnerContent.keySet()) {
            LinkedHashMap<String, LinkedHashMap<String, Double>> fafaForClass = faContentToPartnerContent.get(string);
            for (String fa : fafaForClass.keySet()) {
                LinkedHashMap<String, Double> partnerFAs = fafaForClass.get(fa);
                if (!totalFAFA.containsKey(fa)) {
                    totalFAFA.put(fa, new LinkedHashMap());
                }
                for (String partnerFA : partnerFAs.keySet()) {
                    Double value = partnerFAs.get(partnerFA);
                    if (value > 0.0 && (fa.contains("(n-") || partnerFA.contains("(n-") || fa.length() <= 1)) {
                        allFASet1.add(fa);
                        allFASet2.add(partnerFA);
                        allFASet2.add(fa);
                        allFASet1.add(partnerFA);
                    }
                    if (!((LinkedHashMap)totalFAFA.get(fa)).containsKey(partnerFA)) {
                        ((LinkedHashMap)totalFAFA.get(fa)).put(partnerFA, 0.0);
                    }
                    Double before = (Double)((LinkedHashMap)totalFAFA.get(fa)).get(partnerFA);
                    ((LinkedHashMap)totalFAFA.get(fa)).put(partnerFA, before + value);
                }
            }
        }
        Double maxFAContent = 0.0;
        for (Object fa : totalFAFA.keySet()) {
            for (String partnerFA : ((LinkedHashMap)totalFAFA.get(fa)).keySet()) {
                if (!((Double)((LinkedHashMap)totalFAFA.get(fa)).get(partnerFA) > maxFAContent)) continue;
                maxFAContent = (Double)((LinkedHashMap)totalFAFA.get(fa)).get(partnerFA);
            }
        }
        Vector<FattyAcidVO> vector = new Vector<FattyAcidVO>();
        for (String string : allFASet1) {
            if (string.equals("")) {
                if (vector.contains(null)) continue;
                vector.add(null);
                continue;
            }
            try {
                FattyAcidVO vo = StaticUtils.decodeHumanReadableChain(string, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
                vector.add(vo);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ExcelAndTextExporter.sortFAs(vector);
        Vector<FattyAcidVO> allFAs2 = new Vector<FattyAcidVO>();
        for (String faName : allFASet2) {
            if (faName.equals("")) {
                if (allFAs2.contains(null)) continue;
                allFAs2.add(null);
                continue;
            }
            try {
                FattyAcidVO vo = StaticUtils.decodeHumanReadableChain(faName, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
                allFAs2.add(vo);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        ExcelAndTextExporter.sortFAs(allFAs2);
        try {
            void var15_24;
            boolean bl = false;
            while (var15_24 < vector.size()) {
                void columnNr = var15_24 + true;
                String key1 = vector.get((int)var15_24) == null ? "" : StaticUtils.getHumanReadableChainName(vector.get((int)var15_24), Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), vector.get((int)var15_24).getOhNumber() > 0);
                String faName = key1.length() <= 1 ? "lyso" : key1;
                collection.put(faName, new LinkedHashMap());
                Cell cell = headerRowC.createCell((int)columnNr, 1);
                cell.setCellValue(faName);
                cell.setCellStyle(headerStyle);
                for (int j = 0; j < allFAs2.size(); ++j) {
                    Row row;
                    String key2 = allFAs2.get(j) == null ? "" : StaticUtils.getHumanReadableChainName(allFAs2.get(j), Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), allFAs2.get(j).getOhNumber() > 0);
                    String faNamePartner = key2.length() <= 1 ? "lyso" : key2;
                    int rowNr = j + 1;
                    if (var15_24 == false) {
                        row = sheetC.createRow(rowNr);
                        cell = row.createCell(0, 1);
                        cell.setCellValue(faNamePartner);
                        cell.setCellStyle(headerStyle);
                    } else {
                        row = sheetC.getRow(rowNr);
                    }
                    cell = row.createCell((int)columnNr, 0);
                    double number = 0.0;
                    if (totalFAFA.containsKey(key1) && ((LinkedHashMap)totalFAFA.get(key1)).containsKey(key2)) {
                        number = (Double)((LinkedHashMap)totalFAFA.get(key1)).get(key2) / totalFAContent;
                    }
                    collection.get(faName).put(faNamePartner, number);
                    cell.setCellValue(number);
                    cell.setCellStyle(numberStyle);
                }
                ++var15_24;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("hihi");
        return collection;
    }

    private static void sortFAs(Vector<FattyAcidVO> fas) {
        Collections.sort(fas, new Comparator<FattyAcidVO>(){

            @Override
            public int compare(FattyAcidVO fa1, FattyAcidVO fa2) {
                if (fa1 == null && fa2 == null) {
                    return 0;
                }
                if (fa1 == null) {
                    return 1;
                }
                if (fa2 == null) {
                    return -1;
                }
                return Comparator.comparing(FattyAcidVO::getcAtoms).thenComparing(FattyAcidVO::getDoubleBonds).thenComparing(FattyAcidVO::getOmegaPosition).thenComparing(FattyAcidVO::getChainType).compare(fa1, fa2);
            }
        });
    }

    private static class OmegaSummary {
        double sumArea_ = 0.0;
        double sumVariance_ = 0.0;
        int numContributions_ = 0;

        private OmegaSummary() {
        }

        void addArea(double area) {
            if (!Double.isInfinite(area) && !Double.isNaN(area)) {
                this.sumArea_ += area;
                ++this.numContributions_;
            }
        }

        void addStdev(double stdev) {
            if (!Double.isInfinite(stdev) && !Double.isNaN(stdev)) {
                this.sumVariance_ += Math.pow(stdev, 2.0);
            }
        }

        double getAverageArea() {
            return this.sumArea_ / (double)this.numContributions_;
        }

        double getStdev() {
            return Math.sqrt(this.sumVariance_ / (double)this.numContributions_);
        }
    }
}

