/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.export;

import java.util.LinkedHashMap;
import java.util.Vector;

public class OmegaCollector {
    public static final String DESCRIPTION_SATURATED = "saturated";
    public static final String DESCRIPTION_ASSIGNED = "unsaturated assigned";
    public static final String DESCRIPTION_UNASSIGNED = "unsaturated unassigned (u.a.)";
    public static final String DESCRIPTION_UNASSIGNED_SUGGESTED = "u.a. suggested";
    public static final String DESCRIPTION_UNASSIGNED_EVEN_CHAIN = "u.a. even chain";
    public static final String DESCRIPTION_UNASSIGNED_ODD_CHAIN = "u.a. odd chain";
    public static final String DESCRIPTION_UNASSIGNED_EVEN_CHAIN_PARTNER_KNOWN = "u.a. even chain; partner chain assigned / saturated";
    public static final String DESCRIPTION_UNASSIGNED_ODD_CHAIN_PARTNER_KNOWN = "u.a. odd chain; partner chain assigned / saturated";
    public static final String DESCRIPTION_UNASSIGNED_EVEN_CHAIN_PARTNER_UNASSIGNED = "u.a. even chain; partner chain unassigned";
    public static final String DESCRIPTION_UNASSIGNED_ODD_CHAIN_PARTNER_UNASSIGNED = "u.a. odd chain; partner chain unassigned";
    LinkedHashMap<String, LinkedHashMap<String, Double>> totalFAPerClass_ = new LinkedHashMap();
    LinkedHashMap<String, LinkedHashMap<String, Double>> totalFAPerDescription_ = new LinkedHashMap();
    LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<Integer, Double>>> totalOmegaPerClass_ = new LinkedHashMap();
    LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Double>>> totalOmegaFAPerClass_ = new LinkedHashMap();
    LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Double>>>> faContentToPartnerContent_ = new LinkedHashMap();
    LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Double>>>> sn1ContentToSn2Content_ = new LinkedHashMap();
    LinkedHashMap<String, Double> totalFASTD_ = new LinkedHashMap();
    LinkedHashMap<String, Integer> numContributorsTotal_ = new LinkedHashMap();
    LinkedHashMap<String, LinkedHashMap<Integer, Double>> omegaSTD_ = new LinkedHashMap();
    LinkedHashMap<String, LinkedHashMap<Integer, Integer>> numContributorsOmega_ = new LinkedHashMap();

    public void addToTotalFAPerClass(String exp, String lClass, Double amount) {
        if (!this.totalFAPerClass_.containsKey(exp)) {
            this.totalFAPerClass_.put(exp, new LinkedHashMap());
        }
        if (!this.totalFAPerClass_.get(exp).containsKey(lClass)) {
            this.totalFAPerClass_.get(exp).put(lClass, amount);
        } else {
            double before = this.totalFAPerClass_.get(exp).get(lClass);
            this.totalFAPerClass_.get(exp).put(lClass, before + amount);
        }
    }

    public void addToTotalFAPerDescription(String exp, String description, Double amount) {
        if (!this.totalFAPerDescription_.containsKey(exp)) {
            this.totalFAPerDescription_.put(exp, new LinkedHashMap());
        }
        if (!this.totalFAPerDescription_.get(exp).containsKey(description)) {
            this.totalFAPerDescription_.get(exp).put(description, amount);
        } else {
            double before = this.totalFAPerDescription_.get(exp).get(description);
            this.totalFAPerDescription_.get(exp).put(description, before + amount);
        }
    }

    public void addToTotalOmegaPerClass(String exp, String lClass, Integer omegaPos, Double amount) {
        if (!this.totalOmegaPerClass_.containsKey(exp)) {
            this.totalOmegaPerClass_.put(exp, new LinkedHashMap());
        }
        if (!this.totalOmegaPerClass_.get(exp).containsKey(lClass)) {
            this.totalOmegaPerClass_.get(exp).put(lClass, new LinkedHashMap());
        }
        if (!this.totalOmegaPerClass_.get(exp).get(lClass).containsKey(omegaPos)) {
            this.totalOmegaPerClass_.get(exp).get(lClass).put(omegaPos, amount);
        } else {
            double before = this.totalOmegaPerClass_.get(exp).get(lClass).get(omegaPos);
            this.totalOmegaPerClass_.get(exp).get(lClass).put(omegaPos, before + amount);
        }
    }

    public void addToTotalOmegaFAPerClass(String exp, String lClass, String faName, Double amount) {
        if (!this.totalOmegaFAPerClass_.containsKey(exp)) {
            this.totalOmegaFAPerClass_.put(exp, new LinkedHashMap());
        }
        if (!this.totalOmegaFAPerClass_.get(exp).containsKey(lClass)) {
            this.totalOmegaFAPerClass_.get(exp).put(lClass, new LinkedHashMap());
        }
        if (!this.totalOmegaFAPerClass_.get(exp).get(lClass).containsKey(faName)) {
            this.totalOmegaFAPerClass_.get(exp).get(lClass).put(faName, amount);
        } else {
            double before = this.totalOmegaFAPerClass_.get(exp).get(lClass).get(faName);
            this.totalOmegaFAPerClass_.get(exp).get(lClass).put(faName, before + amount);
        }
    }

    public void addToFAContentToPartnerContent(String exp, String lClass, String vo, String partnerVO, Double amount) {
        double before;
        if (!this.faContentToPartnerContent_.containsKey(exp)) {
            this.faContentToPartnerContent_.put(exp, new LinkedHashMap());
        }
        if (!this.faContentToPartnerContent_.get(exp).containsKey(lClass)) {
            this.faContentToPartnerContent_.get(exp).put(lClass, new LinkedHashMap());
        }
        if (!this.faContentToPartnerContent_.get(exp).get(lClass).containsKey(vo)) {
            this.faContentToPartnerContent_.get(exp).get(lClass).put(vo, new LinkedHashMap());
        }
        if (!this.faContentToPartnerContent_.get(exp).get(lClass).get(vo).containsKey(partnerVO)) {
            this.faContentToPartnerContent_.get(exp).get(lClass).get(vo).put(partnerVO, amount);
        } else {
            before = this.faContentToPartnerContent_.get(exp).get(lClass).get(vo).get(partnerVO);
            this.faContentToPartnerContent_.get(exp).get(lClass).get(vo).put(partnerVO, before + amount);
        }
        if (!this.faContentToPartnerContent_.get(exp).get(lClass).containsKey(partnerVO)) {
            this.faContentToPartnerContent_.get(exp).get(lClass).put(partnerVO, new LinkedHashMap());
        }
        if (!this.faContentToPartnerContent_.get(exp).get(lClass).get(partnerVO).containsKey(vo)) {
            this.faContentToPartnerContent_.get(exp).get(lClass).get(partnerVO).put(vo, amount);
        } else {
            before = this.faContentToPartnerContent_.get(exp).get(lClass).get(partnerVO).get(vo);
            this.faContentToPartnerContent_.get(exp).get(lClass).get(partnerVO).put(vo, before + amount);
        }
    }

    public void addToSn1ContentToSn2Content(String exp, String lClass, String sn1, String sn2, Double amount) {
        if (!this.sn1ContentToSn2Content_.containsKey(exp)) {
            this.sn1ContentToSn2Content_.put(exp, new LinkedHashMap());
        }
        if (!this.sn1ContentToSn2Content_.get(exp).containsKey(lClass)) {
            this.sn1ContentToSn2Content_.get(exp).put(lClass, new LinkedHashMap());
        }
        if (!this.sn1ContentToSn2Content_.get(exp).get(lClass).containsKey(sn1)) {
            this.sn1ContentToSn2Content_.get(exp).get(lClass).put(sn1, new LinkedHashMap());
        }
        if (!this.sn1ContentToSn2Content_.get(exp).get(lClass).get(sn1).containsKey(sn2)) {
            this.sn1ContentToSn2Content_.get(exp).get(lClass).get(sn1).put(sn2, amount);
        } else {
            double before = this.sn1ContentToSn2Content_.get(exp).get(lClass).get(sn1).get(sn2);
            this.sn1ContentToSn2Content_.get(exp).get(lClass).get(sn1).put(sn2, before + amount);
        }
    }

    public Vector<String> getExperimentNames() {
        return new Vector<String>(this.totalFAPerClass_.keySet());
    }

    public Double getTotalFA(String experiment) {
        LinkedHashMap<String, Double> totalFAPerClass = this.totalFAPerClass_.get(experiment);
        Double totalFA = 0.0;
        for (String lClass : totalFAPerClass.keySet()) {
            totalFA = totalFA + totalFAPerClass.get(lClass);
        }
        return totalFA;
    }

    public LinkedHashMap<String, Double> getTotalFAPerDescription(String experiment) {
        return this.totalFAPerDescription_.get(experiment);
    }

    public LinkedHashMap<Integer, Double> getNormTotalOmegaFA(String experiment) {
        LinkedHashMap<String, LinkedHashMap<Integer, Double>> totalOmegaFAPerClass = this.totalOmegaPerClass_.get(experiment);
        LinkedHashMap<Integer, Double> normTotalOmegaFA = new LinkedHashMap<Integer, Double>();
        Double totalFA = this.getTotalFA(experiment);
        for (String lClass : totalOmegaFAPerClass.keySet()) {
            LinkedHashMap<Integer, Double> totalOmegaFA = totalOmegaFAPerClass.get(lClass);
            for (Integer omegaPos : totalOmegaFA.keySet()) {
                if (!normTotalOmegaFA.containsKey(omegaPos)) {
                    normTotalOmegaFA.put(omegaPos, 0.0);
                }
                Double before = normTotalOmegaFA.get(omegaPos);
                normTotalOmegaFA.put(omegaPos, before + totalOmegaFA.get(omegaPos));
            }
        }
        for (Integer omegaPos : normTotalOmegaFA.keySet()) {
            Double before = normTotalOmegaFA.get(omegaPos);
            normTotalOmegaFA.put(omegaPos, before / totalFA);
        }
        return normTotalOmegaFA;
    }

    public LinkedHashMap<String, LinkedHashMap<String, Double>> getTotalOmegaFAPerClass(String experiment) {
        return this.totalOmegaFAPerClass_.get(experiment);
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Double>>> getFAContentToPartnerContent(String experiment) {
        return this.faContentToPartnerContent_.get(experiment);
    }

    public LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, Double>>> getSn1ContentToSn2Content(String experiment) {
        return this.sn1ContentToSn2Content_.get(experiment);
    }

    public void addToTotalFAPerClassSTD(String exp, Double amount) {
        if (amount > 0.0) {
            if (!this.totalFASTD_.containsKey(exp)) {
                this.totalFASTD_.put(exp, 0.0);
            }
            double before = this.totalFASTD_.get(exp);
            this.totalFASTD_.put(exp, before + Math.pow(amount, 2.0));
            if (!this.numContributorsTotal_.containsKey(exp)) {
                this.numContributorsTotal_.put(exp, 0);
            }
            int prior = this.numContributorsTotal_.get(exp);
            this.numContributorsTotal_.put(exp, ++prior);
        }
    }

    public void addToTotalOmegaPerClassSTD(String exp, Integer omega, Double amount) {
        if (amount > 0.0) {
            if (!this.omegaSTD_.containsKey(exp)) {
                this.omegaSTD_.put(exp, new LinkedHashMap());
            }
            if (!this.omegaSTD_.get(exp).containsKey(omega)) {
                this.omegaSTD_.get(exp).put(omega, 0.0);
            }
            double before = this.omegaSTD_.get(exp).get(omega);
            this.omegaSTD_.get(exp).put(omega, before + Math.pow(amount, 2.0));
            if (!this.numContributorsOmega_.containsKey(exp)) {
                this.numContributorsOmega_.put(exp, new LinkedHashMap());
            }
            if (!this.numContributorsOmega_.get(exp).containsKey(omega)) {
                this.numContributorsOmega_.get(exp).put(omega, 0);
            }
            int prior = this.numContributorsOmega_.get(exp).get(omega);
            this.numContributorsOmega_.get(exp).put(omega, ++prior);
        }
    }

    public Double getTotalSTD(String exp) {
        Double stdPow = this.totalFASTD_.get(exp);
        Integer numContributors = this.numContributorsTotal_.get(exp);
        return Math.sqrt(stdPow / (double)numContributors.intValue());
    }

    public Double getOmegaSTD(String exp, Integer omega) {
        try {
            Double stdPow = this.omegaSTD_.get(exp).get(omega);
            Integer numContributors = this.numContributorsOmega_.get(exp).get(omega);
            return Math.sqrt(stdPow / (double)numContributors.intValue());
        }
        catch (Exception ex) {
            System.out.println("Likely only one replicate, so no standard deviation...");
            return 0.0;
        }
    }
}

