/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fragai;

import at.tugraz.genome.lda.fragai.CombinedSpectrumContainer;
import at.tugraz.genome.lda.fragai.SpectrumContainer;
import java.util.ArrayList;
import java.util.Hashtable;

public class SpectraInterpreter {
    private ArrayList<SpectrumContainer> spectra_;
    private static final Integer MZ_TOLERANCE = 10;

    public SpectraInterpreter(ArrayList<SpectrumContainer> spectra) {
        this.spectra_ = spectra;
    }

    public ArrayList<CombinedSpectrumContainer> interpretSpectra() {
        Hashtable<String, ArrayList<SpectrumContainer>> spectraForLipid = this.groupSpectraContainer();
        ArrayList<CombinedSpectrumContainer> combinedSpectra = new ArrayList<CombinedSpectrumContainer>();
        for (String lipid : spectraForLipid.keySet()) {
            CombinedSpectrumContainer combined = new CombinedSpectrumContainer(lipid.substring(0, lipid.indexOf("_")), lipid.substring(lipid.indexOf("_") + 1, lipid.length()), MZ_TOLERANCE);
            for (SpectrumContainer container : spectraForLipid.get(lipid)) {
                combined.addContainerCopy(container);
            }
            if (!combined.isViableData()) continue;
            combinedSpectra.add(combined);
        }
        return combinedSpectra;
    }

    private String getSpectrumID(SpectrumContainer spectrum) {
        return spectrum.getEntry().getLipidClass() + "_" + spectrum.getAdduct().getAdductName();
    }

    private Hashtable<String, ArrayList<SpectrumContainer>> groupSpectraContainer() {
        Hashtable<String, ArrayList<SpectrumContainer>> spectraForLipid = new Hashtable<String, ArrayList<SpectrumContainer>>();
        for (SpectrumContainer spectrum : this.spectra_) {
            String id = this.getSpectrumID(spectrum);
            if (!spectraForLipid.containsKey(id)) {
                spectraForLipid.put(id, new ArrayList());
            }
            spectraForLipid.get(id).add(spectrum);
        }
        return spectraForLipid;
    }
}

