/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.fraggli;

import at.tugraz.genome.lda.fraggli.Adduct;
import at.tugraz.genome.lda.fraggli.AdductIonCloud;
import at.tugraz.genome.lda.fraggli.FragGLiPanel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.linkage.Linkage;
import org.eurocarbdb.application.glycanbuilder.massutil.MassUtils;
import org.eurocarbdb.application.glycanbuilder.massutil.Molecule;

public class LDAParser {
    private FragGLiPanel parent_;
    private String filePath_;
    private Glycan structure_;
    private String glycanName_ = "";
    private ArrayList<AdductIonCloud> ionClouds_;
    private FragmentCollection fragments_;

    public LDAParser(ArrayList<AdductIonCloud> ionClouds, FragmentCollection fragments, Glycan structure, FragGLiPanel parent) {
        this.ionClouds_ = ionClouds;
        this.fragments_ = fragments;
        this.structure_ = structure;
        this.parent_ = parent;
        this.filePath_ = "fragRules\\" + this.parent_.getMachineName() + "\\";
        this.createFolder(this.filePath_);
        this.createFolder(this.filePath_ + this.parent_.getFragNameNeg());
        this.createFolder(this.filePath_ + this.parent_.getFragNamePos());
        this.glycanName_ = this.buildGlycanName(structure);
    }

    public void writeGlycan() {
        for (AdductIonCloud ionCloud : this.ionClouds_) {
            String fileName = String.format("%s%s\\%s_%s.%s", this.filePath_, ionCloud.isPositive() ? this.parent_.getFragNamePos() : this.parent_.getFragNameNeg(), this.glycanName_, ionCloud.getName(), "frag.txt");
            try {
                FileOutputStream out = new FileOutputStream(fileName);
                Throwable throwable = null;
                try {
                    out.write(this.buildGeneralSettings(ionCloud).getBytes());
                    out.write(this.buildHeadHeader(ionCloud).getBytes());
                    out.write(this.buildGlycanFragRules(ionCloud).getBytes());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void createFolder(String folderName) {
        File folder = new File(folderName);
        if (!folder.exists()) {
            if (folder.mkdir()) {
                System.out.println("Directory created: " + folder.getAbsolutePath());
            } else if (!folder.exists()) {
                JOptionPane.showMessageDialog(this.parent_, "Failed to create the directory '" + folderName + "'.", "Error", 0);
            } else {
                System.out.println("Directory created: " + folder.getAbsolutePath());
            }
        }
    }

    public String buildGlycanName(Glycan structure) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Residue> allResidues = new ArrayList<Residue>();
        if (structure.getRoot() != null) {
            allResidues.addAll(this.collectChildResidues(structure.getRoot()));
        }
        TreeMap<String, Integer> residueCount = new TreeMap<String, Integer>();
        for (Residue res : allResidues) {
            String resDesc = this.getFragmentName(res);
            if (!residueCount.containsKey(resDesc)) {
                residueCount.put(resDesc, 0);
            }
            residueCount.put(resDesc, residueCount.get(resDesc) + 1);
        }
        String fragment = this.getFragmentShorthand(residueCount);
        ArrayList<String> resTypes = new ArrayList<String>(residueCount.keySet());
        Collections.sort(resTypes);
        if (resTypes.contains("Cer")) {
            resTypes.remove("Cer");
            resTypes.add("Cer");
        }
        for (int i = 0; i < resTypes.size(); ++i) {
            String res = resTypes.get(i);
            sb.append(res);
            sb.append(residueCount.get(res) > 1 ? residueCount.get(res) : "");
            if (i >= resTypes.size() - 1) continue;
            sb.append("_");
        }
        if (fragment != null) {
            sb.append(fragment);
        }
        return sb.toString();
    }

    private String getFragmentName(Residue res) {
        String resDesc = res.getType().getName();
        if (resDesc.contains("#x") || resDesc.contains("#a")) {
            resDesc = resDesc.replaceAll("_.*", "");
            String composition = res.getType().getComposition();
            composition = composition.replaceAll("(?<=[A-Z])1(?!\\d)", "");
            resDesc = resDesc + "_{" + composition + "}";
        }
        return resDesc;
    }

    private boolean isAcidicOnlyNeutralLoss(Glycan structure) {
        ArrayList<Residue> allResidues = this.collectChildResidues(this.structure_.getRoot());
        if (structure.getRoot() != null) {
            ArrayList<Residue> fragResidues = this.collectChildResidues(structure.getRoot());
            ArrayList<Residue> toRemove = new ArrayList<Residue>();
            block0: for (Residue fr : fragResidues) {
                for (Residue ar : allResidues) {
                    if (!fr.typeEquals(ar) || toRemove.contains(ar)) continue;
                    toRemove.add(ar);
                    continue block0;
                }
            }
            allResidues.removeAll(toRemove);
        }
        return this.isAcidicOnly(allResidues);
    }

    private boolean isAcidicOnlyGlycan(Glycan structure) {
        ArrayList<Residue> allResidues = new ArrayList<Residue>();
        if (structure.getRoot() != null) {
            allResidues.addAll(this.collectChildResidues(structure.getRoot()));
        }
        return this.isAcidicOnly(allResidues);
    }

    private boolean isAcidicOnly(ArrayList<Residue> allResidues) {
        for (Residue res : allResidues) {
            if (res.getType().getMSDefaultDescriptor().contains("cleavage") || res.getTypeName().equals("Cer") || res.getType().getDescription().contains("acid")) continue;
            return false;
        }
        return true;
    }

    private String getFragmentShorthand(TreeMap<String, Integer> residueCount) {
        Optional<String> xCleavage;
        Optional<String> aCleavage;
        String a = "#acleavage";
        String b = "#bcleavage";
        String c = "#ccleavage";
        String x = "#xcleavage";
        String y = "#ycleavage";
        String z = "#zcleavage";
        String fragment = null;
        if (residueCount.containsKey(b) || residueCount.containsKey(c) || residueCount.containsKey(y) || residueCount.containsKey(z)) {
            int w = 0;
            if (residueCount.containsKey(b)) {
                w += residueCount.get(b).intValue();
                residueCount.remove(b);
            }
            if (residueCount.containsKey(c)) {
                residueCount.remove(c);
            }
            if (residueCount.containsKey(y)) {
                residueCount.remove(y);
            }
            if (residueCount.containsKey(z)) {
                w += residueCount.get(z).intValue();
                residueCount.remove(z);
            }
            String string = fragment = w == 0 ? null : String.join((CharSequence)"", Collections.nCopies(w, "'"));
        }
        if ((aCleavage = residueCount.keySet().stream().filter(key -> Pattern.compile(a + "_.*").matcher((CharSequence)key).matches()).findFirst()).isPresent()) {
            fragment = "_A" + aCleavage.get().substring(aCleavage.get().lastIndexOf("_") + 1) + (fragment != null ? fragment : "");
            residueCount.remove(aCleavage.get());
        }
        if ((xCleavage = residueCount.keySet().stream().filter(key -> Pattern.compile(x + "_.*").matcher((CharSequence)key).matches()).findFirst()).isPresent()) {
            fragment = "_X" + xCleavage.get().substring(xCleavage.get().lastIndexOf("_") + 1) + (fragment != null ? fragment : "");
            residueCount.remove(xCleavage.get());
        }
        return fragment;
    }

    private ArrayList<Residue> collectChildResidues(Residue r) {
        ArrayList<Residue> children = new ArrayList<Residue>();
        children.add(r);
        for (Linkage l : r.getChildrenLinkages()) {
            children.addAll(this.collectChildResidues(l.getChildResidue()));
        }
        return children;
    }

    private String buildGlycanFragRules(AdductIonCloud ionCloud) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> fragmentNames = new ArrayList<String>();
        ArrayList<String> acidicSpecificFragments = new ArrayList<String>();
        this.buildDefaultFragRules(this.fragments_, fragmentNames, acidicSpecificFragments, ionCloud, sb);
        this.buildNLFragRules(this.fragments_, fragmentNames, acidicSpecificFragments, ionCloud, sb);
        sb = this.filterLines(sb, acidicSpecificFragments);
        sb.append("\n\n\n");
        if (!ionCloud.isPositive()) {
            this.addHeadIntensityRules(sb, acidicSpecificFragments);
            this.addChainRulesNegative(sb, acidicSpecificFragments, ionCloud);
        } else {
            this.addChainRulesPositive(sb, ionCloud);
        }
        return sb.toString();
    }

    private StringBuilder filterLines(StringBuilder sb, ArrayList<String> acidicSpecificFragments) {
        String[] lines = sb.toString().split("\\r?\\n");
        Pattern pattern = Pattern.compile("Name=(.*?)\\s+Formula=(.*?)\\s+Charge=\\d+\\s+MSLevel=(\\d+)\\s+mandatory=.*");
        LinkedHashMap<String, String> shortestNamesMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> nameToLineMap = new LinkedHashMap<String, String>();
        for (String line : lines) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String name = matcher.group(1);
            String formula = matcher.group(2);
            String msLevel = matcher.group(3);
            String key = formula + "_" + msLevel;
            String currentBest = shortestNamesMap.getOrDefault(key, null);
            if (currentBest != null && name.length() >= currentBest.length()) continue;
            shortestNamesMap.put(key, name);
            nameToLineMap.put(key, line);
            if (currentBest == null || !acidicSpecificFragments.contains(currentBest)) continue;
            acidicSpecificFragments.remove(currentBest);
            acidicSpecificFragments.add(name);
        }
        StringBuilder output = new StringBuilder();
        for (String bestLine : nameToLineMap.values()) {
            output.append(bestLine).append("\n");
        }
        return output;
    }

    private String buildRuleString(String fragmentName, String formula) {
        return this.buildRuleString(fragmentName, formula, 1, "false");
    }

    private String buildRuleString(String fragmentName, String formula, Integer charge) {
        return this.buildRuleString(fragmentName, formula, charge, "false");
    }

    private String buildRuleString(String fragmentName, String formula, Integer charge, String mandatory) {
        return String.format("Name=%s \t Formula=%s \t Charge=%s \t MSLevel=2 \t mandatory=%s\nName=%s. \t Formula=%s \t Charge=%s \t MSLevel=3 \t mandatory=%s\n", fragmentName, formula, Math.abs(charge), mandatory, fragmentName, formula, Math.abs(charge), mandatory);
    }

    private void buildDefaultFragRules(FragmentCollection fragColl, ArrayList<String> fragmentNames, ArrayList<String> acidicSpecificFragments, AdductIonCloud ionCloud, StringBuilder sb) {
        for (FragmentEntry entry : fragColl.getFragments()) {
            if (entry.getStructure().contains("Cer")) continue;
            try {
                String fragmentName = this.buildGlycanName(entry.getFragment());
                if (fragmentNames.contains(fragmentName)) continue;
                fragmentNames.add(fragmentName);
                if (!ionCloud.isPositive() && this.isAcidicOnlyGlycan(entry.getFragment()) && fragmentName.endsWith("'")) {
                    acidicSpecificFragments.add(fragmentName);
                }
                Molecule molecule = entry.getFragment().computeMolecule();
                Adduct adduct = ionCloud.getAdductByCharge(ionCloud.isPositive() ? 1 : -1);
                Molecule adductMolecule = molecule.clone();
                for (String atom : adduct.getAtoms().keySet()) {
                    adductMolecule.add(atom, (int)adduct.getAtoms().get(atom));
                }
                String formula = adductMolecule.toString();
                sb.append(this.buildRuleString(fragmentName, formula, adduct.getCharge()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void buildNLFragRules(FragmentCollection fragColl, ArrayList<String> fragmentNames, ArrayList<String> acidicSpecificFragments, AdductIonCloud ionCloud, StringBuilder sb) {
        try {
            this.addCerOnlyRules(ionCloud, sb);
            for (FragmentEntry entry : fragColl.getFragments()) {
                String fragmentName;
                if (!entry.getStructure().contains("Cer") || fragmentNames.contains(fragmentName = this.buildGlycanName(entry.getFragment())) || fragmentName.equals(this.glycanName_)) continue;
                fragmentNames.add(fragmentName);
                if (!ionCloud.isPositive() && this.isAcidicOnlyNeutralLoss(entry.getFragment()) && !fragmentName.contains("_X{") && !fragmentName.endsWith("'")) {
                    acidicSpecificFragments.add(fragmentName);
                }
                Molecule molecule = this.structure_.computeMolecule();
                molecule.remove(entry.getFragment().computeMolecule());
                String formula = String.format("Precursor_(%s%s)-%s", 1, ionCloud.isPositive() ? "+" : "-", molecule.toString());
                sb.append(this.buildRuleString(fragmentName, formula));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addCerOnlyRules(AdductIonCloud ionCloud, StringBuilder sb) throws Exception {
        String fragmentName = "Cer";
        Molecule molecule = this.structure_.computeMolecule().and("H", -1);
        String formula = String.format("Precursor_(%s%s)-%s", 1, ionCloud.isPositive() ? "+" : "-", molecule.toString());
        String rule1 = this.buildRuleString(fragmentName, formula);
        fragmentName = "Cer'";
        molecule = molecule.and(MassUtils.water);
        formula = String.format("Precursor_(%s%s)-%s", 1, ionCloud.isPositive() ? "+" : "-", molecule.toString());
        String rule2 = this.buildRuleString(fragmentName, formula);
        fragmentName = "Cer''";
        molecule = molecule.and(MassUtils.water);
        formula = String.format("Precursor_(%s%s)-%s", 1, ionCloud.isPositive() ? "+" : "-", molecule.toString());
        String rule3 = this.buildRuleString(fragmentName, formula);
        fragmentName = ":N'";
        molecule.add("C");
        formula = String.format("Precursor_(%s%s)-%s", 1, ionCloud.isPositive() ? "+" : "-", molecule.toString());
        String rule4 = this.buildRuleString(fragmentName, formula);
        fragmentName = ":No";
        molecule.remove("O");
        formula = String.format("Precursor_(%s%s)-%s", 1, ionCloud.isPositive() ? "+" : "-", molecule.toString());
        String rule5 = this.buildRuleString(fragmentName, formula);
        fragmentName = ":N";
        molecule.remove("H", 2);
        formula = String.format("Precursor_(%s%s)-%s", 1, ionCloud.isPositive() ? "+" : "-", molecule.toString());
        String rule6 = this.buildRuleString(fragmentName, formula);
        sb.append(rule4);
        sb.append(rule5);
        sb.append(rule6);
        sb.append(rule3);
        sb.append(rule2);
        sb.append(rule1);
    }

    private void addHeadIntensityRules(StringBuilder sb, ArrayList<String> frags) {
        if (!frags.isEmpty()) {
            sb.append("!INTENSITIES\n");
            sb.append("Equation=");
            for (int i = 0; i < frags.size(); ++i) {
                sb.append(frags.get(i));
                if (i >= frags.size() - 1) continue;
                sb.append("|");
            }
            sb.append(" \t mandatory=true\n");
            sb.append("\n\n\n");
        }
    }

    private String buildGeneralSettings(AdductIonCloud ionCloud) {
        StringBuilder sb = new StringBuilder();
        sb.append("[GENERAL]\n");
        sb.append("AmountOfChains=2\n");
        sb.append("AmountOfLCBs=1\n");
        sb.append("ChainLibrary=fattyAcidChains.xlsx\n");
        sb.append("LCBLibrary=dSPB_Ganglio.xlsx\t\n");
        sb.append("CAtomsFromName=\\D*(\\d+):\\d+\n");
        sb.append("DoubleBondsFromName=\\D*\\d+:(\\d+)\n");
        sb.append("FaHydroxylationRange=0-1\n");
        sb.append("LcbHydroxylationRange=2-3\n");
        sb.append("RetentionTimePostprocessing=true\n");
        sb.append("SpectrumCoverage=15%\n");
        sb.append(String.format("SingleChainIdentification=true\n", new Object[0]));
        sb.append("\n\n\n");
        return sb.toString();
    }

    private String buildHeadHeader(AdductIonCloud ionCloud) {
        StringBuilder sb = new StringBuilder();
        sb.append("[HEAD]\n");
        sb.append("!FRAGMENTS\n");
        sb.append(String.format("Name=Precursor_(%s%s) \t Formula=$PRECURSOR \t Charge=%s \t MSLevel=2 \t mandatory=false\n", Math.abs(ionCloud.totalCharge()), ionCloud.isPositive() ? "+" : "-", Math.abs(ionCloud.totalCharge())));
        sb.append(String.format("Name=Precursor_(%s%s)' \t Formula=$PRECURSOR-H2O \t Charge=%s \t MSLevel=2 \t mandatory=false\n", Math.abs(ionCloud.totalCharge()), ionCloud.isPositive() ? "+" : "-", Math.abs(ionCloud.totalCharge())));
        for (int i = 1; i < Math.abs(ionCloud.totalCharge()); ++i) {
            Adduct adductOpposite;
            Integer diff = Math.abs(ionCloud.totalCharge()) - i;
            if (diff < 1 || (adductOpposite = ionCloud.getAdductByCharge(diff = Integer.valueOf(ionCloud.isPositive() ? diff : -diff.intValue()))) == null) continue;
            sb.append(String.format("Name=Precursor_(%s%s) \t Formula=$PRECURSOR%s \t Charge=%s \t MSLevel=2 \t mandatory=false\n", i, ionCloud.isPositive() ? "+" : "-", adductOpposite.getFormula(true), Math.abs(i)));
            sb.append(String.format("Name=Precursor_(%s%s)' \t Formula=$PRECURSOR-H2O%s \t Charge=%s \t MSLevel=2 \t mandatory=false\n", i, ionCloud.isPositive() ? "+" : "-", adductOpposite.getFormula(true), Math.abs(i)));
        }
        return sb.toString();
    }

    private void addChainRulesNegative(StringBuilder sb, ArrayList<String> frags, AdductIonCloud ionCloud) {
        ArrayList<String> jFragments = new ArrayList<String>();
        ArrayList<String> gFragments = new ArrayList<String>();
        Adduct adduct = ionCloud.getAdductByCharge(ionCloud.isPositive() ? 1 : -1);
        String adductFormula = adduct.getFormula(false);
        sb.append("[CHAINS]\n");
        sb.append("!FRAGMENTS\n");
        String[] chainRules = new String[]{"Name=:U%s \t Formula=$CHAIN-O+NH%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:U'%s \t Formula=$CHAIN-HO2+N%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:Uo%s \t Formula=$CHAIN%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:Uo'%s \t Formula=$CHAIN-H2O%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:O%s \t Formula=$LCB%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:O'%s \t Formula=$LCB-H2O%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:O''%s \t Formula=$LCB-H4O2%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:P%s \t Formula=$LCB-C2H5NO%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:P'%s \t Formula=$LCB-C2H7NO2%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:Q%s \t Formula=$LCB-CH2O%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:Q'%s \t Formula=$LCB-CH4O2%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:T%s \t Formula=$CHAIN-O+C2H3N%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:T'%s \t Formula=$CHAIN-O2+C2HN%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:S%s \t Formula=$CHAIN+C2H3N%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:S'%s \t Formula=$CHAIN-O+C2HN%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:J%s \t Formula=Precursor_(1-)-$CHAIN+C2H4O \t Charge=1 \t MSLevel=%s \t mandatory=false\n"};
        for (int i = 0; i < chainRules.length; ++i) {
            String rule = chainRules[i];
            if (rule.split("%s", -1).length - 1 < 3) {
                sb.append(String.format(rule, "", 2));
                sb.append(String.format(rule, ".", 3));
                continue;
            }
            if (rule.split("%s", -1).length - 1 != 3) continue;
            sb.append(String.format(rule, "", adductFormula, 2));
            sb.append(String.format(rule, ".", adductFormula, 3));
        }
        for (String frag : frags) {
            if (!frag.endsWith("-H2O") || frag.contains("Cer")) continue;
            String jFragment = ":J-" + frag;
            jFragments.add(jFragment);
            sb.append(String.format("Name=%s \t Formula=:J-%s%s \t Charge=1 \t MSLevel=2 \t mandatory=false\n", jFragment, frag, adductFormula));
        }
        sb.append(String.format("Name=:G \t Formula=Precursor_(1-)-$LCB+C2H5NO \t Charge=1 \t MSLevel=2 \t mandatory=%s\n", "false"));
        gFragments.add(":G");
        for (String frag : frags) {
            if (!frag.endsWith("'") || frag.contains("Cer")) continue;
            String gFragment = ":G-" + frag;
            gFragments.add(gFragment);
            sb.append(String.format("Name=%s \t Formula=:G-%s%s \t Charge=1 \t MSLevel=2 \t mandatory=false\n", gFragment, frag, adductFormula));
        }
        sb.append("\n\n\n");
        sb.append("!INTENSITIES\n");
        sb.append("Equation=:T|:T. \t mandatory=false\n");
        sb.append("Equation=:Uo|:Uo. \t mandatory=false\n");
        sb.append("\n\n\n");
        sb.append("[POSITION]\n");
        sb.append("!INTENSITIES\n");
        sb.append("Equation=:T[2]+:T.[2]+:Uo[2]+:Uo.[2]>0*$BASEPEAK \t mandatory=true\n");
    }

    private void addChainRulesPositive(StringBuilder sb, AdductIonCloud ionCloud) {
        Adduct adduct = ionCloud.getAdductByCharge(ionCloud.isPositive() ? 1 : -1);
        String adductFormula = adduct.getFormula(false);
        sb.append("[CHAINS]\n");
        sb.append("!FRAGMENTS\n");
        String[] chainRules = new String[]{"Name=:U%s \t Formula=$CHAIN \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:U'%s \t Formula=$CHAIN-H2O \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:O%s \t Formula=$LCB%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:O'%s \t Formula=$LCB-H2O%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:O''%s \t Formula=$LCB-H4O2%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:O'''%s \t Formula=$LCB-H6O3%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:Q%s \t Formula=$LCB-CH2O%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:Q'%s \t Formula=$LCB-CH4O2%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=:Q''%s \t Formula=$LCB-CH6O3%s \t Charge=1 \t MSLevel=%s \t mandatory=false\n", "Name=x:O''%s \t Formula=:O''+C \t Charge=1 \t MSLevel=%s \t mandatory=other\n"};
        for (int i = 0; i < chainRules.length; ++i) {
            String rule = chainRules[i];
            if (rule.split("%s", -1).length - 1 < 3) {
                sb.append(String.format(rule, "", 2));
                sb.append(String.format(rule, ".", 3));
                continue;
            }
            if (rule.split("%s", -1).length - 1 != 3) continue;
            sb.append(String.format(rule, "", adductFormula, 2));
            sb.append(String.format(rule, ".", adductFormula, 3));
        }
        sb.append("\n\n\n");
        sb.append("!INTENSITIES\n");
        sb.append("Equation=:O''|:O''. \t mandatory=true\n");
        sb.append("Equation=:O'|:O'. \t mandatory=true\n");
        sb.append("Equation=:O''+:O''.+:O'+:O'.>x:O''+x:O''. \t mandatory=true\n");
        sb.append("Equation=(:O''+:O''.+:O'+:O'.)*2>:U+:U.+:U'+:U'. \t mandatory=true\n");
        sb.append("\n\n\n");
        sb.append("[POSITION]\n");
        sb.append("!INTENSITIES\n");
        sb.append("Equation=:O''[1]+:O''.[1]>0*$BASEPEAK \t mandatory=true\n");
    }
}

