/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl;

import at.tugraz.genome.lda.lccl.JDefaultComponents;
import at.tugraz.genome.lda.lccl.JOptionPanel;
import at.tugraz.genome.lda.lccl.JTargetFileWizard;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ChooserPanel
extends JOptionPanel {
    private static final long serialVersionUID = 1L;
    private JTargetFileWizard jTargetFileWizard_;

    public ChooserPanel(JDefaultComponents wizardComponents, JTargetFileWizard jTargetFileWizard) {
        super(wizardComponents, "Create a new RT-DB with information for \u03c9-position identification.");
        this.jTargetFileWizard_ = jTargetFileWizard;
        this.init();
    }

    private void init() {
        Dimension preferredSizeTextOneLine = new Dimension(825, 15);
        this.setLayout(new GridBagLayout());
        JPanel calibrationPanel = this.initCalibrationPanel(preferredSizeTextOneLine);
        JPanel experimentsPanel = this.initExperimentsPanel(preferredSizeTextOneLine);
        calibrationPanel.setBorder(this.getPanelBorder());
        experimentsPanel.setBorder(this.getPanelBorder());
        this.add((Component)calibrationPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(25, 25, 25, 25), 0, 0));
        this.add((Component)experimentsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(25, 25, 25, 25), 0, 0));
    }

    private JPanel initCalibrationPanel(Dimension sizeTextOneLine) {
        JPanel calibrationPanel = new JPanel();
        calibrationPanel.setLayout(new GridBagLayout());
        JLabel title = new JLabel("<html>RT-DB predictor - map an RT-DB to your chromatographic conditions.</html>");
        title.setFont(new Font("Arial", 1, 24));
        title.setPreferredSize(new Dimension(sizeTextOneLine.width, sizeTextOneLine.height * 4));
        title.setMinimumSize(new Dimension(title.getPreferredSize().width / 2, title.getPreferredSize().height));
        JLabel requirementsHeader = new JLabel("<html> Requirements:</html>");
        requirementsHeader.setFont(new Font("Arial", 1, 18));
        requirementsHeader.setPreferredSize(new Dimension(sizeTextOneLine.width, sizeTextOneLine.height * 2));
        requirementsHeader.setMinimumSize(new Dimension(requirementsHeader.getPreferredSize().width / 2, requirementsHeader.getPreferredSize().height));
        JLabel requirements = new JLabel("<html> <ul style=\"list-style-type:circle;\"> <li> An RT-DB in LDA-format. </li><li> Experimental data (analyzed with LDA) of an (internal) standard mix and/or biological samples measured with the exact same chromatographic conditions the RT-DB was created with. </li><li> Experimental data (analyzed with LDA) of a (ideally the same) standard mix and/or biological samples measured with your chromatography. </li></html>");
        requirements.setFont(new Font("Arial", 0, 12));
        requirements.setPreferredSize(new Dimension(sizeTextOneLine.width, sizeTextOneLine.height * 5));
        requirements.setMinimumSize(new Dimension(requirements.getPreferredSize().width / 2, requirements.getPreferredSize().height * 2));
        JButton calibrateButton = new JButton();
        calibrateButton.setText("Continue");
        calibrateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooserPanel.this.calibrateButton_actionPerformed(e);
            }
        });
        calibrationPanel.add((Component)title, this.getDefaultConstraints(0, 0, 17, 5, 0));
        calibrationPanel.add((Component)requirementsHeader, this.getDefaultConstraints(0, 1, 17, 5, 0));
        calibrationPanel.add((Component)requirements, this.getDefaultConstraints(0, 2, 17, 5, 0));
        calibrationPanel.add((Component)calibrateButton, this.getDefaultConstraints(0, 3, 10, 0, 10));
        return calibrationPanel;
    }

    private JPanel initExperimentsPanel(Dimension sizeTextOneLine) {
        JPanel experimentsPanel = new JPanel();
        experimentsPanel.setLayout(new GridBagLayout());
        JLabel title = new JLabel("<html>RT-DB generator - create a new RT-DB.</html>");
        title.setFont(new Font("Arial", 1, 24));
        title.setPreferredSize(new Dimension(sizeTextOneLine.width, sizeTextOneLine.height * 4));
        title.setMinimumSize(new Dimension(title.getPreferredSize().width / 2, title.getPreferredSize().height));
        JLabel requirementsHeader = new JLabel("<html> Requirements:</html>");
        requirementsHeader.setFont(new Font("Arial", 1, 18));
        requirementsHeader.setPreferredSize(new Dimension(sizeTextOneLine.width, sizeTextOneLine.height * 2));
        requirementsHeader.setMinimumSize(new Dimension(requirementsHeader.getPreferredSize().width / 2, requirementsHeader.getPreferredSize().height));
        JLabel requirements = new JLabel("<html> <ul style=\"list-style-type:circle;\"> <li> Experimental data (analyzed with LDA) of analytes with SIL specific for \u03c9-positions. </li><li> If deuterium labels are used: experimental data (analyzed with LDA) of unlabeled authentic standards with known \u03c9-positions. <br>Ideally at least one standard for each deuterium label should be provided, with the respective labeled isotopologue identified in the SIL data. <br>(For <sup>13</sup>C labels experimental data of unlabeled authentic standards is not needed.) </li></ul> </html>");
        requirements.setFont(new Font("Arial", 0, 12));
        requirements.setPreferredSize(new Dimension(sizeTextOneLine.width, sizeTextOneLine.height * 5));
        requirements.setMinimumSize(new Dimension(requirements.getPreferredSize().width / 2, requirements.getPreferredSize().height * 2));
        JButton experimentsButton = new JButton();
        experimentsButton.setText("Continue");
        experimentsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooserPanel.this.experimentsButton_actionPerformed(e);
            }
        });
        experimentsPanel.add((Component)title, this.getDefaultConstraints(0, 0, 17, 5, 0));
        experimentsPanel.add((Component)requirementsHeader, this.getDefaultConstraints(0, 1, 17, 5, 0));
        experimentsPanel.add((Component)requirements, this.getDefaultConstraints(0, 2, 17, 5, 0));
        experimentsPanel.add((Component)experimentsButton, this.getDefaultConstraints(0, 3, 10, 0, 10));
        return experimentsPanel;
    }

    private GridBagConstraints getDefaultConstraints(int gridx, int gridy, int anchor, int left, int ipady) {
        return new GridBagConstraints(gridx, gridy, 1, 1, 0.0, 0.0, anchor, 0, new Insets(5, left, 5, 0), 0, ipady);
    }

    private Border getPanelBorder() {
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        return BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
    }

    void calibrateButton_actionPerformed(ActionEvent e) {
        this.jTargetFileWizard_.initCalibration();
    }

    void experimentsButton_actionPerformed(ActionEvent e) {
        this.jTargetFileWizard_.initExperiment();
    }
}

