/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.experiment;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.lccl.IsotopeLabelVO;
import at.tugraz.genome.lda.lccl.JDefaultComponents;
import at.tugraz.genome.lda.lccl.JOptionPanel;
import at.tugraz.genome.lda.lccl.LoadingPanel;
import at.tugraz.genome.lda.lccl.experiment.ExperimentLabelDefinitionPanel;
import at.tugraz.genome.lda.lccl.experiment.IsotopeEffectRegression;
import at.tugraz.genome.lda.lccl.experiment.MatchedPartnerVO;
import at.tugraz.genome.lda.lccl.experiment.TotalIsotopeEffectPlot;
import at.tugraz.genome.lda.lccl.export.ExportOptionsPanel;
import at.tugraz.genome.lda.lccl.export.ExportPanel;
import at.tugraz.genome.lda.lccl.export.TargetListExporter;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.utils.UpdatablePair;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.lda.vos.ResultFileVO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class ExperimentGraphPanel
extends JOptionPanel {
    private static final long serialVersionUID = 1L;
    private static final int EDITABLE_COLUMN = 2;
    private static final String TABLE_FRAME_TITLE = "Computation of the total deuterium isotope effect on retention time.";
    private static final Dimension TABLE_PANEL_DIMENSION = new Dimension(825, 200);
    private static final Dimension PLOT_DIMENSION = new Dimension(825, 500);
    private ExperimentLabelDefinitionPanel labelDefinitionPanel_;
    private LoadingPanel loadingPanel_ = new LoadingPanel("<html>Computing data, please wait...</html>");
    private JPanel displayPanel_;
    private Vector<MatchedPartnerVO> matchedIsotopologues_;
    private IsotopeEffectRegression isotopeEffectRegression_;
    private TotalIsotopeEffectPlot plot_;

    public ExperimentGraphPanel(JDefaultComponents wizardComponents) {
        super(wizardComponents, "Create RT-DB using experimental data of SIL specific for \u03c9-positions.");
        this.init(this.loadingPanel_);
    }

    protected void init(JPanel panel) {
        this.add((Component)panel, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.invalidate();
        this.updateUI();
    }

    public void matchIsotopologues(Vector<UpdatablePair<ResultFileVO, Integer>> standardsFileVOs, ExperimentLabelDefinitionPanel labelDefinitionPanel) throws LipidCombinameEncodingException {
        Hashtable<String, Vector<LipidomicsMSnSet>> authenticStandards = this.collectStandards(standardsFileVOs);
        this.labelDefinitionPanel_ = labelDefinitionPanel;
        this.matchedIsotopologues_ = this.collectMatchedIsotopologues(authenticStandards, labelDefinitionPanel);
        this.isotopeEffectRegression_ = new IsotopeEffectRegression(this.matchedIsotopologues_, labelDefinitionPanel.getAssignedIsotopeLabels());
    }

    public void initDataDisplay() {
        this.cleanPanels();
        String[] columnNames = new String[]{"Authentic standards", "Matched isotopologues", "Choose pairs for the calibration."};
        Object[][] tableData = this.generateTableData();
        this.getDefaultComponents().updateComponents();
        this.init(this.generateDisplayPanel(columnNames, tableData, 2));
    }

    private void cleanPanels() {
        if (this.loadingPanel_ != null) {
            this.remove(this.loadingPanel_);
            this.loadingPanel_ = null;
        }
        if (this.displayPanel_ != null) {
            this.remove(this.displayPanel_);
            this.displayPanel_ = null;
        }
    }

    private String convertLipidomicsMSnSetToTableDisplayName(MatchedPartnerVO match, boolean isStandard) {
        String displayName = "";
        LipidomicsMSnSet standard = match.getStandard();
        if (isStandard) {
            displayName = String.format("%s %s, RT = %s min", match.getLipidClass(), standard.getOmegaInformation().get(0).getDoubleBondPositionsHumanReadable(), standard.getRt());
        } else {
            LipidomicsMSnSet set = match.getIsotopologue();
            Vector<String> normed = this.normChainCombination(standard.getValidChainCombinations().iterator().next(), match.getLabel());
            Vector<String> chainCombis = set.getValidChainCombinations();
            for (String chainCombi : chainCombis) {
                if (!this.normChainCombination(chainCombi, match.getLabel()).equals(normed)) continue;
                try {
                    displayName = String.format("%s %s, RT = %s min", match.getLipidClass(), set.getHumanReadableChainCombi(chainCombi, true), set.getRt());
                }
                catch (LipidCombinameEncodingException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return displayName;
    }

    protected Object[][] generateTableData() {
        Object[][] tableData = new Object[this.matchedIsotopologues_.size()][3];
        int count = 0;
        for (MatchedPartnerVO match : this.matchedIsotopologues_) {
            tableData[count][0] = this.convertLipidomicsMSnSetToTableDisplayName(match, true);
            tableData[count][1] = this.convertLipidomicsMSnSetToTableDisplayName(match, false);
            tableData[count][2] = match.isUseForCalibration();
            ++count;
        }
        return tableData;
    }

    protected JPanel generateDisplayPanel(String[] columnNames, Object[][] tableData, int editableColumn) {
        this.displayPanel_ = new JPanel();
        this.displayPanel_.setLayout(new GridBagLayout());
        DataModel model = new DataModel(tableData, columnNames);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                MatchedPartnerVO vo;
                boolean before = (vo = (MatchedPartnerVO)ExperimentGraphPanel.this.matchedIsotopologues_.get(e.getFirstRow())).isUseForCalibration();
                vo.setUseForCalibration(!before);
                ExperimentGraphPanel.this.isotopeEffectRegression_ = new IsotopeEffectRegression(ExperimentGraphPanel.this.matchedIsotopologues_, ExperimentGraphPanel.this.labelDefinitionPanel_.getAssignedIsotopeLabels());
                ExperimentGraphPanel.this.updatePlot();
            }
        });
        JTable standardsTable = new JTable(model);
        standardsTable.setRowHeight(30);
        JScrollPane scrollPane = new JScrollPane(standardsTable);
        scrollPane.setPreferredSize(TABLE_PANEL_DIMENSION);
        this.plot_ = new TotalIsotopeEffectPlot(this.matchedIsotopologues_, this.isotopeEffectRegression_, PLOT_DIMENSION);
        this.displayPanel_.add((Component)scrollPane, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.addPlotToDisplayPanel();
        this.displayPanel_.setBorder(ExperimentGraphPanel.getTitledPanelBorder(TABLE_FRAME_TITLE));
        return this.displayPanel_;
    }

    private void updatePlot() {
        this.displayPanel_.remove(this.plot_);
        this.plot_ = new TotalIsotopeEffectPlot(this.matchedIsotopologues_, this.isotopeEffectRegression_, PLOT_DIMENSION);
        this.addPlotToDisplayPanel();
        this.displayPanel_.invalidate();
        this.displayPanel_.updateUI();
    }

    private void addPlotToDisplayPanel() {
        this.displayPanel_.add((Component)this.plot_, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 10, 0, new Insets(25, 0, 0, 0), 0, 0));
    }

    protected Vector<MatchedPartnerVO> collectMatchedIsotopologues(Hashtable<String, Vector<LipidomicsMSnSet>> authenticStandards, ExperimentLabelDefinitionPanel labelDefinitionPanel) {
        Vector<MatchedPartnerVO> matched = new Vector<MatchedPartnerVO>();
        for (ResultFileVO resultFileVO : labelDefinitionPanel.getResultFiles()) {
            QuantificationResult quantRes = resultFileVO.getQuantificationResult();
            for (String lipidClass : authenticStandards.keySet()) {
                Vector<LipidomicsMSnSet> standards = authenticStandards.get(lipidClass);
                Vector<LipidParameterSet> results = quantRes.getIdentifications().get(lipidClass);
                for (LipidParameterSet result : results) {
                    if (!(result instanceof LipidomicsMSnSet) || result.getDoubleBonds() <= 0 || !result.getChemicalFormula().contains("D")) continue;
                    LipidomicsMSnSet resultMSn = (LipidomicsMSnSet)result;
                    for (LipidomicsMSnSet standard : standards) {
                        IsotopeLabelVO labelVO;
                        if (!this.isEquivalentCompound(standard, resultMSn, labelVO = this.matchLabelToStandard(labelDefinitionPanel.getAssignedIsotopeLabels(), standard))) continue;
                        matched.add(new MatchedPartnerVO(lipidClass, standard, resultMSn, this.isPositionAssignmentMatch(standard, resultMSn, labelVO), labelVO));
                    }
                }
            }
        }
        matched.sort(Comparator.comparing(MatchedPartnerVO::isUseForCalibration).reversed());
        return matched;
    }

    private boolean isPositionAssignmentMatch(LipidomicsMSnSet compound, LipidomicsMSnSet labeledCompound, IsotopeLabelVO labelVO) {
        boolean matches = false;
        Set<String> humanReadable1 = compound.getHumanReadableNameSet();
        Set<String> humanReadable2 = labeledCompound.getHumanReadableNameSet();
        for (String name : humanReadable2) {
            if (!humanReadable1.contains(name = name.replaceAll(labelVO.getLabelId(), ""))) continue;
            matches = true;
        }
        return matches;
    }

    private boolean isEquivalentCompound(LipidomicsMSnSet compound, LipidomicsMSnSet labeledCompound, IsotopeLabelVO labelVO) {
        boolean isEquivalent = false;
        if (compound.getNameStringWithoutRt().equals(labeledCompound.getNameStringWithoutRt().replaceAll(labelVO.getLabelId(), ""))) {
            try {
                Hashtable<String, Integer> chemicalFormula1 = StaticUtils.categorizeFormula(compound.getChemicalFormula());
                Hashtable<String, Integer> chemicalFormula2 = this.replaceIsotopesInFormula(labeledCompound.getChemicalFormula(), labelVO);
                if (StaticUtils.isChemicalFormulaTheSame(chemicalFormula1, chemicalFormula2)) {
                    Vector<String> chainCombis1 = compound.getValidChainCombinations();
                    Vector<String> chainCombis2 = labeledCompound.getValidChainCombinations();
                    isEquivalent = this.isEquivalentChainCombinationPresent(chainCombis1, chainCombis2, labelVO);
                }
            }
            catch (ChemicalFormulaException ex) {
                ex.printStackTrace();
            }
        }
        return isEquivalent;
    }

    private boolean isEquivalentChainCombinationPresent(Vector<String> chainCombis1, Vector<String> labeledChainCombis, IsotopeLabelVO labelVO) {
        for (String chainCombi1 : chainCombis1) {
            for (String chainCombi2 : labeledChainCombis) {
                if (!this.normChainCombination(chainCombi1, labelVO).equals(this.normChainCombination(chainCombi2, labelVO))) continue;
                return true;
            }
        }
        return false;
    }

    private Vector<String> normChainCombination(String chainCombination, IsotopeLabelVO labelVO) {
        String removedLabels = chainCombination.replaceAll(labelVO.getLabelId(), "");
        Vector<String> split = new Vector<String>(Arrays.asList(removedLabels.split("<->")));
        split.sort(Comparator.nullsFirst(Comparator.comparing(String::length).thenComparing(Comparator.naturalOrder())));
        return split;
    }

    private Hashtable<String, Integer> replaceIsotopesInFormula(String chemicalFormulaLabeled, IsotopeLabelVO labelVO) throws ChemicalFormulaException {
        Hashtable<String, Integer> chemicalFormula = null;
        try {
            chemicalFormula = StaticUtils.categorizeFormula(chemicalFormulaLabeled);
            for (String element : labelVO.getLabelElements().keySet()) {
                int nr = 0;
                if (chemicalFormula.containsKey(element)) {
                    nr = chemicalFormula.get(element);
                }
                if ((nr -= labelVO.getLabelElements().get(element).intValue()) == 0) {
                    chemicalFormula.remove(element);
                    continue;
                }
                chemicalFormula.put(element, nr);
            }
        }
        catch (ChemicalFormulaException ex) {
            throw new ChemicalFormulaException(ex);
        }
        return chemicalFormula;
    }

    private IsotopeLabelVO matchLabelToStandard(Vector<IsotopeLabelVO> labels, LipidParameterSet standard) {
        IsotopeLabelVO matchedLabel = null;
        int omegaPosition = -1;
        DoubleBondPositionVO doubleBondPositionVO = standard.getOmegaInformation().get(0);
        for (FattyAcidVO fattyAcid : doubleBondPositionVO.getChainCombination()) {
            if (fattyAcid.getDoubleBonds() <= 0) continue;
            omegaPosition = fattyAcid.getOmegaPosition();
            break;
        }
        for (IsotopeLabelVO label : labels) {
            if (label.getOmegaPosition() != omegaPosition) continue;
            matchedLabel = label;
            break;
        }
        return matchedLabel;
    }

    private Hashtable<String, Vector<LipidomicsMSnSet>> collectStandards(Vector<UpdatablePair<ResultFileVO, Integer>> standardsFileVOs) throws LipidCombinameEncodingException {
        Hashtable<String, Vector<LipidomicsMSnSet>> authenticStandards = new Hashtable<String, Vector<LipidomicsMSnSet>>();
        for (UpdatablePair<ResultFileVO, Integer> standard : standardsFileVOs) {
            QuantificationResult result = standard.getKey().getQuantificationResult();
            Hashtable<String, Vector<LipidParameterSet>> identifications = result.getIdentifications();
            for (String lipidClass : identifications.keySet()) {
                if (!authenticStandards.containsKey(lipidClass)) {
                    authenticStandards.put(lipidClass, new Vector());
                }
                for (LipidParameterSet authenticStandard : identifications.get(lipidClass)) {
                    if (!(authenticStandard instanceof LipidomicsMSnSet)) continue;
                    LipidomicsMSnSet mSnSet = (LipidomicsMSnSet)authenticStandard;
                    Set<String> humanReadableNameSet = mSnSet.getHumanReadableNameSet();
                    LinkedHashMap<String, String> lookup = mSnSet.getNameLookupHumReadableToPositionInsensitive();
                    Hashtable<String, FattyAcidVO> involvedFAs = mSnSet.getInvolvedFAs();
                    for (String name : humanReadableNameSet) {
                        Vector<String> positionInsensitiveChains = StaticUtils.splitChainCombiToEncodedStrings(lookup.get(name), "<->");
                        Vector<FattyAcidVO> chainCombination = new Vector<FattyAcidVO>();
                        for (String chain : positionInsensitiveChains) {
                            chainCombination.add(involvedFAs.get(chain));
                        }
                        for (FattyAcidVO fattyAcid : chainCombination) {
                            if (fattyAcid.getDoubleBonds() <= 0) continue;
                            fattyAcid.setOmegaPosition(standard.getValue());
                        }
                        DoubleBondPositionVO doubleBondPositionVO = new DoubleBondPositionVO(chainCombination, Float.parseFloat(authenticStandard.getRt()), 0, name);
                        authenticStandard.addOmegaInformation(doubleBondPositionVO);
                        authenticStandards.get(lipidClass).add(mSnSet);
                    }
                }
            }
        }
        return authenticStandards;
    }

    @Override
    protected void back() {
        try {
            this.getDefaultComponents().removeOptionPanel(this.getDefaultComponents().getCurrentPanel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.goBack();
    }

    @Override
    protected void next() {
        MatchedPartnerVO vo;
        boolean arePairsChosen = false;
        Iterator<MatchedPartnerVO> iterator = this.matchedIsotopologues_.iterator();
        while (iterator.hasNext() && !(arePairsChosen = (vo = iterator.next()).isUseForCalibration() == Boolean.TRUE.booleanValue())) {
        }
        if (arePairsChosen) {
            this.goNext();
            try {
                ExportPanel panel = (ExportPanel)this.getDefaultComponents().getCurrentPanel();
                panel.addNewRTDBCreationOptions(new ExportOptionsPanel(true));
                panel.setExporter(new TargetListExporter(this.isotopeEffectRegression_, this.labelDefinitionPanel_.getResultFiles(), this.labelDefinitionPanel_.getAssignedIsotopeLabels()));
            }
            catch (Exception exception) {}
        } else {
            new WarningMessage(new JFrame(), "Warning", "No pair was chosen. This step is necessary to account for the isotope effect on retention time caused by deuterium labels!");
        }
    }

    private class DataModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        public DataModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return Boolean.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 2;
        }
    }
}

