/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.experiment;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.lccl.experiment.IsotopeEffectRegression;
import at.tugraz.genome.lda.lccl.experiment.MatchedPartnerVO;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.function.Function2D;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class TotalIsotopeEffectPlot
extends JPanel {
    private static final long serialVersionUID = 1L;

    public TotalIsotopeEffectPlot(Vector<MatchedPartnerVO> data, IsotopeEffectRegression regression, Dimension dimension) {
        XYPlot plot = new XYPlot();
        Font fontTitle = new Font("Dialog", 1, 25);
        Font fontLabel = new Font("Dialog", 0, 20);
        Font tickLabel = new Font("Dialog", 0, 14);
        int domainAxisMax = regression.getMaxNumDeuteriumAllowed();
        XYDataset scatterPlotDataset = this.getScatterPlotDataset(data);
        plot.setDataset(0, scatterPlotDataset);
        XYLineAndShapeRenderer scatterRenderer = new XYLineAndShapeRenderer(false, true);
        scatterRenderer.setDefaultLegendTextFont(fontLabel);
        plot.setRenderer(0, scatterRenderer);
        NumberAxis domainAxis = new NumberAxis("Number of deuterium atoms");
        domainAxis.setLabelFont(fontLabel);
        domainAxis.setTickLabelFont(tickLabel);
        domainAxis.setRange(0.0, domainAxisMax);
        plot.setDomainAxis(0, domainAxis);
        NumberAxis rangeAxis = new NumberAxis("Total Isotope Effect (TIE)");
        rangeAxis.setLabelFont(fontLabel);
        rangeAxis.setTickLabelFont(tickLabel);
        rangeAxis.setRange(1.0, this.findMaximumForRangeAxis(data, regression, domainAxisMax));
        plot.setRangeAxis(0, rangeAxis);
        plot.mapDatasetToDomainAxis(0, 0);
        plot.mapDatasetToRangeAxis(0, 0);
        XYDataset curveFitDataset = this.getCurveFitDataset(regression);
        plot.setDataset(1, curveFitDataset);
        XYLineAndShapeRenderer curveRenderer = new XYLineAndShapeRenderer(true, false);
        curveRenderer.setDefaultLegendTextFont(fontLabel);
        curveRenderer.setSeriesFillPaint(1, new Color(255, 255, 255));
        plot.setRenderer(1, curveRenderer);
        JFreeChart chart = new JFreeChart("Isotope effect on retention time", fontTitle, plot, true);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(dimension);
        this.add(chartPanel);
    }

    private double findMaximumForRangeAxis(Vector<MatchedPartnerVO> data, IsotopeEffectRegression regression, int domainAxisMax) {
        double max = 1.0;
        for (MatchedPartnerVO matched : data) {
            double isotopologueRT;
            if (!matched.isUseForCalibration()) continue;
            double standardRT = matched.getStandard().getPreciseRT();
            double totalIsotopeEffect = standardRT / (isotopologueRT = matched.getIsotopologue().getPreciseRT().doubleValue());
            max = totalIsotopeEffect > max ? totalIsotopeEffect : max;
        }
        max = regression.getIsotopeEffect(domainAxisMax) > max ? regression.getIsotopeEffect(domainAxisMax) : max;
        return (max - 1.0) / 10.0 + max;
    }

    private XYDataset getCurveFitDataset(IsotopeEffectRegression regression) {
        int num = 10000;
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries dataSeries = new XYSeries((Comparable)((Object)"Fit"));
        double step = new Double(regression.getMaxNumDeuteriumAllowed()) / (double)num;
        for (int i = 0; i <= num; ++i) {
            double x = (double)i * step;
            double y = regression.getIsotopeEffect(x);
            dataSeries.add(x, y);
        }
        dataset.addSeries(dataSeries);
        return dataset;
    }

    public static XYSeries sampleFunctionOverY(Function2D f, double start, double end, int samples, Comparable<?> seriesKey) {
        XYSeries series = new XYSeries(seriesKey, false);
        double step = (end - start) / (double)(samples - 1);
        for (int i = 0; i < samples; ++i) {
            double y = start + step * (double)i;
            series.add(f.getValue(y), y);
        }
        return series;
    }

    private XYDataset getScatterPlotDataset(Vector<MatchedPartnerVO> data) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        XYSeries dataSeries = new XYSeries((Comparable)((Object)"Matched isotopologues"));
        for (MatchedPartnerVO matched : data) {
            if (!matched.isUseForCalibration()) continue;
            double standardRT = matched.getStandard().getPreciseRT();
            double isotopologueRT = matched.getIsotopologue().getPreciseRT();
            try {
                Hashtable<String, Integer> chemicalFormula = StaticUtils.categorizeFormula(matched.getIsotopologue().getChemicalFormula());
                int numberDeuterium = chemicalFormula.get("D");
                double totalIsotopeEffect = standardRT / isotopologueRT;
                dataSeries.add((double)numberDeuterium, totalIsotopeEffect);
            }
            catch (ChemicalFormulaException ex) {
                ex.printStackTrace();
            }
        }
        dataset.addSeries(dataSeries);
        return dataset;
    }
}

