/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.export;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.lccl.JDefaultComponents;
import at.tugraz.genome.lda.lccl.JOptionPanel;
import at.tugraz.genome.lda.lccl.export.ExportOptionsPanel;
import at.tugraz.genome.lda.lccl.export.TargetListExporter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportPanel
extends JOptionPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private TargetListExporter exporter_;
    private ExportOptionsPanel exportOptionsPanel_;
    private JTextField exportField_;
    private JTextField templateField_;
    private JPanel templatePanel_;
    private Path previousSelection_ = null;
    private static final String PLACEHOLDER_PREFIX = "Enter ";
    private static final String BROWSE = "Browse";
    private static final String COMMAND_OPEN_EXPORT = "Open export";
    private static final String COMMAND_OPEN_TEMPLATE = "Open template";
    private static final Dimension ENTER_FIELD_DIMENSION_MIN = new Dimension(300, 15);
    private static final Dimension ENTER_FIELD_DIMENSION = new Dimension(775, 30);
    private static final Dimension DEFAULT_FILE_CHOOSER_DIMENSION = new Dimension(750, 750);

    public ExportPanel(JDefaultComponents wizardComponents) {
        super(wizardComponents, "RT-DB export");
        this.init();
    }

    private void init() {
        this.exportField_ = this.instantiateJTextField("Enter path and file name for the new RT-DB.");
        JButton exportButton = this.instantiateJButton(COMMAND_OPEN_EXPORT, BROWSE);
        JPanel exportPanel = this.instantiatePanel(this.exportField_, exportButton, "New RT-DB");
        this.add((Component)exportPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(100, 0, 0, 0), 0, 0));
    }

    public void addNewRTDBCreationOptions(ExportOptionsPanel panel) {
        this.addTemplatePanel();
        this.addExportOptionsPanel(panel);
    }

    private void addTemplatePanel() {
        this.templateField_ = this.instantiateJTextField("Enter path and file name for the template LDA mass list the new RT-DB should be based on.");
        JButton templateButton = this.instantiateJButton(COMMAND_OPEN_TEMPLATE, BROWSE);
        this.templatePanel_ = this.instantiatePanel(this.templateField_, templateButton, "Template LDA mass list");
        this.add((Component)this.templatePanel_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addExportOptionsPanel(ExportOptionsPanel panel) {
        this.exportOptionsPanel_ = panel;
        this.add((Component)this.exportOptionsPanel_, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(50, 0, 0, 0), 0, 0));
    }

    private JTextField instantiateJTextField(final String placeholder) {
        final JTextField field = new JTextField();
        field.setMinimumSize(ENTER_FIELD_DIMENSION_MIN);
        field.setPreferredSize(ENTER_FIELD_DIMENSION);
        field.setText(placeholder);
        field.setForeground(Color.GRAY);
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (field.getText().equals(placeholder)) {
                    field.setText("");
                    field.setForeground(Color.BLACK);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (field.getText().isEmpty()) {
                    field.setForeground(Color.GRAY);
                    field.setText(placeholder);
                }
            }
        });
        return field;
    }

    private JButton instantiateJButton(String command, String title) {
        JButton button = new JButton(title);
        button.addActionListener(this);
        button.setActionCommand(command);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        switch (arg0.getActionCommand()) {
            case "Open template": {
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Only .xlsx", "xlsx");
                this.selectPath(0, this.templateField_, filter, "Select the path and file name for the template LDA mass list (.xlsx file)");
                break;
            }
            case "Open export": {
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Only .xlsx", "xlsx");
                this.selectPath(0, this.exportField_, filter, "Select the path and file name for the new RT-DB (.xlsx file)");
                break;
            }
        }
    }

    private void selectPath(int selectionMode, JTextField field, FileNameExtensionFilter filter, String title) {
        int val;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(filter);
        chooser.setPreferredSize(DEFAULT_FILE_CHOOSER_DIMENSION);
        chooser.setFileSelectionMode(selectionMode);
        chooser.setDialogTitle(title);
        if (this.previousSelection_ != null) {
            chooser.setCurrentDirectory(this.previousSelection_.getParent().toFile());
        }
        if ((val = chooser.showOpenDialog(new JFrame())) != 0) {
            return;
        }
        String text = chooser.getSelectedFile().getAbsolutePath();
        this.previousSelection_ = Paths.get(text, new String[0]);
        field.setText(text);
        field.setForeground(Color.BLACK);
    }

    private JPanel instantiatePanel(JTextField textfield, JButton button, String borderTitle) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)textfield, this.getDefaultGridBagConstraints(0, 0));
        panel.add((Component)button, this.getDefaultGridBagConstraints(7, 0));
        panel.setBorder(ExportPanel.getTitledPanelBorder(borderTitle));
        return panel;
    }

    private GridBagConstraints getDefaultGridBagConstraints(int column, int row) {
        return new GridBagConstraints(column, row, 6, 1, 0.0, 0.0, 13, 0, new Insets(10, 6, 0, 0), 0, 10);
    }

    public boolean isPlaceholderTemplate() {
        return this.templateField_ != null && this.templateField_.getText().startsWith(PLACEHOLDER_PREFIX);
    }

    public boolean isPlaceholderExport() {
        return this.exportField_.getText().startsWith(PLACEHOLDER_PREFIX);
    }

    public void setExporter(TargetListExporter exporter) {
        this.exporter_ = exporter;
    }

    public String getOutPath() {
        return this.exportField_.getText();
    }

    public String getTemplatePath() {
        return this.templateField_.getText();
    }

    public ExportOptionsPanel getExportOptions() {
        return this.exportOptionsPanel_;
    }

    @Override
    protected void back() {
        if (this.exportOptionsPanel_ != null) {
            this.remove(this.exportOptionsPanel_);
            this.exportOptionsPanel_ = null;
        }
        if (this.templatePanel_ != null) {
            this.remove(this.templatePanel_);
            this.templatePanel_ = null;
        }
        this.goBack();
    }

    public void export() {
        try {
            this.exporter_.export(this);
        }
        catch (Exception ex) {
            new WarningMessage(new JFrame(), "Error", "An error occurred during the export: " + ex.getMessage());
        }
    }
}

