/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.lccl.export;

import at.tugraz.genome.lda.QuantificationThread;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.ExportException;
import at.tugraz.genome.lda.lccl.IsotopeLabelVO;
import at.tugraz.genome.lda.lccl.calibration.CalibrationGraphPanel;
import at.tugraz.genome.lda.lccl.calibration.RecalibrationRegression;
import at.tugraz.genome.lda.lccl.experiment.IsotopeEffectRegression;
import at.tugraz.genome.lda.lccl.export.ExportPanel;
import at.tugraz.genome.lda.lccl.export.GradientAdjuster;
import at.tugraz.genome.lda.lccl.export.GradientParser;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.parser.MassListParser;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.QuantificationResult;
import at.tugraz.genome.lda.utils.ExcelUtils;
import at.tugraz.genome.lda.utils.RangeDouble;
import at.tugraz.genome.lda.utils.RangeInteger;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.lda.vos.ResultFileVO;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JFrame;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.Pair;
import org.apache.commons.math3.util.Precision;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.dhatim.fastexcel.reader.Cell;
import org.dhatim.fastexcel.reader.CellType;
import org.dhatim.fastexcel.reader.ReadableWorkbook;
import org.dhatim.fastexcel.reader.Sheet;

public class TargetListExporter {
    public static final String HEADER_MOLECULAR_SPECIES_WITH_DOUBLE_BOND_POSITIONS = "mol. species";
    public static final int HEADER_ROW = 1;
    private IsotopeEffectRegression isotopeEffectRegression_;
    private Vector<ResultFileVO> resultFileVO_;
    private Vector<IsotopeLabelVO> labels_;
    private String templatePath_;
    private boolean calibrateSeparately_ = false;
    private CalibrationGraphPanel calibrationGraphPanel_ = null;
    Hashtable<String, Set<Pair<Double, DoubleBondPositionVO>>> beforeAfter_ = new Hashtable();
    Hashtable<String, Vector<Pair<Double, DoubleBondPositionVO>>> comparisonPairsOfClass_ = new Hashtable();

    public TargetListExporter(String templatePath, boolean calibrateSeparately, CalibrationGraphPanel calibrationGraphPanel) {
        this.calibrateSeparately_ = calibrateSeparately;
        this.templatePath_ = templatePath;
        this.calibrationGraphPanel_ = calibrationGraphPanel;
        this.beforeAfter_ = new Hashtable();
    }

    public TargetListExporter(IsotopeEffectRegression isotopeEffectRegression, Vector<ResultFileVO> resultFileVO, Vector<IsotopeLabelVO> labels) {
        this.isotopeEffectRegression_ = isotopeEffectRegression;
        this.resultFileVO_ = resultFileVO;
        this.labels_ = labels;
    }

    protected void export(ExportPanel exportPanel) throws ExportException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(exportPanel.getOutPath()));
             XSSFWorkbook workbook = new XSSFWorkbook();){
            if (this.isRTMapping()) {
                this.exportRTMappedDB(workbook);
            } else {
                this.exportNewRTDB(workbook, exportPanel);
            }
            workbook.write(out);
            System.out.println("workbook written!");
        }
        catch (Exception e) {
            throw new ExportException(e);
        }
    }

    private void exportRTMappedDB(XSSFWorkbook workbook) throws Exception {
        MassListParser massListParser = new MassListParser(this.getTemplatePath());
        for (String cName : massListParser.getClassSequence().keySet()) {
            Vector<DoubleBondPositionVO> allLabeledVOsToAdd = new Vector<DoubleBondPositionVO>();
            XSSFSheet sheet = workbook.createSheet(cName);
            this.writeMassListForSheet(sheet, ExcelUtils.getMassListHeaderStyle(workbook), ExcelUtils.getMassListNumberStyle(workbook), massListParser, cName, allLabeledVOsToAdd);
        }
    }

    private void exportNewRTDB(XSSFWorkbook workbook, ExportPanel exportPanel) throws Exception {
        MassListParser templateParser = new MassListParser(exportPanel.getTemplatePath());
        GradientAdjuster adjuster = GradientParser.parseGradient(exportPanel.getExportOptions().getSelectedGradient());
        if (adjuster == null && exportPanel.getExportOptions().isGradientSelected()) {
            throw new ExportException("The gradient file could not be read!");
        }
        for (String cName : templateParser.getClassSequence().keySet()) {
            Vector<DoubleBondPositionVO> allLabeledVOsToAdd = new Vector<DoubleBondPositionVO>();
            Double clusteringThreshold = exportPanel.getExportOptions().getSelectedClustering();
            MolecularSpeciesContainer container = new MolecularSpeciesContainer();
            this.fillContainerForClass(cName, container, adjuster);
            for (String molecularSpecies : container.getSingleLabeledMolecularSpecies()) {
                Vector singleLabeledVOs = container.getSingleLabeledSpecies(molecularSpecies);
                Vector multiLabeledVOs = container.getMultiLabeledSpecies(molecularSpecies);
                if (multiLabeledVOs != null) {
                    Vector<DoubleBondPositionVO> clusteredMultiLabeledVOs = this.clusterMolecularSpecies(multiLabeledVOs, true, clusteringThreshold);
                    for (DoubleBondPositionVO voMulti : clusteredMultiLabeledVOs) {
                        double multiRT = voMulti.getExpectedRetentionTime();
                        RangeDouble range = new RangeDouble(multiRT - clusteringThreshold / 60.0, multiRT + clusteringThreshold / 60.0);
                        for (DoubleBondPositionVO voSingle : singleLabeledVOs) {
                            double singleRT = voSingle.getExpectedRetentionTime();
                            if (!range.insideRange(singleRT) || !this.computeCombinedPattern(voMulti, voSingle).equals(voMulti.getPositionAssignmentPattern())) continue;
                            voSingle.setChainCombination(voMulti.getChainCombination());
                        }
                    }
                }
                Vector<DoubleBondPositionVO> clusteredSingleLabeledVOs = this.clusterMolecularSpecies(singleLabeledVOs, true, clusteringThreshold);
                allLabeledVOsToAdd.addAll(clusteredSingleLabeledVOs);
            }
            XSSFSheet sheet = workbook.createSheet(cName);
            this.writeMassListForSheet(sheet, ExcelUtils.getMassListHeaderStyle(workbook), ExcelUtils.getMassListNumberStyle(workbook), templateParser, cName, allLabeledVOsToAdd);
        }
    }

    private void writeMassListForSheet(org.apache.poi.ss.usermodel.Sheet sheet, XSSFCellStyle headerStyle, XSSFCellStyle numberStyle, MassListParser templateParser, String cName, Vector<DoubleBondPositionVO> allLabeledVOsToAdd) {
        try {
            Vector<Object> elModCharge = this.getAvailableElementsAndModificationsPlusCharge(templateParser.getQuantObjects().get(cName));
            Vector elements = (Vector)elModCharge.get(0);
            LinkedHashMap mods = (LinkedHashMap)elModCharge.get(1);
            Hashtable modToCharge = (Hashtable)elModCharge.get(2);
            Integer ohNumber = 0;
            if (templateParser.isFirstRowRelevant(cName)) {
                org.apache.poi.ss.usermodel.Cell cell;
                int rowCount = 0;
                Row outRow = sheet.createRow(rowCount);
                if (templateParser.getAdductInsensitiveRtFilter().get(cName) != null && templateParser.getAdductInsensitiveRtFilter().get(cName).booleanValue()) {
                    cell = outRow.createCell(3, 1);
                    cell.setCellValue("adductInsensitiveRtFilter");
                }
                if (templateParser.getBestMatchBySpectrumCoverage().get(cName) != null && templateParser.getBestMatchBySpectrumCoverage().get(cName).booleanValue()) {
                    cell = outRow.createCell(4, 1);
                    cell.setCellValue("pickBestMatchBySpectrumCoverage");
                }
                if (templateParser.getFixedStartTime().get(cName) != null) {
                    cell = outRow.createCell(5, 1);
                    cell.setCellValue("Start-RT:" + Precision.round(templateParser.getFixedStartTime().get(cName).floatValue(), 2));
                }
                if (templateParser.getFixedStopTime().get(cName) != null) {
                    cell = outRow.createCell(6, 1);
                    cell.setCellValue("Stop-RT:" + Precision.round(templateParser.getFixedStopTime().get(cName).floatValue(), 2));
                }
                if (templateParser.getOHNumber().get(cName) != null) {
                    ohNumber = templateParser.getOHNumber().get(cName);
                    cell = outRow.createCell(7, 1);
                    cell.setCellValue("OH-Number:" + ohNumber);
                }
                if (templateParser.getOHRange().get(cName) != null) {
                    RangeInteger ohRange = templateParser.getOHRange().get(cName);
                    org.apache.poi.ss.usermodel.Cell cell2 = outRow.createCell(8, 1);
                    cell2.setCellValue("OH-Range:" + ohRange.getStart() + "-" + ohRange.getStop());
                }
            }
            List<String> headerTitles = TargetListExporter.createHeaderTitles(elements, mods, modToCharge);
            TargetListExporter.createHeader(sheet, headerTitles, headerStyle);
            int firstModColumn = headerTitles.indexOf(headerTitles.stream().filter(s -> s.startsWith("mass(form[")).findFirst().get());
            int rowCount = 2;
            for (String analyte : templateParser.getAnalyteSequence().get(cName)) {
                Hashtable<String, QuantVO> quantAnalytes = templateParser.getQuantObjects().get(cName).get(analyte);
                Hashtable<Object, Object> formula = new Hashtable();
                Vector<Object> doubleBondPositionVOs = new Vector();
                for (String mod : mods.keySet()) {
                    QuantVO quant = quantAnalytes.get(mod);
                    if (!this.isRTMapping() && quant.getDbs() > 0) {
                        for (DoubleBondPositionVO doubleBondPositionVO : allLabeledVOsToAdd) {
                            if (quant.getCarbons() != doubleBondPositionVO.getNumberOfCarbons() || quant.getDbs() != doubleBondPositionVO.getNumberOfDoubleBonds()) continue;
                            quant.addInfoForOmegaAssignment(doubleBondPositionVO);
                        }
                    }
                    doubleBondPositionVOs = quant.getInfoForOmegaAssignment();
                }
                if (this.isRTMapping()) {
                    RecalibrationRegression regression = this.calibrationGraphPanel_.getRegressionByFields("Combined", this.calibrateSeparately_ ? this.calibrationGraphPanel_.getRelevantRegressionName(cName) : "Combined");
                    boolean noRegressionAvailable = regression == null;
                    for (int i = 0; i < doubleBondPositionVOs.size(); ++i) {
                        DoubleBondPositionVO vo = (DoubleBondPositionVO)doubleBondPositionVOs.get(i);
                        if (noRegressionAvailable) {
                            vo.setExpectedRetentionTime(-1.0);
                            continue;
                        }
                        try {
                            this.computeExpectedRetentionTime(vo, regression, cName);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (!doubleBondPositionVOs.isEmpty()) {
                    Collections.sort(doubleBondPositionVOs);
                }
                for (int i = -1; i < doubleBondPositionVOs.size(); ++i) {
                    int modCount = 0;
                    Row row = sheet.createRow(rowCount);
                    boolean increaseRowCount = true;
                    for (String mod : mods.keySet()) {
                        org.apache.poi.ss.usermodel.Cell cell;
                        QuantVO quant = quantAnalytes.get(mod);
                        if (ohNumber > 0 && quant.getOhNumber() != ohNumber.intValue()) {
                            increaseRowCount = false;
                            continue;
                        }
                        if (modCount == 0) {
                            cell = row.createCell(headerTitles.indexOf("Name"), 1);
                            cell.setCellValue(quant.getCarbons());
                            cell = row.createCell(headerTitles.indexOf(""), 1);
                            cell.setCellValue(":");
                            cell = row.createCell(headerTitles.indexOf("dbs"), 0);
                            cell.setCellValue(quant.getDbs());
                            if (i >= 0) {
                                cell = row.createCell(headerTitles.indexOf(HEADER_MOLECULAR_SPECIES_WITH_DOUBLE_BOND_POSITIONS), 0);
                                cell.setCellValue(((DoubleBondPositionVO)doubleBondPositionVOs.get(i)).getDoubleBondPositionsHumanReadable(1));
                            }
                            formula = StaticUtils.categorizeFormula(quant.getAnalyteFormula());
                            for (String string : formula.keySet()) {
                                cell = row.createCell(headerTitles.indexOf(string), 0);
                                cell.setCellValue(((Integer)formula.get(string)).intValue());
                            }
                        }
                        cell = row.createCell(firstModColumn + modCount, 0);
                        cell.setCellValue(quant.getAnalyteMass());
                        ++modCount;
                        if (i < 0) continue;
                        cell = row.createCell(headerTitles.indexOf("tR (min)"), 0);
                        cell.setCellValue(((DoubleBondPositionVO)doubleBondPositionVOs.get(i)).getExpectedRetentionTime());
                        cell.setCellStyle(numberStyle);
                    }
                    if (!increaseRowCount) continue;
                    ++rowCount;
                }
            }
        }
        catch (ChemicalFormulaException ex) {
            ex.printStackTrace();
        }
    }

    private void computeExpectedRetentionTime(DoubleBondPositionVO vo, RecalibrationRegression regression, String cName) {
        double before = vo.getExpectedRetentionTime();
        try {
            double after = regression.getTargetRT(before);
            vo.setExpectedRetentionTime((float)after);
        }
        catch (OutOfRangeException ex) {
            double extrapolatedRT = this.extrapolateRTOutOfRange(before, regression);
            vo.setExpectedRetentionTime((float)extrapolatedRT);
        }
    }

    private double extrapolateRTOutOfRange(double before, RecalibrationRegression regression) {
        Double returnValue = -1.0;
        ArrayList<Pair<Double, Double>> clustered = regression.getClustered();
        Pair<Double, Double> firstPair = null;
        Pair<Double, Double> secondPair = null;
        if (before < clustered.get(0).getKey()) {
            firstPair = clustered.get(0);
            secondPair = clustered.get(1);
        } else if (before > clustered.get(clustered.size() - 1).getKey()) {
            firstPair = clustered.get(clustered.size() - 1);
            secondPair = clustered.get(clustered.size() - 2);
        }
        if (firstPair != null && secondPair != null) {
            double m = (secondPair.getValue() - firstPair.getValue()) / (secondPair.getKey() - firstPair.getKey());
            double b = firstPair.getValue() - m * firstPair.getKey();
            returnValue = before - (m * before + b);
        }
        System.out.println(returnValue);
        return returnValue;
    }

    private Vector<DoubleBondPositionVO> clusterMolecularSpecies(Vector<DoubleBondPositionVO> doubleBondPositionVOs, boolean labeled, double clusteringThreshold) {
        if (labeled && !doubleBondPositionVOs.isEmpty()) {
            Vector<DoubleBondPositionVO> returnElements = new Vector<DoubleBondPositionVO>();
            Vector<Boolean> permutationPattern = doubleBondPositionVOs.get(0).getPermutationPattern();
            Hashtable<Vector<Integer>, Vector<DoubleBondPositionVO>> patternLookup = this.computePatternLookup(doubleBondPositionVOs);
            for (Vector<Integer> pattern : patternLookup.keySet()) {
                Vector<DoubleBondPositionVO> averageElements = this.computeGroups(patternLookup.get(pattern), clusteringThreshold);
                patternLookup.put(pattern, averageElements);
            }
            Hashtable<Vector<Integer>, Vector<Vector<Integer>>> overlappingPatterns = this.computeOverlappingPatterns(patternLookup.keySet(), permutationPattern);
            Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>> markedToCombine = this.markToCombine(patternLookup, overlappingPatterns, clusteringThreshold);
            Vector combineRanges = new Vector();
            for (DoubleBondPositionVO doubleBondPositionVO : markedToCombine.keySet()) {
                boolean isRepresented = false;
                for (Pair pair : combineRanges) {
                    if (!((RangeDouble)pair.getKey()).insideRange(doubleBondPositionVO.getExpectedRetentionTime())) continue;
                    RangeDouble range2 = new RangeDouble(doubleBondPositionVO.getExpectedRetentionTime() - clusteringThreshold / 60.0, doubleBondPositionVO.getExpectedRetentionTime() + clusteringThreshold / 60.0);
                    ((RangeDouble)pair.getKey()).extendToOtherRanges(range2);
                    ((Vector)pair.getValue()).add(doubleBondPositionVO);
                    isRepresented = true;
                }
                if (isRepresented) continue;
                RangeDouble range2 = new RangeDouble(doubleBondPositionVO.getExpectedRetentionTime() - clusteringThreshold / 60.0, doubleBondPositionVO.getExpectedRetentionTime() + clusteringThreshold / 60.0);
                Vector<DoubleBondPositionVO> vector = new Vector<DoubleBondPositionVO>();
                vector.add(doubleBondPositionVO);
                Pair newRange = new Pair(range2, vector);
                combineRanges.add(newRange);
            }
            for (Pair pair : combineRanges) {
                boolean combineSpecies = true;
                Vector<Vector<Integer>> added = new Vector<Vector<Integer>>();
                Vector<DoubleBondPositionVO> vector = new Vector<DoubleBondPositionVO>();
                Vector<DoubleBondPositionVO> toBeAddedToLookup = new Vector<DoubleBondPositionVO>();
                for (DoubleBondPositionVO doubleBondPositionVO : (Vector)pair.getValue()) {
                    Vector<DoubleBondPositionVO> vos = new Vector<DoubleBondPositionVO>();
                    vos.addAll((Collection)markedToCombine.get(doubleBondPositionVO));
                    Set<Vector<Integer>> combinedPatterns = this.computeCombinedPatterns(doubleBondPositionVO, vos);
                    if (combinedPatterns.size() != 1) {
                        combineSpecies = false;
                        continue;
                    }
                    Vector<Integer> pattern = combinedPatterns.iterator().next();
                    Vector<FattyAcidVO> original = doubleBondPositionVO.getChainCombination();
                    Vector<FattyAcidVO> combinedFattyAcidVO = new Vector<FattyAcidVO>();
                    for (int i = 0; i < pattern.size(); ++i) {
                        FattyAcidVO fattyAcid = new FattyAcidVO(original.get(i));
                        fattyAcid.setOmegaPosition(pattern.get(i));
                        combinedFattyAcidVO.add(fattyAcid);
                    }
                    double expectedRetentionTime = doubleBondPositionVO.getExpectedRetentionTime();
                    int count = 1;
                    for (DoubleBondPositionVO vo : vos) {
                        vector.add(vo);
                        expectedRetentionTime += vo.getExpectedRetentionTime();
                        ++count;
                    }
                    DoubleBondPositionVO combined = new DoubleBondPositionVO(combinedFattyAcidVO, expectedRetentionTime / (double)count, 0, doubleBondPositionVO.getMolecularSpecies());
                    toBeAddedToLookup.add(combined);
                    vector.add(doubleBondPositionVO);
                }
                if (!combineSpecies) continue;
                for (DoubleBondPositionVO toBeAdded : toBeAddedToLookup) {
                    if (added.contains(toBeAdded.getPositionAssignmentPattern())) continue;
                    if (!patternLookup.containsKey(toBeAdded.getPositionAssignmentPattern())) {
                        patternLookup.put(toBeAdded.getPositionAssignmentPattern(), new Vector());
                    }
                    patternLookup.get(toBeAdded.getPositionAssignmentPattern()).add(toBeAdded);
                    added.add(toBeAdded.getPositionAssignmentPattern());
                }
                for (DoubleBondPositionVO toBeRemoved : vector) {
                    patternLookup.get(toBeRemoved.getPositionAssignmentPattern()).remove(toBeRemoved);
                }
            }
            for (Vector vector : patternLookup.keySet()) {
                returnElements.addAll((Collection<DoubleBondPositionVO>)patternLookup.get(vector));
            }
            return returnElements;
        }
        return this.computeGroups(doubleBondPositionVOs, clusteringThreshold);
    }

    private Set<Vector<Integer>> computeCombinedPatterns(DoubleBondPositionVO vo1, Vector<DoubleBondPositionVO> doubleBondPositionVOs) {
        HashSet<Vector<Integer>> combinedPatterns = new HashSet<Vector<Integer>>();
        for (DoubleBondPositionVO vo2 : doubleBondPositionVOs) {
            Vector<Integer> combinedPattern = this.computeCombinedPattern(vo1, vo2);
            combinedPatterns.add(combinedPattern);
        }
        return combinedPatterns;
    }

    private Vector<Integer> computeCombinedPattern(DoubleBondPositionVO vo1, DoubleBondPositionVO vo2) {
        Vector<Integer> combinedPattern = new Vector<Integer>();
        Vector<Integer> pattern1 = vo1.getPositionAssignmentPattern();
        Vector<Integer> pattern2 = vo2.getPositionAssignmentPattern();
        if (vo2.getPermutationPattern().contains(Boolean.TRUE) && pattern2.size() == 2) {
            int temp = pattern2.get(0);
            pattern2.setElementAt(pattern2.get(1), 0);
            pattern2.setElementAt(temp, 1);
        }
        for (int i = 0; i < pattern1.size(); ++i) {
            if (pattern1.get(i) == pattern2.get(i)) {
                combinedPattern.add(pattern1.get(i));
                continue;
            }
            if (pattern1.get(i) > 0 && pattern2.get(i) == -1) {
                combinedPattern.add(pattern1.get(i));
                continue;
            }
            if (pattern1.get(i) == -1 && pattern2.get(i) > 0) {
                combinedPattern.add(pattern2.get(i));
                continue;
            }
            combinedPattern.add(-1);
        }
        return combinedPattern;
    }

    private Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>> markToCombine(Hashtable<Vector<Integer>, Vector<DoubleBondPositionVO>> patternLookup, Hashtable<Vector<Integer>, Vector<Vector<Integer>>> overlappingPatterns, Double clusteringThreshold) {
        Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>> markedToCombine = new Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>>();
        for (Vector<Integer> pattern : overlappingPatterns.keySet()) {
            Vector<DoubleBondPositionVO> patternVOs = patternLookup.get(pattern);
            for (Vector<Integer> overlappingPattern : overlappingPatterns.get(pattern)) {
                Vector<DoubleBondPositionVO> overlappingPatternVOs = patternLookup.get(overlappingPattern);
                for (DoubleBondPositionVO vo1 : patternVOs) {
                    Float retentionTime1 = Float.valueOf((float)vo1.getExpectedRetentionTime());
                    for (DoubleBondPositionVO vo2 : overlappingPatternVOs) {
                        Float retentionTime2 = Float.valueOf((float)vo2.getExpectedRetentionTime());
                        if (!((double)Math.abs(retentionTime1.floatValue() - retentionTime2.floatValue()) < clusteringThreshold / 60.0)) continue;
                        if (!markedToCombine.containsKey(vo1)) {
                            markedToCombine.put(vo1, new Vector());
                        }
                        if (!markedToCombine.get(vo1).contains(vo2)) {
                            markedToCombine.get(vo1).add(vo2);
                        }
                        if (!markedToCombine.containsKey(vo2)) {
                            markedToCombine.put(vo2, new Vector());
                        }
                        if (markedToCombine.get(vo2).contains(vo1)) continue;
                        markedToCombine.get(vo2).add(vo1);
                    }
                }
            }
        }
        return this.removeDuplicates(markedToCombine);
    }

    private Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>> removeDuplicates(Hashtable<DoubleBondPositionVO, Vector<DoubleBondPositionVO>> markedToCombine) {
        Set<DoubleBondPositionVO> keySet = markedToCombine.keySet();
        ArrayList<DoubleBondPositionVO> toRemoveList = new ArrayList<DoubleBondPositionVO>();
        for (DoubleBondPositionVO key : keySet) {
            if (toRemoveList.contains(key)) continue;
            Vector<DoubleBondPositionVO> collection1 = new Vector<DoubleBondPositionVO>();
            collection1.addAll((Collection)markedToCombine.get(key));
            collection1.add(key);
            Vector<DoubleBondPositionVO> keyVector = markedToCombine.get(key);
            for (int i = 0; i < keyVector.size(); ++i) {
                if (keyVector.get(i).equals(key) || toRemoveList.contains(keyVector.get(i)) || !markedToCombine.containsKey(keyVector.get(i))) continue;
                Vector<DoubleBondPositionVO> collection2 = new Vector<DoubleBondPositionVO>();
                collection2.addAll((Collection)markedToCombine.get(keyVector.get(i)));
                collection2.add(keyVector.get(i));
                if (collection2.containsAll(collection1)) {
                    toRemoveList.add(key);
                    continue;
                }
                if (!collection1.containsAll(collection2)) continue;
                toRemoveList.add(keyVector.get(i));
            }
        }
        for (DoubleBondPositionVO toRemove : toRemoveList) {
            markedToCombine.remove(toRemove);
        }
        return markedToCombine;
    }

    private Hashtable<Vector<Integer>, Vector<Vector<Integer>>> computeOverlappingPatterns(Set<Vector<Integer>> patterns, Vector<Boolean> permutationPattern) {
        Hashtable<Vector<Integer>, Vector<Vector<Integer>>> overlappingPatterns = new Hashtable<Vector<Integer>, Vector<Vector<Integer>>>();
        for (Vector<Integer> pattern1 : patterns) {
            overlappingPatterns.put(pattern1, new Vector());
            for (Vector<Integer> pattern2 : patterns) {
                boolean isOverlapping = true;
                boolean isIdentical = pattern1.equals(pattern2);
                if (isIdentical) continue;
                Vector<Vector<Integer>> patternPermutations = this.computePatternPermutations(pattern2, permutationPattern);
                for (Vector<Integer> pattern3 : patternPermutations) {
                    isOverlapping = true;
                    for (int i = 0; i < pattern1.size(); ++i) {
                        if (pattern1.get(i).equals(pattern3.get(i)) || pattern1.get(i) == -1 || pattern3.get(i) == -1) continue;
                        isOverlapping = false;
                    }
                }
                if (!isOverlapping) continue;
                overlappingPatterns.get(pattern1).add(pattern2);
            }
        }
        return overlappingPatterns;
    }

    private Vector<Vector<Integer>> computePatternPermutations(Vector<Integer> pattern, Vector<Boolean> permutationPattern) {
        Vector<Vector<Integer>> patternPermutations = new Vector<Vector<Integer>>();
        int size = pattern.size();
        patternPermutations.add(new Vector<Integer>(pattern));
        if (!permutationPattern.contains(Boolean.TRUE)) {
            return patternPermutations;
        }
        for (int i = 0; i < size; ++i) {
            int temp;
            Vector<Integer> tempPattern;
            if (permutationPattern.get(i) != Boolean.TRUE) continue;
            if (i < size - 1 && permutationPattern.get(i + 1) == Boolean.TRUE) {
                tempPattern = new Vector<Integer>(pattern);
                temp = tempPattern.get(i);
                tempPattern.setElementAt(tempPattern.get(i + 1), i);
                tempPattern.setElementAt(temp, i + 1);
                patternPermutations.add(tempPattern);
                continue;
            }
            if (size <= 2 || i != size - 1 || permutationPattern.firstElement() != Boolean.TRUE) continue;
            tempPattern = new Vector<Integer>(pattern);
            temp = tempPattern.get(i);
            tempPattern.setElementAt(tempPattern.firstElement(), i);
            tempPattern.setElementAt(temp, 0);
            patternPermutations.add(tempPattern);
        }
        return patternPermutations;
    }

    public DoubleBondPositionVO combineDoubleBondPositionVO(DoubleBondPositionVO vo1, DoubleBondPositionVO vo2) {
        if (vo1.getMolecularSpecies().equals(vo2.getMolecularSpecies())) {
            int i;
            double combinedRetentionTime = (vo1.getExpectedRetentionTime() + vo2.getExpectedRetentionTime()) / 2.0;
            Vector<Integer> pattern1 = vo1.getPositionAssignmentPattern();
            Vector<Integer> pattern2 = vo2.getPositionAssignmentPattern();
            if (vo2.getPermutationPattern().contains(Boolean.TRUE) && pattern2.size() == 2) {
                int temp = pattern2.get(0);
                pattern2.setElementAt(pattern2.get(1), 0);
                pattern2.setElementAt(temp, 1);
            }
            Vector<Integer> combinedPattern = new Vector<Integer>();
            Vector<FattyAcidVO> combinedFattyAcidVO = new Vector<FattyAcidVO>(vo1.getChainCombination());
            for (i = 0; i < pattern1.size(); ++i) {
                if (pattern1.get(i) == pattern2.get(i)) {
                    combinedPattern.add(pattern1.get(i));
                    continue;
                }
                if (pattern1.get(i) > 0 && pattern2.get(i) == -1) {
                    combinedPattern.add(pattern1.get(i));
                    continue;
                }
                if (pattern1.get(i) == -1 && pattern2.get(i) > 0) {
                    combinedPattern.add(pattern2.get(i));
                    continue;
                }
                combinedPattern.add(-1);
            }
            for (i = 0; i < combinedPattern.size(); ++i) {
                combinedFattyAcidVO.get(i).setOmegaPosition((Integer)combinedPattern.get(i));
            }
            return new DoubleBondPositionVO(combinedFattyAcidVO, combinedRetentionTime, 0, vo1.getMolecularSpecies());
        }
        return null;
    }

    private Hashtable<Vector<Integer>, Vector<DoubleBondPositionVO>> computePatternLookup(Vector<DoubleBondPositionVO> doubleBondPositionVOs) {
        Hashtable<Vector<Integer>, Vector<DoubleBondPositionVO>> patternLookup = new Hashtable<Vector<Integer>, Vector<DoubleBondPositionVO>>();
        for (DoubleBondPositionVO doubleBondPositionVO : doubleBondPositionVOs) {
            Vector<Integer> pattern = doubleBondPositionVO.getPositionAssignmentPattern();
            if (!patternLookup.containsKey(pattern)) {
                patternLookup.put(pattern, new Vector());
            }
            patternLookup.get(pattern).add(doubleBondPositionVO);
        }
        return patternLookup;
    }

    private Vector<DoubleBondPositionVO> computeGroups(Vector<DoubleBondPositionVO> doubleBondPositionVOs, double clusteringThreshold) {
        Vector<DoubleBondPositionVO> averageElements = new Vector<DoubleBondPositionVO>();
        Hashtable<Integer, Integer> clusterLookup = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Cluster> clusters = new Hashtable<Integer, Cluster>();
        int numClusters = 0;
        for (int i = 0; i < doubleBondPositionVOs.size(); ++i) {
            DoubleBondPositionVO vo1 = doubleBondPositionVOs.get(i);
            Float retentionTime1 = Float.valueOf((float)vo1.getExpectedRetentionTime());
            if (!clusterLookup.containsKey(i)) {
                Cluster cluster = new Cluster();
                cluster.addDoubleBondPositionVO(vo1);
                clusters.put(numClusters, cluster);
                clusterLookup.put(i, numClusters);
                ++numClusters;
            }
            for (int j = 0; j < doubleBondPositionVOs.size(); ++j) {
                int numCluster2;
                DoubleBondPositionVO vo2 = doubleBondPositionVOs.get(j);
                if (!((double)Math.abs(retentionTime1.floatValue() - (float)vo2.getExpectedRetentionTime()) < clusteringThreshold / 60.0)) continue;
                if (!clusterLookup.containsKey(j)) {
                    int numCluster = (Integer)clusterLookup.get(i);
                    ((Cluster)clusters.get(numCluster)).addDoubleBondPositionVO(vo2);
                    clusterLookup.put(j, numCluster);
                    continue;
                }
                int numCluster1 = (Integer)clusterLookup.get(i);
                if (numCluster1 == (numCluster2 = ((Integer)clusterLookup.get(j)).intValue())) continue;
                Cluster cluster = new Cluster((Cluster)clusters.get(numCluster1), (Cluster)clusters.get(numCluster2));
                clusters.put(numCluster1, cluster);
                clusterLookup.forEach((k, v) -> {
                    if (v == numCluster2) {
                        clusterLookup.replace((Integer)k, numCluster1);
                    }
                });
                clusters.remove(numCluster2);
            }
        }
        clusters.forEach((k, v) -> averageElements.add(((Cluster)v).getAverageElement()));
        return averageElements;
    }

    private void fillContainerForClass(String cName, MolecularSpeciesContainer container, GradientAdjuster adjuster) {
        try {
            for (ResultFileVO resultFileVO : this.resultFileVO_) {
                QuantificationResult quantRes = resultFileVO.getQuantificationResult();
                Vector<LipidParameterSet> analytes = quantRes.getIdentifications().get(cName);
                if (analytes == null) {
                    return;
                }
                for (LipidParameterSet analyte : analytes) {
                    LipidomicsMSnSet analyteMSn;
                    if (!(analyte instanceof LipidomicsMSnSet) || analyte.getDoubleBonds() <= 0 || (analyteMSn = (LipidomicsMSnSet)analyte).getStatus() < 3) continue;
                    Vector<Pair<String, String>> labeledUnlabeledPairs = analyteMSn.getLabeledUnlabeledPairs();
                    double expectedRetentionTime = analyte.getPreciseRT();
                    boolean viableForCalibration = true;
                    boolean singleLabel = true;
                    if (this.isotopeEffectRegression_ != null && analyte.getChemicalFormula().contains("D")) {
                        int numberDeuterium = StaticUtils.categorizeFormula(analyte.getChemicalFormula()).get("D");
                        if (numberDeuterium > this.isotopeEffectRegression_.getMaxNumDeuteriumAllowed()) {
                            singleLabel = false;
                            String validCombi = analyteMSn.getValidChainCombinations().get(0);
                            for (FattyAcidVO fa : StaticUtils.decodeLipidNamesFromChainCombi(validCombi)) {
                                String prefix = fa.getPrefix();
                                if (prefix == null || prefix.equals("")) continue;
                                for (IsotopeLabelVO label : this.labels_) {
                                    int num;
                                    if (!label.getLabelId().equals(prefix)) continue;
                                    int n = num = label.getLabelElements().containsKey("D") ? label.getLabelElements().get("D") : 0;
                                    if (num > this.isotopeEffectRegression_.getMaxNumDeuteriumAllowed()) {
                                        viableForCalibration = false;
                                        continue;
                                    }
                                    expectedRetentionTime = adjuster != null ? adjuster.getGradientAdjustedValue(this.isotopeEffectRegression_.getIsotopeEffect(num), expectedRetentionTime) : this.isotopeEffectRegression_.getIsotopeEffect(num) * expectedRetentionTime;
                                }
                            }
                        } else {
                            double d = expectedRetentionTime = adjuster != null ? adjuster.getGradientAdjustedValue(this.isotopeEffectRegression_.getIsotopeEffect(numberDeuterium), analyte.getPreciseRT()) : this.isotopeEffectRegression_.getIsotopeEffect(numberDeuterium) * analyte.getPreciseRT();
                        }
                    }
                    if (!viableForCalibration) continue;
                    for (Pair<String, String> pair : labeledUnlabeledPairs) {
                        String labeledSpecies = pair.getValue();
                        Vector<FattyAcidVO> chains = new Vector<FattyAcidVO>();
                        String[] splitName = StaticUtils.splitChainCombinationsAtChainSeparators(labeledSpecies);
                        for (int i = 0; i < splitName.length; ++i) {
                            FattyAcidVO fa = StaticUtils.decodeHumanReadableChain(splitName[i], Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
                            String prefix = fa.getPrefix();
                            if (!prefix.equals("")) {
                                for (IsotopeLabelVO label : this.labels_) {
                                    if (!label.getLabelId().equals(prefix)) continue;
                                    fa.setOmegaPosition(label.getOmegaPosition());
                                    fa.setPrefix("");
                                }
                            }
                            chains.add(fa);
                        }
                        if (!analyte.getChemicalFormula().contains("D") && !analyte.getChemicalFormula().contains("Cc")) continue;
                        if (singleLabel) {
                            container.addSingleLabeledSpecies(pair.getKey(), new DoubleBondPositionVO(chains, expectedRetentionTime, 0, pair.getKey()));
                            continue;
                        }
                        container.addMultiLabeledSpecies(pair.getKey(), new DoubleBondPositionVO(chains, expectedRetentionTime, 0, pair.getKey()));
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void createHeader(org.apache.poi.ss.usermodel.Sheet sheet, List<String> headerTitles, XSSFCellStyle headerStyle) {
        Row row = sheet.createRow(1);
        for (int i = 0; i < headerTitles.size(); ++i) {
            org.apache.poi.ss.usermodel.Cell cell = row.createCell(i, 1);
            cell.setCellValue(headerTitles.get(i));
            cell.setCellStyle(headerStyle);
        }
        sheet.setColumnWidth(headerTitles.indexOf("Name"), 2560);
        sheet.setColumnWidth(headerTitles.indexOf(""), 512);
        sheet.setColumnWidth(headerTitles.indexOf("dbs"), 2560);
        sheet.setColumnWidth(headerTitles.indexOf(HEADER_MOLECULAR_SPECIES_WITH_DOUBLE_BOND_POSITIONS), 7680);
        sheet.setColumnWidth(headerTitles.indexOf("tR (min)"), 2560);
    }

    public static List<String> createHeaderTitles(Vector<String> elements, LinkedHashMap<String, String> mods, Hashtable<String, Integer> modToCharge) {
        ArrayList<String> headerTitles = new ArrayList<String>();
        headerTitles.add("Name");
        headerTitles.add("");
        headerTitles.add("dbs");
        headerTitles.add(HEADER_MOLECULAR_SPECIES_WITH_DOUBLE_BOND_POSITIONS);
        for (String element : elements) {
            headerTitles.add(element);
        }
        for (String mod : mods.keySet()) {
            String modHeader = "mass(form[" + mods.get(mod) + "] name[" + mod + "]";
            if (modToCharge.get(mod) > 1) {
                modHeader = modHeader + " charge=" + modToCharge.get(mod);
            }
            modHeader = modHeader + ")";
            headerTitles.add(modHeader);
        }
        headerTitles.add("tR (min)");
        return headerTitles;
    }

    public Vector<Object> getAvailableElementsAndModificationsPlusCharge(Hashtable<String, Hashtable<String, QuantVO>> quantObjects) throws ChemicalFormulaException {
        Vector<Object> result = new Vector<Object>();
        HashSet<String> elements = new HashSet<String>();
        LinkedHashMap<String, String> modifications = new LinkedHashMap<String, String>();
        Hashtable<String, Integer> modToCharge = new Hashtable<String, Integer>();
        for (Hashtable<String, QuantVO> quantAnal : quantObjects.values()) {
            for (QuantVO quant : quantAnal.values()) {
                for (String element : StaticUtils.categorizeFormula(quant.getAnalyteFormula()).keySet()) {
                    if (!elements.contains(element)) {
                        elements.add(element);
                    }
                    if (modifications.containsKey(quant.getModName())) continue;
                    modifications.put(quant.getModName(), StaticUtils.getFormulaInHillNotation(StaticUtils.categorizeFormula(quant.getModFormula()), false));
                    modToCharge.put(quant.getModName(), quant.getCharge());
                }
            }
        }
        Vector<String> sorted = new Vector<String>();
        if (elements.contains("C")) {
            sorted.add("C");
        }
        if (elements.contains("H")) {
            sorted.add("H");
        }
        ArrayList<String> otherThanCH = new ArrayList<String>();
        for (String element : elements) {
            if (element.equalsIgnoreCase("C") || element.equalsIgnoreCase("H")) continue;
            otherThanCH.add(element);
        }
        Collections.sort(otherThanCH);
        for (String element : otherThanCH) {
            sorted.add(element);
        }
        result.add(sorted);
        result.add(modifications);
        result.add(modToCharge);
        return result;
    }

    private String getTemplatePath() {
        return this.templatePath_;
    }

    private boolean isRTMapping() {
        return this.calibrationGraphPanel_ != null;
    }

    private Hashtable<String, Set<Pair<Double, DoubleBondPositionVO>>> getBeforeAfter() {
        return this.beforeAfter_;
    }

    private Hashtable<String, Vector<Pair<Double, DoubleBondPositionVO>>> parseComparisonSheet(Sheet sheet) throws Exception {
        Integer rowNr;
        Hashtable<String, Vector<Pair<Double, DoubleBondPositionVO>>> allowedPairsOfClass = new Hashtable<String, Vector<Pair<Double, DoubleBondPositionVO>>>();
        List<org.dhatim.fastexcel.reader.Row> rows = null;
        rows = sheet.read();
        Integer n = rowNr = Integer.valueOf(0);
        Integer n2 = rowNr = Integer.valueOf(rowNr + 1);
        org.dhatim.fastexcel.reader.Row headerRow = rows.get(n);
        List headerTitles = null;
        try (Stream<Cell> cells = headerRow.stream();){
            headerTitles = cells.map(c -> c != null && !c.getType().equals((Object)CellType.ERROR) ? c.getText() : "null").collect(Collectors.toList());
        }
        if (headerTitles == null) {
            throw new IOException("No headertitles...");
        }
        List<org.dhatim.fastexcel.reader.Row> contentRows = rows.subList(rowNr, rows.size());
        String lClass = null;
        String molecularSpecies = null;
        float targetRT = 0.0f;
        float originalRT = 0.0f;
        for (org.dhatim.fastexcel.reader.Row row : contentRows) {
            List cells = row.stream().filter(c -> c != null && !c.getType().equals((Object)CellType.ERROR)).collect(Collectors.toList());
            for (Cell cell : cells) {
                int index = cell.getColumnIndex();
                String rawValue = cell.getRawValue();
                if (index == headerTitles.indexOf("Lipid Class")) {
                    lClass = rawValue;
                    continue;
                }
                if (index == headerTitles.indexOf("Lipid Molecular Species")) {
                    molecularSpecies = rawValue;
                    continue;
                }
                if (index == headerTitles.indexOf("RT Target DB /min")) {
                    targetRT = Float.parseFloat(rawValue);
                    continue;
                }
                if (index != headerTitles.indexOf("RT Original DB /min")) continue;
                originalRT = Float.parseFloat(rawValue);
            }
            Vector<FattyAcidVO> chainCombination = StaticUtils.decodeFAsFromHumanReadableName(molecularSpecies, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
            DoubleBondPositionVO vo = new DoubleBondPositionVO(chainCombination, targetRT, 0, molecularSpecies);
            if (!allowedPairsOfClass.containsKey(lClass)) {
                allowedPairsOfClass.put(lClass, new Vector());
            }
            allowedPairsOfClass.get(lClass).add(new Pair<Double, DoubleBondPositionVO>(new Double(originalRT), vo));
        }
        return allowedPairsOfClass;
    }

    /*
     * WARNING - void declaration
     */
    public void exportBeforeAfter(String targetPath, String outPath, String comparisonPath) throws ExportException {
        Throwable throwable;
        Throwable throwable2;
        this.comparisonPairsOfClass_ = new Hashtable();
        String sheetName = "RTDB_A_to_B1";
        if (comparisonPath != null) {
            try {
                throwable2 = null;
                try (FileInputStream is = new FileInputStream(comparisonPath);){
                    throwable = null;
                    try (ReadableWorkbook wb = new ReadableWorkbook(is);
                         Stream<Sheet> sheets22 = wb.getSheets();){
                        sheets22.forEach(s -> {
                            if (s.getName().equalsIgnoreCase(sheetName)) {
                                try {
                                    this.comparisonPairsOfClass_ = this.parseComparisonSheet((Sheet)s);
                                }
                                catch (Exception ex) {
                                    new WarningMessage(new JFrame(), "ERROR", ex.getMessage());
                                }
                            }
                        });
                    }
                    catch (Throwable sheets22) {
                        throwable = sheets22;
                        throw sheets22;
                    }
                }
                catch (Throwable wb) {
                    throwable2 = wb;
                    throw wb;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        try {
            throwable2 = null;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outPath));){
                throwable = null;
                try (XSSFWorkbook workbook = new XSSFWorkbook();){
                    XSSFSheet sheet = workbook.createSheet("beforeAfter");
                    this.createBeforeAfterTitle(sheet);
                    int rowCount = 1;
                    Vector quantInfo = QuantificationThread.getCorrectAnalyteSequence(targetPath, false);
                    LinkedHashMap classSequence = (LinkedHashMap)quantInfo.get(0);
                    LinkedHashMap analyteSequence = (LinkedHashMap)quantInfo.get(1);
                    Hashtable quantObjects = (Hashtable)quantInfo.get(4);
                    for (String cName : classSequence.keySet()) {
                        Hashtable<void, Object> matchedRecalibratedToTarget = new Hashtable<void, Object>();
                        Hashtable<DoubleBondPositionVO, Pair<Double, void>> matchedTargetToRecalibrated = new Hashtable<DoubleBondPositionVO, Pair<Double, void>>();
                        Vector<Object> pairsOfClassPriority = new Vector();
                        if (!this.comparisonPairsOfClass_.isEmpty() && (pairsOfClassPriority = this.comparisonPairsOfClass_.get(cName)) == null) {
                            pairsOfClassPriority = new Vector();
                        }
                        Set<Pair<Double, DoubleBondPositionVO>> beforeAfter = this.getBeforeAfter().get(cName);
                        Vector<Object> pairsOfClass = new Vector();
                        if (beforeAfter != null) {
                            pairsOfClass = new Vector<Pair<Double, DoubleBondPositionVO>>(beforeAfter);
                        }
                        if (!this.comparisonPairsOfClass_.isEmpty()) {
                            pairsOfClass = pairsOfClassPriority;
                        }
                        if (pairsOfClass.isEmpty()) continue;
                        Vector<Object> elModCharge = this.getAvailableElementsAndModificationsPlusCharge((Hashtable)quantObjects.get(cName));
                        LinkedHashMap mods = (LinkedHashMap)elModCharge.get(1);
                        for (Pair pair : pairsOfClass) {
                            void var26_46;
                            boolean pairAdded = false;
                            for (Pair<Double, DoubleBondPositionVO> original : beforeAfter) {
                                if (!original.getKey().equals(var26_46.getKey()) || !original.getValue().getChainCombination().equals(((DoubleBondPositionVO)var26_46.getValue()).getChainCombination())) continue;
                                Pair<Double, DoubleBondPositionVO> pair2 = original;
                            }
                            for (String analyte : (Vector)analyteSequence.get(cName)) {
                                Hashtable quantAnalytes = (Hashtable)((Hashtable)quantObjects.get(cName)).get(analyte);
                                for (String mod : mods.keySet()) {
                                    QuantVO quant = (QuantVO)quantAnalytes.get(mod);
                                    Vector<DoubleBondPositionVO> doubleBondPositionVOs = quant.getInfoForOmegaAssignment();
                                    for (DoubleBondPositionVO vo : doubleBondPositionVOs) {
                                        if (!((DoubleBondPositionVO)var26_46.getValue()).getDoubleBondPositionsHumanReadable().equals(vo.getDoubleBondPositionsHumanReadable())) continue;
                                        double rtError = vo.getExpectedRetentionTime() - ((DoubleBondPositionVO)var26_46.getValue()).getExpectedRetentionTime();
                                        double existingRtError = Double.MAX_VALUE;
                                        if (matchedRecalibratedToTarget.containsKey(var26_46)) {
                                            existingRtError = (Double)((Pair)matchedRecalibratedToTarget.get(var26_46)).getKey();
                                        } else if (matchedTargetToRecalibrated.containsKey(vo)) {
                                            existingRtError = (Double)((Pair)matchedTargetToRecalibrated.get(vo)).getKey();
                                        } else if (Math.abs(rtError) < 1.0) {
                                            matchedRecalibratedToTarget.put(var26_46, new Pair<Double, DoubleBondPositionVO>(rtError, vo));
                                            matchedTargetToRecalibrated.put(vo, new Pair<Double, void>(rtError, var26_46));
                                            pairAdded = true;
                                        }
                                        if (!(existingRtError < Double.MAX_VALUE) || !(Math.abs(rtError) <= Math.abs(existingRtError))) continue;
                                        if (!matchedRecalibratedToTarget.containsKey(var26_46)) {
                                            Pair toRemove = null;
                                            for (Pair previous : matchedRecalibratedToTarget.keySet()) {
                                                if (!((DoubleBondPositionVO)((Pair)matchedRecalibratedToTarget.get(previous)).getValue()).equals(vo) || !this.comparisonPairsOfClass_.isEmpty()) continue;
                                                toRemove = previous;
                                            }
                                            if (toRemove != null) {
                                                matchedRecalibratedToTarget.remove(toRemove);
                                            }
                                        }
                                        matchedRecalibratedToTarget.put(var26_46, new Pair<Double, DoubleBondPositionVO>(rtError, vo));
                                        matchedTargetToRecalibrated.put(vo, new Pair<Double, void>(rtError, var26_46));
                                        pairAdded = true;
                                    }
                                }
                            }
                            if (pairAdded || this.comparisonPairsOfClass_.isEmpty()) continue;
                            matchedRecalibratedToTarget.put(var26_46, var26_46);
                        }
                        if (matchedRecalibratedToTarget.isEmpty()) continue;
                        ArrayList usedVOs = new ArrayList();
                        for (Pair originalPair : matchedRecalibratedToTarget.keySet()) {
                            Pair targetPair = (Pair)matchedRecalibratedToTarget.get(originalPair);
                            if (usedVOs.contains(targetPair.getValue()) && this.comparisonPairsOfClass_.isEmpty()) continue;
                            usedVOs.add(targetPair.getValue());
                            String molName = ((DoubleBondPositionVO)targetPair.getValue()).getDoubleBondPositionsHumanReadable();
                            double targetRT = ((DoubleBondPositionVO)targetPair.getValue()).getExpectedRetentionTime();
                            double originalRT = (Double)originalPair.getKey();
                            double recalibratedRT = ((DoubleBondPositionVO)originalPair.getValue()).getExpectedRetentionTime();
                            double rtError = (Double)targetPair.getKey() > 1.0 ? 0.0 : (Double)targetPair.getKey();
                            Row row = sheet.createRow(rowCount);
                            org.apache.poi.ss.usermodel.Cell cell = row.createCell(0, 1);
                            cell.setCellValue(cName);
                            cell = row.createCell(1, 1);
                            cell.setCellValue(molName);
                            cell = row.createCell(2, 0);
                            cell.setCellValue(targetRT);
                            cell = row.createCell(3, 0);
                            cell.setCellValue(originalRT);
                            cell = row.createCell(4, 0);
                            cell.setCellValue(recalibratedRT);
                            cell = row.createCell(5, 0);
                            cell.setCellValue(originalRT - targetRT);
                            cell = row.createCell(6, 0);
                            cell.setCellValue(rtError);
                            cell = row.createCell(7, 0);
                            cell.setCellValue(Math.abs(rtError));
                            ++rowCount;
                        }
                    }
                    workbook.write(out);
                    System.out.println("recalibration_comparison.xlsx written!");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
        }
        catch (Exception e) {
            throw new ExportException(e);
        }
    }

    private void createBeforeAfterTitle(org.apache.poi.ss.usermodel.Sheet sheet) {
        Row row = sheet.createRow(0);
        org.apache.poi.ss.usermodel.Cell cell = row.createCell(0, 1);
        cell.setCellValue("Lipid Class");
        sheet.setColumnWidth(0, 2560);
        cell = row.createCell(1, 1);
        cell.setCellValue("Lipid Molecular Species");
        sheet.setColumnWidth(1, 6400);
        cell = row.createCell(2, 1);
        cell.setCellValue("Target DB");
        sheet.setColumnWidth(2, 3840);
        cell = row.createCell(3, 1);
        cell.setCellValue("Original DB");
        sheet.setColumnWidth(3, 3840);
        cell = row.createCell(4, 1);
        cell.setCellValue("Recalibrated DB");
        sheet.setColumnWidth(4, 3840);
        cell = row.createCell(5, 1);
        cell.setCellValue("RT differences (original - target)");
        sheet.setColumnWidth(5, 3840);
        cell = row.createCell(6, 1);
        cell.setCellValue("RT error");
        sheet.setColumnWidth(6, 3840);
        cell = row.createCell(7, 1);
        cell.setCellValue("Abs RT error");
        sheet.setColumnWidth(7, 3840);
    }

    private class MolecularSpeciesContainer {
        private Hashtable<String, Vector<DoubleBondPositionVO>> singleLabeledSpecies_ = new Hashtable();
        private Hashtable<String, Vector<DoubleBondPositionVO>> multiLabeledSpecies_ = new Hashtable();

        private MolecularSpeciesContainer() {
        }

        private void addSingleLabeledSpecies(String molecularSpecies, DoubleBondPositionVO doubleBondPositionVO) {
            if (!this.singleLabeledSpecies_.containsKey(molecularSpecies)) {
                this.singleLabeledSpecies_.put(molecularSpecies, new Vector());
            }
            this.singleLabeledSpecies_.get(molecularSpecies).add(doubleBondPositionVO);
        }

        private void addMultiLabeledSpecies(String molecularSpecies, DoubleBondPositionVO doubleBondPositionVO) {
            if (!this.multiLabeledSpecies_.containsKey(molecularSpecies)) {
                this.multiLabeledSpecies_.put(molecularSpecies, new Vector());
            }
            this.multiLabeledSpecies_.get(molecularSpecies).add(doubleBondPositionVO);
        }

        private Set<String> getSingleLabeledMolecularSpecies() {
            return this.singleLabeledSpecies_.keySet();
        }

        private Vector<DoubleBondPositionVO> getSingleLabeledSpecies(String molecularSpecies) {
            if (this.singleLabeledSpecies_.containsKey(molecularSpecies)) {
                return this.singleLabeledSpecies_.get(molecularSpecies);
            }
            return null;
        }

        private Vector<DoubleBondPositionVO> getMultiLabeledSpecies(String molecularSpecies) {
            if (this.multiLabeledSpecies_.containsKey(molecularSpecies)) {
                return this.multiLabeledSpecies_.get(molecularSpecies);
            }
            return null;
        }
    }

    private class Cluster {
        private Vector<DoubleBondPositionVO> doubleBondPositionVOs_ = new Vector();

        private Cluster() {
        }

        private Cluster(Cluster cluster1, Cluster cluster2) {
            this();
            this.doubleBondPositionVOs_.addAll(cluster1.getDoubleBondPositionVOs());
            this.doubleBondPositionVOs_.addAll(cluster2.getDoubleBondPositionVOs());
        }

        private void addDoubleBondPositionVO(DoubleBondPositionVO vo) {
            this.doubleBondPositionVOs_.add(vo);
        }

        private Vector<DoubleBondPositionVO> getDoubleBondPositionVOs() {
            return this.doubleBondPositionVOs_;
        }

        private DoubleBondPositionVO getAverageElement() {
            if (!this.doubleBondPositionVOs_.isEmpty()) {
                DoubleBondPositionVO combined = new DoubleBondPositionVO(this.doubleBondPositionVOs_.get(0));
                float sum = 0.0f;
                int count = 0;
                for (DoubleBondPositionVO vo : this.doubleBondPositionVOs_) {
                    sum = (float)((double)sum + vo.getExpectedRetentionTime());
                    ++count;
                }
                float average = sum / (float)count;
                combined.setExpectedRetentionTime(average);
                return combined;
            }
            return null;
        }
    }
}

