/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.masslist;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.masslist.LipidClassVO;
import at.tugraz.genome.lda.masslist.MassListCreatorPanel;
import at.tugraz.genome.lda.vos.AdductVO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.math3.util.Pair;

public class LipidClassPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final String COMMAND_CLASS_NAME = "className";
    protected static final String COMMAND_CLASS_FA_CHAIN_NUM = "classFAChainNum";
    protected static final String COMMAND_CLASS_LCB_CHAIN_NUM = "classLCBChainNum";
    protected static final String COMMAND_CLASS_FORMULA = "classFormula";
    protected static final String COMMAND_CLASS_FA_CHAIN_LIST = "classFAChainList";
    protected static final String COMMAND_CLASS_LCB_CHAIN_LIST = "classLCBChainList";
    protected static final String COMMAND_CLASS_ADDUCT_LIST = "classAdductList";
    protected static final String COMMAND_CLASS_CHAIN_C = "classChainMin";
    protected static final String COMMAND_CLASS_DB = "classDBMin";
    protected static final String COMMAND_CLASS_RT = "classRtMin";
    protected static final String COMMAND_CLASS_OH = "classOhMin";
    protected static final String COMMAND_CLASS_ADDUCT_INSENSITIVE_RT_FILTER = "classRTFilter";
    protected static final String COMMAND_CLASS_PICK_BEST = "classPickBest";
    protected static final String COMMAND_CLASS_EXPORT = "classExport";
    protected static final String COMMAND_CLASS_DELETE = "classDelete";
    protected static final String COMMAND_ALL_OVERRIDE_ALL = "overrideAll";
    protected static final String COMMAND_ALL_CHAIN_NUM = "allChainNum";
    protected static final String COMMAND_ALL_FA_CHAIN_LIST = "allFAChainList";
    protected static final String COMMAND_ALL_LCB_CHAIN_LIST = "allLCBChainList";
    protected static final String COMMAND_ALL_ADDUCT_LIST = "allAdductList";
    protected static final String COMMAND_ALL_CHAIN_C = "allChainMin";
    protected static final String COMMAND_ALL_DB = "allDBMin";
    protected static final String COMMAND_ALL_RT = "allRtMin";
    protected static final String COMMAND_ALL_OH = "allOhMin";
    protected static final String COMMAND_ALL_ADDUCT_INSENSITIVE_RT_FILTER = "allRTFilter";
    protected static final String COMMAND_ALL_PICK_BEST = "allPickBest";
    protected static final String OPTION_EXPORT_ALL = "All listed in table";
    protected static final String OPTION_EXPORT_SELECTED = "Selected only";
    private MassListCreatorPanel parent_;
    private String[] faChainListNames_;
    private String[] lcbChainListNames_;
    private JTextField numberLCBChainField_;
    private JComboBox<String> lcbChainList_;
    private LipidClassVO selectedClass_;
    private LipidClassVO tempClass_;
    private boolean isSingleEdit_;
    private JComboBox<String> exportOption_;

    public LipidClassPanel(MassListCreatorPanel parent, boolean isSingleEdit, String[] faChainListNames, String[] lcbChainListNames) throws IOException {
        this.parent_ = parent;
        this.selectedClass_ = isSingleEdit ? parent.getSelectedClass() : new LipidClassVO(faChainListNames[0], lcbChainListNames[0]);
        this.tempClass_ = isSingleEdit ? parent.getTempClass() : new LipidClassVO(faChainListNames[0], lcbChainListNames[0]);
        this.faChainListNames_ = faChainListNames;
        this.lcbChainListNames_ = lcbChainListNames;
        this.isSingleEdit_ = isSingleEdit;
        this.init();
    }

    public void updatePanelContent(boolean isSingleEdit, String[] faChainListNames, String[] lcbChainListNames) throws IOException {
        this.selectedClass_ = isSingleEdit ? this.parent_.getSelectedClass() : new LipidClassVO(faChainListNames[0], lcbChainListNames[0]);
        this.tempClass_ = isSingleEdit ? this.parent_.getTempClass() : new LipidClassVO(faChainListNames[0], lcbChainListNames[0]);
        this.faChainListNames_ = faChainListNames;
        this.lcbChainListNames_ = lcbChainListNames;
        this.isSingleEdit_ = isSingleEdit;
        this.removeAll();
        this.init();
        this.revalidate();
        this.repaint();
    }

    private void init() throws IOException {
        this.setLayout(new GridBagLayout());
        int y = 0;
        if (this.isSingleEdit_) {
            this.addLabeledTextField(this, y++, new JLabel("Lipid (sub)class name: "), this.instantiateJTextField(COMMAND_CLASS_NAME, this.selectedClass_.getLipidClass()), "<html>This defines the name of the lipid (sub)class.<br/>In combination with the respective adduct name this determines the filename of the MS/MS fragmentation rules file <br/>that LDA will look for in the folder 'fragRules' in the installation directory.<br/>E.g. the fragmentation rule file for the lipid subclass 'PC' with the adduct 'H' is named 'PC_H.frag.txt'.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
            this.addLabeledTextField(this, y++, new JLabel("Chemical formula without chains: "), this.instantiateJTextField(COMMAND_CLASS_FORMULA, this.selectedClass_.getHeadGroupFormulaString()), "<html>This defines the chemical formula of the lipid headgroup (without chains).<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        } else {
            this.exportOption_ = this.parent_.instantiateJComboBox(new String[]{OPTION_EXPORT_ALL, OPTION_EXPORT_SELECTED}, 0, this.isSingleEdit_);
            this.addLabeledComboBox(this, y++, new JLabel("Lipid (sub)classes to export: "), this.exportOption_, "<html>Select which group of lipid (sub)class definitions should be exported.</html>");
            JSeparator sep = new JSeparator();
            sep.setPreferredSize(new Dimension(520, 10));
            this.add((Component)sep, new GridBagConstraints(0, y++, 6, 1, 1.0, 0.0, 10, 3, new Insets(10, 0, 0, 0), 0, 2));
        }
        if (!this.isSingleEdit_) {
            this.addApplyJButton(y, COMMAND_ALL_CHAIN_NUM, "<html>Apply this setting to all listed lipid (sub)class definitions.</html>");
        }
        this.numberLCBChainField_ = this.instantiateJTextField(COMMAND_CLASS_LCB_CHAIN_NUM, String.valueOf(this.selectedClass_.getNumberOfLCBChains()));
        this.addNumberOfChainSelection(this, y++, this.parent_.getPreferredDisplayComponentWidthSmaller(this.isSingleEdit_ ? 0 : 25), this.instantiateJTextField(COMMAND_CLASS_FA_CHAIN_NUM, String.valueOf(this.selectedClass_.getNumberOfFAChains())), this.numberLCBChainField_, "<html>This defines the number of fatty acid chains and spingoid bases in the lipid (sub)class.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        if (!this.isSingleEdit_) {
            this.addApplyJButton(y, COMMAND_ALL_FA_CHAIN_LIST, "<html>Apply this setting to all listed lipid (sub)class definitions.</html>");
        }
        JComboBox<String> faChainList = this.instantiateJComboBox(COMMAND_CLASS_FA_CHAIN_LIST, this.faChainListNames_, this.findSelectedChainListIndex(this.selectedClass_.getFAChainList()));
        this.addLabeledComboBox(this, y++, new JLabel("Selected FA chain list: "), faChainList, "<html>This defines the fatty acid chain list to base the mass list on.<br/>Available for selection are all fatty acid chain lists in the folder 'fattyAcids' in the installation directory.<br/>Only compounds that are possible given the entries in the provided chain list will be included in the exported file.<br/>If the chain list includes stable isotope labeled chains, those will be included in all possible combinations.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        if (!this.isSingleEdit_) {
            this.addApplyJButton(y, COMMAND_ALL_LCB_CHAIN_LIST, "<html>Apply this setting to all listed lipid (sub)class definitions.</html>");
        }
        this.lcbChainList_ = this.instantiateJComboBox(COMMAND_CLASS_LCB_CHAIN_LIST, this.lcbChainListNames_, this.findSelectedChainListIndex(this.selectedClass_.getLCBChainList()));
        this.lcbChainList_.setEnabled(this.selectedClass_.getNumberOfLCBChains() > 0);
        this.addLabeledComboBox(this, y++, new JLabel("Selected SPB chain list: "), this.lcbChainList_, "<html>This defines the sphingoid base list to base the mass list on.<br/>Available for selection are all sphingoid base lists in the folder 'fattyAcids' in the installation directory.<br/>Only compounds that are possible given the entries in the provided chain list will be included in the resulting mass list.<br/>If the chain list includes stable isotope labeled chains, those will be included in all possible combinations in the generated mass list file.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        if (!this.isSingleEdit_) {
            this.addApplyJButton(y, COMMAND_ALL_ADDUCT_LIST, "<html>Apply this setting to all listed lipid (sub)class definitions.</html>");
        }
        this.addLabeledJListScrollPane(this, y++, new JLabel("Selected adducts (hold CNTR for multiselection): "), this.instantiateJListScrollPane(COMMAND_CLASS_ADDUCT_LIST, this.parent_.getAdductCreatorPanel().getAdductListNames(), !this.isSingleEdit_ && this.selectedClass_.getAdducts().isEmpty() ? new int[]{} : this.parent_.findSelectedAdductListIndices(this.selectedClass_)), "<html>One or multiple adducts may be selected for this lipid (sub)class.<br/>Additional adducts may be defined below.<br/>Depending on the option chosen in the 'mass list export' settings below, m/z values for all adducts or only those relevant for negative or positive ion mode, respectively, are exported.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        if (!this.isSingleEdit_) {
            this.addApplyJButton(y, COMMAND_ALL_OH, "<html>Apply this setting to all listed lipid (sub)class definitions.</html>");
        }
        this.addLabeledRange(this, y++, new JLabel("Chain OH / oxidation range: "), this.instantiateJTextFieldRange(COMMAND_CLASS_OH, String.valueOf(this.selectedClass_.getOhRangeFrom()), String.valueOf(this.selectedClass_.getOhRangeTo()), this.parent_.getPreferredDisplayComponentWidthSmaller(this.isSingleEdit_ ? 0 : 25)), "<html>This defines the range of chain (FA and SPB) oxidation of a lipid (sub)class.<br/>Only masses that are possible given the chains defined in the provided chain lists are exported.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        if (!this.isSingleEdit_) {
            this.addApplyJButton(y, COMMAND_ALL_CHAIN_C, "<html>Apply this setting to all listed lipid (sub)class definitions.</html>");
        }
        this.addLabeledRange(this, y++, new JLabel("Total number of chain C atoms: "), this.instantiateJTextFieldRange(COMMAND_CLASS_CHAIN_C, String.valueOf(this.selectedClass_.getMinChainC()), String.valueOf(this.selectedClass_.getMaxChainC()), this.parent_.getPreferredDisplayComponentWidthSmaller(this.isSingleEdit_ ? 0 : 25)), "<html>This defines the range of combined chain (FA and SPB) C atoms that should be exported.<br/>Only masses that are possible given the chains defined in the provided chain lists are exported.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        if (!this.isSingleEdit_) {
            this.addApplyJButton(y, COMMAND_ALL_DB, "<html>Apply this setting to all listed lipid (sub)class definitions.</html>");
        }
        this.addLabeledRange(this, y++, new JLabel("Total number of chain double bonds: "), this.instantiateJTextFieldRange(COMMAND_CLASS_DB, String.valueOf(this.selectedClass_.getMinChainDB()), String.valueOf(this.selectedClass_.getMaxChainDB()), this.parent_.getPreferredDisplayComponentWidthSmaller(this.isSingleEdit_ ? 0 : 25)), "<html>This defines the range of combined chain (FA and SPB) double bonds that should be exported.<br/>Only masses that are possible given the chains defined in the provided chain lists are exported.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        if (!this.isSingleEdit_) {
            this.addApplyJButton(y, COMMAND_ALL_RT, "<html>Apply this setting to all listed lipid (sub)class definitions.</html>");
        }
        this.addLabeledRange(this, y++, new JLabel("Retention time (RT) range in minutes: "), this.instantiateJTextFieldRange(COMMAND_CLASS_RT, String.valueOf(this.selectedClass_.getRtRangeFrom()), String.valueOf(this.selectedClass_.getRtRangeTo()), this.parent_.getPreferredDisplayComponentWidthSmaller(this.isSingleEdit_ ? 0 : 25)), "<html>This defines the retention time range setting for the LDA mass list.<br/>If a range is defined, LDA will only consider IDs within the defined RT range.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        if (!this.isSingleEdit_) {
            this.addApplyJButton(y, COMMAND_ALL_ADDUCT_INSENSITIVE_RT_FILTER, "<html>Apply this setting to all listed lipid (sub)class definitions.</html>");
        }
        JCheckBox rtFilter = this.instantiateCheckBox(COMMAND_CLASS_ADDUCT_INSENSITIVE_RT_FILTER, this.selectedClass_.isAdductInsensitiveRtFilter());
        this.addLabeledCheckBox(this, y++, new JLabel("Enable adduct insensitive RT filter: "), rtFilter, "<html>When checked, the LDA RT filter is calculated based on all identified adducts.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        if (!this.isSingleEdit_) {
            this.addApplyJButton(y, COMMAND_ALL_PICK_BEST, "<html>Apply this setting to all listed lipid (sub)class definitions.</html>");
        }
        JCheckBox pickBest = this.instantiateCheckBox(COMMAND_CLASS_PICK_BEST, this.selectedClass_.isPickBestMatchBySpectrumCoverage());
        this.addLabeledCheckBox(this, y++, new JLabel("Pick best match by spectrum coverage: "), pickBest, "<html>When checked, the best matches are picked from duplicates (same lipid (sub)class and scan number) by spectrum coverage.<br/>Please refer to the user manual (tab 'Help') for more detailed instructions.</html>");
        JPanel buttonPanel = this.isSingleEdit_ ? this.instantiateJButtonPanel(COMMAND_CLASS_DELETE, COMMAND_CLASS_EXPORT, "Delete", "Override", "Save New", "<html>Delete this lipid (sub)class definition.</html>", "<html>Override the existing lipid (sub)class definition.</html>", "<html>Export this new lipid (sub)class definition.</html>") : this.instantiateJButtonPanel(COMMAND_ALL_OVERRIDE_ALL, "Apply all", "<html>Apply all these settings to all listed lipid (sub)class definitions.</html>");
        this.add((Component)buttonPanel, this.parent_.getDefaultGridBagConstraints(0, y, 10, 6, 1));
    }

    private JPanel instantiateJButtonPanel(String actionCommandDelete, String actionCommandExport, String textDelete, String textOverride, String textSaveNew, String tooltipsDelete, String tooltipsOverride, String tooltipsSaveNew) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton buttonDelete = this.instantiateJButton(actionCommandDelete, textDelete, false, tooltipsDelete);
        JButton buttonOverride = this.instantiateJButton(actionCommandExport, textOverride, true, tooltipsOverride);
        JButton buttonSaveNew = this.instantiateJButton(actionCommandExport, textSaveNew, false, tooltipsSaveNew);
        panel.add((Component)buttonDelete, this.parent_.getDefaultGridBagConstraints(0, 0, 17, 1, 1, new Insets(10, 10, 10, 10)));
        panel.add((Component)buttonOverride, this.parent_.getDefaultGridBagConstraints(1, 0, 17, 1, 1, new Insets(10, 10, 10, 10)));
        panel.add((Component)buttonSaveNew, this.parent_.getDefaultGridBagConstraints(2, 0, 13, 1, 1, new Insets(10, 10, 10, 10)));
        return panel;
    }

    private JPanel instantiateJButtonPanel(String actionCommand, String text, String tooltips) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JButton button = this.instantiateJButton(actionCommand, text, true, tooltips);
        panel.add((Component)button, this.parent_.getDefaultGridBagConstraints(0, 0, 10, 1, 1, new Insets(10, 10, 10, 10)));
        return panel;
    }

    private void addApplyJButton(int yPos, final String actionCommand, String tooltips) {
        JButton button = new JButton("Apply");
        button.setToolTipText(tooltips);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LipidClassPanel.this.jButtonExecuter(actionCommand);
            }
        });
        this.add((Component)button, this.parent_.getDefaultGridBagConstraints(5, yPos, 10, 1, 1));
    }

    private JButton instantiateJButton(final String actionCommand, String text, final boolean isOverride, String tooltips) {
        JButton button = new JButton(text);
        button.setToolTipText(tooltips);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LipidClassPanel.this.jButtonExecuter(actionCommand, isOverride);
            }
        });
        return button;
    }

    private JComboBox<String> instantiateJComboBox(final String actionCommand, String[] entries, int index) {
        final JComboBox<String> jComboBox = new JComboBox<String>(entries);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LipidClassPanel.this.jComboBoxChangeExecuter(actionCommand, jComboBox);
            }
        });
        jComboBox.setSelectedIndex(index);
        jComboBox.setPreferredSize(new Dimension(this.parent_.getPreferredDisplayComponentWidth(this.isSingleEdit_ ? 0 : 50), 20));
        return jComboBox;
    }

    private JCheckBox instantiateCheckBox(final String actionCommand, boolean selected) {
        final JCheckBox checkBox = new JCheckBox();
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LipidClassPanel.this.jCheckBoxChangeExecuter(actionCommand, checkBox);
            }
        });
        checkBox.setSelected(selected);
        return checkBox;
    }

    private JScrollPane instantiateJListScrollPane(final String actionCommand, String[] entries, int[] indices) throws IOException {
        final JList<String> jList = new JList<String>(entries);
        jList.setSelectionMode(2);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                LipidClassPanel.this.jListScrollChangeExecuter(actionCommand, jList);
            }
        });
        jList.setSelectedIndices(indices);
        JScrollPane scrollPane = new JScrollPane(jList);
        scrollPane.setPreferredSize(new Dimension(this.parent_.getPreferredDisplayComponentWidth(this.isSingleEdit_ ? 0 : 50), 100));
        return scrollPane;
    }

    private JTextField instantiateJTextField(String actionCommand, String text) {
        return this.instantiateJTextField(actionCommand, text, this.parent_.getPreferredDisplayComponentWidth(this.isSingleEdit_ ? 0 : 50));
    }

    private Pair<JTextField, JTextField> instantiateJTextFieldRange(final String actionCommand, String textFrom, String textTo, Integer width) {
        final JTextField textFieldFrom = new JTextField(textFrom);
        textFieldFrom.setPreferredSize(new Dimension(width, 20));
        this.parent_.setDefaultTextFieldBorder(textFieldFrom);
        final JTextField textFieldTo = new JTextField(textTo);
        textFieldTo.setPreferredSize(new Dimension(width, 20));
        this.parent_.setDefaultTextFieldBorder(textFieldTo);
        DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LipidClassPanel.this.textFieldChangeExecuterRange(actionCommand, textFieldFrom, textFieldTo);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LipidClassPanel.this.textFieldChangeExecuterRange(actionCommand, textFieldFrom, textFieldTo);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LipidClassPanel.this.textFieldChangeExecuterRange(actionCommand, textFieldFrom, textFieldTo);
            }
        };
        textFieldFrom.getDocument().addDocumentListener(listener);
        textFieldTo.getDocument().addDocumentListener(listener);
        return new Pair<JTextField, JTextField>(textFieldFrom, textFieldTo);
    }

    private JTextField instantiateJTextField(final String actionCommand, String text, Integer width) {
        final JTextField textField = new JTextField(text);
        textField.setPreferredSize(new Dimension(width, 20));
        this.parent_.setDefaultTextFieldBorder(textField);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LipidClassPanel.this.textFieldChangeExecuter(actionCommand, textField);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LipidClassPanel.this.textFieldChangeExecuter(actionCommand, textField);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                LipidClassPanel.this.textFieldChangeExecuter(actionCommand, textField);
            }
        });
        return textField;
    }

    private void addLabeledJListScrollPane(JPanel panel, Integer yPos, JLabel label, JScrollPane jScrollPane, String tooltips) {
        label.setToolTipText(tooltips);
        jScrollPane.setToolTipText(tooltips);
        panel.add((Component)label, this.parent_.getDefaultGridBagConstraints(0, yPos, 17, 2, 1));
        panel.add((Component)jScrollPane, this.parent_.getDefaultGridBagConstraints(2, yPos, 10, 3, 1));
    }

    private void addNumberOfChainSelection(JPanel panel, Integer yPos, Integer width, JTextField numberFAChainField, JTextField numberSPBChainField, String tooltips) {
        JLabel labelNum = new JLabel("Number of chains: ");
        labelNum.setToolTipText(tooltips);
        JLabel labelFA = new JLabel("FA: ");
        labelFA.setToolTipText(tooltips);
        JLabel labelSPB = new JLabel("SPB: ");
        labelSPB.setToolTipText(tooltips);
        numberFAChainField.setPreferredSize(new Dimension(width, 20));
        numberFAChainField.setToolTipText(tooltips);
        numberSPBChainField.setPreferredSize(new Dimension(width, 20));
        numberSPBChainField.setToolTipText(tooltips);
        panel.add((Component)labelNum, this.parent_.getDefaultGridBagConstraints(0, yPos, 17, 1, 1));
        panel.add((Component)labelFA, this.parent_.getDefaultGridBagConstraints(1, yPos, 13, 1, 1));
        panel.add((Component)numberFAChainField, this.parent_.getDefaultGridBagConstraints(2, yPos, 17, 1, 1));
        panel.add((Component)labelSPB, this.parent_.getDefaultGridBagConstraints(3, yPos, 13, 1, 1));
        panel.add((Component)numberSPBChainField, this.parent_.getDefaultGridBagConstraints(4, yPos, 13, 1, 1));
    }

    private void addLabeledComboBox(JPanel panel, Integer yPos, JLabel label, JComboBox<String> comboBox, String tooltips) {
        label.setToolTipText(tooltips);
        comboBox.setToolTipText(tooltips);
        panel.add((Component)label, this.parent_.getDefaultGridBagConstraints(0, yPos, 17, 2, 1));
        panel.add(comboBox, this.parent_.getDefaultGridBagConstraints(2, yPos, 10, 3, 1));
    }

    private void addLabeledCheckBox(JPanel panel, Integer yPos, JLabel label, JCheckBox checkBox, String tooltips) {
        label.setToolTipText(tooltips);
        checkBox.setToolTipText(tooltips);
        panel.add((Component)label, this.parent_.getDefaultGridBagConstraints(0, yPos, 17, 2, 1));
        panel.add((Component)checkBox, this.parent_.getDefaultGridBagConstraints(2, yPos, 10, 3, 1));
    }

    private void addLabeledTextField(JPanel panel, Integer yPos, JLabel label, JTextField textField, String tooltips) {
        label.setToolTipText(tooltips);
        textField.setToolTipText(tooltips);
        panel.add((Component)label, this.parent_.getDefaultGridBagConstraints(0, yPos, 17, 2, 1));
        panel.add((Component)textField, this.parent_.getDefaultGridBagConstraints(2, yPos, 13, 3, 1));
    }

    private void addLabeledRange(JPanel panel, Integer yPos, JLabel label, Pair<JTextField, JTextField> range, String tooltips) {
        label.setToolTipText(tooltips);
        range.getKey().setToolTipText(tooltips);
        range.getValue().setToolTipText(tooltips);
        JLabel minField = new JLabel("From: ");
        minField.setToolTipText(tooltips);
        JLabel maxField = new JLabel("To: ");
        maxField.setToolTipText(tooltips);
        panel.add((Component)label, this.parent_.getDefaultGridBagConstraints(0, yPos, 17, 1, 1));
        panel.add((Component)minField, this.parent_.getDefaultGridBagConstraints(1, yPos, 13, 1, 1));
        panel.add((Component)range.getKey(), this.parent_.getDefaultGridBagConstraints(2, yPos, 17, 1, 1));
        panel.add((Component)maxField, this.parent_.getDefaultGridBagConstraints(3, yPos, 13, 1, 1));
        panel.add((Component)range.getValue(), this.parent_.getDefaultGridBagConstraints(4, yPos, 13, 1, 1));
    }

    private int findSelectedChainListIndex(String chainListName) throws IOException {
        int i;
        for (i = 0; i < this.faChainListNames_.length; ++i) {
            if (!this.faChainListNames_[i].equalsIgnoreCase(chainListName)) continue;
            return i;
        }
        for (i = 0; i < this.lcbChainListNames_.length; ++i) {
            if (!this.lcbChainListNames_[i].equalsIgnoreCase(chainListName)) continue;
            return i;
        }
        return 0;
    }

    private void jComboBoxChangeExecuter(String actionCommand, JComboBox<String> jComboBox) {
        switch (actionCommand) {
            case "classFAChainList": {
                this.tempClass_.setFaChainList((String)jComboBox.getSelectedItem());
                break;
            }
            case "classLCBChainList": {
                this.tempClass_.setLCBChainList((String)jComboBox.getSelectedItem());
                break;
            }
        }
    }

    private void jCheckBoxChangeExecuter(String actionCommand, JCheckBox checkBox) {
        switch (actionCommand) {
            case "classRTFilter": {
                this.tempClass_.setAdductInsensitiveRtFilter(checkBox.isSelected());
                break;
            }
            case "classPickBest": {
                this.tempClass_.setPickBestMatchBySpectrumCoverage(checkBox.isSelected());
                break;
            }
        }
    }

    private void jButtonExecuter(String actionCommand, boolean isOverride) {
        switch (actionCommand) {
            case "classDelete": {
                this.synchronizeCurrentLipidClass();
                this.parent_.deleteLipidClass();
                break;
            }
            case "classExport": {
                this.parent_.synchronizeCurrentLipidClass(this);
                if (this.parent_.isLipidClassViable()) {
                    if (isOverride && (!isOverride || JOptionPane.showConfirmDialog(new JFrame(), String.format("Would you like to override the lipid (sub)class definition '%s'?", this.selectedClass_.getLipidClass()), "Override definition", 0) != 0)) break;
                    this.parent_.exportLipidClass(isOverride);
                    break;
                }
                JOptionPane.showMessageDialog(this, "The lipid class definition contains erroneous user-input, please correct textfields highlighted in red before exporting and make sure at least one adduct is selected.", "Error", 0);
                break;
            }
            case "overrideAll": {
                if (this.parent_.isGeneralDefinitionViable(this.tempClass_)) {
                    this.parent_.exportAll(this.tempClass_, this.parent_.findLipidClassesToExport((String)this.exportOption_.getSelectedItem()));
                    break;
                }
                JOptionPane.showMessageDialog(this, "The lipid class definition contains erroneous user-input, please correct textfields highlighted in red before exporting and make sure at least one adduct is selected.", "Error", 0);
                break;
            }
        }
    }

    private void jButtonExecuter(String actionCommand) {
        ArrayList<LipidClassVO> toExport = this.parent_.findLipidClassesToExport((String)this.exportOption_.getSelectedItem());
        switch (actionCommand) {
            case "allChainNum": {
                if (this.parent_.isChainNumViable(this.tempClass_)) {
                    this.parent_.exportChainNumbersToSelectedClasses(this.tempClass_.getNumberOfFAChains(), this.tempClass_.getNumberOfLCBChains(), toExport);
                    break;
                }
                JOptionPane.showMessageDialog(this, "The chain number definition contains erroneous user-input, please correct textfields highlighted in red before exporting.", "Error", 0);
                break;
            }
            case "allFAChainList": {
                this.parent_.exportFAChainListToSelectedClasses(this.tempClass_.getFAChainList(), toExport);
                break;
            }
            case "allLCBChainList": {
                this.parent_.exportSPBChainListToSelectedClasses(this.tempClass_.getLCBChainList(), toExport);
                break;
            }
            case "allAdductList": {
                if (this.parent_.isAdductListViable(this.tempClass_)) {
                    this.parent_.exportAdductListToSelectedClasses(this.tempClass_.getAdducts(), toExport);
                    break;
                }
                new WarningMessage(new JFrame(), "Error", "You must select at least one Adduct to export!");
                break;
            }
            case "allChainMin": {
                if (this.parent_.isCNumViable(this.tempClass_)) {
                    this.parent_.exportCNumToSelectedClasses(this.tempClass_.getMinChainC(), this.tempClass_.getMaxChainC(), toExport);
                    break;
                }
                JOptionPane.showMessageDialog(this, "The definition of chain C atom numbers contains erroneous user-input, please correct textfields highlighted in red before exporting.", "Error", 0);
                break;
            }
            case "allDBMin": {
                if (this.parent_.isDBNumViable(this.tempClass_)) {
                    this.parent_.exportDBNumToSelectedClasses(this.tempClass_.getMinChainDB(), this.tempClass_.getMaxChainDB(), toExport);
                    break;
                }
                JOptionPane.showMessageDialog(this, "The definition of chain double bond numbers contains erroneous user-input, please correct textfields highlighted in red before exporting.", "Error", 0);
                break;
            }
            case "allRtMin": {
                if (this.parent_.isRTViable(this.tempClass_)) {
                    this.parent_.exportRTToSelectedClasses(this.tempClass_.getRtRangeFrom(), this.tempClass_.getRtRangeTo(), toExport);
                    break;
                }
                JOptionPane.showMessageDialog(this, "The retention time definition contains erroneous user-input, please correct textfields highlighted in red before exporting.", "Error", 0);
                break;
            }
            case "allOhMin": {
                if (this.parent_.isLipidClassOxDefinitionViable(this.tempClass_)) {
                    this.parent_.exportOxNumToSelectedClasses(this.tempClass_.getOhRangeFrom(), this.tempClass_.getOhRangeTo(), toExport);
                    break;
                }
                JOptionPane.showMessageDialog(this, "The definition of chain double bond numbers contains erroneous user-input, please correct textfields highlighted in red before exporting.", "Error", 0);
                break;
            }
            case "allRTFilter": {
                this.parent_.exportPickToSelectedClasses(this.tempClass_.isAdductInsensitiveRtFilter(), toExport);
                break;
            }
            case "allPickBest": {
                this.parent_.exportPickToSelectedClasses(this.tempClass_.isPickBestMatchBySpectrumCoverage(), toExport);
                break;
            }
        }
    }

    private void textFieldChangeExecuterRange(String actionCommand, JTextField textfieldFrom, JTextField textfieldTo) {
        switch (actionCommand) {
            case "classChainMin": {
                this.tempClass_.setMinChainC(-1);
                this.tempClass_.setMaxChainC(-1);
                try {
                    int numFrom = Integer.parseInt(textfieldFrom.getText());
                    int numTo = Integer.parseInt(textfieldTo.getText());
                    if (numFrom > 0 && numTo > 0 && numFrom < numTo) {
                        this.parent_.setDefaultTextFieldBorder(textfieldFrom);
                        this.parent_.setDefaultTextFieldBorder(textfieldTo);
                    } else {
                        this.parent_.setWarningTextFieldBorder(textfieldFrom);
                        this.parent_.setWarningTextFieldBorder(textfieldTo);
                    }
                    this.tempClass_.setMinChainC(numFrom);
                    this.tempClass_.setMaxChainC(numTo);
                }
                catch (NumberFormatException ex) {
                    this.parent_.setWarningTextFieldBorder(textfieldFrom);
                    this.parent_.setWarningTextFieldBorder(textfieldTo);
                }
                break;
            }
            case "classDBMin": {
                this.tempClass_.setMinChainDB(-1);
                this.tempClass_.setMaxChainDB(-1);
                try {
                    int numFrom = Integer.parseInt(textfieldFrom.getText());
                    int numTo = Integer.parseInt(textfieldTo.getText());
                    if (numFrom < numTo || numFrom < 1 && numTo < 1) {
                        this.parent_.setDefaultTextFieldBorder(textfieldFrom);
                        this.parent_.setDefaultTextFieldBorder(textfieldTo);
                    } else {
                        this.parent_.setWarningTextFieldBorder(textfieldFrom);
                        this.parent_.setWarningTextFieldBorder(textfieldTo);
                    }
                    this.tempClass_.setMinChainDB(numFrom);
                    this.tempClass_.setMaxChainDB(numTo);
                }
                catch (NumberFormatException ex) {
                    this.parent_.setWarningTextFieldBorder(textfieldFrom);
                    this.parent_.setWarningTextFieldBorder(textfieldTo);
                }
                break;
            }
            case "classRtMin": {
                this.tempClass_.setRtRangeFrom(-1.0);
                this.tempClass_.setRtRangeTo(-1.0);
                try {
                    int numFrom = Integer.parseInt(textfieldFrom.getText());
                    int numTo = Integer.parseInt(textfieldTo.getText());
                    if (numFrom < numTo || numFrom <= 0 && numTo <= 0) {
                        this.parent_.setDefaultTextFieldBorder(textfieldFrom);
                        this.parent_.setDefaultTextFieldBorder(textfieldTo);
                    } else {
                        this.parent_.setWarningTextFieldBorder(textfieldFrom);
                        this.parent_.setWarningTextFieldBorder(textfieldTo);
                    }
                    this.tempClass_.setRtRangeFrom(numFrom);
                    this.tempClass_.setRtRangeTo(numTo);
                }
                catch (NumberFormatException ex) {
                    this.parent_.setWarningTextFieldBorder(textfieldFrom);
                    this.parent_.setWarningTextFieldBorder(textfieldTo);
                }
                break;
            }
            case "classOhMin": {
                this.tempClass_.setOhRangeFrom(0);
                this.tempClass_.setOhRangeTo(0);
                try {
                    int numFrom = Integer.parseInt(textfieldFrom.getText());
                    int numTo = Integer.parseInt(textfieldTo.getText());
                    if (numFrom >= 0 && numTo > 0 && numFrom <= numTo) {
                        this.parent_.setDefaultTextFieldBorder(textfieldFrom);
                        this.parent_.setDefaultTextFieldBorder(textfieldTo);
                    } else {
                        this.parent_.setWarningTextFieldBorder(textfieldFrom);
                        this.parent_.setWarningTextFieldBorder(textfieldTo);
                    }
                    this.tempClass_.setOhRangeFrom(numFrom);
                    this.tempClass_.setOhRangeTo(numTo);
                }
                catch (NumberFormatException ex) {
                    this.parent_.setWarningTextFieldBorder(textfieldFrom);
                    this.parent_.setWarningTextFieldBorder(textfieldTo);
                }
                break;
            }
        }
    }

    private void jListScrollChangeExecuter(String actionCommand, JList<String> jList) {
        switch (actionCommand) {
            case "classAdductList": {
                ArrayList<AdductVO> selectedAdducts = new ArrayList<AdductVO>();
                for (String adductName : jList.getSelectedValuesList()) {
                    for (AdductVO vo : this.parent_.getAdductCreatorPanel().getAllDefinedAdducts()) {
                        if (!adductName.equals(vo.getAdductName())) continue;
                        selectedAdducts.add(vo);
                    }
                }
                this.tempClass_.setAdducts(selectedAdducts);
                break;
            }
        }
    }

    private void textFieldChangeExecuter(String actionCommand, JTextField textfield) {
        switch (actionCommand) {
            case "className": {
                this.tempClass_.setLipidClass(textfield.getText());
                if (this.parent_.isLipidClassNameAvailable(textfield.getText())) {
                    this.parent_.setDefaultTextFieldBorder(textfield);
                    break;
                }
                this.parent_.setWarningTextFieldBorder(textfield);
                break;
            }
            case "classFAChainNum": {
                this.tempClass_.setNumberOfFAChains(0);
                try {
                    int chainNum = Integer.parseInt(textfield.getText());
                    if (chainNum > 0) {
                        this.parent_.setDefaultTextFieldBorder(textfield);
                    } else {
                        this.parent_.setWarningTextFieldBorder(textfield);
                    }
                    this.tempClass_.setNumberOfFAChains(chainNum);
                }
                catch (NumberFormatException ex) {
                    this.parent_.setWarningTextFieldBorder(textfield);
                }
                break;
            }
            case "classLCBChainNum": {
                this.tempClass_.setNumberOfLCBChains(0);
                try {
                    int chainNum = Integer.parseInt(textfield.getText());
                    if (chainNum >= 0) {
                        this.parent_.setDefaultTextFieldBorder(textfield);
                    } else {
                        this.parent_.setWarningTextFieldBorder(textfield);
                    }
                    this.tempClass_.setNumberOfLCBChains(chainNum);
                    this.lcbChainList_.setEnabled(chainNum > 0);
                }
                catch (NumberFormatException ex) {
                    this.parent_.setWarningTextFieldBorder(textfield);
                }
                break;
            }
            case "classFormula": {
                try {
                    this.tempClass_.setHeadGroupFormulaString(textfield.getText());
                    this.parent_.setDefaultTextFieldBorder(textfield);
                }
                catch (ChemicalFormulaException ex) {
                    this.parent_.setWarningTextFieldBorder(textfield);
                }
                break;
            }
        }
    }

    public LipidClassVO getSelectedClass() {
        return this.selectedClass_;
    }

    public LipidClassVO getTempClass() {
        return this.tempClass_;
    }

    void synchronizeCurrentLipidClass() {
        this.selectedClass_ = this.parent_.getSelectedClass();
        this.tempClass_ = this.parent_.getTempClass();
    }
}

