/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.masslist;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.masslist.LipidClassParser;
import at.tugraz.genome.lda.masslist.MassListCreatorPanel;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LipidClassesOrganizerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private MassListCreatorPanel parent_;
    private JTree folderTree_;
    private DefaultTreeModel treeModel_;

    public LipidClassesOrganizerPanel(MassListCreatorPanel parent) {
        this.parent_ = parent;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        JLabel label = new JLabel("Select working subdirectory: ");
        label.setToolTipText("<html>Select folder with defined lipid (sub)classes.</html>");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.add((Component)label, gbc);
        final DefaultMutableTreeNode root = new DefaultMutableTreeNode("Lipid Classes");
        this.treeModel_ = new DefaultTreeModel(root);
        this.folderTree_ = new JTree(this.treeModel_);
        this.folderTree_.setToolTipText("<html>Select folder with defined lipid (sub)classes.</html>");
        this.updateTreeItems(root, new File(LipidClassParser.LIPID_CLASS_FOLDER));
        this.folderTree_.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                File file = new File(LipidClassParser.LIPID_CLASS_FOLDER + File.separator + LipidClassesOrganizerPanel.this.getPath(node));
                if (node.getChildCount() == 1 && ((DefaultMutableTreeNode)node.getFirstChild()).isLeaf()) {
                    node.removeAllChildren();
                    LipidClassesOrganizerPanel.this.updateTreeItems(node, file);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.folderTree_.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultMutableTreeNode selectedNode;
                if (e.getClickCount() == 1 && (selectedNode = (DefaultMutableTreeNode)LipidClassesOrganizerPanel.this.folderTree_.getLastSelectedPathComponent()) != null) {
                    String path = LipidClassParser.LIPID_CLASS_FOLDER + File.separator + LipidClassesOrganizerPanel.this.getPath(selectedNode);
                    System.out.println("Selected path: " + path);
                    LipidClassesOrganizerPanel.this.parent_.setCurrentLipidClassSubfolderName(path);
                    try {
                        LipidClassesOrganizerPanel.this.parent_.reloadLipidClassScrollPane(null);
                    }
                    catch (ChemicalFormulaException | IOException ex) {
                        JOptionPane.showMessageDialog(LipidClassesOrganizerPanel.this, "An error occurred: " + ex.getMessage(), "Error", 0);
                    }
                }
            }
        });
        JScrollPane treeScrollPane = new JScrollPane(this.folderTree_);
        treeScrollPane.setMinimumSize(new Dimension(400, 75));
        treeScrollPane.setPreferredSize(new Dimension(575, 200));
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)treeScrollPane, gbc);
        JButton organizeButton = new JButton("Organize in File Explorer");
        organizeButton.setToolTipText("<html>Open file explorer to organize (sub)folder structure.</html>");
        organizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File directory = new File(LipidClassParser.LIPID_CLASS_FOLDER);
                    Desktop.getDesktop().open(directory);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(LipidClassesOrganizerPanel.this, "Failed to open file explorer: " + ex.getMessage(), "Error", 0);
                }
            }
        });
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add((Component)organizeButton, gbc);
        JButton updateButton = new JButton("Update");
        updateButton.setToolTipText("<html>Update displayed folderstructure.</html>");
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LipidClassesOrganizerPanel.this.updateTreeItems(root, new File(LipidClassParser.LIPID_CLASS_FOLDER));
            }
        });
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.add((Component)updateButton, gbc);
    }

    private void updateTreeItems(DefaultMutableTreeNode node, File directory) {
        node.removeAllChildren();
        if (directory.exists() && directory.isDirectory()) {
            File[] subdirectories = directory.listFiles(File::isDirectory);
            if (subdirectories != null) {
                for (File subdir : subdirectories) {
                    DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(subdir.getName());
                    childNode.add(new DefaultMutableTreeNode());
                    node.add(childNode);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "Directory does not exist: " + directory.getAbsolutePath(), "Error", 0);
        }
        this.treeModel_.reload(node);
    }

    private String getPath(DefaultMutableTreeNode node) {
        StringBuilder path = new StringBuilder();
        TreeNode[] nodes = node.getPath();
        for (int i = 1; i < nodes.length; ++i) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)nodes[i];
            path.append(treeNode.getUserObject()).append(File.separator);
        }
        return path.toString();
    }
}

