/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.FattyAcidsContainer;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.utils.RulesUtils;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.FragmentRuleVO;
import at.tugraz.genome.lda.msn.vos.FragmentVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.parser.ModificationParser;
import at.tugraz.genome.lda.utils.RangeInteger;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FragmentCalculator {
    private static final String OH_COMBI_SEPARATOR = "-";
    private static final String OH_FREQUENCY_ID_SEPRATOR = ":";
    private String rulesDir_;
    private String ruleName_;
    private String analyteName_;
    private String labelInName_;
    private String analyteFormula_;
    private String analyteFormulaWODeducts_;
    private double precursorMz_;
    private int precursorCharge_;
    private int ohNumber_;
    private ElementConfigParser elements_;
    private Hashtable<String, Hashtable<String, Vector<FattyAcidVO>>> potentialChainCombinations_;
    private Hashtable<String, FattyAcidVO> availableChains_;
    private Vector<int[]> possibleOhCombinations_;
    private Hashtable<String, Vector<Vector<Integer>>> allowedFaHydroxylationsCombinations_;
    private Hashtable<String, Vector<Vector<Integer>>> allowedLcbHydroxylationsCombinations_;
    private Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableFAChainsBeforeCombiCheck_;
    private Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkylChainsBeforeCombiCheck_;
    private Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkenylChainsBeforeCombiCheck_;
    private Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableLCBChainsBeforeCombiCheck_;
    private Hashtable<String, Integer> availableLabels_;
    private Hashtable<String, String> singleLabelLookup_;
    private Set<String> availableSingleLabels_;
    private Hashtable<String, Integer> allowedLabelsInChains_;
    private String analyteOxState_;

    public FragmentCalculator(String rulesDir, String className, String modName, String analyteName, String analyteFormula, String formulaWoDeducts, double precursorMz, int precursorCharge, int ohNumber, String analyteOxState) throws RulesException, NoRuleException, IOException, SpectrummillParserException, HydroxylationEncodingException, ChemicalFormulaException {
        this.rulesDir_ = rulesDir;
        this.ruleName_ = StaticUtils.getRuleName(className, modName);
        this.analyteName_ = analyteName;
        this.analyteFormula_ = analyteFormula;
        this.analyteFormulaWODeducts_ = formulaWoDeducts;
        this.precursorMz_ = precursorMz;
        this.precursorCharge_ = precursorCharge;
        this.ohNumber_ = ohNumber;
        if (this.ohNumber_ < 0) {
            this.ohNumber_ = 0;
        }
        this.analyteOxState_ = analyteOxState;
        this.initCalculator();
    }

    private void initCalculator() throws RulesException, NoRuleException, IOException, SpectrummillParserException, HydroxylationEncodingException, ChemicalFormulaException {
        this.elements_ = Settings.getElementParser();
        int amountOfChains = Integer.parseInt(RulesContainer.getAmountOfChains(this.ruleName_, this.rulesDir_));
        int[] chainAmounts = RulesUtils.getAmountOfChainsCategorized(this.rulesDir_, this.ruleName_);
        int fattyChains = chainAmounts[0];
        int lcbChains = chainAmounts[1];
        int acylChains = chainAmounts[2];
        int alkylChains = chainAmounts[3];
        int alkenylChains = chainAmounts[4];
        if (amountOfChains > 0) {
            try {
                String chainLib = null;
                if (fattyChains > 0) {
                    chainLib = RulesContainer.getChainlibrary(this.ruleName_, this.rulesDir_);
                }
                String lcbLib = null;
                if (lcbChains > 0) {
                    lcbLib = RulesContainer.getLcbLibrary(this.ruleName_, this.rulesDir_);
                }
                this.calculatePossibleFaLcbHydroxyCombinations(fattyChains, lcbChains);
                if (amountOfChains > 0) {
                    int cAtoms = FragmentCalculator.getIntValueFromParsingRule(RulesContainer.getCAtomsFromNamePattern(this.ruleName_, this.rulesDir_), this.analyteName_, this.ruleName_, "CAtomsFromName");
                    int dbs = FragmentCalculator.getIntValueFromParsingRule(RulesContainer.getDoubleBondsFromNamePattern(this.ruleName_, this.rulesDir_), this.analyteName_, this.ruleName_, "DoubleBondsFromName");
                    if (LipidomicsConstants.checkChainLabelCombination()) {
                        this.labelInName_ = this.analyteName_.substring(0, this.analyteName_.indexOf(String.valueOf(cAtoms)));
                    }
                    this.checkChainsForPlausibility(chainLib, lcbLib, cAtoms, dbs, alkylChains > 0, alkenylChains > 0);
                    this.extractPotentialChainCombinations(amountOfChains, fattyChains, lcbChains, acylChains, alkylChains, alkenylChains, cAtoms, dbs);
                }
            }
            catch (NoRuleException nrx) {
                throw new RulesException("Error in rule \"" + this.ruleName_ + "\"! " + nrx.getMessage());
            }
        }
    }

    private void extractPotentialChainCombinations(int chainsTotal, int faChains, int lcbChains, int acylChains, int alkylChains, int alkenylChains, int cs, int dbs) throws RulesException {
        Hashtable<Integer, Hashtable<Integer, Hashtable<String, String>>> possibleCAtomsDbsOxs = new Hashtable<Integer, Hashtable<Integer, Hashtable<String, String>>>();
        if (this.availableFAChainsBeforeCombiCheck_ != null) {
            this.addUniqueChainDbsCombis(possibleCAtomsDbsOxs, this.availableFAChainsBeforeCombiCheck_);
        }
        if (this.availableLCBChainsBeforeCombiCheck_ != null) {
            this.addUniqueChainDbsCombis(possibleCAtomsDbsOxs, this.availableLCBChainsBeforeCombiCheck_);
        }
        Vector<String> potentialCombinations = this.calculatePotentialChainCombinations(chainsTotal, cs, dbs, possibleCAtomsDbsOxs);
        this.availableChains_ = new Hashtable();
        this.potentialChainCombinations_ = this.payAttentionToActuallyPresentFaAndLcbChains(chainsTotal, faChains, lcbChains, acylChains, alkylChains, alkenylChains, potentialCombinations, this.possibleOhCombinations_, this.availableFAChainsBeforeCombiCheck_, this.availableLCBChainsBeforeCombiCheck_, this.availableAlkylChainsBeforeCombiCheck_, this.availableAlkenylChainsBeforeCombiCheck_, this.availableChains_);
    }

    /*
     * WARNING - void declaration
     */
    private Vector<String> calculatePotentialChainCombinations(int chains, int cs, int dbs, Hashtable<Integer, Hashtable<Integer, Hashtable<String, String>>> possibleCAtomsDbsOxs) {
        Vector<String> combinations = new Vector<String>();
        ArrayList<Integer> availableCs = new ArrayList<Integer>(possibleCAtomsDbsOxs.keySet());
        Hashtable<Integer, List<Integer>> availableCHash = new Hashtable<Integer, List<Integer>>();
        for (int i = 0; i != chains; ++i) {
            availableCHash.put(i + 1, availableCs);
        }
        Vector<Vector<Integer>> combis = this.getCombinations(cs, chains, availableCHash, new Vector<Integer>(), 0, false);
        Hashtable<String, String> permutedCombinations = new Hashtable<String, String>();
        for (Vector<Integer> cCombis : combis) {
            Hashtable<Integer, List<Integer>> availableDbsHash = new Hashtable<Integer, List<Integer>>();
            boolean doubleBonds = true;
            if (possibleCAtomsDbsOxs.get(cCombis.get(0)).size() == 1 && possibleCAtomsDbsOxs.get(cCombis.get(0)).keySet().iterator().next() == -1) {
                doubleBonds = false;
            }
            Vector<Vector<Object>> dbCombis = new Vector();
            if (doubleBonds) {
                for (int i = 0; i != chains; ++i) {
                    availableDbsHash.put(chains - i, new ArrayList<Integer>(possibleCAtomsDbsOxs.get(cCombis.get(i)).keySet()));
                }
                dbCombis = this.getCombinations(dbs, chains, availableDbsHash, new Vector<Integer>(), 0, true);
            } else {
                void var16_19;
                Vector<Integer> noDbsCombis = new Vector<Integer>();
                boolean bl = false;
                while (var16_19 != chains) {
                    noDbsCombis.add(-1);
                    ++var16_19;
                }
                dbCombis.add(noDbsCombis);
            }
            for (Vector vector : dbCombis) {
                int n;
                Set<Object> validOxCombis = new HashSet();
                if (!this.analyteOxState_.isEmpty()) {
                    ArrayList<String> oxStates = new ArrayList<String>(possibleCAtomsDbsOxs.get(cCombis.get(0)).get(vector.get(0)).keySet());
                    Set<List<String>> oxCombis = this.getOxCombinations(oxStates, chains);
                    validOxCombis = this.ValidateCombinations(oxCombis);
                    for (List list : validOxCombis) {
                        String combiName = "";
                        Vector<String> singleCombiParts = new Vector<String>();
                        for (int i = 0; i != chains; ++i) {
                            int cAtoms = cCombis.get(i);
                            int dBonds = (Integer)vector.get(i);
                            String oxState = null;
                            oxState = (String)list.get(i);
                            String partName = StaticUtils.generateLipidNameString(String.valueOf(cAtoms), (Integer)dBonds, -1, oxState);
                            combiName = combiName + partName + "_";
                            singleCombiParts.add(partName);
                        }
                        combiName = combiName.substring(0, combiName.length() - 1);
                        Vector<String> permutedNames = StaticUtils.getPermutedChainNames(singleCombiParts, "_");
                        boolean isThere = false;
                        for (String permutedName : permutedNames) {
                            if (!permutedCombinations.containsKey(permutedName)) continue;
                            isThere = true;
                            break;
                        }
                        if (isThere) continue;
                        for (String permutedName : permutedNames) {
                            permutedCombinations.put(permutedName, permutedName);
                        }
                        combinations.add(combiName);
                    }
                    continue;
                }
                String combiName = "";
                Vector<String> singleCombiParts = new Vector<String>();
                for (int i = 0; i != chains; ++i) {
                    n = cCombis.get(i);
                    int dBonds = (Integer)vector.get(i);
                    String oxState = null;
                    String partName = StaticUtils.generateLipidNameString(String.valueOf(n), (Integer)dBonds, -1, oxState);
                    combiName = combiName + partName + "_";
                    singleCombiParts.add(partName);
                }
                combiName = combiName.substring(0, combiName.length() - 1);
                Vector<String> permutedNames = StaticUtils.getPermutedChainNames(singleCombiParts, "_");
                n = 0;
                for (String permutedName : permutedNames) {
                    if (!permutedCombinations.containsKey(permutedName)) continue;
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                for (String permutedName : permutedNames) {
                    permutedCombinations.put(permutedName, permutedName);
                }
                combinations.add(combiName);
            }
        }
        return combinations;
    }

    private Hashtable<String, Hashtable<String, Vector<FattyAcidVO>>> payAttentionToActuallyPresentFaAndLcbChains(int chainsTotal, int faChains, int lcbChains, int acylChains, int alkylChains, int alkenylChains, Vector<String> potentialCombinations, Vector<int[]> ohCombis, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableFAChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableLCBChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkylChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkenylChains, Hashtable<String, FattyAcidVO> uniqueChains) throws RulesException {
        Hashtable<String, Hashtable<String, Vector<FattyAcidVO>>> potentialChainCombis = new Hashtable<String, Hashtable<String, Vector<FattyAcidVO>>>();
        Hashtable<Integer, Hashtable<String, String>> acylChainsInLib = null;
        Hashtable<Integer, Hashtable<String, String>> alkylChainsInLib = null;
        Hashtable<Integer, Hashtable<String, String>> alkenylChainsInLib = null;
        Hashtable<Integer, Hashtable<String, String>> lcbChainsInLib = null;
        for (int[] ohCombi : ohCombis) {
            String ohCombiId = this.getOhCombiId(ohCombi);
            Vector<String> ohDistributions = this.calculateAllPossibleOhDistributionsAmongChainTypes(acylChains, alkylChains, alkenylChains, lcbChains, this.allowedFaHydroxylationsCombinations_.get(ohCombiId), this.allowedLcbHydroxylationsCombinations_.get(ohCombiId));
            Hashtable<String, Vector<FattyAcidVO>> combis = new Hashtable<String, Vector<FattyAcidVO>>();
            potentialChainCombis.put(ohCombiId, combis);
            Set<Integer> relevantFaOHs = null;
            Set<Integer> relevantLcbOHs = null;
            if (faChains > 0) {
                relevantFaOHs = this.getRelevantOhNumbers(this.allowedFaHydroxylationsCombinations_.get(ohCombiId));
            }
            if (lcbChains > 0) {
                relevantLcbOHs = this.getRelevantOhNumbers(this.allowedLcbHydroxylationsCombinations_.get(ohCombiId));
            }
            for (String faCombi : potentialCombinations) {
                HashSet<String> uniqueFAs = new HashSet<String>();
                String[] fas = faCombi.split("_");
                if (acylChains > 0) {
                    acylChainsInLib = new Hashtable<Integer, Hashtable<String, String>>();
                }
                if (alkylChains > 0) {
                    alkylChainsInLib = new Hashtable<Integer, Hashtable<String, String>>();
                }
                if (alkenylChains > 0) {
                    alkenylChainsInLib = new Hashtable<Integer, Hashtable<String, String>>();
                }
                if (lcbChains > 0) {
                    lcbChainsInLib = new Hashtable<Integer, Hashtable<String, String>>();
                }
                for (String fa : fas) {
                    uniqueFAs.add(fa);
                }
                for (String fa : uniqueFAs) {
                    if (acylChainsInLib != null) {
                        this.checkWhetherFaIsInLib(fa, relevantFaOHs, acylChainsInLib, availableFAChains);
                    }
                    if (alkylChainsInLib != null) {
                        this.checkWhetherFaIsInLib(fa, relevantFaOHs, alkylChainsInLib, availableAlkylChains);
                    }
                    if (alkenylChainsInLib != null) {
                        this.checkWhetherFaIsInLib(fa, relevantFaOHs, alkenylChainsInLib, availableAlkenylChains);
                    }
                    if (lcbChainsInLib == null) continue;
                    this.checkWhetherFaIsInLib(fa, relevantLcbOHs, lcbChainsInLib, availableLCBChains);
                }
                for (String ohDistri : ohDistributions) {
                    this.permuteChainCombinationsOnOhPositionsAndCheckForValidity(faCombi, ohDistri, combis, acylChainsInLib, alkylChainsInLib, alkenylChainsInLib, lcbChainsInLib, availableFAChains, availableAlkylChains, availableAlkenylChains, availableLCBChains, uniqueChains);
                }
            }
        }
        return potentialChainCombis;
    }

    private Vector<Vector<Integer>> getCombinations(int expectedSum, int currentLevel, Hashtable<Integer, List<Integer>> values, Vector<Integer> prevComb, int currentPos, boolean currentPosDoesNotMatter) {
        Vector<Vector<Integer>> combinations = new Vector<Vector<Integer>>();
        if (currentLevel == 0) {
            return combinations;
        }
        int startPosition = currentPos;
        if (currentPosDoesNotMatter) {
            startPosition = 0;
        }
        for (int i = startPosition; i < values.get(currentLevel).size(); ++i) {
            Integer value = values.get(currentLevel).get(i);
            Vector<Integer> comb = new Vector<Integer>(prevComb);
            int previousSum = 0;
            for (int prev : comb) {
                previousSum += prev;
            }
            if (previousSum + value > expectedSum) continue;
            comb.add(value);
            if (currentLevel > 1) {
                Vector<Vector<Integer>> returnedCombis = this.getCombinations(expectedSum, currentLevel - 1, values, comb, i, currentPosDoesNotMatter);
                combinations.addAll(returnedCombis);
                continue;
            }
            if (expectedSum != previousSum + value) continue;
            combinations.add(comb);
        }
        return combinations;
    }

    public Hashtable<Boolean, Vector<FragmentVO>> getHeadFragments(int ohNumber) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Hashtable<Boolean, Vector<FragmentVO>> allHeadFragments = new Hashtable<Boolean, Vector<FragmentVO>>();
        Vector<FragmentVO> mandatoryFragments = new Vector<FragmentVO>();
        Vector<FragmentVO> addFragments = new Vector<FragmentVO>();
        Hashtable<String, FragmentRuleVO> headRules = RulesContainer.getHeadFragmentRules(this.ruleName_, this.rulesDir_);
        short oh = (short)ohNumber;
        for (FragmentRuleVO ruleVO : headRules.values()) {
            if (!ruleVO.hydroxylationValid(oh)) continue;
            Vector<Object> formulaAndMass = ruleVO.getFormulaAndMz(this.analyteFormula_, this.precursorMz_ * (double)this.precursorCharge_, null, 0.0, ruleVO.getCharge());
            FragmentVO fragVO = new FragmentVO(ruleVO.getName(), (Double)formulaAndMass.get(1), (String)formulaAndMass.get(0), ruleVO.getCharge(), ruleVO.getMsLevel(), ruleVO.isMandatory(oh));
            if (ruleVO.isMandatory(oh) == 1 || ruleVO.isMandatory(oh) == 3) {
                mandatoryFragments.add(fragVO);
                continue;
            }
            addFragments.add(fragVO);
        }
        allHeadFragments.put(true, mandatoryFragments);
        allHeadFragments.put(false, addFragments);
        return allHeadFragments;
    }

    public Vector<IntensityRuleVO> getHeadIntensityRules() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getHeadIntensityRules(this.ruleName_, this.rulesDir_);
    }

    private Vector<IntensityRuleVO> getChainIntensityRules() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getChainIntensityRules(this.ruleName_, this.rulesDir_);
    }

    public Hashtable<Short, Vector<IntensityRuleVO>> getChainIntensityRulesSameChain() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Hashtable<Short, Vector<IntensityRuleVO>> sameRules = new Hashtable<Short, Vector<IntensityRuleVO>>();
        Vector<IntensityRuleVO> rules = this.getChainIntensityRules();
        for (IntensityRuleVO rule : rules) {
            if (rule.getChainType() == -1) continue;
            if (!sameRules.containsKey(rule.getChainType())) {
                sameRules.put(rule.getChainType(), new Vector());
            }
            sameRules.get(rule.getChainType()).add(rule);
        }
        return sameRules;
    }

    public Vector<IntensityRuleVO> getChainIntensityRulesDiffChain() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Vector<IntensityRuleVO> rules = this.getChainIntensityRules();
        Vector<IntensityRuleVO> diffRules = new Vector<IntensityRuleVO>();
        for (IntensityRuleVO rule : rules) {
            if (rule.getChainType() != -1) continue;
            diffRules.add(rule);
        }
        return diffRules;
    }

    public Vector<IntensityRuleVO> getPositionIntensityRules() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getPositionIntensityRules(this.ruleName_, this.rulesDir_);
    }

    public FragmentRuleVO getFragmentRuleByName(String fragmentName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Hashtable<String, FragmentRuleVO> headRules = RulesContainer.getHeadFragmentRules(this.ruleName_, this.rulesDir_);
        if (headRules.containsKey(fragmentName)) {
            return headRules.get(fragmentName);
        }
        Hashtable<String, FragmentRuleVO> chainRules = RulesContainer.getChainFragmentRules(this.ruleName_, this.rulesDir_);
        if (chainRules.containsKey(fragmentName)) {
            return chainRules.get(fragmentName);
        }
        throw new RulesException("There exists no fragment with the name\"" + fragmentName + "\" for the analyte class\"" + this.ruleName_ + "\"!");
    }

    public Vector<Integer> getBasePeakIntRuleLevels(Hashtable<Integer, Boolean> msLevels) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        boolean hasBasePeakCutoff = this.getBasePeakCutoff() > 0.0;
        Hashtable<Integer, Integer> levels = new Hashtable<Integer, Integer>();
        if (hasBasePeakCutoff) {
            for (FragmentRuleVO ruleVO : RulesContainer.getHeadFragmentRules(this.ruleName_, this.rulesDir_).values()) {
                if (!msLevels.containsKey(ruleVO.getMsLevel()) || !msLevels.get(ruleVO.getMsLevel()).booleanValue()) continue;
                levels.put(ruleVO.getMsLevel(), ruleVO.getMsLevel());
            }
            for (FragmentRuleVO ruleVO : RulesContainer.getChainFragmentRules(this.ruleName_, this.rulesDir_).values()) {
                if (!msLevels.containsKey(ruleVO.getMsLevel()) || !msLevels.get(ruleVO.getMsLevel()).booleanValue()) continue;
                levels.put(ruleVO.getMsLevel(), ruleVO.getMsLevel());
            }
        } else {
            this.getBasePeakIntRuleLevels(levels, this.getHeadIntensityRules(), msLevels);
            this.getBasePeakIntRuleLevels(levels, this.getChainIntensityRules(), msLevels);
            this.getBasePeakIntRuleLevels(levels, this.getPositionIntensityRules(), msLevels);
        }
        return new Vector<Integer>(levels.keySet());
    }

    public double getBasePeakCutoff() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getBasePeakCutoff(this.ruleName_, this.rulesDir_);
    }

    public double getChainCutoff() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getChainCutoff(this.ruleName_, this.rulesDir_);
    }

    public double getSpectrumCoverageMin() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getSpectrumCoverageMin(this.ruleName_, this.rulesDir_);
    }

    private void getBasePeakIntRuleLevels(Hashtable<Integer, Integer> levels, Vector<IntensityRuleVO> intRules, Hashtable<Integer, Boolean> msLevels) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        for (IntensityRuleVO intRule : intRules) {
            int msLevel;
            if (!intRule.containsBasePeak() || !msLevels.containsKey(msLevel = this.getFragmentRuleByName(intRule.getAnyNonBasePeakName()).getMsLevel()) || !msLevels.get(msLevel).booleanValue()) continue;
            levels.put(msLevel, msLevel);
        }
    }

    public Vector<FattyAcidVO> getPossibleChainObjects() {
        return new Vector<FattyAcidVO>(this.availableChains_.values());
    }

    public Hashtable<Boolean, Vector<FragmentVO>> getChainFragments(FattyAcidVO chain) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Hashtable<Boolean, Vector<FragmentVO>> chainFragments = new Hashtable<Boolean, Vector<FragmentVO>>();
        Vector<FragmentVO> mandatoryFragments = new Vector<FragmentVO>();
        Vector<FragmentVO> addFragments = new Vector<FragmentVO>();
        Hashtable<String, FragmentRuleVO> chainRules = RulesContainer.getChainFragmentRules(this.ruleName_, this.rulesDir_);
        short oh = (short)chain.getOhNumber();
        for (FragmentRuleVO ruleVO : chainRules.values()) {
            if (ruleVO.getChainType() != chain.getChainType() || !ruleVO.hydroxylationValid(oh)) continue;
            Vector<Object> formulaAndMass = ruleVO.getFormulaAndMass(this.analyteFormula_, this.precursorMz_ * (double)this.precursorCharge_, chain, ruleVO.getCharge());
            FragmentVO fragVO = new FragmentVO(ruleVO.getName(), (Double)formulaAndMass.get(1), (String)formulaAndMass.get(0), ruleVO.getCharge(), ruleVO.getMsLevel(), ruleVO.isMandatory(oh));
            if (ruleVO.isMandatory(oh) == 1 || ruleVO.isMandatory(oh) == 3 || ruleVO.isMandatory(oh) == 4) {
                mandatoryFragments.add(fragVO);
                continue;
            }
            addFragments.add(fragVO);
        }
        chainFragments.put(true, mandatoryFragments);
        chainFragments.put(false, addFragments);
        return chainFragments;
    }

    public Hashtable<String, Vector<FattyAcidVO>> getChainFragmentCombinationsWithDetectedEvidence(Collection<String> foundFAs, Hashtable<String, Hashtable<String, CgProbe>> chainFragments, Set<String> forbiddenChains) throws RulesException, NoRuleException, IOException, SpectrummillParserException, LipidCombinameEncodingException {
        Hashtable<String, Vector<FattyAcidVO>> potentialChainCombinations = new Hashtable<String, Vector<FattyAcidVO>>();
        Hashtable<String, String> fas = new Hashtable<String, String>();
        for (String fa : foundFAs) {
            fas.put(fa, fa);
        }
        Hashtable<String, FragmentRuleVO> chainRules = RulesContainer.getChainFragmentRules(this.ruleName_, this.rulesDir_);
        boolean singleChainIdentification = RulesContainer.isSingleChainIdentification(this.ruleName_, this.rulesDir_);
        Vector<Object> relevantCombinations = new Vector();
        try {
            relevantCombinations = this.getChainCombinationsReleveantForTheseChains(fas, forbiddenChains);
        }
        catch (LipidCombinameEncodingException e) {
            throw new RulesException(e);
        }
        Hashtable<String, Integer> labelsOfChainsBase = new Hashtable<String, Integer>();
        for (String string : this.availableSingleLabels_) {
            labelsOfChainsBase.put(string, 0);
        }
        for (String string : relevantCombinations) {
            boolean allFAsThere = true;
            boolean oneFAIsThere = false;
            Vector<FattyAcidVO> chains = StaticUtils.decodeLipidNamesFromChainCombi(string);
            for (FattyAcidVO chain : chains) {
                Vector<String> mandatoryFrags = new Vector<String>();
                for (FragmentRuleVO ruleVO : chainRules.values()) {
                    short mandatory;
                    if (ruleVO.getChainType() != chain.getChainType() || !ruleVO.hydroxylationValid((short)chain.getOhNumber()) || (mandatory = ruleVO.isMandatory((short)chain.getOhNumber())) != 1 && mandatory != 3 && mandatory != 4) continue;
                    mandatoryFrags.add(ruleVO.getName());
                }
                if (!fas.containsKey(chain.getChainId())) {
                    allFAsThere = false;
                    continue;
                }
                boolean chainValid = true;
                for (String fragName : mandatoryFrags) {
                    if (chainFragments.containsKey(chain.getChainId()) && chainFragments.get(chain.getChainId()).containsKey(fragName)) continue;
                    chainValid = false;
                }
                if (chainValid) {
                    oneFAIsThere = true;
                    continue;
                }
                allFAsThere = false;
            }
            if (!allFAsThere && (!oneFAIsThere || !singleChainIdentification)) continue;
            boolean labelingIsOK = true;
            if (LipidomicsConstants.checkChainLabelCombination()) {
                Hashtable<String, Integer> labelsOfChains = new Hashtable<String, Integer>(labelsOfChainsBase);
                for (FattyAcidVO chain : chains) {
                    if (chain.getPrefix() == null || chain.getPrefix().length() <= 0) continue;
                    String singleLabel = this.singleLabelLookup_.get(chain.getPrefix());
                    labelsOfChains.put(singleLabel, (Integer)labelsOfChains.get(singleLabel) + this.availableLabels_.get(chain.getPrefix()));
                }
                for (String label : this.allowedLabelsInChains_.keySet()) {
                    if (this.allowedLabelsInChains_.get(label) == labelsOfChains.get(label)) continue;
                    labelingIsOK = false;
                    break;
                }
            }
            if (!labelingIsOK) continue;
            potentialChainCombinations.put(string, chains);
        }
        return potentialChainCombinations;
    }

    public int getAmountOfChains() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return Integer.parseInt(RulesContainer.getAmountOfChains(this.ruleName_, this.rulesDir_));
    }

    public int[] getSpectrumLevelRange() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getSpectrumLevelRange(this.ruleName_, this.rulesDir_);
    }

    public Hashtable<Integer, Boolean> correctMsLevelsForExistingFragments(Hashtable<Integer, Boolean> oldMsLevels, Hashtable<Integer, Vector<CgProbe>> probesWithMSnSpectra) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Hashtable<Integer, Boolean> usableLevels = new Hashtable<Integer, Boolean>();
        for (Integer msLevel : oldMsLevels.keySet()) {
            if (!probesWithMSnSpectra.containsKey(msLevel)) continue;
            boolean found = false;
            for (FragmentRuleVO ruleVO : RulesContainer.getHeadFragmentRules(this.ruleName_, this.rulesDir_).values()) {
                if (ruleVO.getMsLevel() != msLevel.intValue()) continue;
                found = true;
                break;
            }
            for (FragmentRuleVO ruleVO : RulesContainer.getChainFragmentRules(this.ruleName_, this.rulesDir_).values()) {
                if (ruleVO.getMsLevel() != msLevel.intValue()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            usableLevels.put(msLevel, true);
        }
        return usableLevels;
    }

    public int getAllowedChainPositions() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getAllowedChainPositions(this.ruleName_, this.rulesDir_);
    }

    public static int getIntValueFromParsingRule(String rule, String analyte, String lClass, String inputKey) throws RulesException {
        Pattern cAtomsPattern = Pattern.compile(rule);
        Matcher cAtomsMatcher = cAtomsPattern.matcher(analyte);
        if (!cAtomsMatcher.matches() && !(cAtomsMatcher = (cAtomsPattern = Pattern.compile(rule + "\\" + ";" + ".*")).matcher(analyte)).matches()) {
            throw new RulesException("The analyte " + analyte + " does not match the " + inputKey + " pattern \"" + rule + "\" of the class " + lClass + "!");
        }
        String valueString = cAtomsMatcher.group(1);
        try {
            int value = Integer.parseInt(valueString);
            return value;
        }
        catch (NumberFormatException nfx) {
            throw new RulesException("The rule \"" + rule + "\" of the class " + lClass + " is not correct, since it returns for the " + analyte + " the non-integer value \"" + valueString + "\"!");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkChainsForPlausibility(String chainLib, String lcbLib, int cAtoms, int dbs, boolean alkylPresent, boolean alkenylPresent) throws RulesException, NoRuleException, IOException, HydroxylationEncodingException, ChemicalFormulaException {
        String encoded;
        this.availableLabels_ = new Hashtable();
        this.singleLabelLookup_ = new Hashtable();
        this.availableSingleLabels_ = new HashSet<String>();
        this.allowedLabelsInChains_ = new Hashtable();
        if (chainLib == null) {
            this.availableFAChainsBeforeCombiCheck_ = null;
        } else {
            this.availableFAChainsBeforeCombiCheck_ = new Hashtable();
            Hashtable<String, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> faHydroxies = FattyAcidsContainer.getAllFattyAcidChains(chainLib);
            this.addAvailableLabels(FattyAcidsContainer.getAvailableLabels(chainLib));
            for (int ohNumber : this.getPossibleFaHydroxylations()) {
                encoded = "n";
                if (ohNumber != 0) {
                    encoded = Settings.getFaHydroxyEncoding().getEncodedPrefix((short)ohNumber);
                }
                this.checkPlausibilityAndAddToHash(this.availableFAChainsBeforeCombiCheck_, faHydroxies.get(encoded), ohNumber, cAtoms, dbs);
            }
        }
        if (this.availableFAChainsBeforeCombiCheck_ != null && alkylPresent) {
            this.availableAlkylChainsBeforeCombiCheck_ = this.createAlkylAlkenylatedHash((short)1, this.availableFAChainsBeforeCombiCheck_);
        }
        if (this.availableFAChainsBeforeCombiCheck_ != null && alkenylPresent) {
            this.availableAlkenylChainsBeforeCombiCheck_ = this.createAlkylAlkenylatedHash((short)2, this.availableFAChainsBeforeCombiCheck_);
        }
        if (lcbLib == null) {
            this.availableLCBChainsBeforeCombiCheck_ = null;
        } else {
            this.availableLCBChainsBeforeCombiCheck_ = new Hashtable();
            Hashtable<String, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> lcbHydroxies = FattyAcidsContainer.getAllLCBs(lcbLib);
            this.addAvailableLabels(FattyAcidsContainer.getAvailableLabels(lcbLib));
            for (int ohNumber : this.getPossibleLcbHydroxylations()) {
                encoded = Settings.getLcbHydroxyEncoding().getEncodedPrefix((short)ohNumber);
                this.checkPlausibilityAndAddToHash(this.availableLCBChainsBeforeCombiCheck_, (Hashtable)lcbHydroxies.get(encoded), ohNumber, cAtoms, dbs);
            }
        }
        if (LipidomicsConstants.checkChainLabelCombination()) {
            for (String string : this.availableSingleLabels_) {
                this.allowedLabelsInChains_.put(string, 0);
            }
            Vector<String> lengthSortedLabels = new Vector<String>();
            for (String label : this.availableSingleLabels_) {
                int posToAdd = -1;
                for (int i = 0; i != lengthSortedLabels.size(); ++i) {
                    if (label.length() <= ((String)lengthSortedLabels.get(i)).length()) continue;
                    posToAdd = i;
                    break;
                }
                if (posToAdd == -1) {
                    lengthSortedLabels.add(label);
                    continue;
                }
                lengthSortedLabels.add(posToAdd, label);
            }
            String string = new String(this.labelInName_);
            for (String label : lengthSortedLabels) {
                void var8_15;
                while (var8_15.indexOf(label) != -1) {
                    this.allowedLabelsInChains_.put(label, this.allowedLabelsInChains_.get(label) + 1);
                    String string2 = var8_15.substring(0, var8_15.indexOf(label)) + var8_15.substring(var8_15.indexOf(label) + label.length());
                }
                if (var8_15.length() != 0) continue;
                break;
            }
        }
    }

    private void addAvailableLabels(Set<String> labels) {
        StaticUtils.extractIsoLabelInformation(labels, this.availableSingleLabels_, this.singleLabelLookup_, this.availableLabels_);
    }

    private void checkPlausibilityAndAddToHash(Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> hash, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> toBeChecked, int ohNumber, int maxCAtoms, int maxDbs) throws RulesException {
        Hashtable chains = new Hashtable();
        try {
            Hashtable<String, Integer> formulaAmounts = StaticUtils.categorizeFormula(this.analyteFormulaWODeducts_);
            for (Integer cAtoms : toBeChecked.keySet()) {
                if (cAtoms > maxCAtoms) continue;
                Hashtable sameCAtoms = new Hashtable();
                for (Integer dbs : toBeChecked.get(cAtoms).keySet()) {
                    if (dbs > maxDbs) continue;
                    Hashtable sameDbs = new Hashtable();
                    for (String prefix : toBeChecked.get(cAtoms).get(dbs).keySet()) {
                        Hashtable<String, FattyAcidVO> sameOxs = new Hashtable<String, FattyAcidVO>();
                        for (String oxState : toBeChecked.get(cAtoms).get(dbs).get(prefix).keySet()) {
                            FattyAcidVO fa = toBeChecked.get(cAtoms).get(dbs).get(prefix).get(oxState);
                            Hashtable<String, Integer> faElements = StaticUtils.categorizeFormula(fa.getFormula());
                            boolean isOk = true;
                            for (String element : faElements.keySet()) {
                                if (formulaAmounts.containsKey(element) && formulaAmounts.get(element) >= faElements.get(element)) continue;
                                isOk = false;
                                break;
                            }
                            if (!isOk) continue;
                            sameOxs.put(oxState, fa);
                        }
                        if (sameOxs.size() <= 0) continue;
                        sameDbs.put(prefix, sameOxs);
                    }
                    if (sameDbs.size() <= 0) continue;
                    sameCAtoms.put(dbs, sameDbs);
                }
                if (sameCAtoms.size() <= 0) continue;
                chains.put(cAtoms, sameCAtoms);
            }
        }
        catch (ChemicalFormulaException e) {
            throw new RulesException("The formula " + this.analyteFormulaWODeducts_ + " contains fragments that have not been defined before! Fragments have to be defined in previous columns, before they can be used!");
        }
        hash.put(ohNumber, chains);
    }

    private void calculatePossibleFaLcbHydroxyCombinations(int faChains, int lcbChains) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        int i;
        int totalPossibleFaHydroxylations = 0;
        this.possibleOhCombinations_ = new Vector();
        this.allowedFaHydroxylationsCombinations_ = new Hashtable();
        this.allowedLcbHydroxylationsCombinations_ = new Hashtable();
        RangeInteger faRange = new RangeInteger(0, 0);
        if (faChains > 0 && RulesContainer.getFaHydroxyRange(this.ruleName_, this.rulesDir_) != null) {
            faRange = RulesContainer.getFaHydroxyRange(this.ruleName_, this.rulesDir_);
            totalPossibleFaHydroxylations = faChains * faRange.getStop();
        }
        ArrayList<Integer> availableFaOHs = new ArrayList<Integer>();
        for (int i2 = faRange.getStart(); i2 != faRange.getStop() + 1; ++i2) {
            availableFaOHs.add(i2);
        }
        Hashtable<Integer, List<Integer>> availableFaHash = new Hashtable<Integer, List<Integer>>();
        for (int i3 = 0; i3 != faChains; ++i3) {
            availableFaHash.put(i3 + 1, availableFaOHs);
        }
        int totalPossibleLcbHydroxylations = 0;
        RangeInteger lcbRange = new RangeInteger(0, 0);
        if (lcbChains > 0 && RulesContainer.getLcbHydroxyRange(this.ruleName_, this.rulesDir_) != null) {
            lcbRange = RulesContainer.getLcbHydroxyRange(this.ruleName_, this.rulesDir_);
            totalPossibleLcbHydroxylations = lcbChains * lcbRange.getStop();
        }
        ArrayList<Integer> availableLcbOHs = new ArrayList<Integer>();
        for (int i4 = lcbRange.getStart(); i4 != lcbRange.getStop() + 1; ++i4) {
            availableLcbOHs.add(i4);
        }
        Hashtable<Integer, List<Integer>> availableLcbHash = new Hashtable<Integer, List<Integer>>();
        for (i = 0; i != lcbChains; ++i) {
            availableLcbHash.put(i + 1, availableLcbOHs);
        }
        for (i = faRange.getStart() * faChains; i < totalPossibleFaHydroxylations + 1; ++i) {
            for (int j = lcbRange.getStart() * lcbChains; j < totalPossibleLcbHydroxylations + 1; ++j) {
                if (this.ohNumber_ != i + j) continue;
                this.possibleOhCombinations_.add(new int[]{i, j});
                String combiId = this.getOhCombiId(this.possibleOhCombinations_.lastElement());
                this.allowedFaHydroxylationsCombinations_.put(combiId, this.getCombinations(i, faChains, availableFaHash, new Vector<Integer>(), 0, false));
                this.allowedLcbHydroxylationsCombinations_.put(combiId, this.getCombinations(j, lcbChains, availableLcbHash, new Vector<Integer>(), 0, false));
            }
        }
        if (this.possibleOhCombinations_.size() == 0) {
            throw new RulesException("The amount of " + this.ohNumber_ + " hydroxylation sites, cannot be fulfilled by " + lcbChains + " LCB chains with " + (lcbRange.getStart() == lcbRange.getStop() ? String.valueOf(lcbRange.getStart()) : String.valueOf(lcbRange.getStart()) + OH_COMBI_SEPARATOR + String.valueOf(lcbRange.getStop())) + " hydroxylation sites, and " + faChains + " FA chains with " + (faRange.getStart() == faRange.getStop() ? String.valueOf(faRange.getStart()) : String.valueOf(faRange.getStart()) + OH_COMBI_SEPARATOR + String.valueOf(faRange.getStop())) + " hydroxylation sites!");
        }
    }

    private String getOhCombiId(int[] combi) {
        return String.valueOf(combi[0]) + OH_COMBI_SEPARATOR + String.valueOf(combi[1]);
    }

    private Vector<Integer> getPossibleFaHydroxylations() {
        return this.getPossibleHydroxylations(0);
    }

    private Vector<Integer> getPossibleLcbHydroxylations() {
        return this.getPossibleHydroxylations(1);
    }

    private Vector<Integer> getPossibleHydroxylations(int position) {
        Vector<Integer> ohIndices = new Vector<Integer>();
        Hashtable<Integer, Integer> ohs = new Hashtable<Integer, Integer>();
        int highestOh = 0;
        for (int[] ohCombi : this.possibleOhCombinations_) {
            String combiId = this.getOhCombiId(ohCombi);
            Vector<Vector<Integer>> allowedCombis = null;
            if (position == 0) {
                allowedCombis = this.allowedFaHydroxylationsCombinations_.get(combiId);
            } else if (position == 1) {
                allowedCombis = this.allowedLcbHydroxylationsCombinations_.get(combiId);
            }
            if (allowedCombis == null) continue;
            for (Vector<Integer> combi : allowedCombis) {
                for (Integer ohNumber : combi) {
                    ohs.put(ohNumber, ohNumber);
                    if (ohNumber <= highestOh) continue;
                    highestOh = ohNumber;
                }
            }
        }
        for (int i = 0; i < highestOh + 1; ++i) {
            if (!ohs.containsKey(i)) continue;
            ohIndices.add(i);
        }
        return ohIndices;
    }

    private void addUniqueChainDbsCombis(Hashtable<Integer, Hashtable<Integer, Hashtable<String, String>>> hash, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> toBeAdded) {
        for (Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> carbonHash : toBeAdded.values()) {
            for (Integer cAtoms : carbonHash.keySet()) {
                Hashtable<Object, Object> dbHash;
                if (hash.containsKey(cAtoms)) {
                    dbHash = hash.get(cAtoms);
                } else {
                    dbHash = new Hashtable();
                    hash.put(cAtoms, dbHash);
                }
                for (Integer dbs : carbonHash.get(cAtoms).keySet()) {
                    Hashtable<Object, Object> oxHash;
                    if (dbHash.containsKey(dbs)) {
                        oxHash = hash.get(cAtoms).get(dbs);
                    } else {
                        oxHash = new Hashtable();
                        dbHash.put(dbs, oxHash);
                    }
                    for (String prefix : carbonHash.get(cAtoms).get(dbs).keySet()) {
                        for (String oxs : carbonHash.get(cAtoms).get(dbs).get(prefix).keySet()) {
                            oxHash.put(oxs, oxs);
                        }
                    }
                }
            }
        }
    }

    private Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> createAlkylAlkenylatedHash(short chainType, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> faHash) throws ChemicalFormulaException {
        Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> newHash = new Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>>();
        for (Integer oh : faHash.keySet()) {
            newHash.put(oh, new Hashtable());
            for (Integer c : faHash.get(oh).keySet()) {
                newHash.get(oh).put(c, new Hashtable());
                for (Integer dbs : faHash.get(oh).get(c).keySet()) {
                    newHash.get(oh).get(c).put(dbs, new Hashtable());
                    for (String prefix : faHash.get(oh).get(c).get(dbs).keySet()) {
                        newHash.get(oh).get(c).get(dbs).put(prefix, new Hashtable());
                        for (String oxState : faHash.get(oh).get(c).get(dbs).get(prefix).keySet()) {
                            FattyAcidVO faVO = faHash.get(oh).get(c).get(dbs).get(prefix).get(oxState);
                            Hashtable<String, Integer> faElements = StaticUtils.categorizeFormula(faVO.getFormula());
                            double mass = faVO.getMass();
                            if (!faElements.containsKey("O")) continue;
                            if (chainType == 1) {
                                mass += 2.0 * this.elements_.getElementDetails("H").getMonoMass() - this.elements_.getElementDetails("O").getMonoMass();
                                faElements.put("H", faElements.get("H") + 2);
                                faElements.put("O", faElements.get("O") - 1);
                            } else if (chainType == 2) {
                                mass += -1.0 * this.elements_.getElementDetails("O").getMonoMass();
                                faElements.put("O", faElements.get("O") - 1);
                            }
                            if (faElements.get("O") < 0 || mass < 0.0) continue;
                            newHash.get(oh).get(c).get(dbs).get(prefix).put(oxState, new FattyAcidVO(chainType, faVO.getPrefix(), faVO.getcAtoms(), faVO.getDoubleBonds(), oh, mass, StaticUtils.getFormulaInHillNotation(faElements, true), faVO.getOxState()));
                        }
                    }
                }
            }
        }
        return newHash;
    }

    private Set<Integer> getRelevantOhNumbers(Vector<Vector<Integer>> hydroCombis) {
        HashSet<Integer> relevant = new HashSet<Integer>();
        for (Vector<Integer> ohFaCombi : hydroCombis) {
            for (Integer ohNumber : ohFaCombi) {
                relevant.add(ohNumber);
            }
        }
        return relevant;
    }

    private void checkWhetherFaIsInLib(String chain, Set<Integer> ohNumbers, Hashtable<Integer, Hashtable<String, String>> hashToAdd, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> chainLib) throws RulesException {
        String[] cAndDbAndOx = null;
        try {
            cAndDbAndOx = StaticUtils.parseCAndDbsFromChainId(chain);
        }
        catch (Exception e) {
            throw new RulesException(e.getMessage());
        }
        for (Integer oh : ohNumbers) {
            if (!hashToAdd.containsKey(oh)) {
                hashToAdd.put(oh, new Hashtable());
            }
            if (!chainLib.containsKey(oh) || !chainLib.get(oh).containsKey(Integer.parseInt(cAndDbAndOx[0])) || !chainLib.get(oh).get(Integer.parseInt(cAndDbAndOx[0])).containsKey(Integer.parseInt(cAndDbAndOx[1])) || !chainLib.get(oh).get(Integer.parseInt(cAndDbAndOx[0])).get(Integer.parseInt(cAndDbAndOx[1])).values().iterator().next().containsKey(cAndDbAndOx[2])) continue;
            hashToAdd.get(oh).put(chain, chain);
        }
    }

    private Vector<String> calculateAllPossibleOhDistributionsAmongChainTypes(int acylChains, int alkylChains, int alkenylChains, int lcbChains, Vector<Vector<Integer>> faHydroxylationOptions, Vector<Vector<Integer>> lcbHydroxylationOptions) {
        Vector<String> encodedOptions = new Vector<String>();
        Vector encodedFaMoiety = new Vector();
        Vector<String> encodedLcbMoiety = new Vector<String>();
        if (faHydroxylationOptions != null) {
            for (Vector<Integer> hydroxiesOnChain : faHydroxylationOptions) {
                Hashtable<Integer, Integer> numberOfChainsWithSameOh = new Hashtable<Integer, Integer>();
                for (Integer oh : hydroxiesOnChain) {
                    if (numberOfChainsWithSameOh.containsKey(oh)) {
                        numberOfChainsWithSameOh.put(oh, numberOfChainsWithSameOh.get(oh) + 1);
                        continue;
                    }
                    numberOfChainsWithSameOh.put(oh, 1);
                }
                Vector<String> allPossibleAcylPermutations = this.getPossibleFaOHPermutations((short)0, acylChains, numberOfChainsWithSameOh);
                Vector<String> allPossibleAlkylPermutations = this.getPossibleFaOHPermutations((short)1, alkylChains, numberOfChainsWithSameOh);
                Vector<String> allPossibleAlkenylPermutations = this.getPossibleFaOHPermutations((short)2, alkenylChains, numberOfChainsWithSameOh);
                Vector<String> possibleCombis = this.getAcylAlkylAlkenylPermutations(allPossibleAcylPermutations, allPossibleAlkylPermutations, allPossibleAlkenylPermutations, numberOfChainsWithSameOh);
                encodedFaMoiety.addAll(possibleCombis);
            }
        }
        if (lcbHydroxylationOptions != null) {
            for (Vector<Integer> hydroxiesOnChain : lcbHydroxylationOptions) {
                Hashtable<Integer, Integer> numberOfChainsWithSameOh = new Hashtable<Integer, Integer>();
                int lowest = Integer.MAX_VALUE;
                int highest = 0;
                for (Integer oh : hydroxiesOnChain) {
                    if (oh < lowest) {
                        lowest = oh;
                    }
                    if (oh > highest) {
                        highest = oh;
                    }
                    if (numberOfChainsWithSameOh.containsKey(oh)) {
                        numberOfChainsWithSameOh.put(oh, (Integer)numberOfChainsWithSameOh.get(oh) + 1);
                        continue;
                    }
                    numberOfChainsWithSameOh.put(oh, 1);
                }
                StringBuilder encoded = new StringBuilder();
                for (int i = lowest; i < highest + 1; ++i) {
                    if (!numberOfChainsWithSameOh.containsKey(i)) continue;
                    if (encoded.length() > 0) {
                        encoded.append("_");
                    }
                    encoded.append(this.createTypeOHFrequencyString((short)3, i, (Integer)numberOfChainsWithSameOh.get(i)));
                }
                encodedLcbMoiety.add(encoded.toString());
            }
        }
        if (encodedFaMoiety.size() > 0) {
            if (encodedLcbMoiety.size() > 0) {
                for (String faCombi : encodedFaMoiety) {
                    for (String lcbCombi : encodedLcbMoiety) {
                        encodedOptions.add(faCombi + "_" + lcbCombi);
                    }
                }
            } else {
                encodedOptions.addAll(encodedFaMoiety);
            }
        } else if (encodedLcbMoiety.size() > 0) {
            encodedOptions.addAll(encodedLcbMoiety);
        }
        return encodedOptions;
    }

    private Vector<String> getPossibleFaOHPermutations(short chainType, int chains, Hashtable<Integer, Integer> sameOhFrequencies) {
        Vector<String> toReturn = new Vector<String>();
        if (chains < 1) {
            return toReturn;
        }
        Vector<String> permut = this.getOhPermutations(chains, sameOhFrequencies);
        if (permut.size() > 0) {
            Hashtable<String, String> unique = new Hashtable<String, String>();
            for (String combi : permut) {
                String[] split;
                int lowest = Integer.MAX_VALUE;
                int highest = 0;
                Hashtable<Integer, Integer> ohFrequencies = new Hashtable<Integer, Integer>();
                for (String ohString : split = combi.split("_")) {
                    Integer oh = new Integer(ohString);
                    if (oh < lowest) {
                        lowest = oh;
                    }
                    if (oh > highest) {
                        highest = oh;
                    }
                    if (ohFrequencies.containsKey(oh)) {
                        ohFrequencies.put(oh, (Integer)ohFrequencies.get(oh) + 1);
                        continue;
                    }
                    ohFrequencies.put(oh, 1);
                }
                StringBuilder encoded = new StringBuilder();
                for (int i = lowest; i < highest + 1; ++i) {
                    if (!ohFrequencies.containsKey(i)) continue;
                    if (encoded.length() > 0) {
                        encoded.append("_");
                    }
                    encoded.append(this.createTypeOHFrequencyString(chainType, i, (Integer)ohFrequencies.get(i)));
                }
                String encodedStr = encoded.toString();
                unique.put(encodedStr, encodedStr);
            }
            for (String encoded : unique.keySet()) {
                toReturn.add(encoded);
            }
        }
        return toReturn;
    }

    private Vector<String> getOhPermutations(int chains, Hashtable<Integer, Integer> sameOhFrequencies) {
        Vector<String> toReturn = new Vector<String>();
        for (Integer oh : sameOhFrequencies.keySet()) {
            if (!sameOhFrequencies.containsKey(oh)) continue;
            String combi = String.valueOf(oh);
            if (chains > 1) {
                Hashtable<Integer, Integer> newOhFrequencies = new Hashtable<Integer, Integer>(sameOhFrequencies);
                int amount = newOhFrequencies.get(oh);
                if (--amount <= 0) {
                    newOhFrequencies.remove(oh);
                } else {
                    newOhFrequencies.put(oh, amount);
                }
                for (String otherPart : this.getOhPermutations(chains - 1, newOhFrequencies)) {
                    toReturn.add(combi + "_" + otherPart);
                }
                continue;
            }
            toReturn.add(combi);
        }
        return toReturn;
    }

    private String createTypeOHFrequencyString(short chainType, int oh, int frequency) {
        return chainType + OH_FREQUENCY_ID_SEPRATOR + oh + OH_FREQUENCY_ID_SEPRATOR + frequency;
    }

    private Vector<String> getAcylAlkylAlkenylPermutations(Vector<String> acyls, Vector<String> alkyls, Vector<String> alkenyls, Hashtable<Integer, Integer> numberOfChainsWithSameOh) {
        Vector<String> faMoieties;
        block12: {
            block13: {
                block11: {
                    faMoieties = new Vector<String>();
                    if (acyls == null || acyls.size() <= 0) break block11;
                    for (String acylCombi : acyls) {
                        String encodedTotal;
                        if (alkyls != null && alkyls.size() > 0) {
                            for (String alkylCombi : alkyls) {
                                if (alkenyls != null && alkenyls.size() > 0) {
                                    for (String alkenylCombi : alkenyls) {
                                        encodedTotal = acylCombi + "_" + alkylCombi + "_" + alkenylCombi;
                                        if (!this.areOhNumbersFulfilled(encodedTotal, numberOfChainsWithSameOh)) continue;
                                        faMoieties.add(encodedTotal);
                                    }
                                    continue;
                                }
                                encodedTotal = acylCombi + "_" + alkylCombi;
                                if (!this.areOhNumbersFulfilled(encodedTotal, numberOfChainsWithSameOh)) continue;
                                faMoieties.add(encodedTotal);
                            }
                            continue;
                        }
                        if (alkenyls != null && alkenyls.size() > 0) {
                            for (String alkenylCombi : alkenyls) {
                                encodedTotal = acylCombi + "_" + alkenylCombi;
                                if (!this.areOhNumbersFulfilled(encodedTotal, numberOfChainsWithSameOh)) continue;
                                faMoieties.add(encodedTotal);
                            }
                            continue;
                        }
                        encodedTotal = acylCombi;
                        if (!this.areOhNumbersFulfilled(encodedTotal, numberOfChainsWithSameOh)) continue;
                        faMoieties.add(encodedTotal);
                    }
                    break block12;
                }
                if (alkyls == null || alkyls.size() <= 0) break block13;
                for (String alkylCombi : alkyls) {
                    String encodedTotal;
                    if (alkenyls != null && alkenyls.size() > 0) {
                        for (String alkenylCombi : alkenyls) {
                            encodedTotal = alkylCombi + "_" + alkenylCombi;
                            if (!this.areOhNumbersFulfilled(encodedTotal, numberOfChainsWithSameOh)) continue;
                            faMoieties.add(encodedTotal);
                        }
                        continue;
                    }
                    encodedTotal = alkylCombi;
                    if (!this.areOhNumbersFulfilled(encodedTotal, numberOfChainsWithSameOh)) continue;
                    faMoieties.add(encodedTotal);
                }
                break block12;
            }
            if (alkenyls == null || alkenyls.size() <= 0) break block12;
            for (String alkenylCombi : alkenyls) {
                String encodedTotal = alkenylCombi;
                if (!this.areOhNumbersFulfilled(encodedTotal, numberOfChainsWithSameOh)) continue;
                faMoieties.add(encodedTotal);
            }
        }
        return faMoieties;
    }

    private boolean areOhNumbersFulfilled(String encodedTotal, Hashtable<Integer, Integer> numberOfChainsWithSameOh) {
        String[] ohNames;
        Hashtable<Integer, Integer> refTable = new Hashtable<Integer, Integer>();
        for (String oneOhName : ohNames = encodedTotal.split("_")) {
            int[] decoded = this.decodeTypeOHFrequencyString(oneOhName);
            if (refTable.containsKey(decoded[1])) {
                refTable.put(decoded[1], (Integer)refTable.get(decoded[1]) + decoded[2]);
                continue;
            }
            refTable.put(decoded[1], decoded[2]);
        }
        boolean ok = true;
        if (refTable.size() == numberOfChainsWithSameOh.size()) {
            for (Integer oh : numberOfChainsWithSameOh.keySet()) {
                if (refTable.containsKey(oh) && numberOfChainsWithSameOh.get(oh) == refTable.get(oh)) continue;
                ok = false;
                break;
            }
        } else {
            ok = false;
        }
        return ok;
    }

    private int[] decodeTypeOHFrequencyString(String encoded) {
        int[] decoded = new int[3];
        String[] parts = encoded.split(OH_FREQUENCY_ID_SEPRATOR);
        for (int i = 0; i < 3; ++i) {
            decoded[i] = Integer.parseInt(parts[i]);
        }
        return decoded;
    }

    private void permuteChainCombinationsOnOhPositionsAndCheckForValidity(String chainCombi, String ohDistri, Hashtable<String, Vector<FattyAcidVO>> toAdd, Hashtable<Integer, Hashtable<String, String>> acylChainsInLib, Hashtable<Integer, Hashtable<String, String>> alkylChainsInLib, Hashtable<Integer, Hashtable<String, String>> alkenylChainsInLib, Hashtable<Integer, Hashtable<String, String>> lcbChainsInLib, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableFAChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkylChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkenylChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableLCBChains, Hashtable<String, FattyAcidVO> uniqueChains) throws RulesException {
        String[] chains = chainCombi.split("_");
        boolean[] usedChains = new boolean[chains.length];
        try {
            Vector<String> chainPermutations = this.getPermutedChainsSplitOnChainAndOhTypes(ohDistri, chains, usedChains, acylChainsInLib, alkylChainsInLib, alkenylChainsInLib, lcbChainsInLib, availableFAChains, availableAlkylChains, availableAlkenylChains, availableLCBChains);
            if (chainPermutations == null || chainPermutations.size() == 0) {
                return;
            }
            for (String permuteId : chainPermutations) {
                this.addIsotopeLabelsToMutations(permuteId, toAdd, availableFAChains, availableAlkylChains, availableAlkenylChains, availableLCBChains, uniqueChains);
            }
        }
        catch (ChemicalFormulaException | LipidCombinameEncodingException e) {
            throw new RulesException(e);
        }
    }

    private Vector<String> getPermutedChainsSplitOnChainAndOhTypes(String ohId, String[] chains, boolean[] usedChains, Hashtable<Integer, Hashtable<String, String>> acylChainsInLib, Hashtable<Integer, Hashtable<String, String>> alkylChainsInLib, Hashtable<Integer, Hashtable<String, String>> alkenylChainsInLib, Hashtable<Integer, Hashtable<String, String>> lcbChainsInLib, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableFAChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkylChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkenylChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableLCBChains) throws RulesException, LipidCombinameEncodingException {
        String ohTypeFrequencyId;
        String remainingOhId = null;
        boolean lastOccurence = false;
        if (ohId.indexOf("_") == -1) {
            ohTypeFrequencyId = ohId;
            lastOccurence = true;
        } else {
            remainingOhId = ohId.substring(0, ohId.lastIndexOf("_"));
            ohTypeFrequencyId = ohId.substring(ohId.lastIndexOf("_") + 1);
        }
        int[] decoded = this.decodeTypeOHFrequencyString(ohTypeFrequencyId);
        short type = (short)decoded[0];
        int oh = decoded[1];
        int nrOfChains = decoded[2];
        Hashtable<String, String> lookup = null;
        Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> values = null;
        if (type == 0) {
            lookup = acylChainsInLib.get(oh);
            values = availableFAChains.get(oh);
        } else if (type == 1) {
            lookup = alkylChainsInLib.get(oh);
            values = availableAlkylChains.get(oh);
        } else if (type == 2) {
            lookup = alkenylChainsInLib.get(oh);
            values = availableAlkenylChains.get(oh);
        } else if (type == 3) {
            lookup = lcbChainsInLib.get(oh);
            values = availableLCBChains.get(oh);
        }
        Vector<String> availableChains = new Vector<String>();
        for (int i = 0; i != chains.length; ++i) {
            if (usedChains[i] || !lookup.containsKey(chains[i])) continue;
            availableChains.add(chains[i]);
        }
        if (availableChains.size() < nrOfChains) {
            return null;
        }
        Vector<String> combis = this.getAllPossibleChainCombinations(nrOfChains, availableChains);
        Vector<String> permutedResults = new Vector<String>();
        Hashtable<String, String> combisEncoded = new Hashtable<String, String>();
        for (String combi : combis) {
            StringBuilder encoded = new StringBuilder();
            for (String chain : combi.split("_")) {
                if (encoded.length() > 0) {
                    encoded.append("<->");
                }
                try {
                    String[] cAndDbs = StaticUtils.parseCAndDbsFromChainId(chain);
                    encoded.append(values.get(Integer.parseInt(cAndDbs[0])).get(Integer.parseInt(cAndDbs[1])).values().iterator().next().get(cAndDbs[2]).getChainIdDetailed(false, true));
                }
                catch (Exception e) {
                    throw new RulesException(e);
                }
            }
            combisEncoded.put(combi, encoded.toString());
        }
        if (lastOccurence) {
            for (String combiEncoded : combisEncoded.values()) {
                permutedResults.add(combiEncoded);
            }
        } else {
            for (String combi : combis) {
                boolean[] remainingChains = (boolean[])usedChains.clone();
                block7: for (String oneChain : combi.split("_")) {
                    for (int i = 0; i != chains.length; ++i) {
                        if (remainingChains[i] || !chains[i].equalsIgnoreCase(oneChain)) continue;
                        remainingChains[i] = true;
                        continue block7;
                    }
                }
                Vector<String> fromOtherParts = this.getPermutedChainsSplitOnChainAndOhTypes(remainingOhId, chains, remainingChains, acylChainsInLib, alkylChainsInLib, alkenylChainsInLib, lcbChainsInLib, availableFAChains, availableAlkylChains, availableAlkenylChains, availableLCBChains);
                if (fromOtherParts == null || fromOtherParts.size() == 0) continue;
                for (String other : fromOtherParts) {
                    permutedResults.add(other + "<->" + (String)combisEncoded.get(combi));
                }
            }
        }
        return permutedResults;
    }

    private Vector<String> getAllPossibleChainCombinations(int nrOfChains, Vector<String> chains) throws LipidCombinameEncodingException {
        Vector<String> combisWithRepeats = new Vector<String>();
        for (int i = 0; i != chains.size(); ++i) {
            String chain = chains.get(i);
            if (nrOfChains > 1) {
                Vector<String> remainingChains = new Vector<String>(chains);
                remainingChains.remove(i);
                for (String otherPart : this.getAllPossibleChainCombinations(nrOfChains - 1, remainingChains)) {
                    combisWithRepeats.add(chain + "_" + otherPart);
                }
                continue;
            }
            combisWithRepeats.add(chain);
        }
        Hashtable<String, String> unique = new Hashtable<String, String>();
        for (String combi : combisWithRepeats) {
            String sorted = StaticUtils.sortFASequenceUnassigned(combi, "_");
            unique.put(sorted, sorted);
        }
        Vector<String> combis = new Vector<String>();
        for (String combi : unique.keySet()) {
            combis.add(combi);
        }
        return combis;
    }

    private void addIsotopeLabelsToMutations(String permuteId, Hashtable<String, Vector<FattyAcidVO>> toAdd, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableFAChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkylChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkenylChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableLCBChains, Hashtable<String, FattyAcidVO> uniqueChains) throws LipidCombinameEncodingException, ChemicalFormulaException {
        FattyAcidVO chain;
        Vector<FattyAcidVO> chains = StaticUtils.decodeLipidNamesFromChainCombi(permuteId);
        int[] isotopicLabels = new int[chains.size()];
        int[] divisors = new int[chains.size()];
        Hashtable chainVOsByPosition = new Hashtable();
        for (int i = 0; i != chains.size(); ++i) {
            chain = chains.get(i);
            Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> available = this.getLookupHashByChainType(chain.getChainType(), availableFAChains, availableAlkylChains, availableAlkenylChains, availableLCBChains);
            Hashtable<String, FattyAcidVO> faPlusPrefix = new Hashtable<String, FattyAcidVO>();
            Set<String> prefixes = available.get(chain.getOhNumber()).get(chain.getcAtoms()).get(chain.getDoubleBonds()).keySet();
            for (String prefix : prefixes) {
                faPlusPrefix.put(prefix, available.get(chain.getOhNumber()).get(chain.getcAtoms()).get(chain.getDoubleBonds()).get(prefix).get(chain.getOxState()));
            }
            chainVOsByPosition.put(i, faPlusPrefix);
            isotopicLabels[i] = ((Hashtable)chainVOsByPosition.get(i)).size();
        }
        int iterations = 1;
        for (int i = isotopicLabels.length - 1; i != -1; --i) {
            divisors[i] = iterations;
            iterations *= isotopicLabels[i];
        }
        Hashtable<String, String> permutedCombinations = new Hashtable<String, String>();
        for (int j = 0; j != iterations; ++j) {
            String combiName = "";
            Vector valueVOs = new Vector();
            Vector<String> singleCombiParts = new Vector<String>();
            block4: for (int i = 0; i != chains.size(); ++i) {
                chain = chains.get(i);
                Hashtable chainVOs = (Hashtable)chainVOsByPosition.get(i);
                int currentIndex = j / divisors[i] % isotopicLabels[i];
                int k = 0;
                for (String prefix : chainVOs.keySet()) {
                    if (k == currentIndex) {
                        String partName = ((FattyAcidVO)chainVOs.get(prefix)).getChainId();
                        combiName = combiName + partName + "<->";
                        valueVOs.add(chainVOs.get(prefix));
                        singleCombiParts.add(partName);
                        continue block4;
                    }
                    ++k;
                }
            }
            combiName = combiName.substring(0, combiName.length() - "<->".length());
            Vector<String> permutedNames = StaticUtils.getPermutedChainNames(singleCombiParts, "<->");
            boolean isThere = false;
            for (String permutedName : permutedNames) {
                if (!permutedCombinations.containsKey(permutedName)) continue;
                isThere = true;
                break;
            }
            if (isThere) continue;
            for (String permutedName : permutedNames) {
                permutedCombinations.put(permutedName, permutedName);
            }
            boolean ok = true;
            if (!ok) continue;
            toAdd.put(combiName, valueVOs);
            for (FattyAcidVO vo : valueVOs) {
                if (uniqueChains.containsKey(vo.getChainId())) continue;
                uniqueChains.put(vo.getChainId(), vo);
            }
        }
    }

    private Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> getLookupHashByChainType(short chainType, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableFAChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkylChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableAlkenylChains, Hashtable<Integer, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> availableLCBChains) throws LipidCombinameEncodingException {
        if (chainType == 0) {
            return availableFAChains;
        }
        if (chainType == 1) {
            return availableAlkylChains;
        }
        if (chainType == 2) {
            return availableAlkenylChains;
        }
        if (chainType == 3) {
            return availableLCBChains;
        }
        throw new LipidCombinameEncodingException("The chain type \"" + chainType + "\" is not allowed in the combination");
    }

    private Vector<String> getChainCombinationsReleveantForTheseChains(Hashtable<String, String> chains, Set<String> forbiddenChains) throws LipidCombinameEncodingException {
        Vector<String> relevantChains = new Vector<String>();
        for (Hashtable<String, Vector<FattyAcidVO>> ohCombi : this.potentialChainCombinations_.values()) {
            for (String combiId : ohCombi.keySet()) {
                boolean relevant = false;
                for (String chain : chains.keySet()) {
                    if (combiId.indexOf(chain) == -1) continue;
                    for (FattyAcidVO vo : StaticUtils.decodeLipidNamesFromChainCombi(combiId)) {
                        if (!vo.getChainId().equalsIgnoreCase(chain)) continue;
                        relevant = true;
                        break;
                    }
                    if (!relevant) continue;
                    break;
                }
                if (relevant) {
                    for (FattyAcidVO vo : StaticUtils.decodeLipidNamesFromChainCombi(combiId)) {
                        if (!forbiddenChains.contains(vo.getChainId())) continue;
                        relevant = false;
                        break;
                    }
                }
                if (!relevant) continue;
                relevantChains.add(combiId);
            }
        }
        return relevantChains;
    }

    public boolean containAllOhCombinationsClassSpecificFragments() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        boolean foundClassFragments = false;
        boolean oneCombiHasNoClassFragments = false;
        Hashtable<String, FragmentRuleVO> chainRules = RulesContainer.getChainFragmentRules(this.ruleName_, this.rulesDir_);
        for (int[] ohs : this.possibleOhCombinations_) {
            String combiId = this.getOhCombiId(ohs);
            boolean containAllFaCombisClassFragments = false;
            Vector<Vector<Integer>> faCombis = this.allowedFaHydroxylationsCombinations_.get(combiId);
            if (faCombis.size() > 0) {
                containAllFaCombisClassFragments = true;
                for (Vector<Integer> combi : faCombis) {
                    boolean containsClassFragments = false;
                    block2: for (Integer oh : combi) {
                        for (FragmentRuleVO vo : chainRules.values()) {
                            if (vo.getChainType() != 0 && vo.getChainType() != 1 && vo.getChainType() != 2 || !vo.hydroxylationValid(oh.shortValue()) || vo.isMandatory(oh.shortValue()) != 4) continue;
                            containsClassFragments = true;
                            continue block2;
                        }
                    }
                    if (containsClassFragments) continue;
                    containAllFaCombisClassFragments = false;
                    break;
                }
            }
            boolean containAllLcbCombisClassFragments = false;
            Vector<Vector<Integer>> lcbCombis = this.allowedLcbHydroxylationsCombinations_.get(combiId);
            if (lcbCombis.size() > 0) {
                containAllLcbCombisClassFragments = true;
                for (Vector<Integer> combi : lcbCombis) {
                    boolean containsClassFragments = false;
                    block5: for (Integer oh : combi) {
                        for (FragmentRuleVO vo : chainRules.values()) {
                            if (vo.getChainType() != 3 || !vo.hydroxylationValid(oh.shortValue()) || vo.isMandatory(oh.shortValue()) != 4) continue;
                            containsClassFragments = true;
                            continue block5;
                        }
                    }
                    if (containsClassFragments) continue;
                    containAllLcbCombisClassFragments = false;
                    break;
                }
            }
            if (containAllFaCombisClassFragments || containAllLcbCombisClassFragments) {
                foundClassFragments = true;
                continue;
            }
            oneCombiHasNoClassFragments = true;
            break;
        }
        return foundClassFragments && !oneCombiHasNoClassFragments;
    }

    public boolean areAllClassFragmentsForChainFound(FattyAcidVO chain, Hashtable<String, CgProbe> foundFragments) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        boolean foundAll = true;
        Hashtable<String, FragmentRuleVO> chainRules = RulesContainer.getChainFragmentRules(this.ruleName_, this.rulesDir_);
        for (FragmentRuleVO fragVO : chainRules.values()) {
            if (fragVO.getChainType() != chain.getChainType() || !fragVO.hydroxylationValid((short)chain.getOhNumber()) || fragVO.isMandatory((short)chain.getOhNumber()) != 4 || foundFragments != null && foundFragments.containsKey(fragVO.getName())) continue;
            foundAll = false;
            break;
        }
        return foundAll;
    }

    public Hashtable<String, FragmentRuleVO> getCombiOhFragments() throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        Hashtable<String, FragmentRuleVO> combiOhs = new Hashtable<String, FragmentRuleVO>();
        Hashtable<String, FragmentRuleVO> allFrags = RulesContainer.getChainFragmentRules(this.ruleName_, this.rulesDir_);
        for (String name : allFrags.keySet()) {
            FragmentRuleVO rule = allFrags.get(name);
            if (!rule.hasCombiOhRequirements()) continue;
            combiOhs.put(name, rule);
        }
        return combiOhs;
    }

    public Set<List<String>> getOxCombinations(List<String> oxStates, int chains) {
        HashSet<List<String>> oxStateCombinations = new HashSet<List<String>>();
        int index = 0;
        for (String i : oxStates) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(i);
            oxStateCombinations.add(arrayList);
        }
        ++index;
        while (index < chains) {
            List<String> nextList = oxStates;
            HashSet newCombinations = new HashSet();
            for (List list : oxStateCombinations) {
                for (String second : nextList) {
                    ArrayList<String> newList = new ArrayList<String>();
                    newList.addAll(list);
                    newList.add(second);
                    newCombinations.add(newList);
                }
            }
            oxStateCombinations = newCombinations;
            ++index;
        }
        return oxStateCombinations;
    }

    public Set<List<String>> ValidateCombinations(Set<List<String>> combs) {
        HashSet<List<String>> validCombinations = new HashSet<List<String>>();
        for (List<String> combi : combs) {
            String combiString = "";
            for (String s : combi) {
                if (!combiString.equals("") && !s.equals("")) {
                    combiString = combiString + "," + s;
                    continue;
                }
                if (!combiString.equals("") || s.equals("")) continue;
                combiString = s;
            }
            combiString = combiString.replaceAll("\\s", "");
            ModificationParser mcp = new ModificationParser(combiString);
            mcp.parse();
            String combiFormula = mcp.getModificationComposition();
            mcp = new ModificationParser(this.analyteOxState_.replaceAll("\\s", ""));
            mcp.parse();
            String analyteOxFormula = mcp.getModificationComposition();
            if (!combiFormula.equals(analyteOxFormula)) continue;
            validCombinations.add(combi);
        }
        return validCombinations;
    }
}

