/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn;

import at.tugraz.genome.dbutilities.Base64;
import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.alex123.vos.TargetlistEntry;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.FragmentCalculator;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.MSnRelativeShareCalculator;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.msn.vos.FragmentRuleVO;
import at.tugraz.genome.lda.msn.vos.FragmentVO;
import at.tugraz.genome.lda.msn.vos.IntensityChainVO;
import at.tugraz.genome.lda.msn.vos.IntensityPositionVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.msn.vos.MSnDebugVO;
import at.tugraz.genome.lda.msn.vos.SharedMS1PeakVO;
import at.tugraz.genome.lda.msn.vos.SharedPeakContributionVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.LipidomicsAnalyzer;
import at.tugraz.genome.lda.quantification.LipidomicsChromatogram;
import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.utils.FloatFloatVO;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleStringVO;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.quantification.CgAreaStatus;
import at.tugraz.genome.maspectras.quantification.CgChromatogram;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.utils.Calculator;
import at.tugraz.genome.voutils.GeneralComparator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.math3.util.Pair;

public class MSnAnalyzer {
    private double relativeChainCutoff_ = 0.01;
    private String rulesDir_ = null;
    private String className_;
    private String modName_;
    private LipidParameterSet set_ = null;
    private LipidomicsAnalyzer analyzer_;
    private boolean debug_;
    private int status_;
    private FragmentCalculator fragCalc_;
    private MSnDebugVO debugVO_;
    private Hashtable<String, CgProbe> headGroupFragments_;
    private Hashtable<String, IntensityRuleVO> fulfilledHeadIntensityRules_;
    private Hashtable<String, Hashtable<String, CgProbe>> chainFragments_;
    private Hashtable<String, Hashtable<String, IntensityChainVO>> fulfilledChainIntensityRules_;
    private Vector<String> validChainCombinations_;
    private Hashtable<String, Double> relativeIntensityOfCombination_;
    private boolean ignoreAbsolute_;
    private Vector<CgProbe> shotgunProbes_;
    private Hashtable<String, Hashtable<Integer, Integer>> positionDefinition_;
    private Hashtable<String, Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>>> positionRecommendations_;
    private Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> posEvidenceAccordToProposedDefinition_;
    private Hashtable<Integer, Float> basePeakValues_;
    private Vector<Float> spectraFound_;
    private boolean msnSpectraPresent_;
    private Hashtable<Integer, Vector<CgProbe>> probesWithMSnSpectra_;
    Hashtable<Integer, Boolean> msLevels_;
    private float coverage_;

    public MSnAnalyzer(String className, String modName, LipidParameterSet set, LipidomicsAnalyzer analyzer, QuantVO quantVO, boolean readMSnSpectra, boolean ignoreAbsolute) throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        this(null, className, modName, set, analyzer, quantVO, ignoreAbsolute, readMSnSpectra, false);
    }

    public MSnAnalyzer(String rulesDir, String className, String modName, LipidParameterSet set, LipidomicsAnalyzer analyzer) throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        this(rulesDir, className, modName, set, analyzer, null, false, true, false);
    }

    public MSnAnalyzer(String rulesDir, String className, String modName, LipidParameterSet set, LipidomicsAnalyzer analyzer, QuantVO quantVO, boolean ignoreAbsolute, boolean readMSnSpectra, boolean debug) throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        this(className, modName, analyzer, debug, ignoreAbsolute);
        this.rulesDir_ = rulesDir;
        this.set_ = set;
        this.debug_ = debug;
        this.fragCalc_ = null;
        this.msLevels_ = MSnAnalyzer.prepareCachedSpectra(this.analyzer_, this.set_, readMSnSpectra);
        try {
            if (Settings.useAlex() && quantVO != null && quantVO instanceof TargetlistEntry && ((TargetlistEntry)quantVO).hasAlex123FragmentsForClass()) {
                try {
                    this.fragCalc_ = new FragmentCalculator(this.rulesDir_, this.className_, this.modName_, this.set_.getNameStringWithoutRt(), this.set_.getChemicalFormula(), this.set_.getChemicalFormulaWODeducts(), this.set_.Mz[0], this.set_.getCharge(), this.set_.getOhNumber(), quantVO.getOxState());
                }
                catch (NoRuleException noRuleException) {
                    // empty catch block
                }
                this.checkMSnByAlexFragments((TargetlistEntry)quantVO, this.msLevels_);
            } else {
                String oxState = "";
                oxState = quantVO != null ? quantVO.getOxState() : set.getOxState();
                this.fragCalc_ = new FragmentCalculator(this.rulesDir_, this.className_, this.modName_, this.set_.getNameStringWithoutRt(), this.set_.getChemicalFormula(), this.set_.getChemicalFormulaWODeducts(), this.set_.Mz[0], this.set_.getCharge(), this.set_.getOhNumber(), oxState);
                this.checkMSnEvidence(this.msLevels_);
            }
            this.transferResultsToLipidParameterSet();
        }
        catch (NoRuleException nrx) {
            return;
        }
    }

    private MSnAnalyzer(String className, String modName, LipidomicsAnalyzer analyzer, boolean debug, boolean ignoreAbsolute) throws RulesException, IOException, SpectrummillParserException, CgException {
        this.className_ = className;
        this.modName_ = modName;
        this.status_ = 0;
        this.relativeChainCutoff_ = LipidomicsConstants.getChainCutoffValue();
        this.analyzer_ = analyzer;
        this.ignoreAbsolute_ = ignoreAbsolute;
    }

    public MSnAnalyzer(String className, String modName, double precursorMz, double precursorTolerance, String name, int doubleBonds, int ohNumber, String analyteFormula, String modificationFormula, int charge, LipidomicsAnalyzer analyzer, boolean debug, boolean ignoreAbsolute) throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        this(className, modName, analyzer, debug, ignoreAbsolute);
        this.set_ = new LipidParameterSet((float)precursorMz, name, new Integer(doubleBonds), modName, 0.0, analyteFormula, modificationFormula, new Integer(charge), ohNumber);
        this.rulesDir_ = null;
        this.msnSpectraPresent_ = false;
        this.scanAllSpectraForCandidates(precursorMz, precursorTolerance);
    }

    private void scanAllSpectraForCandidates(double precursorMz, double precursorTolerance) throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        this.spectraFound_ = new Vector();
        Hashtable<Integer, Boolean> msLevels = this.analyzer_.prepareMSnSpectraCache((float)(precursorMz - precursorTolerance), (float)(precursorMz + precursorTolerance), LipidomicsConstants.getMs2MinIntsForNoiseRemoval());
        try {
            if (msLevels.size() < 1) {
                this.status_ = 0;
                return;
            }
            this.fragCalc_ = new FragmentCalculator(this.rulesDir_, this.className_, this.modName_, this.set_.getNameStringWithoutRt(), this.set_.getChemicalFormula(), this.set_.getChemicalFormulaWODeducts(), this.set_.Mz[0], this.set_.getCharge(), this.set_.getOhNumber(), this.set_.getOxState());
            Vector<Range> ranges = this.analyzer_.findSingleSpectraRanges(this.fragCalc_.getSpectrumLevelRange());
            if (ranges.size() > 0) {
                this.msnSpectraPresent_ = false;
            }
            for (Range range : ranges) {
                Vector<CgProbe> probes = new Vector<CgProbe>();
                CgProbe probe = new CgProbe(0, 1);
                probe.AreaStatus = CgAreaStatus.OK;
                probe.Area = 100.0f;
                probe.AreaError = 0.0f;
                probe.Background = 0.0f;
                probe.Peak = (range.getStart() + range.getStop()) / 2.0f;
                probe.LowerValley = range.getStart();
                probe.UpperValley = range.getStop();
                probe.Mz = this.set_.Mz[0];
                probe.LowerMzBand = LipidomicsConstants.getCoarseChromMzTolerance(this.set_.Mz[0]);
                probe.UpperMzBand = LipidomicsConstants.getCoarseChromMzTolerance(this.set_.Mz[0]);
                probe.isotopeNumber = 0;
                probes.add(probe);
                this.set_.setProbes(probes);
                this.status_ = 0;
                this.checkMSnEvidence(msLevels);
                if (this.status_ <= 1) continue;
                this.spectraFound_.add(Float.valueOf(probe.Peak));
            }
        }
        catch (NoRuleException nrx) {
            return;
        }
    }

    private void checkMSnEvidence(Hashtable<Integer, Boolean> msLevelsFromSpectralData) throws RulesException, IOException, SpectrummillParserException, CgException, NoRuleException, LipidCombinameEncodingException {
        this.probesWithMSnSpectra_ = this.performStandardInitialProcesses(msLevelsFromSpectralData);
        Hashtable<Integer, Boolean> msLevels = this.fragCalc_.correctMsLevelsForExistingFragments(msLevelsFromSpectralData, this.probesWithMSnSpectra_);
        if (this.probesWithMSnSpectra_ == null || this.probesWithMSnSpectra_.size() < 1 || msLevels.size() < 1) {
            this.status_ = 0;
            return;
        }
        if (this.fragCalc_.getChainCutoff() >= 0.0) {
            this.relativeChainCutoff_ = this.fragCalc_.getChainCutoff();
        }
        this.basePeakValues_ = this.calculateBasePeakValuesIfRequired(msLevels);
        this.checkHeadGroupFragments(this.probesWithMSnSpectra_);
        if (this.status_ == 1 && !this.debug_) {
            return;
        }
        if (this.fragCalc_.getAmountOfChains() > 0) {
            this.checkChainFragments(this.probesWithMSnSpectra_);
            if (this.debug_) {
                this.debugVO_.setSpectrumCoverageFulfilled(true);
            }
            this.checkSpectrumCoverage(msLevels);
            if (this.status_ != 3) {
                return;
            }
            if (this.fragCalc_.getAllowedChainPositions() > 1) {
                try {
                    this.checkPositions();
                }
                catch (LipidCombinameEncodingException e) {
                    throw new RulesException(e);
                }
            } else if (this.status_ != 1) {
                this.status_ = 4;
            }
        } else {
            this.checkSpectrumCoverage(msLevels);
        }
    }

    private Hashtable<Integer, Vector<CgProbe>> performStandardInitialProcesses(Hashtable<Integer, Boolean> msLevels) throws CgException {
        this.headGroupFragments_ = new Hashtable();
        this.fulfilledHeadIntensityRules_ = new Hashtable();
        this.chainFragments_ = new Hashtable();
        this.fulfilledChainIntensityRules_ = new Hashtable();
        this.validChainCombinations_ = new Vector();
        this.basePeakValues_ = new Hashtable();
        this.positionDefinition_ = new Hashtable();
        this.positionRecommendations_ = new Hashtable();
        this.posEvidenceAccordToProposedDefinition_ = new Hashtable();
        if (this.debug_) {
            this.debugVO_ = new MSnDebugVO();
        }
        if (msLevels.size() < 1) {
            this.status_ = 0;
            return null;
        }
        Hashtable<Integer, Vector<CgProbe>> probesWithMSnSpectra = new Hashtable<Integer, Vector<CgProbe>>();
        for (int msLevel : msLevels.keySet()) {
            Vector<CgProbe> probes = new Vector<CgProbe>();
            for (CgProbe probe : this.getCorrespondingCgProbes()) {
                if (this.analyzer_.areMSnSpectraInThisRegion(probe.LowerValley, probe.UpperValley, msLevel)) {
                    probes.add(probe);
                }
                if (probes.size() <= 0) continue;
                probesWithMSnSpectra.put(msLevel, probes);
            }
        }
        return probesWithMSnSpectra;
    }

    private void checkMSnByAlexFragments(TargetlistEntry quantVO, Hashtable<Integer, Boolean> msLevels) throws CgException, RulesException, NoRuleException, IOException, SpectrummillParserException, LipidCombinameEncodingException {
        if (quantVO.getMsnFragments() == null || quantVO.getMsnFragments().size() == 0) {
            this.status_ = 0;
            return;
        }
        this.probesWithMSnSpectra_ = this.performStandardInitialProcesses(msLevels);
        if (this.probesWithMSnSpectra_ == null || this.probesWithMSnSpectra_.size() < 1) {
            this.status_ = 0;
            return;
        }
        if (this.fragCalc_ != null) {
            this.basePeakValues_ = this.calculateBasePeakValuesIfRequired(msLevels);
        }
        Hashtable<String, String> verifiedMolecularSpecies = new Hashtable<String, String>();
        Hashtable<Integer, Hashtable<String, Hashtable<String, TargetlistEntry>>> allFragments = quantVO.getMsnFragments();
        boolean foundAnyFragments = false;
        boolean foundHeadFragments = false;
        boolean foundChainFragments = false;
        for (Integer n : allFragments.keySet()) {
            if (!msLevels.get(n).booleanValue()) continue;
            Hashtable<String, Hashtable<String, TargetlistEntry>> fragments = allFragments.get(n);
            for (String fragmentName : fragments.keySet()) {
                Hashtable<String, TargetlistEntry> molSpecies = fragments.get(fragmentName);
                TargetlistEntry oneFragment = molSpecies.values().iterator().next();
                CgProbe probe = this.analyzer_.calculateMs2Area(oneFragment.getAnalyteMass(), oneFragment.getFragmentFormula(), oneFragment.getMsLevel(), oneFragment.getCharge(), false, this.probesWithMSnSpectra_.get(oneFragment.getMsLevel()));
                if (probe.AreaStatus != CgAreaStatus.OK || this.fragCalc_ != null && !this.checkCutoffs(probe, oneFragment.getMsLevel(), 0.0f)) continue;
                foundAnyFragments = true;
                if (!(oneFragment.getStructure().startsWith("FA ") || oneFragment.getStructure().startsWith("LCB ") || oneFragment.getStructure().startsWith("O-"))) {
                    this.headGroupFragments_.put(fragmentName, probe);
                    foundHeadFragments = true;
                    continue;
                }
                String chainName = StaticUtils.decodeAlex123Chain(oneFragment.getStructure(), quantVO.getAnalyteName()).getChainId();
                Hashtable<String, Object> fragmentsOfChain = new Hashtable<String, Object>();
                if (this.chainFragments_.containsKey(chainName)) {
                    fragmentsOfChain = this.chainFragments_.get(chainName);
                }
                fragmentsOfChain.put(fragmentName, probe);
                this.chainFragments_.put(chainName, fragmentsOfChain);
                for (String molSpec : molSpecies.keySet()) {
                    foundChainFragments = true;
                    verifiedMolecularSpecies.put(molSpec, molSpec);
                }
            }
        }
        if (!foundAnyFragments) {
            this.status_ = 1;
        }
        if (foundHeadFragments && this.status_ != 1) {
            this.status_ = 2;
        }
        if (foundChainFragments && this.status_ != 1) {
            this.status_ = 3;
        }
        Hashtable<String, Vector<FattyAcidVO>> combis = new Hashtable<String, Vector<FattyAcidVO>>();
        for (String molSpecies : verifiedMolecularSpecies.keySet()) {
            combis.put(molSpecies, StaticUtils.decodeLipidNamesFromChainCombi(molSpecies));
        }
        Hashtable hashtable = new Hashtable();
        Hashtable<String, Double> areas = new Hashtable<String, Double>();
        for (String key : this.chainFragments_.keySet()) {
            double area = 0.0;
            for (CgProbe probe : this.chainFragments_.get(key).values()) {
                double oneArea = probe.Area;
                area += oneArea;
            }
            areas.put(key, area);
        }
        Hashtable<String, Double> combiAreas = new Hashtable<String, Double>();
        double highestIntensity = 0.0;
        for (String key : combis.keySet()) {
            double relative = 0.0;
            for (FattyAcidVO combiFA : (Vector)combis.get(key)) {
                if (!areas.containsKey(combiFA.getChainId())) continue;
                relative += ((Double)areas.get(combiFA.getChainId())).doubleValue();
            }
            if (relative > highestIntensity) {
                highestIntensity = relative;
            }
            combiAreas.put(key, relative);
        }
        double totalArea = 0.0;
        for (String key : new Vector(combiAreas.keySet())) {
            double intensity = (Double)combiAreas.get(key);
            if (intensity >= 0.0) {
                totalArea += intensity;
                continue;
            }
            if (this.debug_) {
                this.debugVO_.addViolatedCombinations(key, 4);
            }
            combiAreas.remove(key);
            combis.remove(key);
        }
        Hashtable<String, FattyAcidVO> hashtable2 = new Hashtable<String, FattyAcidVO>();
        for (String key : new Vector(combiAreas.keySet())) {
            for (FattyAcidVO combiFA : (Vector)combis.get(key)) {
                hashtable2.put(combiFA.getChainId(), combiFA);
            }
        }
        this.removeNotNecessaryFragments(hashtable2, false);
        this.removeNotNecessaryDiffIntensityRules(combiAreas.keySet());
        this.relativeIntensityOfCombination_ = new Hashtable();
        for (String combi : combiAreas.keySet()) {
            this.relativeIntensityOfCombination_.put(StaticUtils.encodeLipidCombi(StaticUtils.sortChainVOs(StaticUtils.decodeLipidNamesFromChainCombi(combi))), (Double)combiAreas.get(combi) / totalArea);
        }
        Vector<DoubleStringVO> toSort = new Vector<DoubleStringVO>();
        for (String key : new Vector<String>(this.relativeIntensityOfCombination_.keySet())) {
            toSort.add(new DoubleStringVO(key, this.relativeIntensityOfCombination_.get(key)));
        }
        Collections.sort(toSort, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
        for (int i = toSort.size() - 1; i != -1; --i) {
            this.validChainCombinations_.add(((DoubleStringVO)toSort.get(i)).getKey());
        }
    }

    private void checkHeadGroupFragments(Hashtable<Integer, Vector<CgProbe>> probesWithMSnSpectra) throws RulesException, IOException, SpectrummillParserException, CgException, NoRuleException, LipidCombinameEncodingException {
        CgProbe probe;
        Hashtable<Boolean, Vector<FragmentVO>> headFragments = this.fragCalc_.getHeadFragments(this.set_.getOhNumber());
        Vector<FragmentVO> mandatoryHeadFragments = headFragments.get(true);
        Vector<FragmentVO> addHeadFragments = headFragments.get(false);
        boolean foundHeadFragments = false;
        for (FragmentVO fragment : mandatoryHeadFragments) {
            if (!probesWithMSnSpectra.containsKey(fragment.getMsLevel())) continue;
            probe = this.analyzer_.calculateMs2Area(fragment.getMass(), fragment.getFormula(), fragment.getMsLevel(), fragment.getCharge(), fragment.isMandatory() == 2, probesWithMSnSpectra.get(fragment.getMsLevel()));
            if (probe.AreaStatus == CgAreaStatus.OK && this.checkCutoffs(probe, fragment.getMsLevel(), 0.0f)) {
                foundHeadFragments = true;
                this.headGroupFragments_.put(fragment.getName(), probe);
                continue;
            }
            this.status_ = 1;
            if (this.debug_) {
                this.debugVO_.addDiscardedHeadGroupFragment(fragment.getName(), this.findAreaDiscardReason(probe, fragment, 0.0f));
                continue;
            }
            return;
        }
        for (FragmentVO fragment : addHeadFragments) {
            if (!probesWithMSnSpectra.containsKey(fragment.getMsLevel())) continue;
            probe = this.analyzer_.calculateMs2Area(fragment.getMass(), fragment.getFormula(), fragment.getMsLevel(), fragment.getCharge(), fragment.isMandatory() == 2, probesWithMSnSpectra.get(fragment.getMsLevel()));
            if (probe.AreaStatus == CgAreaStatus.OK && this.checkCutoffs(probe, fragment.getMsLevel(), 0.0f)) {
                foundHeadFragments = true;
                this.headGroupFragments_.put(fragment.getName(), probe);
                continue;
            }
            if (!this.debug_) continue;
            this.debugVO_.addDiscardedHeadGroupFragment(fragment.getName(), this.findAreaDiscardReason(probe, fragment, 0.0f));
        }
        if (foundHeadFragments && this.status_ != 1) {
            this.status_ = 2;
        }
        Vector<IntensityRuleVO> intRules = this.fragCalc_.getHeadIntensityRules();
        for (IntensityRuleVO intRule : intRules) {
            if (!intRule.hydroxylationValid(this.set_.getOhNumber().shortValue()) || !intRule.isOrRule() && !intRule.enoughFragmentsForRuleEvaluationFound(this.headGroupFragments_)) continue;
            if (this.ignoreAbsolute_ && intRule.isAbsoluteComparison()) {
                if (!intRule.isRuleFulfilled(this.headGroupFragments_, this.getBasepeakIfRequired(intRule))) continue;
                this.fulfilledHeadIntensityRules_.put(intRule.getRuleIdentifier(), intRule);
                continue;
            }
            if (intRule.isRuleFulfilled(this.headGroupFragments_, this.getBasepeakIfRequired(intRule))) {
                this.fulfilledHeadIntensityRules_.put(intRule.getRuleIdentifier(), intRule);
                continue;
            }
            if (this.debug_) {
                this.debugVO_.addViolatedHeadRule(intRule);
            }
            if (!intRule.isMandatory(this.set_.getOhNumber().shortValue())) continue;
            this.status_ = 1;
            return;
        }
    }

    private Float getBasepeakIfRequired(IntensityRuleVO ruleVO) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        int msLevel;
        Float basePeak = null;
        if (ruleVO.containsBasePeak() && this.basePeakValues_.containsKey(msLevel = this.fragCalc_.getFragmentRuleByName(ruleVO.getAnyNonBasePeakName()).getMsLevel())) {
            basePeak = this.basePeakValues_.get(msLevel);
        }
        return basePeak;
    }

    private void checkChainFragments(Hashtable<Integer, Vector<CgProbe>> probesWithMSnSpectra) throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException, LipidCombinameEncodingException {
        Vector<FattyAcidVO> fas = this.fragCalc_.getPossibleChainObjects();
        Hashtable<Short, Vector<IntensityRuleVO>> intRules = this.fragCalc_.getChainIntensityRulesSameChain();
        HashSet<String> forbiddenChains = new HashSet<String>();
        Hashtable<String, Vector> absRulesToCheck = new Hashtable<String, Vector>();
        for (FattyAcidVO chain : fas) {
            CgProbe probe;
            Hashtable<Boolean, Vector<FragmentVO>> chainFragments = this.fragCalc_.getChainFragments(chain);
            Vector<FragmentVO> mandatoryChainFragments = chainFragments.get(true);
            Iterator<String> addChainFragments = chainFragments.get(false);
            boolean bl = false;
            boolean foundChainFragments = false;
            Hashtable<String, CgProbe> foundFragments = new Hashtable<String, CgProbe>();
            for (FragmentVO fragmentVO : mandatoryChainFragments) {
                if (fragmentVO.getFormula().indexOf("-") != -1) {
                    bl = true;
                    break;
                }
                if (!probesWithMSnSpectra.containsKey(fragmentVO.getMsLevel())) continue;
                probe = this.analyzer_.calculateMs2Area(fragmentVO.getMass(), fragmentVO.getFormula(), fragmentVO.getMsLevel(), fragmentVO.getCharge(), fragmentVO.isMandatory() == 2, probesWithMSnSpectra.get(fragmentVO.getMsLevel()));
                if (probe.AreaStatus == CgAreaStatus.OK && this.checkCutoffs(probe, fragmentVO.getMsLevel(), RulesContainer.getChainAbsoluteThreshold(StaticUtils.getRuleName(this.className_, this.modName_)))) {
                    foundChainFragments = true;
                    foundFragments.put(fragmentVO.getName(), probe);
                    continue;
                }
                if (this.debug_) {
                    this.debugVO_.addViolatedChainFragment(chain.getChainId(), fragmentVO.getName(), this.findAreaDiscardReason(probe, fragmentVO, RulesContainer.getChainAbsoluteThreshold(StaticUtils.getRuleName(this.className_, this.modName_))));
                }
                bl = true;
                break;
            }
            if (bl) continue;
            Iterator iterator = ((Vector)((Object)addChainFragments)).iterator();
            while (iterator.hasNext()) {
                FragmentVO fragmentVO = (FragmentVO)iterator.next();
                if (fragmentVO.getFormula().indexOf("-") != -1 || !probesWithMSnSpectra.containsKey(fragmentVO.getMsLevel())) continue;
                probe = this.analyzer_.calculateMs2Area(fragmentVO.getMass(), fragmentVO.getFormula(), fragmentVO.getMsLevel(), fragmentVO.getCharge(), fragmentVO.isMandatory() == 2, probesWithMSnSpectra.get(fragmentVO.getMsLevel()));
                if (probe.AreaStatus == CgAreaStatus.OK && this.checkCutoffs(probe, fragmentVO.getMsLevel(), RulesContainer.getChainAbsoluteThreshold(StaticUtils.getRuleName(this.className_, this.modName_)))) {
                    foundChainFragments = true;
                    foundFragments.put(fragmentVO.getName(), probe);
                    continue;
                }
                if (!this.debug_) continue;
                this.debugVO_.addViolatedChainFragment(chain.getChainId(), fragmentVO.getName(), this.findAreaDiscardReason(probe, fragmentVO, RulesContainer.getChainAbsoluteThreshold(StaticUtils.getRuleName(this.className_, this.modName_))));
            }
            if (!foundChainFragments) continue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            if (intRules.containsKey(chain.getChainType())) {
                for (IntensityRuleVO intRule : intRules.get(chain.getChainType())) {
                    if (!intRule.hydroxylationValid((short)chain.getOhNumber())) continue;
                    Hashtable<String, CgProbe> hashtable2 = new Hashtable<String, CgProbe>(foundFragments);
                    hashtable2.putAll(this.headGroupFragments_);
                    if (!intRule.isOrRule() && !intRule.enoughFragmentsForRuleEvaluationFound(hashtable2)) continue;
                    if (intRule.isAbsoluteComparison()) {
                        Vector absRules = new Vector();
                        if (absRulesToCheck.containsKey(chain.getChainId())) {
                            absRules = (Vector)absRulesToCheck.get(chain.getChainId());
                        }
                        absRules.add(intRule);
                        absRulesToCheck.put(chain.getChainId(), absRules);
                        continue;
                    }
                    if (intRule.isRuleFulfilled(hashtable2, this.getBasepeakIfRequired(intRule))) {
                        IntensityChainVO intChainVO = new IntensityChainVO(intRule, chain, this.set_.getOhNumber() > 0);
                        hashtable.put(intChainVO.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding()), intChainVO);
                        continue;
                    }
                    if (this.debug_) {
                        this.debugVO_.addViolatedChainRule(chain.getChainId(), intRule);
                    }
                    if (!intRule.isMandatory((short)chain.getOhNumber())) continue;
                    bl = true;
                    if (!intRule.isOrRule()) break;
                    forbiddenChains.add(chain.getChainId());
                    break;
                }
            }
            if (bl || !this.fragCalc_.areAllClassFragmentsForChainFound(chain, foundFragments)) {
                absRulesToCheck.remove(chain.getChainId());
                continue;
            }
            this.chainFragments_.put(chain.getChainId(), foundFragments);
            if (hashtable.size() <= 0) continue;
            this.fulfilledChainIntensityRules_.put(chain.getChainId(), hashtable);
        }
        if (this.chainFragments_.size() == 0) {
            if (this.fragCalc_.containAllOhCombinationsClassSpecificFragments()) {
                this.status_ = 1;
            }
            return;
        }
        Hashtable<String, Vector<FattyAcidVO>> combis = this.fragCalc_.getChainFragmentCombinationsWithDetectedEvidence(this.chainFragments_.keySet(), this.chainFragments_, forbiddenChains);
        Vector<IntensityRuleVO> diffRules = this.fragCalc_.getChainIntensityRulesDiffChain();
        Hashtable<String, Vector> absCombiRulesToCheck = new Hashtable<String, Vector>();
        if (combis.size() > 0 && combis.values().iterator().next().size() > 1 && diffRules.size() > 0) {
            Hashtable<String, Vector<FattyAcidVO>> intRulesFulFilled = new Hashtable<String, Vector<FattyAcidVO>>();
            for (String string : combis.keySet()) {
                Vector<FattyAcidVO> combi = combis.get(string);
                if (combi.size() < 2) continue;
                boolean discardCombi = false;
                Hashtable<String, IntensityChainVO> hashtable = new Hashtable<String, IntensityChainVO>();
                block5: for (IntensityRuleVO intRule : diffRules) {
                    Vector<Vector<FattyAcidVO>> vector = StaticUtils.getAllPotentialChainCombinationForThisRule(intRule, combi);
                    for (Vector<FattyAcidVO> chainsToCheck : vector) {
                        if (!intRule.hydroxylationValid(chainsToCheck) || !intRule.isOrRule() && !intRule.enoughFragmentsForRuleEvaluationFound(this.headGroupFragments_, this.chainFragments_, chainsToCheck)) continue;
                        if (intRule.isAbsoluteComparison()) {
                            Vector absRules = new Vector();
                            if (absCombiRulesToCheck.containsKey(string)) {
                                absRules = (Vector)absCombiRulesToCheck.get(string);
                            }
                            absRules.add(intRule);
                            absCombiRulesToCheck.put(string, absRules);
                            continue;
                        }
                        if (intRule.isRuleFulfilled(this.headGroupFragments_, this.chainFragments_, chainsToCheck, this.getBasepeakIfRequired(intRule))) {
                            IntensityChainVO intChainVO = new IntensityChainVO(intRule, chainsToCheck, this.set_.getOhNumber() > 0);
                            hashtable.put(intChainVO.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding()), intChainVO);
                            continue;
                        }
                        if (this.debug_) {
                            this.debugVO_.addViolatedChainRule(string, intRule);
                        }
                        if (!intRule.isMandatory(chainsToCheck)) continue;
                        discardCombi = true;
                        continue block5;
                    }
                }
                if (discardCombi) continue;
                if (hashtable.size() > 0) {
                    this.fulfilledChainIntensityRules_.put(string, hashtable);
                }
                intRulesFulFilled.put(string, combi);
            }
            combis = intRulesFulFilled;
        }
        Vector<IntensityRuleVO> orRules = new Vector<IntensityRuleVO>();
        for (Vector vector : intRules.values()) {
            for (IntensityRuleVO intRule : vector) {
                if (!intRule.isOrRule()) continue;
                orRules.add(intRule);
            }
        }
        Hashtable<String, FragmentRuleVO> combiOhRequirements = this.fragCalc_.getCombiOhFragments();
        if (orRules.size() > 0 || combiOhRequirements.size() > 0) {
            Vector<String> vector = new Vector<String>();
            for (String combiKey : combis.keySet()) {
                Vector<FattyAcidVO> vector2 = StaticUtils.decodeLipidNamesFromChainCombi(combiKey);
                boolean bl = false;
                for (IntensityRuleVO intensityRuleVO : orRules) {
                    if (!intensityRuleVO.hydroxylationValid(vector2) || intensityRuleVO.isRuleFulfilled(this.headGroupFragments_, this.chainFragments_, vector2, this.getBasepeakIfRequired(intensityRuleVO))) continue;
                    vector.add(combiKey);
                    bl = true;
                    break;
                }
                if (bl) continue;
                int mand = -1;
                block11: for (FragmentRuleVO ruleVO : combiOhRequirements.values()) {
                    if (bl) continue;
                    Vector<FattyAcidVO> chains = new Vector<FattyAcidVO>();
                    for (FattyAcidVO fattyAcidVO : vector2) {
                        if (ruleVO.getChainType() != fattyAcidVO.getChainType() || !ruleVO.hydroxylationValid((short)fattyAcidVO.getOhNumber())) continue;
                        chains.add(fattyAcidVO);
                    }
                    if (chains.size() == 0) continue;
                    boolean isMandatory = false;
                    for (FattyAcidVO chain : vector2) {
                        mand = ruleVO.isMandatoryInCombi(chain.getChainType(), (short)chain.getOhNumber());
                        if (mand != 1 && mand != 4) continue;
                        isMandatory = true;
                        break;
                    }
                    if (!isMandatory) continue;
                    for (FattyAcidVO chain : chains) {
                        if (this.chainFragments_.containsKey(chain.getChainId()) && this.chainFragments_.get(chain.getChainId()).containsKey(ruleVO.getName())) continue;
                        vector.add(combiKey);
                        bl = true;
                        continue block11;
                    }
                }
            }
            if (vector.size() > 0) {
                for (String combiKey : vector) {
                    combis.remove(combiKey);
                }
                Hashtable<String, FattyAcidVO> allowedFAs = new Hashtable<String, FattyAcidVO>();
                for (String string : combis.keySet()) {
                    for (FattyAcidVO chain : StaticUtils.decodeLipidNamesFromChainCombi(string)) {
                        allowedFAs.put(chain.getChainId(), chain);
                    }
                }
                this.removeNotNecessaryFragments(allowedFAs, true);
            }
        }
        Hashtable<String, FattyAcidVO> hashtable = new Hashtable<String, FattyAcidVO>();
        for (Vector<FattyAcidVO> combiFAs : combis.values()) {
            for (FattyAcidVO fattyAcidVO : combiFAs) {
                hashtable.put(fattyAcidVO.getChainId(), fattyAcidVO);
            }
        }
        this.removeNotNecessaryFragments(hashtable, true);
        this.removeNotNecessaryDiffIntensityRules(combis.keySet());
        if (combis.size() == 0) {
            if (this.fragCalc_.containAllOhCombinationsClassSpecificFragments()) {
                this.status_ = 1;
            }
            return;
        }
        if (this.relativeIntensitySplitNecessary(combis)) {
            MSnRelativeShareCalculator relativeShares = new MSnRelativeShareCalculator(combis, this.chainFragments_, this.relativeChainCutoff_, this.debug_, this.debugVO_);
            relativeShares.splitIntensities();
            Hashtable<String, FattyAcidVO> hashtable3 = relativeShares.getAllowedFAs();
            this.relativeIntensityOfCombination_ = relativeShares.getRelativeIntensities();
            this.removeNotNecessaryFragments(hashtable3, false);
            this.removeNotNecessaryDiffIntensityRules(this.relativeIntensityOfCombination_.keySet());
        } else {
            boolean bl;
            Hashtable<String, Double> areas = new Hashtable<String, Double>();
            for (String string : this.chainFragments_.keySet()) {
                double d = 0.0;
                for (CgProbe probe : this.chainFragments_.get(string).values()) {
                    double oneArea = probe.Area;
                    d += oneArea;
                }
                areas.put(string, d);
            }
            Hashtable<String, Double> combiAreas = new Hashtable<String, Double>();
            double d = 0.0;
            for (String string : combis.keySet()) {
                double relative = 0.0;
                for (FattyAcidVO fattyAcidVO : combis.get(string)) {
                    if (!areas.containsKey(fattyAcidVO.getChainId())) continue;
                    relative += ((Double)areas.get(fattyAcidVO.getChainId())).doubleValue();
                }
                if (relative > d) {
                    d = relative;
                }
                combiAreas.put(string, relative);
            }
            String strongestCombi = this.getStrongestCombination(combiAreas);
            boolean bl2 = false;
            if (strongestCombi != null) {
                Vector<String> chainsOfStrongestCombi = StaticUtils.splitChainCombiToEncodedStrings(strongestCombi, "<->");
                Vector<FattyAcidVO> chainsToCheck = new Vector<FattyAcidVO>();
                for (String string : chainsOfStrongestCombi) {
                    FattyAcidVO chainVO = StaticUtils.decodeLipidNameForCreatingCombis(string);
                    chainsToCheck.add(chainVO);
                    if (!absRulesToCheck.containsKey(string)) continue;
                    Vector absRules = (Vector)absRulesToCheck.get(string);
                    Hashtable<Object, Object> fulfilledChainIntensityRules = new Hashtable();
                    if (this.fulfilledChainIntensityRules_.containsKey(string)) {
                        fulfilledChainIntensityRules = this.fulfilledChainIntensityRules_.get(string);
                    }
                    Hashtable<String, CgProbe> allFragments = new Hashtable<String, CgProbe>((Map)this.chainFragments_.get(string));
                    allFragments.putAll(this.headGroupFragments_);
                    for (IntensityRuleVO intRule : absRules) {
                        IntensityChainVO intChainVO;
                        if (this.ignoreAbsolute_) {
                            if (!intRule.isRuleFulfilled(this.headGroupFragments_, this.getBasepeakIfRequired(intRule))) continue;
                            intChainVO = new IntensityChainVO(intRule, chainVO, this.set_.getOhNumber() > 0);
                            fulfilledChainIntensityRules.put(intChainVO.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding()), intChainVO);
                            continue;
                        }
                        if (intRule.isRuleFulfilled(allFragments, this.getBasepeakIfRequired(intRule))) {
                            intChainVO = new IntensityChainVO(intRule, chainVO, this.set_.getOhNumber() > 0);
                            fulfilledChainIntensityRules.put(intChainVO.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding()), intChainVO);
                            continue;
                        }
                        if (this.debug_) {
                            this.debugVO_.addViolatedChainRule(string, intRule);
                        }
                        if (!intRule.isMandatory((short)chainVO.getOhNumber())) continue;
                        boolean bl3 = true;
                        if (!intRule.isOrRule()) break;
                        forbiddenChains.add(string);
                        break;
                    }
                    fulfilledChainIntensityRules = this.fulfilledChainIntensityRules_.put(string, fulfilledChainIntensityRules);
                }
                if (absCombiRulesToCheck.containsKey(strongestCombi)) {
                    Hashtable<Object, Object> fulfilledChaindIntensityRules = new Hashtable();
                    if (this.fulfilledChainIntensityRules_.containsKey(strongestCombi)) {
                        fulfilledChaindIntensityRules = this.fulfilledChainIntensityRules_.get(strongestCombi);
                    }
                    for (IntensityRuleVO intRule : (Vector)absCombiRulesToCheck.get(strongestCombi)) {
                        IntensityChainVO intChainVO;
                        if (this.ignoreAbsolute_) {
                            if (!intRule.isRuleFulfilled(this.headGroupFragments_, this.chainFragments_, chainsToCheck, this.getBasepeakIfRequired(intRule))) continue;
                            intChainVO = new IntensityChainVO(intRule, chainsToCheck, this.set_.getOhNumber() > 0);
                            fulfilledChaindIntensityRules.put(intChainVO.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding()), intChainVO);
                            continue;
                        }
                        if (intRule.isRuleFulfilled(this.headGroupFragments_, this.chainFragments_, chainsToCheck, this.getBasepeakIfRequired(intRule))) {
                            intChainVO = new IntensityChainVO(intRule, chainsToCheck, this.set_.getOhNumber() > 0);
                            fulfilledChaindIntensityRules.put(intChainVO.getReadableRuleInterpretation(Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding()), intChainVO);
                            continue;
                        }
                        if (this.debug_) {
                            this.debugVO_.addViolatedChainRule(strongestCombi, intRule);
                        }
                        if (!intRule.isMandatory(chainsToCheck)) continue;
                        bl = true;
                        break;
                    }
                    this.fulfilledChainIntensityRules_.put(strongestCombi, fulfilledChaindIntensityRules);
                }
            }
            if (bl) {
                this.removeNotNecessaryFragments(new Hashtable<String, FattyAcidVO>(), false);
                if (this.fragCalc_.containAllOhCombinationsClassSpecificFragments()) {
                    this.status_ = 1;
                }
                return;
            }
            double totalArea = 0.0;
            for (String string : new Vector<String>(combiAreas.keySet())) {
                double intensity = combiAreas.get(string);
                if (intensity >= this.relativeChainCutoff_ * d) {
                    totalArea += intensity;
                    continue;
                }
                if (this.debug_) {
                    this.debugVO_.addViolatedCombinations(string, 4);
                }
                combiAreas.remove(string);
                combis.remove(string);
                this.fulfilledChainIntensityRules_.remove(string);
            }
            Hashtable<String, FattyAcidVO> hashtable4 = new Hashtable<String, FattyAcidVO>();
            for (String string : new Vector<String>(combiAreas.keySet())) {
                for (FattyAcidVO combiFA : combis.get(string)) {
                    hashtable4.put(combiFA.getChainId(), combiFA);
                }
            }
            this.removeNotNecessaryFragments(hashtable4, false);
            this.removeNotNecessaryDiffIntensityRules(combiAreas.keySet());
            this.relativeIntensityOfCombination_ = new Hashtable();
            for (String string : combiAreas.keySet()) {
                this.relativeIntensityOfCombination_.put(StaticUtils.encodeLipidCombi(StaticUtils.sortChainVOs(StaticUtils.decodeLipidNamesFromChainCombi(string))), combiAreas.get(string) / totalArea);
            }
        }
        Vector<DoubleStringVO> toSort = new Vector<DoubleStringVO>();
        for (String string : new Vector<String>(this.relativeIntensityOfCombination_.keySet())) {
            toSort.add(new DoubleStringVO(string, this.relativeIntensityOfCombination_.get(string)));
        }
        Collections.sort(toSort, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
        for (int i = toSort.size() - 1; i != -1; --i) {
            this.validChainCombinations_.add(((DoubleStringVO)toSort.get(i)).getKey());
        }
        if (this.status_ != 1) {
            this.status_ = 3;
        }
    }

    private void removeNotNecessaryFragments(Hashtable<String, FattyAcidVO> allowedFAs, boolean addToDiscard) {
        Vector<String> chains = new Vector<String>(this.chainFragments_.keySet());
        for (String chain : chains) {
            if (allowedFAs.containsKey(chain)) continue;
            if (this.debug_ && addToDiscard) {
                this.debugVO_.addViolatedChainFragment(chain, "COMBINATION", 3);
            }
            this.chainFragments_.remove(chain);
            this.fulfilledChainIntensityRules_.remove(chain);
        }
    }

    private void removeNotNecessaryDiffIntensityRules(Set<String> allowedCombis) {
        Hashtable<String, String> allowed = new Hashtable<String, String>();
        for (String combi : allowedCombis) {
            allowed.put(combi, combi);
        }
        Vector<String> combisToRemove = new Vector<String>();
        for (String key : this.fulfilledChainIntensityRules_.keySet()) {
            if (key.indexOf("<->") == -1 || allowed.containsKey(key)) continue;
            combisToRemove.add(key);
        }
        for (String combi : combisToRemove) {
            this.fulfilledChainIntensityRules_.remove(combi);
        }
    }

    public int checkStatus() {
        return this.status_;
    }

    public Hashtable<String, CgProbe> getHeadGroupFragments() {
        return this.headGroupFragments_;
    }

    public Hashtable<String, IntensityRuleVO> getFulfilledHeadIntensityRules() {
        return this.fulfilledHeadIntensityRules_;
    }

    public Hashtable<String, Hashtable<String, CgProbe>> getChainFragments() {
        return this.chainFragments_;
    }

    public Hashtable<String, Hashtable<String, IntensityChainVO>> getFulfilledChainIntensityRules() {
        return this.fulfilledChainIntensityRules_;
    }

    public Hashtable<String, Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>>> getPositionRecommendations() {
        return this.positionRecommendations_;
    }

    private Hashtable<Integer, Float> calculateBasePeakValuesIfRequired(Hashtable<Integer, Boolean> msLevels) throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException {
        Hashtable<Integer, Float> basePeakValues = new Hashtable<Integer, Float>();
        Vector<Integer> levels = this.fragCalc_.getBasePeakIntRuleLevels(msLevels);
        if (levels.size() > 0) {
            basePeakValues = this.analyzer_.extractBasePeakValues(levels, this.getCorrespondingCgProbes());
        }
        return basePeakValues;
    }

    private boolean checkCutoffs(CgProbe probe, int msLevel, float absThreshold) throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException {
        double cutoff = this.fragCalc_.getBasePeakCutoff();
        if (cutoff > 0.0) {
            return probe.Area > this.basePeakValues_.get(msLevel).floatValue() * (float)cutoff && probe.Area > absThreshold;
        }
        return true;
    }

    private void checkPositions() throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException, LipidCombinameEncodingException {
        Vector<IntensityRuleVO> intRules = this.fragCalc_.getPositionIntensityRules();
        Hashtable<String, Hashtable<Boolean, Vector<IntensityRuleVO>>> positionSpecificRules = new Hashtable<String, Hashtable<Boolean, Vector<IntensityRuleVO>>>();
        Hashtable<String, Hashtable<Boolean, Vector<IntensityRuleVO>>> positionSpecificSingleRules = new Hashtable<String, Hashtable<Boolean, Vector<IntensityRuleVO>>>();
        for (IntensityRuleVO rule : intRules) {
            ArrayList<Integer> affectedPositions = new ArrayList<Integer>();
            affectedPositions.add(rule.getBiggerPosition());
            if (rule.getBiggerPosition() != rule.getSmallerPosition()) {
                affectedPositions.add(rule.getSmallerPosition());
            }
            String identifier = this.getIdentifierForPositions(affectedPositions);
            if (rule.getBiggerPosition() == rule.getSmallerPosition() || rule.getBiggerPosition() == 0 || rule.getSmallerPosition() == 0) {
                this.addToPositionSpecificRuleHash(positionSpecificSingleRules, identifier, rule);
                continue;
            }
            this.addToPositionSpecificRuleHash(positionSpecificRules, identifier, rule);
        }
        boolean foundOnePosition = false;
        for (String combiKey : this.validChainCombinations_) {
            Vector<FattyAcidVO> chains = StaticUtils.decodeLipidNamesFromChainCombi(combiKey);
            Hashtable<String, Integer> chainOccurenceInCombi = new Hashtable<String, Integer>();
            for (FattyAcidVO fa : chains) {
                int count = 0;
                if (chainOccurenceInCombi.containsKey(fa.getChainId())) {
                    count = chainOccurenceInCombi.get(fa.getChainId());
                }
                chainOccurenceInCombi.put(fa.getChainId(), ++count);
            }
            if (chainOccurenceInCombi.size() == 1 && this.fragCalc_.getAllowedChainPositions() == this.fragCalc_.getAmountOfChains()) {
                foundOnePosition = true;
                Hashtable<Integer, Integer> definitions = new Hashtable<Integer, Integer>();
                for (int i = 0; i != chains.size(); ++i) {
                    definitions.put(i, i);
                }
                this.positionDefinition_.put(combiKey, definitions);
                this.posEvidenceAccordToProposedDefinition_.put(combiKey, new Hashtable());
                continue;
            }
            int[] positions = this.detectPostions(combiKey, chainOccurenceInCombi, positionSpecificRules, positionSpecificSingleRules);
            if (positions == null) continue;
            boolean foundAtLeastOnePosition = false;
            for (int position : positions) {
                if (position <= -1) continue;
                foundAtLeastOnePosition = true;
            }
            if (!foundAtLeastOnePosition) continue;
            foundOnePosition = true;
            Hashtable<Integer, Integer> definitions = new Hashtable<Integer, Integer>();
            for (int i = 0; i != chains.size(); ++i) {
                if (positions[i] <= -1) continue;
                definitions.put(i, positions[i] - 1);
            }
            this.positionDefinition_.put(combiKey, definitions);
        }
        if (foundOnePosition && this.status_ != 1) {
            this.status_ = 4;
        }
    }

    private String getIdentifierForPositions(List<Integer> positions) {
        Collections.sort(positions);
        String id = "";
        for (Integer position : positions) {
            id = id + position.toString() + ",";
        }
        if (id.length() > 0) {
            id = id.substring(0, id.length() - 1);
        }
        return id;
    }

    /*
     * WARNING - void declaration
     */
    private int[] detectPostions(String combiName, Hashtable<String, Integer> chainOccurenceInCombi, Hashtable<String, Hashtable<Boolean, Vector<IntensityRuleVO>>> positionSpecificRules, Hashtable<String, Hashtable<Boolean, Vector<IntensityRuleVO>>> positionSpecificSingleRules) throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException, LipidCombinameEncodingException {
        int i;
        int[] positions = null;
        ArrayList<String> faList = new ArrayList<String>(chainOccurenceInCombi.keySet());
        Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> positionRecommendations = new Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>>();
        Hashtable<String, Hashtable<Integer, IntensityPositionVO>> impossiblePositions = new Hashtable<String, Hashtable<Integer, IntensityPositionVO>>();
        for (i = 0; i != faList.size(); ++i) {
            FattyAcidVO chain = StaticUtils.decodeLipidNameForCreatingCombis((String)faList.get(i));
            Integer occurrence = chainOccurenceInCombi.get(chain.getChainId());
            Hashtable<String, CgProbe> fragments = this.chainFragments_.get(chain.getChainId());
            for (String position : positionSpecificSingleRules.keySet()) {
                Hashtable<Boolean, Vector<IntensityRuleVO>> mandAndAddRules = positionSpecificSingleRules.get(position);
                Vector<IntensityRuleVO> mandRules = mandAndAddRules.get(true);
                Vector<IntensityRuleVO> addRules = mandAndAddRules.get(false);
                int proposedPosition = -1;
                Vector<IntensityPositionVO> fulfilledRules = new Vector<IntensityPositionVO>();
                int notEnoughFragmentsForEvaluation = 0;
                for (IntensityRuleVO rule : mandRules) {
                    if (rule.enoughFragmentsForRuleEvaluationFound(fragments)) {
                        int[] poss = this.getPositionRecommendation(chain.getChainId(), occurrence, fragments, chain.getChainId(), occurrence, fragments, rule);
                        if (poss == null || proposedPosition > -1 && poss[0] != proposedPosition) {
                            if (this.debug_) {
                                this.debugVO_.addUnfulfilledPositionRule(combiName, rule);
                            }
                            proposedPosition = -1;
                            fulfilledRules = new Vector();
                            Hashtable<Integer, IntensityPositionVO> imp = new Hashtable();
                            if (impossiblePositions.containsKey(chain.getChainId())) {
                                imp = impossiblePositions.get(chain.getChainId());
                            }
                            imp.put(rule.getBiggerPosition(), this.createIntensityPositionVO(rule, new int[]{rule.getBiggerPosition(), rule.getBiggerPosition()}, chain, chain));
                            impossiblePositions.put(chain.getChainId(), imp);
                            break;
                        }
                        proposedPosition = poss[0];
                        fulfilledRules.add(this.createIntensityPositionVO(rule, poss, chain, chain));
                        continue;
                    }
                    ++notEnoughFragmentsForEvaluation;
                }
                if (mandRules.size() > 0 && notEnoughFragmentsForEvaluation < mandRules.size() && proposedPosition == -1) continue;
                int fulfilled = 0;
                int contradicting = 0;
                Vector<IntensityPositionVO> addFulfilled = new Vector<IntensityPositionVO>();
                for (IntensityRuleVO rule : addRules) {
                    if (!rule.enoughFragmentsForRuleEvaluationFound(fragments)) continue;
                    int[] poss = this.getPositionRecommendation(chain.getChainId(), occurrence, fragments, chain.getChainId(), occurrence, fragments, rule);
                    if (poss != null) {
                        if (mandRules.size() > 0 && notEnoughFragmentsForEvaluation < mandRules.size()) {
                            if (proposedPosition == poss[0]) {
                                fulfilledRules.add(this.createIntensityPositionVO(rule, poss, chain, chain));
                                continue;
                            }
                            if (!this.debug_) continue;
                            this.debugVO_.addContradictingPositionRules(combiName, (IntensityRuleVO)fulfilledRules.lastElement(), this.createIntensityPositionVO(rule, poss, chain, chain));
                            continue;
                        }
                        addFulfilled.add(this.createIntensityPositionVO(rule, poss, chain, chain));
                        ++fulfilled;
                        continue;
                    }
                    ++contradicting;
                    if (!this.debug_) continue;
                    this.debugVO_.addUnfulfilledPositionRule(combiName, new IntensityPositionVO(rule, chain, chain, this.set_.getOhNumber() > 0, false, false));
                }
                if ((mandRules.size() == 0 || mandRules.size() == notEnoughFragmentsForEvaluation) && fulfilled > contradicting) {
                    proposedPosition = new Integer(position);
                    fulfilledRules.addAll(addFulfilled);
                }
                if (proposedPosition <= -1) continue;
                Hashtable<Object, Object> positionRuleEvidence = new Hashtable();
                if (positionRecommendations.containsKey(chain.getChainId())) {
                    positionRuleEvidence = positionRecommendations.get(chain.getChainId());
                }
                Vector rules = new Vector();
                if (positionRuleEvidence.containsKey(proposedPosition)) {
                    rules = (Vector)positionRuleEvidence.get(proposedPosition);
                }
                rules.addAll(fulfilledRules);
                positionRuleEvidence.put(proposedPosition, rules);
                positionRecommendations.put(chain.getChainId(), positionRuleEvidence);
            }
        }
        for (i = 0; i != faList.size(); ++i) {
            FattyAcidVO firstFA = StaticUtils.decodeLipidNameForCreatingCombis((String)faList.get(i));
            Integer firstOccurrence = chainOccurenceInCombi.get(firstFA.getChainId());
            Hashtable<String, CgProbe> firstFragments = this.chainFragments_.get(firstFA.getChainId());
            for (int j = i + 1; j != faList.size(); ++j) {
                FattyAcidVO secondFA = StaticUtils.decodeLipidNameForCreatingCombis((String)faList.get(j));
                Integer secondOccurrence = chainOccurenceInCombi.get(secondFA.getChainId());
                Hashtable<String, CgProbe> secondFragments = this.chainFragments_.get(secondFA.getChainId());
                Hashtable<String, CgProbe> combinedFragments = new Hashtable<String, CgProbe>();
                if (firstFragments != null) {
                    combinedFragments.putAll(firstFragments);
                }
                if (secondFragments != null) {
                    combinedFragments.putAll(secondFragments);
                }
                for (String positionId : positionSpecificRules.keySet()) {
                    void var28_49;
                    void var28_46;
                    Hashtable<Boolean, Vector<IntensityRuleVO>> mandAndAddRules = positionSpecificRules.get(positionId);
                    Vector<IntensityRuleVO> mandRules = mandAndAddRules.get(true);
                    Vector<IntensityRuleVO> addRules = mandAndAddRules.get(false);
                    int[] proposedPositions = null;
                    Vector<IntensityPositionVO> fulfilledRules = new Vector<IntensityPositionVO>();
                    int notEnoughFragmentsForEvaluation = 0;
                    Vector<Object> inversibleRules = new Vector<Object>();
                    for (IntensityRuleVO intensityRuleVO : mandRules) {
                        if (firstFA.getChainType() != secondFA.getChainType() && intensityRuleVO.enoughFragmentsForRuleEvaluationFound(combinedFragments) || firstFA.getChainType() == secondFA.getChainType() && intensityRuleVO.enoughFragmentsForRuleEvaluationFound(firstFragments) && intensityRuleVO.enoughFragmentsForRuleEvaluationFound(secondFragments)) {
                            int[] poss = this.getPositionRecommendation(firstFA.getChainId(), firstOccurrence, firstFragments, secondFA.getChainId(), secondOccurrence, secondFragments, intensityRuleVO);
                            int[] poss2 = this.getPositionRecommendation(secondFA.getChainId(), secondOccurrence, secondFragments, firstFA.getChainId(), firstOccurrence, firstFragments, intensityRuleVO);
                            boolean isMandRuleOK = true;
                            if (poss != null) {
                                if (poss[0] == poss2[0] && poss[1] == poss2[1]) {
                                    boolean firstOK = true;
                                    if (impossiblePositions.containsKey(firstFA.getChainId()) && impossiblePositions.get(firstFA.getChainId()).containsKey(poss[0]) || impossiblePositions.containsKey(secondFA.getChainId()) && impossiblePositions.get(secondFA.getChainId()).containsKey(poss[1])) {
                                        firstOK = false;
                                    }
                                    boolean secondOK = true;
                                    if (impossiblePositions.containsKey(firstFA.getChainId()) && impossiblePositions.get(firstFA.getChainId()).containsKey(poss[1]) || impossiblePositions.containsKey(secondFA.getChainId()) && impossiblePositions.get(secondFA.getChainId()).containsKey(poss[0])) {
                                        secondOK = false;
                                    }
                                    if (firstOK && secondOK) {
                                        inversibleRules.add(intensityRuleVO);
                                        continue;
                                    }
                                    if (!firstOK) {
                                        if (secondOK) {
                                            poss = poss2;
                                        } else {
                                            isMandRuleOK = false;
                                        }
                                    }
                                }
                                if (impossiblePositions.containsKey(firstFA.getChainId()) && impossiblePositions.get(firstFA.getChainId()).containsKey(poss[0]) || impossiblePositions.containsKey(secondFA.getChainId()) && impossiblePositions.get(secondFA.getChainId()).containsKey(poss[1])) {
                                    isMandRuleOK = false;
                                }
                                if (proposedPositions != null) {
                                    for (int k = 0; k != poss.length; ++k) {
                                        if (poss[k] == proposedPositions[k]) continue;
                                        isMandRuleOK = false;
                                    }
                                    if (!isMandRuleOK && this.debug_) {
                                        this.debugVO_.addContradictingPositionRules(combiName, (IntensityRuleVO)fulfilledRules.lastElement(), this.createIntensityPositionVO(intensityRuleVO, poss, firstFA, secondFA));
                                    }
                                }
                            } else {
                                isMandRuleOK = false;
                                if (this.debug_) {
                                    this.debugVO_.addUnfulfilledPositionRule(combiName, intensityRuleVO);
                                }
                            }
                            if (isMandRuleOK) {
                                proposedPositions = poss;
                                fulfilledRules.add(this.createIntensityPositionVO(intensityRuleVO, poss, firstFA, secondFA));
                                continue;
                            }
                            proposedPositions = null;
                            fulfilledRules = new Vector<IntensityPositionVO>();
                            break;
                        }
                        ++notEnoughFragmentsForEvaluation;
                    }
                    if (fulfilledRules.size() > 0 && inversibleRules.size() > 0) {
                        for (IntensityRuleVO intensityRuleVO : inversibleRules) {
                            fulfilledRules.add(this.createIntensityPositionVO(intensityRuleVO, proposedPositions, firstFA, secondFA));
                        }
                        inversibleRules = new Vector();
                    }
                    if (mandRules.size() > 0 && notEnoughFragmentsForEvaluation < mandRules.size() && proposedPositions == null) continue;
                    Hashtable<String, Vector> addRulesHash = new Hashtable<String, Vector>();
                    for (Object rule3 : addRules) {
                        if (!((IntensityRuleVO)rule3).enoughFragmentsForRuleEvaluationFound(firstFragments) || !((IntensityRuleVO)rule3).enoughFragmentsForRuleEvaluationFound(secondFragments)) continue;
                        int[] poss = this.getPositionRecommendation(firstFA.getChainId(), firstOccurrence, firstFragments, secondFA.getChainId(), secondOccurrence, secondFragments, (IntensityRuleVO)rule3);
                        int[] poss2 = this.getPositionRecommendation(secondFA.getChainId(), secondOccurrence, secondFragments, firstFA.getChainId(), firstOccurrence, firstFragments, (IntensityRuleVO)rule3);
                        if (poss != null) {
                            boolean discard = false;
                            if (poss[0] == poss2[0] && poss[1] == poss2[1]) {
                                boolean firstOK = true;
                                if (impossiblePositions.containsKey(firstFA.getChainId()) && impossiblePositions.get(firstFA.getChainId()).containsKey(poss[0]) || impossiblePositions.containsKey(secondFA.getChainId()) && impossiblePositions.get(secondFA.getChainId()).containsKey(poss[1])) {
                                    firstOK = false;
                                }
                                boolean secondOK = true;
                                if (impossiblePositions.containsKey(firstFA.getChainId()) && impossiblePositions.get(firstFA.getChainId()).containsKey(poss[1]) || impossiblePositions.containsKey(secondFA.getChainId()) && impossiblePositions.get(secondFA.getChainId()).containsKey(poss[0])) {
                                    secondOK = false;
                                }
                                if (firstOK && secondOK) {
                                    inversibleRules.add(rule3);
                                    continue;
                                }
                                if (!firstOK) {
                                    if (secondOK) {
                                        poss = poss2;
                                    } else {
                                        discard = true;
                                    }
                                }
                            }
                            if (impossiblePositions.containsKey(firstFA.getChainId()) && impossiblePositions.get(firstFA.getChainId()).containsKey(poss[0]) || impossiblePositions.containsKey(secondFA.getChainId()) && impossiblePositions.get(secondFA.getChainId()).containsKey(poss[1])) {
                                discard = true;
                            }
                            if (discard) {
                                if (!this.debug_) continue;
                                this.debugVO_.addUnfulfilledPositionRule(combiName, new IntensityPositionVO((IntensityRuleVO)rule3, firstFA, secondFA, this.set_.getOhNumber() > 0, false, false));
                                continue;
                            }
                            if (mandRules.size() > 0 && notEnoughFragmentsForEvaluation < mandRules.size()) {
                                boolean theSame = true;
                                for (int k = 0; k != poss.length; ++k) {
                                    if (poss[k] == proposedPositions[k]) continue;
                                    theSame = false;
                                }
                                if (theSame) {
                                    fulfilledRules.add(this.createIntensityPositionVO((IntensityRuleVO)rule3, poss, firstFA, secondFA));
                                    continue;
                                }
                                if (!this.debug_) continue;
                                this.debugVO_.addContradictingPositionRules(combiName, (IntensityRuleVO)fulfilledRules.lastElement(), this.createIntensityPositionVO((IntensityRuleVO)rule3, poss, firstFA, secondFA));
                                continue;
                            }
                            String id = String.valueOf(poss[0]) + "," + String.valueOf(poss[1]);
                            Vector rules = new Vector();
                            if (addRulesHash.containsKey(id)) {
                                rules = (Vector)addRulesHash.get(id);
                            }
                            rules.add(this.createIntensityPositionVO((IntensityRuleVO)rule3, poss, firstFA, secondFA));
                            addRulesHash.put(id, rules);
                            continue;
                        }
                        if (!this.debug_) continue;
                        this.debugVO_.addUnfulfilledPositionRule(combiName, new IntensityPositionVO((IntensityRuleVO)rule3, firstFA, secondFA, this.set_.getOhNumber() > 0, false, false));
                    }
                    if ((mandRules.size() == 0 || mandRules.size() == notEnoughFragmentsForEvaluation) && addRulesHash.size() > 0) {
                        Object rule3;
                        boolean bl = false;
                        rule3 = addRulesHash.keySet().iterator();
                        while (rule3.hasNext()) {
                            int n;
                            String id = (String)rule3.next();
                            Vector<IntensityPositionVO> rules = (Vector<IntensityPositionVO>)addRulesHash.get(id);
                            if (rules.size() == n) {
                                proposedPositions = null;
                                fulfilledRules = new Vector();
                                continue;
                            }
                            if (rules.size() <= n) continue;
                            n = rules.size();
                            fulfilledRules = rules;
                            proposedPositions = new int[2];
                            String[] poss = id.split(",");
                            proposedPositions[0] = Integer.parseInt(poss[0]);
                            proposedPositions[1] = Integer.parseInt(poss[1]);
                        }
                        if (this.debug_ && addRulesHash.size() > 1) {
                            Iterator keys = addRulesHash.keySet().iterator();
                            String key1 = (String)keys.next();
                            String key2 = (String)keys.next();
                            IntensityPositionVO rule1 = (IntensityPositionVO)((Vector)addRulesHash.get(key1)).lastElement();
                            IntensityPositionVO rule2 = (IntensityPositionVO)((Vector)addRulesHash.get(key2)).lastElement();
                            this.debugVO_.addContradictingPositionRules(combiName, rule1, rule2);
                        }
                    }
                    if (proposedPositions == null) continue;
                    for (IntensityRuleVO rule : inversibleRules) {
                        fulfilledRules.add(this.createIntensityPositionVO(rule, proposedPositions, firstFA, secondFA));
                    }
                    Hashtable hashtable = new Hashtable();
                    if (positionRecommendations.containsKey(firstFA.getChainId())) {
                        Hashtable<Integer, Vector<IntensityPositionVO>> hashtable2 = positionRecommendations.get(firstFA.getChainId());
                    }
                    Vector rules = new Vector();
                    if (var28_46.containsKey((int)proposedPositions[0])) {
                        rules = (Vector)var28_46.get(proposedPositions[0]);
                    }
                    rules.addAll(fulfilledRules);
                    var28_46.put(proposedPositions[0], rules);
                    positionRecommendations.put(firstFA.getChainId(), (Hashtable<Integer, Vector<IntensityPositionVO>>)var28_46);
                    Hashtable hashtable3 = new Hashtable();
                    if (positionRecommendations.containsKey(secondFA.getChainId())) {
                        Hashtable<Integer, Vector<IntensityPositionVO>> hashtable4 = positionRecommendations.get(secondFA.getChainId());
                    }
                    rules = new Vector();
                    if (var28_49.containsKey(proposedPositions[1])) {
                        rules = (Vector)var28_49.get(proposedPositions[1]);
                    }
                    rules.addAll(fulfilledRules);
                    var28_49.put(proposedPositions[1], rules);
                    positionRecommendations.put(secondFA.getChainId(), (Hashtable<Integer, Vector<IntensityPositionVO>>)var28_49);
                }
            }
        }
        if (positionRecommendations.size() > 0) {
            for (i = 0; i != faList.size(); ++i) {
                String fa = (String)faList.get(i);
                if (positionRecommendations.containsKey(fa)) continue;
            }
            positions = this.getMostLikelyPositionsFromRecommendations(combiName, positionRecommendations, impossiblePositions, this.fragCalc_.getAllowedChainPositions());
            this.positionRecommendations_.put(combiName, positionRecommendations);
        }
        return positions;
    }

    /*
     * WARNING - void declaration
     */
    private int[] getMostLikelyPositionsFromRecommendations(String combiName, Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> positionRecommendations, Hashtable<String, Hashtable<Integer, IntensityPositionVO>> impossiblePositions, int allowedChainPositions) throws LipidCombinameEncodingException {
        int i;
        Vector<FattyAcidVO> chains = StaticUtils.decodeLipidNamesFromChainCombi(combiName);
        Hashtable<Integer, Vector<IntensityPositionVO>> positionEvidence = new Hashtable<Integer, Vector<IntensityPositionVO>>();
        int[] positions = new int[chains.size()];
        Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> posRec = new Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>>();
        for (int i2 = 0; i2 != chains.size(); ++i2) {
            FattyAcidVO chain = chains.get(i2);
            if (!positionRecommendations.containsKey(chain.getChainId())) continue;
            posRec.put(chain.getChainId() + "_" + String.valueOf(i2), new Hashtable(positionRecommendations.get(chain.getChainId())));
        }
        Hashtable<Integer, Integer> unassignedPositions = new Hashtable<Integer, Integer>();
        for (i = 0; i != chains.size(); ++i) {
            positions[i] = -1;
        }
        for (i = 0; i != allowedChainPositions; ++i) {
            int position = i + 1;
            unassignedPositions.put(position, position);
        }
        while (unassignedPositions.size() != allowedChainPositions - chains.size()) {
            Hashtable<Integer, String> singles = this.getSinglePositionAssignments(posRec);
            if (singles.size() > 0) {
                for (Integer n : singles.keySet()) {
                    String fa = singles.get(n);
                    for (int i3 = 0; i3 != chains.size(); ++i3) {
                        if (!chains.get(i3).getChainId().equalsIgnoreCase(fa) || positions[i3] != -1) continue;
                        positions[i3] = n;
                        positionEvidence.put(n, new Vector(positionRecommendations.get(fa).get(n)));
                        break;
                    }
                    String keyToRemove = "";
                    for (String key : posRec.keySet()) {
                        if (!key.startsWith(fa + "_")) continue;
                        keyToRemove = key;
                        break;
                    }
                    posRec.remove(keyToRemove);
                    for (String otherFA : posRec.keySet()) {
                        posRec.get(otherFA).remove(n);
                    }
                    this.removeWrongEvidence(fa, n, posRec);
                    unassignedPositions.remove(n);
                }
                continue;
            }
            Hashtable<Integer, String> multiples = this.getMultiplePositionsWithHigherEvidence(posRec);
            if (multiples.size() <= 0) break;
            for (Integer position3 : multiples.keySet()) {
                String fa = multiples.get(position3);
                for (int i4 = 0; i4 != chains.size(); ++i4) {
                    String key;
                    if (!chains.get(i4).getChainId().equalsIgnoreCase(fa)) continue;
                    positions[i4] = position3;
                    key = fa + "_" + String.valueOf(i4);
                    positionEvidence.put(position3, new Vector(posRec.get(key).get(position3)));
                    posRec.remove(key);
                    break;
                }
                for (String otherFA : posRec.keySet()) {
                    posRec.get(otherFA).remove(position3);
                }
                unassignedPositions.remove(position3);
                this.removeWrongEvidence(fa, position3, posRec);
            }
        }
        if (unassignedPositions.size() == allowedChainPositions - chains.size() + 1) {
            int faPos = -1;
            for (int i5 = 0; i5 != chains.size(); ++i5) {
                if (positions[i5] != -1) continue;
                faPos = i5;
                break;
            }
            if (faPos != -1) {
                void var12_23;
                FattyAcidVO chain = chains.get(faPos);
                boolean bl = false;
                while (var12_23 != chains.size()) {
                    if (positions[var12_23] > 0) {
                        unassignedPositions.remove(positions[var12_23]);
                    }
                    ++var12_23;
                }
                if (impossiblePositions.containsKey(chain.getChainId())) {
                    for (Integer pos : impossiblePositions.get(chain.getChainId()).keySet()) {
                        if (!unassignedPositions.containsKey(pos)) continue;
                        unassignedPositions.remove(pos);
                    }
                }
                if (unassignedPositions.size() == 1) {
                    positions[faPos] = (Integer)unassignedPositions.keySet().iterator().next();
                    String string = chain.getChainId() + "_" + String.valueOf(faPos);
                    Vector<IntensityPositionVO> evidence = new Vector<IntensityPositionVO>();
                    if (impossiblePositions.containsKey(chain.getChainId())) {
                        for (IntensityPositionVO posVO : impossiblePositions.get(chain.getChainId()).values()) {
                            evidence.add(IntensityPositionVO.createNegatedVO(posVO, positions[faPos]));
                        }
                    }
                    positionEvidence.put(positions[faPos], evidence);
                    posRec.remove(string);
                    unassignedPositions.remove(positions[faPos]);
                    this.removeWrongEvidence(chain.getChainId(), positions[faPos], posRec);
                }
            }
        }
        positionEvidence = this.cleanWrongEvidence(chains, positions, positionEvidence);
        this.posEvidenceAccordToProposedDefinition_.put(combiName, positionEvidence);
        return positions;
    }

    private Hashtable<Integer, Vector<IntensityPositionVO>> cleanWrongEvidence(Vector<FattyAcidVO> fas, int[] positions, Hashtable<Integer, Vector<IntensityPositionVO>> positionEvidence) {
        Hashtable<Integer, Vector<IntensityPositionVO>> cleaned = new Hashtable<Integer, Vector<IntensityPositionVO>>();
        Hashtable<String, Hashtable> faPosOK = new Hashtable<String, Hashtable>();
        Hashtable<String, FattyAcidVO> unassigned = new Hashtable<String, FattyAcidVO>();
        for (int i = 0; i != fas.size(); ++i) {
            FattyAcidVO fa = fas.get(i);
            if (positions[i] > -1) {
                Hashtable poss = new Hashtable();
                if (faPosOK.containsKey(fa.getChainId())) {
                    poss = (Hashtable)faPosOK.get(fa.getChainId());
                }
                poss.put(positions[i], positions[i]);
                faPosOK.put(fa.getChainId(), poss);
                continue;
            }
            unassigned.put(fa.getChainId(), fa);
        }
        for (Integer pos : positionEvidence.keySet()) {
            Vector<IntensityPositionVO> ok = new Vector<IntensityPositionVO>();
            for (IntensityPositionVO posVO : positionEvidence.get(pos)) {
                boolean addIt = true;
                if (!posVO.isNegated()) {
                    addIt = false;
                    FattyAcidVO big = posVO.getBiggerFA();
                    boolean bigOk = true;
                    if (big != null) {
                        String biggerFA = big.getChainId();
                        int biggerPos = posVO.getBiggerPosition();
                        if (!unassigned.containsKey(biggerFA) && !faPosOK.containsKey(biggerFA) && ((Hashtable)faPosOK.get(biggerFA)).containsKey(biggerPos)) {
                            bigOk = false;
                        }
                    }
                    FattyAcidVO small = posVO.getSmallerFA();
                    boolean smallOk = true;
                    if (small != null) {
                        String smallerFA = small.getChainId();
                        int smallerPos = posVO.getSmallerPosition();
                        if (!unassigned.containsKey(smallerFA) && !faPosOK.containsKey(smallerFA) && ((Hashtable)faPosOK.get(smallerFA)).containsKey(smallerPos)) {
                            smallOk = false;
                        }
                    }
                    if (bigOk && smallOk) {
                        addIt = true;
                    }
                }
                if (!addIt) continue;
                ok.add(posVO);
            }
            cleaned.put(pos, ok);
        }
        return cleaned;
    }

    private void removeWrongEvidence(String fa, int position, Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> posRec) {
        for (String faWithPos : posRec.keySet()) {
            Hashtable<Integer, Vector<IntensityPositionVO>> recomm = posRec.get(faWithPos);
            for (Integer pos : recomm.keySet()) {
                Vector<IntensityPositionVO> old = recomm.get(pos);
                Vector<IntensityPositionVO> newEv = new Vector<IntensityPositionVO>();
                for (IntensityPositionVO ev : old) {
                    if (ev.getBiggerPosition() != position && ev.getSmallerPosition() != position) {
                        newEv.add(ev);
                        continue;
                    }
                    if ((ev.getBiggerPosition() != position || !ev.getBiggerFA().getChainId().equalsIgnoreCase(fa)) && (ev.getSmallerPosition() != position || !ev.getSmallerFA().getChainId().equalsIgnoreCase(fa))) continue;
                    newEv.add(ev);
                }
                if (newEv.size() <= 0) continue;
                recomm.put(pos, newEv);
            }
            posRec.put(faWithPos, recomm);
        }
    }

    private Hashtable<Integer, String> getMultiplePositionsWithHigherEvidence(Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> posRec) {
        Hashtable<Integer, String> moreLikelyMultiples = new Hashtable<Integer, String>();
        Hashtable<Integer, Integer> occurences = new Hashtable<Integer, Integer>();
        Hashtable<Integer, Vector<String>> fasForPosition = this.buildFasForPositionHash(posRec);
        int lowestOccurence = Integer.MAX_VALUE;
        for (Vector<String> fas : fasForPosition.values()) {
            if (fas.size() >= lowestOccurence) continue;
            lowestOccurence = fas.size();
        }
        int rulesForPosition = 0;
        Hashtable<String, Integer> allowedOccurences = this.getAllowedOccurences(posRec);
        for (Integer position : fasForPosition.keySet()) {
            Vector<String> fas = fasForPosition.get(position);
            Hashtable<String, String> usedFAs = new Hashtable<String, String>();
            for (String fa : fas) {
                Vector<IntensityPositionVO> rules;
                if (usedFAs.containsKey(fa)) continue;
                usedFAs.put(fa, fa);
                String key = "";
                for (String faWithPos : posRec.keySet()) {
                    if (!faWithPos.startsWith(fa + "_")) continue;
                    key = faWithPos;
                    break;
                }
                if ((rules = posRec.get(key).get(position)).size() == rulesForPosition) {
                    moreLikelyMultiples.remove(position);
                    occurences.remove(position);
                    continue;
                }
                if (rules.size() <= rulesForPosition) continue;
                int foundElse = 0;
                for (Integer pos2 : fasForPosition.keySet()) {
                    if (position == pos2 || !posRec.get(key).containsKey(pos2) || rules.size() != posRec.get(key).get(pos2).size()) continue;
                    ++foundElse;
                }
                if (foundElse >= allowedOccurences.get(fa)) continue;
                rulesForPosition = rules.size();
                moreLikelyMultiples.put(position, fa);
                occurences.put(position, rulesForPosition);
            }
        }
        int highestOccurence = 0;
        for (Integer pos : moreLikelyMultiples.keySet()) {
            if ((Integer)occurences.get(pos) <= highestOccurence) continue;
            highestOccurence = (Integer)occurences.get(pos);
        }
        for (Integer pos : occurences.keySet()) {
            if ((Integer)occurences.get(pos) == highestOccurence) continue;
            moreLikelyMultiples.remove(pos);
        }
        return moreLikelyMultiples;
    }

    private Hashtable<Integer, String> getSinglePositionAssignments(Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> posRec) {
        Hashtable<Integer, String> singles = new Hashtable<Integer, String>();
        Hashtable<Integer, Vector<String>> fasForPosition = this.buildFasForPositionHash(posRec);
        Hashtable<String, Integer> allowedOccurences = this.getAllowedOccurences(posRec);
        for (Integer position : fasForPosition.keySet()) {
            if (fasForPosition.get(position).size() != 1) continue;
            String fa = fasForPosition.get(position).get(0);
            int foundElse = 0;
            block1: for (Integer pos2 : fasForPosition.keySet()) {
                if (position == pos2 || fasForPosition.get(position).size() > 1) continue;
                for (String other : fasForPosition.get(pos2)) {
                    if (!fa.equalsIgnoreCase(other)) continue;
                    ++foundElse;
                    continue block1;
                }
            }
            if (foundElse >= allowedOccurences.get(fa)) continue;
            singles.put(position, fa);
        }
        return singles;
    }

    private Hashtable<String, Integer> getAllowedOccurences(Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> posRec) {
        Hashtable<String, Integer> allowedOccurences = new Hashtable<String, Integer>();
        for (String faWithPos : posRec.keySet()) {
            String fa = faWithPos.substring(0, faWithPos.lastIndexOf("_"));
            int occur = 0;
            if (allowedOccurences.containsKey(fa)) {
                occur = allowedOccurences.get(fa);
            }
            allowedOccurences.put(fa, ++occur);
        }
        return allowedOccurences;
    }

    private Hashtable<Integer, Vector<String>> buildFasForPositionHash(Hashtable<String, Hashtable<Integer, Vector<IntensityPositionVO>>> posRec) {
        Hashtable<Integer, Vector<String>> fasForPosition = new Hashtable<Integer, Vector<String>>();
        for (String faWithPos : posRec.keySet()) {
            String fa = faWithPos.substring(0, faWithPos.lastIndexOf("_"));
            Hashtable<Integer, Vector<IntensityPositionVO>> intToRules = posRec.get(faWithPos);
            for (Integer position : intToRules.keySet()) {
                Vector<String> fas = new Vector<String>();
                if (fasForPosition.containsKey(position)) {
                    fas = fasForPosition.get(position);
                }
                fas.add(fa);
                fasForPosition.put(position, fas);
            }
        }
        return fasForPosition;
    }

    private int[] getPositionRecommendation(String firstFA, int firstOccurence, Hashtable<String, CgProbe> firstFragments, String secondFA, int secondOccurence, Hashtable<String, CgProbe> secondFragments, IntensityRuleVO rule) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        double smallerArea;
        int[] recommendation = null;
        Float basepeak = this.getBasepeakIfRequired(rule);
        double biggerArea = rule.getBiggerArea(firstFragments, basepeak) / (double)firstOccurence;
        if (biggerArea > (smallerArea = rule.getSmallerArea(secondFragments, basepeak) / (double)secondOccurence)) {
            recommendation = new int[]{rule.getBiggerPosition(), rule.getSmallerPosition()};
        }
        if (recommendation != null) {
            return recommendation;
        }
        biggerArea = rule.getBiggerArea(secondFragments, basepeak) / (double)secondOccurence;
        if (biggerArea > (smallerArea = rule.getSmallerArea(firstFragments, basepeak) / (double)firstOccurence)) {
            recommendation = new int[2];
            recommendation[1] = rule.getBiggerPosition();
            recommendation[0] = rule.getSmallerPosition();
        }
        return recommendation;
    }

    private void transferResultsToLipidParameterSet() throws RulesException, NoRuleException, IOException, SpectrummillParserException, LipidCombinameEncodingException {
        if (this.status_ > 1 || this.debug_) {
            Hashtable<Integer, LinkedHashMap<Integer, Float>> msnRetentionTimes = new Hashtable<Integer, LinkedHashMap<Integer, Float>>();
            for (int msLevel : this.msLevels_.keySet()) {
                if (!this.msLevels_.get(msLevel).booleanValue() || !this.probesWithMSnSpectra_.containsKey(msLevel)) continue;
                msnRetentionTimes.put(msLevel, this.analyzer_.getMSnSpectraRetentionTimes(msLevel, this.probesWithMSnSpectra_.get(msLevel)));
            }
            this.set_ = new LipidomicsMSnSet(this.set_, this.status_, this.headGroupFragments_, this.fulfilledHeadIntensityRules_, this.chainFragments_, this.fulfilledChainIntensityRules_, this.validChainCombinations_, this.relativeIntensityOfCombination_, this.positionDefinition_, this.posEvidenceAccordToProposedDefinition_, this.fragCalc_ != null ? this.fragCalc_.getAllowedChainPositions() : 1, this.basePeakValues_, msnRetentionTimes, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding());
            this.set_.setCoverage(this.coverage_);
        }
    }

    public LipidParameterSet getResult() {
        return this.set_;
    }

    private IntensityPositionVO createIntensityPositionVO(IntensityRuleVO rule, int[] poss, FattyAcidVO firstFA, FattyAcidVO secondFA) {
        FattyAcidVO biggerFA = null;
        FattyAcidVO smallerFA = null;
        if (poss[0] == rule.getBiggerPosition()) {
            biggerFA = firstFA;
            smallerFA = secondFA;
        } else {
            biggerFA = secondFA;
            smallerFA = firstFA;
        }
        return new IntensityPositionVO(rule, biggerFA, smallerFA, this.set_.getOhNumber() > 0, false, false);
    }

    private void checkSpectrumCoverage(Hashtable<Integer, Boolean> msLevels) throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException {
        float coverage;
        Vector<CgProbe> foundHits = new Vector<CgProbe>();
        Vector<CgProbe> notCounted = new Vector<CgProbe>();
        for (CgProbe cgProbe : this.headGroupFragments_.values()) {
            if (cgProbe.isFromOtherSpecies()) {
                notCounted.add(cgProbe);
                continue;
            }
            foundHits.add(cgProbe);
        }
        for (Hashtable hashtable : this.chainFragments_.values()) {
            for (CgProbe hit : hashtable.values()) {
                if (hit.isFromOtherSpecies()) {
                    notCounted.add(hit);
                    continue;
                }
                foundHits.add(hit);
            }
        }
        Pair<Boolean, Float> spectrumCoverage = MSnAnalyzer.isSpectrumCovered(this.analyzer_, this.set_, msLevels, foundHits, new Vector<CgProbe>(), (float)RulesContainer.getBasePeakCutoff(StaticUtils.getRuleName(this.className_, this.modName_), this.rulesDir_), (float)RulesContainer.getSpectrumCoverageMin(StaticUtils.getRuleName(this.className_, this.modName_), this.rulesDir_), this.ignoreAbsolute_, this.debug_, this.debugVO_);
        boolean bl = spectrumCoverage.getKey();
        this.coverage_ = coverage = spectrumCoverage.getValue().floatValue();
        if (!bl) {
            this.status_ = 1;
        }
    }

    private static Pair<Boolean, Float> isSpectrumCovered(LipidomicsAnalyzer analyzer, LipidParameterSet set, Hashtable<Integer, Boolean> msLevels, Vector<CgProbe> foundHits, Vector<CgProbe> notCountedHits, float bpCutoff, float coverageMin, boolean ignoreAbsolute, boolean debug, MSnDebugVO debugVO) throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException {
        Vector<Integer> levels = new Vector<Integer>();
        for (int level : msLevels.keySet()) {
            if (!msLevels.get(level).booleanValue() || level != 2) continue;
            levels.add(level);
        }
        Hashtable<Integer, Float> coverages = analyzer.calculateSpectrumCoverage(MSnAnalyzer.getCorrespondingCgProbes(set), foundHits, notCountedHits, levels, bpCutoff);
        boolean covered = true;
        for (int key : coverages.keySet()) {
            if (ignoreAbsolute) {
                coverageMin = 0.0f;
            }
            if (coverages.get(key).floatValue() > coverageMin || !ignoreAbsolute && coverageMin == 0.0f) continue;
            if (debug) {
                debugVO.setSpectrumCoverageFulfilled(false);
            }
            covered = false;
            break;
        }
        return new Pair<Boolean, Float>(covered, coverages.get(2));
    }

    public static boolean isSpectrumCovered(LipidomicsAnalyzer analyzer, LipidParameterSet set, Hashtable<Integer, Boolean> msLevels, Vector<CgProbe> foundHits, Vector<CgProbe> notCountedHits, float bpCutoff, float coverageMin) throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException {
        return MSnAnalyzer.isSpectrumCovered(analyzer, set, msLevels, foundHits, notCountedHits, bpCutoff, coverageMin, false, false, null).getKey();
    }

    public MSnDebugVO getDebugInfo() throws RulesException {
        if (this.debug_) {
            this.debugVO_.setStatus(this.status_);
            return this.debugVO_;
        }
        throw new RulesException("The analyzer is not in debug mode -> there is no debug information available!");
    }

    private int findAreaDiscardReason(CgProbe probe, FragmentVO fragment, float absThreshold) throws RulesException, NoRuleException, IOException, SpectrummillParserException, CgException {
        int discardStatus = 1;
        if (probe.AreaStatus == CgAreaStatus.NothingThere) {
            discardStatus = 1;
        } else if (!this.checkCutoffs(probe, fragment.getMsLevel(), absThreshold)) {
            discardStatus = 2;
        }
        return discardStatus;
    }

    public Vector<Float> getFoundMatchingSpectraTimes() {
        return this.spectraFound_;
    }

    public boolean areMSnSpectraPresent() {
        return this.msnSpectraPresent_;
    }

    public Hashtable<String, Hashtable<Integer, Integer>> getPositionDefinition() {
        return this.positionDefinition_;
    }

    public String getRulesDir() {
        return this.rulesDir_;
    }

    private void addToPositionSpecificRuleHash(Hashtable<String, Hashtable<Boolean, Vector<IntensityRuleVO>>> positionSpecificRules, String identifier, IntensityRuleVO rule) {
        Hashtable<Object, Object> mandAndAddRules = new Hashtable();
        Vector mandRules = new Vector();
        Vector addRules = new Vector();
        if (positionSpecificRules.containsKey(identifier)) {
            mandAndAddRules = positionSpecificRules.get(identifier);
            mandRules = (Vector)mandAndAddRules.get(true);
            addRules = (Vector)mandAndAddRules.get(false);
        }
        if (rule.isMandatory()) {
            mandRules.add(rule);
        } else {
            addRules.add(rule);
        }
        mandAndAddRules.put(true, mandRules);
        mandAndAddRules.put(false, addRules);
        positionSpecificRules.put(identifier, mandAndAddRules);
    }

    public static Vector<SharedPeakContributionVO> splitTwoIsobaricPeaks(LipidomicsAnalyzer analyzer, float start, float stop, float startRelative, float stopRelative, SharedMS1PeakVO shared, int upperMsLevel) throws CgException, LipidCombinameEncodingException {
        Object rts;
        List<Integer> scansSorted;
        Vector<SharedPeakContributionVO> splitted = new Vector<SharedPeakContributionVO>();
        Hashtable relevantSpectra = new Hashtable();
        Hashtable<Integer, Hashtable<Integer, String>> allSpectra = analyzer.getMSnSpectraCache();
        Hashtable<Integer, Hashtable<Integer, Float>> allNoise = analyzer.getMSnSpectraNoise();
        Hashtable<Integer, Hashtable<Integer, Float>> retTimeLookup = new Hashtable<Integer, Hashtable<Integer, Float>>();
        Hashtable<Integer, List<Integer>> scanNumbersSorted = new Hashtable<Integer, List<Integer>>();
        for (Integer msLevel : allSpectra.keySet()) {
            Hashtable<Integer, Float> retTimes = analyzer.getRetentionTimes(msLevel);
            Hashtable<Integer, String> spectra = allSpectra.get(msLevel);
            Hashtable relRetTimes = new Hashtable();
            Hashtable<Integer, String> relSpectra = new Hashtable<Integer, String>();
            scansSorted = new ArrayList();
            for (Integer consScanNumber : spectra.keySet()) {
                float rt = retTimes.get(consScanNumber).floatValue();
                if (!(start <= rt) || !(rt <= stop)) continue;
                relRetTimes.put(consScanNumber, retTimes.get(consScanNumber));
                relSpectra.put(consScanNumber, spectra.get(consScanNumber));
                scansSorted.add(consScanNumber);
            }
            Collections.sort(scansSorted);
            retTimeLookup.put(msLevel, relRetTimes);
            relevantSpectra.put(msLevel, relSpectra);
            scanNumbersSorted.put(msLevel, scansSorted);
        }
        Hashtable<Integer, Hashtable> relevantMzHash = new Hashtable<Integer, Hashtable>();
        for (int i = 0; i != shared.getPartners().size(); ++i) {
            SharedPeakContributionVO partner = shared.getPartners().get(i);
            Iterator quant = partner.getQuantVO();
            for (String key : partner.getDistinctFragments().keySet()) {
                CgProbe probe = partner.getDistinctFragments().get(key);
                if (((List)scanNumbersSorted.get(probe.getMsLevel())).isEmpty()) continue;
                Hashtable allOfMsLevel = new Hashtable();
                if (relevantMzHash.containsKey(probe.getMsLevel())) {
                    allOfMsLevel = (Hashtable)relevantMzHash.get(probe.getMsLevel());
                }
                Hashtable allOfQuant = new Hashtable();
                if (allOfMsLevel.containsKey(quant)) {
                    allOfQuant = (Hashtable)allOfMsLevel.get(quant);
                }
                allOfQuant.put(key, probe);
                allOfMsLevel.put(quant, allOfQuant);
                relevantMzHash.put(probe.getMsLevel(), allOfMsLevel);
            }
        }
        Hashtable<QuantVO, Hashtable<String, Vector<LipidomicsChromatogram>>> chromsForMzs = null;
        ArrayList<Integer> msLevels = new ArrayList<Integer>();
        for (Integer msLevel : relevantMzHash.keySet()) {
            msLevels.add(msLevel);
        }
        Collections.sort(msLevels);
        for (Integer msLevel : msLevels) {
            if (msLevel != msLevels.get(0)) continue;
            chromsForMzs = new Hashtable<QuantVO, Hashtable<String, Vector<LipidomicsChromatogram>>>();
            Hashtable mzsForChroms = (Hashtable)relevantMzHash.get(msLevel);
            scansSorted = (List)scanNumbersSorted.get(msLevel);
            rts = (Hashtable)retTimeLookup.get(msLevel);
            Hashtable<Integer, Float> noiseLevels = allNoise.get(msLevel);
            Hashtable spectra = (Hashtable)relevantSpectra.get(msLevel);
            for (QuantVO quant : mzsForChroms.keySet()) {
                Hashtable allOfQuant = (Hashtable)mzsForChroms.get(quant);
                Hashtable chromsOfPartner = new Hashtable();
                for (String key : allOfQuant.keySet()) {
                    float tol;
                    LipidomicsChromatogram chrom = new LipidomicsChromatogram(new CgChromatogram(scansSorted.size()));
                    chrom.LowerMzBand = tol = StaticUtils.calculatedMzTolValue(((CgProbe)allOfQuant.get((Object)key)).Mz, analyzer.getMsnMzTolerance(), analyzer.getMsnMzToleranceUnit());
                    chrom.UpperMzBand = tol;
                    LipidomicsChromatogram chromRelative = new LipidomicsChromatogram(new CgChromatogram(scansSorted.size()));
                    for (int i = 0; i != scansSorted.size(); ++i) {
                        chrom.Value[i][0] = ((Float)((Hashtable)rts).get(scansSorted.get(i))).floatValue();
                        chrom.Value[i][1] = 0.0f;
                        chrom.Value[i][2] = 0.0f;
                        chrom.Value[i][3] = 0.0f;
                        chromRelative.Value[i][0] = ((Float)((Hashtable)rts).get(scansSorted.get(i))).floatValue();
                        chromRelative.Value[i][1] = 0.0f;
                        chromRelative.Value[i][2] = 0.0f;
                        chromRelative.Value[i][3] = 0.0f;
                    }
                    Vector<LipidomicsChromatogram> chroms = new Vector<LipidomicsChromatogram>();
                    chroms.add(chrom);
                    chroms.add(chromRelative);
                    chromsOfPartner.put(key, chroms);
                }
                chromsForMzs.put(quant, chromsOfPartner);
            }
            for (int i = 0; i != scansSorted.size(); ++i) {
                int consScanNumber = (Integer)scansSorted.get(i);
                float noise = noiseLevels.get(consScanNumber).floatValue();
                float noiseThreshold = noise * 1.5f;
                String spectrum = (String)spectra.get(consScanNumber);
                spectrum = spectrum.substring(spectrum.indexOf(" ") + 1);
                FloatBuffer buffer = ByteBuffer.wrap(Base64.decode(spectrum)).asFloatBuffer();
                int limit = buffer.limit();
                float mz = 0.0f;
                float intensity = 0.0f;
                float highestInt = 0.0f;
                for (int iItem = 0; iItem < limit; ++iItem) {
                    if (iItem % 2 == 0) {
                        mz = buffer.get();
                        continue;
                    }
                    intensity = buffer.get();
                    if (!(intensity > noiseThreshold)) continue;
                    if (intensity > highestInt) {
                        highestInt = intensity;
                    }
                    for (QuantVO quant : mzsForChroms.keySet()) {
                        Hashtable mzs = (Hashtable)mzsForChroms.get(quant);
                        for (String key : mzs.keySet()) {
                            CgProbe probe = (CgProbe)mzs.get(key);
                            if (!(probe.Mz - probe.LowerMzBand < mz) || !(mz < probe.Mz + probe.UpperMzBand)) continue;
                            chromsForMzs.get((Object)quant).get((Object)key).get((int)0).Value[i][1] = intensity;
                        }
                    }
                }
                if (highestInt <= 0.0f) continue;
                for (QuantVO quant : chromsForMzs.keySet()) {
                    Hashtable<String, Vector<LipidomicsChromatogram>> chromsForQuant = chromsForMzs.get(quant);
                    for (String key : chromsForQuant.keySet()) {
                        Vector<LipidomicsChromatogram> chroms = chromsForQuant.get(key);
                        if (!(startRelative <= chroms.get((int)1).Value[i][0]) || !(chroms.get((int)1).Value[i][0] <= stopRelative)) continue;
                        chroms.get((int)1).Value[i][1] = chroms.get((int)0).Value[i][1] / highestInt;
                    }
                }
            }
        }
        if (chromsForMzs.keySet().size() < 2) {
            return splitted;
        }
        Hashtable<QuantVO, Object> rtPeaksAbsolute = new Hashtable<QuantVO, Object>();
        Hashtable<QuantVO, Float> proposedRts = new Hashtable<QuantVO, Float>();
        for (QuantVO quant : chromsForMzs.keySet()) {
            rts = new Hashtable();
            float sumWeightings = 0.0f;
            float weightedRt = 0.0f;
            for (String key : ((Hashtable)chromsForMzs.get(quant)).keySet()) {
                LipidomicsChromatogram chrom = (LipidomicsChromatogram)((Vector)((Hashtable)chromsForMzs.get(quant)).get(key)).get(0);
                int index = chrom.findIndexOfHighestIntensity();
                if (index < 0) continue;
                ((Hashtable)rts).put(key, new FloatFloatVO(chrom.Value[index][0], chrom.Value[index][1]));
                weightedRt += chrom.Value[index][0] * chrom.Value[index][1];
                sumWeightings += chrom.Value[index][1];
            }
            float proposedRt = weightedRt / sumWeightings;
            proposedRts.put(quant, Float.valueOf(proposedRt));
            rtPeaksAbsolute.put(quant, rts);
        }
        if (proposedRts.size() < 2) {
            String classes = "";
            String rts2 = "";
            for (SharedPeakContributionVO partner : shared.getPartners()) {
                classes = classes + partner.getQuantVO().getAnalyteClass() + "_" + partner.getSet().getNameString() + "-";
                rts2 = rts2 + partner.getSet().getRt() + "/";
            }
            classes = classes.substring(0, classes.length() - 1);
            rts2 = rts2.substring(0, rts2.length() - 1);
        }
        Iterator it = proposedRts.keySet().iterator();
        QuantVO quant1 = (QuantVO)it.next();
        QuantVO quant2 = (QuantVO)it.next();
        MSnAnalyzer.checkProposedRtsInsidePeakBorders(proposedRts, shared);
        float threshold = MSnAnalyzer.checkForThresholdRt(proposedRts.get(quant1).floatValue(), proposedRts.get(quant2).floatValue(), scanNumbersSorted, retTimeLookup);
        if (threshold < 0.0f) {
            Hashtable<QuantVO, Float> proposedRelativeRts = new Hashtable<QuantVO, Float>();
            for (QuantVO quant : chromsForMzs.keySet()) {
                float sumWeightings = 0.0f;
                float weightedRt = 0.0f;
                for (String key : chromsForMzs.get(quant).keySet()) {
                    LipidomicsChromatogram absChrom = chromsForMzs.get(quant).get(key).get(0);
                    LipidomicsChromatogram relChrom = chromsForMzs.get(quant).get(key).get(1);
                    Vector<Double> basePeaks = new Vector<Double>();
                    for (int i = 0; i != relChrom.Value.length; ++i) {
                        if (!(relChrom.Value[i][1] > 0.999999f)) continue;
                        basePeaks.add(Double.valueOf(relChrom.Value[i][0]));
                    }
                    int index = -1;
                    float rt = 0.0f;
                    if (basePeaks.size() > 0) {
                        if (basePeaks.size() * 5 / 4 >= relChrom.Value.length) {
                            index = absChrom.findIndexOfHighestIntensity();
                            rt = absChrom.Value[index][0];
                        } else {
                            rt = Calculator.mean(basePeaks);
                            index = absChrom.findIndexOfHighestIntensity();
                        }
                    } else {
                        index = relChrom.findIndexOfHighestIntensity();
                        if (index > 0) {
                            rt = relChrom.Value[index][0];
                        }
                    }
                    if (index < 0) continue;
                    weightedRt += rt * relChrom.Value[index][1];
                    sumWeightings += relChrom.Value[index][1];
                }
                float proposedRt = weightedRt / sumWeightings;
                proposedRelativeRts.put(quant, Float.valueOf(proposedRt));
            }
            if (proposedRts.get(quant1).floatValue() * 1.02f > proposedRts.get(quant2).floatValue() && proposedRts.get(quant2).floatValue() * 1.02f > proposedRts.get(quant1).floatValue() || ((Float)proposedRelativeRts.get(quant1)).floatValue() < ((Float)proposedRelativeRts.get(quant2)).floatValue() && proposedRts.get(quant1).floatValue() < proposedRts.get(quant2).floatValue() || ((Float)proposedRelativeRts.get(quant1)).floatValue() > proposedRelativeRts.get(quant2).floatValue() && proposedRts.get(quant1).floatValue() > proposedRts.get(quant2).floatValue()) {
                MSnAnalyzer.checkProposedRtsInsidePeakBorders(proposedRelativeRts, shared);
                threshold = MSnAnalyzer.checkForThresholdRt(proposedRelativeRts.get(quant1).floatValue(), proposedRelativeRts.get(quant2).floatValue(), scanNumbersSorted, retTimeLookup);
                if (threshold >= 0.0f) {
                    proposedRts = proposedRelativeRts;
                }
            }
        }
        if (threshold >= 0.0f && !MSnAnalyzer.areIntensitesOKAccordingToSeparation(shared, proposedRts, chromsForMzs)) {
            threshold = -1.0f;
        }
        if (threshold > -1.0f) {
            SharedPeakContributionVO[] lowerHigher = MSnAnalyzer.getLowerAndHigherContribution(shared, proposedRts);
            SharedPeakContributionVO lowerContr = lowerHigher[0];
            lowerContr.makeCopyOfOldIdentification();
            SharedPeakContributionVO upperContr = lowerHigher[1];
            upperContr.makeCopyOfOldIdentification();
            lowerContr.getSet().setUpperRtHardLimit(threshold);
            try {
                analyzer.recalculatePeaksAccordingToHardLimits(lowerContr.getSet(), upperMsLevel, proposedRts.get(lowerContr.getQuantVO()).floatValue());
            }
            catch (CgException cgx) {
                MSnAnalyzer.undoSplit(lowerContr, upperContr);
                return null;
            }
            try {
                MSnAnalyzer.recalculateMS2Identification(lowerContr, analyzer);
            }
            catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException | RulesException | SpectrummillParserException | IOException e) {
                e.printStackTrace();
            }
            upperContr.getSet().setLowerRtHardLimit(threshold);
            try {
                analyzer.recalculatePeaksAccordingToHardLimits(upperContr.getSet(), upperMsLevel, proposedRts.get(upperContr.getQuantVO()).floatValue());
            }
            catch (CgException cgx) {
                MSnAnalyzer.undoSplit(lowerContr, upperContr);
                return null;
            }
            try {
                MSnAnalyzer.recalculateMS2Identification(upperContr, analyzer);
            }
            catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException | RulesException | SpectrummillParserException | IOException e) {
                e.printStackTrace();
            }
            splitted.add(lowerContr);
            splitted.add(upperContr);
        }
        return splitted;
    }

    private static void undoSplit(SharedPeakContributionVO lowerContr, SharedPeakContributionVO upperContr) {
        MSnAnalyzer.undoSplit(lowerContr);
        MSnAnalyzer.undoSplit(upperContr);
    }

    private static void undoSplit(SharedPeakContributionVO contr) {
        contr.setSet(contr.getOldSet());
        contr.getSet().setUpperRtHardLimit(-1.0f);
        contr.getSet().setLowerRtHardLimit(-1.0f);
    }

    private static void checkProposedRtsInsidePeakBorders(Hashtable<QuantVO, Float> proposedRts, SharedMS1PeakVO shared) {
        for (SharedPeakContributionVO partner : shared.getPartners()) {
            if (!proposedRts.containsKey(partner.getQuantVO())) continue;
            float lowest = Float.MAX_VALUE;
            float highest = 0.0f;
            for (CgProbe probe : MSnAnalyzer.getCorrespondingCgProbes(partner.getSet())) {
                if (probe.LowerValley < lowest) {
                    lowest = probe.LowerValley;
                }
                if (!(probe.UpperValley > highest)) continue;
                highest = probe.UpperValley;
            }
            float proposedRt = proposedRts.get(partner.getQuantVO()).floatValue();
            if (proposedRt < lowest) {
                proposedRts.put(partner.getQuantVO(), Float.valueOf(lowest));
            }
            if (!(proposedRt > highest)) continue;
            proposedRts.put(partner.getQuantVO(), Float.valueOf(highest));
        }
    }

    private static void recalculateMS2Identification(SharedPeakContributionVO contr, LipidomicsAnalyzer analyzer) throws RulesException, IOException, SpectrummillParserException, CgException, HydroxylationEncodingException, ChemicalFormulaException, LipidCombinameEncodingException {
        MSnAnalyzer msnAnalyzer = new MSnAnalyzer(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getModName(), contr.getSet(), analyzer, contr.getQuantVO(), true, true);
        if (msnAnalyzer.checkStatus() == 1) {
            contr.setSet(null);
        } else {
            contr.setSet(msnAnalyzer.getResult());
        }
    }

    private static float checkForThresholdRt(float rt1, float rt2, Hashtable<Integer, List<Integer>> scans, Hashtable<Integer, Hashtable<Integer, Float>> retTimeLookup) {
        float threshold = -1.0f;
        float lowerRt = rt1;
        float higherRt = rt2;
        if (lowerRt > higherRt) {
            lowerRt = rt2;
            higherRt = rt1;
        }
        if (MSnAnalyzer.scanInBetween(lowerRt, higherRt, scans, retTimeLookup) || MSnAnalyzer.rtsCloseToNextScan(lowerRt, higherRt, scans, retTimeLookup)) {
            threshold = (rt1 + rt2) / 2.0f;
        }
        return threshold;
    }

    private static boolean scanInBetween(float lowerRt, float higherRt, Hashtable<Integer, List<Integer>> scans, Hashtable<Integer, Hashtable<Integer, Float>> retTimeLookup) {
        boolean scanInBetween = false;
        for (Integer msLevel : scans.keySet()) {
            for (Integer scanNumber : scans.get(msLevel)) {
                float rt = retTimeLookup.get(msLevel).get(scanNumber).floatValue();
                if (!(lowerRt < rt) || !(rt < higherRt)) continue;
                scanInBetween = true;
                return scanInBetween;
            }
        }
        return scanInBetween;
    }

    private static boolean rtsCloseToNextScan(float lowerRt, float higherRt, Hashtable<Integer, List<Integer>> scans, Hashtable<Integer, Hashtable<Integer, Float>> retTimeLookup) {
        boolean closeEnough = false;
        float nextLowerScan = -1.0f;
        float nextUpperScan = -1.0f;
        float timeDistanceLower = Float.MAX_VALUE;
        float timeDistanceUpper = Float.MAX_VALUE;
        for (Integer msLevel : scans.keySet()) {
            for (Integer scanNumber : scans.get(msLevel)) {
                float rt = retTimeLookup.get(msLevel).get(scanNumber).floatValue();
                if (rt <= lowerRt && lowerRt - rt < timeDistanceLower) {
                    nextLowerScan = rt;
                    timeDistanceLower = lowerRt - rt;
                }
                if (!(rt >= higherRt) || !(rt - higherRt < timeDistanceUpper)) continue;
                nextUpperScan = rt;
                timeDistanceUpper = rt - higherRt;
            }
        }
        float scanDistance = nextUpperScan - nextLowerScan;
        float tolerance = scanDistance / 5.0f;
        if (lowerRt <= nextLowerScan + tolerance && higherRt >= nextUpperScan - tolerance) {
            closeEnough = true;
        }
        return closeEnough;
    }

    private static boolean areIntensitesOKAccordingToSeparation(SharedMS1PeakVO shared, Hashtable<QuantVO, Float> proposedRts, Hashtable<QuantVO, Hashtable<String, Vector<LipidomicsChromatogram>>> chromsForMzs) {
        int i;
        LipidomicsChromatogram chrom;
        boolean ok = false;
        float lowerAreaOfLowerContr = 0.0f;
        float lowerAreaOfUpperContr = 0.0f;
        float upperAreaOfLowerContr = 0.0f;
        float upperAreaOfUpperContr = 0.0f;
        SharedPeakContributionVO[] lowerHigher = MSnAnalyzer.getLowerAndHigherContribution(shared, proposedRts);
        SharedPeakContributionVO lowerContr = lowerHigher[0];
        SharedPeakContributionVO upperContr = lowerHigher[1];
        float lowerRt = proposedRts.get(lowerContr.getQuantVO()).floatValue();
        float upperRt = proposedRts.get(upperContr.getQuantVO()).floatValue();
        for (Vector<LipidomicsChromatogram> chroms : chromsForMzs.get(lowerContr.getQuantVO()).values()) {
            chrom = chroms.get(0);
            for (i = 0; i != chrom.Value.length; ++i) {
                if (chrom.Value[i][0] <= lowerRt) {
                    lowerAreaOfLowerContr += chrom.Value[i][1];
                }
                if (!(chrom.Value[i][0] >= upperRt)) continue;
                upperAreaOfLowerContr += chrom.Value[i][1];
            }
        }
        for (Vector<LipidomicsChromatogram> chroms : chromsForMzs.get(upperContr.getQuantVO()).values()) {
            chrom = chroms.get(0);
            for (i = 0; i != chrom.Value.length; ++i) {
                if (chrom.Value[i][0] <= lowerRt) {
                    lowerAreaOfUpperContr += chrom.Value[i][1];
                }
                if (!(chrom.Value[i][0] >= upperRt)) continue;
                upperAreaOfUpperContr += chrom.Value[i][1];
            }
        }
        float upperRatio = upperAreaOfUpperContr / upperAreaOfLowerContr;
        float lowerRatio = lowerAreaOfUpperContr / lowerAreaOfLowerContr;
        if (upperRatio / lowerRatio > 1.5f) {
            ok = true;
        }
        return ok;
    }

    private static SharedPeakContributionVO[] getLowerAndHigherContribution(SharedMS1PeakVO shared, Hashtable<QuantVO, Float> proposedRts) {
        float upperRt;
        Iterator<SharedPeakContributionVO> it = shared.getPartners().iterator();
        SharedPeakContributionVO contr1 = it.next();
        SharedPeakContributionVO contr2 = it.next();
        SharedPeakContributionVO lowerContr = contr1;
        SharedPeakContributionVO upperContr = contr2;
        float lowerRt = proposedRts.get(lowerContr.getQuantVO()).floatValue();
        if (lowerRt > (upperRt = proposedRts.get(upperContr.getQuantVO()).floatValue())) {
            lowerContr = contr2;
            upperContr = contr1;
            lowerRt = proposedRts.get(lowerContr.getQuantVO()).floatValue();
            upperRt = proposedRts.get(upperContr.getQuantVO()).floatValue();
        }
        SharedPeakContributionVO[] lowerHigher = new SharedPeakContributionVO[]{lowerContr, upperContr};
        return lowerHigher;
    }

    public static Hashtable<Integer, Boolean> prepareCachedSpectra(LipidomicsAnalyzer analyzer, LipidParameterSet set, boolean readMSnSpectra) throws CgException {
        if (readMSnSpectra) {
            float tol = LipidomicsConstants.getMs2PrecursorTolerance(set.Mz[0]);
            return analyzer.prepareMSnSpectraCache(set.Mz[0] - tol, set.Mz[0] + tol, LipidomicsConstants.getMs2MinIntsForNoiseRemoval());
        }
        return analyzer.checkMSnLevels();
    }

    private boolean relativeIntensitySplitNecessary(Hashtable<String, Vector<FattyAcidVO>> combiFAs) {
        if (combiFAs.size() < 2) {
            return false;
        }
        if (combiFAs.get(combiFAs.keySet().iterator().next()).size() < 3) {
            return false;
        }
        boolean split = false;
        Vector<String> combis = new Vector<String>(combiFAs.keySet());
        for (int i = 0; i < combis.size(); ++i) {
            Vector<FattyAcidVO> firstFAs = combiFAs.get(combis.get(i));
            for (int j = i + 1; j < combis.size(); ++j) {
                Vector<FattyAcidVO> secondFAs = combiFAs.get(combis.get(j));
                for (FattyAcidVO firstFA : firstFAs) {
                    for (FattyAcidVO secondFA : secondFAs) {
                        if (!firstFA.getChainId().equalsIgnoreCase(secondFA.getChainId())) continue;
                        split = true;
                        break;
                    }
                    if (!split) continue;
                    break;
                }
                if (split) break;
            }
            if (split) break;
        }
        return split;
    }

    private Vector<CgProbe> getCorrespondingCgProbes() {
        if (LipidomicsConstants.isShotgun() == 1) {
            if (this.shotgunProbes_ == null) {
                this.shotgunProbes_ = MSnAnalyzer.getCorrespondingCgProbes(this.set_);
            }
            return this.shotgunProbes_;
        }
        return this.set_.getIsotopicProbes().get(0);
    }

    private static Vector<CgProbe> getCorrespondingCgProbes(LipidParameterSet set) {
        Vector<CgProbe> probes = set.getIsotopicProbes().get(0);
        if (LipidomicsConstants.isShotgun() == 1) {
            probes = new Vector();
            for (CgProbe aProbe : set.getIsotopicProbes().get(0)) {
                CgProbe probe = new CgProbe(aProbe);
                probe.LowerValley = 0.0f;
                probe.UpperValley = Float.MAX_VALUE;
                probes.add(probe);
            }
        }
        return probes;
    }

    private String getStrongestCombination(Hashtable<String, Double> combiAreas) {
        double highest = 0.0;
        String strongest = null;
        for (String combi : combiAreas.keySet()) {
            if (!(combiAreas.get(combi) > highest)) continue;
            highest = combiAreas.get(combi);
            strongest = combi;
        }
        return strongest;
    }
}

