/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.MSnAnalyzer;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.vos.SharedMS1PeakVO;
import at.tugraz.genome.lda.msn.vos.SharedPeakContributionVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.LipidomicsAnalyzer;
import at.tugraz.genome.lda.quantification.LipidomicsChromatogram;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class MSnPeakSeparator {
    private Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> result_ = new Hashtable();
    private LipidomicsAnalyzer analyzer_;
    private int msLevel_;
    private Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> peaksBeforeSplit_;
    private Set<String> adductsThatRequireOtherAdduct_;

    public MSnPeakSeparator(Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant, Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> peaksBeforeSplit, LipidomicsAnalyzer analyzer, int msLevel, Set<String> adductsThatRequireOtherAdduct) {
        for (QuantVO quant : hitsAccordingToQuant.keySet()) {
            this.result_.put(quant, new Hashtable(hitsAccordingToQuant.get(quant)));
        }
        this.analyzer_ = analyzer;
        this.msLevel_ = msLevel;
        this.peaksBeforeSplit_ = peaksBeforeSplit;
        this.adductsThatRequireOtherAdduct_ = adductsThatRequireOtherAdduct;
    }

    public Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> disentagleSharedMS1Peaks() throws CgException, LipidCombinameEncodingException {
        int i;
        int i2;
        SharedMS1PeakVO shared;
        Vector<SharedMS1PeakVO> sharedPeaks = MSnPeakSeparator.detectSharedMS1PeakInstances(this.result_);
        Vector<Integer> sharedToRemove = new Vector<Integer>();
        for (int i22 = 0; i22 != sharedPeaks.size(); ++i22) {
            shared = sharedPeaks.get(i22);
            if (!shared.areAnyOfTheseAdductsPresent(this.adductsThatRequireOtherAdduct_)) continue;
            sharedToRemove.add(i22);
        }
        for (i2 = sharedToRemove.size() - 1; i2 != -1; --i2) {
            sharedPeaks.remove((Integer)sharedToRemove.get(i2));
        }
        sharedToRemove = new Vector();
        for (i2 = 0; i2 != sharedPeaks.size(); ++i2) {
            shared = sharedPeaks.get(i2);
            shared.checkForDistinctFragments();
            if (shared.hasAnyPartnerDistinctFragments()) {
                this.removeDetectionsWhereDistinctFragmentsAreMissing(shared, this.result_);
                if (shared.getPartners().size() == 1) {
                    this.recheckMS2HitWithoutIsobar(shared, this.result_, this.analyzer_);
                    sharedToRemove.add(i2);
                } else {
                    int previousPartnerSize = shared.getPartners().size() + 1;
                    while (previousPartnerSize > shared.getPartners().size()) {
                        previousPartnerSize = shared.getPartners().size();
                        shared.checkForDistinctFragments();
                        this.removeDetectionsWhereSpectrumCoverageWithoutSharedIsToLow(shared, this.result_, this.analyzer_);
                    }
                    if (shared.getPartners().size() == 1) {
                        this.recheckMS2HitWithoutIsobar(shared, this.result_, this.analyzer_);
                        sharedToRemove.add(i2);
                    }
                }
            }
            if (shared.hasAnyPartnerDistinctFragments()) continue;
            boolean chooseOneByRt = shared.haveAllChooseOnRtSetToTrue();
            for (SharedPeakContributionVO contr : shared.getPartners()) {
                contr.getSet().setPercentalSplit(100.0f);
                if (!chooseOneByRt) continue;
                contr.getSet().setChoseMoreLikelyRtWhenEqualMSn(true);
            }
            sharedToRemove.add(i2);
            if (shared.getPartners().size() <= 0) continue;
            this.checkIfAllPartnerFragmentsFulfillSpectrumCoverage(shared, this.result_, this.analyzer_);
        }
        for (i2 = sharedToRemove.size() - 1; i2 != -1; --i2) {
            sharedPeaks.remove((Integer)sharedToRemove.get(i2));
        }
        float relIsobarSpecCovExclusion = LipidomicsConstants.getMs2IsobarSCExclusionRatio();
        sharedToRemove = new Vector();
        for (int i3 = 0; i3 != sharedPeaks.size(); ++i3) {
            SharedMS1PeakVO shared2 = sharedPeaks.get(i3);
            Vector<SharedPeakContributionVO> contributions = new Vector<SharedPeakContributionVO>(shared2.getPartners());
            for (int j = 0; j != contributions.size(); ++j) {
                SharedPeakContributionVO contr = contributions.get(j);
                float exclValue = relIsobarSpecCovExclusion;
                try {
                    String cutoff = RulesContainer.getIsobarExclusionRatio(StaticUtils.getRuleName(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getModName()));
                    if (cutoff != null) {
                        exclValue = Float.parseFloat(cutoff);
                    }
                }
                catch (NoRuleException cutoff) {
                }
                catch (RulesException | SpectrummillParserException | IOException e) {
                    e.printStackTrace();
                }
                if (!shared2.isSpectrumContributionMuchLower(exclValue, contr)) continue;
                this.removePartner(contr, shared2, this.result_);
                if (shared2.getPartners().size() != 1) continue;
                this.recheckMS2HitWithoutIsobar(shared2, this.result_, this.analyzer_);
                sharedToRemove.add(i3);
            }
        }
        Hashtable<Integer, Integer> removed = new Hashtable<Integer, Integer>();
        for (int i4 = sharedToRemove.size() - 1; i4 != -1; --i4) {
            int index = (Integer)sharedToRemove.get(i4);
            if (removed.containsKey(index)) continue;
            sharedPeaks.remove(index);
            removed.put(index, index);
        }
        if (LipidomicsConstants.isShotgun() == 1) {
            for (SharedMS1PeakVO shared3 : sharedPeaks) {
                this.calculatePercentualSplitValueAccordingToMSn(shared3);
                for (SharedPeakContributionVO contr : shared3.getPartners()) {
                    this.result_.get(contr.getQuantVO()).put("", contr.getSet());
                }
            }
            return this.result_;
        }
        Vector<SharedMS1PeakVO> sortedSharedPeaks = new Vector<SharedMS1PeakVO>();
        Hashtable<Integer, Boolean> disentangledPeaks = new Hashtable<Integer, Boolean>();
        sharedToRemove = new Vector();
        for (SharedMS1PeakVO shared4 : sharedPeaks) {
            double rt2;
            double rt1 = Double.parseDouble(shared4.getPartners().get(0).getSet().getRt());
            int count = 0;
            for (int i5 = 0; i5 != sortedSharedPeaks.size() && !(rt1 < (rt2 = Double.parseDouble(((SharedMS1PeakVO)sortedSharedPeaks.get(i5)).getPartners().get(0).getSet().getRt()))); ++i5) {
                ++count;
            }
            if (count == sortedSharedPeaks.size()) {
                sortedSharedPeaks.add(shared4);
            } else {
                sortedSharedPeaks.add(count, shared4);
            }
            disentangledPeaks.put(sortedSharedPeaks.size() - 1, false);
        }
        float minRtDifference = LipidomicsConstants.getMs2IsobaricOtherRtDifference();
        float relIsobarFarAreaSpecCovExclusion = LipidomicsConstants.getMs2IsobarSCFarExclusionRatio();
        Hashtable<QuantVO, Hashtable> checkedSets = new Hashtable<QuantVO, Hashtable>();
        for (i = 0; i != sharedPeaks.size(); ++i) {
            SharedMS1PeakVO shared5 = sharedPeaks.get(i);
            Vector<SharedPeakContributionVO> contributions = new Vector<SharedPeakContributionVO>(shared5.getPartners());
            for (int j = 0; j != contributions.size(); ++j) {
                Object uniqueAndShared;
                SharedPeakContributionVO contr = contributions.get(j);
                float exclValue = relIsobarFarAreaSpecCovExclusion;
                float rtDiff = minRtDifference;
                try {
                    String cutoff = RulesContainer.getIsobarFarExclusionRatio(StaticUtils.getRuleName(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getModName()));
                    if (cutoff != null) {
                        exclValue = Float.parseFloat(cutoff);
                    }
                    if ((cutoff = RulesContainer.getIsobarFarRtDifference(StaticUtils.getRuleName(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getModName()))) != null) {
                        rtDiff = Float.parseFloat(cutoff);
                    }
                }
                catch (NoRuleException cutoff) {
                }
                catch (RulesException | SpectrummillParserException | IOException e) {
                    e.printStackTrace();
                }
                if (disentangledPeaks.containsKey(i) && ((Boolean)disentangledPeaks.get(i)).booleanValue()) continue;
                Hashtable checked = new Hashtable();
                if (checkedSets.containsKey(contr.getQuantVO())) {
                    checked = (Hashtable)checkedSets.get(contr.getQuantVO());
                }
                if (checked.containsKey(j)) continue;
                checked.put(j, true);
                checkedSets.put(contr.getQuantVO(), checked);
                if (!this.result_.containsKey(contr.getQuantVO()) || ((Vector)(uniqueAndShared = this.getUniqueAndSharedContributions(i, sharedPeaks, disentangledPeaks, contr, this.result_.get(contr.getQuantVO())))).size() < 2 || ((Vector)((Vector)uniqueAndShared).get(0)).size() == 0) continue;
                Vector uniques = (Vector)((Vector)uniqueAndShared).get(0);
                Vector sharedInsts = (Vector)((Vector)uniqueAndShared).get(1);
                int direction = this.detectDirectionOfUniqueHits(Double.parseDouble(contr.getSet().getRt()), uniques);
                if (direction == 0) continue;
                if (direction > 0) {
                    Vector<Integer> otherSharedDesc = this.getSharedDescendingOrder(j, sharedInsts);
                    for (Integer n : otherSharedDesc) {
                        if (disentangledPeaks.containsKey(n) && disentangledPeaks.get(n).booleanValue()) continue;
                        SharedMS1PeakVO other = sharedPeaks.get(n);
                        for (SharedPeakContributionVO otherContr : new Vector<SharedPeakContributionVO>(other.getPartners())) {
                            Vector otherUniqueAndShared;
                            if (disentangledPeaks.containsKey(n) && disentangledPeaks.get(n).booleanValue() || !otherContr.getQuantVO().equals(contr) || checked.containsKey(n)) continue;
                            checked.put(n, true);
                            if (!this.result_.containsKey(otherContr.getQuantVO()) || (otherUniqueAndShared = this.getUniqueAndSharedContributions(n, sharedPeaks, disentangledPeaks, otherContr, this.result_.get(otherContr.getQuantVO()))).size() < 2 || ((Vector)otherUniqueAndShared.get(0)).size() == 0) continue;
                            Vector otherUniques = (Vector)((Vector)uniqueAndShared).get(0);
                            int otherDirection = this.detectDirectionOfUniqueHits(Double.parseDouble(otherContr.getSet().getRt()), otherUniques);
                            if (otherDirection != direction || !this.isSufficentlyFarAway(rtDiff, otherContr, otherUniques) || !other.isSpectrumContributionMuchLower(exclValue, otherContr)) continue;
                            this.removePartner(otherContr, other, this.result_);
                            if (other.getPartners().size() != 1) continue;
                            this.recheckMS2HitWithoutIsobar(other, this.result_, this.analyzer_);
                            sharedToRemove.add(i);
                            disentangledPeaks.put(n, true);
                        }
                    }
                    if (!this.result_.containsKey(contr.getQuantVO())) continue;
                    uniques = (Vector)this.getUniqueAndSharedContributions(i, sharedPeaks, disentangledPeaks, contr, this.result_.get(contr.getQuantVO())).get(0);
                }
                if (!this.isSufficentlyFarAway(rtDiff, contr, uniques) || !shared5.isSpectrumContributionMuchLower(exclValue, contr)) continue;
                this.removePartner(contr, shared5, this.result_);
                if (shared5.getPartners().size() != 1) continue;
                this.recheckMS2HitWithoutIsobar(shared5, this.result_, this.analyzer_);
                sharedToRemove.add(i);
                disentangledPeaks.put(i, true);
            }
        }
        Collections.sort(sharedToRemove);
        removed = new Hashtable();
        for (i = sharedToRemove.size() - 1; i != -1; --i) {
            int index = (Integer)sharedToRemove.get(i);
            if (removed.containsKey(index)) continue;
            sharedPeaks.remove(index);
            removed.put(index, index);
        }
        float percentForBordersAbsolute = 5.0f;
        float percentForBordersRelative = 10.0f;
        LipidomicsChromatogram chrom = null;
        if (sharedPeaks.size() > 0) {
            QuantVO quant = sharedPeaks.iterator().next().getPartners().get(0).getQuantVO();
            chrom = this.analyzer_.readOneChromatogram((float)quant.getAnalyteMass(), this.msLevel_);
        }
        for (SharedMS1PeakVO shared6 : sharedPeaks) {
            float start = Float.MAX_VALUE;
            float stop = 0.0f;
            Vector<LipidParameterSet> sets = new Vector<LipidParameterSet>();
            for (SharedPeakContributionVO contr : shared6.getPartners()) {
                sets.add(contr.getSet());
            }
            float[] borders = this.analyzer_.calculatePercentualBorders(percentForBordersAbsolute, chrom, sets);
            start = borders[0];
            stop = borders[1];
            float[] bordersRelative = this.analyzer_.calculatePercentualBorders(percentForBordersRelative, chrom, sets);
            float startRelative = bordersRelative[0];
            float stopRelative = bordersRelative[1];
            String classes = "";
            String rts = "";
            for (SharedPeakContributionVO partner : shared6.getPartners()) {
                classes = classes + partner.getQuantVO().getAnalyteClass() + "_" + partner.getSet().getNameString() + "-";
                rts = rts + partner.getSet().getRt() + "/";
            }
            classes = classes.substring(0, classes.length() - 1);
            rts = rts.substring(0, rts.length() - 1);
            if (shared6.getPartners().size() == 2 && this.analyzer_.countMSnSpectraOfRegion(start, stop, 2) > 1) {
                Vector<SharedPeakContributionVO> vector = MSnAnalyzer.splitTwoIsobaricPeaks(this.analyzer_, start, stop, startRelative, stopRelative, shared6, this.msLevel_);
                float zeroIsoAreaOne = 0.0f;
                float zeroIsoAreaTwo = 0.0f;
                if (vector != null && vector.size() == 2) {
                    if (vector.get(0).getSet() != null && vector.get(0).getSet().getIsotopicProbes() != null && vector.get(0).getSet().getIsotopicProbes().size() > 0) {
                        for (CgProbe probe : vector.get(0).getSet().getIsotopicProbes().get(0)) {
                            zeroIsoAreaOne += probe.Area;
                        }
                    }
                    if (vector.get(1).getSet() != null && vector.get(1).getSet().getIsotopicProbes() != null && vector.get(1).getSet().getIsotopicProbes().size() > 0) {
                        for (CgProbe probe : vector.get(1).getSet().getIsotopicProbes().get(0)) {
                            zeroIsoAreaTwo += probe.Area;
                        }
                    }
                }
                if (vector != null && vector.size() == 2 && zeroIsoAreaOne > 0.0f && zeroIsoAreaTwo > 0.0f) {
                    if (vector.get(0).getSet() != null) {
                        this.result_.get(vector.get(0).getQuantVO()).put(vector.get(0).getSet().getRt(), vector.get(0).getSet());
                        this.peaksBeforeSplit_.get(vector.get(0).getQuantVO()).put(vector.get(0).getSet().getRt(), vector.get(0).getOldSet());
                    }
                    if (vector.get(1).getSet() == null) continue;
                    this.result_.get(vector.get(1).getQuantVO()).put(vector.get(1).getSet().getRt(), vector.get(1).getSet());
                    this.peaksBeforeSplit_.get(vector.get(1).getQuantVO()).put(vector.get(1).getSet().getRt(), vector.get(1).getOldSet());
                    continue;
                }
                this.calculatePercentualSplitValueAccordingToMSn(shared6);
                for (SharedPeakContributionVO contr : shared6.getPartners()) {
                    this.result_.get(contr.getQuantVO()).put(contr.getSet().getRt(), contr.getSet());
                }
                continue;
            }
            this.calculatePercentualSplitValueAccordingToMSn(shared6);
            for (SharedPeakContributionVO contr : shared6.getPartners()) {
                this.result_.get(contr.getQuantVO()).put(contr.getSet().getRt(), contr.getSet());
            }
        }
        return this.result_;
    }

    public static Vector<SharedMS1PeakVO> detectSharedMS1PeakInstances(Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant) {
        Vector<SharedMS1PeakVO> sharedPeaks = new Vector<SharedMS1PeakVO>();
        Vector<QuantVO> quants = new Vector<QuantVO>(hitsAccordingToQuant.keySet());
        Hashtable<Integer, Hashtable> alreadyAdded = new Hashtable<Integer, Hashtable>();
        for (int i1 = 0; i1 != quants.size(); ++i1) {
            QuantVO quant1 = quants.get(i1);
            Hashtable<String, LipidParameterSet> hits1 = hitsAccordingToQuant.get(quant1);
            Hashtable added = new Hashtable();
            if (alreadyAdded.containsKey(i1)) {
                added = (Hashtable)alreadyAdded.get(i1);
            }
            for (String rt1 : hits1.keySet()) {
                if (added.containsKey(rt1)) continue;
                LipidParameterSet set1 = hits1.get(rt1);
                SharedMS1PeakVO sharedPeak = new SharedMS1PeakVO();
                sharedPeak.addSharedInstance(quant1, set1);
                boolean otherAdded = false;
                for (int i2 = i1 + 1; i2 < quants.size(); ++i2) {
                    Hashtable added2 = new Hashtable();
                    if (alreadyAdded.containsKey(i2)) {
                        added2 = (Hashtable)alreadyAdded.get(i2);
                    }
                    QuantVO quant2 = quants.get(i2);
                    Hashtable<String, LipidParameterSet> hits2 = hitsAccordingToQuant.get(quant2);
                    for (String rt2 : hits2.keySet()) {
                        if (added2.containsKey(rt2)) continue;
                        LipidParameterSet set2 = hits2.get(rt2);
                        if (!rt1.equalsIgnoreCase(rt2) && !LipidomicsAnalyzer.isPeakCenterTheSame(set1, set2)) continue;
                        sharedPeak.addSharedInstance(quant2, set2);
                        otherAdded = true;
                        added2.put(rt2, rt2);
                    }
                    alreadyAdded.put(i2, added2);
                }
                if (!otherAdded || !sharedPeak.areThereMS2Hits()) continue;
                sharedPeaks.add(sharedPeak);
                added.put(rt1, rt1);
                alreadyAdded.put(i1, added);
            }
        }
        return sharedPeaks;
    }

    private void removeDetectionsWhereDistinctFragmentsAreMissing(SharedMS1PeakVO shared, Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant) {
        Vector<Integer> partnersToRemove = new Vector<Integer>();
        Vector<SharedPeakContributionVO> partners = shared.getPartners();
        for (int i = 0; i != partners.size(); ++i) {
            SharedPeakContributionVO partner = partners.get(i);
            if (partner.hasDistinctFragments()) continue;
            Hashtable<String, LipidParameterSet> sets = hitsAccordingToQuant.get(partner.getQuantVO());
            String rt = "";
            if (LipidomicsConstants.isShotgun() != 1) {
                rt = partner.getSet().getRt();
            }
            sets.remove(rt);
            if (sets.size() == 0) {
                hitsAccordingToQuant.remove(partner.getQuantVO());
            }
            partnersToRemove.add(i);
        }
        shared.removePartners(partnersToRemove);
    }

    private void removePartner(SharedPeakContributionVO contr, SharedMS1PeakVO shared, Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant) {
        Vector<Integer> partnersToRemove = new Vector<Integer>();
        Vector<SharedPeakContributionVO> partners = shared.getPartners();
        for (int i = 0; i != partners.size(); ++i) {
            SharedPeakContributionVO partner = partners.get(i);
            if (!partner.getQuantVO().equals(contr.getQuantVO())) continue;
            Hashtable<String, LipidParameterSet> sets = hitsAccordingToQuant.get(partner.getQuantVO());
            String rt = "";
            if (LipidomicsConstants.isShotgun() != 1) {
                rt = partner.getSet().getRt();
            }
            sets.remove(rt);
            if (sets.size() == 0) {
                hitsAccordingToQuant.remove(partner.getQuantVO());
            }
            partnersToRemove.add(i);
        }
        shared.removePartners(partnersToRemove);
    }

    private void recheckMS2HitWithoutIsobar(SharedMS1PeakVO shared, Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant, LipidomicsAnalyzer analyzer) throws CgException {
        for (SharedPeakContributionVO contr : shared.getPartners()) {
            QuantVO oneSet = contr.getQuantVO();
            Hashtable<String, LipidParameterSet> quantsOfMod = hitsAccordingToQuant.get(oneSet);
            try {
                MSnAnalyzer msnAnalyzer;
                String rt = "";
                if (LipidomicsConstants.isShotgun() != 1) {
                    rt = contr.getSet().getRt();
                }
                if ((msnAnalyzer = new MSnAnalyzer(oneSet.getAnalyteClass(), oneSet.getModName(), contr.getSet(), analyzer, oneSet, true, false)).checkStatus() == 1) {
                    quantsOfMod.remove(rt);
                    continue;
                }
                quantsOfMod.put(rt, msnAnalyzer.getResult());
            }
            catch (ChemicalFormulaException | HydroxylationEncodingException | LipidCombinameEncodingException | RulesException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SpectrummillParserException e) {
                e.printStackTrace();
            }
        }
    }

    private void removeDetectionsWhereSpectrumCoverageWithoutSharedIsToLow(SharedMS1PeakVO shared, Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant, LipidomicsAnalyzer analyzer) {
        Vector<Integer> partnersToRemove = new Vector<Integer>();
        for (int i = 0; i != shared.getPartners().size(); ++i) {
            SharedPeakContributionVO contr = shared.getPartners().get(i);
            boolean remove = false;
            try {
                MSnAnalyzer.prepareCachedSpectra(analyzer, contr.getSet(), true);
                float bpCutoff = (float)RulesContainer.getBasePeakCutoff(StaticUtils.getRuleName(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getModName()));
                float coverage = (float)RulesContainer.getSpectrumCoverageMin(StaticUtils.getRuleName(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getModName()));
                if (!MSnAnalyzer.isSpectrumCovered(analyzer, contr.getSet(), contr.getMsLevels(), new Vector<CgProbe>(contr.getFoundFragments().values()), new Vector<CgProbe>(contr.getFragsFromOthers().values()), bpCutoff, coverage)) {
                    remove = true;
                }
            }
            catch (NoRuleException | RulesException | SpectrummillParserException | CgException | IOException e) {
                e.printStackTrace();
                remove = true;
            }
            if (!remove) continue;
            String rt = "";
            if (LipidomicsConstants.isShotgun() != 1) {
                rt = contr.getSet().getRt();
            }
            hitsAccordingToQuant.get(contr.getQuantVO()).remove(rt);
            partnersToRemove.add(i);
        }
        shared.removePartners(partnersToRemove);
    }

    private void checkIfAllPartnerFragmentsFulfillSpectrumCoverage(SharedMS1PeakVO shared, Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant, LipidomicsAnalyzer analyzer) {
        try {
            Vector<CgProbe> allFragments = new Vector<CgProbe>();
            for (int i = 0; i != shared.getPartners().size(); ++i) {
                SharedPeakContributionVO contr = shared.getPartners().get(i);
                if (!(contr.getSet() instanceof LipidomicsMSnSet)) continue;
                allFragments.addAll(contr.getFoundFragments().values());
                allFragments.addAll(contr.getFragsFromOthers().values());
                break;
            }
            float minCutoff = 1.0f;
            float lowestCov = 1.0f;
            Hashtable<Integer, Boolean> msLevels = new Hashtable<Integer, Boolean>();
            for (int i = 0; i != shared.getPartners().size(); ++i) {
                SharedPeakContributionVO contr = shared.getPartners().get(i);
                if (!(contr.getSet() instanceof LipidomicsMSnSet)) continue;
                String className = contr.getQuantVO().getAnalyteClass();
                String modName = contr.getQuantVO().getModName();
                float bpCutoff = (float)RulesContainer.getBasePeakCutoff(StaticUtils.getRuleName(className, modName));
                float coverage = (float)RulesContainer.getSpectrumCoverageMin(StaticUtils.getRuleName(className, modName));
                if (bpCutoff < minCutoff) {
                    minCutoff = bpCutoff;
                }
                if (coverage < lowestCov) {
                    lowestCov = coverage;
                }
                for (Integer level : contr.getMsLevels().keySet()) {
                    if (!contr.getMsLevels().get(level).booleanValue()) continue;
                    msLevels.put(level, true);
                }
            }
            SharedPeakContributionVO contr = null;
            for (SharedPeakContributionVO contr1 : shared.getPartners()) {
                if (!(contr1.getSet() instanceof LipidomicsMSnSet)) continue;
                contr = contr1;
                break;
            }
            MSnAnalyzer.prepareCachedSpectra(analyzer, contr.getSet(), true);
            if (!MSnAnalyzer.isSpectrumCovered(analyzer, contr.getSet(), msLevels, allFragments, new Vector<CgProbe>(), minCutoff, lowestCov)) {
                for (int i = 0; i != shared.getPartners().size(); ++i) {
                    SharedPeakContributionVO cont = shared.getPartners().get(i);
                    if (!(cont.getSet() instanceof LipidomicsMSnSet)) continue;
                    String rt = "";
                    if (LipidomicsConstants.isShotgun() != 1) {
                        rt = cont.getSet().getRt();
                    }
                    hitsAccordingToQuant.get(cont.getQuantVO()).remove(rt);
                }
            }
        }
        catch (NoRuleException | RulesException | SpectrummillParserException | CgException | IOException e) {
            e.printStackTrace();
        }
    }

    private Vector getUniqueAndSharedContributions(int currentSharedPeak, Vector<SharedMS1PeakVO> sharedPeaks, Hashtable<Integer, Boolean> disentangledPeaks, SharedPeakContributionVO contr, Hashtable<String, LipidParameterSet> rtHits) {
        Vector<Vector<Object>> results = new Vector<Vector<Object>>();
        Vector<LipidParameterSet> uniqueContributionsOfSpecies = this.areThereUniqueContributions(currentSharedPeak, sharedPeaks, disentangledPeaks, contr, rtHits);
        results.add(uniqueContributionsOfSpecies);
        if (uniqueContributionsOfSpecies.size() > 0) {
            results.add(this.getOtherSharedContributions(currentSharedPeak, sharedPeaks, disentangledPeaks, contr.getQuantVO()));
        }
        return results;
    }

    private Vector<LipidParameterSet> areThereUniqueContributions(int currentSharedPeak, Vector<SharedMS1PeakVO> sharedPeaks, Hashtable<Integer, Boolean> disentangledPeaks, SharedPeakContributionVO contr, Hashtable<String, LipidParameterSet> rtHits) {
        Vector<LipidParameterSet> uniqueOnes = new Vector<LipidParameterSet>();
        for (int i = 0; i != sharedPeaks.size(); ++i) {
            if (i == currentSharedPeak || !disentangledPeaks.get(i).booleanValue()) continue;
            uniqueOnes.add(sharedPeaks.get(i).getPartners().get(0).getSet());
        }
        for (String rt : rtHits.keySet()) {
            LipidParameterSet set = rtHits.get(rt);
            if (!(set instanceof LipidomicsMSnSet) || this.isHitASharedObject(contr.getQuantVO(), set, sharedPeaks)) continue;
            uniqueOnes.add(set);
        }
        return uniqueOnes;
    }

    private boolean isHitASharedObject(QuantVO anal, LipidParameterSet set, Vector<SharedMS1PeakVO> sharedPeaks) {
        for (SharedMS1PeakVO shared : sharedPeaks) {
            for (SharedPeakContributionVO contr : shared.getPartners()) {
                QuantVO other = contr.getQuantVO();
                if (!anal.equals(other) || !set.getRt().equalsIgnoreCase(contr.getSet().getRt())) continue;
                return true;
            }
        }
        return false;
    }

    private Vector<Integer> getOtherSharedContributions(int currentSharedPeak, Vector<SharedMS1PeakVO> sharedPeaks, Hashtable<Integer, Boolean> disentangledPeaks, QuantVO anal) {
        Vector<Integer> otherShared = new Vector<Integer>();
        block0: for (int i = 0; i != sharedPeaks.size(); ++i) {
            if (i == currentSharedPeak || disentangledPeaks.containsKey(i) && disentangledPeaks.get(i).booleanValue()) continue;
            for (SharedPeakContributionVO contr : sharedPeaks.get(i).getPartners()) {
                if (!contr.getQuantVO().equals(anal)) continue;
                otherShared.add(i);
                continue block0;
            }
        }
        return otherShared;
    }

    private int detectDirectionOfUniqueHits(double rt, Vector<LipidParameterSet> sets) {
        int dir = 0;
        for (int i = 0; i != sets.size(); ++i) {
            double other = Double.parseDouble(sets.get(i).getRt());
            if (i == 0) {
                if (other > rt) {
                    dir = 1;
                    continue;
                }
                dir = -1;
                continue;
            }
            if (dir == 1) {
                if (!(other < rt)) continue;
                dir = 0;
                break;
            }
            if (!(other > rt)) continue;
            dir = 0;
            break;
        }
        return dir;
    }

    private Vector<Integer> getSharedDescendingOrder(int currentIndex, Vector<Integer> sharedInsts) {
        Vector<Integer> descending = new Vector<Integer>();
        for (Integer sharedIndex : sharedInsts) {
            if (sharedIndex <= currentIndex) continue;
            int count = 0;
            for (int i = 0; i != descending.size() && descending.get(i) >= sharedIndex; ++i) {
                ++count;
            }
            if (count == descending.size()) {
                descending.add(sharedIndex);
                continue;
            }
            descending.add(count, sharedIndex);
        }
        return descending;
    }

    private boolean isSufficentlyFarAway(float minRt, SharedPeakContributionVO contr, Vector<LipidParameterSet> uniques) {
        boolean isOK = true;
        float rt = Float.parseFloat(contr.getSet().getRt());
        for (LipidParameterSet set : uniques) {
            float otherRt = Float.parseFloat(set.getRt());
            if (!(Math.abs(rt - otherRt) < minRt)) continue;
            isOK = false;
            break;
        }
        return isOK;
    }

    private void calculatePercentualSplitValueAccordingToMSn(SharedMS1PeakVO shared) {
        float sum = 0.0f;
        Hashtable<QuantVO, Float> contrSums = new Hashtable<QuantVO, Float>();
        for (SharedPeakContributionVO contr : shared.getPartners()) {
            if (contr.getOldSet() != null) {
                contr.setSet(contr.getOldSet());
            }
            float contrSum = 0.0f;
            for (CgProbe fragment : contr.getDistinctFragments().values()) {
                contrSum += fragment.Area;
            }
            contrSums.put(contr.getQuantVO(), Float.valueOf(contrSum));
            sum += contrSum;
        }
        for (SharedPeakContributionVO contr : shared.getPartners()) {
            contr.getSet().setPercentalSplit(((Float)contrSums.get(contr.getQuantVO())).floatValue() * 100.0f / sum);
        }
    }

    public Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> getPeaksBeforeSplit() {
        return this.peaksBeforeSplit_;
    }
}

