/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.MSnAnalyzer;
import at.tugraz.genome.lda.msn.MSnPeakSeparator;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.LipidomicsAnalyzer;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;

public class OtherAdductChecker {
    private static final String SEP = "<->";

    public static Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> checkTheResultsForOtherAdducts(Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> results, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> unsplittedPeaks, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects, LipidomicsAnalyzer analyzer, LinkedHashMap<String, Integer> classSequence, LinkedHashMap<String, Vector<String>> analyteSequence) throws CgException, LipidCombinameEncodingException {
        String ruleName;
        Hashtable<String, Boolean> requiresOtherAdducts = new Hashtable<String, Boolean>();
        Hashtable<String, Vector<String>> otherRequiredAdducts = new Hashtable<String, Vector<String>>();
        Hashtable<String, Boolean> allOtherAdductsRequired = new Hashtable<String, Boolean>();
        Hashtable<String, Float> timeTolerance = new Hashtable<String, Float>();
        boolean forceAdductValidity = false;
        Hashtable<String, LipidParameterSet> correct = new Hashtable<String, LipidParameterSet>();
        Hashtable<String, LipidParameterSet> toRemove = new Hashtable<String, LipidParameterSet>();
        Hashtable<String, String> interestingQuantVOs = new Hashtable<String, String>();
        Hashtable<String, Boolean> affectedMods = new Hashtable<String, Boolean>();
        for (String lipidClass : results.keySet()) {
            for (String string : results.get(lipidClass).keySet()) {
                for (String mod : results.get(lipidClass).get(string).keySet()) {
                    boolean requiresOther = false;
                    ruleName = StaticUtils.getRuleName(lipidClass, mod);
                    try {
                        if (!RulesContainer.requiresOtherValidAdduct(ruleName)) continue;
                        requiresOther = true;
                        requiresOtherAdducts.put(ruleName, requiresOther);
                        otherRequiredAdducts.put(ruleName, RulesContainer.getOtherRequiredAdducts(ruleName));
                        allOtherAdductsRequired.put(ruleName, RulesContainer.areAllOtherAdductsRequired(ruleName));
                        timeTolerance.put(ruleName, Float.valueOf(RulesContainer.getOtherTimeTolerance(ruleName)));
                        forceAdductValidity = RulesContainer.forceOtherAdductValidity(ruleName);
                        affectedMods.put(ruleName, forceAdductValidity);
                    }
                    catch (NoRuleException noRuleException) {
                    }
                    catch (RulesException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (SpectrummillParserException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (String lipidClass : results.keySet()) {
            for (String string : results.get(lipidClass).keySet()) {
                for (String mod : results.get(lipidClass).get(string).keySet()) {
                    ruleName = StaticUtils.getRuleName(lipidClass, mod);
                    Hashtable<String, LipidParameterSet> sameMod = results.get(lipidClass).get(string).get(mod);
                    if (!requiresOtherAdducts.containsKey(ruleName) || !((Boolean)requiresOtherAdducts.get(ruleName)).booleanValue()) continue;
                    for (String rt : sameMod.keySet()) {
                        boolean oneFound = false;
                        boolean allFound = true;
                        for (String otherMod : (Vector)otherRequiredAdducts.get(ruleName)) {
                            if (OtherAdductChecker.isOtherModPresentInResults(lipidClass, string, otherMod, rt, ((Float)timeTolerance.get(ruleName)).floatValue(), results)) {
                                oneFound = true;
                                continue;
                            }
                            allFound = false;
                        }
                        String quantId = OtherAdductChecker.getUniqueId(lipidClass, string, mod, "");
                        interestingQuantVOs.put(quantId, quantId);
                        if (oneFound && (!((Boolean)allOtherAdductsRequired.get(ruleName)).booleanValue() || allFound)) {
                            correct.put(OtherAdductChecker.getUniqueId(lipidClass, string, mod, rt), sameMod.get(rt));
                            continue;
                        }
                        toRemove.put(OtherAdductChecker.getUniqueId(lipidClass, string, mod, rt), sameMod.get(rt));
                    }
                }
            }
        }
        for (String lClass : classSequence.keySet()) {
            for (String analyte : analyteSequence.get(lClass)) {
                for (String mod : quantObjects.get(lClass).get(analyte).keySet()) {
                    QuantVO quantSet = quantObjects.get(lClass).get(analyte).get(mod);
                    if (quantSet.isQuantifiedByOtherIsobar()) continue;
                    Vector<QuantVO> allQuants = new Vector<QuantVO>();
                    boolean isAffected = false;
                    allQuants.add(quantSet);
                    allQuants.addAll(quantSet.getOtherIsobaricSpecies());
                    for (QuantVO one : allQuants) {
                        if (!affectedMods.containsKey(StaticUtils.getRuleName(one.getAnalyteClass(), one.getModName())) || !interestingQuantVOs.containsKey(OtherAdductChecker.getUniqueId(one.getAnalyteClass(), StaticUtils.generateLipidNameString(one.getAnalyteName(), (Integer)one.getDbs(), -1, one.getOxState()), mod, ""))) continue;
                        isAffected = true;
                    }
                    if (!isAffected) continue;
                    Hashtable<String, Hashtable<String, LipidParameterSet>> sameRt = OtherAdductChecker.getGroupsOfSameRt(allQuants, results);
                    for (String rt : sameRt.keySet()) {
                        LipidParameterSet set;
                        String uniqueId;
                        String lipClass;
                        Hashtable<String, LipidParameterSet> same = sameRt.get(rt);
                        if (same.size() < 2) continue;
                        Hashtable<String, LipidParameterSet> force = new Hashtable<String, LipidParameterSet>();
                        boolean ms2InformationPresent = false;
                        for (String string : same.keySet()) {
                            LipidParameterSet set3 = same.get(string);
                            lipClass = string.substring(0, string.indexOf("_"));
                            if (set3 instanceof LipidomicsMSnSet) {
                                ms2InformationPresent = true;
                            }
                            if (!affectedMods.containsKey(string) || !((Boolean)affectedMods.get(string)).booleanValue() || !correct.containsKey(uniqueId = OtherAdductChecker.getUniqueId(lipClass, set3.getNameStringWithoutRt(), set3.getModificationName(), rt))) continue;
                            force.put(uniqueId, set3);
                        }
                        Hashtable<String, LipidParameterSet> forSplit = new Hashtable<String, LipidParameterSet>();
                        if (force.size() > 0) {
                            forSplit = force;
                            for (String rule : same.keySet()) {
                                LipidParameterSet set2;
                                lipClass = rule.substring(0, rule.indexOf("_"));
                                uniqueId = OtherAdductChecker.getUniqueId(lipClass, (set2 = same.get(rule)).getNameStringWithoutRt(), set2.getModificationName(), rt);
                                if (forSplit.containsKey(uniqueId)) continue;
                                toRemove.put(uniqueId, set2);
                            }
                        } else {
                            for (String rule : same.keySet()) {
                                LipidParameterSet set2;
                                lipClass = rule.substring(0, rule.indexOf("_"));
                                uniqueId = OtherAdductChecker.getUniqueId(lipClass, (set2 = same.get(rule)).getNameStringWithoutRt(), set2.getModificationName(), rt);
                                if (toRemove.containsKey(uniqueId)) continue;
                                forSplit.put(uniqueId, set2);
                            }
                        }
                        if (!ms2InformationPresent) continue;
                        if (forSplit.size() < 2) {
                            if (forSplit.size() != 1) continue;
                            String string = (String)forSplit.keySet().iterator().next();
                            String lipClass2 = OtherAdductChecker.getLipidClassFromUniqueId(string);
                            LipidParameterSet set4 = (LipidParameterSet)forSplit.get(string);
                            Object quant = null;
                            for (QuantVO one : allQuants) {
                                if (!lipClass2.equalsIgnoreCase(one.getAnalyteClass()) || !set4.getNameStringWithoutRt().equalsIgnoreCase(one.getIdString()) || !set4.getModificationName().equalsIgnoreCase(one.getModName())) continue;
                                quant = one;
                                break;
                            }
                            try {
                                MSnAnalyzer msnAnalyzer = new MSnAnalyzer(((QuantVO)quant).getAnalyteClass(), ((QuantVO)quant).getModName(), set4, analyzer, (QuantVO)quant, true, false);
                                if (msnAnalyzer.checkStatus() != 1) continue;
                                toRemove.put(string, set4);
                            }
                            catch (ChemicalFormulaException | HydroxylationEncodingException | RulesException | SpectrummillParserException | IOException e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hashtable = new Hashtable<QuantVO, Hashtable<String, LipidParameterSet>>();
                        Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> peaksBeforeSplit = new Hashtable<QuantVO, Hashtable<String, LipidParameterSet>>();
                        lipClass = null;
                        for (String id : forSplit.keySet()) {
                            LipidParameterSet set5 = (LipidParameterSet)forSplit.get(id);
                            lipClass = OtherAdductChecker.getLipidClassFromUniqueId(id);
                            QuantVO quant = null;
                            for (QuantVO one : allQuants) {
                                if (!lipClass.equalsIgnoreCase(one.getAnalyteClass()) || !set5.getNameStringWithoutRt().equalsIgnoreCase(one.getIdString()) || !set5.getModificationName().equalsIgnoreCase(one.getModName())) continue;
                                quant = one;
                                break;
                            }
                            if (!hashtable.containsKey(quant)) {
                                hashtable.put(quant, new Hashtable());
                            }
                            hashtable.get(quant).put(set5.getRt(), set5);
                            if (unsplittedPeaks.containsKey(quant.getAnalyteClass()) && unsplittedPeaks.get(quant.getAnalyteClass()).containsKey(quant.getIdString()) && unsplittedPeaks.get(quant.getAnalyteClass()).get(quant.getIdString()).containsKey(quant.getModName()) && unsplittedPeaks.get(quant.getAnalyteClass()).get(quant.getIdString()).get(quant.getModName()).containsKey(rt)) {
                                hashtable.get(quant).put(set5.getRt(), unsplittedPeaks.get(quant.getAnalyteClass()).get(quant.getIdString()).get(quant.getModName()).get(rt));
                            }
                            peaksBeforeSplit.put(quant, new Hashtable());
                        }
                        MSnPeakSeparator separator = new MSnPeakSeparator(hashtable, peaksBeforeSplit, analyzer, classSequence.get(lipClass), new HashSet<String>());
                        Hashtable<QuantVO, Hashtable<String, LipidParameterSet>> hitsAccordingToQuant = separator.disentagleSharedMS1Peaks();
                        for (QuantVO quant : hashtable.keySet()) {
                            for (String ret : hashtable.get(quant).keySet()) {
                                if (hitsAccordingToQuant.containsKey(quant) && hitsAccordingToQuant.get(quant).containsKey(ret)) continue;
                                toRemove.put(OtherAdductChecker.getUniqueId(quant.getAnalyteClass(), quant.getIdString(), quant.getModName(), ret), hashtable.get(quant).get(ret));
                            }
                        }
                        for (QuantVO quant : hitsAccordingToQuant.keySet()) {
                            for (String ret : hitsAccordingToQuant.get(quant).keySet()) {
                                set = hitsAccordingToQuant.get(quant).get(ret);
                                results.get(quant.getAnalyteClass()).get(quant.getIdString()).get(set.getModificationName()).put(ret, set);
                            }
                        }
                        for (QuantVO quant : peaksBeforeSplit.keySet()) {
                            for (String ret : peaksBeforeSplit.get(quant).keySet()) {
                                set = peaksBeforeSplit.get(quant).get(ret);
                                Hashtable<String, LipidParameterSet> unsplitted = new Hashtable<String, LipidParameterSet>();
                                if (unsplittedPeaks.get(quant.getAnalyteClass()).get(quant.getIdString()).containsKey(set.getModificationName())) {
                                    unsplitted = unsplittedPeaks.get(quant.getAnalyteClass()).get(quant.getIdString()).get(set.getModificationName());
                                }
                                unsplitted.put(ret, set);
                                unsplittedPeaks.get(quant.getAnalyteClass()).get(quant.getIdString()).put(set.getModificationName(), unsplitted);
                            }
                        }
                    }
                }
            }
        }
        for (String id : toRemove.keySet()) {
            Vector<String> vector = OtherAdductChecker.getParamsFromId(id);
            results.get(vector.get(0)).get(vector.get(1)).get(vector.get(2)).remove(vector.get(3));
        }
        return results;
    }

    private static boolean isOtherModPresentInResults(String lClass, String analyte, String mod, String rtString, float tolerance, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> results) {
        if (!(results.containsKey(lClass) && results.get(lClass).containsKey(analyte) && results.get(lClass).get(analyte).containsKey(mod))) {
            return false;
        }
        boolean found = false;
        float rt = Float.parseFloat(rtString);
        float startRt = rt - tolerance;
        float stopRt = rt + tolerance;
        for (String foundRtString : results.get(lClass).get(analyte).get(mod).keySet()) {
            float foundRt = Float.parseFloat(foundRtString);
            if (!(startRt <= foundRt) || !(foundRt <= stopRt)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static String getUniqueId(String lClass, String anal, String mod, String rt) {
        return lClass + SEP + anal + SEP + mod + SEP + rt;
    }

    private static String getLipidClassFromUniqueId(String uniqueId) {
        return uniqueId.substring(0, uniqueId.indexOf(SEP));
    }

    private static Hashtable<String, Hashtable<String, LipidParameterSet>> getGroupsOfSameRt(Vector<QuantVO> allQuants, Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> results) {
        Hashtable<String, Hashtable<String, LipidParameterSet>> sameRts = new Hashtable<String, Hashtable<String, LipidParameterSet>>();
        for (QuantVO quant : allQuants) {
            if (!results.containsKey(quant.getAnalyteClass()) || !results.get(quant.getAnalyteClass()).containsKey(quant.getIdString()) || !results.get(quant.getAnalyteClass()).get(quant.getIdString()).containsKey(quant.getModName())) continue;
            for (String rt : results.get(quant.getAnalyteClass()).get(quant.getIdString()).get(quant.getModName()).keySet()) {
                LipidParameterSet set = results.get(quant.getAnalyteClass()).get(quant.getIdString()).get(quant.getModName()).get(rt);
                if (!sameRts.containsKey(rt)) {
                    sameRts.put(rt, new Hashtable());
                }
                sameRts.get(rt).put(StaticUtils.getRuleName(quant.getAnalyteClass(), quant.getModName()), set);
            }
        }
        return sameRts;
    }

    public static Vector<String> getParamsFromId(String id) {
        Vector<String> params = new Vector<String>();
        String rest = new String(id);
        while (rest.length() > 0) {
            if (rest.indexOf(SEP) != -1) {
                params.add(rest.substring(0, rest.indexOf(SEP)));
                rest = rest.substring(rest.indexOf(SEP) + SEP.length());
                continue;
            }
            params.add(rest);
            rest = "";
        }
        return params;
    }

    public static void removePeaksThatFallBelowTheBasepeakCutoff(Hashtable<String, Hashtable<String, Hashtable<String, Hashtable<String, LipidParameterSet>>>> results, float threshold) {
        Hashtable<String, LipidParameterSet> toRemove = new Hashtable<String, LipidParameterSet>();
        for (String anClass : results.keySet()) {
            for (String analyte : results.get(anClass).keySet()) {
                for (String mod : results.get(anClass).get(analyte).keySet()) {
                    for (String rt : results.get(anClass).get(analyte).get(mod).keySet()) {
                        LipidParameterSet set = results.get(anClass).get(analyte).get(mod).get(rt);
                        boolean oneOk = false;
                        for (CgProbe probe : set.getIsotopicProbes().get(0)) {
                            if (!(probe.Area > threshold)) continue;
                            oneOk = true;
                        }
                        if (oneOk) continue;
                        toRemove.put(OtherAdductChecker.getUniqueId(anClass, analyte, mod, rt), set);
                    }
                }
            }
        }
        for (String id : toRemove.keySet()) {
            Vector<String> params = OtherAdductChecker.getParamsFromId(id);
            results.get(params.get(0)).get(params.get(1)).get(params.get(2)).remove(params.get(3));
        }
    }
}

