/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.parser.FragRuleParser;
import at.tugraz.genome.lda.msn.vos.FragmentRuleVO;
import at.tugraz.genome.lda.msn.vos.IntensityRuleVO;
import at.tugraz.genome.lda.utils.RangeInteger;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class RulesContainer {
    public static final String DEFAULT_RULES_DIR = "fragRules";
    private static final String INTERIM_RULES_DIR = "fragRules/interim";
    public static String currentRulesDir_ = "fragRules";
    private String rulesDir_;
    private static Hashtable<String, RulesContainer> instances_;
    private Hashtable<String, FragRuleParser> rules_;
    public static final int ORDER_MS1_FIRST = 0;
    public static final int ORDER_MSN_FIRST = 1;
    public static final int ORDER_MSN_ONLY = 2;

    private RulesContainer(String rulesDir) throws RulesException, IOException, SpectrummillParserException {
        this.rulesDir_ = rulesDir;
        this.extractRules();
    }

    private static RulesContainer getInstance(String rulesDir) throws RulesException, IOException, SpectrummillParserException {
        if (instances_ == null) {
            RulesContainer.clearCache();
        }
        if (!instances_.containsKey(rulesDir)) {
            instances_.put(rulesDir, new RulesContainer(rulesDir));
        }
        return instances_.get(rulesDir);
    }

    public static void usePermanentRulesDir() {
        currentRulesDir_ = DEFAULT_RULES_DIR;
    }

    public static void useInterimRulesDir() {
        currentRulesDir_ = INTERIM_RULES_DIR;
    }

    private void extractRules() throws RulesException, IOException {
        this.rules_ = new Hashtable();
        File rulesDir = new File(this.rulesDir_);
        if (!rulesDir.exists()) {
            throw new RulesException("The provided fragmentation rules directory does not exist!");
        }
        if (!rulesDir.isDirectory()) {
            throw new RulesException("The provided fragmentation rules directory is a file - not a directory!");
        }
        File[] files = rulesDir.listFiles();
        List<String> fileNames = Arrays.asList(rulesDir.list());
        ElementConfigParser elementParser = Settings.getElementParser();
        String analyteClass = "";
        for (File file : files) {
            if (!file.getAbsolutePath().endsWith(".frag.txt")) continue;
            FragRuleParser parser = new FragRuleParser(elementParser);
            try {
                parser.parseFile(file);
                analyteClass = file.getName().substring(0, file.getName().length() - ".frag.txt".length());
                this.rules_.put(analyteClass, parser);
                if (fileNames.contains("ox" + analyteClass + ".frag.txt")) continue;
                this.rules_.put("ox" + analyteClass, parser);
            }
            catch (RulesException ex) {
                throw new RulesException(file.getName() + ": " + ex.getMessage());
            }
        }
    }

    private boolean hasRule(String rule) {
        return this.rules_.containsKey(rule);
    }

    private static RulesContainer checkIfRuleExists(String rule, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer instance;
        String rDir = rulesDir;
        if (rDir == null || rDir.length() == 0) {
            rDir = currentRulesDir_;
        }
        if (!(instance = RulesContainer.getInstance(rDir)).hasRule(rule)) {
            throw new NoRuleException(String.format("There is no MS2 rule for the analyte class \"%s\"!", rule));
        }
        return instance;
    }

    public static String getChainlibrary(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getChainlibrary(ruleName, currentRulesDir_);
    }

    public static String getChainlibrary(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getChainLibrary();
    }

    public static String getLcbLibrary(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getLcbLibrary(ruleName, currentRulesDir_);
    }

    public static String getLcbLibrary(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getLcbLibrary();
    }

    public static String getCAtomsFromNamePattern(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getCAtomsFromNamePattern(ruleName, currentRulesDir_);
    }

    public static String getCAtomsFromNamePattern(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getCAtomsFromNamePattern();
    }

    public static String getDoubleBondsFromNamePattern(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getDoubleBondsFromNamePattern(ruleName, currentRulesDir_);
    }

    public static String getDoubleBondsFromNamePattern(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getDoubleBondsFromNamePattern();
    }

    public static String getAmountOfChains(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getAmountOfChains(ruleName, currentRulesDir_);
    }

    public static String getAmountOfChains(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getAmountOfChains();
    }

    public static String getAmountOfAlkylChains(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getAmountOfAlkylChains(ruleName, currentRulesDir_);
    }

    public static String getAmountOfAlkylChains(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getAmountOfAlkylChains();
    }

    public static String getAmountOfAlkenylChains(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getAmountOfAlkenylChains(ruleName, currentRulesDir_);
    }

    public static String getAmountOfAlkenylChains(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getAmountOfAlkenylChains();
    }

    public static String getAmountOfLCBs(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getAmountOfLCBs(ruleName, currentRulesDir_);
    }

    public static String getAmountOfLCBs(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getAmountOfLCBs();
    }

    public static RangeInteger getFaHydroxyRange(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getFaHydroxyRange(ruleName, currentRulesDir_);
    }

    public static RangeInteger getFaHydroxyRange(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getFaHydroxyRange();
    }

    public static RangeInteger getLcbHydroxyRange(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getLcbHydroxyRange(ruleName, currentRulesDir_);
    }

    public static RangeInteger getLcbHydroxyRange(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getLcbHydroxyRange();
    }

    public static double getBasePeakCutoff(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getBasePeakCutoff(ruleName, currentRulesDir_);
    }

    public static double getBasePeakCutoff(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getBasePeakCutoff();
    }

    public static String getBasePeakCutoffAsString(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getBasePeakCutoffAsString(ruleName, currentRulesDir_);
    }

    public static String getBasePeakCutoffAsString(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getBasePeakCutoffAsString();
    }

    public static double getChainCutoff(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getChainCutoff(ruleName, currentRulesDir_);
    }

    public static double getChainCutoff(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getChainCutoff();
    }

    public static String getChainCutoffAsString(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getChainCutoffAsString(ruleName, currentRulesDir_);
    }

    public static String getChainCutoffAsString(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        String cutoffString = cont.rules_.get(ruleName).getChainCutoffAsString();
        if (cutoffString.equalsIgnoreCase("-1")) {
            cutoffString = null;
        }
        return cutoffString;
    }

    public static double getSpectrumCoverageMin(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getSpectrumCoverageMin(ruleName, currentRulesDir_);
    }

    public static double getSpectrumCoverageMin(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getSpectrumCoverageMin();
    }

    public static String getSpectrumCoverageMinAsString(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getSpectrumCoverageMinAsString(ruleName, currentRulesDir_);
    }

    public static String getSpectrumCoverageMinAsString(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getSpectrumCoverageMinAsString();
    }

    public static boolean isRtPostprocessing(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.isRtPostprocessing(ruleName, currentRulesDir_);
    }

    public static boolean isRtPostprocessing(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).isRtPostprocessing();
    }

    public static boolean correctRtForParallelModel(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.correctRtForParallelModel(ruleName, currentRulesDir_);
    }

    public static boolean correctRtForParallelModel(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).correctRtForParallelModel();
    }

    public static String getRetentionTimeMaxDeviation(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getRetentionTimeMaxDeviation(ruleName, currentRulesDir_);
    }

    public static String getRetentionTimeMaxDeviation(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getRetentionTimeMaxDeviation();
    }

    public static String getPeakUnionTime(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getPeakUnionTime(ruleName, currentRulesDir_);
    }

    public static String getPeakUnionTime(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getPeakUnionTime();
    }

    public static boolean isUnionWithoutPosition(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.isUnionWithoutPosition(ruleName, currentRulesDir_);
    }

    public static boolean isUnionWithoutPosition(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).isUnionWithoutPosition();
    }

    public static String getMS1PeakCutoff(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getMS1PeakCutoff(ruleName, currentRulesDir_);
    }

    public static String getMS1PeakCutoff(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getMS1PeakCutoff();
    }

    public static String getIsobarExclusionRatio(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getIsobarExclusionRatio(ruleName, currentRulesDir_);
    }

    public static String getIsobarExclusionRatio(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getIsobarExclusionRatio();
    }

    public static String getIsobarFarExclusionRatio(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getIsobarFarExclusionRatio(ruleName, currentRulesDir_);
    }

    public static String getIsobarFarExclusionRatio(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getIsobarFarExclusionRatio();
    }

    public static String getIsobarFarRtDifference(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getIsobarFarRtDifference(ruleName, currentRulesDir_);
    }

    public static String getIsobarFarRtDifference(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getIsobarFarRtDifference();
    }

    public static Hashtable<String, FragmentRuleVO> getHeadFragmentRules(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getHeadFragmentRules(ruleName, currentRulesDir_);
    }

    public static Hashtable<String, FragmentRuleVO> getHeadFragmentRules(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getHeadFragmentRules();
    }

    public static Vector<IntensityRuleVO> getHeadIntensityRules(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getHeadIntensityRules(ruleName, currentRulesDir_);
    }

    public static Vector<IntensityRuleVO> getHeadIntensityRules(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getHeadIntensityRules();
    }

    public static Hashtable<String, FragmentRuleVO> getChainFragmentRules(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getChainFragmentRules(ruleName, currentRulesDir_);
    }

    public static Hashtable<String, FragmentRuleVO> getChainFragmentRules(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getChainFragmentRules();
    }

    public static Vector<IntensityRuleVO> getChainIntensityRules(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getChainIntensityRules(ruleName, currentRulesDir_);
    }

    public static Vector<IntensityRuleVO> getChainIntensityRules(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getChainIntensityRules();
    }

    public static Vector<IntensityRuleVO> getPositionIntensityRules(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getPositionIntensityRules(ruleName, currentRulesDir_);
    }

    public static Vector<IntensityRuleVO> getPositionIntensityRules(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getPositionIntensityRules();
    }

    public static boolean isSingleChainIdentification(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.isSingleChainIdentification(ruleName, currentRulesDir_);
    }

    public static boolean isSingleChainIdentification(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).isSingleChainIdentification();
    }

    public static int getMSIdentificationOrder(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getMSIdentificationOrder(ruleName, currentRulesDir_);
    }

    public static int getMSIdentificationOrder(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getMSIdentificationOrder();
    }

    public static int[] getSpectrumLevelRange(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getSpectrumLevelRange(ruleName, currentRulesDir_);
    }

    public static int[] getSpectrumLevelRange(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getSpectrumLevelRange();
    }

    public static Integer getAddChainPositions(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getAddChainPositions(ruleName, currentRulesDir_);
    }

    public static Integer getAddChainPositions(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getAddChainPositions();
    }

    public static int getAllowedChainPositions(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getAllowedChainPositions(ruleName, currentRulesDir_);
    }

    public static int getAllowedChainPositions(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getAllowedChainPositions();
    }

    public static boolean requiresOtherValidAdduct(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.requiresOtherValidAdduct(ruleName, currentRulesDir_);
    }

    public static boolean requiresOtherValidAdduct(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).requiresOtherValidAdduct();
    }

    public static Vector<String> getOtherRequiredAdducts(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getOtherRequiredAdducts(ruleName, currentRulesDir_);
    }

    public static Vector<String> getOtherRequiredAdducts(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getOtherRequiredAdducts();
    }

    public static boolean areAllOtherAdductsRequired(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.areAllOtherAdductsRequired(ruleName, currentRulesDir_);
    }

    public static boolean areAllOtherAdductsRequired(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).areAllOtherAdductsRequired();
    }

    public static float getOtherTimeTolerance(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getOtherTimeTolerance(ruleName, currentRulesDir_);
    }

    public static float getOtherTimeTolerance(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getOtherTimeTolerance();
    }

    public static float getChainAbsoluteThreshold(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.getChainAbsoluteThreshold(ruleName, currentRulesDir_);
    }

    public static float getChainAbsoluteThreshold(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).getChainAbsoluteThreshold();
    }

    public static boolean forceOtherAdductValidity(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.forceOtherAdductValidity(ruleName, currentRulesDir_);
    }

    public static boolean forceOtherAdductValidity(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).forceOtherAdductValidity();
    }

    public static boolean choseMoreLikelyRtWhenEqualMSn(String ruleName) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        return RulesContainer.choseMoreLikelyRtWhenEqualMSn(ruleName, currentRulesDir_);
    }

    public static boolean choseMoreLikelyRtWhenEqualMSn(String ruleName, String rulesDir) throws RulesException, NoRuleException, IOException, SpectrummillParserException {
        RulesContainer cont = RulesContainer.checkIfRuleExists(ruleName, rulesDir);
        return cont.rules_.get(ruleName).choseMoreLikelyRtWhenEqualMSn();
    }

    public static void clearCache() {
        instances_ = new Hashtable();
    }

    public static void clearCache(String rulesDir) {
        if (instances_ != null && instances_.containsKey(rulesDir)) {
            instances_.remove(rulesDir);
        }
    }
}

