/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.hydroxy.parser;

import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Properties;

public class HydroxyEncoding
extends Properties {
    private static final long serialVersionUID = 4234382085044433873L;
    private Hashtable<String, Short> encodingToNumber_ = new Hashtable();
    private List<Short> sortedOHs_ = new ArrayList<Short>();
    public static final String HYDROXYLATION_ZERO = "n";

    public HydroxyEncoding(String path) throws IOException, HydroxylationEncodingException {
        this();
        FileInputStream in = new FileInputStream(path);
        this.load(in);
        in.close();
        String keyString = "";
        try {
            for (Object key : this.keySet()) {
                keyString = (String)key;
                if (keyString == null || keyString.length() == 0) continue;
                Short oh = Short.parseShort(keyString);
                this.encodingToNumber_.put((String)this.get(key), oh);
                this.sortedOHs_.add(oh);
            }
            Collections.sort(this.sortedOHs_);
        }
        catch (NumberFormatException nfx) {
            throw new HydroxylationEncodingException("The value \"" + keyString + "\" is not permitted as hydroxylation encoding - only integer numbers are allowed as keys!");
        }
    }

    private HydroxyEncoding() {
    }

    public HydroxyEncoding(Hashtable<String, Short> encodingToNumber) {
        this();
        this.encodingToNumber_ = new Hashtable<String, Short>(encodingToNumber);
        for (String key : encodingToNumber.keySet()) {
            this.put(String.valueOf(this.encodingToNumber_.get(key)), key);
            this.sortedOHs_.add(this.encodingToNumber_.get(key));
        }
        Collections.sort(this.sortedOHs_);
    }

    public String getEncodedPrefix(short hydroxyNumber) throws HydroxylationEncodingException {
        String stringNumber = String.valueOf(hydroxyNumber);
        if (this.getProperty(stringNumber) == null) {
            throw new HydroxylationEncodingException("The demanded hydroxylation number \"" + hydroxyNumber + "\" does not exist in the encoding file");
        }
        return this.getProperty(stringNumber);
    }

    public Short getHydroxyNumber(String encoded) throws HydroxylationEncodingException {
        if (!this.encodingToNumber_.containsKey(encoded)) {
            throw new HydroxylationEncodingException("The demanded hydroxylation key \"" + encoded + "\" does not exist in the encoding file");
        }
        return this.encodingToNumber_.get(encoded);
    }

    public List<Short> getHydroxyNumbersInAscendingOrder() {
        return this.sortedOHs_;
    }

    public void mergeHydroxyEncodings(HydroxyEncoding other) {
        for (String encoded : other.encodingToNumber_.keySet()) {
            this.addHydroxyEncoding(encoded, this.encodingToNumber_.get(encoded));
        }
    }

    private void addHydroxyEncoding(String encoded, short hydroxyNumber) {
        if (this.encodingToNumber_.containsKey(encoded) || this.encodingToNumber_.containsValue(hydroxyNumber)) {
            return;
        }
        this.put(String.valueOf(hydroxyNumber), encoded);
        this.encodingToNumber_.put(encoded, hydroxyNumber);
        this.sortedOHs_.add(hydroxyNumber);
        Collections.sort(this.sortedOHs_);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HydroxyEncoding other = (HydroxyEncoding)obj;
        return Objects.equals(this.encodingToNumber_, other.encodingToNumber_) && Objects.equals(this.sortedOHs_, other.sortedOHs_);
    }
}

