/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.parser;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.exception.SheetNotPresentException;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.parser.ModificationParser;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FALibParser {
    private static final String FAS_SHEET_NAME = "FAS";
    protected File inputFile_;
    protected Hashtable<String, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> result_;
    protected Set<String> availablePrefixes_;

    public FALibParser(String filePath) throws IOException {
        this(new File(filePath));
    }

    public FALibParser(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("The file " + file.getAbsolutePath() + " does not exist!");
        }
        this.inputFile_ = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFAFile() {
        try (FileInputStream myxls = new FileInputStream(this.inputFile_);
             XSSFWorkbook workbook = new XSSFWorkbook(myxls);){
            int sheetNumber = 0;
            while (sheetNumber != workbook.getNumberOfSheets()) {
                if (workbook.getSheetAt(sheetNumber).getSheetName().equalsIgnoreCase(FAS_SHEET_NAME)) {
                    boolean bl = true;
                    return bl;
                }
                ++sheetNumber;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile() throws RulesException, IOException, SheetNotPresentException {
        block23: {
            this.result_ = new Hashtable();
            this.availablePrefixes_ = new HashSet<String>();
            InputStream myxls = null;
            try {
                myxls = new FileInputStream(this.inputFile_);
                Workbook workbook = null;
                if (this.inputFile_.getAbsolutePath().endsWith(".xlsx")) {
                    workbook = new XSSFWorkbook(myxls);
                } else if (this.inputFile_.getAbsolutePath().endsWith(".xls")) {
                    workbook = new HSSFWorkbook(myxls);
                }
                Sheet sheet = null;
                for (int sheetNumber = 0; sheetNumber != workbook.getNumberOfSheets(); ++sheetNumber) {
                    if (!workbook.getSheetAt(sheetNumber).getSheetName().equalsIgnoreCase(FAS_SHEET_NAME)) continue;
                    sheet = workbook.getSheetAt(sheetNumber);
                }
                if (sheet == null) {
                    throw new SheetNotPresentException("A fatty acid chain library must have a sheet called \"FAS\"! The lib " + this.inputFile_.getName() + " has not!");
                }
                Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> readResult = this.parseSheet(sheet);
                this.result_.put("n", readResult);
                if (Settings.getFaHydroxyEncoding() == null) break block23;
                short highestHydroxyNumber = 0;
                HydroxyEncoding hydroxies = Settings.getFaHydroxyEncoding();
                HashSet<String> encodedHydroxyStrings = new HashSet<String>();
                for (Object hydroxyObject : hydroxies.keySet()) {
                    short hydroxyKey = Short.parseShort((String)hydroxyObject);
                    encodedHydroxyStrings.add((String)hydroxies.get(hydroxyObject));
                    if (hydroxyKey <= highestHydroxyNumber) continue;
                    highestHydroxyNumber = hydroxyKey;
                }
                double oxygenMass = Settings.getElementParser().getElementDetails("O").getMonoMass();
                for (short i = 1; i <= highestHydroxyNumber; ++i) {
                    String encoded = null;
                    try {
                        encoded = hydroxies.getEncodedPrefix(i);
                    }
                    catch (HydroxylationEncodingException e) {
                        continue;
                    }
                    try {
                        Hashtable currentHydroxy = new Hashtable();
                        for (Integer cAtoms : this.result_.get("n").keySet()) {
                            Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>> otherCAtoms = this.result_.get("n").get(cAtoms);
                            Hashtable cAtomsRes = new Hashtable();
                            for (Integer dbs : otherCAtoms.keySet()) {
                                Hashtable<String, Hashtable<String, FattyAcidVO>> otherDbs = otherCAtoms.get(dbs);
                                Hashtable dbsRes = new Hashtable();
                                for (String prefix : otherDbs.keySet()) {
                                    Hashtable<String, FattyAcidVO> otherOxs = otherDbs.get(prefix);
                                    Hashtable<String, FattyAcidVO> OxsRes = new Hashtable<String, FattyAcidVO>();
                                    for (String oxState : otherOxs.keySet()) {
                                        FattyAcidVO otherFA = otherOxs.get(oxState);
                                        Hashtable<String, Integer> formulaCat = StaticUtils.categorizeFormula(otherFA.getFormula());
                                        int oxygens = 0;
                                        if (formulaCat.containsKey("O")) {
                                            oxygens = formulaCat.get("O");
                                        }
                                        formulaCat.put("O", oxygens += i);
                                        FattyAcidVO chainVO = new FattyAcidVO(otherFA.getChainType(), otherFA.getPrefix(), otherFA.getcAtoms(), otherFA.getDoubleBonds(), i, otherFA.getMass() + (double)i * oxygenMass, StaticUtils.getFormulaInHillNotation(formulaCat, true), otherFA.getOxState());
                                        OxsRes.put(oxState, chainVO);
                                    }
                                    dbsRes.put(prefix, OxsRes);
                                }
                                cAtomsRes.put(dbs, dbsRes);
                            }
                            currentHydroxy.put(cAtoms, cAtomsRes);
                        }
                        this.result_.put(encoded, currentHydroxy);
                        continue;
                    }
                    catch (ChemicalFormulaException cfx) {
                        cfx.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    myxls.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> parseSheet(Sheet sheet) throws RulesException {
        return this.parseSheet(sheet, 0);
    }

    protected Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> parseSheet(Sheet sheet, int ohNumber) throws RulesException {
        Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> result = new Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>();
        int cAtomsColumn = -1;
        int dbsColumn = -1;
        int massColumn = -1;
        int oxStateColumn = -1;
        boolean foundColumns = false;
        Hashtable elementColumns = new Hashtable();
        Pattern prefixPattern = Pattern.compile("\\D*(\\d+)");
        for (int rowCount = 0; rowCount != sheet.getLastRowNum() + 1; ++rowCount) {
            Row row = sheet.getRow(rowCount);
            String prefix = "";
            int cAtoms = -1;
            int dbs = -1;
            double mass = -1.0;
            String oxState = "";
            Hashtable<Integer, String> possibleElementColumns = new Hashtable<Integer, String>();
            Hashtable<String, Integer> elementalComposition = new Hashtable<String, Integer>();
            for (int i = 0; row != null && i != row.getLastCellNum() + 1; ++i) {
                Cell cell = row.getCell(i);
                String contents = "";
                Double numeric = null;
                int cellType = -1;
                if (cell != null) {
                    cellType = cell.getCellType();
                }
                if (cellType == 1) {
                    contents = cell.getStringCellValue();
                    if (contents != null) {
                        contents = contents.trim();
                    }
                    try {
                        if (contents != null) {
                            numeric = new Double(contents.replaceAll(",", "."));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (cellType == 0 || cellType == 2) {
                    numeric = cell.getNumericCellValue();
                    contents = String.valueOf(numeric);
                }
                if (contents != null) {
                    contents = contents.trim();
                }
                if (!foundColumns) {
                    if (contents.equalsIgnoreCase("Name")) {
                        cAtomsColumn = i;
                        continue;
                    }
                    if (contents.equalsIgnoreCase("dbs")) {
                        dbsColumn = i;
                        continue;
                    }
                    if (contents.equalsIgnoreCase("mass")) {
                        massColumn = i;
                        continue;
                    }
                    if (contents.equalsIgnoreCase("PSM")) {
                        oxStateColumn = i;
                        continue;
                    }
                    if (contents.trim().length() != 1 && contents.trim().length() != 2) continue;
                    boolean ok = false;
                    if (!Character.isUpperCase(contents.trim().toCharArray()[0])) continue;
                    if (contents.trim().length() == 2) {
                        if (Character.isLowerCase(contents.trim().toCharArray()[1])) {
                            ok = true;
                        }
                    } else {
                        ok = true;
                    }
                    if (!ok) continue;
                    possibleElementColumns.put(i, contents.trim());
                    continue;
                }
                if (i == cAtomsColumn && contents != null && contents.length() > 0) {
                    if (numeric == null) {
                        Matcher prefixMatcher = prefixPattern.matcher(contents);
                        if (prefixMatcher.matches()) {
                            prefix = prefixMatcher.group(0);
                            String cAtomsString = prefixMatcher.group(1);
                            prefix = contents.substring(0, contents.indexOf(cAtomsString));
                            cAtoms = Integer.parseInt(cAtomsString);
                        }
                    } else {
                        cAtoms = numeric.intValue();
                    }
                    if (cAtoms < 1) {
                        throw new RulesException("A fatty acid chain library must have integer values greater or equal 1 in the \"Name\" column! There is the value " + cAtoms + " at line number " + (rowCount + 1) + "!");
                    }
                }
                if (i == dbsColumn && contents != null && contents.length() > 0) {
                    if (numeric == null) {
                        throw new RulesException("A fatty acid chain library must have integer values in the \"dbs\" column! There is the entry \"" + contents + "\" at line number " + (rowCount + 1) + "!");
                    }
                    dbs = numeric.intValue();
                    if (dbs < 0) {
                        throw new RulesException("A fatty acid chain library must have integer values greater or equal 0 in the \"dbs\" column! There is the value " + dbs + " at line number " + (rowCount + 1) + "!");
                    }
                }
                if (i == massColumn && contents != null && contents.length() > 0) {
                    if (numeric == null) {
                        throw new RulesException("A fatty acid chain library must have double values in the \"mass\" column! There is the entry \"" + contents + "\" at line number " + (rowCount + 1) + "!");
                    }
                    mass = numeric;
                    if (mass <= 0.0) {
                        throw new RulesException("A fatty acid chain library must have double values greater 0 in the \"mass\" column! There is the value " + mass + " at line number " + (rowCount + 1) + "!");
                    }
                }
                if (i == oxStateColumn && contents != null && contents.length() > 0) {
                    oxState = contents;
                }
                if (!elementColumns.containsKey(i) || contents.length() <= 0) continue;
                int value = 0;
                if (numeric != null && contents.endsWith(".0")) {
                    value = (int)Math.round(numeric);
                } else {
                    try {
                        value = Integer.parseInt(contents);
                    }
                    catch (NumberFormatException nfx3) {
                        System.out.println("Warning: The elemental column \"" + (String)elementColumns.get(i) + "\" does not seem to be a chemical element, since float values are there -> I remove it!");
                        elementColumns.remove(i);
                    }
                }
                if (value <= 0) continue;
                elementalComposition.put((String)elementColumns.get(i), value);
            }
            if (!foundColumns && cAtomsColumn != -1 && massColumn != -1) {
                foundColumns = true;
                elementColumns = new Hashtable(possibleElementColumns);
            }
            if (!foundColumns || cAtoms <= 0 || !(mass > 0.0) || dbsColumn > -1 && dbs < 0) continue;
            String[] oxStates = oxState.split(";");
            double newMass = mass;
            for (String oxMod : oxStates) {
                oxMod = oxMod.replaceAll("\\s", "");
                ModificationParser mp = new ModificationParser(oxMod);
                mp.parse();
                newMass = mp.getNewMass(mass);
                String chemicalFormula = mp.getNewChemicalFormula(elementalComposition);
                if (chemicalFormula.indexOf("-") != -1) continue;
                FattyAcidVO faVO = new FattyAcidVO(0, prefix, cAtoms, dbs, ohNumber, newMass, chemicalFormula, oxMod);
                if (prefix != null && prefix.length() > 0) {
                    this.availablePrefixes_.add(prefix);
                }
                Hashtable<Object, Object> fasWithSameC = new Hashtable();
                if (result.containsKey(cAtoms)) {
                    fasWithSameC = result.get(cAtoms);
                }
                Hashtable fasWithSameDbs = new Hashtable();
                Hashtable fasWithSameOx = new Hashtable();
                if (fasWithSameC.containsKey(dbs)) {
                    fasWithSameDbs = (Hashtable)fasWithSameC.get(dbs);
                }
                if (fasWithSameDbs.containsKey(prefix)) {
                    fasWithSameOx = (Hashtable)fasWithSameDbs.get(prefix);
                }
                if (fasWithSameOx.containsKey(oxMod)) {
                    throw new RulesException("A fatty acid chain library must not contain the same elements twice! The entry " + faVO.getCarbonDbsId() + " at line number " + (rowCount + 1) + " is there for the second time!");
                }
                fasWithSameOx.put(oxMod, faVO);
                fasWithSameDbs.put(prefix, fasWithSameOx);
                fasWithSameC.put(dbs, fasWithSameDbs);
                result.put(cAtoms, fasWithSameC);
            }
        }
        if (!foundColumns) {
            throw new RulesException("A fatty acid chain library must have the column headers \"Name\" and \"mass\"! The lib " + this.inputFile_.getName() + " has not!");
        }
        return result;
    }

    public Hashtable<String, Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>>> getResult() {
        return this.result_;
    }

    public ArrayList<FattyAcidVO> getFattyAcidSet(String hydroxyEncoding, Integer numC, Integer numDB) {
        ArrayList<FattyAcidVO> chains = new ArrayList<FattyAcidVO>();
        Hashtable<String, Hashtable<String, FattyAcidVO>> selectedFAs = this.result_.get(hydroxyEncoding).get(numC).get(numDB);
        for (String pref : selectedFAs.keySet()) {
            for (String oxState : selectedFAs.get(pref).keySet()) {
                chains.add(selectedFAs.get(pref).get(oxState));
            }
        }
        return chains;
    }

    public ArrayList<FattyAcidVO> getFattyAcidSet(String hydroxyEncoding) {
        ArrayList<FattyAcidVO> chains = new ArrayList<FattyAcidVO>();
        Hashtable<Integer, Hashtable<Integer, Hashtable<String, Hashtable<String, FattyAcidVO>>>> selectedFAs = this.result_.get(hydroxyEncoding);
        for (Integer cAtoms : selectedFAs.keySet()) {
            for (Integer dbs : selectedFAs.get(cAtoms).keySet()) {
                for (String pref : selectedFAs.get(cAtoms).get(dbs).keySet()) {
                    for (String oxState : selectedFAs.get(cAtoms).get(dbs).get(pref).keySet()) {
                        chains.add(selectedFAs.get(cAtoms).get(dbs).get(pref).get(oxState));
                    }
                }
            }
        }
        return chains;
    }

    public ArrayList<FattyAcidVO> getFattyAcidSet(boolean includeOxState) {
        ArrayList<FattyAcidVO> chains = new ArrayList<FattyAcidVO>();
        for (String hydroxy : this.result_.keySet()) {
            for (Integer cAtoms : this.result_.get(hydroxy).keySet()) {
                for (Integer dbs : this.result_.get(hydroxy).get(cAtoms).keySet()) {
                    for (String pref : this.result_.get(hydroxy).get(cAtoms).get(dbs).keySet()) {
                        for (String oxState : this.result_.get(hydroxy).get(cAtoms).get(dbs).get(pref).keySet()) {
                            FattyAcidVO chain = this.result_.get(hydroxy).get(cAtoms).get(dbs).get(pref).get(oxState);
                            if (!includeOxState && chain.getOxState().equals("")) {
                                chains.add(chain);
                                continue;
                            }
                            if (!includeOxState) continue;
                            chains.add(chain);
                        }
                    }
                }
            }
        }
        Collections.sort(chains);
        return chains;
    }

    public Set<String> getAvailableLabels() {
        return this.availablePrefixes_;
    }
}

