/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.parser;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.hydroxy.parser.HydroxyEncoding;
import at.tugraz.genome.lda.msn.parser.FALibParser;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SPBLibParser
extends FALibParser {
    private static final String SPB_SHEET_SUFFIX = "SPB";
    private static final String LCB_SHEET_SUFFIX = "LCB";
    private short highestHydroxyNumber_ = 0;

    public SPBLibParser(File file) throws IOException {
        super(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLCBFile() {
        try (FileInputStream myxls = new FileInputStream(this.inputFile_);
             XSSFWorkbook workbook = new XSSFWorkbook(myxls);){
            int sheetNumber = 0;
            while (sheetNumber != workbook.getNumberOfSheets()) {
                String sheetName = workbook.getSheetAt(sheetNumber).getSheetName();
                if (sheetName.endsWith(SPB_SHEET_SUFFIX) || sheetName.endsWith(LCB_SHEET_SUFFIX)) {
                    boolean bl = true;
                    return bl;
                }
                ++sheetNumber;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public void parseFile() throws RulesException, IOException {
        this.result_ = new Hashtable();
        this.availablePrefixes_ = new HashSet();
        HydroxyEncoding hydroxies = Settings.getLcbHydroxyEncoding();
        Hashtable<String, Short> encodedHydroxyStrings = new Hashtable<String, Short>();
        for (Object hydroxyObject : hydroxies.keySet()) {
            short hydroxyKey = Short.parseShort((String)hydroxyObject);
            encodedHydroxyStrings.put((String)hydroxies.get(hydroxyObject), hydroxyKey);
            if (hydroxyKey <= this.highestHydroxyNumber_) continue;
            this.highestHydroxyNumber_ = hydroxyKey;
        }
        try (FileInputStream myxls = new FileInputStream(this.inputFile_);){
            Workbook workbook = null;
            if (this.inputFile_.getAbsolutePath().endsWith(".xlsx")) {
                workbook = new XSSFWorkbook(myxls);
            } else if (this.inputFile_.getAbsolutePath().endsWith(".xls")) {
                workbook = new HSSFWorkbook(myxls);
            }
            for (int sheetNumber = 0; sheetNumber != workbook.getNumberOfSheets(); ++sheetNumber) {
                String sheetName = workbook.getSheetAt(sheetNumber).getSheetName();
                Sheet sheet = null;
                String hydrKey = null;
                for (String key : encodedHydroxyStrings.keySet()) {
                    if (!sheetName.equalsIgnoreCase(key + SPB_SHEET_SUFFIX) && !sheetName.equalsIgnoreCase(key + LCB_SHEET_SUFFIX)) continue;
                    sheet = workbook.getSheetAt(sheetNumber);
                    hydrKey = key;
                    break;
                }
                if (sheet == null) continue;
                this.result_.put(hydrKey, this.parseSheet(sheet, ((Short)encodedHydroxyStrings.get(hydrKey)).shortValue()));
                for (Hashtable sameC : ((Hashtable)this.result_.get(hydrKey)).values()) {
                    for (Hashtable sameDb : sameC.values()) {
                        for (Hashtable sameOx : sameDb.values()) {
                            for (FattyAcidVO fa : sameOx.values()) {
                                fa.correctChainType((short)3);
                            }
                        }
                    }
                }
            }
            if (this.result_.size() == 0) {
                throw new RulesException("A long chain base library must contain at least one sheet starting with the hydroxylation code, followed by \"SPB\", e.g. dSPB! The lib " + this.inputFile_.getName() + " has not!");
            }
            int previousResultNumber = 0;
            Hashtable otherHydroxyResults = null;
            double oxygenMass = Settings.getElementParser().getElementDetails("O").getMonoMass();
            for (int i = 0; i <= this.highestHydroxyNumber_; ++i) {
                String encoded = null;
                try {
                    encoded = hydroxies.getEncodedPrefix((short)i);
                }
                catch (HydroxylationEncodingException hdx) {
                    continue;
                }
                if (this.result_.containsKey(encoded)) {
                    previousResultNumber = i;
                    otherHydroxyResults = (Hashtable)this.result_.get(encoded);
                    continue;
                }
                if (otherHydroxyResults == null) {
                    for (int j = i + 1; j <= this.highestHydroxyNumber_; ++j) {
                        String otherEncoded;
                        try {
                            otherEncoded = hydroxies.getEncodedPrefix((short)j);
                        }
                        catch (HydroxylationEncodingException hdx) {
                            continue;
                        }
                        if (!this.result_.containsKey(otherEncoded)) continue;
                        previousResultNumber = j;
                        otherHydroxyResults = (Hashtable)this.result_.get(otherEncoded);
                    }
                }
                Hashtable currentHydroxy = new Hashtable();
                int hydroxyDifference = i - previousResultNumber;
                for (Integer cAtoms : otherHydroxyResults.keySet()) {
                    Hashtable otherCAtoms = (Hashtable)otherHydroxyResults.get(cAtoms);
                    Hashtable cAtomsRes = new Hashtable();
                    for (Integer dbs : otherCAtoms.keySet()) {
                        Hashtable otherDbs = (Hashtable)otherCAtoms.get(dbs);
                        Hashtable dbsRes = new Hashtable();
                        for (String prefix : otherDbs.keySet()) {
                            Hashtable otherOxs = (Hashtable)otherDbs.get(prefix);
                            Hashtable<String, FattyAcidVO> OxsRes = new Hashtable<String, FattyAcidVO>();
                            for (String oxState : otherOxs.keySet()) {
                                FattyAcidVO otherFA = (FattyAcidVO)otherOxs.get(oxState);
                                Hashtable<String, Integer> formulaCat = StaticUtils.categorizeFormula(otherFA.getFormula());
                                int oxygens = 0;
                                if (formulaCat.containsKey("O")) {
                                    oxygens = formulaCat.get("O");
                                }
                                formulaCat.put("O", oxygens += hydroxyDifference);
                                FattyAcidVO chainVO = new FattyAcidVO(3, otherFA.getPrefix(), otherFA.getcAtoms(), otherFA.getDoubleBonds(), i, otherFA.getMass() + (double)hydroxyDifference * oxygenMass, StaticUtils.getFormulaInHillNotation(formulaCat, true), otherFA.getOxState());
                                OxsRes.put(oxState, chainVO);
                            }
                            dbsRes.put(prefix, OxsRes);
                        }
                        cAtomsRes.put(dbs, dbsRes);
                    }
                    currentHydroxy.put(cAtoms, cAtomsRes);
                }
                this.result_.put(encoded, currentHydroxy);
            }
        }
        catch (ChemicalFormulaException e) {
            e.printStackTrace();
        }
    }
}

