/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.vos;

import at.tugraz.genome.lda.msn.vos.FragmentMultVO;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;

public class ExpressionForComparisonVO {
    private String globalMultiplier_;
    private Vector<FragmentMultVO> fragments_;

    public ExpressionForComparisonVO(Vector<FragmentMultVO> fragments, String globalMultiplier) {
        this.fragments_ = fragments;
        this.globalMultiplier_ = globalMultiplier;
    }

    public double getGlobalMultiplier() {
        return Double.parseDouble(this.globalMultiplier_);
    }

    public String getGlobalMultiplierString() {
        return this.globalMultiplier_;
    }

    public Vector<FragmentMultVO> getFragments() {
        return this.fragments_;
    }

    public double evaluateExpression(Hashtable<String, CgProbe> found, Float basePeak) {
        double sum = 0.0;
        for (FragmentMultVO multVO : this.fragments_) {
            double value = 0.0;
            if (multVO.getFragmentName().equalsIgnoreCase("$BASEPEAK")) {
                value = basePeak != null ? (double)basePeak.floatValue() : 0.0;
            } else if (found != null && found.containsKey(multVO.getFragmentName())) {
                value = found.get((Object)multVO.getFragmentName()).Area;
            }
            value *= multVO.getMultFactor();
            if (!multVO.isPositive()) {
                value *= -1.0;
            }
            sum += value;
        }
        return sum *= Double.parseDouble(this.globalMultiplier_);
    }

    public int getPosition() {
        int position = 0;
        for (FragmentMultVO frag : this.fragments_) {
            if (frag.getFragmentName().equalsIgnoreCase("$BASEPEAK")) continue;
            position = frag.getPosition();
            break;
        }
        return position;
    }

    public boolean containsFragment(String fragmentName) {
        boolean fragmentThere = false;
        for (FragmentMultVO fragment : this.fragments_) {
            if (!fragment.getFragmentName().equalsIgnoreCase(fragmentName)) continue;
            fragmentThere = true;
            break;
        }
        return fragmentThere;
    }

    public boolean isAbsoluteComparison() {
        if (Double.parseDouble(this.globalMultiplier_) <= 0.0) {
            return false;
        }
        boolean isAbsolute = false;
        for (FragmentMultVO frag : this.fragments_) {
            if (!frag.getFragmentName().equalsIgnoreCase("$BASEPEAK") || !(frag.getMultFactor() > 0.0)) continue;
            isAbsolute = true;
            break;
        }
        return isAbsolute;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpressionForComparisonVO other = (ExpressionForComparisonVO)obj;
        return Objects.equals(this.fragments_, other.fragments_) && Objects.equals(this.globalMultiplier_, other.globalMultiplier_);
    }
}

