/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.msn.vos;

import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.vos.SharedPeakContributionVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class SharedMS1PeakVO {
    private Vector<SharedPeakContributionVO> contributions_ = new Vector();

    public void addSharedInstance(QuantVO quantVO, LipidParameterSet set) {
        this.contributions_.add(new SharedPeakContributionVO(quantVO, set));
    }

    public boolean areThereMS2Hits() {
        for (SharedPeakContributionVO contrib : this.contributions_) {
            if (!(contrib.getSet() instanceof LipidomicsMSnSet)) continue;
            return true;
        }
        return false;
    }

    public Vector<SharedPeakContributionVO> getPartners() {
        return this.contributions_;
    }

    public void checkForDistinctFragments() {
        for (int i = 0; i != this.contributions_.size(); ++i) {
            SharedPeakContributionVO shared1 = this.contributions_.get(i);
            if (!(shared1.getSet() instanceof LipidomicsMSnSet)) continue;
            LipidomicsMSnSet set1 = (LipidomicsMSnSet)shared1.getSet();
            Hashtable<String, CgProbe> frags1 = this.buildFragmentHash(set1);
            Hashtable<String, CgProbe> distinctFragments = new Hashtable<String, CgProbe>();
            Hashtable<Integer, Boolean> msLevels = new Hashtable<Integer, Boolean>();
            for (String key1 : frags1.keySet()) {
                CgProbe probe1 = frags1.get(key1);
                if (probe1.isFromOtherSpecies()) continue;
                msLevels.put(probe1.getMsLevel(), true);
                boolean distinct = true;
                for (int j = 0; j != this.contributions_.size(); ++j) {
                    SharedPeakContributionVO shared2 = this.contributions_.get(j);
                    if (i == j || !(shared2.getSet() instanceof LipidomicsMSnSet)) continue;
                    LipidomicsMSnSet set2 = (LipidomicsMSnSet)shared2.getSet();
                    Hashtable<String, CgProbe> frags2 = this.buildFragmentHash(set2);
                    boolean foundOther = false;
                    for (String key2 : frags2.keySet()) {
                        CgProbe probe2 = frags2.get(key2);
                        if (probe2.isFromOtherSpecies() || !this.isInsideMz(probe1, probe2)) continue;
                        foundOther = true;
                        break;
                    }
                    if (!foundOther) continue;
                    distinct = false;
                    break;
                }
                if (!distinct) continue;
                distinctFragments.put(key1, probe1);
            }
            Hashtable<String, CgProbe> fragsFromOthers = new Hashtable<String, CgProbe>();
            for (int j = 0; j != this.contributions_.size(); ++j) {
                SharedPeakContributionVO shared2 = this.contributions_.get(j);
                if (i == j || !(shared2.getSet() instanceof LipidomicsMSnSet)) continue;
                LipidomicsMSnSet set2 = (LipidomicsMSnSet)shared2.getSet();
                Hashtable<String, CgProbe> frags2 = this.buildFragmentHash(set2);
                for (String key2 : frags2.keySet()) {
                    CgProbe probe2 = frags2.get(key2);
                    boolean found = false;
                    for (String key1 : frags1.keySet()) {
                        CgProbe probe1 = frags1.get(key1);
                        if (!this.isInsideMz(probe1, probe2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    for (CgProbe probe1 : fragsFromOthers.values()) {
                        if (!this.isInsideMz(probe1, probe2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    fragsFromOthers.put(shared2.getQuantVO().getAnalyteClass() + shared2.getSet().getNameStringWithoutRt() + "x" + key2, probe2);
                }
            }
            if (distinctFragments.size() > 0) {
                shared1.setDistinctFragments(distinctFragments);
            }
            shared1.setFoundFragments(frags1);
            shared1.setFragsFromOthers(fragsFromOthers);
            shared1.setMsLevels(msLevels);
        }
    }

    private Hashtable<String, CgProbe> buildFragmentHash(LipidomicsMSnSet set) {
        Hashtable<String, CgProbe> frags = new Hashtable<String, CgProbe>();
        for (String fragName : set.getHeadGroupFragments().keySet()) {
            frags.put(fragName, set.getHeadGroupFragments().get(fragName));
        }
        Hashtable<String, Hashtable<String, CgProbe>> chainFragments = set.getChainFragments();
        for (String faName : chainFragments.keySet()) {
            Hashtable<String, CgProbe> chainFrags = chainFragments.get(faName);
            for (String fragName : chainFrags.keySet()) {
                CgProbe probe = chainFrags.get(fragName);
                String otherProbe = null;
                for (String other : frags.keySet()) {
                    if (!this.isInsideMz(probe, frags.get(other))) continue;
                    otherProbe = other;
                    break;
                }
                if (otherProbe != null && !(probe.Area > frags.get(otherProbe).Area)) continue;
                if (otherProbe != null) {
                    frags.remove(otherProbe);
                }
                frags.put(faName + ";" + fragName, probe);
            }
        }
        return frags;
    }

    private boolean isInsideMz(CgProbe probe1, CgProbe probe2) {
        boolean inside = false;
        if (probe1.Mz < probe2.Mz) {
            if (probe1.Mz + probe1.UpperMzBand > probe2.Mz - probe2.LowerMzBand) {
                inside = true;
            }
        } else if (probe2.Mz + probe2.UpperMzBand > probe1.Mz - probe1.LowerMzBand) {
            inside = true;
        }
        return inside;
    }

    public boolean hasAnyPartnerDistinctFragments() {
        for (SharedPeakContributionVO contr : this.contributions_) {
            if (!contr.hasDistinctFragments()) continue;
            return true;
        }
        return false;
    }

    public void removePartners(Vector<Integer> partnersToRemove) {
        for (int i = partnersToRemove.size() - 1; i != -1; --i) {
            this.contributions_.remove(partnersToRemove.get(i));
        }
    }

    public boolean isSpectrumContributionMuchLower(float threshold, SharedPeakContributionVO ofInterest) {
        boolean isMuchLower = false;
        float totalContribution = 0.0f;
        for (CgProbe probe : ofInterest.getDistinctFragments().values()) {
            totalContribution += probe.Area;
        }
        for (SharedPeakContributionVO other : this.contributions_) {
            if (ofInterest.getQuantVO().equals(other.getQuantVO())) continue;
            float otherContrib = 0.0f;
            for (CgProbe probe : other.getDistinctFragments().values()) {
                otherContrib += probe.Area;
            }
            if (!(threshold > totalContribution / (totalContribution + otherContrib))) continue;
            isMuchLower = true;
            break;
        }
        return isMuchLower;
    }

    public boolean areAnyOfTheseAdductsPresent(Set<String> adducts) {
        boolean there = false;
        for (SharedPeakContributionVO contr : this.contributions_) {
            if (!adducts.contains(StaticUtils.getRuleName(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getModName()))) continue;
            there = true;
            break;
        }
        return there;
    }

    public boolean haveAllChooseOnRtSetToTrue() {
        boolean allTrue = this.contributions_.size() > 1;
        for (SharedPeakContributionVO contr : this.contributions_) {
            try {
                if (RulesContainer.choseMoreLikelyRtWhenEqualMSn(StaticUtils.getRuleName(contr.getQuantVO().getAnalyteClass(), contr.getQuantVO().getModName()))) continue;
                allTrue = false;
                break;
            }
            catch (NoRuleException | RulesException | SpectrummillParserException | IOException e) {
                allTrue = false;
            }
        }
        return allTrue;
    }
}

