/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.parser;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.alex123.TargetlistDirParser;
import at.tugraz.genome.lda.alex123.TargetlistParser;
import at.tugraz.genome.lda.alex123.vos.TargetlistEntry;
import at.tugraz.genome.lda.exception.AlexTargetlistParserException;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.ExcelInputFileException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.LipidCombinameEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.RulesContainer;
import at.tugraz.genome.lda.msn.vos.FattyAcidVO;
import at.tugraz.genome.lda.parser.ModificationParser;
import at.tugraz.genome.lda.utils.RangeInteger;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleBondPositionVO;
import at.tugraz.genome.lda.vos.QuantVO;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.parser.spectrummill.ElementConfigParser;
import at.tugraz.genome.maspectras.utils.Calculator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MassListParser {
    private String quantFile_;
    private float minusTime_;
    private float plusTime_;
    private int amountOfIsotopes_;
    private int isotopesMustMatch_;
    private boolean searchUnknownTime_;
    private float rtShift_;
    private float lowestRetTime_;
    private float highestRetTime_;
    private boolean respectMassShift_;
    private boolean positiveIonMode_;
    private LinkedHashMap<String, Integer> classSequence_;
    private LinkedHashMap<String, Vector<String>> analyteSequence_;
    private Hashtable<String, Boolean> adductInsensitiveRtFilter_;
    private Hashtable<String, Boolean> bestMatchBySpectrumCoverage_;
    private Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects_;
    private Hashtable<String, Float> fixedStartTime_;
    private Hashtable<String, Float> fixedStopTime_;
    private Hashtable<String, Integer> ohNumber_;
    private Hashtable<String, RangeInteger> ohRange_;

    public MassListParser(String quantFile) throws IOException, SpectrummillParserException, ExcelInputFileException, ChemicalFormulaException, RulesException, HydroxylationEncodingException {
        this(quantFile, 0.0f, 0.0f, 0, 0, true, 0.0f, 0.0f, 0.0f, true);
    }

    public MassListParser(String quantFile, float minusTime, float plusTime, int amountOfIsotopes, int isotopesMustMatch, boolean searchUnknownTime, float rtShift, float lowestRetTime, float highestRetTime) throws IOException, SpectrummillParserException, ExcelInputFileException, ChemicalFormulaException, RulesException, HydroxylationEncodingException {
        this(quantFile, minusTime, plusTime, amountOfIsotopes, isotopesMustMatch, searchUnknownTime, rtShift, lowestRetTime, highestRetTime, true);
    }

    public MassListParser(String quantFile, float minusTime, float plusTime, int amountOfIsotopes, int isotopesMustMatch, boolean searchUnknownTime, float rtShift, float lowestRetTime, float highestRetTime, boolean respectMassShift) throws IOException, SpectrummillParserException, ExcelInputFileException, ChemicalFormulaException, RulesException, HydroxylationEncodingException {
        this.quantFile_ = quantFile;
        this.minusTime_ = minusTime;
        this.plusTime_ = plusTime;
        this.amountOfIsotopes_ = amountOfIsotopes;
        this.isotopesMustMatch_ = isotopesMustMatch;
        this.searchUnknownTime_ = searchUnknownTime;
        this.rtShift_ = rtShift;
        this.lowestRetTime_ = lowestRetTime;
        this.highestRetTime_ = highestRetTime;
        this.respectMassShift_ = respectMassShift;
        this.classSequence_ = new LinkedHashMap();
        this.analyteSequence_ = new LinkedHashMap();
        this.adductInsensitiveRtFilter_ = new Hashtable();
        this.bestMatchBySpectrumCoverage_ = new Hashtable();
        this.quantObjects_ = new Hashtable();
        this.fixedStartTime_ = new Hashtable();
        this.fixedStopTime_ = new Hashtable();
        this.ohNumber_ = new Hashtable();
        this.ohRange_ = new Hashtable();
        this.parseTargetListFile();
    }

    public MassListParser(String quantFile, float minusTime, float plusTime, int amountOfIsotopes, int isotopesMustMatch, boolean searchUnknownTime, float basePeakCutoff, float rtShift, float lowestRetTime, float highestRetTime, boolean respectMassShift, boolean positiveIonMode) throws IOException, SpectrummillParserException, AlexTargetlistParserException, ChemicalFormulaException, RulesException {
        this.quantFile_ = quantFile;
        this.minusTime_ = minusTime;
        this.plusTime_ = plusTime;
        this.amountOfIsotopes_ = amountOfIsotopes;
        this.isotopesMustMatch_ = isotopesMustMatch;
        this.searchUnknownTime_ = searchUnknownTime;
        this.rtShift_ = rtShift;
        this.lowestRetTime_ = lowestRetTime;
        this.highestRetTime_ = highestRetTime;
        this.respectMassShift_ = respectMassShift;
        this.positiveIonMode_ = positiveIonMode;
        this.classSequence_ = new LinkedHashMap();
        this.analyteSequence_ = new LinkedHashMap();
        this.adductInsensitiveRtFilter_ = new Hashtable();
        this.bestMatchBySpectrumCoverage_ = new Hashtable();
        this.quantObjects_ = new Hashtable();
        this.fixedStartTime_ = new Hashtable();
        this.fixedStopTime_ = new Hashtable();
        this.ohNumber_ = new Hashtable();
        this.ohRange_ = new Hashtable();
        this.parseAlex123TargetList();
    }

    private void parseTargetListFile() throws IOException, SpectrummillParserException, ExcelInputFileException, ChemicalFormulaException, RulesException, HydroxylationEncodingException {
        FileInputStream myxls = new FileInputStream(this.quantFile_);
        Workbook workbook = null;
        if (this.quantFile_.endsWith(".xlsx")) {
            workbook = new XSSFWorkbook(myxls);
        } else if (this.quantFile_.endsWith(".xls")) {
            workbook = new HSSFWorkbook(myxls);
        }
        boolean excelOK = false;
        ElementConfigParser aaParser = Settings.getElementParser();
        for (int sheetNumber = 0; sheetNumber != workbook.getNumberOfSheets(); ++sheetNumber) {
            Hashtable quantsOfClass = new Hashtable();
            Hashtable quantsOfOxClass = new Hashtable();
            Vector<String> analytes = new Vector<String>();
            Vector<String> oxAnalytes = new Vector<String>();
            Sheet sheet = workbook.getSheetAt(sheetNumber);
            boolean rtFilterInsensitive = false;
            boolean pickBestMatchBySpectrumCoverage = false;
            int sideChainColumn = -1;
            int doubleBondColumn = -1;
            int molecularSpeciesWithDoubleBondPositionsColumn = -1;
            int oxStateColumn = -1;
            Hashtable<Integer, String> massOfInterestColumns = new Hashtable<Integer, String>();
            Hashtable<String, Hashtable<String, Integer>> adductComposition = new Hashtable<String, Hashtable<String, Integer>>();
            Hashtable<String, Integer> charges = new Hashtable<String, Integer>();
            Hashtable<String, Integer> multi = new Hashtable<String, Integer>();
            int retTimeColumn = -1;
            boolean foundColumns = false;
            float fixedStartTime = 0.0f;
            float fixedEndTime = Float.MAX_VALUE;
            Hashtable elementColumns = new Hashtable();
            int msLevel = 1;
            int ohNumber = -1;
            RangeInteger ohRange = null;
            for (int rowCount = 0; rowCount != sheet.getLastRowNum() + 1; ++rowCount) {
                float usedPlusTime;
                Row row = sheet.getRow(rowCount);
                String sideChain = "";
                int doubleBonds = -1;
                String oxState = "";
                Hashtable elementalComposition = new Hashtable();
                Hashtable massesOfInterest = new Hashtable();
                float retTime = -1.0f;
                String molecularSpeciesWithDB = null;
                Hashtable<Integer, String> possibleElementColumns = new Hashtable<Integer, String>();
                for (int i = 0; row != null && i != row.getLastCellNum() + 1; ++i) {
                    Cell cell = row.getCell(i);
                    String contents = "";
                    Double numeric = null;
                    int cellType = -1;
                    if (cell != null) {
                        cellType = cell.getCellType();
                    }
                    if (cellType == 1) {
                        contents = cell.getStringCellValue();
                        try {
                            if (contents != null) {
                                numeric = new Double(contents.replaceAll(",", "."));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (cellType == 0 || cellType == 2) {
                        numeric = cell.getNumericCellValue();
                        contents = String.valueOf(numeric);
                    }
                    if (contents != null) {
                        contents = contents.trim();
                    }
                    if (!foundColumns) {
                        if (contents.equalsIgnoreCase("Seitenkette") || contents.equalsIgnoreCase("Name")) {
                            sideChainColumn = i;
                            continue;
                        }
                        if (contents.equalsIgnoreCase("dbs") || contents.equalsIgnoreCase("dbs_TAG")) {
                            doubleBondColumn = i;
                            continue;
                        }
                        if (contents.equalsIgnoreCase("PSM")) {
                            oxStateColumn = i;
                            continue;
                        }
                        if (contents.startsWith("mass") && contents.contains("(") && contents.contains(")")) {
                            String[] formulaAndName = StaticUtils.extractFormulaAndAdductName(contents);
                            adductComposition.put(formulaAndName[1], StaticUtils.categorizeFormula(formulaAndName[0], true));
                            massOfInterestColumns.put(i, formulaAndName[1]);
                            charges.put(formulaAndName[1], Integer.parseInt(formulaAndName[2]));
                            multi.put(formulaAndName[1], Integer.parseInt(formulaAndName[3]));
                            continue;
                        }
                        if (contents.equalsIgnoreCase("tR (min)")) {
                            retTimeColumn = i;
                            continue;
                        }
                        if (contents.startsWith("Start-RT:")) {
                            try {
                                fixedStartTime = Float.parseFloat(contents.substring("Start-RT:".length()).trim().replaceAll(",", "."));
                                this.fixedStartTime_.put(sheet.getSheetName(), Float.valueOf(fixedStartTime));
                            }
                            catch (NumberFormatException nfx) {
                                nfx.printStackTrace();
                            }
                            continue;
                        }
                        if (contents.startsWith("Stop-RT:")) {
                            try {
                                fixedEndTime = Float.parseFloat(contents.substring("Stop-RT:".length()).trim().replaceAll(",", "."));
                                this.fixedStopTime_.put(sheet.getSheetName(), Float.valueOf(fixedEndTime));
                            }
                            catch (NumberFormatException nfx) {}
                            continue;
                        }
                        if (contents.startsWith("Mass-Trace:")) {
                            try {
                                msLevel = Integer.parseInt(contents.substring("Mass-Trace:".length()).trim().replaceAll(",", "."));
                            }
                            catch (NumberFormatException nfx) {}
                            continue;
                        }
                        if (contents.trim().length() == 1 || contents.trim().length() == 2) {
                            boolean ok = false;
                            if (!Character.isUpperCase(contents.trim().toCharArray()[0])) continue;
                            if (contents.trim().length() == 2) {
                                if (Character.isLowerCase(contents.trim().toCharArray()[1])) {
                                    ok = true;
                                }
                            } else {
                                ok = true;
                            }
                            if (!ok) continue;
                            String element = contents.trim();
                            if (aaParser.isElementAvailable(element)) {
                                possibleElementColumns.put(i, element);
                                continue;
                            }
                            if (sideChainColumn <= -1) continue;
                            System.out.println("Warning: The elemental column \"" + element + "\" does not seem to be a chemical element!");
                            continue;
                        }
                        if (contents.trim().equalsIgnoreCase("adductInsensitiveRtFilter")) {
                            rtFilterInsensitive = true;
                            continue;
                        }
                        if (contents.startsWith("OH-Number:")) {
                            String ohString = contents.substring("OH-Number:".length()).trim().replaceAll(",", ".");
                            try {
                                ohNumber = Integer.parseInt(ohString);
                            }
                            catch (NumberFormatException nfx) {
                                ohNumber = Settings.getLcbHydroxyEncoding().getHydroxyNumber(ohString).shortValue();
                            }
                            this.ohNumber_.put(sheet.getSheetName(), ohNumber);
                            continue;
                        }
                        if (contents.startsWith("OH-Range:")) {
                            String ohRangeString = contents.substring("OH-Range:".length()).trim().replaceAll(",", ".");
                            String[] ohRangeParts = ohRangeString.split("-");
                            boolean error = false;
                            try {
                                int start;
                                if (ohRangeParts.length > 2) {
                                    error = true;
                                }
                                int stop = start = Integer.parseInt(ohRangeParts[0]);
                                if (ohRangeParts.length == 2) {
                                    stop = Integer.parseInt(ohRangeParts[1]);
                                }
                                ohRange = new RangeInteger(start, stop);
                            }
                            catch (NumberFormatException nfx) {
                                error = true;
                            }
                            if (error) {
                                throw new HydroxylationEncodingException("The value \"OH-Range\" must be a single integer, or a range in the format $lower$-$higher$; the value \"" + ohRangeString + "\" in sheet " + sheet.getSheetName() + " does not comply!");
                            }
                            this.ohRange_.put(sheet.getSheetName(), ohRange);
                            continue;
                        }
                        if (contents.trim().equalsIgnoreCase("pickBestMatchBySpectrumCoverage")) {
                            pickBestMatchBySpectrumCoverage = true;
                            continue;
                        }
                        if (!contents.equalsIgnoreCase("mol. species")) continue;
                        molecularSpeciesWithDoubleBondPositionsColumn = i;
                        continue;
                    }
                    if (i == sideChainColumn && contents != null & contents.length() > 0) {
                        sideChain = numeric != null ? String.valueOf((int)Math.round(numeric)) : contents;
                    }
                    if (i == doubleBondColumn && contents != null && contents.length() > 0) {
                        doubleBonds = numeric.intValue();
                    }
                    if (i == oxStateColumn && contents != null && contents.length() > 0) {
                        oxState = contents;
                    }
                    if (elementColumns.containsKey(i) && contents.length() > 0) {
                        int value = 0;
                        if (numeric != null && contents.endsWith(".0")) {
                            value = (int)Math.round(numeric);
                        } else {
                            try {
                                value = Integer.parseInt(contents);
                            }
                            catch (NumberFormatException nfx3) {
                                System.out.println("Warning: The elemental column \"" + (String)elementColumns.get(i) + "\" does not seem to be a chemical element, since float values are there -> I remove it!");
                                elementColumns.remove(i);
                            }
                        }
                        if (value > 0) {
                            elementalComposition.put(elementColumns.get(i), value);
                        }
                    }
                    if (massOfInterestColumns.containsKey(i) && contents != null & contents.length() > 0) {
                        double massOfInterest = numeric;
                        if (this.respectMassShift_) {
                            massOfInterest += LipidomicsConstants.getMassShift();
                        }
                        massesOfInterest.put(massOfInterestColumns.get(i), massOfInterest);
                    }
                    if (i == retTimeColumn && contents != null & contents.length() > 0) {
                        retTime = numeric.floatValue();
                        retTime += this.rtShift_;
                    }
                    if (i != molecularSpeciesWithDoubleBondPositionsColumn || !(contents != null & contents.length() > 0)) continue;
                    molecularSpeciesWithDB = contents;
                }
                if (sideChainColumn != -1 && possibleElementColumns.size() > 0 && massOfInterestColumns.size() > 0 && retTimeColumn != -1 && !foundColumns) {
                    foundColumns = true;
                    elementColumns = new Hashtable(possibleElementColumns);
                }
                if (!foundColumns || sideChain == null || sideChain.length() <= 0 || massesOfInterest.size() <= 0) continue;
                float usedMinusTime = new Float(this.minusTime_).floatValue();
                if (usedMinusTime < 0.0f) {
                    usedMinusTime *= -1.0f;
                }
                if ((usedPlusTime = new Float(this.plusTime_).floatValue()) < 0.0f) {
                    usedPlusTime *= -1.0f;
                }
                if (!(retTime > 0.0f) && !this.searchUnknownTime_) continue;
                if (fixedStartTime > 0.0f || fixedEndTime < Float.MAX_VALUE && fixedStartTime < fixedEndTime) {
                    if (retTime > 0.0f) {
                        if (fixedStartTime < retTime && retTime < fixedEndTime) {
                            if (fixedStartTime > retTime - usedMinusTime) {
                                usedMinusTime = retTime - fixedStartTime;
                            }
                            if (fixedEndTime < retTime + usedPlusTime) {
                                usedPlusTime = fixedEndTime - retTime;
                            }
                        }
                    } else {
                        float startTime = this.lowestRetTime_;
                        float stopTime = this.highestRetTime_;
                        if (fixedStartTime > startTime) {
                            startTime = fixedStartTime;
                        }
                        if (fixedEndTime < stopTime) {
                            stopTime = fixedEndTime;
                        }
                        retTime = (startTime + stopTime) / 2.0f;
                        usedMinusTime = retTime - startTime;
                        usedPlusTime = stopTime - retTime;
                    }
                }
                int startOh = 0;
                int stopOh = 0;
                if (ohNumber > -1) {
                    startOh = ohNumber;
                    stopOh = ohNumber;
                    if (ohRange != null) {
                        startOh = ohRange.getStart();
                        stopOh = ohRange.getStop();
                    }
                }
                String[] oxStates = oxState.split(";");
                if (oxState.length() == 0) {
                    for (int oh = startOh; oh < stopOh + 1; ++oh) {
                        Object modName2;
                        Hashtable<Object, QuantVO> quantsOfAnalyte = new Hashtable<Object, QuantVO>();
                        String analEncoded = null;
                        Hashtable<String, Integer> correctedElementalComposition = new Hashtable<String, Integer>(elementalComposition);
                        double ohDiff = 0.0;
                        int ohToUse = -1;
                        if (ohNumber > -1) {
                            ohToUse = oh;
                            if (oh != ohNumber) {
                                int oxygens = 0;
                                if (correctedElementalComposition.containsKey("O")) {
                                    oxygens = (Integer)correctedElementalComposition.get("O");
                                }
                                if ((oxygens += oh - ohNumber) < 0) continue;
                                correctedElementalComposition.put("O", oxygens);
                                ohDiff = (double)(oh - ohNumber) * Settings.getElementParser().getElementDetails("O").getMonoMass();
                            }
                        }
                        for (Object modName2 : massesOfInterest.keySet()) {
                            Hashtable modElements = (Hashtable)adductComposition.get(modName2);
                            Integer charge = (Integer)charges.get(modName2);
                            double massOfInterest = (Double)massesOfInterest.get(modName2) + ohDiff / (double)charge.intValue();
                            Integer mult = (Integer)multi.get(modName2);
                            String[] formulas = this.getFormulasAsString(correctedElementalComposition, modElements, mult);
                            String analyteFormula = formulas[0];
                            String modificationFormula = formulas[1];
                            String chemicalFormula = formulas[2];
                            if (chemicalFormula.indexOf("-") != -1) continue;
                            Object[] distris = this.getTheoreticalIsoDistributions(aaParser, this.isotopesMustMatch_, this.amountOfIsotopes_, chemicalFormula);
                            Vector mustMatchProbabs = (Vector)distris[0];
                            Vector probabs = (Vector)distris[1];
                            int negativeStartValue = (Integer)distris[2];
                            QuantVO quantVO = new QuantVO(sheet.getSheetName(), sideChain, doubleBonds, ohToUse, analyteFormula, massOfInterest, charge, (String)modName2, modificationFormula, retTime, usedMinusTime, usedPlusTime, mustMatchProbabs, probabs, negativeStartValue, "");
                            analEncoded = quantVO.getAnalyteName();
                            quantsOfAnalyte.put(modName2, quantVO);
                        }
                        String analyteName = StaticUtils.generateLipidNameString(analEncoded != null ? analEncoded : sideChain, (Integer)doubleBonds, -1, "");
                        if (!quantsOfClass.containsKey(analyteName)) {
                            analytes.add(analyteName);
                            quantsOfClass.put(analyteName, quantsOfAnalyte);
                        } else if (!this.hasValidInfoForOmegaAssignment(molecularSpeciesWithDB, retTime)) {
                            System.out.println(String.format("Ignoring duplicate analyte %s in mass list (line %s)!", analyteName, rowCount + 1));
                        }
                        if (!this.hasValidInfoForOmegaAssignment(molecularSpeciesWithDB, retTime)) continue;
                        modName2 = quantsOfAnalyte.keySet().iterator();
                        while (modName2.hasNext()) {
                            String mod = (String)modName2.next();
                            try {
                                Vector<FattyAcidVO> chainCombination = StaticUtils.decodeFAsFromHumanReadableName(molecularSpeciesWithDB, Settings.getFaHydroxyEncoding(), Settings.getLcbHydroxyEncoding(), false, null);
                                DoubleBondPositionVO doubleBondPositionVO = new DoubleBondPositionVO(chainCombination, retTime);
                                ((QuantVO)((Hashtable)quantsOfClass.get(analyteName)).get(mod)).addInfoForOmegaAssignment(doubleBondPositionVO);
                            }
                            catch (LipidCombinameEncodingException ex) {
                                System.out.println(ex.getMessage());
                            }
                        }
                    }
                    continue;
                }
                for (String oxMod : oxStates) {
                    oxMod = oxMod.replaceAll("\\s", "");
                    for (int oh = startOh; oh < stopOh + 1; ++oh) {
                        Hashtable<String, QuantVO> quantsOfAnalyte = new Hashtable<String, QuantVO>();
                        Hashtable<String, QuantVO> quantsOfOxAnalyte = new Hashtable<String, QuantVO>();
                        String analEncoded = null;
                        Hashtable<String, Integer> correctedElementalComposition = new Hashtable<String, Integer>(elementalComposition);
                        double ohDiff = 0.0;
                        int ohToUse = -1;
                        if (ohNumber > -1) {
                            ohToUse = oh;
                            if (oh != ohNumber) {
                                int oxygens = 0;
                                if (correctedElementalComposition.containsKey("O")) {
                                    oxygens = correctedElementalComposition.get("O");
                                }
                                if ((oxygens += oh - ohNumber) < 0) continue;
                                correctedElementalComposition.put("O", oxygens);
                                ohDiff = (double)(oh - ohNumber) * Settings.getElementParser().getElementDetails("O").getMonoMass();
                            }
                        }
                        ModificationParser mp = new ModificationParser(oxMod);
                        mp.parse();
                        correctedElementalComposition = mp.getNewChemicalComposition(correctedElementalComposition);
                        for (String modName : massesOfInterest.keySet()) {
                            String analyteClass = sheet.getSheetName();
                            Hashtable modElements = (Hashtable)adductComposition.get(modName);
                            Integer charge = (Integer)charges.get(modName);
                            double massOfInterest = mp.getNewMass((Double)massesOfInterest.get(modName) + ohDiff / (double)charge.intValue());
                            Integer mult = (Integer)multi.get(modName);
                            String[] formulas = this.getFormulasAsString(correctedElementalComposition, modElements, mult);
                            String analyteFormula = formulas[0];
                            String modificationFormula = formulas[1];
                            String chemicalFormula = formulas[2];
                            if (chemicalFormula.indexOf("-") != -1) continue;
                            Object[] distris = this.getTheoreticalIsoDistributions(aaParser, this.isotopesMustMatch_, this.amountOfIsotopes_, chemicalFormula);
                            Vector mustMatchProbabs = (Vector)distris[0];
                            Vector probabs = (Vector)distris[1];
                            int negativeStartValue = (Integer)distris[2];
                            if (!oxMod.equals("")) {
                                analyteClass = "ox" + analyteClass;
                            }
                            QuantVO quantVO = new QuantVO(analyteClass, sideChain, doubleBonds, ohToUse, analyteFormula, massOfInterest, charge, modName, modificationFormula, retTime, usedMinusTime, usedPlusTime, mustMatchProbabs, probabs, negativeStartValue, oxMod);
                            analEncoded = quantVO.getAnalyteName();
                            if (oxMod.equals("")) {
                                quantsOfAnalyte.put(modName, quantVO);
                                continue;
                            }
                            quantsOfOxAnalyte.put(modName, quantVO);
                        }
                        String analyteName = StaticUtils.generateLipidNameString(analEncoded != null ? analEncoded : sideChain, (Integer)doubleBonds, -1, oxMod);
                        if (oxMod.equals("")) {
                            analytes.add(analyteName);
                            quantsOfClass.put(analyteName, quantsOfAnalyte);
                            continue;
                        }
                        oxAnalytes.add(analyteName);
                        quantsOfOxClass.put(analyteName, quantsOfOxAnalyte);
                    }
                }
            }
            this.quantObjects_.put(sheet.getSheetName(), quantsOfClass);
            this.analyteSequence_.put(sheet.getSheetName(), analytes);
            this.classSequence_.put(sheet.getSheetName(), msLevel);
            this.adductInsensitiveRtFilter_.put(sheet.getSheetName(), rtFilterInsensitive);
            this.bestMatchBySpectrumCoverage_.put(sheet.getSheetName(), pickBestMatchBySpectrumCoverage);
            if (!oxAnalytes.isEmpty()) {
                this.quantObjects_.put("ox" + sheet.getSheetName(), quantsOfOxClass);
                this.analyteSequence_.put("ox" + sheet.getSheetName(), oxAnalytes);
                this.classSequence_.put("ox" + sheet.getSheetName(), msLevel);
                this.adductInsensitiveRtFilter_.put("ox" + sheet.getSheetName(), rtFilterInsensitive);
                this.bestMatchBySpectrumCoverage_.put("ox" + sheet.getSheetName(), pickBestMatchBySpectrumCoverage);
            }
            if (!foundColumns) continue;
            excelOK = true;
        }
        ((InputStream)myxls).close();
        if (!excelOK) {
            throw new ExcelInputFileException("The Excel file is not valid!");
        }
        if (LipidomicsConstants.isShotgun() != 2) {
            this.checkForIsobaricSpecies(this.classSequence_, this.analyteSequence_, this.quantObjects_);
        }
    }

    @Deprecated
    public Vector getResultsVector() {
        Vector<Map<String, Serializable>> results = new Vector<Map<String, Serializable>>();
        results.add(this.classSequence_);
        results.add(this.analyteSequence_);
        results.add(this.adductInsensitiveRtFilter_);
        results.add(this.bestMatchBySpectrumCoverage_);
        results.add(this.quantObjects_);
        return results;
    }

    private void parseAlex123TargetList() throws IOException, SpectrummillParserException, AlexTargetlistParserException, ChemicalFormulaException, RulesException {
        File file = new File(this.quantFile_);
        LinkedHashMap<String, LinkedHashMap<String, LinkedHashMap<String, TargetlistEntry>>> sortedEntries = null;
        if (file.isFile() && file.getName().endsWith(".txt")) {
            Vector<Hashtable<Integer, Vector<TargetlistEntry>>> parsedEntries = new Vector<Hashtable<Integer, Vector<TargetlistEntry>>>();
            TargetlistParser parser = new TargetlistParser(this.quantFile_, this.positiveIonMode_);
            parser.parse();
            parsedEntries.add(parser.getResults());
            sortedEntries = TargetlistDirParser.sortEntriesForLDA(parsedEntries);
        } else if (file.isDirectory()) {
            TargetlistDirParser dirParser = new TargetlistDirParser(this.quantFile_, this.positiveIonMode_);
            dirParser.parse();
            sortedEntries = dirParser.getResults();
        }
        if (sortedEntries == null || sortedEntries.size() == 0) {
            throw new AlexTargetlistParserException("There are unusable entries in your target list");
        }
        ElementConfigParser elementParser = Settings.getElementParser();
        for (String className : sortedEntries.keySet()) {
            this.classSequence_.put(className, 1);
            LinkedHashMap<String, LinkedHashMap<String, TargetlistEntry>> classEntries = sortedEntries.get(className);
            Vector<String> analytes = new Vector<String>();
            Hashtable quantsOfClass = new Hashtable();
            for (String analyteOriginalName : classEntries.keySet()) {
                LinkedHashMap<String, TargetlistEntry> analyteEntries = classEntries.get(analyteOriginalName);
                String sideChain = "";
                int doubleBonds = -1;
                Hashtable<String, TargetlistEntry> quantsOfAnalyte = new Hashtable<String, TargetlistEntry>();
                for (String mod : analyteEntries.keySet()) {
                    TargetlistEntry entry = analyteEntries.get(mod);
                    sideChain = entry.getAnalyteName();
                    doubleBonds = entry.getDbs();
                    entry.setTimeConstraints(-1.0f, this.minusTime_, this.plusTime_);
                    Hashtable<String, Integer> formAnal = StaticUtils.categorizeFormula(entry.getAnalyteFormula());
                    Hashtable<String, Integer> formMod = StaticUtils.categorizeFormula(entry.getModFormula());
                    String[] formulas = this.getFormulasAsString(formAnal, formMod, 1);
                    String chemicalFormula = formulas[2];
                    Object[] distris = this.getTheoreticalIsoDistributions(elementParser, this.isotopesMustMatch_, this.amountOfIsotopes_, chemicalFormula);
                    Vector mustMatchProbabs = (Vector)distris[0];
                    Vector probabs = (Vector)distris[1];
                    int negativeStartValue = (Integer)distris[2];
                    entry.setDistributionValues(mustMatchProbabs, probabs, negativeStartValue);
                    quantsOfAnalyte.put(entry.getModName(), entry);
                }
                String analyteName = StaticUtils.generateLipidNameString(sideChain, (Integer)doubleBonds, -1, "");
                analytes.add(analyteName);
                quantsOfClass.put(analyteName, quantsOfAnalyte);
            }
            this.quantObjects_.put(className, quantsOfClass);
            this.analyteSequence_.put(className, analytes);
            this.adductInsensitiveRtFilter_.put(className, false);
            this.bestMatchBySpectrumCoverage_.put(className, false);
        }
        if (LipidomicsConstants.isShotgun() != 2) {
            this.checkForIsobaricSpecies(this.classSequence_, this.analyteSequence_, this.quantObjects_);
        }
    }

    private String[] getFormulasAsString(Hashtable<String, Integer> elementalComposition, Hashtable<String, Integer> modElements, int mult) {
        Hashtable<String, Integer> chemicalFormula = new Hashtable<String, Integer>(elementalComposition);
        for (String element : modElements.keySet()) {
            int amount = modElements.get(element);
            if (chemicalFormula.containsKey(element)) {
                amount += chemicalFormula.get(element).intValue();
            }
            chemicalFormula.put(element, amount);
        }
        String[] formulas = new String[]{StaticUtils.getFormulaInHillNotation(elementalComposition, true), StaticUtils.getFormulaInHillNotation(modElements, true), StaticUtils.getFormulaInHillNotation(chemicalFormula, true)};
        return formulas;
    }

    private Object[] getTheoreticalIsoDistributions(ElementConfigParser elementParser, int isotopesMustMatch, int amountOfIsotopes, String chemicalFormula) throws SpectrummillParserException {
        boolean negativeDistribution = false;
        Vector<Double> probabs = new Vector<Double>();
        if (amountOfIsotopes < isotopesMustMatch) {
            amountOfIsotopes = isotopesMustMatch;
        }
        if (amountOfIsotopes > 0) {
            Vector<Double> negDistri;
            Vector<Vector<Double>> bothDistris = elementParser.calculateChemicalFormulaIntensityDistribution(chemicalFormula, amountOfIsotopes + 1, false);
            probabs = bothDistris.get(0);
            if (bothDistris.size() > 1 && StaticUtils.useNegativeDistribution(probabs, negDistri = bothDistris.get(1))) {
                probabs = negDistri;
                negativeDistribution = true;
            }
        } else {
            probabs.add(1.0);
        }
        Vector<Double> mustMatchProbabs = new Vector();
        if (isotopesMustMatch > 0) {
            if (amountOfIsotopes == isotopesMustMatch) {
                mustMatchProbabs = new Vector(probabs);
            } else {
                Vector<Double> negDistri;
                Vector<Vector<Double>> bothDistris = elementParser.calculateChemicalFormulaIntensityDistribution(chemicalFormula, isotopesMustMatch + 1, false);
                mustMatchProbabs = bothDistris.get(0);
                if (bothDistris.size() > 1 && StaticUtils.useNegativeDistribution(mustMatchProbabs, negDistri = bothDistris.get(1))) {
                    mustMatchProbabs = negDistri;
                    negativeDistribution = true;
                }
            }
        }
        int negativeStartValue = 0;
        if (negativeDistribution) {
            negativeStartValue = mustMatchProbabs.size() * -1 + 1;
        }
        Object[] distris = new Object[]{mustMatchProbabs, probabs, negativeStartValue};
        return distris;
    }

    private boolean hasValidInfoForOmegaAssignment(String molecularSpeciesWithDB, float retTime) {
        return molecularSpeciesWithDB != null && retTime > 0.0f;
    }

    private void checkForIsobaricSpecies(LinkedHashMap<String, Integer> classSequence, LinkedHashMap<String, Vector<String>> analyteSequence, Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> quantObjects) throws RulesException, IOException, SpectrummillParserException {
        Vector<String> classes = new Vector<String>(classSequence.keySet());
        Hashtable<Integer, Vector> tenDaIsobaricClusters = new Hashtable<Integer, Vector>();
        for (int i = 0; i != classes.size(); ++i) {
            String lipidClass = classes.get(i);
            Vector<String> analytes = analyteSequence.get(lipidClass);
            Hashtable<String, Hashtable<String, QuantVO>> quantClass = quantObjects.get(lipidClass);
            for (int j = 0; j != analytes.size(); ++j) {
                String anal = analytes.get(j);
                Hashtable<String, QuantVO> quantAnal = quantClass.get(anal);
                for (String mod : quantAnal.keySet()) {
                    QuantVO quant = quantAnal.get(mod);
                    float mz = (float)quant.getAnalyteMass();
                    int clusterId = this.getTenDaClusterId(mz);
                    Vector vosOfCluster = new Vector();
                    if (tenDaIsobaricClusters.containsKey(clusterId)) {
                        vosOfCluster = (Vector)tenDaIsobaricClusters.get(clusterId);
                    }
                    vosOfCluster.add(quant);
                    tenDaIsobaricClusters.put(clusterId, vosOfCluster);
                }
            }
        }
        Hashtable<String, String> alreadyUsed = new Hashtable<String, String>();
        for (int i = 0; i != classes.size(); ++i) {
            String lipidClass = classes.get(i);
            Vector<String> analytes = analyteSequence.get(lipidClass);
            Hashtable<String, Hashtable<String, QuantVO>> quantClass = quantObjects.get(lipidClass);
            for (int j = 0; j != analytes.size(); ++j) {
                String anal = analytes.get(j);
                Hashtable<String, QuantVO> quantAnal = quantClass.get(anal);
                for (String mod : quantAnal.keySet()) {
                    QuantVO quant1 = quantAnal.get(mod);
                    if (quant1.isQuantifiedByOtherIsobar()) continue;
                    float tol = LipidomicsConstants.getCoarseChromMzTolerance((float)quant1.getAnalyteMass());
                    float sameTol = tol / 5.0f;
                    try {
                        RulesContainer.getAmountOfChains(StaticUtils.getRuleName(quant1.getAnalyteClass(), quant1.getModName()));
                    }
                    catch (NoRuleException nrx) {
                        if (j != 0) continue;
                        System.out.println(nrx.getMessage());
                        continue;
                    }
                    float lowerMz = (float)quant1.getAnalyteMass() - tol;
                    float upperMz = (float)quant1.getAnalyteMass() + tol;
                    float lowerSame = (float)quant1.getAnalyteMass() - sameTol;
                    float upperSame = (float)quant1.getAnalyteMass() + sameTol;
                    int clusterId = this.getTenDaClusterId(lowerMz);
                    Vector toCompare = new Vector();
                    if (tenDaIsobaricClusters.containsKey(clusterId)) {
                        toCompare.addAll((Collection)tenDaIsobaricClusters.get(clusterId));
                    }
                    if (clusterId != this.getTenDaClusterId(upperMz) && tenDaIsobaricClusters.containsKey(clusterId = this.getTenDaClusterId(upperMz))) {
                        toCompare.addAll((Collection)tenDaIsobaricClusters.get(clusterId));
                    }
                    for (QuantVO quant2 : toCompare) {
                        boolean sameMass;
                        if (quant1.equals(quant2) || alreadyUsed.containsKey(this.getUniqueQuantVOString(quant2))) continue;
                        try {
                            RulesContainer.getAmountOfChains(StaticUtils.getRuleName(quant2.getAnalyteClass(), quant2.getModName()));
                        }
                        catch (NoRuleException nrx) {
                            if (j != 0) continue;
                            System.out.println(nrx.getMessage());
                            continue;
                        }
                        float mz2 = (float)quant2.getAnalyteMass();
                        boolean similarMass = lowerMz < mz2 && mz2 < upperMz;
                        boolean bl = sameMass = lowerSame < mz2 && mz2 < upperSame;
                        if (!similarMass) continue;
                        quant1.addIsobaricSpecies(quant2);
                        quant2.addIsobaricSpecies(quant1);
                        if (!sameMass) continue;
                        quant2.setQuantifiedByOtherIsobar(true);
                    }
                    String idString = this.getUniqueQuantVOString(quant1);
                    alreadyUsed.put(idString, idString);
                }
            }
        }
    }

    private int getTenDaClusterId(float mz) {
        return Math.round(Calculator.roundFloat(mz, 0, 1));
    }

    private String getUniqueQuantVOString(QuantVO vo) {
        return vo.getAnalyteClass() + "_;%" + vo.getIdString() + "_;%" + vo.getModName();
    }

    public LinkedHashMap<String, Integer> getClassSequence() {
        return this.classSequence_;
    }

    public LinkedHashMap<String, Vector<String>> getAnalyteSequence() {
        return this.analyteSequence_;
    }

    public Hashtable<String, Boolean> getAdductInsensitiveRtFilter() {
        return this.adductInsensitiveRtFilter_;
    }

    public Hashtable<String, Boolean> getBestMatchBySpectrumCoverage() {
        return this.bestMatchBySpectrumCoverage_;
    }

    public Hashtable<String, Hashtable<String, Hashtable<String, QuantVO>>> getQuantObjects() {
        return this.quantObjects_;
    }

    public Hashtable<String, Float> getFixedStartTime() {
        return this.fixedStartTime_;
    }

    public Hashtable<String, Float> getFixedStopTime() {
        return this.fixedStopTime_;
    }

    public Hashtable<String, Integer> getOHNumber() {
        return this.ohNumber_;
    }

    public Hashtable<String, RangeInteger> getOHRange() {
        return this.ohRange_;
    }

    public boolean isFirstRowRelevant(String cName) {
        return this.getAdductInsensitiveRtFilter().get(cName) != null || this.getBestMatchBySpectrumCoverage().get(cName) != null || this.getFixedStartTime().get(cName) != null || this.getFixedStopTime().get(cName) != null || this.getOHNumber().get(cName) != null || this.getOHRange().get(cName) != null;
    }
}

