/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.parser;

import at.tugraz.genome.lda.Settings;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModificationParser {
    Hashtable<String, Integer> modFormula_;
    String modification_;

    public ModificationParser(String modification) {
        this.modification_ = modification;
    }

    public void parse() {
        Hashtable<String, Integer> modFormula = new Hashtable<String, Integer>();
        if (this.modification_.equals("")) {
            this.modFormula_ = modFormula;
            return;
        }
        for (String mod : this.modification_.split(",")) {
            int multiplier = 1;
            Pattern p = Pattern.compile("(\\d+)");
            Matcher m = p.matcher(mod);
            if (m.find()) {
                multiplier = Integer.parseInt(m.group(0));
                mod = mod.replace(m.group(0), "");
            }
            try {
                for (String element : Settings.getModParser().getElements(mod).keySet()) {
                    if (!modFormula.containsKey(element)) {
                        modFormula.put(element, multiplier * Settings.getModParser().getElements(mod).get(element));
                        continue;
                    }
                    modFormula.put(element, (Integer)modFormula.get(element) + multiplier * Settings.getModParser().getElements(mod).get(element));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.modFormula_ = modFormula;
    }

    public String getNewChemicalFormula(Hashtable<String, Integer> elementalComposition) {
        String chemicalFormula = "";
        for (String element : elementalComposition.keySet()) {
            if (chemicalFormula.length() > 0) {
                chemicalFormula = chemicalFormula + " ";
            }
            int amount = elementalComposition.get(element);
            if (this.modFormula_.containsKey(element)) {
                chemicalFormula = chemicalFormula + element + String.valueOf(amount + this.modFormula_.get(element));
                continue;
            }
            chemicalFormula = chemicalFormula + element + String.valueOf(amount);
        }
        for (String element : this.modFormula_.keySet()) {
            if (elementalComposition.containsKey(element)) continue;
            chemicalFormula = chemicalFormula + element + String.valueOf(this.modFormula_.get(element));
        }
        return chemicalFormula;
    }

    public Hashtable<String, Integer> getNewChemicalComposition(Hashtable<String, Integer> elementalComposition) {
        Hashtable<String, Integer> chemicalComposition = new Hashtable<String, Integer>();
        for (String element : elementalComposition.keySet()) {
            if (this.modFormula_.containsKey(element)) {
                chemicalComposition.put(element, elementalComposition.get(element) + this.modFormula_.get(element));
                continue;
            }
            chemicalComposition.put(element, elementalComposition.get(element));
        }
        for (String element : this.modFormula_.keySet()) {
            if (elementalComposition.containsKey(element)) continue;
            chemicalComposition.put(element, this.modFormula_.get(element));
        }
        return chemicalComposition;
    }

    public double getNewMass(double mass) {
        for (String element : this.modFormula_.keySet()) {
            mass += (double)this.modFormula_.get(element).intValue() * Settings.getElementParser().getElementDetails(element).getMonoMass();
        }
        return mass;
    }

    public String getModificationComposition() {
        return this.modFormula_.toString();
    }
}

