/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.parser;

import at.tugraz.genome.lda.exception.MzXMLReaderException;
import at.tugraz.genome.lda.parser.MzXMLNextScanReader;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class MzXMLMergerForWaters {
    private String mzXMLBaseFile_;
    private int msLevels_;
    private Hashtable<Integer, MzXMLNextScanReader> readers_;
    private String mergedFileName_;

    public MzXMLMergerForWaters(String mzXMLBaseFile, int msLevels) {
        this.mzXMLBaseFile_ = mzXMLBaseFile;
        this.msLevels_ = msLevels;
        this.mergedFileName_ = this.mzXMLBaseFile_.substring(0, this.mzXMLBaseFile_.length() - ".mzXML".length()) + "_merged.mzXML";
    }

    public void merge() throws IOException, MzXMLReaderException {
        this.readers_ = new Hashtable();
        int totalNumberOfScans = 0;
        for (int i = 1; i <= this.msLevels_; ++i) {
            File file;
            String fileName = new String(this.mzXMLBaseFile_);
            if (i != 1) {
                fileName = fileName + String.valueOf(i);
            }
            if (!(file = new File(fileName)).exists()) continue;
            MzXMLNextScanReader scanReader = new MzXMLNextScanReader(fileName);
            scanReader.openReader(i == 1);
            totalNumberOfScans += scanReader.getScanCount();
            this.readers_.put(i, scanReader);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.mergedFileName_));
        byte[] bytes = this.replaceScanCount(this.readers_.get(1).getCachedContents(), totalNumberOfScans).getBytes();
        long currentByteOffset = bytes.length;
        out.write(bytes);
        for (int i = 1; i <= this.msLevels_; ++i) {
            if (!this.readers_.containsKey(i)) continue;
            this.readers_.get(i).readNextScan();
        }
        int currentScanNumber = 1;
        String indexEntry = "  <index name=\"scan\">\n";
        String lastScanEntry = null;
        int lastMSLevel = 1;
        Vector<String> closingLines = new Vector<String>();
        boolean foundMS1Scan = false;
        boolean lastIteration = false;
        while (!lastIteration) {
            if (this.allFinished()) {
                lastIteration = true;
            }
            MzXMLNextScanReader scanReader = this.getReaderAtNextTimePoint();
            if (lastScanEntry != null) {
                int i;
                indexEntry = indexEntry + this.createOffsetString(currentScanNumber, currentByteOffset);
                String toWrite = this.replaceScanNumber(lastScanEntry, currentScanNumber);
                ++currentScanNumber;
                if (scanReader == null) {
                    for (i = closingLines.size() - 1; i != -1; --i) {
                        toWrite = toWrite + (String)closingLines.get(i);
                    }
                } else if (scanReader.getMsLevel() < lastMSLevel) {
                    for (i = lastMSLevel; i > scanReader.getMsLevel(); --i) {
                        toWrite = toWrite + (String)closingLines.lastElement();
                        closingLines.remove(closingLines.size() - 1);
                    }
                } else if (scanReader.getMsLevel() != lastMSLevel && scanReader.getMsLevel() > lastMSLevel) {
                    int indexLastLineBreak = toWrite.substring(0, toWrite.length() - 1).lastIndexOf("\n");
                    closingLines.add(toWrite.substring(indexLastLineBreak + 1));
                    toWrite = toWrite.substring(0, indexLastLineBreak + 1);
                }
                bytes = toWrite.getBytes();
                currentByteOffset += (long)bytes.length;
                out.write(bytes);
            }
            if (lastIteration) continue;
            if (foundMS1Scan || scanReader.getMsLevel() == 1) {
                foundMS1Scan = true;
                lastScanEntry = scanReader.getCachedContents();
                lastMSLevel = scanReader.getMsLevel();
            }
            scanReader.readNextScan();
        }
        String endTag = "  </msRun>\n";
        bytes = endTag.getBytes();
        out.write(bytes);
        indexEntry = indexEntry + "  </index>\n";
        indexEntry = indexEntry + "  <indexOffset>" + String.valueOf(currentByteOffset += (long)bytes.length) + "</indexOffset>\n";
        out.write(indexEntry.getBytes());
        out.write("</mzXML>\n".getBytes());
        out.close();
        for (int i = 1; i <= this.msLevels_; ++i) {
            if (!this.readers_.containsKey(i)) continue;
            this.readers_.get(i).closeReader();
        }
    }

    private String createOffsetString(int scanNumber, long byteOffset) {
        return "\t<offset id=\"" + String.valueOf(scanNumber) + "\">" + String.valueOf(byteOffset) + "</offset>\n";
    }

    private boolean allFinished() {
        boolean allFinished = true;
        for (int i = 1; i <= this.msLevels_; ++i) {
            if (!this.readers_.containsKey(i) || this.readers_.get(i).isFinished()) continue;
            allFinished = false;
            break;
        }
        return allFinished;
    }

    private MzXMLNextScanReader getReaderAtNextTimePoint() {
        MzXMLNextScanReader currentReader = null;
        float lowestTime = Float.MAX_VALUE;
        for (MzXMLNextScanReader reader : this.readers_.values()) {
            float time;
            if (reader.isFinished() || !((time = Float.parseFloat(reader.getRetentionTime())) < lowestTime)) continue;
            currentReader = reader;
            lowestTime = time;
        }
        return currentReader;
    }

    private String replaceScanNumber(String entry, int currentScanNumber) throws MzXMLReaderException {
        if (entry.indexOf("num=\"") != -1 || entry.indexOf("num = \"") != -1) {
            String beforeString = "";
            if (entry.indexOf("num=\"") != -1) {
                beforeString = entry.substring(0, entry.indexOf("num=\"") + "num=\"".length());
            } else if (entry.indexOf("num = \"") != -1) {
                beforeString = entry.substring(0, entry.indexOf("num = \"") + "num = \"".length());
            }
            String restString = entry.substring(beforeString.length());
            restString = restString.substring(restString.indexOf("\""));
            return beforeString + String.valueOf(currentScanNumber) + restString;
        }
        throw new MzXMLReaderException("A mzXML File has no mandatory scan number!");
    }

    private String replaceScanCount(String contents, int scanCount) {
        String newContents = "";
        String subContents = new String(contents);
        newContents = subContents.substring(0, subContents.indexOf("scanCount") + "scanCount".length());
        subContents = subContents.substring(subContents.indexOf("scanCount") + "scanCount".length());
        newContents = newContents + subContents.substring(0, subContents.indexOf("=") + 1);
        subContents = subContents.substring(subContents.indexOf("=") + 1);
        newContents = newContents + subContents.substring(0, subContents.indexOf("\"") + 1);
        subContents = subContents.substring(subContents.indexOf("\"") + 1);
        newContents = newContents + String.valueOf(scanCount);
        newContents = newContents + subContents.substring(subContents.indexOf("\""));
        return newContents;
    }

    public String getMergedFileName() {
        return this.mergedFileName_;
    }
}

