/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.parser;

import at.tugraz.genome.lda.exception.MzXMLReaderException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;

public class MzXMLNextScanReader {
    private String fileName_;
    private int msLevel_;
    private String cachedContents_;
    private int scanCount_;
    private String retentionTime_;
    private String line_;
    private boolean finished_;
    private LineNumberReader reader_;

    public MzXMLNextScanReader(String fileName) {
        this.fileName_ = fileName;
    }

    public void openReader(boolean cacheLinesBeforeScan) throws IOException {
        this.reader_ = new LineNumberReader(new FileReader(this.fileName_));
        this.cachedContents_ = "";
        this.finished_ = false;
        while ((this.line_ = this.reader_.readLine()) != null && !this.line_.trim().startsWith("<scan") && !this.line_.trim().startsWith("< scan")) {
            if (this.line_.indexOf("scanCount") != -1) {
                String subLine = this.line_.trim().substring(this.line_.trim().indexOf("scanCount") + "scanCount".length());
                subLine = subLine.substring(subLine.indexOf("=") + 1);
                subLine = subLine.substring(subLine.indexOf("\"") + 1);
                subLine = subLine.substring(0, subLine.indexOf("\"")).trim();
                this.scanCount_ = Integer.parseInt(subLine);
            }
            if (!cacheLinesBeforeScan) continue;
            this.cachedContents_ = this.cachedContents_ + this.line_ + "\n";
        }
    }

    public void readNextScan() throws IOException, MzXMLReaderException {
        this.msLevel_ = -1;
        this.cachedContents_ = "";
        this.retentionTime_ = "";
        if (this.finished_) {
            return;
        }
        if (this.line_ != null && (this.line_.trim().startsWith("<scan") || this.line_.trim().startsWith("< scan"))) {
            this.cachedContents_ = this.cachedContents_ + this.line_ + "\n";
        }
        while ((this.line_ = this.reader_.readLine()) != null) {
            if (this.line_.indexOf("</msRun>") != -1 || this.line_.indexOf("</ msRun>") != -1 || this.line_.indexOf("</ msRun >") != -1) {
                this.finished_ = true;
                return;
            }
            this.cachedContents_ = this.cachedContents_ + this.line_ + "\n";
            if (this.line_.indexOf("msLevel=\"") != -1 || this.line_.indexOf("msLevel = \"") != -1) {
                String msLevelString = "";
                if (this.line_.indexOf("msLevel=\"") != -1) {
                    msLevelString = this.line_.substring(this.line_.indexOf("msLevel=\"") + "msLevel=\"".length());
                } else if (this.line_.indexOf("msLevel = \"") != -1) {
                    msLevelString = this.line_.substring(this.line_.indexOf("msLevel = \"") + "msLevel = \"".length());
                }
                msLevelString = msLevelString.substring(0, msLevelString.indexOf("\""));
                try {
                    this.msLevel_ = Integer.parseInt(msLevelString);
                }
                catch (NumberFormatException nfx) {
                    throw new MzXMLReaderException("There is something wrong with the msLevel at line " + this.reader_.getLineNumber() + " with the file: " + this.fileName_);
                }
            }
            if (this.line_.indexOf("retentionTime=\"") != -1 || this.line_.indexOf("retentionTime = \"") != -1) {
                int i;
                String retentionTimeString = "";
                if (this.line_.indexOf("retentionTime=\"") != -1) {
                    retentionTimeString = this.line_.substring(this.line_.indexOf("retentionTime=\"") + "retentionTime=\"".length());
                } else if (this.line_.indexOf("retentionTime = \"") != -1) {
                    retentionTimeString = this.line_.substring(this.line_.indexOf("retentionTime = \"") + "retentionTime = \"".length());
                }
                retentionTimeString = retentionTimeString.substring(0, retentionTimeString.indexOf("\""));
                char[] rtChars = retentionTimeString.toCharArray();
                for (i = 0; i != rtChars.length; ++i) {
                    if (!Character.isDigit(rtChars[i])) continue;
                    retentionTimeString = retentionTimeString.substring(i);
                    break;
                }
                rtChars = retentionTimeString.toCharArray();
                for (i = rtChars.length - 1; i != -1; --i) {
                    if (!Character.isDigit(rtChars[i])) continue;
                    retentionTimeString = retentionTimeString.substring(0, i + 1);
                    break;
                }
                try {
                    Double.parseDouble(retentionTimeString);
                    this.retentionTime_ = new String(retentionTimeString);
                }
                catch (NumberFormatException nfx) {
                    throw new MzXMLReaderException("There is something wrong with the retention time at line " + this.reader_.getLineNumber() + " with the file: " + this.fileName_);
                }
            }
            if (!this.line_.trim().startsWith("</scan") && !this.line_.trim().startsWith("</ scan")) continue;
            break;
        }
    }

    public String getCachedContents() {
        return this.cachedContents_;
    }

    public int getScanCount() {
        return this.scanCount_;
    }

    public void closeReader() {
        try {
            if (this.reader_ != null) {
                this.reader_.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getMsLevel() {
        return this.msLevel_;
    }

    public String getRetentionTime() {
        return this.retentionTime_;
    }

    public boolean isFinished() {
        return this.finished_;
    }
}

