/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.quantification;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.exception.HydroxylationEncodingException;
import at.tugraz.genome.lda.exception.NoRuleException;
import at.tugraz.genome.lda.exception.QuantificationException;
import at.tugraz.genome.lda.exception.RulesException;
import at.tugraz.genome.lda.msn.FragmentCalculator;
import at.tugraz.genome.lda.msn.vos.FragmentVO;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.quantification.LipidomicsChromReader;
import at.tugraz.genome.lda.quantification.LipidomicsChromatogram;
import at.tugraz.genome.lda.quantification.LipidomicsDefines;
import at.tugraz.genome.lda.quantification.SavGolJNI;
import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.maspectras.parser.exceptions.SpectrummillParserException;
import at.tugraz.genome.maspectras.quantification.Analyzer;
import at.tugraz.genome.maspectras.quantification.CgAreaStatus;
import at.tugraz.genome.maspectras.quantification.CgChromatogram;
import at.tugraz.genome.maspectras.quantification.CgDefines;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgProbe;
import at.tugraz.genome.maspectras.quantification.ChromaAnalyzer;
import at.tugraz.genome.maspectras.quantification.Probe3D;
import at.tugraz.genome.maspectras.utils.Calculator;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;

public class LipidomicsAnalyzer
extends ChromaAnalyzer {
    private boolean useCuda_;
    protected SavGolJNI sav_gol_jni_;
    private boolean useSameCgHashFor3D_;
    private static int NO_ISOTOPE_PRESENT = 0;
    private static int POSSIBLE_ISOTOPE_OVERLAP = 1;
    private static int ISOTOPE_PRESENT = 2;
    private float generalBasePeakCutoff_;
    private float coarseChromMzTolerance_;
    private float chromSmoothRange_ = 0.5f;
    private int chromSmoothRepeats_ = 10;
    private boolean removeIfOtherIsotopePresent_ = true;
    private boolean useNoiseCutoff_;
    private boolean useDynamicNoiseCutoff_;
    private float noiseCutoffDeviationValue_;
    private Float minimumRelativeIntensity_;
    private int scanStep_;
    private float profileMzRange_;
    private float profileTimeTolerance_;
    private float profileIntThreshold_;
    private float broaderProfileTimeTolerance_;
    private float profileSmoothRange_;
    private int profileSmoothRepeats_;
    private int profileMeanSmoothRepeats_;
    private float profileMzMinRange_;
    private float profileSteepnessChange1_;
    private float profileSteepnessChange2_;
    private float profileIntensityCutoff1_;
    private float profileIntensityCutoff2_;
    private float profileGeneralIntCutoff_;
    private float profilePeakAcceptanceRange_;
    private float profileSmoothingCorrection_;
    private float profileMaxRange_;
    private float smallChromMzRange_;
    private int smallChromSmoothRepeats_;
    private int smallChromMeanSmoothRepeats_;
    private float smallChromSmoothRange_;
    private float smallChromIntensityCutoff_;
    private int broadChromSmoothRepeats_;
    private int broadChromMeanSmoothRepeats_;
    private float broadChromSmoothRange_;
    private float broadChromIntensityCutoff_;
    private float broadChromSteepnessChangeNoSmall_;
    private float broadChromIntensityCutoffNoSmall_;
    private float finalProbeTimeCompTolerance_;
    private float finalProbeMzCompTolerance_;
    private float overlapDistanceDeviationFactor_;
    private float overlapPossibleIntensityThreshold_;
    private float overlapSureIntensityThreshold_;
    private float overlapPeakDistanceDivisor_;
    private float overlapFullDistanceDivisor_;
    private int peakDiscardingAreaFactor_;
    private int isotopeInBetweenTime_;
    private float isoInBetweenAreaFactor_;
    private int isoInBetweenMaxTimeDistance_;
    private int isoNearNormalProbeTime_;
    private float relativeAreaCutoff_;
    private float relativeFarAreaCutoff_;
    private int relativeFarAreaTimeSpace_;
    private float relativeIsoInBetweenCutoff_;
    private int closePeakTimeTolerance_;
    private float twinInBetweenCutoff_;
    private float unionInBetweenCutoff_;
    private Vector<CgProbe> chromProbes_;
    private Hashtable<Integer, CgProbe> fromProbeToProfile_;
    private Vector<CgProbe> profileProbes_;
    private Hashtable<Integer, LipidomicsChromatogram> fromProfileToSmallChrom_;
    private Hashtable<Integer, LipidomicsChromatogram> fromProfileToBroadChrom_;
    private Hashtable<Float, CgProbe> prevIsoProbes_;
    private float highestArea_ = 0.0f;
    private float highestIntensity_ = 0.0f;
    private Hashtable<Integer, LipidomicsChromatogram> chromHash_;
    private float lowerIntensityThreshold_ = 0.0f;
    private float msnMzTolerance_ = 0.2f;
    private short msnMzToleranceUnit_ = 0;
    public static final int SHOTGUN_TYPE_MEAN = 0;
    public static final int SHOTGUN_TYPE_MEDIAN = 1;
    public static final int SHOTGUN_TYPE_SUM = 2;
    private int shotgunType_;

    public LipidomicsAnalyzer(String headerFilePath, String indexFilePath, String retentionTimeFilePath, String chromatogramFilePath, boolean useCuda) throws CgException {
        if (useCuda) {
            this.sav_gol_jni_ = new SavGolJNI();
        }
        this.reader_ = new LipidomicsChromReader(headerFilePath, indexFilePath, retentionTimeFilePath, chromatogramFilePath, LipidomicsConstants.isSparseData(), LipidomicsConstants.getChromSmoothRange(), useCuda);
        this.m_chroma = new LipidomicsChromatogram[CgDefines.MaxCharge];
        LipidomicsChromReader lReader = (LipidomicsChromReader)this.reader_;
        if (useCuda) {
            int max_length = lReader.getNumberOfScans();
            for (Integer key : lReader.getMsmsNrOfScans().keySet()) {
                if (max_length >= lReader.getMsmsNrOfScans().get(key)) continue;
                max_length = lReader.getMsmsNrOfScans().get(key);
            }
            this.sav_gol_jni_.initMalloc(max_length);
        }
        this.useCuda_ = useCuda;
        this.init();
    }

    private void init() {
        this.useSameCgHashFor3D_ = false;
        this.initCacheHashes();
        this.generalBasePeakCutoff_ = 0.0f;
        this.coarseChromMzTolerance_ = 0.02f;
        this.removeIfOtherIsotopePresent_ = true;
        this.useNoiseCutoff_ = false;
        this.useDynamicNoiseCutoff_ = false;
        this.noiseCutoffDeviationValue_ = 2.0f;
        this.scanStep_ = 1;
        this.chromSmoothRange_ = 0.5f;
        this.chromSmoothRepeats_ = 10;
        this.profileMzRange_ = 0.1f;
        this.profileTimeTolerance_ = 2.0f;
        this.profileIntThreshold_ = 5.0f;
        this.broaderProfileTimeTolerance_ = 3.0f;
        this.profileSmoothRange_ = 0.02f;
        this.profileSmoothRepeats_ = 5;
        this.profileMeanSmoothRepeats_ = 0;
        this.profileMzMinRange_ = 0.0f;
        this.profileSteepnessChange1_ = 1.5f;
        this.profileSteepnessChange2_ = 1.8f;
        this.profileIntensityCutoff1_ = 0.15f;
        this.profileIntensityCutoff2_ = 0.2f;
        this.profileGeneralIntCutoff_ = 0.03f;
        this.profilePeakAcceptanceRange_ = 0.034f;
        this.profileSmoothingCorrection_ = 0.0f;
        this.profileMaxRange_ = 0.02f;
        this.smallChromMzRange_ = 0.002f;
        this.smallChromSmoothRepeats_ = 15;
        this.smallChromMeanSmoothRepeats_ = 0;
        this.smallChromSmoothRange_ = 5.0f;
        this.smallChromIntensityCutoff_ = 0.03f;
        this.broadChromSmoothRepeats_ = 10;
        this.broadChromMeanSmoothRepeats_ = 0;
        this.broadChromSmoothRange_ = 5.0f;
        this.broadChromIntensityCutoff_ = 0.0f;
        this.broadChromSteepnessChangeNoSmall_ = 1.33f;
        this.broadChromIntensityCutoffNoSmall_ = 0.05f;
        this.finalProbeTimeCompTolerance_ = 0.1f;
        this.finalProbeMzCompTolerance_ = 5.0E-4f;
        this.overlapDistanceDeviationFactor_ = 1.5f;
        this.overlapPossibleIntensityThreshold_ = 0.15f;
        this.overlapSureIntensityThreshold_ = 0.7f;
        this.overlapPeakDistanceDivisor_ = 3.0f;
        this.overlapFullDistanceDivisor_ = 6.0f;
        this.peakDiscardingAreaFactor_ = 1000;
        this.isotopeInBetweenTime_ = 30;
        this.isoInBetweenAreaFactor_ = 3.0f;
        this.isoNearNormalProbeTime_ = 30;
        this.relativeAreaCutoff_ = 0.01f;
        this.relativeFarAreaCutoff_ = 0.1f;
        this.relativeFarAreaTimeSpace_ = 30;
        this.relativeIsoInBetweenCutoff_ = 0.5f;
        this.closePeakTimeTolerance_ = 10;
        this.isoInBetweenMaxTimeDistance_ = 300;
        this.twinInBetweenCutoff_ = 0.95f;
        this.unionInBetweenCutoff_ = 0.8f;
        this.msnMzTolerance_ = 0.2f;
        this.msnMzToleranceUnit_ = 0;
    }

    public void set3DParameters(float chromSmoothRange, int chromSmoothRepeats, boolean removeIfOtherIsotopePresent, boolean useNoiseCutoff, float noiseCutoffDeviationValue, boolean useDynamicNoiseCutoff, Float minimumRelativeIntensity, int scanStep, float profileMzRange, float profileTimeTolerance, float profileIntThreshold, float broaderProfileTimeTolerance, float profileSmoothRange, int profileSmoothRepeats, int profileMeanSmoothRepeats, float profileMzMinRange, float profileSteepnessChange1, float profileSteepnessChange2, float profileIntensityCutoff1, float profileIntensityCutoff2, float profileGeneralIntCutoff, float profilePeakAcceptanceRange, float profileSmoothingCorrection, float profileMaxRange, float smallChromMzRange, int smallChromSmoothRepeats, int smallChromMeanSmoothRepeats, float smallChromSmoothRange, float smallChromIntensityCutoff, int broadChromSmoothRepeats, int broadChromMeanSmoothRepeats, float broadChromSmoothRange, float broadChromIntensityCutoff, float broadChromSteepnessChangeNoSmall, float broadChromIntensityCutoffNoSmall, float finalProbeTimeCompTolerance, float finalProbeMzCompTolerance, float overlapDistanceDeviationFactor, float overlapPossibleIntensityThreshold, float overlapSureIntensityThreshold, float overlapPeakDistanceDivisor, float overlapFullDistanceDivisor, int peakDiscardingAreaFactor, int isotopeInBetweenTime, float isoInBetweenAreaFactor, int isoInBetweenMaxTimeDistance, int isoNearNormalProbeTime, float relativeAreaCutoff, float relativeFarAreaCutoff, int relativeFarAreaTimeSpace, float relativeIsoInBetweenCutoff, int closePeakTimeTolerance, float twinInBetweenCutoff, float unionInBetweenCutoff, float msnMzTolerance, short msnMzToleranceUnit) {
        this.chromSmoothRange_ = chromSmoothRange;
        this.removeIfOtherIsotopePresent_ = removeIfOtherIsotopePresent;
        this.chromSmoothRepeats_ = chromSmoothRepeats;
        this.useNoiseCutoff_ = useNoiseCutoff;
        this.useDynamicNoiseCutoff_ = useDynamicNoiseCutoff;
        this.noiseCutoffDeviationValue_ = noiseCutoffDeviationValue;
        this.minimumRelativeIntensity_ = minimumRelativeIntensity;
        this.scanStep_ = scanStep;
        this.profileMzRange_ = profileMzRange;
        this.profileTimeTolerance_ = profileTimeTolerance;
        this.profileIntThreshold_ = profileIntThreshold;
        this.broaderProfileTimeTolerance_ = broaderProfileTimeTolerance;
        this.profileSmoothRange_ = profileSmoothRange;
        this.profileSmoothRepeats_ = profileSmoothRepeats;
        this.profileMeanSmoothRepeats_ = profileMeanSmoothRepeats;
        this.profileMzMinRange_ = profileMzMinRange;
        this.profileSteepnessChange1_ = profileSteepnessChange1;
        this.profileSteepnessChange2_ = profileSteepnessChange2;
        this.profileIntensityCutoff1_ = profileIntensityCutoff1;
        this.profileIntensityCutoff2_ = profileIntensityCutoff2;
        this.profileGeneralIntCutoff_ = profileGeneralIntCutoff;
        this.profilePeakAcceptanceRange_ = profilePeakAcceptanceRange;
        this.profileSmoothingCorrection_ = profileSmoothingCorrection;
        this.profileMaxRange_ = profileMaxRange;
        this.smallChromMzRange_ = smallChromMzRange;
        this.smallChromSmoothRepeats_ = smallChromSmoothRepeats;
        this.smallChromMeanSmoothRepeats_ = smallChromMeanSmoothRepeats;
        this.smallChromSmoothRange_ = smallChromSmoothRange;
        this.smallChromIntensityCutoff_ = smallChromIntensityCutoff;
        this.broadChromSmoothRepeats_ = broadChromSmoothRepeats;
        this.broadChromMeanSmoothRepeats_ = broadChromMeanSmoothRepeats;
        this.broadChromSmoothRange_ = broadChromSmoothRange;
        this.broadChromIntensityCutoff_ = broadChromIntensityCutoff;
        this.broadChromSteepnessChangeNoSmall_ = broadChromSteepnessChangeNoSmall;
        this.broadChromIntensityCutoffNoSmall_ = broadChromIntensityCutoffNoSmall;
        this.finalProbeTimeCompTolerance_ = finalProbeTimeCompTolerance;
        this.finalProbeMzCompTolerance_ = finalProbeMzCompTolerance;
        this.overlapDistanceDeviationFactor_ = overlapDistanceDeviationFactor;
        this.overlapPossibleIntensityThreshold_ = overlapPossibleIntensityThreshold;
        this.overlapSureIntensityThreshold_ = overlapSureIntensityThreshold;
        this.overlapPeakDistanceDivisor_ = overlapPeakDistanceDivisor;
        this.overlapFullDistanceDivisor_ = overlapFullDistanceDivisor;
        this.peakDiscardingAreaFactor_ = peakDiscardingAreaFactor;
        this.isotopeInBetweenTime_ = isotopeInBetweenTime;
        this.isoInBetweenAreaFactor_ = isoInBetweenAreaFactor;
        this.isoInBetweenMaxTimeDistance_ = isoInBetweenMaxTimeDistance;
        this.isoNearNormalProbeTime_ = isoNearNormalProbeTime;
        this.relativeAreaCutoff_ = relativeAreaCutoff;
        this.relativeFarAreaCutoff_ = relativeFarAreaCutoff;
        this.relativeFarAreaTimeSpace_ = relativeFarAreaTimeSpace;
        this.relativeIsoInBetweenCutoff_ = relativeIsoInBetweenCutoff;
        this.closePeakTimeTolerance_ = closePeakTimeTolerance;
        this.twinInBetweenCutoff_ = twinInBetweenCutoff;
        this.unionInBetweenCutoff_ = unionInBetweenCutoff;
        this.setMSnMzTolerance(msnMzTolerance, msnMzToleranceUnit);
    }

    public void setPrmParameters(float chromSmoothRange, int chromSmoothRepeats, int peakDiscardingAreaFactor, float relativeAreaCutoff, float relativeFarAreaCutoff, int relativeFarAreaTimeSpace, float msnMzTolerance, short msnMzToleranceUnit) {
        this.chromSmoothRange_ = chromSmoothRange;
        this.chromSmoothRepeats_ = chromSmoothRepeats;
        this.peakDiscardingAreaFactor_ = peakDiscardingAreaFactor;
        this.relativeAreaCutoff_ = relativeAreaCutoff;
        this.relativeFarAreaCutoff_ = relativeFarAreaCutoff;
        this.relativeFarAreaTimeSpace_ = relativeFarAreaTimeSpace;
        this.setMSnMzTolerance(msnMzTolerance, msnMzToleranceUnit);
    }

    private void setMSnMzTolerance(float msnMzTolerance, short msnMzToleranceUnit) {
        this.msnMzTolerance_ = msnMzTolerance;
        this.msnMzToleranceUnit_ = msnMzToleranceUnit;
    }

    public void setShotgunParameters(int shotgunType, float msnMzTolerance, short msnMzToleranceUnit) {
        this.shotgunType_ = shotgunType;
        this.setMSnMzTolerance(msnMzTolerance, msnMzToleranceUnit);
    }

    private void initCacheHashes() {
        this.chromProbes_ = new Vector();
        this.fromProbeToProfile_ = new Hashtable();
        this.profileProbes_ = new Vector();
        this.fromProfileToSmallChrom_ = new Hashtable();
        this.fromProfileToBroadChrom_ = new Hashtable();
        this.lowerIntensityThreshold_ = 0.0f;
    }

    private void releaseCacheHashes() {
        this.chromProbes_ = null;
        this.fromProbeToProfile_ = null;
        this.profileProbes_ = null;
        this.fromProfileToSmallChrom_ = null;
        this.fromProfileToBroadChrom_ = null;
        this.lowerIntensityThreshold_ = 0.0f;
    }

    @Override
    protected CgChromatogram readAChromatogram(float mz, float lowerMzBand, float upperMzBand, int msLevel, float smoothRange, int smoothRepeats, float meanSmoothRange, int meanSmoothRepeats, float startTime, float stopTime) throws CgException {
        CgChromatogram cx = this.reader_.readChromatogram(mz - lowerMzBand, mz + upperMzBand, msLevel);
        cx.Mz = mz;
        cx.LowerMzBand = lowerMzBand;
        cx.UpperMzBand = upperMzBand;
        if (startTime != -1.0f || stopTime != Float.MAX_VALUE) {
            boolean foundStart = false;
            boolean foundStop = false;
            for (int i = 0; i != cx.ScanCount; ++i) {
                if (!foundStart && startTime < cx.Value[i][0]) {
                    cx.startSmoothScan_ = i - 1;
                    foundStart = true;
                }
                if (foundStop || !(stopTime < cx.Value[i][0])) continue;
                cx.stopSmoothScan_ = i + 1;
                foundStop = true;
            }
        }
        boolean copyRawData = true;
        if (meanSmoothRange > 0.0f) {
            cx.smoothMean(meanSmoothRange, meanSmoothRepeats, copyRawData);
            copyRawData = false;
        }
        if (this.useCuda_) {
            LipidomicsChromatogram lCx = new LipidomicsChromatogram(cx);
            lCx.Smooth(smoothRange, smoothRepeats, copyRawData, this.sav_gol_jni_);
        } else {
            cx.Smooth(smoothRange, smoothRepeats, copyRawData);
        }
        return cx;
    }

    public Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> processByMzProbabsAndPossibleRetentionTime(float mz, int charge, float retentionTime, float prevTimeTolerance, float afterTimeTolerance, int timeType, Vector<Double> probabs, Vector<Double> possibleProbabs, int msLevel, boolean negative) throws CgException {
        return this.processByMzProbabsAndPossibleRetentionTime(mz, charge, retentionTime, null, prevTimeTolerance, afterTimeTolerance, timeType, probabs, possibleProbabs, msLevel, negative);
    }

    public Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> processByMzProbabsAndPossibleRetentionTime(float mz, int charge, Vector<Float> retentionTimes, float prevTimeTolerance, float afterTimeTolerance, int timeType, Vector<Double> probabs, Vector<Double> possibleProbabs, int msLevel, boolean negative) throws CgException {
        return this.processByMzProbabsAndPossibleRetentionTime(mz, charge, -1.0f, retentionTimes, prevTimeTolerance, afterTimeTolerance, timeType, probabs, possibleProbabs, msLevel, negative);
    }

    public Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> processShotgunData(float mz, int charge, int msLevel, int nrOfIsotopes, Vector<Double> mustMatchIsos) throws CgException {
        float mzTolerance = LipidomicsConstants.getCoarseChromMzTolerance(mz);
        CgProbe probe = this.calculateAShotgunIntensity(mz, mzTolerance, charge, msLevel);
        if (!(probe.Area > 0.0f)) {
            return null;
        }
        Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> result = new Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>>();
        Hashtable oneResult = new Hashtable();
        Vector<CgProbe> probes = new Vector<CgProbe>();
        probes.add(probe);
        oneResult.put(0, probes);
        if (nrOfIsotopes > 1) {
            for (int i = 1; i != nrOfIsotopes; ++i) {
                probe = this.calculateAShotgunIntensity(mz + (float)i * LipidomicsConstants.getNeutronMass() / (float)charge, mzTolerance, charge, msLevel);
                if (probe.Area == 0.0f) {
                    if (i >= mustMatchIsos.size()) break;
                    return null;
                }
                probes = new Vector();
                probes.add(probe);
                oneResult.put(i, probes);
            }
        }
        result.put(0, oneResult);
        return result;
    }

    public Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> processPrmData(float mz, int charge, int msLevel, String className, String modName, String analyteName, String formula, int ohNumber, String oxState) {
        Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> finalResults = null;
        try {
            String fragmentName;
            float mzTolerance = LipidomicsConstants.getCoarseChromMzTolerance(mz);
            this.prepareMSnSpectraCache(mz - mzTolerance, mz + mzTolerance, LipidomicsConstants.getMs2MinIntsForNoiseRemoval());
            FragmentCalculator fragCalc = new FragmentCalculator(null, className, modName, analyteName, formula, formula, mz, charge, ohNumber, oxState);
            Vector<FragmentVO> mandHeadFragments = fragCalc.getHeadFragments(ohNumber).get(true);
            Hashtable headPeaks = new Hashtable();
            for (FragmentVO frag : mandHeadFragments) {
                if (frag.isMandatory() != 3) continue;
                float tol = StaticUtils.calculatedMzTolValue((float)frag.getMass(), this.msnMzTolerance_, this.msnMzToleranceUnit_);
                LipidomicsChromatogram chrom = new LipidomicsChromatogram(this.readJustIntensitiesOfInterest((float)frag.getMass() - tol, (float)frag.getMass() + tol, 0.0f, Float.MAX_VALUE, msLevel));
                chrom.Smooth(this.chromSmoothRange_, this.chromSmoothRepeats_);
                chrom.GetMaximumAndAverage();
                Vector<CgProbe> probes = new Vector<CgProbe>();
                float highestArea = 0.0f;
                for (int currentScan = 0; currentScan < chrom.Value.length; ++currentScan) {
                    CgProbe standardProbe = LipidomicsAnalyzer.calculateOneArea(chrom, currentScan, LipidomicsDefines.StandardValleyMethod, charge);
                    int highestScan = LipidomicsAnalyzer.findIndexByTime(standardProbe.UpperValley, chrom);
                    standardProbe.isotopeNumber = 0;
                    if (standardProbe.AreaStatus != CgAreaStatus.OK) continue;
                    this.checkDuplicate(probes, standardProbe);
                    if (standardProbe.AreaStatus != CgAreaStatus.OK) continue;
                    probes.add(standardProbe);
                    if (standardProbe.Area > highestArea) {
                        highestArea = standardProbe.Area;
                    }
                    if (highestScan <= currentScan) continue;
                    currentScan = highestScan;
                }
                Vector<CgProbe> strongProbes = new Vector<CgProbe>();
                for (CgProbe probe : probes) {
                    if (!(probe.Area > highestArea / (float)this.peakDiscardingAreaFactor_)) continue;
                    strongProbes.add(probe);
                }
                headPeaks.put(frag.getName(), strongProbes);
            }
            finalResults = new Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>>();
            Hashtable chainPeaks = new Hashtable();
            if (headPeaks.size() == 0 && chainPeaks.size() == 0) {
                return finalResults;
            }
            Vector probesToCheck = new Vector();
            if (headPeaks.size() > 0) {
                fragmentName = (String)headPeaks.keySet().iterator().next();
                probesToCheck = (Vector)headPeaks.get(fragmentName);
            } else {
                fragmentName = (String)chainPeaks.keySet().iterator().next();
                probesToCheck = (Vector)chainPeaks.get(fragmentName);
            }
            Vector<CgProbe> allProbes = new Vector<CgProbe>();
            CgProbe strongestProbe = null;
            float strongestArea = 0.0f;
            for (CgProbe probe : probesToCheck) {
                Vector<CgProbe> probesToCombine = new Vector<CgProbe>();
                probesToCombine.add(probe);
                boolean allFound = true;
                for (String fragName : headPeaks.keySet()) {
                    if (fragName.equalsIgnoreCase(fragmentName)) continue;
                    Vector otherProbes = (Vector)headPeaks.get(fragName);
                    Vector<CgProbe> overlappingProbes = new Vector<CgProbe>();
                    CgProbe probeToAdd = null;
                    for (CgProbe other : otherProbes) {
                        if (!LipidomicsAnalyzer.isOneProbeInOtherInnerThird(probe, other, 1.3333334f, 2.6666667f)) continue;
                        overlappingProbes.add(other);
                    }
                    if (overlappingProbes.size() == 0) {
                        allFound = false;
                        break;
                    }
                    float lowestDifference = Float.MAX_VALUE;
                    for (CgProbe other : overlappingProbes) {
                        float summitDifference = this.positiveDifference(probe.Peak, other.Peak);
                        if (!(summitDifference < lowestDifference)) continue;
                        probeToAdd = other;
                        lowestDifference = summitDifference;
                    }
                    probesToCombine.add(probeToAdd);
                }
                if (!allFound) continue;
                float totalArea = 0.0f;
                float lowerValleyTimesArea = 0.0f;
                float peakTimesArea = 0.0f;
                float upperValleyTimesArea = 0.0f;
                float totalBackground = 0.0f;
                float totalAreaError = 0.0f;
                float highestIntensity = 0.0f;
                float lowerValley10TimesArea = 0.0f;
                float lowerValley50TimesArea = 0.0f;
                float upperValley10TimesArea = 0.0f;
                float upperValley50TimesArea = 0.0f;
                for (CgProbe aProbe : probesToCombine) {
                    totalArea += aProbe.Area;
                    lowerValleyTimesArea += aProbe.LowerValley * aProbe.Area;
                    peakTimesArea += aProbe.Peak * aProbe.Area;
                    upperValleyTimesArea += aProbe.UpperValley * aProbe.Area;
                    totalBackground += aProbe.Background;
                    totalAreaError += aProbe.AreaError;
                    if (aProbe.getHighestIntensity() > highestIntensity) {
                        highestIntensity = aProbe.getHighestIntensity();
                    }
                    lowerValley10TimesArea += aProbe.getLowerValley10().floatValue() * aProbe.Area;
                    lowerValley50TimesArea += aProbe.getLowerValley50().floatValue() * aProbe.Area;
                    upperValley10TimesArea += aProbe.getUpperValley10().floatValue() * aProbe.Area;
                    upperValley50TimesArea += aProbe.getUpperValley50().floatValue() * aProbe.Area;
                }
                CgProbe finalProbe = new CgProbe(0, 1, 1, formula);
                finalProbe.Mz = mz;
                finalProbe.LowerMzBand = mzTolerance;
                finalProbe.UpperMzBand = mzTolerance;
                finalProbe.isotopeNumber = 0;
                finalProbe.Area = totalArea;
                finalProbe.LowerValley = lowerValleyTimesArea / totalArea;
                finalProbe.Peak = peakTimesArea / totalArea;
                finalProbe.UpperValley = upperValleyTimesArea / totalArea;
                finalProbe.Background = totalBackground;
                finalProbe.AreaError = totalAreaError;
                finalProbe.setHighestIntensity(highestIntensity);
                finalProbe.setLowerValley10(Float.valueOf(lowerValley10TimesArea / totalArea));
                finalProbe.setLowerValley50(Float.valueOf(lowerValley50TimesArea / totalArea));
                finalProbe.setUpperValley10(Float.valueOf(upperValley10TimesArea / totalArea));
                finalProbe.setUpperValley50(Float.valueOf(upperValley50TimesArea / totalArea));
                finalProbe.AreaStatus = CgAreaStatus.OK;
                finalProbe.setApexIntensity(Float.valueOf(0.0f));
                allProbes.add(finalProbe);
                if (!(finalProbe.Area > strongestArea)) continue;
                strongestProbe = finalProbe;
                strongestArea = finalProbe.Area;
            }
            int hitNumber = 0;
            for (CgProbe aProbe : allProbes) {
                if (aProbe.Area < strongestArea * this.relativeAreaCutoff_ || aProbe.Area < strongestArea * this.relativeFarAreaCutoff_ && this.checkTimeSpace(strongestProbe, aProbe) > (float)this.relativeFarAreaTimeSpace_) continue;
                Vector<CgProbe> finalProbes = new Vector<CgProbe>();
                finalProbes.add(aProbe);
                Hashtable<Integer, Vector<CgProbe>> isotopes = new Hashtable<Integer, Vector<CgProbe>>();
                isotopes.put(0, finalProbes);
                finalResults.put(hitNumber, isotopes);
                ++hitNumber;
            }
        }
        catch (ChemicalFormulaException | HydroxylationEncodingException | NoRuleException | RulesException | SpectrummillParserException | CgException | IOException ex) {
            ex.printStackTrace();
        }
        return finalResults;
    }

    private CgProbe calculateAShotgunIntensity(float mz, float mzTolerance, int charge, int msLevel) throws CgException {
        CgChromatogram cgChrom = this.readAChromatogram(mz, mzTolerance, mzTolerance, msLevel, 0.0f, 0);
        return LipidomicsAnalyzer.calculateAShotgunIntensity(cgChrom, charge, msLevel, this.shotgunType_);
    }

    public static CgProbe calculateAShotgunIntensity(CgChromatogram cgChrom, int charge, int msLevel, int shotgunType) {
        CgProbe probe = new CgProbe(0, charge);
        probe.Area = LipidomicsAnalyzer.calculateShotgunIntensity(cgChrom, shotgunType);
        probe.AreaStatus = CgAreaStatus.OK;
        probe.LowerMzBand = cgChrom.LowerMzBand;
        probe.UpperMzBand = cgChrom.UpperMzBand;
        probe.LowerValley = cgChrom.Value[0][0];
        probe.UpperValley = cgChrom.Value[cgChrom.Value.length - 1][0];
        probe.Peak = (probe.LowerValley + probe.UpperValley) / 2.0f;
        probe.Mz = cgChrom.Mz;
        return probe;
    }

    /*
     * WARNING - void declaration
     */
    private Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> processByMzProbabsAndPossibleRetentionTime(float mz, int charge, float retentionTime, Vector<Float> retentionTimes, float prevTimeTolerance, float afterTimeTolerance, int timeType, Vector<Double> probabs, Vector<Double> possibleProbabs, int msLevel, boolean negative) throws CgException {
        int i;
        Vector<CgProbe> recentIsoProbes;
        void var25_30;
        this.coarseChromMzTolerance_ = LipidomicsConstants.getCoarseChromMzTolerance(mz);
        this.useSameCgHashFor3D_ = true;
        this.initCacheHashes();
        float massToAdd = LipidomicsConstants.getNeutronMass();
        if (negative) {
            massToAdd *= -1.0f;
        }
        this.chromHash_ = new Hashtable();
        this.prevIsoProbes_ = new Hashtable();
        double possibleIsoLowerMinimum = 0.6666666666666666;
        if (possibleProbabs.size() > 1) {
            possibleIsoLowerMinimum = 100.0;
            for (int i3 = 0; i3 != possibleProbabs.size() - 1; ++i3) {
                double ratio = possibleProbabs.get(i3) / possibleProbabs.get(i3 + 1);
                if (!((ratio *= 0.6666666666666666) < possibleIsoLowerMinimum)) continue;
                possibleIsoLowerMinimum = ratio;
            }
        }
        LipidomicsChromatogram previousIsoChrom = null;
        LipidomicsChromatogram chrom = null;
        if (this.removeIfOtherIsotopePresent_) {
            previousIsoChrom = new LipidomicsChromatogram(this.readAChromatogram(mz - massToAdd / (float)charge, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
            previousIsoChrom.GetMaximumAndAverage();
            chrom = new LipidomicsChromatogram(this.readAChromatogram(mz, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
            chrom.GetMaximumAndAverage();
        } else {
            CgChromatogram cgChrom = this.readAChromatogram(mz, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_);
            chrom = new LipidomicsChromatogram(cgChrom);
            chrom.GetMaximumAndAverage();
            CgChromatogram prevChrom = new CgChromatogram(cgChrom.ScanCount);
            for (int i4 = 0; i4 != cgChrom.ScanCount; ++i4) {
                prevChrom.Value[i4][0] = cgChrom.Value[i4][0];
                prevChrom.Value[i4][1] = 0.0f;
                prevChrom.Value[i4][2] = 0.0f;
                prevChrom.Value[i4][3] = 0.0f;
            }
            previousIsoChrom = new LipidomicsChromatogram(prevChrom);
            previousIsoChrom.GetMaximumAndAverage();
        }
        if (this.useNoiseCutoff_) {
            this.calculateNoiseCutoffValue(chrom);
        }
        if (this.useDynamicNoiseCutoff_) {
            this.setDynamicNoiseCutoff(chrom);
        }
        if (this.minimumRelativeIntensity_ != null) {
            this.calculateMinIntThreshold(chrom);
        }
        this.chromHash_.put(0, chrom);
        Vector<Vector<CgProbe>> both = this.scanForHits(chrom, previousIsoChrom, possibleIsoLowerMinimum, charge, msLevel, retentionTime, retentionTimes, prevTimeTolerance, afterTimeTolerance, timeType);
        Vector<CgProbe> otherIsoProbes1 = both.get(1);
        Vector<CgProbe> allProbes = both.get(0);
        Vector<Object> probes1 = new Vector<Object>();
        float biggestArea = 0.0f;
        CgProbe highestProbe = null;
        for (int i5 = 0; i5 != allProbes.size(); ++i5) {
            CgProbe aProbe = allProbes.get(i5);
            if (aProbe.AreaStatus != CgAreaStatus.OK) continue;
            probes1.add(aProbe);
            if (!(aProbe.Area > biggestArea)) continue;
            biggestArea = aProbe.Area;
            highestProbe = aProbe;
        }
        Vector<CgProbe> probes2 = new Vector<CgProbe>();
        for (CgProbe cgProbe : probes1) {
            if (!(cgProbe.Area > biggestArea / (float)this.peakDiscardingAreaFactor_)) continue;
            probes2.add(cgProbe);
        }
        Vector<CgProbe> probes3 = new Vector<CgProbe>();
        boolean bl = false;
        while (var25_30 != probes2.size()) {
            CgProbe probe1 = (CgProbe)probes2.get((int)var25_30);
            boolean isFromOtherIso = false;
            for (int j = 0; j != probes2.size(); ++j) {
                CgProbe probe2;
                if (var25_30 == j || !(this.checkTimeSpace(probe1, probe2 = (CgProbe)probes2.get(j)) < (float)this.isotopeInBetweenTime_) || !this.otherIsoProbeInBetween(probe1, probe2, new Vector<CgProbe>(this.prevIsoProbes_.values()))) continue;
                for (CgProbe otherIsoProbe : this.prevIsoProbes_.values()) {
                    float ratio2;
                    float ratio1;
                    boolean isoInBetween = false;
                    if (probe1.Peak > probe2.Peak) {
                        if (probe2.Peak < otherIsoProbe.Peak && otherIsoProbe.Peak < probe1.Peak) {
                            isoInBetween = true;
                        }
                    } else if (probe1.Peak < otherIsoProbe.Peak && otherIsoProbe.Peak < probe2.Peak) {
                        isoInBetween = true;
                    }
                    if (!isoInBetween) continue;
                    if (probe1.Area < probe2.Area / this.isoInBetweenAreaFactor_) {
                        isFromOtherIso = true;
                        continue;
                    }
                    if (!(probe1.Area < probe2.Area * this.isoInBetweenAreaFactor_)) continue;
                    float totalSpan = otherIsoProbe.UpperValley - otherIsoProbe.LowerValley;
                    if (probe1.Peak > probe2.Peak) {
                        if (!(probe1.LowerValley < otherIsoProbe.UpperValley) || !(probe2.UpperValley > otherIsoProbe.LowerValley) || !((ratio1 = (otherIsoProbe.UpperValley - probe1.LowerValley) / totalSpan) > (ratio2 = (probe2.UpperValley - otherIsoProbe.LowerValley) / totalSpan))) continue;
                        isFromOtherIso = true;
                        continue;
                    }
                    if (!(probe2.LowerValley < otherIsoProbe.UpperValley) || !(probe1.UpperValley > otherIsoProbe.LowerValley) || !((ratio1 = (probe1.UpperValley - otherIsoProbe.LowerValley) / totalSpan) > (ratio2 = (otherIsoProbe.UpperValley - probe2.LowerValley) / totalSpan))) continue;
                    isFromOtherIso = true;
                }
            }
            if (isFromOtherIso) {
                probe1.AreaStatus = CgAreaStatus.OtherIso;
                otherIsoProbes1.add(probe1);
            } else {
                probes3.add(probe1);
            }
            ++var25_30;
        }
        Vector<CgProbe> vector = this.uniteTwinPeaks(probes3, chrom, msLevel);
        Vector<CgProbe> otherIsoProbes2 = new Vector<CgProbe>();
        for (CgProbe otherIsoProbe : otherIsoProbes1) {
            if (otherIsoProbe.AreaStatus != CgAreaStatus.OtherIso || !this.checkNearNormalProbe(otherIsoProbe, vector, null)) continue;
            otherIsoProbes2.add(otherIsoProbe);
        }
        boolean[] isOfInterest = new boolean[vector.size()];
        Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> isotopicAreas = new Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>>();
        for (int j = 0; j != vector.size(); ++j) {
            isOfInterest[j] = true;
            Vector<CgProbe> areas = new Vector<CgProbe>();
            areas.add(vector.get(j));
            Hashtable<Integer, Vector<CgProbe>> isoAreasOfOneIso = new Hashtable<Integer, Vector<CgProbe>>();
            isoAreasOfOneIso.put(0, areas);
            isotopicAreas.put(j, isoAreasOfOneIso);
        }
        Vector<CgProbe> currentIsoProbes = new Vector<CgProbe>(otherIsoProbes2);
        for (int i2 = 0; i2 != probabs.size(); ++i2) {
            if (i2 == 0) continue;
            recentIsoProbes = currentIsoProbes;
            currentIsoProbes = new Vector();
            chrom = new LipidomicsChromatogram(this.readAChromatogram(mz + (float)i2 * massToAdd / (float)charge, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
            chrom.GetMaximumAndAverage();
            this.chromHash_.put(i2, chrom);
            double multiplicationFactor = probabs.get(i2) / probabs.get(0);
            for (int j = 0; j != vector.size(); ++j) {
                if (!isOfInterest[j]) continue;
                Probe3D aProbe = (Probe3D)vector.get(j);
                Hashtable<Object, Object> isoAreasOfOneProbe = new Hashtable();
                if (isotopicAreas.containsKey(j)) {
                    isoAreasOfOneProbe = isotopicAreas.get(j);
                }
                Vector result = this.calculateIsoProbesWithinZeroIsotopeBoundaries(chrom, aProbe, vector, multiplicationFactor, recentIsoProbes, probabs.get(1) / probabs.get(0), false, charge, msLevel);
                CgProbe isoProbe = (CgProbe)result.get(0);
                currentIsoProbes.addAll((Vector)result.get(1));
                if (isoProbe != null && isoProbe.AreaStatus == CgAreaStatus.OK) {
                    isoProbe.isotopeNumber = i2;
                    Vector<CgProbe> isoAreas = new Vector<CgProbe>();
                    isoAreas.add(isoProbe);
                    isoAreasOfOneProbe.put(i2, isoAreas);
                    isotopicAreas.put(j, isoAreasOfOneProbe);
                    continue;
                }
                isOfInterest[j] = false;
                isotopicAreas.remove(j);
            }
            currentIsoProbes = this.curateCurrentIsoProbes(currentIsoProbes, i2, isotopicAreas, isOfInterest);
        }
        biggestArea = 0.0f;
        highestProbe = null;
        for (int i2 = 0; i2 != vector.size(); ++i2) {
            if (!isOfInterest[i2]) continue;
            CgProbe aProbe = vector.get(i2);
            if (aProbe.AreaStatus != CgAreaStatus.OK || !(aProbe.Area > biggestArea)) continue;
            biggestArea = aProbe.Area;
            highestProbe = aProbe;
        }
        Vector<CgProbe> otherIsoProbes3 = new Vector<CgProbe>();
        for (CgProbe otherIsoProbe : otherIsoProbes2) {
            if (otherIsoProbe.AreaStatus != CgAreaStatus.OtherIso || !this.checkNearNormalProbe(otherIsoProbe, vector, isOfInterest)) continue;
            otherIsoProbes3.add(otherIsoProbe);
        }
        for (i = 0; i != vector.size(); ++i) {
            if (!isOfInterest[i]) continue;
            CgProbe aProbe = vector.get(i);
            if (aProbe.AreaStatus != CgAreaStatus.OK) continue;
            if (aProbe.Area > biggestArea * this.relativeAreaCutoff_) {
                if (aProbe.Area < biggestArea * this.relativeFarAreaCutoff_ && this.checkTimeSpace(highestProbe, aProbe) > (float)this.relativeFarAreaTimeSpace_) {
                    isOfInterest[i] = false;
                    isotopicAreas.remove(i);
                }
                if (!(aProbe.Area < biggestArea * this.relativeIsoInBetweenCutoff_) || !this.otherIsoProbeInBetween(highestProbe, aProbe, otherIsoProbes3)) continue;
                isOfInterest[i] = false;
                isotopicAreas.remove(i);
                continue;
            }
            isOfInterest[i] = false;
            isotopicAreas.remove(i);
        }
        if (possibleProbabs.size() > probabs.size()) {
            if (probabs.size() == 0) {
                recentIsoProbes = new Vector(otherIsoProbes3);
            }
            for (i = probabs.size(); i != possibleProbabs.size(); ++i) {
                if (i == 0) continue;
                recentIsoProbes = currentIsoProbes;
                currentIsoProbes = new Vector();
                chrom = new LipidomicsChromatogram(this.readAChromatogram(mz + (float)i * massToAdd / (float)charge, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
                chrom.GetMaximumAndAverage();
                this.chromHash_.put(i, chrom);
                double multiplicationFactor = possibleProbabs.get(i) / possibleProbabs.get(0);
                for (int j = 0; j != vector.size(); ++j) {
                    if (!isOfInterest[j]) continue;
                    Probe3D aProbe = (Probe3D)vector.get(j);
                    Hashtable<Object, Object> isoAreasOfOneProbe = new Hashtable();
                    if (isotopicAreas.containsKey(j)) {
                        isoAreasOfOneProbe = isotopicAreas.get(j);
                    }
                    Vector result = this.calculateIsoProbesWithinZeroIsotopeBoundaries(chrom, aProbe, vector, multiplicationFactor, recentIsoProbes, possibleProbabs.get(1) / possibleProbabs.get(0), false, charge, msLevel);
                    CgProbe isoProbe = (CgProbe)result.get(0);
                    currentIsoProbes.addAll((Vector)result.get(1));
                    if (isoProbe == null || isoProbe.AreaStatus != CgAreaStatus.OK) continue;
                    isoProbe.isotopeNumber = i;
                    Vector<CgProbe> isoAreas = new Vector<CgProbe>();
                    isoAreas.add(isoProbe);
                    isoAreasOfOneProbe.put(i, isoAreas);
                    isotopicAreas.put(j, isoAreasOfOneProbe);
                }
                currentIsoProbes = this.curateCurrentIsoProbes(currentIsoProbes, i, isotopicAreas, isOfInterest);
            }
        }
        isotopicAreas = this.uniteClosePeaks(this.uniteClosePeaks(isotopicAreas, this.chromHash_, msLevel), this.chromHash_, msLevel);
        this.releaseCacheHashes();
        return isotopicAreas;
    }

    private Vector<Vector<CgProbe>> scanForHits(LipidomicsChromatogram chrom, LipidomicsChromatogram previousIsoChrom, double possibleIsoLowerMinimum, int charge, int msLevel, float retentionTime, Vector<Float> retentionTimes, float prevTimeTolerance, float afterTimeTolerance, int timeType) throws CgException {
        Vector<Vector<CgProbe>> both = new Vector<Vector<CgProbe>>();
        Vector<CgProbe> allProbes = new Vector<CgProbe>();
        Vector<Probe3D> otherIsoProbes1 = new Vector<Probe3D>();
        Probe3D probe = null;
        int currentScan = 0;
        Probe3D currentValidProbe = null;
        if (retentionTimes != null && retentionTimes.size() > 0) {
            float prevTime = prevTimeTolerance;
            float afterTime = afterTimeTolerance;
            if (timeType == 1) {
                prevTime *= 60.0f;
                afterTime *= 60.0f;
            }
            for (float retTime : retentionTimes) {
                boolean bl = false;
                for (CgProbe cgProbe : allProbes) {
                    if (!(cgProbe.LowerValley < retTime) || !(retTime < cgProbe.UpperValley)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                for (CgProbe cgProbe : otherIsoProbes1) {
                    if (!(cgProbe.LowerValley < retTime) || !(retTime < cgProbe.UpperValley)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                int mainScan = LipidomicsAnalyzer.findIndexByTime(retTime, chrom);
                probe = this.calculateAreaWithoutPrevIso(chrom, previousIsoChrom, mainScan, possibleIsoLowerMinimum, true, charge, msLevel);
                if (probe != null && probe.AreaStatus == CgAreaStatus.OK) {
                    this.checkDuplicate(allProbes, probe);
                    if (probe.AreaStatus != CgAreaStatus.OK) continue;
                    allProbes.add(probe);
                    continue;
                }
                if (probe == null || probe.AreaStatus != CgAreaStatus.OtherIso) continue;
                this.checkDuplicate(otherIsoProbes1, probe);
                if (probe.AreaStatus != CgAreaStatus.OtherIso) continue;
                otherIsoProbes1.add(probe);
            }
            Vector<Range> rangesToCover = new Vector<Range>();
            for (float f : retentionTimes) {
                Range range = new Range(f - prevTime, f + afterTime);
                boolean bl = false;
                for (int i = 0; i != rangesToCover.size(); ++i) {
                    Range exRange = (Range)rangesToCover.get(i);
                    if (!range.overlap(exRange)) continue;
                    exRange.combine(range);
                    bl = true;
                    break;
                }
                if (bl) continue;
                rangesToCover.add(range);
            }
            for (CgProbe cgProbe : allProbes) {
                Vector<Range> reducedCover = new Vector<Range>();
                for (Range range : rangesToCover) {
                    reducedCover.addAll(Range.reduce(range, new Range(cgProbe.LowerValley, cgProbe.UpperValley)));
                }
                rangesToCover = reducedCover;
            }
            for (CgProbe cgProbe : otherIsoProbes1) {
                Vector<Range> reducedCover = new Vector<Range>();
                for (Range range : rangesToCover) {
                    reducedCover.addAll(Range.reduce(range, new Range(cgProbe.LowerValley, cgProbe.UpperValley)));
                }
                rangesToCover = reducedCover;
            }
            for (Range range : rangesToCover) {
                currentScan = LipidomicsAnalyzer.findIndexByTime(range.getStart(), chrom);
                int stopScan = LipidomicsAnalyzer.findIndexByTime(range.getStop(), chrom) + 1;
                while (currentScan < chrom.ScanCount && currentScan < stopScan) {
                    probe = this.calculateAreaWithoutPrevIso(chrom, previousIsoChrom, currentScan, possibleIsoLowerMinimum, true, charge, msLevel);
                    if (probe != null && probe.AreaStatus == CgAreaStatus.OK) {
                        int n;
                        this.checkDuplicate(allProbes, probe);
                        if (probe.AreaStatus == CgAreaStatus.OK) {
                            allProbes.add(probe);
                        }
                        if (currentValidProbe != null && (n = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.UpperValley, chrom)) > currentScan) {
                            currentScan = n;
                        }
                    } else if (probe != null && probe.AreaStatus == CgAreaStatus.OtherIso) {
                        this.checkDuplicate(otherIsoProbes1, probe);
                        if (probe.AreaStatus == CgAreaStatus.OtherIso) {
                            otherIsoProbes1.add(probe);
                        }
                    }
                    currentScan += this.scanStep_;
                    Vector vector = new Vector(allProbes);
                    allProbes = new Vector();
                    for (CgProbe another : vector) {
                        if (another.AreaStatus == CgAreaStatus.Duplicate) continue;
                        allProbes.add(another);
                    }
                }
            }
        } else {
            int stopScan = Integer.MAX_VALUE;
            if (retentionTime > 0.0f && prevTimeTolerance > 0.0f && afterTimeTolerance > 0.0f) {
                float mainRetTime = retentionTime;
                float startRetTime = mainRetTime - prevTimeTolerance;
                if (startRetTime < 0.0f) {
                    startRetTime = 0.0f;
                }
                float stopRetTime = mainRetTime + afterTimeTolerance;
                if (timeType == 1) {
                    mainRetTime *= 60.0f;
                    startRetTime *= 60.0f;
                    stopRetTime *= 60.0f;
                }
                int n = LipidomicsAnalyzer.findIndexByTime(mainRetTime, chrom);
                int startScan = LipidomicsAnalyzer.findIndexByTime(startRetTime, chrom);
                stopScan = LipidomicsAnalyzer.findIndexByTime(stopRetTime, chrom) + 1;
                probe = this.calculateAreaWithoutPrevIso(chrom, previousIsoChrom, n, possibleIsoLowerMinimum, true, charge, msLevel);
                currentScan = n;
                if (probe != null && probe.AreaStatus == CgAreaStatus.OK) {
                    allProbes.add(probe);
                    currentValidProbe = probe;
                    int n2 = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.LowerValley, chrom);
                    if (n2 < currentScan) {
                        currentScan = n2;
                    }
                } else if (probe != null && probe.AreaStatus == CgAreaStatus.OtherIso) {
                    otherIsoProbes1.add(probe);
                }
                --currentScan;
                while (currentScan >= startScan) {
                    probe = this.calculateAreaWithoutPrevIso(chrom, previousIsoChrom, currentScan, possibleIsoLowerMinimum, true, charge, msLevel);
                    if (probe != null && probe.AreaStatus == CgAreaStatus.OK) {
                        int n3;
                        this.checkDuplicate(allProbes, probe);
                        if (probe.AreaStatus == CgAreaStatus.OK) {
                            allProbes.add(probe);
                        }
                        if (currentValidProbe != null && (n3 = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.LowerValley, chrom)) < currentScan) {
                            currentScan = n3;
                        }
                    } else if (probe != null && probe.AreaStatus == CgAreaStatus.OtherIso) {
                        this.checkDuplicate(otherIsoProbes1, probe);
                        if (probe.AreaStatus == CgAreaStatus.OtherIso) {
                            otherIsoProbes1.add(probe);
                        }
                    }
                    Vector vector = new Vector(allProbes);
                    allProbes = new Vector();
                    for (CgProbe another : vector) {
                        if (another.AreaStatus == CgAreaStatus.Duplicate) continue;
                        allProbes.add(another);
                    }
                    currentScan -= this.scanStep_;
                }
                currentScan = n;
                if (allProbes.size() > 0) {
                    int highesTimeScan;
                    CgProbe cgProbe = (CgProbe)allProbes.get(0);
                    if (currentValidProbe != null && (highesTimeScan = LipidomicsAnalyzer.findIndexByTime(cgProbe.UpperValley, chrom)) > currentScan) {
                        currentScan = highesTimeScan;
                    }
                }
                ++currentScan;
            }
            while (currentScan < chrom.ScanCount && currentScan < stopScan) {
                probe = this.calculateAreaWithoutPrevIso(chrom, previousIsoChrom, currentScan, possibleIsoLowerMinimum, true, charge, msLevel);
                if (probe != null && probe.AreaStatus == CgAreaStatus.OK) {
                    int upScan;
                    this.checkDuplicate(allProbes, probe);
                    if (probe.AreaStatus == CgAreaStatus.OK) {
                        allProbes.add(probe);
                    }
                    if (currentValidProbe != null && (upScan = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.UpperValley, chrom)) > currentScan) {
                        currentScan = upScan;
                    }
                } else if (probe != null && probe.AreaStatus == CgAreaStatus.OtherIso) {
                    this.checkDuplicate(otherIsoProbes1, probe);
                    if (probe.AreaStatus == CgAreaStatus.OtherIso) {
                        otherIsoProbes1.add(probe);
                    }
                }
                currentScan += this.scanStep_;
                Vector probes = new Vector(allProbes);
                allProbes = new Vector();
                for (CgProbe another : probes) {
                    if (another.AreaStatus == CgAreaStatus.Duplicate) continue;
                    allProbes.add(another);
                }
            }
        }
        both.add(allProbes);
        both.add(otherIsoProbes1);
        return both;
    }

    public Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> processByMzAndRetentionTime(float mz, int charge, float retentionTime, float prevTimeTolerance, float afterTimeTolerance, int timeType, Vector<Double> probabs, Vector<Double> possibleProbabs, int msLevel, boolean negative) throws CgException {
        Vector<CgProbe> oneisotopeProbeOK;
        Object rightProbe;
        double upperArea;
        double lowerArea;
        double[] isotopeRegionAreas;
        CgProbe isotopeProbeGreedy;
        int scan;
        Hashtable<Object, Object> isoAreasOfOneProbe;
        CgProbe aProbe;
        int j;
        Vector<CgProbe> allowedPrevIsos;
        int i;
        int highesTimeScan;
        CgProbe greedyProbe;
        int isPossibleIsotope;
        CgProbe probe;
        this.coarseChromMzTolerance_ = LipidomicsConstants.getCoarseChromMzTolerance(mz);
        float massToAdd = LipidomicsConstants.getNeutronMass();
        if (negative) {
            massToAdd *= -1.0f;
        }
        Vector<CgProbe> allProbes = new Vector<CgProbe>();
        float mainRetTime = retentionTime;
        float startRetTime = mainRetTime - prevTimeTolerance;
        if (startRetTime < 0.0f) {
            startRetTime = 0.0f;
        }
        float stopRetTime = mainRetTime + afterTimeTolerance;
        if (timeType == 1) {
            mainRetTime *= 60.0f;
            startRetTime *= 60.0f;
            stopRetTime *= 60.0f;
        }
        LipidomicsChromatogram previousIsoChrom = new LipidomicsChromatogram(this.readAChromatogram(mz - massToAdd / (float)charge, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
        previousIsoChrom.GetMaximumAndAverage();
        double multiplicationFactor = 1.0;
        if (probabs.size() > 1) {
            multiplicationFactor = probabs.get(0) / probabs.get(1) * 0.6666666865348816;
        }
        LipidomicsChromatogram chrom = new LipidomicsChromatogram(this.readAChromatogram(mz, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
        int mainScan = LipidomicsAnalyzer.findIndexByTime(mainRetTime, chrom);
        int startScan = LipidomicsAnalyzer.findIndexByTime(startRetTime, chrom);
        int stopScan = LipidomicsAnalyzer.findIndexByTime(stopRetTime, chrom);
        chrom.GetMaximumAndAverage();
        Vector result = this.calculateOneAreaWithoutPrevIso(chrom, previousIsoChrom, mainScan, multiplicationFactor, new Vector<CgProbe>(), true, charge);
        Vector theProbes = (Vector)result.get(0);
        int lowestScan = (Integer)result.get(1);
        int highestScan = (Integer)result.get(2);
        CgProbe currentValidProbe = null;
        for (int i2 = theProbes.size() - 1; i2 != -1; --i2) {
            CgProbe anProbe = (CgProbe)theProbes.get(i2);
            if (anProbe == null || anProbe.AreaStatus != CgAreaStatus.OK) continue;
            allProbes.add(anProbe);
            currentValidProbe = anProbe;
        }
        int currentScan = mainScan - 1;
        if (currentValidProbe != null) {
            currentScan = lowestScan;
        }
        while (currentScan >= startScan) {
            result = this.calculateOneAreaWithoutPrevIso(chrom, previousIsoChrom, currentScan, multiplicationFactor, new Vector<CgProbe>(), true, charge);
            theProbes = (Vector)result.get(0);
            lowestScan = (Integer)result.get(1);
            for (int i3 = theProbes.size() - 1; i3 != -1; --i3) {
                probe = (CgProbe)theProbes.get(i3);
                if (probe.AreaStatus != CgAreaStatus.OK) continue;
                this.checkDuplicate(allProbes, probe);
                if (!probe.greedyProbe && probe.AreaStatus == CgAreaStatus.Duplicate) {
                    probe = LipidomicsAnalyzer.calculateOneArea(chrom, currentScan, LipidomicsDefines.StandardValleyMethod, charge);
                }
                isPossibleIsotope = 0;
                isPossibleIsotope = probe.greedyProbe ? this.isFromOtherIsotope(probe, LipidomicsDefines.GreedySteepnessReductionMethod, previousIsoChrom, multiplicationFactor, new Vector<CgProbe>()) : this.isFromOtherIsotope(probe, LipidomicsDefines.StandardValleyMethod, previousIsoChrom, multiplicationFactor, new Vector<CgProbe>());
                if (isPossibleIsotope == POSSIBLE_ISOTOPE_OVERLAP && !probe.greedyProbe) {
                    greedyProbe = LipidomicsAnalyzer.calculateOneArea(chrom, currentScan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                    if ((greedyProbe = this.selectCorrespondingGreedyProbeIsGreedy(probe, greedyProbe, chrom, previousIsoChrom, multiplicationFactor, new Vector<CgProbe>(), charge)) != null) {
                        greedyProbe.greedyProbe = true;
                        probe = greedyProbe;
                    }
                }
                if (isPossibleIsotope != ISOTOPE_PRESENT) {
                    this.checkDuplicate(allProbes, probe);
                    if (currentValidProbe == null || probe.AreaStatus == CgAreaStatus.OK) {
                        currentValidProbe = probe;
                    }
                    allProbes.add(probe);
                }
                if (lowestScan >= currentScan) continue;
                currentScan = lowestScan;
            }
            --currentScan;
        }
        currentScan = mainScan + 1;
        if (allProbes.size() > 0 && (highesTimeScan = highestScan) > currentScan) {
            currentScan = highesTimeScan;
        }
        while (currentScan <= stopScan) {
            result = this.calculateOneAreaWithoutPrevIso(chrom, previousIsoChrom, currentScan, multiplicationFactor, new Vector<CgProbe>(), true, charge);
            theProbes = (Vector)result.get(0);
            highestScan = (Integer)result.get(2);
            for (int i4 = 0; i4 != theProbes.size(); ++i4) {
                probe = (CgProbe)theProbes.get(i4);
                if (probe.AreaStatus != CgAreaStatus.OK) continue;
                this.checkDuplicate(allProbes, probe);
                this.checkDuplicate(allProbes, probe);
                if (!probe.greedyProbe && probe.AreaStatus == CgAreaStatus.Duplicate) {
                    probe = LipidomicsAnalyzer.calculateOneArea(chrom, currentScan, LipidomicsDefines.StandardValleyMethod, charge);
                }
                isPossibleIsotope = 0;
                isPossibleIsotope = probe.greedyProbe ? this.isFromOtherIsotope(probe, LipidomicsDefines.GreedySteepnessReductionMethod, previousIsoChrom, multiplicationFactor, new Vector<CgProbe>()) : this.isFromOtherIsotope(probe, LipidomicsDefines.StandardValleyMethod, previousIsoChrom, multiplicationFactor, new Vector<CgProbe>());
                if (isPossibleIsotope == POSSIBLE_ISOTOPE_OVERLAP && !probe.greedyProbe) {
                    greedyProbe = LipidomicsAnalyzer.calculateOneArea(chrom, currentScan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                    if ((greedyProbe = this.selectCorrespondingGreedyProbeIsGreedy(probe, greedyProbe, chrom, previousIsoChrom, multiplicationFactor, new Vector<CgProbe>(), charge)) != null) {
                        greedyProbe.greedyProbe = true;
                        probe = greedyProbe;
                    }
                }
                if (isPossibleIsotope != ISOTOPE_PRESENT) {
                    this.checkDuplicate(allProbes, probe);
                    if (currentValidProbe == null || probe.AreaStatus == CgAreaStatus.OK) {
                        currentValidProbe = probe;
                    }
                    allProbes.add(probe);
                }
                if (highestScan <= currentScan) continue;
                currentScan = highestScan;
            }
            ++currentScan;
        }
        Vector<CgProbe> probes1 = new Vector<CgProbe>();
        float biggestArea = 0.0f;
        CgProbe highestProbe = null;
        for (int i5 = 0; i5 != allProbes.size(); ++i5) {
            CgProbe aProbe2 = (CgProbe)allProbes.get(i5);
            if (aProbe2.AreaStatus != CgAreaStatus.OK) continue;
            probes1.add(aProbe2);
            if (!(aProbe2.Area > biggestArea)) continue;
            biggestArea = aProbe2.Area;
            highestProbe = aProbe2;
        }
        Vector<CgProbe> probes = probes1;
        double mainPeak = 1.0;
        boolean[] isOfInterest = new boolean[probes.size()];
        for (int i6 = 0; i6 != probes.size(); ++i6) {
            isOfInterest[i6] = true;
        }
        Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> isotopicAreas = new Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>>();
        for (int j2 = 0; j2 != probes.size(); ++j2) {
            if (!isOfInterest[j2]) continue;
            Vector areas = new Vector();
            areas.add(probes.get(j2));
            Hashtable isoAreasOfOneIso = new Hashtable();
            isoAreasOfOneIso.put(0, areas);
            isotopicAreas.put(j2, isoAreasOfOneIso);
        }
        for (i = 0; i != probabs.size(); ++i) {
            previousIsoChrom = chrom;
            if (i == 0) {
                mainPeak = probabs.get(i);
                continue;
            }
            double relativeValue = probabs.get(i) / mainPeak;
            chrom = new LipidomicsChromatogram(this.readAChromatogram(mz + (float)i * massToAdd / (float)charge, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
            chrom.GetMaximumAndAverage();
            allowedPrevIsos = this.getAllowedPrevIsos(isotopicAreas, i - 1, isOfInterest);
            for (j = 0; j != probes.size(); ++j) {
                if (!isOfInterest[j]) continue;
                aProbe = (CgProbe)probes.get(j);
                isoAreasOfOneProbe = new Hashtable();
                if (isotopicAreas.containsKey(j)) {
                    isoAreasOfOneProbe = isotopicAreas.get(j);
                }
                scan = LipidomicsAnalyzer.findIndexByTime(aProbe.Peak, chrom);
                result = this.calculateOneAreaWithoutPrevIso(chrom, previousIsoChrom, scan, multiplicationFactor, allowedPrevIsos, false, charge);
                theProbes = (Vector)result.get(0);
                boolean isOneOfInterest = false;
                double theoreticalAreaValue = (double)aProbe.Area * relativeValue;
                Vector<Object> oneisotopeProbes = new Vector<Object>();
                for (Object isotopeProbe : theProbes) {
                    ((CgProbe)isotopeProbe).isotopeNumber = i;
                    if (((CgProbe)isotopeProbe).AreaStatus != CgAreaStatus.OK) continue;
                    CgProbe cgProbe = LipidomicsAnalyzer.calculateOneArea(chrom, scan, LipidomicsDefines.StandardValleyMethod, charge);
                    cgProbe.isotopeNumber = i;
                    isotopeProbeGreedy = LipidomicsAnalyzer.calculateOneArea(chrom, scan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                    isotopeProbeGreedy.isotopeNumber = i;
                    isotopeProbeGreedy.greedyProbe = true;
                    isotopeRegionAreas = this.calculateLowerUpperArea(i, theoreticalAreaValue, aProbe.greedyProbe);
                    lowerArea = isotopeRegionAreas[0];
                    upperArea = isotopeRegionAreas[1];
                    if (!(lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea || cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea) && (isotopeProbeGreedy.AreaStatus != CgAreaStatus.OK || !(lowerArea < (double)isotopeProbeGreedy.Area) || !((double)isotopeProbeGreedy.Area < upperArea))) continue;
                    rightProbe = isotopeProbe;
                    if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea || lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea || cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                        if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                            rightProbe = this.checkCloserToExpected(aProbe, (CgProbe)isotopeProbe, cgProbe, isotopeProbeGreedy);
                        } else if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea) {
                            rightProbe = this.checkCloserToExpected(aProbe, (CgProbe)isotopeProbe, cgProbe);
                        } else if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                            rightProbe = this.checkCloserToExpected(aProbe, (CgProbe)isotopeProbe, isotopeProbeGreedy);
                        } else if (cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                            rightProbe = this.checkCloserToExpected(aProbe, cgProbe, isotopeProbeGreedy);
                        }
                    } else if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea) {
                        rightProbe = isotopeProbe;
                    } else if (cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea) {
                        rightProbe = cgProbe;
                    } else if (isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                        rightProbe = isotopeProbeGreedy;
                    }
                    this.checkDuplicate(oneisotopeProbes, (CgProbe)rightProbe);
                    oneisotopeProbes.add(rightProbe);
                    isOneOfInterest = true;
                }
                if (isOneOfInterest) {
                    Object isotopeProbe;
                    oneisotopeProbeOK = new Vector<CgProbe>();
                    isotopeProbe = oneisotopeProbes.iterator();
                    while (isotopeProbe.hasNext()) {
                        CgProbe cgProbe = (CgProbe)isotopeProbe.next();
                        if (cgProbe.AreaStatus != CgAreaStatus.OK) continue;
                        oneisotopeProbeOK.add(cgProbe);
                    }
                    if (oneisotopeProbeOK.size() > 0) {
                        isoAreasOfOneProbe.put(i, oneisotopeProbeOK);
                        isotopicAreas.put(j, isoAreasOfOneProbe);
                        continue;
                    }
                    isOfInterest[j] = false;
                    isotopicAreas.remove(j);
                    continue;
                }
                isOfInterest[j] = false;
                isotopicAreas.remove(j);
            }
        }
        biggestArea = 0.0f;
        highestProbe = null;
        for (i = 0; i != probes.size(); ++i) {
            if (!isOfInterest[i]) continue;
            CgProbe aProbe3 = (CgProbe)probes.get(i);
            if (aProbe3.AreaStatus != CgAreaStatus.OK || !(aProbe3.Area > biggestArea)) continue;
            biggestArea = aProbe3.Area;
            highestProbe = aProbe3;
        }
        for (i = 0; i != probes.size(); ++i) {
            if (!isOfInterest[i]) continue;
            CgProbe aProbe4 = (CgProbe)probes.get(i);
            if (aProbe4.AreaStatus != CgAreaStatus.OK) continue;
            if (aProbe4.Area > biggestArea / 200.0f) {
                if (!(this.checkTimeSpace(highestProbe, aProbe4) >= 30.0f)) continue;
                isOfInterest[i] = false;
                isotopicAreas.remove(i);
                continue;
            }
            isOfInterest[i] = false;
            isotopicAreas.remove(i);
        }
        if (possibleProbabs.size() > probabs.size()) {
            for (i = probabs.size(); i != possibleProbabs.size(); ++i) {
                double relativeValue = possibleProbabs.get(i) / mainPeak;
                previousIsoChrom = chrom;
                chrom = new LipidomicsChromatogram(this.readAChromatogram(mz + (float)i * massToAdd / (float)charge, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
                chrom.GetMaximumAndAverage();
                allowedPrevIsos = this.getAllowedPrevIsos(isotopicAreas, i - 1, isOfInterest);
                for (j = 0; j != probes.size(); ++j) {
                    if (!isOfInterest[j]) continue;
                    aProbe = (CgProbe)probes.get(j);
                    isoAreasOfOneProbe = new Hashtable();
                    if (isotopicAreas.containsKey(j)) {
                        isoAreasOfOneProbe = isotopicAreas.get(j);
                    }
                    scan = LipidomicsAnalyzer.findIndexByTime(aProbe.Peak, chrom);
                    result = this.calculateOneAreaWithoutPrevIso(chrom, previousIsoChrom, scan, multiplicationFactor, allowedPrevIsos, false, charge);
                    theProbes = (Vector)result.get(0);
                    double theoreticalAreaValue = (double)aProbe.Area * relativeValue;
                    Vector<Object> oneisotopeProbes = new Vector<Object>();
                    boolean isOneOfInterest = false;
                    for (Object isotopeProbe : theProbes) {
                        ((CgProbe)isotopeProbe).isotopeNumber = i;
                        if (((CgProbe)isotopeProbe).AreaStatus != CgAreaStatus.OK) continue;
                        CgProbe cgProbe = LipidomicsAnalyzer.calculateOneArea(chrom, scan, LipidomicsDefines.StandardValleyMethod, charge);
                        cgProbe.isotopeNumber = i;
                        isotopeProbeGreedy = LipidomicsAnalyzer.calculateOneArea(chrom, scan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                        isotopeProbeGreedy.isotopeNumber = i;
                        isotopeProbeGreedy.greedyProbe = true;
                        isotopeRegionAreas = this.calculateLowerUpperArea(i, theoreticalAreaValue, aProbe.greedyProbe);
                        lowerArea = isotopeRegionAreas[0];
                        upperArea = isotopeRegionAreas[1];
                        if (!(lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea || cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea) && (isotopeProbeGreedy.AreaStatus != CgAreaStatus.OK || !(lowerArea < (double)isotopeProbeGreedy.Area) || !((double)isotopeProbeGreedy.Area < upperArea))) continue;
                        rightProbe = isotopeProbe;
                        if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea || lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea || cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                            if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                                rightProbe = this.checkCloserToExpected(aProbe, (CgProbe)isotopeProbe, cgProbe, isotopeProbeGreedy);
                            } else if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea) {
                                rightProbe = this.checkCloserToExpected(aProbe, (CgProbe)isotopeProbe, cgProbe);
                            } else if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                                rightProbe = this.checkCloserToExpected(aProbe, (CgProbe)isotopeProbe, isotopeProbeGreedy);
                            } else if (cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                                rightProbe = this.checkCloserToExpected(aProbe, cgProbe, isotopeProbeGreedy);
                            }
                        } else if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea) {
                            rightProbe = isotopeProbe;
                        } else if (cgProbe.AreaStatus == CgAreaStatus.OK && lowerArea < (double)cgProbe.Area && (double)cgProbe.Area < upperArea) {
                            rightProbe = cgProbe;
                        } else if (isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                            rightProbe = isotopeProbeGreedy;
                        }
                        this.checkDuplicate(oneisotopeProbes, (CgProbe)rightProbe);
                        oneisotopeProbes.add(rightProbe);
                        isOneOfInterest = true;
                    }
                    if (!isOneOfInterest) continue;
                    oneisotopeProbeOK = new Vector<CgProbe>();
                    for (CgProbe cgProbe : oneisotopeProbes) {
                        if (cgProbe.AreaStatus != CgAreaStatus.OK) continue;
                        oneisotopeProbeOK.add(cgProbe);
                    }
                    isoAreasOfOneProbe.put(i, oneisotopeProbeOK);
                    isotopicAreas.put(j, isoAreasOfOneProbe);
                }
            }
        }
        return isotopicAreas;
    }

    public Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> processByMzAndProbabs(float mz, int charge, Vector<Double> probabs, Vector<Double> possibleProbabs, int msLevel, boolean negative) throws CgException {
        CgProbe aProbe;
        int i;
        int i2;
        this.coarseChromMzTolerance_ = LipidomicsConstants.getCoarseChromMzTolerance(mz);
        float massToAdd = LipidomicsConstants.getNeutronMass();
        LipidomicsChromatogram mainChrom = new LipidomicsChromatogram(this.readAChromatogram(mz, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
        mainChrom.GetMaximumAndAverage();
        LipidomicsChromatogram previousIsoChrom = new LipidomicsChromatogram(this.readAChromatogram(mz - massToAdd / (float)charge, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
        previousIsoChrom.GetMaximumAndAverage();
        double multiplicationFactor = probabs.get(0) / probabs.get(1) * 0.6666666865348816;
        Vector<CgProbe> allProbes = new Vector<CgProbe>();
        Vector result = null;
        Vector theProbes = null;
        for (int currentScan = 0; currentScan < mainChrom.Value.length; ++currentScan) {
            result = this.calculateOneAreaWithoutPrevIso(mainChrom, previousIsoChrom, currentScan, multiplicationFactor, new Vector<CgProbe>(), true, charge);
            theProbes = (Vector)result.get(0);
            int highestScan = (Integer)result.get(2);
            for (i2 = 0; i2 != theProbes.size(); ++i2) {
                CgProbe probe = (CgProbe)theProbes.get(i2);
                probe.isotopeNumber = 0;
                if (probe.AreaStatus != CgAreaStatus.OK) continue;
                this.checkDuplicate(allProbes, probe);
                if (!probe.greedyProbe && probe.AreaStatus == CgAreaStatus.Duplicate) {
                    probe = LipidomicsAnalyzer.calculateOneArea(mainChrom, currentScan, LipidomicsDefines.StandardValleyMethod, charge);
                }
                int isPossibleIsotope = 0;
                isPossibleIsotope = probe.greedyProbe ? this.isFromOtherIsotope(probe, LipidomicsDefines.GreedySteepnessReductionMethod, previousIsoChrom, multiplicationFactor, new Vector<CgProbe>()) : this.isFromOtherIsotope(probe, LipidomicsDefines.StandardValleyMethod, previousIsoChrom, multiplicationFactor, new Vector<CgProbe>());
                if (isPossibleIsotope == POSSIBLE_ISOTOPE_OVERLAP && !probe.greedyProbe) {
                    CgProbe greedyProbe = LipidomicsAnalyzer.calculateOneArea(mainChrom, currentScan, LipidomicsDefines.GreedySteepnessReductionMethod);
                    if ((greedyProbe = this.selectCorrespondingGreedyProbeIsGreedy(probe, greedyProbe, mainChrom, previousIsoChrom, multiplicationFactor, new Vector<CgProbe>(), charge)) != null) {
                        greedyProbe.greedyProbe = true;
                        probe = greedyProbe;
                    }
                }
                if (isPossibleIsotope != ISOTOPE_PRESENT) {
                    this.checkDuplicate(allProbes, probe);
                    allProbes.add(probe);
                }
                Vector<CgProbe> noDuplicateProbes = new Vector<CgProbe>();
                for (CgProbe aProbe2 : allProbes) {
                    if (aProbe2.AreaStatus != CgAreaStatus.OK) continue;
                    noDuplicateProbes.add(aProbe2);
                }
                allProbes = noDuplicateProbes;
                if (highestScan <= currentScan) continue;
                currentScan = highestScan;
            }
        }
        boolean[] isOfInterest = new boolean[allProbes.size()];
        for (i2 = 0; i2 != allProbes.size(); ++i2) {
            isOfInterest[i2] = true;
        }
        double mainPeak = 1.0;
        Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> isotopicAreas = new Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>>();
        for (int j = 0; j != allProbes.size(); ++j) {
            if (!isOfInterest[j]) continue;
            Vector areas = new Vector();
            areas.add(allProbes.get(j));
            Hashtable isoAreasOfOneIso = new Hashtable();
            isoAreasOfOneIso.put(0, areas);
            isotopicAreas.put(j, isoAreasOfOneIso);
        }
        for (int i3 = 0; i3 != probabs.size(); ++i3) {
            previousIsoChrom = mainChrom;
            if (i3 == 0) {
                mainPeak = probabs.get(i3);
                continue;
            }
            double relativeValue = probabs.get(i3) / mainPeak;
            mainChrom = new LipidomicsChromatogram(this.readAChromatogram(mz + (float)i3 * massToAdd / (float)charge, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
            mainChrom.GetMaximumAndAverage();
            Vector<CgProbe> allowedPrevIsos = this.getAllowedPrevIsos(isotopicAreas, i3 - 1, isOfInterest);
            for (int j = 0; j != allProbes.size(); ++j) {
                if (!isOfInterest[j]) continue;
                CgProbe aProbe3 = (CgProbe)allProbes.get(j);
                Hashtable<Object, Object> isoAreasOfOneProbe = new Hashtable();
                if (isotopicAreas.containsKey(j)) {
                    isoAreasOfOneProbe = isotopicAreas.get(j);
                }
                int scan = LipidomicsAnalyzer.findIndexByTime(aProbe3.Peak, mainChrom);
                result = this.calculateOneAreaWithoutPrevIso(mainChrom, previousIsoChrom, scan, multiplicationFactor, allowedPrevIsos, false, charge);
                theProbes = (Vector)result.get(0);
                boolean isOneOfInterest = false;
                double theoreticalAreaValue = (double)aProbe3.Area * relativeValue;
                Vector<Object> oneisotopeProbes = new Vector<Object>();
                for (Object isotopeProbe : theProbes) {
                    ((CgProbe)isotopeProbe).isotopeNumber = i3;
                    if (((CgProbe)isotopeProbe).AreaStatus != CgAreaStatus.OK) continue;
                    CgProbe isotopeProbeStandard = LipidomicsAnalyzer.calculateOneArea(mainChrom, scan, LipidomicsDefines.StandardValleyMethod, charge);
                    isotopeProbeStandard.isotopeNumber = i3;
                    CgProbe isotopeProbeGreedy = LipidomicsAnalyzer.calculateOneArea(mainChrom, scan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                    isotopeProbeGreedy.isotopeNumber = i3;
                    isotopeProbeGreedy.greedyProbe = true;
                    double[] isotopeRegionAreas = this.calculateLowerUpperArea(i3, theoreticalAreaValue, aProbe3.greedyProbe);
                    double lowerArea = isotopeRegionAreas[0];
                    double upperArea = isotopeRegionAreas[1];
                    if (!(lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea || isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea) && (isotopeProbeGreedy.AreaStatus != CgAreaStatus.OK || !(lowerArea < (double)isotopeProbeGreedy.Area) || !((double)isotopeProbeGreedy.Area < upperArea))) continue;
                    Object rightProbe = isotopeProbe;
                    if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea || lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea || isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                        if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                            rightProbe = this.checkCloserToExpected(aProbe3, (CgProbe)isotopeProbe, isotopeProbeStandard, isotopeProbeGreedy);
                        } else if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea) {
                            rightProbe = this.checkCloserToExpected(aProbe3, (CgProbe)isotopeProbe, isotopeProbeStandard);
                        } else if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                            rightProbe = this.checkCloserToExpected(aProbe3, (CgProbe)isotopeProbe, isotopeProbeGreedy);
                        } else if (isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                            rightProbe = this.checkCloserToExpected(aProbe3, isotopeProbeStandard, isotopeProbeGreedy);
                        }
                    } else if (lowerArea < (double)((CgProbe)isotopeProbe).Area && (double)((CgProbe)isotopeProbe).Area < upperArea) {
                        rightProbe = isotopeProbe;
                    } else if (isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea) {
                        rightProbe = isotopeProbeStandard;
                    } else if (isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                        rightProbe = isotopeProbeGreedy;
                    }
                    this.checkDuplicate(oneisotopeProbes, (CgProbe)rightProbe);
                    oneisotopeProbes.add(rightProbe);
                    isOneOfInterest = true;
                }
                if (isOneOfInterest) {
                    Object isotopeProbe;
                    Vector<CgProbe> oneisotopeProbeOK = new Vector<CgProbe>();
                    isotopeProbe = oneisotopeProbes.iterator();
                    while (isotopeProbe.hasNext()) {
                        CgProbe anProbe = (CgProbe)isotopeProbe.next();
                        if (anProbe.AreaStatus != CgAreaStatus.OK) continue;
                        oneisotopeProbeOK.add(anProbe);
                    }
                    if (oneisotopeProbeOK.size() > 0) {
                        isoAreasOfOneProbe.put(i3, oneisotopeProbeOK);
                        isotopicAreas.put(j, isoAreasOfOneProbe);
                        continue;
                    }
                    isOfInterest[j] = false;
                    isotopicAreas.remove(j);
                    continue;
                }
                isOfInterest[j] = false;
                isotopicAreas.remove(j);
            }
        }
        float biggestArea = 0.0f;
        CgProbe highestProbe = null;
        for (i = 0; i != allProbes.size(); ++i) {
            if (!isOfInterest[i]) continue;
            aProbe = (CgProbe)allProbes.get(i);
            if (aProbe.AreaStatus != CgAreaStatus.OK || !(aProbe.Area > biggestArea)) continue;
            biggestArea = aProbe.Area;
            highestProbe = aProbe;
        }
        for (i = 0; i != allProbes.size(); ++i) {
            if (!isOfInterest[i]) continue;
            aProbe = (CgProbe)allProbes.get(i);
            if (aProbe.AreaStatus != CgAreaStatus.OK) continue;
            if (aProbe.Area > biggestArea / 200.0f) {
                if (!(this.checkTimeSpace(highestProbe, aProbe) >= 30.0f)) continue;
                isOfInterest[i] = false;
                isotopicAreas.remove(i);
                continue;
            }
            isOfInterest[i] = false;
            isotopicAreas.remove(i);
        }
        if (possibleProbabs.size() > probabs.size()) {
            for (i = probabs.size(); i != possibleProbabs.size(); ++i) {
                double relativeValue = possibleProbabs.get(i) / mainPeak;
                previousIsoChrom = mainChrom;
                mainChrom = new LipidomicsChromatogram(this.readAChromatogram(mz + (float)i * massToAdd / (float)charge, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
                mainChrom.GetMaximumAndAverage();
                Vector<CgProbe> allowedPrevIsos = this.getAllowedPrevIsos(isotopicAreas, i - 1, isOfInterest);
                for (int j = 0; j != allProbes.size(); ++j) {
                    if (!isOfInterest[j]) continue;
                    CgProbe aProbe4 = (CgProbe)allProbes.get(j);
                    Hashtable<Object, Object> isoAreasOfOneProbe = new Hashtable();
                    if (isotopicAreas.containsKey(j)) {
                        isoAreasOfOneProbe = isotopicAreas.get(j);
                    }
                    int scan = LipidomicsAnalyzer.findIndexByTime(aProbe4.Peak, mainChrom);
                    result = this.calculateOneAreaWithoutPrevIso(mainChrom, previousIsoChrom, scan, multiplicationFactor, allowedPrevIsos, false, charge);
                    theProbes = (Vector)result.get(0);
                    double theoreticalAreaValue = (double)aProbe4.Area * relativeValue;
                    Vector<CgProbe> oneisotopeProbes = new Vector<CgProbe>();
                    boolean isOneOfInterest = false;
                    for (CgProbe isotopeProbe : theProbes) {
                        isotopeProbe.isotopeNumber = i;
                        if (isotopeProbe.AreaStatus != CgAreaStatus.OK) continue;
                        CgProbe isotopeProbeStandard = LipidomicsAnalyzer.calculateOneArea(mainChrom, scan, LipidomicsDefines.StandardValleyMethod, charge);
                        isotopeProbeStandard.isotopeNumber = i;
                        CgProbe isotopeProbeGreedy = LipidomicsAnalyzer.calculateOneArea(mainChrom, scan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                        isotopeProbeGreedy.isotopeNumber = i;
                        isotopeProbeGreedy.greedyProbe = true;
                        double[] isotopeRegionAreas = this.calculateLowerUpperArea(i, theoreticalAreaValue, aProbe4.greedyProbe);
                        double lowerArea = isotopeRegionAreas[0];
                        double upperArea = isotopeRegionAreas[1];
                        if (!(lowerArea < (double)isotopeProbe.Area && (double)isotopeProbe.Area < upperArea || isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea) && (isotopeProbeGreedy.AreaStatus != CgAreaStatus.OK || !(lowerArea < (double)isotopeProbeGreedy.Area) || !((double)isotopeProbeGreedy.Area < upperArea))) continue;
                        CgProbe rightProbe = isotopeProbe;
                        if (lowerArea < (double)isotopeProbe.Area && (double)isotopeProbe.Area < upperArea && isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea || lowerArea < (double)isotopeProbe.Area && (double)isotopeProbe.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea || isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                            if (lowerArea < (double)isotopeProbe.Area && (double)isotopeProbe.Area < upperArea && isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                                rightProbe = this.checkCloserToExpected(aProbe4, isotopeProbe, isotopeProbeStandard, isotopeProbeGreedy);
                            } else if (lowerArea < (double)isotopeProbe.Area && (double)isotopeProbe.Area < upperArea && isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea) {
                                rightProbe = this.checkCloserToExpected(aProbe4, isotopeProbe, isotopeProbeStandard);
                            } else if (lowerArea < (double)isotopeProbe.Area && (double)isotopeProbe.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                                rightProbe = this.checkCloserToExpected(aProbe4, isotopeProbe, isotopeProbeGreedy);
                            } else if (isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea && isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                                rightProbe = this.checkCloserToExpected(aProbe4, isotopeProbeStandard, isotopeProbeGreedy);
                            }
                        } else if (lowerArea < (double)isotopeProbe.Area && (double)isotopeProbe.Area < upperArea) {
                            rightProbe = isotopeProbe;
                        } else if (isotopeProbeStandard.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeStandard.Area && (double)isotopeProbeStandard.Area < upperArea) {
                            rightProbe = isotopeProbeStandard;
                        } else if (isotopeProbeGreedy.AreaStatus == CgAreaStatus.OK && lowerArea < (double)isotopeProbeGreedy.Area && (double)isotopeProbeGreedy.Area < upperArea) {
                            rightProbe = isotopeProbeGreedy;
                        }
                        this.checkDuplicate(oneisotopeProbes, rightProbe);
                        oneisotopeProbes.add(rightProbe);
                        isOneOfInterest = true;
                    }
                    if (!isOneOfInterest) continue;
                    Vector<CgProbe> oneisotopeProbeOK = new Vector<CgProbe>();
                    for (CgProbe anProbe : oneisotopeProbes) {
                        if (anProbe.AreaStatus != CgAreaStatus.OK) continue;
                        oneisotopeProbeOK.add(anProbe);
                    }
                    isoAreasOfOneProbe.put(i, oneisotopeProbeOK);
                    isotopicAreas.put(j, isoAreasOfOneProbe);
                }
            }
        }
        return isotopicAreas;
    }

    private double[] calculateLowerUpperArea(int isotopeNumber, double theoreticalAreaValue, boolean greedyProbe) {
        double[] areas = new double[2];
        double lowerArea = 0.0;
        double upperArea = 0.0;
        lowerArea = theoreticalAreaValue / 3.0;
        upperArea = 2.0 * theoreticalAreaValue;
        areas[0] = lowerArea;
        areas[1] = upperArea;
        return areas;
    }

    protected Vector calculateOneAreaWithoutPrevIso(LipidomicsChromatogram chrom, LipidomicsChromatogram previousIsoChrom, int mainScan, double multiplicationFactor, Vector<CgProbe> allowedPrevIsos, boolean respectIntCutoff, int charge) {
        Vector<Serializable> result = new Vector<Serializable>();
        Vector<CgProbe> probes = new Vector<CgProbe>();
        if (!respectIntCutoff || chrom.Value[mainScan][1] > this.highestIntensity_ * this.generalBasePeakCutoff_) {
            CgProbe valleyProbe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.EnhancedValleyMethod, charge);
            CgProbe standardProbe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.StandardValleyMethod, charge);
            if (valleyProbe.AreaStatus == CgAreaStatus.OK) {
                if (standardProbe.AreaStatus == CgAreaStatus.OK && standardProbe.Area - 1.0f < valleyProbe.Area && valleyProbe.Area < standardProbe.Area + 1.0f) {
                    int isPossibleIsotope = this.isFromOtherIsotope(standardProbe, LipidomicsDefines.StandardValleyMethod, previousIsoChrom, multiplicationFactor, allowedPrevIsos);
                    if (isPossibleIsotope != NO_ISOTOPE_PRESENT) {
                        CgProbe greedyProbe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                        if ((greedyProbe = this.selectCorrespondingGreedyProbeIsGreedy(standardProbe, greedyProbe, chrom, previousIsoChrom, multiplicationFactor, allowedPrevIsos, charge)) != null) {
                            valleyProbe = greedyProbe;
                            valleyProbe.greedyProbe = true;
                            isPossibleIsotope = POSSIBLE_ISOTOPE_OVERLAP;
                        }
                    }
                    if (isPossibleIsotope == ISOTOPE_PRESENT) {
                        valleyProbe.AreaStatus = CgAreaStatus.TooSmall;
                    }
                    probes.add(valleyProbe);
                    if (valleyProbe.AreaStatus == CgAreaStatus.OK) {
                        if (this.highestArea_ < valleyProbe.Area) {
                            this.highestArea_ = valleyProbe.Area;
                        }
                        if (this.highestIntensity_ < valleyProbe.getHighestIntensity()) {
                            this.highestIntensity_ = valleyProbe.getHighestIntensity();
                        }
                    }
                    result.add(probes);
                    result.add(Integer.valueOf(LipidomicsAnalyzer.findIndexByTime(valleyProbe.LowerValley, chrom)));
                    result.add(Integer.valueOf(LipidomicsAnalyzer.findIndexByTime(valleyProbe.UpperValley, chrom)));
                } else {
                    Vector<CgProbe> allProbes = new Vector<CgProbe>();
                    Vector<CgProbe> okStandardProbes = this.calculateProbesWithinSpecificBoundaries(valleyProbe, standardProbe, chrom, LipidomicsDefines.StandardValleyMethod, charge);
                    Vector<Boolean> fromDifferentIsotope = new Vector<Boolean>();
                    boolean notOneFromDifferentIsotope = true;
                    Vector<CgProbe> okStandardProbesNew = new Vector<CgProbe>();
                    for (CgProbe aProbe : okStandardProbes) {
                        int isPossibleIsotope = this.isFromOtherIsotope(aProbe, LipidomicsDefines.StandardValleyMethod, previousIsoChrom, multiplicationFactor, allowedPrevIsos);
                        if (isPossibleIsotope == POSSIBLE_ISOTOPE_OVERLAP) {
                            CgProbe greedyProbe = LipidomicsAnalyzer.calculateOneArea(chrom, LipidomicsAnalyzer.findIndexByTime(aProbe.Peak, chrom), LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                            if ((greedyProbe = this.selectCorrespondingGreedyProbeIsGreedy(standardProbe, greedyProbe, chrom, previousIsoChrom, multiplicationFactor, allowedPrevIsos, charge)) != null) {
                                greedyProbe.greedyProbe = true;
                                okStandardProbesNew.add(greedyProbe);
                                notOneFromDifferentIsotope = false;
                            } else {
                                okStandardProbesNew.add(aProbe);
                            }
                            fromDifferentIsotope.add(false);
                            continue;
                        }
                        if (isPossibleIsotope != NO_ISOTOPE_PRESENT) {
                            fromDifferentIsotope.add(true);
                            notOneFromDifferentIsotope = false;
                            okStandardProbesNew.add(aProbe);
                            continue;
                        }
                        fromDifferentIsotope.add(false);
                        okStandardProbesNew.add(aProbe);
                    }
                    okStandardProbes = okStandardProbesNew;
                    if (notOneFromDifferentIsotope) {
                        allProbes.add(valleyProbe);
                    } else {
                        for (int i = 0; i != okStandardProbes.size(); ++i) {
                            if (!((Boolean)fromDifferentIsotope.get(i)).booleanValue()) {
                                int count = this.getSortPosition(allProbes, okStandardProbes.get(i));
                                this.checkDuplicate(allProbes, okStandardProbes.get(i));
                                allProbes.add(count, okStandardProbes.get(i));
                                continue;
                            }
                            CgProbe greedyProbe = LipidomicsAnalyzer.calculateOneArea(chrom, LipidomicsAnalyzer.findIndexByTime(okStandardProbes.get((int)i).Peak, chrom), LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                            if ((greedyProbe = this.selectCorrespondingGreedyProbeIsGreedy(standardProbe, greedyProbe, chrom, previousIsoChrom, multiplicationFactor, allowedPrevIsos, charge)) == null) continue;
                            int count = this.getSortPosition(allProbes, greedyProbe);
                            this.checkDuplicate(allProbes, greedyProbe);
                            greedyProbe.greedyProbe = true;
                            allProbes.add(count, greedyProbe);
                        }
                    }
                    for (CgProbe aProbe : allProbes) {
                        if (aProbe.AreaStatus != CgAreaStatus.OK) continue;
                        probes.add(aProbe);
                    }
                    result.add(probes);
                    result.add(Integer.valueOf(LipidomicsAnalyzer.findIndexByTime(valleyProbe.LowerValley, chrom)));
                    result.add(Integer.valueOf(LipidomicsAnalyzer.findIndexByTime(valleyProbe.UpperValley, chrom)));
                }
            } else if (standardProbe.AreaStatus == CgAreaStatus.OK) {
                int isPossibleIsotope = this.isFromOtherIsotope(standardProbe, LipidomicsDefines.StandardValleyMethod, previousIsoChrom, multiplicationFactor, allowedPrevIsos);
                if (isPossibleIsotope == POSSIBLE_ISOTOPE_OVERLAP) {
                    CgProbe greedyProbe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                    if ((greedyProbe = this.selectCorrespondingGreedyProbeIsGreedy(standardProbe, greedyProbe, chrom, previousIsoChrom, multiplicationFactor, allowedPrevIsos, charge)) != null) {
                        standardProbe = greedyProbe;
                        standardProbe.greedyProbe = true;
                    }
                }
                if (isPossibleIsotope == ISOTOPE_PRESENT) {
                    standardProbe.AreaStatus = CgAreaStatus.TooSmall;
                }
                probes.add(standardProbe);
                result.add(probes);
                result.add(Integer.valueOf(LipidomicsAnalyzer.findIndexByTime(standardProbe.LowerValley, chrom)));
                result.add(Integer.valueOf(LipidomicsAnalyzer.findIndexByTime(standardProbe.UpperValley, chrom)));
            } else {
                int isPossibleIsotope = this.isFromOtherIsotope(standardProbe, LipidomicsDefines.EnhancedValleyMethod, previousIsoChrom, multiplicationFactor, allowedPrevIsos);
                if (isPossibleIsotope == POSSIBLE_ISOTOPE_OVERLAP) {
                    CgProbe greedyProbe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
                    if ((greedyProbe = this.selectCorrespondingGreedyProbeIsGreedy(standardProbe, greedyProbe, chrom, previousIsoChrom, multiplicationFactor, allowedPrevIsos, charge)) != null) {
                        valleyProbe = greedyProbe;
                        valleyProbe.greedyProbe = true;
                    }
                }
                if (isPossibleIsotope == ISOTOPE_PRESENT) {
                    valleyProbe.AreaStatus = CgAreaStatus.TooSmall;
                }
                probes.add(valleyProbe);
                result.add(probes);
                result.add(Integer.valueOf(LipidomicsAnalyzer.findIndexByTime(valleyProbe.LowerValley, chrom)));
                result.add(Integer.valueOf(LipidomicsAnalyzer.findIndexByTime(valleyProbe.UpperValley, chrom)));
            }
        } else {
            result.add(probes);
            result.add(Integer.valueOf(mainScan));
            result.add(Integer.valueOf(mainScan));
        }
        return result;
    }

    private CgProbe selectCorrespondingGreedyProbeIsGreedy(CgProbe standardProbe, CgProbe greedyProbe, LipidomicsChromatogram chrom, LipidomicsChromatogram previousIsoChrom, double multiplicationFactor, Vector<CgProbe> allowedPrevIsos, int charge) {
        Vector<CgProbe> okStandardProbes = this.calculateProbesWithinSpecificBoundaries(standardProbe, greedyProbe, chrom, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
        Vector<CgProbe> probesWithoutIso = new Vector<CgProbe>();
        for (CgProbe newGreedyProbe : okStandardProbes) {
            if (!(newGreedyProbe.Area > standardProbe.Area / 10.0f) || this.isGreedyFromOtherIsotope(newGreedyProbe, standardProbe, previousIsoChrom, multiplicationFactor, allowedPrevIsos)) continue;
            probesWithoutIso.add(newGreedyProbe);
        }
        CgProbe returnProbe = null;
        for (CgProbe probeWithoutIso : probesWithoutIso) {
            if (returnProbe == null) {
                returnProbe = probeWithoutIso;
                continue;
            }
            if (!(probeWithoutIso.Area > returnProbe.Area)) continue;
            returnProbe = probeWithoutIso;
        }
        return returnProbe;
    }

    private Vector<CgProbe> calculateProbesWithinSpecificBoundaries(CgProbe valleyProbe, CgProbe standardProbe, LipidomicsChromatogram chrom, int mode, int charge) {
        CgProbe probe;
        int lowerIndex = LipidomicsAnalyzer.findIndexByTime(valleyProbe.LowerValley, chrom);
        int upperIndex = LipidomicsAnalyzer.findIndexByTime(valleyProbe.UpperValley, chrom);
        int currentScan = LipidomicsAnalyzer.findIndexByTime(standardProbe.LowerValley, chrom);
        Vector<CgProbe> allStandardProbes = new Vector<CgProbe>();
        if (standardProbe.AreaStatus == CgAreaStatus.OK) {
            allStandardProbes.add(standardProbe);
        }
        CgProbe currentValidProbe = standardProbe;
        while (currentScan >= lowerIndex) {
            probe = LipidomicsAnalyzer.calculateOneArea(chrom, currentScan, mode, charge);
            if (mode == LipidomicsDefines.GreedySteepnessReductionMethod) {
                probe.greedyProbe = true;
            }
            if (probe.AreaStatus == CgAreaStatus.OK) {
                this.checkDuplicate(allStandardProbes, probe);
                if (currentValidProbe == null || probe.AreaStatus == CgAreaStatus.OK) {
                    currentValidProbe = probe;
                }
                allStandardProbes.add(probe);
                int lowerValleyIndex = LipidomicsAnalyzer.findIndexByTime(probe.LowerValley, chrom);
                if (lowerValleyIndex < currentScan) {
                    currentScan = lowerValleyIndex;
                }
            }
            --currentScan;
        }
        for (currentScan = LipidomicsAnalyzer.findIndexByTime(standardProbe.UpperValley, chrom); currentScan <= upperIndex; ++currentScan) {
            probe = LipidomicsAnalyzer.calculateOneArea(chrom, currentScan, mode, charge);
            if (mode == LipidomicsDefines.GreedySteepnessReductionMethod) {
                probe.greedyProbe = true;
            }
            if (probe.AreaStatus != CgAreaStatus.OK) continue;
            this.checkDuplicate(allStandardProbes, probe);
            if (currentValidProbe == null || probe.AreaStatus == CgAreaStatus.OK) {
                currentValidProbe = probe;
            }
            allStandardProbes.add(probe);
            int upperValleyIndex = LipidomicsAnalyzer.findIndexByTime(probe.UpperValley, chrom);
            if (upperValleyIndex <= currentScan) continue;
            currentScan = upperValleyIndex;
        }
        Vector<CgProbe> okStandardProbes = new Vector<CgProbe>();
        for (CgProbe aProbe : allStandardProbes) {
            if (aProbe.AreaStatus != CgAreaStatus.OK) continue;
            okStandardProbes.add(aProbe);
        }
        return okStandardProbes;
    }

    private int getSortPosition(Vector<CgProbe> allProbes, CgProbe okStandardProbe) {
        int count = 0;
        int j = 0;
        while (j != allProbes.size() && !(okStandardProbe.LowerValley < allProbes.get((int)j).LowerValley)) {
            count = j++;
        }
        return count;
    }

    private boolean isGreedyFromOtherIsotope(CgProbe greedyProbe, CgProbe standardProbe, LipidomicsChromatogram previousIsoChrom, double multiplicationFactor, Vector<CgProbe> allowedPrevIsos) {
        int isPossibleIsotope;
        boolean isFromOtherIso = true;
        float prevDistanceGreedy = greedyProbe.Peak - greedyProbe.LowerValley;
        float postDistanceGreedy = greedyProbe.UpperValley - greedyProbe.Peak;
        float prevDistanceStandard = standardProbe.Peak - standardProbe.LowerValley;
        float postDistanceStandard = standardProbe.UpperValley - standardProbe.Peak;
        boolean checkPrevIsoGreedy = false;
        if ((double)prevDistanceStandard > 1.1 * (double)prevDistanceGreedy) {
            checkPrevIsoGreedy = true;
        }
        if ((double)postDistanceStandard > 1.1 * (double)postDistanceGreedy) {
            checkPrevIsoGreedy = true;
        }
        if (checkPrevIsoGreedy && (isPossibleIsotope = this.isFromOtherIsotope(greedyProbe, LipidomicsDefines.GreedySteepnessReductionMethod, previousIsoChrom, multiplicationFactor, allowedPrevIsos)) != ISOTOPE_PRESENT) {
            isFromOtherIso = false;
        }
        return isFromOtherIso;
    }

    private boolean isAllowedPrevIso(CgProbe otherIsotopeProbeInterest, Vector<CgProbe> allowedPrevIsos) {
        boolean isAnAllowedIsotope = false;
        for (CgProbe allowedIso : allowedPrevIsos) {
            if (!(allowedIso.LowerValley - 1.0f < otherIsotopeProbeInterest.LowerValley && otherIsotopeProbeInterest.UpperValley < allowedIso.UpperValley + 1.0f) && (!allowedIso.greedyProbe || !allowedIso.isCoveredByThisProbe(otherIsotopeProbeInterest))) continue;
            isAnAllowedIsotope = true;
        }
        return isAnAllowedIsotope;
    }

    private int isFromOtherIsotope(CgProbe aProbe, int mode, LipidomicsChromatogram previousIsoChrom, double multiplicationFactor, Vector<CgProbe> allowedPrevIsos) {
        boolean isAnAllowedIsotope;
        CgProbe otherIsotopeProbeInterest;
        int hasIsotope = NO_ISOTOPE_PRESENT;
        int scan = LipidomicsAnalyzer.findIndexByTime(aProbe.Peak, previousIsoChrom);
        if (mode == LipidomicsDefines.StandardValleyMethod || mode == LipidomicsDefines.GreedySteepnessReductionMethod) {
            otherIsotopeProbeInterest = LipidomicsAnalyzer.calculateOneArea(previousIsoChrom, scan, LipidomicsDefines.StandardValleyMethod);
        } else {
            CgProbe otherIsotopeProbe = LipidomicsAnalyzer.calculateOneArea(previousIsoChrom, scan, LipidomicsDefines.EnhancedValleyMethod);
            CgProbe otherIsotopeProbe2 = LipidomicsAnalyzer.calculateOneArea(previousIsoChrom, scan, LipidomicsDefines.StandardValleyMethod);
            otherIsotopeProbeInterest = otherIsotopeProbe.Area > 100.0f * otherIsotopeProbe2.Area ? otherIsotopeProbe2 : otherIsotopeProbe;
        }
        int possibleIsotopeValue = NO_ISOTOPE_PRESENT;
        if ((double)otherIsotopeProbeInterest.Area > (double)aProbe.Area * multiplicationFactor) {
            possibleIsotopeValue = ISOTOPE_PRESENT;
        } else if (otherIsotopeProbeInterest.Area > aProbe.Area / 3.0f) {
            possibleIsotopeValue = POSSIBLE_ISOTOPE_OVERLAP;
        }
        if (possibleIsotopeValue != NO_ISOTOPE_PRESENT && (!(otherIsotopeProbeInterest.Peak < aProbe.LowerValley) && !(otherIsotopeProbeInterest.Peak > aProbe.UpperValley) || mode == LipidomicsDefines.GreedySteepnessReductionMethod && aProbe.isCoveredByThisProbe(otherIsotopeProbeInterest)) && (mode != LipidomicsDefines.GreedySteepnessReductionMethod || aProbe.greedyFragment || !this.isInOuterThird(otherIsotopeProbeInterest, aProbe)) && !(isAnAllowedIsotope = this.isAllowedPrevIso(otherIsotopeProbeInterest, allowedPrevIsos))) {
            hasIsotope = possibleIsotopeValue;
        }
        return hasIsotope;
    }

    private CgProbe checkCloserToExpected(CgProbe originalProbe, CgProbe isotopeProbe, CgProbe isotopeProbeStandard) {
        float totalDistanceStand;
        float totalDistanceEnh = this.positiveDifference(originalProbe.LowerValley, isotopeProbe.LowerValley) + this.positiveDifference(originalProbe.UpperValley, isotopeProbe.UpperValley);
        float ratio = totalDistanceEnh / (totalDistanceStand = this.positiveDifference(originalProbe.LowerValley, isotopeProbeStandard.LowerValley) + this.positiveDifference(originalProbe.UpperValley, isotopeProbeStandard.UpperValley));
        if ((double)ratio < 0.9090909090909091 || 1.1 < (double)ratio) {
            if (totalDistanceEnh < totalDistanceStand) {
                return isotopeProbe;
            }
            return isotopeProbeStandard;
        }
        return isotopeProbe;
    }

    private CgProbe checkCloserToExpected(CgProbe originalProbe, CgProbe isotopeProbe, CgProbe isotopeProbeStandard, CgProbe greedyProbe) {
        CgProbe cgProbe1 = this.checkCloserToExpected(originalProbe, isotopeProbe, isotopeProbeStandard);
        CgProbe cgProbe2 = this.checkCloserToExpected(originalProbe, isotopeProbeStandard, greedyProbe);
        return this.checkCloserToExpected(originalProbe, cgProbe1, cgProbe2);
    }

    private float positiveDifference(float nr1, float nr2) {
        float distance = nr1 - nr2;
        if (distance > 0.0f) {
            return distance;
        }
        return -1.0f * distance;
    }

    private Vector<CgProbe> getAllowedPrevIsos(Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> isoAreasOfOneProbe, int isotope, boolean[] isOfInterest) {
        Vector<CgProbe> allowedPrevIsos = new Vector<CgProbe>();
        for (int i = 0; i != isOfInterest.length; ++i) {
            Hashtable<Integer, Vector<CgProbe>> areaIsoHashOfOneProbe;
            if (!isOfInterest[i] || !(areaIsoHashOfOneProbe = isoAreasOfOneProbe.get(i)).containsKey(isotope)) continue;
            allowedPrevIsos.addAll((Collection<CgProbe>)areaIsoHashOfOneProbe.get(isotope));
        }
        return allowedPrevIsos;
    }

    private float checkTimeSpace(CgProbe highestProbe, CgProbe aProbe) {
        float timeSpace = 0.0f;
        if (!((double)aProbe.Peak - 0.1 < (double)highestProbe.Peak) || !((double)highestProbe.Peak < (double)aProbe.Peak + 0.1)) {
            timeSpace = aProbe.Peak > highestProbe.Peak ? aProbe.LowerValley - highestProbe.UpperValley : highestProbe.LowerValley - aProbe.UpperValley;
        }
        return timeSpace;
    }

    private boolean isInOuterThird(CgProbe otherIsotopeProbeInterest, CgProbe aProbe) {
        boolean isInOutherThird = false;
        float peakDistance = otherIsotopeProbeInterest.Peak - aProbe.Peak;
        if (peakDistance < 0.0f) {
            peakDistance *= -1.0f;
        }
        if (otherIsotopeProbeInterest.Peak < aProbe.Peak) {
            float outerRegionThreshold = aProbe.LowerValley + (aProbe.Peak - aProbe.LowerValley) / 3.0f;
            if (otherIsotopeProbeInterest.Peak <= outerRegionThreshold) {
                isInOutherThird = true;
            }
        } else {
            float outerRegionThreshold = aProbe.UpperValley - (aProbe.UpperValley - aProbe.Peak) / 3.0f;
            if (otherIsotopeProbeInterest.Peak >= outerRegionThreshold) {
                isInOutherThird = true;
            }
        }
        return isInOutherThird;
    }

    public Probe3D detectPeakThreeD(LipidomicsChromatogram coarseChrom, int mainScan, boolean respectIntCutoff, int charge, int msLevel) throws CgException, QuantificationException {
        Probe3D probe3D = null;
        if (!respectIntCutoff || coarseChrom.Value[mainScan][1] > this.highestIntensity_ * this.generalBasePeakCutoff_ && coarseChrom.Value[mainScan][2] > this.lowerIntensityThreshold_) {
            CgProbe coarseProbe = LipidomicsAnalyzer.calculateOneArea(coarseChrom, mainScan, LipidomicsDefines.GreedySteepnessImproved, charge);
            this.checkIfSmoothingDeviatedPeakPosition(coarseChrom, coarseProbe);
            if (coarseProbe.AreaStatus == CgAreaStatus.OK) {
                CgProbe rightProfileProbe = this.getProfileProbe(coarseProbe, coarseChrom.Mz, charge, msLevel);
                if (rightProfileProbe.AreaStatus == CgAreaStatus.OK) {
                    int count;
                    Vector theProbes = this.getSmallAndBroadProbe(rightProfileProbe, mainScan, coarseChrom, charge, msLevel);
                    CgProbe finalProbe = (CgProbe)theProbes.get(1);
                    for (count = 0; (coarseProbe.Peak < finalProbe.LowerValley + this.finalProbeTimeCompTolerance_ || finalProbe.UpperValley - this.finalProbeTimeCompTolerance_ < coarseProbe.Peak || finalProbe.Mz < rightProfileProbe.LowerValley + this.finalProbeMzCompTolerance_ || finalProbe.Mz > rightProfileProbe.UpperValley - this.finalProbeMzCompTolerance_) && count < 5; ++count) {
                        coarseProbe = finalProbe;
                        rightProfileProbe = this.getProfileProbe(finalProbe, coarseChrom.Mz, charge, msLevel);
                        theProbes = this.getSmallAndBroadProbe(rightProfileProbe, mainScan, (LipidomicsChromatogram)theProbes.get(2), charge, msLevel);
                        finalProbe = (CgProbe)theProbes.get(1);
                    }
                    if (count == 5 && (coarseProbe.Peak < finalProbe.LowerValley + this.finalProbeTimeCompTolerance_ || finalProbe.UpperValley - this.finalProbeTimeCompTolerance_ < coarseProbe.Peak || finalProbe.Mz < rightProfileProbe.LowerValley + this.finalProbeMzCompTolerance_ || finalProbe.Mz > rightProfileProbe.UpperValley - this.finalProbeMzCompTolerance_)) {
                        coarseProbe.AreaStatus = CgAreaStatus.TooSmall;
                        probe3D = new Probe3D(coarseProbe);
                        return probe3D;
                    }
                    if (rightProfileProbe.LowerValley < finalProbe.Mz - this.profileMaxRange_) {
                        rightProfileProbe.LowerValley = finalProbe.Mz - this.profileMaxRange_;
                    }
                    if (rightProfileProbe.UpperValley > finalProbe.Mz + this.profileMaxRange_) {
                        rightProfileProbe.UpperValley = finalProbe.Mz + this.profileMaxRange_;
                    }
                    if (rightProfileProbe.AreaStatus == CgAreaStatus.OK && finalProbe.AreaStatus == CgAreaStatus.OK) {
                        float[] ellipse = Calculator.calculateEllipseFrom4Points(coarseProbe.Peak, rightProfileProbe.LowerValley, coarseProbe.Peak, rightProfileProbe.UpperValley, finalProbe.LowerValley, finalProbe.Mz, finalProbe.UpperValley, finalProbe.Mz);
                        if (finalProbe.Peak < finalProbe.LowerValley + this.finalProbeTimeCompTolerance_ || finalProbe.UpperValley - this.finalProbeTimeCompTolerance_ < finalProbe.Peak) {
                            finalProbe.Peak = coarseProbe.Peak;
                        }
                        if (ellipse[3] > this.profileMaxRange_) {
                            ellipse[3] = this.profileMaxRange_;
                        }
                        probe3D = this.getOverlapPosition(finalProbe, rightProfileProbe, coarseProbe, ellipse);
                        LipidomicsChromatogram forQuant = new LipidomicsChromatogram(this.readJustIntensitiesOfInterest(probe3D, msLevel));
                        forQuant.Background = finalProbe.Background;
                        forQuant.getAreaRaw();
                        probe3D.Area = forQuant.Area;
                        if (probe3D.Area > this.highestArea_) {
                            this.highestArea_ = probe3D.Area;
                        }
                        if (forQuant.getHighestIntensity() > this.highestIntensity_) {
                            this.highestIntensity_ = forQuant.getHighestIntensity();
                        }
                    } else {
                        if (rightProfileProbe.AreaStatus != CgAreaStatus.OK) {
                            coarseProbe.AreaStatus = rightProfileProbe.AreaStatus;
                        }
                        if (finalProbe.AreaStatus != CgAreaStatus.OK) {
                            coarseProbe.AreaStatus = finalProbe.AreaStatus;
                        }
                        probe3D = new Probe3D(coarseProbe);
                    }
                } else {
                    coarseProbe.AreaStatus = rightProfileProbe.AreaStatus;
                    probe3D = new Probe3D(coarseProbe);
                }
            } else {
                coarseProbe.AreaStatus = CgAreaStatus.TooSmall;
                probe3D = new Probe3D(coarseProbe);
            }
        } else {
            probe3D = new Probe3D(new CgProbe(0, charge));
            probe3D.AreaStatus = CgAreaStatus.TooSmall;
        }
        return probe3D;
    }

    protected Probe3D getOverlapPosition(CgProbe finalProbe, CgProbe profileProbe, CgProbe oldChromProbe, float[] ellipse) {
        boolean before = false;
        boolean later = false;
        boolean lessMz = false;
        boolean higherMz = false;
        if (profileProbe.hasLoOverlap()) {
            lessMz = true;
        }
        if (profileProbe.hasUpOverlap()) {
            higherMz = true;
        }
        if (oldChromProbe.hasLoOverlap() || finalProbe.hasLoOverlap()) {
            before = true;
        }
        if ((oldChromProbe.Peak - oldChromProbe.LowerValley) / (finalProbe.Peak - finalProbe.LowerValley) > this.overlapDistanceDeviationFactor_) {
            before = true;
        }
        if (oldChromProbe.hasUpOverlap() || finalProbe.hasUpOverlap()) {
            later = true;
        }
        if ((oldChromProbe.UpperValley - oldChromProbe.Peak) / (finalProbe.UpperValley - finalProbe.Peak) > this.overlapDistanceDeviationFactor_) {
            later = true;
        }
        Probe3D probe3D = new Probe3D(finalProbe, profileProbe, lessMz, higherMz, before, later, ellipse);
        return probe3D;
    }

    private CgProbe getProfileProbe(CgProbe aProbe, float originalMz, int charge, int msLevel) throws CgException {
        int probePositionInHash = this.getProbePositionInHash(aProbe);
        if (this.useSameCgHashFor3D_ && probePositionInHash != -1) {
            return this.fromProbeToProfile_.get(probePositionInHash);
        }
        LipidomicsChromatogram profile = this.readASingleProfile(aProbe, msLevel, true);
        profile.GetMaximumAndAverage();
        profile.greedySteepnessChange1_ = this.profileSteepnessChange1_;
        profile.greedyIntensityCutoff1_ = this.profileIntensityCutoff1_;
        profile.greedySteepnessChange2_ = this.profileSteepnessChange2_;
        profile.greedyIntensityCutoff2_ = this.profileIntensityCutoff2_;
        profile.intensityCutoff_ = this.profileGeneralIntCutoff_;
        int scanStart = profile.Value.length / 2;
        float dist = Math.abs(profile.Value[scanStart][0] - originalMz);
        if (scanStart - 1 > -1 && Math.abs(profile.Value[scanStart - 1][0] - originalMz) < dist) {
            while (scanStart - 1 > -1 && Math.abs(profile.Value[scanStart - 1][0] - originalMz) < dist) {
                dist = Math.abs(profile.Value[--scanStart][0] - originalMz);
            }
        } else if (scanStart + 1 < profile.Value.length && Math.abs(profile.Value[scanStart + 1][0] - originalMz) < dist) {
            while (scanStart + 1 < profile.Value.length && Math.abs(profile.Value[scanStart + 1][0] - originalMz) < dist) {
                dist = Math.abs(profile.Value[++scanStart][0] - originalMz);
            }
        }
        profile.findPeakInNeighbourhood(scanStart, 1, LipidomicsDefines.GreedySteepnessImproved, 50);
        CgProbe rightProfileProbe = new CgProbe(0, charge);
        rightProfileProbe = LipidomicsAnalyzer.copyResults(rightProfileProbe, profile, true);
        rightProfileProbe.Peak += this.profileSmoothingCorrection_;
        if (rightProfileProbe.Peak < originalMz - this.profilePeakAcceptanceRange_ || originalMz + this.profilePeakAcceptanceRange_ < rightProfileProbe.Peak) {
            rightProfileProbe.AreaStatus = CgAreaStatus.TooSmall;
        } else if (rightProfileProbe.UpperValley - rightProfileProbe.LowerValley < this.profileMzMinRange_) {
            rightProfileProbe.AreaStatus = CgAreaStatus.MzRangeTooShort;
        }
        if (this.useSameCgHashFor3D_) {
            this.fromProbeToProfile_.put(this.chromProbes_.size(), rightProfileProbe);
            this.chromProbes_.add(aProbe);
        }
        return rightProfileProbe;
    }

    protected Vector<CgChromatogram> readProfiles(Vector<CgProbe> probes, float mzTolerance, float timeTolerance, float maxTimeDeviation, float mzSmoothRange, int smoothRepeats, float meanSmoothRange, int meanSmoothRepeats, int msLevel, boolean smooth) throws CgException {
        LipidomicsChromReader lReader = (LipidomicsChromReader)this.reader_;
        Vector<CgChromatogram> chroms = lReader.readProfiles(probes, mzTolerance, timeTolerance, maxTimeDeviation, 0.0f, 0, msLevel, this.sav_gol_jni_);
        if (!smooth) {
            return chroms;
        }
        for (CgChromatogram chrom : chroms) {
            LipidomicsChromatogram lChrom = new LipidomicsChromatogram(chrom);
            boolean copyRawData = true;
            if (meanSmoothRange > 0.0f) {
                lChrom.smoothMean(meanSmoothRange, meanSmoothRepeats, copyRawData);
                copyRawData = false;
            }
            if (this.useCuda_) {
                lChrom.Smooth(mzSmoothRange, smoothRepeats, copyRawData, this.sav_gol_jni_);
                continue;
            }
            lChrom.Smooth(mzSmoothRange, smoothRepeats, copyRawData);
        }
        return chroms;
    }

    private Vector getSmallAndBroadProbe(CgProbe rightProfileProbe, int mainScan, LipidomicsChromatogram coarseChrom, int charge, int msLevel) throws CgException, QuantificationException {
        LipidomicsChromatogram smallChroma = null;
        LipidomicsChromatogram broadChroma = null;
        int profilePositionInHash = this.getProfilePositionInHash(rightProfileProbe);
        if (this.useSameCgHashFor3D_ && profilePositionInHash != -1) {
            smallChroma = this.fromProfileToSmallChrom_.get(profilePositionInHash);
            broadChroma = this.fromProfileToBroadChrom_.get(profilePositionInHash);
        } else {
            float smallChromSmoothRange = this.smallChromSmoothRange_ * 60.0f;
            float broadChromSmoothRange = this.broadChromSmoothRange_ * 60.0f;
            smallChroma = new LipidomicsChromatogram(this.readAChromatogram(rightProfileProbe.Peak, this.smallChromMzRange_, this.smallChromMzRange_, msLevel, this.chromSmoothRange_, this.smallChromSmoothRepeats_, this.chromSmoothRange_, this.smallChromMeanSmoothRepeats_, rightProfileProbe.Mz - smallChromSmoothRange, rightProfileProbe.Mz + smallChromSmoothRange));
            smallChroma.GetMaximumAndAverage();
            smallChroma.intensityCutoff_ = this.smallChromIntensityCutoff_;
            broadChroma = new LipidomicsChromatogram(this.readAChromatogram(rightProfileProbe.Peak, rightProfileProbe.Peak - rightProfileProbe.LowerValley, rightProfileProbe.UpperValley - rightProfileProbe.Peak, msLevel, this.chromSmoothRange_, this.broadChromSmoothRepeats_, this.chromSmoothRange_, this.broadChromMeanSmoothRepeats_, rightProfileProbe.Mz - broadChromSmoothRange, rightProfileProbe.Mz + broadChromSmoothRange));
            broadChroma.GetMaximumAndAverage();
            broadChroma.intensityCutoff_ = this.broadChromIntensityCutoff_;
            if (this.useSameCgHashFor3D_) {
                this.fromProfileToSmallChrom_.put(this.profileProbes_.size(), smallChroma);
                this.fromProfileToBroadChrom_.put(this.profileProbes_.size(), broadChroma);
                this.profileProbes_.add(rightProfileProbe);
            }
        }
        smallChroma.FindPeak(mainScan, 1, LipidomicsDefines.GreedySteepnessImproved);
        smallChroma.GetBackground(LipidomicsConstants.getBackgroundScanRange());
        smallChroma.GetAreaAndTime();
        if (!smallChroma.Good) {
            throw new QuantificationException("The exact chromatogram (small) does not show satisfying intensities");
        }
        CgProbe smallProbe = new CgProbe(0, charge);
        smallProbe = LipidomicsAnalyzer.copyResults(smallProbe, smallChroma, false);
        broadChroma.FindPeak(mainScan, 1, LipidomicsDefines.GreedySteepnessPointImproved);
        broadChroma.Peak = smallChroma.Peak;
        boolean takeLoVallyOfSmall = true;
        if (coarseChrom.LoValley > smallChroma.LoValley) {
            float distanceSmall = smallChroma.Peak - smallChroma.LoValley;
            float distanceBig = coarseChrom.Peak - coarseChrom.LoValley;
            if (coarseChrom.getLoSteepnessPoint() != -1 && (double)distanceSmall > 1.1 * (double)distanceBig || (double)distanceSmall > 1.5 * (double)distanceBig) {
                takeLoVallyOfSmall = false;
            }
        }
        broadChroma.LoValley = smallChroma.LoValley;
        boolean takeUpVallyOfSmall = true;
        if (coarseChrom.UpValley < smallChroma.UpValley) {
            float distanceSmall = smallChroma.UpValley - smallChroma.Peak;
            float distanceBig = coarseChrom.UpValley - coarseChrom.Peak;
            if (coarseChrom.getUpSteepnessPoint() != -1 && (double)distanceSmall > 1.1 * (double)distanceBig || (double)distanceSmall > 1.5 * (double)distanceBig) {
                takeUpVallyOfSmall = false;
            }
        }
        broadChroma.UpValley = smallChroma.UpValley;
        broadChroma.GetBackground(LipidomicsConstants.getBackgroundScanRange());
        broadChroma.GetAreaAndTime();
        if (!broadChroma.Good) {
            throw new QuantificationException("The exact chromatogram (broad)  does not show satisfying intensities");
        }
        CgProbe finalProbe = new CgProbe(0, charge);
        finalProbe = LipidomicsAnalyzer.copyResults(finalProbe, broadChroma, false);
        if (!takeLoVallyOfSmall || !takeUpVallyOfSmall) {
            broadChroma.greedySteepnessChange1_ = this.broadChromSteepnessChangeNoSmall_;
            int refinedPosition = -1;
            if (!takeLoVallyOfSmall) {
                broadChroma.intensityCutoff_ = this.broadChromIntensityCutoffNoSmall_;
                broadChroma.FindPeak(smallChroma.Peak, 1, LipidomicsDefines.GreedySteepnessImproved);
                if (broadChroma.Value[broadChroma.LoValley][0] > finalProbe.LowerValley) {
                    finalProbe.LowerValley = broadChroma.Value[broadChroma.LoValley][0];
                    finalProbe.setLoOverlap(true);
                    if (finalProbe.Peak < finalProbe.LowerValley) {
                        finalProbe.Peak = broadChroma.Value[broadChroma.Peak][0];
                        refinedPosition = broadChroma.Peak;
                    }
                }
                broadChroma.FindPeak(mainScan, 1, LipidomicsDefines.GreedySteepnessImproved);
                if (broadChroma.Value[broadChroma.LoValley][0] > finalProbe.LowerValley) {
                    finalProbe.LowerValley = broadChroma.Value[broadChroma.LoValley][0];
                    finalProbe.setLoOverlap(true);
                    if (finalProbe.Peak < finalProbe.LowerValley) {
                        finalProbe.Peak = broadChroma.Value[broadChroma.Peak][0];
                        refinedPosition = broadChroma.Peak;
                    }
                }
            }
            if (!takeUpVallyOfSmall) {
                broadChroma.intensityCutoff_ = this.broadChromIntensityCutoffNoSmall_;
                broadChroma.FindPeak(smallChroma.Peak, 1, LipidomicsDefines.GreedySteepnessImproved);
                if (broadChroma.Value[broadChroma.UpValley][0] < finalProbe.UpperValley) {
                    finalProbe.UpperValley = broadChroma.Value[broadChroma.UpValley][0];
                    finalProbe.setUpOverlap(true);
                    if (finalProbe.Peak > finalProbe.UpperValley) {
                        finalProbe.Peak = broadChroma.Value[broadChroma.Peak][0];
                        refinedPosition = broadChroma.Peak;
                    }
                }
                broadChroma.FindPeak(mainScan, 1, LipidomicsDefines.GreedySteepnessImproved);
                if (broadChroma.Value[broadChroma.UpValley][0] < finalProbe.UpperValley) {
                    finalProbe.UpperValley = broadChroma.Value[broadChroma.UpValley][0];
                    finalProbe.setUpOverlap(true);
                    if (finalProbe.Peak > finalProbe.UpperValley) {
                        finalProbe.Peak = broadChroma.Value[broadChroma.Peak][0];
                        refinedPosition = broadChroma.Peak;
                    }
                }
            }
            broadChroma.Peak = refinedPosition == -1 ? smallChroma.Peak : refinedPosition;
        }
        Vector<Object> theProbes = new Vector<Object>();
        theProbes.add(smallProbe);
        theProbes.add(finalProbe);
        theProbes.add(broadChroma);
        return theProbes;
    }

    protected Probe3D calculateAreaWithoutPrevIso(LipidomicsChromatogram chrom, LipidomicsChromatogram previousIsoChrom, int mainScan, double multiplicationFactor, boolean respectIntCutoff, int charge, int msLevel) throws CgException {
        try {
            Probe3D probe = this.detectPeakThreeD(chrom, mainScan, respectIntCutoff, charge, msLevel);
            if (probe.AreaStatus == CgAreaStatus.OK) {
                int upperValleyIndex;
                int lowerValleyIndex;
                boolean lookLeftSide = true;
                if (probe.isOverlapBefore()) {
                    lookLeftSide = false;
                }
                boolean lookRightSide = true;
                if (probe.isOverlapLater()) {
                    lookRightSide = false;
                }
                Vector<CgProbe> isoProbes = new Vector<CgProbe>();
                CgProbe isoProbe = null;
                isoProbe = LipidomicsAnalyzer.calculateOneArea(previousIsoChrom, mainScan, LipidomicsDefines.StandardValleyMethod, charge);
                CgProbe currentValidProbe = null;
                int currentScan = mainScan;
                if (isoProbe.AreaStatus == CgAreaStatus.OK) {
                    isoProbes.add(isoProbe);
                }
                currentScan = mainScan - 1;
                float valueToFindIndex = probe.LowerValley;
                if (lookLeftSide) {
                    valueToFindIndex = probe.LowerValley - 5.0f;
                }
                int lowerScan = LipidomicsAnalyzer.findIndexByTime(valueToFindIndex, previousIsoChrom);
                if (currentValidProbe != null) {
                    lowerValleyIndex = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.LowerValley, previousIsoChrom);
                    if (lowerValleyIndex < currentScan) {
                        currentScan = lowerValleyIndex;
                    }
                    --currentScan;
                }
                while (currentScan > lowerScan) {
                    isoProbe = LipidomicsAnalyzer.calculateOneArea(previousIsoChrom, currentScan, LipidomicsDefines.StandardValleyMethod, charge);
                    if (isoProbe.AreaStatus == CgAreaStatus.OK) {
                        isoProbes.add(isoProbe);
                        currentValidProbe = isoProbe;
                    }
                    if (currentValidProbe != null && (lowerValleyIndex = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.LowerValley, previousIsoChrom)) < currentScan) {
                        currentScan = lowerValleyIndex;
                    }
                    currentScan -= this.scanStep_;
                }
                currentScan = mainScan + 1;
                valueToFindIndex = probe.UpperValley;
                if (lookRightSide) {
                    valueToFindIndex = probe.UpperValley + 5.0f;
                }
                int upperScan = LipidomicsAnalyzer.findIndexByTime(valueToFindIndex, previousIsoChrom);
                if (currentValidProbe != null) {
                    upperValleyIndex = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.UpperValley, previousIsoChrom);
                    if (upperValleyIndex > currentScan) {
                        currentScan = upperValleyIndex;
                    }
                    ++currentScan;
                }
                while (currentScan < upperScan) {
                    isoProbe = LipidomicsAnalyzer.calculateOneArea(previousIsoChrom, currentScan, LipidomicsDefines.StandardValleyMethod, charge);
                    if (isoProbe.AreaStatus == CgAreaStatus.OK) {
                        isoProbes.add(isoProbe);
                        currentValidProbe = isoProbe;
                    }
                    if (currentValidProbe != null && (upperValleyIndex = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.UpperValley, previousIsoChrom)) > currentScan) {
                        currentScan = upperValleyIndex;
                    }
                    currentScan += this.scanStep_;
                }
                boolean isFromOtherIso = false;
                for (CgProbe anIsoProbe : isoProbes) {
                    if (!((double)anIsoProbe.Area > (double)probe.Area * multiplicationFactor) || !(anIsoProbe.LowerValley < probe.Peak && probe.Peak < anIsoProbe.UpperValley) && (!(probe.LowerValley < anIsoProbe.Peak) || !(anIsoProbe.Peak < probe.UpperValley)) || !(previousIsoChrom.Value[LipidomicsAnalyzer.findIndexByTime(probe.Peak, previousIsoChrom)][2] > previousIsoChrom.Value[LipidomicsAnalyzer.findIndexByTime(anIsoProbe.Peak, previousIsoChrom)][2] * this.overlapPossibleIntensityThreshold_)) continue;
                    this.prevIsoProbes_.put(Float.valueOf(probe.Area), anIsoProbe);
                    if (previousIsoChrom.Value[LipidomicsAnalyzer.findIndexByTime(probe.Peak, previousIsoChrom)][2] > previousIsoChrom.Value[LipidomicsAnalyzer.findIndexByTime(anIsoProbe.Peak, previousIsoChrom)][2] * this.overlapSureIntensityThreshold_) {
                        isFromOtherIso = true;
                        break;
                    }
                    if (anIsoProbe.Peak < probe.Peak) {
                        if (probe.isOverlapBefore()) {
                            float lowerThreshold1 = probe.Peak - (probe.Peak - probe.LowerValley) / this.overlapPeakDistanceDivisor_;
                            float lowerThreshold2 = probe.Peak - (probe.UpperValley - probe.LowerValley) / this.overlapFullDistanceDivisor_;
                            if (!(anIsoProbe.Peak > lowerThreshold1) && !(anIsoProbe.Peak > lowerThreshold2)) continue;
                            isFromOtherIso = true;
                            break;
                        }
                        isFromOtherIso = true;
                        break;
                    }
                    if (probe.isOverlapLater()) {
                        float upperThreshold1 = probe.Peak + (probe.UpperValley - probe.Peak) / this.overlapPeakDistanceDivisor_;
                        float upperThreshold2 = probe.Peak + (probe.UpperValley - probe.LowerValley) / this.overlapFullDistanceDivisor_;
                        if (!(anIsoProbe.Peak < upperThreshold1) && !(anIsoProbe.Peak < upperThreshold2)) continue;
                        isFromOtherIso = true;
                        break;
                    }
                    isFromOtherIso = true;
                    break;
                }
                if (isFromOtherIso) {
                    probe.AreaStatus = CgAreaStatus.OtherIso;
                }
            }
            return probe;
        }
        catch (QuantificationException qex) {
            return null;
        }
    }

    private int getProbePositionInHash(CgProbe chromProbe) {
        for (int i = 0; i != this.chromProbes_.size(); ++i) {
            CgProbe probe = this.chromProbes_.get(i);
            if (!this.sameCgProbe(probe, chromProbe)) continue;
            return i;
        }
        return -1;
    }

    private int getProfilePositionInHash(CgProbe profileProbe) {
        for (int i = 0; i != this.profileProbes_.size(); ++i) {
            CgProbe probe = this.profileProbes_.get(i);
            if (!this.sameProfileProbe(probe, profileProbe)) continue;
            return i;
        }
        return -1;
    }

    private boolean sameCgProbe(CgProbe probe1, CgProbe probe2) {
        boolean ok = false;
        if ((double)probe1.Area >= (double)probe2.Area - 0.02 && (double)probe1.Area <= (double)probe2.Area + 0.02 && (double)probe1.AreaError >= (double)probe2.AreaError - 0.02 && (double)probe1.AreaError <= (double)probe2.AreaError + 0.02 && (double)probe1.Background >= (double)probe2.Background - 0.02 && (double)probe1.Background <= (double)probe2.Background + 0.02 && probe1.Charge == probe2.Charge && (double)probe1.LowerMzBand >= (double)probe2.LowerMzBand - 0.001 && (double)probe1.LowerMzBand <= (double)probe2.LowerMzBand + 0.001 && (double)probe1.LowerValley >= (double)probe2.LowerValley - 0.02 && (double)probe1.LowerValley <= (double)probe2.LowerValley + 0.02 && (double)probe1.Mz >= (double)probe2.Mz - 0.001 && (double)probe1.Mz <= (double)probe2.Mz + 0.001 && (double)probe1.Peak >= (double)probe2.Peak - 0.02 && (double)probe1.Peak <= (double)probe2.Peak + 0.02 && (double)probe1.UpperMzBand >= (double)probe2.UpperMzBand - 0.001 && (double)probe1.UpperMzBand <= (double)probe2.UpperMzBand + 0.001 && (double)probe1.UpperValley >= (double)probe2.UpperValley - 0.02 && (double)probe1.UpperValley <= (double)probe2.UpperValley + 0.02) {
            ok = true;
        }
        return ok;
    }

    private boolean sameProfileProbe(CgProbe probe1, CgProbe probe2) {
        boolean ok = false;
        if (probe1.Charge == probe2.Charge && (double)probe1.LowerMzBand >= (double)probe2.LowerMzBand - 0.02 && (double)probe1.LowerMzBand <= (double)probe2.LowerMzBand + 0.02 && (double)probe1.LowerValley >= (double)probe2.LowerValley - 0.002 && (double)probe1.LowerValley <= (double)probe2.LowerValley + 0.001 && (double)probe1.Mz >= (double)probe2.Mz - 0.001 && (double)probe1.Mz <= (double)probe2.Mz + 0.001 && (double)probe1.Peak >= (double)probe2.Peak - 0.02 && (double)probe1.Peak <= (double)probe2.Peak + 0.02 && (double)probe1.UpperMzBand >= (double)probe2.UpperMzBand - 0.02 && (double)probe1.UpperMzBand <= (double)probe2.UpperMzBand + 0.02 && (double)probe1.UpperValley >= (double)probe2.UpperValley - 0.001 && (double)probe1.UpperValley <= (double)probe2.UpperValley + 0.001) {
            ok = true;
        }
        return ok;
    }

    private Vector<CgProbe> uniteTwinPeaksClone(Vector probes, LipidomicsChromatogram chrom, int msLevel) throws CgException {
        Vector<Probe3D> clonedProbes = new Vector<Probe3D>();
        for (int i = 0; i != probes.size(); ++i) {
            clonedProbes.add(new Probe3D((Probe3D)probes.get(i)));
        }
        return this.uniteTwinPeaks(clonedProbes, chrom, msLevel);
    }

    private Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> uniteClosePeaks(Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> isotopicAreas, Hashtable<Integer, LipidomicsChromatogram> chromHash, int msLevel) throws CgException {
        Hashtable<Integer, CgProbe> probes = new Hashtable<Integer, CgProbe>();
        for (Integer key : isotopicAreas.keySet()) {
            Vector<CgProbe> areasOfOnePeak = isotopicAreas.get(key).get(0);
            if (areasOfOnePeak.size() > 1) {
                throw new CgException("The new edition with separated RTs has problems at the method uniteClosePeaks! Please report this case the developers");
            }
            probes.put(key, areasOfOnePeak.get(0));
        }
        if (probes.size() > 0) {
            Hashtable<Integer, Integer> excludeList = new Hashtable<Integer, Integer>();
            Vector keys = new Vector(probes.keySet());
            for (int i = 0; i != keys.size(); ++i) {
                if (excludeList.containsKey(i)) continue;
                CgProbe probe1 = (CgProbe)probes.get(keys.get(i));
                for (int j = i + 1; j < keys.size(); ++j) {
                    CgProbe probe2;
                    if (excludeList.containsKey(j) || !(this.checkTimeSpace(probe1, probe2 = (CgProbe)probes.get(keys.get(j))) < (float)this.closePeakTimeTolerance_) || this.isDeepValleyBetweenUnionPeaks(chromHash.get(0), probe1, probe2)) continue;
                    probe1 = this.uniteTwoPeaks(probe1, probe2, chromHash.get(0), excludeList, msLevel, j, null);
                    if (!excludeList.containsKey(j)) continue;
                    Hashtable<Integer, Vector<CgProbe>> isos1 = isotopicAreas.get(keys.get(i));
                    Vector<CgProbe> united = new Vector<CgProbe>();
                    united.add(probe1);
                    isos1.put(0, united);
                    Hashtable<Integer, Vector<CgProbe>> isos2 = isotopicAreas.get(keys.get(j));
                    int highestIsoNr = isos1.size();
                    if (isos2.size() > highestIsoNr) {
                        highestIsoNr = isos2.size();
                    }
                    for (int k = 1; k < highestIsoNr; ++k) {
                        if (isos1.containsKey(k) && isos2.containsKey(k)) {
                            if (isos1.get(k).size() > 1) {
                                throw new CgException("The new edition with separated RTs has problems at the method uniteClosePeaks (higher isos)! Please report this case the developers");
                            }
                            if (isos2.get(k).size() > 1) {
                                throw new CgException("The new edition with separated RTs has problems at the method uniteClosePeaks (higher isos)! Please report this case the developers");
                            }
                            Vector<CgProbe> united2 = new Vector<CgProbe>();
                            united2.add(this.uniteTwoPeaks(isos1.get(k).get(0), isos2.get(k).get(0), chromHash.get(k), new Hashtable<Integer, Integer>(), msLevel, j, probe1));
                            isos1.put(k, united2);
                            continue;
                        }
                        if (isos1.containsKey(k)) {
                            isos1.put(k, isos1.get(k));
                            continue;
                        }
                        if (!isos2.containsKey(k)) continue;
                        isos1.put(k, isos2.get(k));
                    }
                    isotopicAreas.put((Integer)keys.get(i), isos1);
                    isotopicAreas.remove(keys.get(j));
                }
            }
        }
        return isotopicAreas;
    }

    private CgProbe uniteTwoPeaks(CgProbe probe1, CgProbe probe2, LipidomicsChromatogram chrom, Hashtable<Integer, Integer> excludeList, int msLevel, int element, CgProbe zeroIso) throws CgException {
        float[] ellipse;
        float oldLowerValley = probe1.LowerValley;
        float oldUpperValley = probe1.UpperValley;
        float oldPeak = probe1.Peak;
        float oldLowerMzBand = probe1.LowerMzBand;
        float oldUpperMzBand = probe1.UpperMzBand;
        boolean coversPeakTop = false;
        if (probe1.LowerValley < probe2.Peak && probe2.Peak < probe1.UpperValley) {
            coversPeakTop = true;
        }
        if (probe2.LowerValley < probe1.Peak && probe1.Peak < probe2.UpperValley) {
            coversPeakTop = true;
        }
        if (probe2.LowerValley < probe1.LowerValley) {
            probe1.LowerValley = probe2.LowerValley;
            probe1.setLowerValley10(probe2.getLowerValley10());
            probe1.setLowerValley50(probe2.getLowerValley50());
        }
        if (probe2.UpperValley > probe1.UpperValley) {
            probe1.UpperValley = probe2.UpperValley;
            probe1.setUpperValley10(probe2.getUpperValley10());
            probe1.setUpperValley50(probe2.getUpperValley50());
        }
        if (probe2.LowerMzBand > probe1.LowerMzBand) {
            probe1.LowerMzBand = probe2.LowerMzBand;
        }
        if (probe2.UpperMzBand > probe1.UpperMzBand) {
            probe1.UpperMzBand = probe2.UpperMzBand;
        }
        if (chrom.Value[LipidomicsAnalyzer.findIndexByTime(probe2.Peak, chrom)][2] > chrom.Value[LipidomicsAnalyzer.findIndexByTime(probe1.Peak, chrom)][2]) {
            probe1.Peak = probe2.Peak;
        }
        if ((ellipse = Calculator.calculateEllipseFrom4Points(probe1.Peak, probe1.Mz - probe1.LowerMzBand, probe1.Peak, probe1.Mz + probe1.UpperMzBand, probe1.LowerValley, probe1.Mz, probe1.UpperValley, probe1.Mz))[3] > this.profileMaxRange_) {
            ellipse[3] = this.profileMaxRange_;
        }
        CgProbe newProbe = probe1;
        if (probe1 instanceof Probe3D || probe2 instanceof Probe3D) {
            CgProbe profileProbe = this.getProfileProbeWithoutQualityCheck(probe1, probe1.Mz - probe1.LowerMzBand, probe1.Mz + probe1.UpperMzBand, msLevel);
            Probe3D probe3D = new Probe3D(probe1, profileProbe, false, false, false, false, ellipse);
            LipidomicsChromatogram forQuant = new LipidomicsChromatogram(this.readJustIntensitiesOfInterest(probe3D, msLevel));
            forQuant.Background = probe1.Background;
            forQuant.getAreaRaw();
            probe3D.Area = forQuant.Area;
            newProbe = probe3D;
        }
        if ((double)newProbe.Area * 1.01 > (double)probe1.Area && (double)newProbe.Area * 1.01 > (double)probe2.Area || coversPeakTop || zeroIso != null) {
            if (zeroIso != null && newProbe.Area > 2.0f * (probe1.Area + probe2.Area)) {
                float time2;
                float time1 = Math.abs(zeroIso.Peak - oldPeak);
                if (time1 > (time2 = Math.abs(zeroIso.Peak - probe2.Peak))) {
                    probe1 = probe2;
                } else {
                    probe1.LowerValley = oldLowerValley;
                    probe1.UpperValley = oldUpperValley;
                    probe1.Peak = oldPeak;
                    probe1.LowerMzBand = oldLowerMzBand;
                    probe1.UpperMzBand = oldUpperMzBand;
                }
            } else {
                probe1 = newProbe;
                excludeList.put(element, element);
            }
        } else {
            probe1.LowerValley = oldLowerValley;
            probe1.UpperValley = oldUpperValley;
            probe1.Peak = oldPeak;
            probe1.LowerMzBand = oldLowerMzBand;
            probe1.UpperMzBand = oldUpperMzBand;
        }
        return probe1;
    }

    private Vector<CgProbe> uniteTwinPeaks(Vector probes, LipidomicsChromatogram chrom, int msLevel) throws CgException {
        Vector<CgProbe> unitedProbes = new Vector<CgProbe>();
        if (probes.size() > 0) {
            Hashtable<Integer, Integer> excludeList = new Hashtable<Integer, Integer>();
            for (int i = 0; i != probes.size(); ++i) {
                if (excludeList.containsKey(i)) continue;
                Probe3D probe1 = (Probe3D)probes.get(i);
                for (int j = i + 1; j < probes.size(); ++j) {
                    float[] ellipse;
                    if (excludeList.containsKey(j)) continue;
                    Probe3D probe2 = (Probe3D)probes.get(j);
                    boolean isInInnterThird = LipidomicsAnalyzer.isOneProbeInOtherInnerThird(probe1, probe2, this.overlapPeakDistanceDivisor_, this.overlapFullDistanceDivisor_);
                    if (!((probe2.LowerValley <= probe1.UpperValley && probe1.UpperValley <= probe2.UpperValley || probe1.LowerValley <= probe2.UpperValley && probe2.UpperValley <= probe1.UpperValley) && (double)probe1.Mz - 0.002 <= (double)probe2.Mz && (double)probe2.Mz <= (double)probe1.Mz + 0.002) && (!isInInnterThird || !(probe1.getEllipseMzPosition() - probe1.getEllipseMzStretch() <= probe2.Mz) || !(probe2.Mz <= probe1.getEllipseMzPosition() + probe1.getEllipseMzStretch())) || !(!this.isDeepValleyBetweenPeaks(chrom, probe1, probe2) || isInInnterThird || (double)probe1.UpperValley > (double)probe2.Peak - (double)(probe2.Peak - probe2.LowerValley) * 0.66 && probe1.LowerValley < probe2.Peak) && (!((double)probe2.UpperValley > (double)probe1.Peak - (double)(probe1.Peak - probe1.LowerValley) * 0.66) || !(probe2.LowerValley < probe1.Peak))) continue;
                    if (probe2.LowerValley < probe1.LowerValley) {
                        probe1.LowerValley = probe2.LowerValley;
                    }
                    if (probe2.UpperValley > probe1.UpperValley) {
                        probe1.UpperValley = probe2.UpperValley;
                    }
                    Probe3D useForProfilePoints = probe1;
                    if (chrom.Value[LipidomicsAnalyzer.findIndexByTime(probe2.Peak, chrom)][2] > chrom.Value[LipidomicsAnalyzer.findIndexByTime(probe1.Peak, chrom)][2]) {
                        probe1.Peak = probe2.Peak;
                        useForProfilePoints = probe2;
                    }
                    if (probe2.LowerMzBand > probe1.LowerMzBand) {
                        probe1.LowerMzBand = probe2.LowerMzBand;
                    }
                    if (probe2.UpperMzBand > probe1.UpperMzBand) {
                        probe1.UpperMzBand = probe2.UpperMzBand;
                    }
                    if ((ellipse = Calculator.calculateEllipseFrom4Points(probe1.Peak, probe1.Mz - probe1.LowerMzBand, probe1.Peak, probe1.Mz + probe1.UpperMzBand, probe1.LowerValley, probe1.Mz, probe1.UpperValley, probe1.Mz))[3] > this.profileMaxRange_) {
                        ellipse[3] = this.profileMaxRange_;
                    }
                    Probe3D probe3D = new Probe3D(probe1, useForProfilePoints, probe1.isOverlapLowerMz(), probe1.isOverlapHigherMz(), probe1.isOverlapBefore(), probe1.isOverlapLater(), ellipse);
                    LipidomicsChromatogram forQuant = new LipidomicsChromatogram(this.readJustIntensitiesOfInterest(probe3D, msLevel));
                    forQuant.Background = probe1.Background;
                    forQuant.getAreaRaw();
                    probe3D.Area = forQuant.Area;
                    probe1 = probe3D;
                    excludeList.put(j, j);
                }
                unitedProbes.add(probe1);
            }
        }
        return unitedProbes;
    }

    private boolean isDeepValleyBetweenPeaks(LipidomicsChromatogram chrom, CgProbe probe1, CgProbe probe2) {
        boolean isDeepValley = true;
        float highestValue = 0.0f;
        float lowestValue = 1.0E10f;
        int start = 0;
        int stop = 0;
        if (probe1.Peak < probe2.Peak) {
            start = LipidomicsAnalyzer.findIndexByTime(probe1.Peak, chrom);
            stop = LipidomicsAnalyzer.findIndexByTime(probe2.Peak, chrom);
        } else {
            start = LipidomicsAnalyzer.findIndexByTime(probe2.Peak, chrom);
            stop = LipidomicsAnalyzer.findIndexByTime(probe1.Peak, chrom);
        }
        for (int i = start; i < stop; ++i) {
            if (chrom.Value[i][2] > highestValue) {
                highestValue = chrom.Value[i][2];
            }
            if (!(chrom.Value[i][2] < lowestValue)) continue;
            lowestValue = chrom.Value[i][2];
        }
        if (lowestValue > this.twinInBetweenCutoff_ * highestValue) {
            isDeepValley = false;
        }
        return isDeepValley;
    }

    private boolean isDeepValleyBetweenUnionPeaks(LipidomicsChromatogram chrom, CgProbe probe1, CgProbe probe2) {
        int i;
        boolean isDeepValley = true;
        float lowestValue = Float.MAX_VALUE;
        int start = 0;
        int stop = 0;
        float highestProbe1 = 0.0f;
        float highestProbe2 = 0.0f;
        if (probe1.Peak < probe2.Peak) {
            start = LipidomicsAnalyzer.findIndexByTime(probe1.Peak, chrom);
            stop = LipidomicsAnalyzer.findIndexByTime(probe2.Peak, chrom);
        } else {
            start = LipidomicsAnalyzer.findIndexByTime(probe2.Peak, chrom);
            stop = LipidomicsAnalyzer.findIndexByTime(probe1.Peak, chrom);
        }
        highestProbe1 = chrom.Value[LipidomicsAnalyzer.findIndexByTime(probe1.Peak, chrom)][2];
        highestProbe2 = chrom.Value[LipidomicsAnalyzer.findIndexByTime(probe2.Peak, chrom)][2];
        float highestValue = highestProbe1;
        if (highestProbe2 < highestProbe1) {
            highestValue = highestProbe2;
        }
        for (i = start; i < stop; ++i) {
            if (!(chrom.Value[i][2] < lowestValue)) continue;
            lowestValue = chrom.Value[i][2];
        }
        if (lowestValue >= this.unionInBetweenCutoff_ * highestValue) {
            isDeepValley = false;
        }
        if (!isDeepValley) {
            return isDeepValley;
        }
        lowestValue = Float.MAX_VALUE;
        highestProbe1 = chrom.Value[LipidomicsAnalyzer.findIndexByTime(probe1.Peak, chrom)][1];
        highestProbe2 = chrom.Value[LipidomicsAnalyzer.findIndexByTime(probe2.Peak, chrom)][1];
        highestValue = highestProbe1;
        if (highestProbe2 < highestProbe1) {
            highestValue = highestProbe2;
        }
        if (highestValue == 0.0f) {
            int stopScan;
            int startScan;
            if (probe1.Area < probe2.Area) {
                if (probe1.Peak < probe2.Peak) {
                    startScan = start;
                    stopScan = probe1.UpperValley > probe2.Peak ? LipidomicsAnalyzer.findIndexByTime(probe1.Peak + (probe2.Peak - probe1.Peak) / 2.0f, chrom) : LipidomicsAnalyzer.findIndexByTime(probe1.UpperValley, chrom);
                } else {
                    startScan = probe1.LowerValley < probe2.Peak ? LipidomicsAnalyzer.findIndexByTime(probe1.Peak - (probe1.Peak - probe2.Peak) / 2.0f, chrom) : LipidomicsAnalyzer.findIndexByTime(probe1.LowerValley, chrom);
                    stopScan = stop;
                }
            } else if (probe2.Peak < probe1.Peak) {
                startScan = start;
                stopScan = probe2.UpperValley > probe1.Peak ? LipidomicsAnalyzer.findIndexByTime(probe2.Peak + (probe1.Peak - probe2.Peak) / 2.0f, chrom) : LipidomicsAnalyzer.findIndexByTime(probe2.UpperValley, chrom);
            } else {
                startScan = probe2.LowerValley < probe1.Peak ? LipidomicsAnalyzer.findIndexByTime(probe2.Peak - (probe2.Peak - probe1.Peak) / 2.0f, chrom) : LipidomicsAnalyzer.findIndexByTime(probe2.LowerValley, chrom);
                stopScan = stop;
            }
            for (int i2 = startScan; i2 <= stopScan; ++i2) {
                if (!(chrom.Value[i2][1] > highestValue)) continue;
                highestValue = chrom.Value[i2][1];
            }
        }
        for (i = start; i < stop; ++i) {
            if (!(chrom.Value[i][1] < lowestValue)) continue;
            lowestValue = chrom.Value[i][1];
        }
        if (lowestValue >= this.unionInBetweenCutoff_ * highestValue) {
            isDeepValley = false;
        }
        return isDeepValley;
    }

    private Vector calculateIsoProbesWithinZeroIsotopeBoundaries(LipidomicsChromatogram chrom, Probe3D zeroProbe, Vector<CgProbe> otherAcceptedProbes, double multiplicationFactor, Vector<CgProbe> notAllowedIsoProbes, double zeroToOneMultiplicationFactor, boolean respectIntCutoff, int charge, int msLevel) throws CgException {
        int upperValleyIndex22;
        CgProbe correctIsoProbe = null;
        Vector<Probe3D> allPossibleIsoProbes = new Vector<Probe3D>();
        Vector<CgProbe> notAllowedIsoProbe = new Vector<CgProbe>();
        int mainScan = LipidomicsAnalyzer.findIndexByTime(zeroProbe.Peak, chrom);
        int lowestScan = LipidomicsAnalyzer.findIndexByTime(zeroProbe.LowerValley, chrom);
        int highestScan = LipidomicsAnalyzer.findIndexByTime(zeroProbe.UpperValley, chrom);
        double lowerThreshold = multiplicationFactor * 0.1428571492433548;
        double upperThreshold = multiplicationFactor * 2.0;
        Probe3D currentValidProbe = null;
        int currentScan = mainScan;
        Probe3D probe = null;
        try {
            probe = this.detectPeakThreeD(chrom, mainScan, respectIntCutoff, charge, msLevel);
            if (probe.AreaStatus == CgAreaStatus.OK) {
                allPossibleIsoProbes.add(probe);
                currentValidProbe = probe;
                int lowerValleyIndex = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.LowerValley, chrom);
                if (lowerValleyIndex < currentScan) {
                    currentScan = lowerValleyIndex;
                }
            }
        }
        catch (QuantificationException lowerValleyIndex) {
            // empty catch block
        }
        --currentScan;
        while (currentScan > lowestScan) {
            try {
                probe = this.detectPeakThreeD(chrom, currentScan, respectIntCutoff, charge, msLevel);
                if (probe.AreaStatus == CgAreaStatus.OK) {
                    this.checkDuplicate(allPossibleIsoProbes, probe);
                    allPossibleIsoProbes.add(probe);
                    currentValidProbe = probe;
                }
            }
            catch (QuantificationException lowerValleyIndex) {
                // empty catch block
            }
            if (currentValidProbe != null && (lowerValleyIndex = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.LowerValley, chrom)) < currentScan) {
                currentScan = lowerValleyIndex;
            }
            --currentScan;
        }
        currentScan = mainScan;
        if (allPossibleIsoProbes.size() > 0 && (upperValleyIndex22 = LipidomicsAnalyzer.findIndexByTime(((Probe3D)allPossibleIsoProbes.get((int)0)).UpperValley, chrom)) > currentScan) {
            currentScan = upperValleyIndex22;
        }
        ++currentScan;
        while (currentScan < highestScan) {
            int upperValleyIndex;
            try {
                probe = this.detectPeakThreeD(chrom, currentScan, respectIntCutoff, charge, msLevel);
                if (probe.AreaStatus == CgAreaStatus.OK) {
                    this.checkDuplicate(allPossibleIsoProbes, probe);
                    allPossibleIsoProbes.add(probe);
                    currentValidProbe = probe;
                }
            }
            catch (QuantificationException upperValleyIndex22) {
                // empty catch block
            }
            if (currentValidProbe != null && (upperValleyIndex = LipidomicsAnalyzer.findIndexByTime(currentValidProbe.UpperValley, chrom)) > currentScan) {
                currentScan = upperValleyIndex;
            }
            ++currentScan;
        }
        Vector<Probe3D> removedDuplicates = new Vector<Probe3D>();
        for (Probe3D aProbe : allPossibleIsoProbes) {
            if (aProbe.AreaStatus != CgAreaStatus.OK) continue;
            if (this.isFromPreviousIsotope(aProbe, notAllowedIsoProbes, zeroToOneMultiplicationFactor)) {
                notAllowedIsoProbe.add(aProbe);
                continue;
            }
            removedDuplicates.add(aProbe);
        }
        Vector<CgProbe> unitedPeaks = this.uniteTwinPeaksClone(removedDuplicates, chrom, msLevel);
        Vector<Probe3D> bothPeakTypes = new Vector<Probe3D>();
        for (Probe3D probe3D : removedDuplicates) {
            if (probe3D.AreaStatus != CgAreaStatus.OK) continue;
            this.checkDuplicate(bothPeakTypes, probe3D);
            bothPeakTypes.add(probe3D);
        }
        for (CgProbe cgProbe : unitedPeaks) {
            if (cgProbe.AreaStatus != CgAreaStatus.OK) continue;
            this.checkDuplicate(bothPeakTypes, cgProbe);
            bothPeakTypes.add((Probe3D)cgProbe);
        }
        removedDuplicates = new Vector();
        for (Probe3D probe3D : bothPeakTypes) {
            if (probe3D.AreaStatus != CgAreaStatus.OK) continue;
            removedDuplicates.add(probe3D);
        }
        Vector<Probe3D> fullfillsCriteria = new Vector<Probe3D>();
        float f = zeroProbe.Area * (float)lowerThreshold;
        float upperArea = zeroProbe.Area * (float)upperThreshold;
        for (Probe3D aProbe : removedDuplicates) {
            if (f < aProbe.Area && aProbe.Area < upperArea) {
                fullfillsCriteria.add(aProbe);
                continue;
            }
            notAllowedIsoProbe.add(aProbe);
        }
        if (fullfillsCriteria.size() > 1) {
            int position = this.findClosestToExpectedPosition(fullfillsCriteria, zeroProbe, multiplicationFactor);
            correctIsoProbe = fullfillsCriteria.get(position);
            fullfillsCriteria.remove(position);
            notAllowedIsoProbe.addAll(fullfillsCriteria);
        } else if (fullfillsCriteria.size() == 1) {
            correctIsoProbe = fullfillsCriteria.get(0);
        } else {
            CgProbe greedyProbe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
            if (greedyProbe.AreaStatus == CgAreaStatus.OK && f < greedyProbe.Area && greedyProbe.Area < upperArea) {
                if (this.isFromPreviousIsotope(greedyProbe, notAllowedIsoProbes, zeroToOneMultiplicationFactor)) {
                    notAllowedIsoProbe.add(greedyProbe);
                } else {
                    correctIsoProbe = greedyProbe;
                }
            } else {
                CgProbe standardProbe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.StandardValleyMethod, charge);
                if (standardProbe.Area < f) {
                    standardProbe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.EnhancedValleyMethod, charge);
                }
                if (f < standardProbe.Area && standardProbe.Area < upperArea) {
                    if (!this.isFromPreviousIsotope(greedyProbe, notAllowedIsoProbes, zeroToOneMultiplicationFactor)) {
                        correctIsoProbe = standardProbe;
                    } else {
                        notAllowedIsoProbe.add(standardProbe);
                    }
                } else {
                    notAllowedIsoProbe.add(greedyProbe);
                }
            }
        }
        Vector<Serializable> result = new Vector<Serializable>();
        result.add(correctIsoProbe);
        result.add(notAllowedIsoProbe);
        return result;
    }

    private int findClosestToExpectedPosition(Vector<Probe3D> probes, Probe3D zeroProbe, double multiplicationFactor) {
        int correctProbePosition = -1;
        Hashtable<Integer, Integer> fromSameScoreToOriginalPosition = new Hashtable<Integer, Integer>();
        Vector<Integer> closeScore = new Vector<Integer>();
        float peakDistance = zeroProbe.UpperValley - zeroProbe.LowerValley;
        int highestScore = 0;
        for (Probe3D probe : probes) {
            int score = 0;
            if (zeroProbe.Peak - peakDistance / 6.0f < probe.Peak && probe.Peak < zeroProbe.Peak + peakDistance / 6.0f) {
                score += 3;
            }
            if (zeroProbe.LowerValley - peakDistance / 6.0f < probe.LowerValley && probe.LowerValley < zeroProbe.LowerValley + peakDistance / 6.0f) {
                score += 2;
            } else if (zeroProbe.LowerValley < probe.LowerValley && probe.Peak < zeroProbe.UpperValley) {
                ++score;
            }
            if (zeroProbe.UpperValley - peakDistance / 6.0f < probe.UpperValley && probe.UpperValley < zeroProbe.UpperValley + peakDistance / 6.0f) {
                score += 2;
            } else if (zeroProbe.UpperValley > probe.UpperValley && probe.Peak > zeroProbe.LowerValley) {
                ++score;
            }
            closeScore.add(score);
            if (score <= highestScore) continue;
            highestScore = score;
        }
        float idealArea = zeroProbe.Area * (float)multiplicationFactor;
        Vector<Probe3D> probesWithSameScore = new Vector<Probe3D>();
        float lowestAreaMultiplication = 100.0f;
        int lowestAreaPosition = 0;
        int currentAddPosition = 0;
        for (int i = 0; i != closeScore.size(); ++i) {
            if ((Integer)closeScore.get(i) != highestScore) continue;
            Probe3D aProbe = probes.get(i);
            if (aProbe.Area > idealArea) {
                if (aProbe.Area / idealArea < lowestAreaMultiplication) {
                    lowestAreaMultiplication = aProbe.Area / idealArea;
                    lowestAreaPosition = currentAddPosition;
                }
            } else if (idealArea / aProbe.Area < lowestAreaMultiplication) {
                lowestAreaMultiplication = idealArea / aProbe.Area;
                lowestAreaPosition = currentAddPosition;
            }
            fromSameScoreToOriginalPosition.put(probesWithSameScore.size(), i);
            probesWithSameScore.add(probes.get(i));
            ++currentAddPosition;
        }
        correctProbePosition = probesWithSameScore.size() > 1 ? ((Integer)fromSameScoreToOriginalPosition.get(lowestAreaPosition)).intValue() : ((Integer)fromSameScoreToOriginalPosition.get(0)).intValue();
        return correctProbePosition;
    }

    private boolean isFromPreviousIsotope(CgProbe aProbe, Vector<CgProbe> notAllowedIsoProbes, double multiplicationFactor) {
        boolean isInNotAllowedIso = false;
        for (CgProbe otherIsoProbe : notAllowedIsoProbes) {
            if (!((double)otherIsoProbe.Area * multiplicationFactor * 1.5 > (double)aProbe.Area) || !LipidomicsAnalyzer.isProbe1InProbe2Third(aProbe, otherIsoProbe, this.overlapPeakDistanceDivisor_, this.overlapFullDistanceDivisor_)) continue;
            isInNotAllowedIso = true;
        }
        return isInNotAllowedIso;
    }

    private static boolean isOneProbeInOtherInnerThird(CgProbe probe1, CgProbe probe2, float overlapPeakDistanceDivisor, float overlapFullDistanceDivisor) {
        boolean isInThird = false;
        if (LipidomicsAnalyzer.isProbe1InProbe2Third(probe1, probe2, overlapPeakDistanceDivisor, overlapFullDistanceDivisor)) {
            isInThird = true;
        }
        if (LipidomicsAnalyzer.isProbe1InProbe2Third(probe2, probe1, overlapPeakDistanceDivisor, overlapFullDistanceDivisor)) {
            isInThird = true;
        }
        return isInThird;
    }

    private static boolean isProbe1InProbe2Third(CgProbe probe1, CgProbe probe2, float overlapPeakDistanceDivisor, float overlapFullDistanceDivisor) {
        boolean isInInnerThird = false;
        if (probe1.Peak < probe2.Peak) {
            float lowerThreshold1 = probe2.Peak - (probe2.Peak - probe2.LowerValley) / overlapPeakDistanceDivisor;
            float lowerThreshold2 = probe2.Peak - (probe2.UpperValley - probe2.LowerValley) / overlapFullDistanceDivisor;
            if (probe1.Peak > lowerThreshold1 || probe1.Peak > lowerThreshold2) {
                isInInnerThird = true;
            }
        } else {
            float upperThreshold1 = probe2.Peak + (probe2.UpperValley - probe2.Peak) / overlapPeakDistanceDivisor;
            float upperThreshold2 = probe2.Peak + (probe2.UpperValley - probe2.LowerValley) / overlapFullDistanceDivisor;
            if (probe1.Peak < upperThreshold1 || probe1.Peak < upperThreshold2) {
                isInInnerThird = true;
            }
        }
        return isInInnerThird;
    }

    private boolean checkNearNormalProbe(CgProbe otherIsoProbe, Vector<CgProbe> probes, boolean[] isOfInterest) {
        boolean nearNormalProbe = false;
        for (int i = 0; i != probes.size(); ++i) {
            CgProbe probe = probes.get(i);
            if (!(this.checkTimeSpace(otherIsoProbe, probe) < (float)this.isoNearNormalProbeTime_) || isOfInterest != null && !isOfInterest[i]) continue;
            nearNormalProbe = true;
        }
        return nearNormalProbe;
    }

    private boolean otherIsoProbeInBetween(CgProbe highestProbe, CgProbe aProbe, Vector<CgProbe> otherIsoProbes) {
        boolean isoInBetween = false;
        for (CgProbe otherIsoProbe : otherIsoProbes) {
            if (otherIsoProbe.Area < 0.2f * aProbe.Area) continue;
            if (highestProbe.Peak > aProbe.Peak) {
                if (!(this.checkTimeSpace(highestProbe, aProbe) < (float)this.isoInBetweenMaxTimeDistance_) || !(aProbe.Peak < otherIsoProbe.Peak) || !(otherIsoProbe.Peak < highestProbe.Peak)) continue;
                isoInBetween = true;
                continue;
            }
            if (!(this.checkTimeSpace(highestProbe, aProbe) < (float)this.isoInBetweenMaxTimeDistance_) || !(highestProbe.Peak < otherIsoProbe.Peak) || !(otherIsoProbe.Peak < aProbe.Peak)) continue;
            isoInBetween = true;
        }
        return isoInBetween;
    }

    private Vector<CgProbe> curateCurrentIsoProbes(Vector<CgProbe> currentIsoProbes, int isoNumber, Hashtable<Integer, Hashtable<Integer, Vector<CgProbe>>> isotopicAreas, boolean[] isOfInterest) {
        Vector<CgProbe> currentProbesOfInterest = new Vector<CgProbe>();
        for (Integer key : isotopicAreas.keySet()) {
            if (!isOfInterest[key] || !isotopicAreas.get(key).containsKey(isoNumber)) continue;
            for (CgProbe aProbe : isotopicAreas.get(key).get(isoNumber)) {
                currentProbesOfInterest.add(aProbe);
            }
        }
        Vector<CgProbe> currentIsoProbesCurated = new Vector<CgProbe>();
        for (CgProbe probe1 : currentIsoProbes) {
            if (!this.checkNearNormalProbe(probe1, currentProbesOfInterest, null)) continue;
            boolean addIt = true;
            for (CgProbe probe2 : currentProbesOfInterest) {
                if (!LipidomicsAnalyzer.isOneProbeInOtherInnerThird(probe1, probe2, this.overlapPeakDistanceDivisor_, this.overlapFullDistanceDivisor_)) continue;
                addIt = false;
            }
            if (!addIt) continue;
            currentIsoProbesCurated.add(probe1);
        }
        return currentIsoProbesCurated;
    }

    public void setGeneralBasePeakCutoff(float generalBasePeakCutoff) {
        this.generalBasePeakCutoff_ = generalBasePeakCutoff / 1000.0f;
    }

    public float getHighestArea() {
        return this.highestArea_;
    }

    private void calculateNoiseCutoffValue(LipidomicsChromatogram chrom) {
        Vector<Float> values = new Vector<Float>();
        for (int i = 0; i != chrom.Value.length; ++i) {
            values.add(Float.valueOf(chrom.Value[i][2]));
        }
        float median = Calculator.median(values).floatValue();
        if (median > 0.0f) {
            Vector<Float> doubleMedian = new Vector<Float>();
            for (int i = 0; i != values.size(); ++i) {
                if (!(values.get(i).floatValue() < median * 2.0f)) continue;
                doubleMedian.add(values.get(i));
            }
            float[] floatArray = new float[doubleMedian.size()];
            for (int i = 0; i != doubleMedian.size(); ++i) {
                floatArray[i] = ((Float)doubleMedian.get(i)).floatValue();
            }
            float stdev = Calculator.stddeviation(floatArray);
            this.lowerIntensityThreshold_ = median;
            this.lowerIntensityThreshold_ = Float.isInfinite(stdev) || Float.isNaN(stdev) ? (this.lowerIntensityThreshold_ += median) : (this.lowerIntensityThreshold_ += this.noiseCutoffDeviationValue_ * stdev);
        }
    }

    private void calculateMinIntThreshold(LipidomicsChromatogram chrom) {
        float highestValue = 0.0f;
        for (int i = 0; i != chrom.Value.length; ++i) {
            if (!(chrom.Value[i][2] > highestValue)) continue;
            highestValue = chrom.Value[i][2];
        }
        if (this.lowerIntensityThreshold_ < highestValue * this.minimumRelativeIntensity_.floatValue()) {
            this.lowerIntensityThreshold_ = highestValue * this.minimumRelativeIntensity_.floatValue();
        }
    }

    private void setDynamicNoiseCutoff(LipidomicsChromatogram chrom) {
        float noiseLevel = chrom.estimateChromatogramNoise();
        if (this.lowerIntensityThreshold_ < noiseLevel) {
            this.lowerIntensityThreshold_ = noiseLevel;
        }
    }

    public CgProbe getProbeByManualSettings(LipidomicsChromatogram cr, boolean is3D, double startTime, double stopTime, double startMz, double stopMz, int charge, int msLevel) throws CgException {
        double timeCenter = (startTime + stopTime) / 2.0;
        cr.FindPeak(LipidomicsAnalyzer.findIndexByTime((float)timeCenter, cr), 1, LipidomicsDefines.StandardValleyMethod);
        int lowValleyIndex = LipidomicsAnalyzer.findIndexByTime((float)startTime, cr) + 1;
        int upValleyIndex = LipidomicsAnalyzer.findIndexByTime((float)stopTime, cr) + 1;
        cr.LoValley = lowValleyIndex;
        cr.UpValley = upValleyIndex;
        if (cr.Peak < lowValleyIndex || cr.Peak > upValleyIndex) {
            cr.Peak = (lowValleyIndex + upValleyIndex) / 2;
        }
        cr.GetBackground(LipidomicsConstants.getBackgroundScanRange());
        cr.GetAreaAndTime();
        if (cr.Area <= 0.0f) {
            cr.Background = 0.0f;
            cr.GetAreaAndTime();
        }
        CgProbe twoDProbe = new CgProbe(0, charge);
        twoDProbe = LipidomicsAnalyzer.copyResults(twoDProbe, cr, false);
        CgProbe returnProbe = null;
        if (is3D) {
            float broadChromSmoothRange = this.broadChromSmoothRange_ * 60.0f;
            double mz = (startMz + stopMz) / 2.0;
            double mzStretch = (stopMz - startMz) / 2.0;
            LipidomicsChromatogram broadChroma = new LipidomicsChromatogram(this.readAChromatogram((float)mz, (float)mzStretch, (float)mzStretch, msLevel, this.chromSmoothRange_, this.broadChromSmoothRepeats_, this.chromSmoothRange_, this.broadChromMeanSmoothRepeats_, (float)(timeCenter - (double)broadChromSmoothRange), (float)(timeCenter + (double)broadChromSmoothRange)));
            broadChroma.FindPeak(LipidomicsAnalyzer.findIndexByTime((float)timeCenter, broadChroma), 1, LipidomicsDefines.GreedySteepnessPointImproved);
            broadChroma.LoValley = lowValleyIndex;
            broadChroma.UpValley = upValleyIndex;
            if (broadChroma.Peak < lowValleyIndex || broadChroma.Peak > upValleyIndex) {
                broadChroma.Peak = (lowValleyIndex + upValleyIndex) / 2;
            }
            broadChroma.GetBackground(LipidomicsConstants.getBackgroundScanRange());
            broadChroma.GetAreaAndTime();
            twoDProbe = new CgProbe(0, charge);
            twoDProbe = LipidomicsAnalyzer.copyResults(twoDProbe, broadChroma, false);
            float[] ellipse = new float[]{(float)timeCenter, (float)mz, (float)((stopTime - startTime) / 2.0), (float)mzStretch};
            CgProbe profileProbe = this.getProfileProbeWithoutQualityCheck(twoDProbe, (float)startMz, (float)stopMz, msLevel);
            returnProbe = new Probe3D(twoDProbe, profileProbe, false, false, false, false, ellipse);
            LipidomicsChromatogram forQuant = new LipidomicsChromatogram(this.readJustIntensitiesOfInterest((Probe3D)returnProbe, msLevel));
            forQuant.Background = returnProbe.Background;
            forQuant.getAreaRaw();
            returnProbe.Area = forQuant.Area;
            if (returnProbe.Area > this.highestArea_) {
                this.highestArea_ = returnProbe.Area;
            }
            if (forQuant.getHighestIntensity() > this.highestIntensity_) {
                this.highestIntensity_ = forQuant.getHighestIntensity();
            }
        } else {
            returnProbe = twoDProbe;
        }
        returnProbe.AreaStatus = CgAreaStatus.OK;
        return returnProbe;
    }

    public Vector<Vector<CgProbe>> calculatePeakAtExactTimePosition(LipidParameterSet templateParam, int maxIsotope, int charge, int msLevel) throws CgException, QuantificationException {
        Vector<Vector<CgProbe>> results = new Vector<Vector<CgProbe>>();
        for (int i = 0; i != maxIsotope; ++i) {
            if (templateParam.getIsotopicProbes().size() <= i) continue;
            CgProbe templateProbe = templateParam.getIsotopicProbes().get(i).get(0);
            float mainRt = templateProbe.Peak;
            LipidomicsChromatogram chrom = new LipidomicsChromatogram(this.readAChromatogram(templateProbe.Mz, templateParam.LowerMzBand, templateParam.UpperMzBand, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
            chrom.GetMaximumAndAverage();
            int mainScan = LipidomicsAnalyzer.findIndexByTime(mainRt, chrom);
            Vector<Probe3D> oneIso = new Vector<Probe3D>();
            CgProbe probe = null;
            try {
                probe = this.detectPeakThreeD(chrom, mainScan, false, charge, msLevel);
            }
            catch (QuantificationException quantificationException) {
                // empty catch block
            }
            if (probe != null && probe.AreaStatus == CgAreaStatus.OK) {
                oneIso.add((Probe3D)probe);
                results.add(oneIso);
                continue;
            }
            probe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
            if (probe.AreaStatus == CgAreaStatus.OK) {
                oneIso.add((Probe3D)probe);
                results.add(oneIso);
                continue;
            }
            probe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.EnhancedValleyMethod, charge);
            if (probe.AreaStatus == CgAreaStatus.OK) {
                oneIso.add((Probe3D)probe);
                results.add(oneIso);
                continue;
            }
            probe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.StandardValleyMethod, charge);
            if (probe.AreaStatus != CgAreaStatus.OK) break;
            oneIso.add((Probe3D)probe);
            results.add(oneIso);
        }
        return results;
    }

    public CgProbe calculatePeakAtExactTimePosition(float rt, float mz, float lowerMzBand, float upperMzBand, int charge, int msLevel) throws CgException, QuantificationException {
        CgProbe probe = null;
        LipidomicsChromatogram chrom = new LipidomicsChromatogram(this.readAChromatogram(mz, lowerMzBand, upperMzBand, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
        chrom.GetMaximumAndAverage();
        int mainScan = LipidomicsAnalyzer.findIndexByTime(rt, chrom);
        try {
            probe = this.detectPeakThreeD(chrom, mainScan, false, charge, msLevel);
        }
        catch (QuantificationException quantificationException) {
            // empty catch block
        }
        if (probe != null && probe.AreaStatus == CgAreaStatus.OK) {
            return probe;
        }
        probe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.GreedySteepnessReductionMethod, charge);
        if (probe.AreaStatus == CgAreaStatus.OK) {
            return probe;
        }
        probe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.EnhancedValleyMethod, charge);
        if (probe.AreaStatus == CgAreaStatus.OK) {
            return probe;
        }
        probe = LipidomicsAnalyzer.calculateOneArea(chrom, mainScan, LipidomicsDefines.StandardValleyMethod, charge);
        if (probe.AreaStatus == CgAreaStatus.OK) {
            return probe;
        }
        return probe;
    }

    public Vector<Vector<CgProbe>> calculatePeakAtExactProbePosition(LipidParameterSet templateParam, int maxIsotope, int charge, int msLevel) throws CgException {
        Vector<Vector<CgProbe>> results = new Vector<Vector<CgProbe>>();
        for (int i = 0; i != maxIsotope; ++i) {
            if (templateParam.getIsotopicProbes().size() <= i) continue;
            CgProbe probe = templateParam.getIsotopicProbes().get(i).get(0);
            LipidomicsChromatogram chrom = new LipidomicsChromatogram(this.readAChromatogram(probe.Mz, templateParam.LowerMzBand, templateParam.UpperMzBand, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
            chrom.GetMaximumAndAverage();
            boolean is3D = false;
            float startMz = probe.Mz - probe.LowerMzBand;
            float stopMz = probe.Mz + probe.LowerMzBand;
            float startTime = probe.LowerValley;
            float stopTime = probe.UpperValley;
            if (probe instanceof Probe3D) {
                is3D = true;
                Probe3D probe3D = (Probe3D)probe;
                startMz = probe3D.getEllipseMzPosition() - probe3D.getEllipseMzStretch();
                stopMz = probe3D.getEllipseMzPosition() + probe3D.getEllipseMzStretch();
                startTime = probe3D.getEllipseTimePosition() - probe3D.getEllipseTimeStretch();
                stopTime = probe3D.getEllipseTimePosition() + probe3D.getEllipseTimeStretch();
            }
            Vector<CgProbe> oneIso = new Vector<CgProbe>();
            CgProbe probeToAdd = this.getProbeByManualSettings(chrom, is3D, startTime, stopTime, startMz, stopMz, charge, msLevel);
            if (!(probeToAdd.Area > 0.0f)) break;
            oneIso.add(probeToAdd);
            results.add(oneIso);
        }
        return results;
    }

    public boolean justZeroValues(LipidomicsChromatogram profile) {
        boolean justZero = true;
        for (int i = 0; i != profile.Value.length; ++i) {
            if (!(profile.Value[i][2] > this.profileIntThreshold_)) continue;
            justZero = false;
            break;
        }
        return justZero;
    }

    protected static CgProbe copyResults(CgProbe px, LipidomicsChromatogram cx, boolean ignoreZeros) {
        px = Analyzer.copyResults(px, cx, ignoreZeros);
        px.greedyFragment = cx.isGreedyFragment();
        boolean loOverlap = false;
        if (cx.getLoSteepnessPoint() != -1) {
            loOverlap = true;
        }
        px.setLoOverlap(loOverlap);
        boolean upOverlap = false;
        if (cx.getUpSteepnessPoint() != -1) {
            upOverlap = true;
        }
        px.setUpOverlap(upOverlap);
        return px;
    }

    public static CgProbe calculateOneArea(CgChromatogram chrom, int scan, int mode, int charge) {
        CgProbe probe = LipidomicsAnalyzer.calculateOneAreaBg(chrom, scan, mode, LipidomicsConstants.getBackgroundScanRange());
        if (probe != null) {
            probe.Charge = charge;
        }
        return probe;
    }

    private static CgProbe calculateOneAreaBg(CgChromatogram chrom, int scan, int mode, int range) {
        chrom.FindPeak(scan, 1, mode);
        if (chrom.anythingThere) {
            chrom.GetBackground(range);
            chrom.GetAreaAndTime();
        }
        CgProbe probe = new CgProbe(0, 1);
        probe = Analyzer.copyResults(probe, chrom, false);
        return probe;
    }

    public CgProbe calculateMs2Area(double fragmentMass, String fragmentFormula, int msLevel, int charge, boolean isFromOtherSpecies, Vector<CgProbe> probes) throws CgException {
        float[] startStopRt = this.getStartStopTimeFromProbes(probes);
        float lowestRt = startStopRt[0];
        float highestRt = startStopRt[1];
        float tol = StaticUtils.calculatedMzTolValue((float)fragmentMass, this.msnMzTolerance_, this.msnMzToleranceUnit_);
        LipidomicsChromatogram chrom = new LipidomicsChromatogram(this.readJustIntensitiesOfInterest((float)fragmentMass - tol, (float)fragmentMass + tol, lowestRt, highestRt, msLevel));
        float area = 0.0f;
        CgProbe result = new CgProbe(0, charge, msLevel, fragmentFormula);
        float peakRt = 0.0f;
        float highestInt = 0.0f;
        result.AreaStatus = CgAreaStatus.NothingThere;
        if (chrom.getHighestIntensity() > 0.0f) {
            int startScan;
            float rt;
            for (int i = startScan = this.getStartPosition(chrom, lowestRt); i != chrom.Value.length && !((rt = chrom.Value[i][0]) > highestRt); ++i) {
                if (!(rt > lowestRt)) continue;
                area += chrom.Value[i][1];
                if (!(chrom.Value[i][1] > highestInt)) continue;
                highestInt = chrom.Value[i][1];
                peakRt = chrom.Value[i][0];
            }
        }
        if (area > 0.0f) {
            result.AreaStatus = CgAreaStatus.OK;
            result.Area = area;
            result.AreaError = 0.0f;
            result.Background = 0.0f;
            result.Peak = peakRt;
            result.LowerValley = lowestRt;
            result.UpperValley = highestRt;
            result.Mz = (float)fragmentMass;
            result.LowerMzBand = tol;
            result.UpperMzBand = tol;
            result.isotopeNumber = 0;
            result.setFromOtherSpecies(isFromOtherSpecies);
        }
        return result;
    }

    public LinkedHashMap<Integer, Float> getMSnSpectraRetentionTimes(int msLevel, Vector<CgProbe> probes) {
        LinkedHashMap<Integer, Float> rts = new LinkedHashMap<Integer, Float>();
        float[] startStopRt = this.getStartStopTimeFromProbes(probes);
        float lowestRt = startStopRt[0];
        float highestRt = startStopRt[1];
        Hashtable<Integer, Hashtable<Integer, String>> spectraCache = this.getMSnSpectraCache();
        if (!spectraCache.containsKey(msLevel)) {
            return rts;
        }
        Hashtable<Integer, String> spectra = spectraCache.get(msLevel);
        Hashtable<Integer, Float> retTimes = this.reader_.getRetentionTimes(msLevel);
        ArrayList<Integer> consScanNumbers = new ArrayList<Integer>(spectra.keySet());
        Collections.sort(consScanNumbers);
        for (Integer consScanNumber : consScanNumbers) {
            float rt = retTimes.get(consScanNumber).floatValue();
            int scanNumber = Integer.parseInt(spectra.get(consScanNumber).substring(0, spectra.get(consScanNumber).indexOf(" ")));
            if (!(lowestRt < rt) || !(rt <= highestRt)) continue;
            rts.put(scanNumber, Float.valueOf(rt));
        }
        return rts;
    }

    private int getStartPosition(CgChromatogram chrom, float startRt) {
        int startScan = chrom.Value.length;
        for (int j = 0; j < chrom.Value.length; j += 100) {
            if (j + 100 < chrom.Value.length && !(chrom.Value[j + 100][0] > startRt)) continue;
            for (int k = j; k != j + 100; k += 10) {
                if (k + 10 < chrom.Value.length && !(chrom.Value[k + 10][0] > startRt)) continue;
                for (int i = k; i < chrom.Value.length; ++i) {
                    if (i + 1 < chrom.Value.length && !(chrom.Value[i + 1][0] > startRt)) continue;
                    return i;
                }
            }
        }
        return startScan;
    }

    public Hashtable<Integer, Float> extractBasePeakValues(Vector<Integer> levels, Vector<CgProbe> probes) throws CgException {
        return this.extractBasePeakValues(levels, probes, this.msnMzTolerance_);
    }

    public Vector<Range> findSingleSpectraRanges(int[] spectrLevelsRequired) {
        Vector<Range> ranges = new Vector<Range>();
        Hashtable<Integer, Hashtable<Integer, String>> spectraCache = this.getMSnSpectraCache();
        Hashtable rtsSorted = new Hashtable();
        Vector<Integer> foundLevels = new Vector<Integer>();
        for (int i = spectrLevelsRequired[0]; i < spectrLevelsRequired[1] + 1; ++i) {
            ArrayList<Float> rts = new ArrayList<Float>();
            if (!spectraCache.containsKey(i)) continue;
            Hashtable<Integer, String> spectra = spectraCache.get(i);
            Hashtable<Integer, Float> retTimes = this.getRetentionTimes(i);
            for (Integer consScanNumber : spectra.keySet()) {
                rts.add(retTimes.get(consScanNumber));
            }
            Collections.sort(rts);
            rtsSorted.put(i, rts);
            foundLevels.add(i);
        }
        if (foundLevels.size() == 0) {
            return ranges;
        }
        float startTime = 0.0f;
        float stopTime = 0.0f;
        List rts = (List)rtsSorted.get(foundLevels.get(0));
        Hashtable<Integer, Integer> levelStopped = new Hashtable<Integer, Integer>();
        Iterator<Object> iterator = foundLevels.iterator();
        while (iterator.hasNext()) {
            int level = (Integer)iterator.next();
            levelStopped.put(level, 0);
        }
        for (int i = 0; i < rts.size(); ++i) {
            startTime = stopTime;
            if (i == 0) {
                startTime = ((Float)rts.get(i)).floatValue() - ((Float)rts.get(i)).floatValue() / 10000.0f;
            }
            float firstValue = ((Float)rts.get(i)).floatValue();
            float secondValue = 0.0f;
            secondValue = i + 1 < rts.size() ? ((Float)rts.get(i + 1)).floatValue() : Float.MAX_VALUE;
            for (int j = 1; j < foundLevels.size(); ++j) {
                int stopped;
                int level = (Integer)foundLevels.get(j);
                List lowRts = (List)rtsSorted.get(level);
                for (int k = stopped = ((Integer)levelStopped.get(level)).intValue(); k < lowRts.size(); ++k) {
                    float rt = ((Float)lowRts.get(k)).floatValue();
                    stopped = k;
                    if (firstValue < rt && rt < secondValue) {
                        firstValue = rt;
                    }
                    if (rt > secondValue) break;
                }
                levelStopped.put(level, stopped);
            }
            if (i + 1 == rts.size()) {
                secondValue = firstValue * 1.001f;
            }
            stopTime = (firstValue + secondValue) / 2.0f;
            ranges.add(new Range(startTime, stopTime));
        }
        return ranges;
    }

    public Hashtable<Integer, Vector<CgProbe>> mergeIdentifications(Collection<LipidParameterSet> hits) throws CgException {
        Hashtable<Integer, Vector<Float>> maxDimensions = this.extractMaxDimensions(hits);
        boolean negative = false;
        if (maxDimensions.size() > 0 && maxDimensions.containsKey(-1)) {
            negative = true;
        }
        Hashtable<Integer, Vector<CgProbe>> results = new Hashtable<Integer, Vector<CgProbe>>();
        for (int i = 0; i != maxDimensions.size(); ++i) {
            Vector<Float> dimensions = null;
            int isotopeNumber = i;
            if (negative) {
                isotopeNumber *= -1;
            }
            dimensions = maxDimensions.get(isotopeNumber);
            float lowestMz = dimensions.get(0).floatValue();
            float highestMz = dimensions.get(1).floatValue();
            float lowestRt = dimensions.get(2).floatValue();
            float highestRt = dimensions.get(3).floatValue();
            float[] ellipse = new float[]{(lowestRt + highestRt) / 2.0f, (lowestMz + highestMz) / 2.0f, (highestRt - lowestRt) / 2.0f, (highestMz - lowestMz) / 2.0f};
            CgProbe probe = new CgProbe(-1, hits.iterator().next().getCharge());
            LipidomicsChromatogram chrom = new LipidomicsChromatogram(this.readAChromatogram(ellipse[1], ellipse[3] / 2.0f, ellipse[3] / 2.0f, 1, this.chromSmoothRange_, this.chromSmoothRepeats_));
            chrom.GetMaximumAndAverage();
            chrom.detectPeakIntensityInsideBorders(LipidomicsAnalyzer.findIndexByTime(lowestRt, chrom), LipidomicsAnalyzer.findIndexByTime(highestRt, chrom));
            chrom.GetBackground(LipidomicsConstants.getBackgroundScanRange());
            chrom.GetAreaAndTime();
            Analyzer.copyResults(probe, chrom, false);
            probe.AreaStatus = CgAreaStatus.OK;
            CgProbe profileProbe = this.getProfileProbeWithoutQualityCheck(probe, lowestMz, highestMz, probe.getMsLevel());
            Probe3D probe3D = new Probe3D(probe, profileProbe, false, false, false, false, ellipse);
            LipidomicsChromatogram forQuant = new LipidomicsChromatogram(this.readJustIntensitiesOfInterest(probe3D, 1));
            forQuant.Background = probe.Background;
            forQuant.getAreaRaw();
            probe3D.Area = forQuant.Area;
            Vector<Probe3D> probes = new Vector<Probe3D>();
            probes.add(probe3D);
            results.put(i, probes);
        }
        return results;
    }

    private Hashtable<Integer, Vector<Float>> extractMaxDimensions(Collection<LipidParameterSet> hits) {
        Hashtable<Integer, Vector<Float>> maxDimensions = new Hashtable<Integer, Vector<Float>>();
        int maxIsotope = 0;
        for (LipidParameterSet set : hits) {
            if (set.getIsotopicProbes().size() <= maxIsotope) continue;
            maxIsotope = set.getIsotopicProbes().size();
        }
        for (int i = 0; i != maxIsotope; ++i) {
            float lowestMz = Float.MAX_VALUE;
            float highestMz = 0.0f;
            float lowestRt = Float.MAX_VALUE;
            float highestRt = 0.0f;
            int isotopeNumber = 0;
            for (LipidParameterSet set : hits) {
                if (set.getIsotopicProbes().size() - 1 < i) continue;
                Vector<CgProbe> probes = set.getIsotopicProbes().get(i);
                for (CgProbe probe : probes) {
                    isotopeNumber = probe.isotopeNumber;
                    if (probe.Mz - probe.LowerMzBand < lowestMz) {
                        lowestMz = probe.Mz - probe.LowerMzBand;
                    }
                    if (probe.Mz + probe.UpperMzBand > highestMz) {
                        highestMz = probe.Mz + probe.UpperMzBand;
                    }
                    if (probe.LowerValley < lowestRt) {
                        lowestRt = probe.LowerValley;
                    }
                    if (!(probe.UpperValley > highestRt)) continue;
                    highestRt = probe.UpperValley;
                }
            }
            Vector<Float> dimensions = new Vector<Float>();
            dimensions.add(Float.valueOf(lowestMz));
            dimensions.add(Float.valueOf(highestMz));
            dimensions.add(Float.valueOf(lowestRt));
            dimensions.add(Float.valueOf(highestRt));
            maxDimensions.put(isotopeNumber, dimensions);
        }
        return maxDimensions;
    }

    public float getRelativeAreaCutoff() {
        return this.relativeAreaCutoff_;
    }

    public float getRelativeFarAreaCutoff() {
        return this.relativeFarAreaCutoff_;
    }

    public int getPeakDiscardingAreaFactor() {
        return this.peakDiscardingAreaFactor_;
    }

    public void setAreaCutoffs(float relativeAreaCutoff, float relativeFarAreaCutoff, int peakDiscardingAreaFactor, boolean overWriteDiscardingFactorOnlyIfBigger) {
        this.relativeAreaCutoff_ = relativeAreaCutoff;
        this.relativeFarAreaCutoff_ = relativeFarAreaCutoff;
        if (!overWriteDiscardingFactorOnlyIfBigger || peakDiscardingAreaFactor > this.peakDiscardingAreaFactor_) {
            this.peakDiscardingAreaFactor_ = peakDiscardingAreaFactor;
        }
    }

    public static boolean isPeakCenterTheSame(LipidParameterSet set1, LipidParameterSet set2) {
        boolean theSame = false;
        for (CgProbe probe1 : set1.getIsotopicProbes().get(0)) {
            for (CgProbe probe2 : set2.getIsotopicProbes().get(0)) {
                if (!LipidomicsAnalyzer.isOneProbeInOtherInnerThird(probe1, probe2, LipidomicsConstants.getOverlapPeakDistanceDivisor(), LipidomicsConstants.getOverlapFullDistanceDivisor())) continue;
                return true;
            }
        }
        return theSame;
    }

    public LipidomicsChromatogram readOneChromatogram(float mz, int msLevel) throws CgException {
        return new LipidomicsChromatogram(this.readAChromatogram(mz, this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
    }

    public float[] calculatePercentualBorders(float percent, LipidomicsChromatogram chrom, Vector<LipidParameterSet> sets) {
        float start = Float.MAX_VALUE;
        float stop = 0.0f;
        CgProbe intenseProbe = null;
        for (LipidParameterSet set : sets) {
            for (CgProbe probe : set.getIsotopicProbes().get(0)) {
                if (intenseProbe != null && !(probe.Area > intenseProbe.Area)) continue;
                intenseProbe = probe;
            }
        }
        if (intenseProbe != null) {
            float[] borders = chrom.findPercentualBorders(percent, intenseProbe.LowerValley, intenseProbe.UpperValley);
            start = borders[0];
            stop = borders[1];
        }
        float[] result = new float[]{start, stop};
        return result;
    }

    public float getMsnMzTolerance() {
        return this.msnMzTolerance_;
    }

    public short getMsnMzToleranceUnit() {
        return this.msnMzToleranceUnit_;
    }

    public boolean getUseCuda() {
        return this.useCuda_;
    }

    public SavGolJNI getSavGolJNI() {
        return this.sav_gol_jni_;
    }

    public void recalculatePeaksAccordingToHardLimits(LipidParameterSet set, int msLevel, float peak) throws CgException {
        Vector<Vector<CgProbe>> newProbes = new Vector<Vector<CgProbe>>();
        float totalArea = 0.0f;
        for (int i = 0; i != set.getIsotopicProbes().size(); ++i) {
            Vector<CgProbe> probes = set.getIsotopicProbes().get(i);
            Vector<CgProbe> newProbesOfIso = new Vector<CgProbe>();
            LipidomicsChromatogram chrom = null;
            if (this.chromHash_.containsKey(i)) {
                chrom = this.chromHash_.get(i);
            } else {
                chrom = new LipidomicsChromatogram(this.readAChromatogram(set.Mz[0], this.coarseChromMzTolerance_, this.coarseChromMzTolerance_, msLevel, this.chromSmoothRange_, this.chromSmoothRepeats_));
                this.chromHash_.put(i, chrom);
            }
            for (CgProbe aProbe : probes) {
                float lowerLimit = set.getLowerRtHardLimit();
                float upperLimit = set.getUpperRtHardLimit();
                if (lowerLimit >= 0.0f ? lowerLimit >= aProbe.UpperValley : upperLimit >= 0.0f && upperLimit <= aProbe.LowerValley) continue;
                CgProbe newProbe = aProbe;
                if (lowerLimit >= 0.0f && newProbe.LowerValley < lowerLimit || upperLimit >= 0.0f && newProbe.UpperValley > upperLimit) {
                    float loVal = newProbe.LowerValley;
                    float upVal = newProbe.UpperValley;
                    if (lowerLimit >= 0.0f && newProbe.LowerValley < lowerLimit) {
                        loVal = lowerLimit;
                    }
                    if (upperLimit >= 0.0f && newProbe.UpperValley > upperLimit) {
                        upVal = upperLimit;
                    }
                    if (newProbe instanceof Probe3D) {
                        Probe3D probe3D = new Probe3D((Probe3D)newProbe);
                        if (lowerLimit >= 0.0f && newProbe.LowerValley < lowerLimit) {
                            probe3D.setLowerHardRtLimit(lowerLimit);
                        }
                        if (upperLimit >= 0.0f && newProbe.UpperValley > upperLimit) {
                            probe3D.setUpperHardRtLimit(upperLimit);
                        }
                        LipidomicsChromatogram forQuant = new LipidomicsChromatogram(this.readJustIntensitiesOfInterest(probe3D, msLevel));
                        forQuant.Background = probe3D.Background;
                        forQuant.getAreaRaw();
                        probe3D.Area = forQuant.Area;
                        chrom.detectPeakIntensityInsideBorders(LipidomicsAnalyzer.findIndexByTime(loVal, chrom), LipidomicsAnalyzer.findIndexByTime(upVal, chrom));
                        probe3D.LowerValley = loVal;
                        probe3D.UpperValley = upVal;
                        newProbe = probe3D;
                    } else {
                        newProbe = new CgProbe(newProbe);
                        chrom.detectPeakIntensityInsideBorders(LipidomicsAnalyzer.findIndexByTime(loVal, chrom), LipidomicsAnalyzer.findIndexByTime(upVal, chrom));
                        chrom.GetBackground(LipidomicsConstants.getBackgroundScanRange());
                        chrom.GetAreaAndTime();
                        Analyzer.copyResults(newProbe, chrom, false);
                        newProbe.AreaStatus = CgAreaStatus.OK;
                    }
                    newProbe.Peak = peak;
                    if (newProbe.Peak < loVal) {
                        newProbe.Peak = loVal;
                    }
                    if (newProbe.Peak > upVal) {
                        newProbe.Peak = upVal;
                    }
                    newProbesOfIso.add(newProbe);
                    continue;
                }
                newProbesOfIso.add(newProbe);
            }
            if (newProbesOfIso.size() <= 0) break;
            newProbes.add(newProbesOfIso);
            for (CgProbe probe : newProbesOfIso) {
                totalArea += probe.Area;
            }
        }
        if (newProbes.size() == 0) {
            throw new CgException("A peak split cannot be performed because one of the partners does not deliver MS1 peak areas!");
        }
        set.setIsotopicProbes(newProbes);
        set.Area = totalArea;
    }

    private void checkIfSmoothingDeviatedPeakPosition(LipidomicsChromatogram chrom, CgProbe probe) {
        int peak = LipidomicsAnalyzer.findIndexByTime(probe.Peak, chrom);
        if (chrom.Value[peak][1] > 0.0f) {
            return;
        }
        int start = LipidomicsAnalyzer.findIndexByTime(probe.LowerValley, chrom);
        int stop = LipidomicsAnalyzer.findIndexByTime(probe.UpperValley, chrom);
        float highestInt = 0.0f;
        int newPeak = -1;
        for (int i = start; i <= stop; ++i) {
            if (!(chrom.Value[i][1] > highestInt)) continue;
            highestInt = chrom.Value[i][1];
            newPeak = i;
        }
        if (newPeak > -1) {
            probe.Peak = chrom.Value[newPeak][0];
        }
    }

    private LipidomicsChromatogram readASingleProfile(CgProbe aProbe, int msLevel, boolean smooth) throws CgException {
        Vector<CgProbe> theProbes = new Vector<CgProbe>();
        theProbes.add(aProbe);
        float mzRange = this.profileMzRange_;
        Vector<CgChromatogram> profiles = this.readProfiles(theProbes, mzRange, this.profileTimeTolerance_, 5.0f, this.profileSmoothRange_, this.profileSmoothRepeats_, this.profileSmoothRange_, this.profileMeanSmoothRepeats_, msLevel, smooth);
        LipidomicsChromatogram profile = new LipidomicsChromatogram(profiles.get(0));
        if (this.justZeroValues(profile)) {
            profiles = this.readProfiles(theProbes, mzRange, this.broaderProfileTimeTolerance_, 5.0f, this.profileSmoothRange_, this.profileSmoothRepeats_, this.profileSmoothRange_, this.profileMeanSmoothRepeats_, msLevel, smooth);
            profile = new LipidomicsChromatogram(profiles.get(0));
        }
        return profile;
    }

    private CgProbe getProfileProbeWithoutQualityCheck(CgProbe probe, float startMz, float stopMz, int msLevel) throws CgException {
        LipidomicsChromatogram profile = this.readASingleProfile(probe, msLevel, false);
        profile.LoValley = LipidomicsAnalyzer.findIndexByTime(startMz, profile);
        profile.UpValley = LipidomicsAnalyzer.findIndexByTime(stopMz, profile);
        profile.Good = true;
        profile.detectPeakIntensityInsideBorders(LipidomicsAnalyzer.findIndexByTime(startMz, profile), LipidomicsAnalyzer.findIndexByTime(stopMz, profile));
        CgProbe profileProbe = new CgProbe(0, probe.Charge);
        profileProbe = LipidomicsAnalyzer.copyResults(profileProbe, profile, true);
        return profileProbe;
    }

    public Hashtable<Integer, Boolean> prepareMSnSpectraCache(float startMz, float stopMz, float startTime, float stopTime) throws CgException {
        return this.reader_.prepareMSnSpectraCache(startMz, stopMz, startTime, stopTime, LipidomicsConstants.getMs2MinIntsForNoiseRemoval());
    }

    public Hashtable<Integer, Boolean> checkMSnLevels() {
        Hashtable<Integer, Hashtable<Integer, String>> cache = this.reader_.getMSnSpectraCache();
        Hashtable<Integer, Boolean> availableLevels = new Hashtable<Integer, Boolean>();
        for (Integer msLevel : cache.keySet()) {
            availableLevels.put(msLevel, true);
        }
        return availableLevels;
    }

    private static float calculateShotgunIntensity(CgChromatogram cgChrom, int shotgunType) {
        Vector<Float> ints = new Vector<Float>();
        float sum = 0.0f;
        for (int i = 0; i != cgChrom.Value.length; ++i) {
            sum += cgChrom.Value[i][1];
            if (LipidomicsConstants.isShotgunIntensityRemoval() && !(cgChrom.Value[i][1] > 0.0f)) continue;
            ints.add(Float.valueOf(cgChrom.Value[i][1]));
        }
        if (LipidomicsConstants.isShotgunIntensityRemoval() && LipidomicsConstants.getShotgunRelIntCutoff() > 0.0f) {
            float cutoff = sum * LipidomicsConstants.getShotgunRelIntCutoff() / (float)ints.size();
            Vector<Float> intermediate = new Vector<Float>();
            for (Float inten : ints) {
                if (!(inten.floatValue() > cutoff)) continue;
                intermediate.add(inten);
            }
        }
        float intensity = 0.0f;
        float[] intValues = new float[ints.size()];
        for (int i = 0; i != ints.size(); ++i) {
            intValues[i] = ((Float)ints.get(i)).floatValue();
        }
        if (shotgunType == 0) {
            intensity = Calculator.mean(intValues);
        } else if (shotgunType == 1) {
            intensity = Calculator.median(intValues).floatValue();
        } else if (shotgunType == 2) {
            intensity = sum;
        }
        return intensity;
    }
}

