/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.analysis.ComparativeNameExtractor;
import at.tugraz.genome.lda.exception.AbsoluteSettingsInputException;
import at.tugraz.genome.lda.swing.ExpVolumeListener;
import at.tugraz.genome.lda.swing.ExpVolumeSettingsPanel;
import at.tugraz.genome.lda.swing.GroupsPanel;
import at.tugraz.genome.lda.swing.LipidClassSettingsPanel;
import at.tugraz.genome.lda.vos.AbsoluteSettingsVO;
import at.tugraz.genome.lda.vos.LipidClassSettingVO;
import at.tugraz.genome.lda.vos.ProbeVolConcVO;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class AbsoluteQuantSettingsPanel
extends JPanel
implements ExpVolumeListener {
    private static final long serialVersionUID = -7145044539526127998L;
    private JPanel inputPanel_;
    private JTabbedPane lipidClassesTabs_;
    private JTabbedPane experimentTabs_;
    private Hashtable<String, ExpVolumeSettingsPanel> volumeSettings_;
    private Hashtable<String, LipidClassSettingsPanel> classSettings_;
    private GroupsPanel groupsPanel_;
    private ComparativeNameExtractor extractor_;

    public AbsoluteQuantSettingsPanel() {
        this.initComponents();
    }

    public AbsoluteQuantSettingsPanel(GroupsPanel groupsPanel) {
        this();
        this.groupsPanel_ = groupsPanel;
    }

    private void initComponents() {
        this.inputPanel_ = new JPanel();
        this.inputPanel_.setLayout(new GridBagLayout());
        this.add(this.inputPanel_);
    }

    public void showSettingsPanel(ComparativeNameExtractor extractor) {
        this.extractor_ = extractor;
        this.initTabbedPanes();
        this.invalidate();
        this.updateUI();
    }

    public void hideSettingsPanel() {
        this.inputPanel_.removeAll();
        this.volumeSettings_ = null;
        this.classSettings_ = null;
        this.invalidate();
        this.updateUI();
    }

    private void initTabbedPanes() {
        this.inputPanel_.removeAll();
        this.lipidClassesTabs_ = new JTabbedPane();
        this.experimentTabs_ = new JTabbedPane();
        this.classSettings_ = new Hashtable();
        this.volumeSettings_ = new Hashtable();
        int count = 0;
        for (String lipidClass : this.extractor_.getLipidClasses()) {
            LipidClassSettingsPanel classSettings = new LipidClassSettingsPanel(lipidClass, this.extractor_, this.groupsPanel_);
            this.classSettings_.put(lipidClass, classSettings);
            this.lipidClassesTabs_.addTab(lipidClass, classSettings);
            this.lipidClassesTabs_.setToolTipTextAt(count, "<html>Standard settings for " + lipidClass + "</html>");
            ++count;
        }
        this.inputPanel_.add((Component)this.lipidClassesTabs_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 0), 0, 0));
        count = 0;
        for (String expName : this.extractor_.getExpNamesInSequence()) {
            ExpVolumeSettingsPanel expVolSettings = new ExpVolumeSettingsPanel(expName, this);
            this.volumeSettings_.put(expName, expVolSettings);
            this.experimentTabs_.addTab(this.extractor_.getExpNames().get(expName), expVolSettings);
            this.experimentTabs_.setToolTipTextAt(count, "<html>Volume and concentration settings for experiment " + expName + "</html>");
            ++count;
        }
        this.inputPanel_.add((Component)this.experimentTabs_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 0), 0, 0));
    }

    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void applyVolumeSettingsToAll(String expirementName) {
        this.applySettingsToAll(expirementName, true);
    }

    @Override
    public void applyProteinLipidSettingsToAll(String expirementName) {
        this.applySettingsToAll(expirementName, false);
    }

    @Override
    public void applyVolumeSettingsToGroup(String expirementName) {
        this.applySettingsToGroup(expirementName, true);
    }

    @Override
    public void applyProteinLipidSettingsToGroup(String expirementName) {
        this.applySettingsToGroup(expirementName, false);
    }

    public void applySettingsToAll(String expirementName, boolean volume) {
        ExpVolumeSettingsPanel panel = this.volumeSettings_.get(expirementName);
        for (String expName : this.extractor_.getExpNamesInSequence()) {
            if (expName.equalsIgnoreCase(expirementName)) continue;
            if (volume) {
                this.volumeSettings_.get(expName).setVolumeInputValues(panel);
                continue;
            }
            this.volumeSettings_.get(expName).setProteinLipidContentValues(panel);
        }
        this.invalidate();
        this.updateUI();
    }

    private void applySettingsToGroup(String expirementName, boolean volume) {
        ExpVolumeSettingsPanel panel = this.volumeSettings_.get(expirementName);
        Set<String> exps = this.groupsPanel_.getExpsOfGroupOneExpBelongsTo(expirementName, this.extractor_.getExpNamesInSequence());
        if (exps.size() > 0) {
            for (String expName : exps) {
                if (expName.equalsIgnoreCase(expirementName)) continue;
                if (volume) {
                    this.volumeSettings_.get(expName).setVolumeInputValues(panel);
                    continue;
                }
                this.volumeSettings_.get(expName).setProteinLipidContentValues(panel);
            }
            this.invalidate();
            this.updateUI();
        } else {
            new WarningMessage(new JFrame(), "Warning", "This experiment does not belong to any group");
        }
    }

    public Hashtable<String, ExpVolumeSettingsPanel> getVolumeSettings() {
        return this.volumeSettings_;
    }

    public Hashtable<String, LipidClassSettingsPanel> getClassSettings() {
        return this.classSettings_;
    }

    public void cleanVolumeSettings() {
        for (ExpVolumeSettingsPanel volSets : this.volumeSettings_.values()) {
            volSets.cleanSettings();
        }
    }

    public void cleanClassSettings() {
        for (LipidClassSettingsPanel classSet : this.classSettings_.values()) {
            classSet.cleanSettings();
        }
    }

    public AbsoluteSettingsVO getSettingsVO() throws AbsoluteSettingsInputException {
        Hashtable<String, ProbeVolConcVO> probeVols = new Hashtable<String, ProbeVolConcVO>();
        Hashtable<String, LipidClassSettingVO> standSet = new Hashtable<String, LipidClassSettingVO>();
        boolean foundProteinConcOnce = false;
        boolean foundNeutralLipidConcOnce = false;
        boolean foundSampleWeightOnce = false;
        boolean foundProteinConcAll = true;
        boolean foundNeutralLipidConcAll = true;
        boolean foundSampleWeightAll = true;
        for (String string : this.volumeSettings_.keySet()) {
            ProbeVolConcVO probeVol = this.volumeSettings_.get(string).getSettingsVO();
            probeVols.put(string, probeVol);
            if (probeVol.getProteinConc() == null) {
                foundProteinConcAll = false;
            } else {
                foundProteinConcOnce = true;
            }
            if (probeVol.getNeutralLipidConc() == null) {
                foundNeutralLipidConcAll = false;
            } else {
                foundNeutralLipidConcOnce = true;
            }
            if (probeVol.getSampleWeight() == null) {
                foundSampleWeightAll = false;
                continue;
            }
            foundSampleWeightOnce = true;
        }
        if (foundProteinConcOnce && !foundProteinConcAll) {
            throw new AbsoluteSettingsInputException("The protein concentration has to be set for all experiments or for none");
        }
        if (foundNeutralLipidConcOnce && !foundNeutralLipidConcAll) {
            throw new AbsoluteSettingsInputException("The neutral lipid concentration has to be set for all experiments or for none");
        }
        if (foundSampleWeightOnce && !foundSampleWeightAll) {
            throw new AbsoluteSettingsInputException("The sample weight has to be set for all experiments or for none");
        }
        Hashtable<String, String> chosenClassLookup = new Hashtable<String, String>();
        for (String className : this.classSettings_.keySet()) {
            String chosenClass = this.getChosenClassLookup(className);
            LipidClassSettingVO classVO = this.classSettings_.get(chosenClass).getSettings();
            standSet.put(className, classVO);
            chosenClassLookup.put(className, chosenClass);
        }
        AbsoluteSettingsVO absoluteSettingsVO = new AbsoluteSettingsVO(probeVols, standSet, chosenClassLookup);
        return absoluteSettingsVO;
    }

    public String getChosenClassLookup(String className) {
        return this.classSettings_ == null ? className : this.classSettings_.get(className).getChosenClass();
    }
}

