/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.Settings;
import at.tugraz.genome.lda.analysis.SampleLookup;
import at.tugraz.genome.lda.swing.ColorChooserDialog;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class BarChart
extends JPanel {
    private static final long serialVersionUID = 5143957226504883251L;
    private boolean doubleSided_;
    private boolean logarithmic_;
    private double lowestValue_;
    private double highestValue_;
    private Hashtable<String, Hashtable<String, Double>> valuesToPaint_;
    private Hashtable<String, Hashtable<String, Double>> sdsToPaint_;
    private String title_;
    private String subTitle_;
    private String normalizationText_;
    private Vector<String> molNames_;
    private Vector<String> originalValueNames_;
    SampleLookup sampleLookup_;
    private boolean subTitleHeightChanged_;
    private int leftMargin_ = 80;
    private int bottomMargin_ = 10;
    private int rightMargin_ = 15;
    private int topMargin_ = 30;
    private int xAxeDescrMargin_ = 5;
    private int roundValue_;
    private int marginLegend = 8;
    private String yAxisText_;
    private String sdText_;
    ColorChooserDialog colors_;
    private int w0_;
    private int yLegendSize_;
    private int yLegendEntryHeight_;
    private int longestYLegend_;
    private int itemsYLegendRow_;
    private Rectangle rectToDraw_ = null;
    private int colorType_;
    protected boolean ignorePlatformSettings_;

    public BarChart(boolean doubleSided, boolean logarithmic, Hashtable<String, Hashtable<String, Double>> valuesToPaint, Hashtable<String, Hashtable<String, Double>> sdsToPaint, String title, String subTitle, String normalizationText, Vector<String> sortedMolNames, SampleLookup sampleLookup, Vector<String> sortedValueNames, double lowestTotalVale, double highestTotalValue, String yAxisText, String sdText, ColorChooserDialog colorChooser_, int colorType) {
        this.sampleLookup_ = sampleLookup;
        this.doubleSided_ = doubleSided;
        this.logarithmic_ = logarithmic;
        this.lowestValue_ = lowestTotalVale;
        this.highestValue_ = highestTotalValue;
        this.title_ = title;
        this.subTitle_ = subTitle;
        this.normalizationText_ = normalizationText;
        this.molNames_ = sortedMolNames;
        this.valuesToPaint_ = valuesToPaint;
        this.sdsToPaint_ = sdsToPaint;
        this.colors_ = colorChooser_;
        this.sdText_ = sdText;
        if (sortedValueNames != null) {
            this.originalValueNames_ = sortedValueNames;
        } else {
            this.originalValueNames_ = new Vector<String>(this.valuesToPaint_.keySet());
            Collections.sort(this.originalValueNames_);
        }
        this.yAxisText_ = "[AU]";
        if (yAxisText != null && yAxisText.length() > 0) {
            this.yAxisText_ = yAxisText;
        }
        this.subTitleHeightChanged_ = false;
        MyListener myListener = new MyListener();
        this.addMouseListener(myListener);
        this.addMouseMotionListener(myListener);
        this.colorType_ = colorType;
        this.ignorePlatformSettings_ = false;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.drawBarchart(g);
    }

    public void drawBarchart(Graphics g, boolean ignorePlatformSpecificSettings) {
        if (ignorePlatformSpecificSettings) {
            this.ignorePlatformSettings_ = true;
        }
        this.drawBarchart(g);
        if (ignorePlatformSpecificSettings) {
            this.ignorePlatformSettings_ = false;
        }
    }

    public void drawBarchart(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawChart(g2);
    }

    public void drawChart(Graphics2D g2) {
        String s;
        Font bigFont = new Font("SansSerif", 0, 200);
        g2.setFont(bigFont);
        FontMetrics fm2 = g2.getFontMetrics();
        g2.setFont(new Font("SansSerif", 0, 10));
        FontMetrics fmSmall = g2.getFontMetrics();
        g2.setColor(Color.BLACK);
        g2.setFont(new Font("SansSerif", 0, 12));
        FontMetrics fm = g2.getFontMetrics();
        int longestName = 0;
        Vector<String> xDescrNames = BarChart.extractDisplayNames(this.sampleLookup_, this.originalValueNames_);
        if (this.valuesToPaint_.size() > 1) {
            xDescrNames = this.molNames_;
        }
        for (String name : xDescrNames) {
            int sw = fm.stringWidth(name);
            if (sw <= longestName) continue;
            longestName = sw;
        }
        this.w0_ = this.getWidth() - this.leftMargin_ - this.rightMargin_;
        int subTitleHeight = 0;
        if (this.subTitle_ != null && this.subTitle_.length() > 0) {
            g2.setFont(new Font("SansSerif", 0, 10));
            if (!this.subTitleHeightChanged_) {
                this.topMargin_ += fmSmall.getHeight() + 1;
                this.subTitleHeightChanged_ = true;
            }
            subTitleHeight = fmSmall.getHeight() + 1;
            g2.drawString(this.subTitle_, this.leftMargin_ + this.w0_ / 2 - fmSmall.stringWidth(this.subTitle_) / 2, this.topMargin_ - 1 - fmSmall.getHeight());
        }
        g2.setFont(new Font("SansSerif", 1, 14));
        FontMetrics fmBold = g2.getFontMetrics();
        g2.drawString(this.title_, this.leftMargin_ + this.w0_ / 2 - fmBold.stringWidth(this.title_) / 2, this.topMargin_ - 1 - fm.getHeight() - subTitleHeight);
        g2.setFont(new Font("SansSerif", 0, 10));
        int sizeForOnePart = this.w0_ / this.originalValueNames_.size();
        int barDivisor = this.valuesToPaint_.size() * 2 + 1;
        this.yLegendSize_ = 0;
        int coloredRectWidth = fm.getHeight() - 4;
        int marginBetweenRectAndLegend = 4;
        this.yLegendEntryHeight_ = fm.getHeight();
        this.longestYLegend_ = 0;
        if (this.valuesToPaint_.size() > 1) {
            for (String valueName : BarChart.extractDisplayNames(this.sampleLookup_, this.originalValueNames_)) {
                int sw = fm.stringWidth(valueName);
                if (sw <= this.longestYLegend_) continue;
                this.longestYLegend_ = sw;
            }
            this.longestYLegend_ += coloredRectWidth + marginBetweenRectAndLegend + this.marginLegend;
            this.itemsYLegendRow_ = this.w0_ / this.longestYLegend_;
            sizeForOnePart = this.w0_ / this.valuesToPaint_.size();
            barDivisor = this.originalValueNames_.size() * 2 + 1;
            int nrRows = this.originalValueNames_.size() / this.itemsYLegendRow_;
            if (this.originalValueNames_.size() % this.itemsYLegendRow_ != 0) {
                ++nrRows;
            }
            this.yLegendSize_ = this.yLegendEntryHeight_ * nrRows;
            for (int i = 0; i != this.originalValueNames_.size(); ++i) {
                int row = i / this.itemsYLegendRow_;
                int column = i % this.itemsYLegendRow_;
                Color myColor = this.colors_.getColor(this.colorType_, this.originalValueNames_.get(i));
                if (myColor.equals(Color.WHITE)) {
                    g2.drawRect(this.leftMargin_ + this.longestYLegend_ * column, this.getHeight() - this.bottomMargin_ - (nrRows - row - 1) * this.yLegendEntryHeight_ - coloredRectWidth, coloredRectWidth, coloredRectWidth);
                } else {
                    g2.setColor(this.colors_.getColor(this.colorType_, this.originalValueNames_.get(i)));
                    g2.fillRect(this.leftMargin_ + this.longestYLegend_ * column, this.getHeight() - this.bottomMargin_ - (nrRows - row - 1) * this.yLegendEntryHeight_ - coloredRectWidth, coloredRectWidth, coloredRectWidth);
                    g2.setColor(Color.BLACK);
                }
                g2.drawString(BarChart.extractDisplayNames(this.sampleLookup_, this.originalValueNames_).get(i), this.leftMargin_ + this.longestYLegend_ * column + coloredRectWidth + marginBetweenRectAndLegend, this.getHeight() - this.bottomMargin_ - (nrRows - 1 - row) * this.yLegendEntryHeight_);
            }
        } else {
            this.longestYLegend_ = fm.stringWidth(this.molNames_.get(0)) + coloredRectWidth + marginBetweenRectAndLegend + this.marginLegend;
            this.itemsYLegendRow_ = 1;
            this.yLegendSize_ = this.yLegendEntryHeight_;
            if (this.colors_.getColor(0, "").equals(Color.WHITE)) {
                g2.drawRect(this.leftMargin_, this.getHeight() - this.bottomMargin_ - coloredRectWidth, coloredRectWidth, coloredRectWidth);
            } else {
                g2.setColor(this.colors_.getColor(0, ""));
                g2.fillRect(this.leftMargin_, this.getHeight() - this.bottomMargin_ - coloredRectWidth, coloredRectWidth, coloredRectWidth);
                g2.setColor(Color.BLACK);
            }
            g2.drawString(this.molNames_.get(0), this.leftMargin_ + coloredRectWidth + marginBetweenRectAndLegend, this.getHeight() - this.bottomMargin_);
        }
        int sizeForOneBar = sizeForOnePart * 2 / barDivisor;
        double rotationAngle = -0.7853981633974483;
        int longestNameYExtension = (int)((double)longestName * Math.sin(-rotationAngle) + (double)fm.getHeight() * Math.cos(-rotationAngle));
        int topMarginToUse = this.topMargin_;
        if (this.doubleSided_) {
            topMarginToUse += longestNameYExtension - 5;
        }
        int h0 = this.getHeight() - topMarginToUse - this.bottomMargin_ - longestNameYExtension - this.yLegendSize_ - 6;
        int y0 = 0;
        int rangeY = h0;
        if (this.normalizationText_ != null && this.normalizationText_.length() > 0) {
            double standRotAngle = -1.5707963267948966;
            g2.setFont(new Font("SansSerif", 0, 10));
            int standX = fmSmall.getAscent() + 5;
            int standY = topMarginToUse + h0 / 2 + fmSmall.stringWidth(this.normalizationText_) / 2;
            if (this.useMacSpecificSettings()) {
                BufferedImage image = new BufferedImage(fm2.stringWidth(this.normalizationText_), fm2.getHeight(), 2);
                Graphics2D g22 = (Graphics2D)image.getGraphics();
                g22.setColor(Color.BLACK);
                g22.setFont(bigFont);
                g22.drawString(this.normalizationText_, 0, fm2.getAscent());
                int sw2 = fm2.stringWidth(this.normalizationText_);
                int swXExtension2 = (int)((double)sw2 * Math.cos(-standRotAngle));
                int swYExtension2 = (int)((double)sw2 * Math.sin(-standRotAngle));
                int shYExtension2 = (int)((double)fm2.getHeight() * Math.cos(-standRotAngle));
                int shXExtension2 = (int)((double)fm2.getHeight() * Math.sin(-standRotAngle));
                BufferedImage image2 = new BufferedImage(swXExtension2 + shXExtension2, swYExtension2 + shYExtension2, 2);
                Graphics2D g23 = (Graphics2D)image2.getGraphics();
                g23.rotate(standRotAngle);
                boolean normalStringXCoordinate2 = false;
                int normalStringYCoordinate2 = swYExtension2;
                double coordinateRadius2 = Math.sqrt(Math.pow(0.0, 2.0) + Math.pow(normalStringYCoordinate2, 2.0));
                double angle2 = Math.atan((double)normalStringYCoordinate2 / (double)normalStringXCoordinate2);
                g23.drawImage((Image)image, (int)(coordinateRadius2 * Math.cos(angle2 - standRotAngle)), (int)(coordinateRadius2 * Math.sin(angle2 - standRotAngle)), null);
                g23.rotate(-standRotAngle);
                g2.drawImage(image2.getScaledInstance(fmSmall.getHeight(), fmSmall.stringWidth(this.normalizationText_), 0), standX - fmSmall.getAscent(), standY - fmSmall.stringWidth(this.normalizationText_), null);
            } else {
                g2.rotate(standRotAngle);
                double standRadius = Math.sqrt(Math.pow(standX, 2.0) + Math.pow(standY, 2.0));
                double standAngle = Math.atan((double)standY / (double)standX);
                g2.drawString(this.normalizationText_, (int)(standRadius * Math.cos(standAngle - standRotAngle)), (int)(standRadius * Math.sin(standAngle - standRotAngle)));
                g2.rotate(-standRotAngle);
            }
        }
        if (this.doubleSided_) {
            y0 = h0 / 2 + topMarginToUse;
            rangeY = h0 / 2;
        } else {
            y0 = this.getHeight() - this.bottomMargin_ - longestNameYExtension - this.yLegendSize_ - 6;
        }
        g2.drawLine(this.leftMargin_ - 3, y0, this.leftMargin_ + this.w0_, y0);
        int yAxisYStart = this.getHeight() - this.bottomMargin_ + 3 - longestNameYExtension - this.yLegendSize_ - 6;
        if (this.doubleSided_) {
            yAxisYStart -= 3;
        }
        g2.drawLine(this.leftMargin_, yAxisYStart, this.leftMargin_, topMarginToUse);
        g2.drawLine(this.leftMargin_ - 2, topMarginToUse, this.leftMargin_ + 2, topMarginToUse);
        g2.drawLine(this.leftMargin_ - 2, topMarginToUse, this.leftMargin_, topMarginToUse - 5);
        g2.drawLine(this.leftMargin_ + 2, topMarginToUse, this.leftMargin_, topMarginToUse - 5);
        double in = 0.0;
        double din = 0.0;
        int x = this.leftMargin_;
        int j = fmSmall.stringWidth(this.yAxisText_);
        int yValue = y0 - h0 + 6;
        if (this.doubleSided_) {
            yValue += h0 / 2;
        }
        if (fmSmall.stringWidth(this.yAxisText_) >= x - 4 || this.sdText_ != null && this.sdText_.length() > 0) {
            yValue -= fmSmall.getHeight() - 2;
        }
        if (fmSmall.stringWidth(this.yAxisText_) >= x - 4 && this.sdText_ != null && this.sdText_.length() > 0 && this.doubleSided_) {
            yValue -= fmSmall.getHeight();
        }
        int axisDescrSpace = fmSmall.getHeight();
        if (fmSmall.stringWidth(this.yAxisText_) >= x - 4) {
            j = fmSmall.stringWidth(this.yAxisText_.substring(0, this.yAxisText_.lastIndexOf("[") - 1));
            g2.drawString(this.yAxisText_.substring(0, this.yAxisText_.lastIndexOf("[") - 1), x - j - 4, yValue);
            int unitWidth = fmSmall.stringWidth(this.yAxisText_.substring(this.yAxisText_.lastIndexOf("[")));
            g2.drawString(this.yAxisText_.substring(this.yAxisText_.lastIndexOf("[")), x - unitWidth - 4, yValue + fmSmall.getHeight());
            axisDescrSpace += fmSmall.getHeight();
        } else {
            g2.drawString(this.yAxisText_, x - j - 4, yValue);
        }
        if (this.sdText_ != null && this.sdText_.length() > 0) {
            j = fmSmall.stringWidth(this.sdText_);
            g2.drawString(this.sdText_, x - j - 4, yValue + axisDescrSpace);
        }
        int finalUsedYDescrSpace = yValue + axisDescrSpace + fmSmall.getHeight();
        double highestValueOfInterest = this.highestValue_;
        in = highestValueOfInterest / 10.0;
        if (this.doubleSided_) {
            if (this.highestValue_ < 1.0 / this.lowestValue_) {
                highestValueOfInterest = 1.0 / this.lowestValue_;
            }
            in = this.logarithmic_ ? Math.log10(highestValueOfInterest) / 10.0 : Math.log10(highestValueOfInterest) / Math.log10(2.0) / 10.0;
        }
        this.roundValue_ = 2;
        if (in < 1.0E-20) {
            din = 1.0E-20;
            this.roundValue_ = 20;
        } else if (in < 2.5E-20) {
            din = 2.5E-20;
            this.roundValue_ = 21;
        } else if (in < 5.0E-20) {
            din = 5.0E-20;
            this.roundValue_ = 20;
        } else if (in < 1.0E-19) {
            din = 1.0E-19;
            this.roundValue_ = 19;
        } else if (in < 2.5E-19) {
            din = 2.5E-19;
            this.roundValue_ = 20;
        } else if (in < 5.0E-19) {
            din = 5.0E-19;
            this.roundValue_ = 19;
        } else if (in < 1.0E-18) {
            din = 1.0E-18;
            this.roundValue_ = 18;
        } else if (in < 2.5E-18) {
            din = 2.5E-18;
            this.roundValue_ = 19;
        } else if (in < 5.0E-18) {
            din = 5.0E-18;
            this.roundValue_ = 18;
        } else if (in < 1.0E-17) {
            din = 1.0E-17;
            this.roundValue_ = 17;
        } else if (in < 2.5E-17) {
            din = 2.5E-17;
            this.roundValue_ = 18;
        } else if (in < 5.0E-17) {
            din = 5.0E-17;
            this.roundValue_ = 17;
        } else if (in < 1.0E-16) {
            din = 1.0E-16;
            this.roundValue_ = 16;
        } else if (in < 2.5E-16) {
            din = 2.5E-16;
            this.roundValue_ = 17;
        } else if (in < 5.0E-16) {
            din = 5.0E-16;
            this.roundValue_ = 16;
        } else if (in < 1.0E-15) {
            din = 1.0E-15;
            this.roundValue_ = 15;
        } else if (in < 2.5E-15) {
            din = 2.5E-15;
            this.roundValue_ = 16;
        } else if (in < 5.0E-15) {
            din = 5.0E-15;
            this.roundValue_ = 15;
        } else if (in < 1.0E-14) {
            din = 1.0E-14;
            this.roundValue_ = 14;
        } else if (in < 2.5E-14) {
            din = 2.5E-14;
            this.roundValue_ = 15;
        } else if (in < 5.0E-14) {
            din = 5.0E-14;
            this.roundValue_ = 14;
        } else if (in < 1.0E-13) {
            din = 1.0E-13;
            this.roundValue_ = 13;
        } else if (in < 2.5E-13) {
            din = 2.5E-13;
            this.roundValue_ = 14;
        } else if (in < 5.0E-13) {
            din = 5.0E-13;
            this.roundValue_ = 13;
        } else if (in < 1.0E-12) {
            din = 1.0E-12;
            this.roundValue_ = 12;
        } else if (in < 2.5E-12) {
            din = 2.5E-12;
            this.roundValue_ = 13;
        } else if (in < 5.0E-12) {
            din = 5.0E-12;
            this.roundValue_ = 12;
        } else if (in < 1.0E-11) {
            din = 1.0E-11;
            this.roundValue_ = 11;
        } else if (in < 2.5E-11) {
            din = 2.5E-11;
            this.roundValue_ = 12;
        } else if (in < 5.0E-11) {
            din = 5.0E-11;
            this.roundValue_ = 11;
        } else if (in < 1.0E-10) {
            din = 1.0E-10;
            this.roundValue_ = 10;
        } else if (in < 2.5E-10) {
            din = 2.5E-10;
            this.roundValue_ = 11;
        } else if (in < 5.0E-10) {
            din = 5.0E-10;
            this.roundValue_ = 10;
        } else if (in < 1.0E-9) {
            din = 1.0E-9;
            this.roundValue_ = 9;
        } else if (in < 2.5E-9) {
            din = 2.5E-9;
            this.roundValue_ = 10;
        } else if (in < 5.0E-9) {
            din = 5.0E-9;
            this.roundValue_ = 9;
        } else if (in < 1.0E-8) {
            din = 1.0E-8;
            this.roundValue_ = 8;
        } else if (in < 2.5E-8) {
            din = 2.5E-8;
            this.roundValue_ = 9;
        } else if (in < 5.0E-8) {
            din = 5.0E-8;
            this.roundValue_ = 8;
        } else if (in < 1.0E-7) {
            din = 1.0E-7;
            this.roundValue_ = 7;
        } else if (in < 2.5E-7) {
            din = 2.5E-7;
            this.roundValue_ = 8;
        } else if (in < 5.0E-7) {
            din = 5.0E-7;
            this.roundValue_ = 7;
        } else if (in < 1.0E-6) {
            din = 1.0E-6;
            this.roundValue_ = 6;
        } else if (in < 2.5E-6) {
            din = 2.5E-6;
            this.roundValue_ = 7;
        } else if (in < 5.0E-6) {
            din = 5.0E-6;
            this.roundValue_ = 6;
        } else if (in < 1.0E-5) {
            din = 1.0E-5;
            this.roundValue_ = 5;
        } else if (in < 2.5E-5) {
            din = 2.5E-5;
            this.roundValue_ = 6;
        } else if (in < 5.0E-5) {
            din = 5.0E-5;
            this.roundValue_ = 5;
        } else if (in < 1.0E-4) {
            din = 1.0E-4;
            this.roundValue_ = 4;
        } else if (in < 2.5E-4) {
            din = 2.5E-4;
            this.roundValue_ = 5;
        } else if (in < 5.0E-4) {
            din = 5.0E-4;
            this.roundValue_ = 4;
        } else if (in < 0.001) {
            din = 0.001;
            this.roundValue_ = 3;
        } else if (in < 0.0025) {
            din = 0.0025;
            this.roundValue_ = 4;
        } else if (in < 0.005) {
            din = 0.005;
            this.roundValue_ = 3;
        } else if (in < 0.01) {
            din = 0.01;
        } else if (in < 0.025) {
            din = 0.025;
            this.roundValue_ = 3;
        } else {
            din = in < 0.05 ? 0.05 : (in < 0.1 ? 0.1 : (in < 0.25 ? 0.25 : (in < 0.5 ? 0.5 : (in < 1.0 ? 1.0 : (in < 2.5 ? 2.5 : (in < 5.0 ? 5.0 : (in < 10.0 ? 10.0 : (in < 25.0 ? 25.0 : (in < 50.0 ? 50.0 : (in < 100.0 ? 100.0 : (in < 250.0 ? 250.0 : (in < 500.0 ? 500.0 : (in < 1000.0 ? 1000.0 : (in < 2500.0 ? 2500.0 : (in < 5000.0 ? 5000.0 : (in < 10000.0 ? 10000.0 : (in < 25000.0 ? 25000.0 : (in < 50000.0 ? 50000.0 : (in < 100000.0 ? 100000.0 : (in < 250000.0 ? 250000.0 : (in < 500000.0 ? 500000.0 : (in < 1000000.0 ? 1000000.0 : (in < 2500000.0 ? 2500000.0 : (in < 5000000.0 ? 5000000.0 : (in < 1.0E7 ? 1.0E7 : (in < 2.5E7 ? 2.5E7 : (in < 5.0E7 ? 5.0E7 : (in < 1.0E8 ? 1.0E8 : (in < 2.5E8 ? 2.5E8 : (in < 5.0E8 ? 5.0E8 : (in < 1.0E9 ? 1.0E9 : (in < 2.5E9 ? 2.5E9 : (in < 5.0E9 ? 5.0E9 : (in < 1.0E10 ? 1.0E10 : (in < 2.5E10 ? 2.5E10 : (in < 5.0E10 ? 5.0E10 : (in < 1.0E11 ? 1.0E11 : (in < 2.5E11 ? 2.5E11 : (in < 5.0E11 ? 5.0E11 : (in < 1.0E12 ? 1.0E12 : (in < 2.5E12 ? 2.5E12 : (in < 5.0E12 ? 5.0E12 : (in < 1.0E13 ? 1.0E13 : (in < 2.5E13 ? 2.5E13 : (in < 5.0E13 ? 5.0E13 : (in < 1.0E13 ? 1.0E13 : (in < 2.5E13 ? 2.5E13 : (in < 5.0E13 ? 5.0E13 : (in < 1.0E13 ? 1.0E13 : (in < 2.5E13 ? 2.5E13 : (in < 5.0E13 ? 5.0E13 : (in < 1.0E13 ? 1.0E13 : (in < 2.5E13 ? 2.5E13 : (in < 5.0E13 ? 5.0E13 : (in < 1.0E13 ? 1.0E13 : (in < 2.5E13 ? 2.5E13 : (in < 5.0E13 ? 5.0E13 : 1.0E18)))))))))))))))))))))))))))))))))))))))))))))))))))))))));
        }
        if (this.logarithmic_ && !this.doubleSided_) {
            din = 1.0;
        }
        int lowestExponent = this.getLowerOrHigherExponent(this.lowestValue_, 0, false);
        double valueRange = highestValueOfInterest - 0.0;
        if (this.doubleSided_) {
            if (this.logarithmic_) {
                for (valueRange = 0.0; valueRange < Math.log10(highestValueOfInterest); valueRange += din) {
                }
            } else {
                while (valueRange < Math.log10(highestValueOfInterest) / Math.log10(2.0)) {
                    valueRange += din;
                }
            }
        } else if (this.logarithmic_) {
            int highestExponent = this.getLowerOrHigherExponent(highestValueOfInterest, 0, true);
            valueRange = highestExponent - lowestExponent;
        }
        in = 0.0;
        int y = y0 - (int)((double)rangeY * in / valueRange);
        if (this.logarithmic_) {
            y = y0 - (int)((double)rangeY * in / valueRange);
        }
        while (y > y0 - rangeY && (y = y0 - (int)((double)rangeY * in / valueRange)) >= y0 - rangeY + 10 && !(in > Double.MAX_VALUE)) {
            long inLong;
            g2.drawLine(x, y, x - 3, y);
            s = "";
            s = this.doubleSided_ ? (this.logarithmic_ ? "1.0E" + String.valueOf(Double.toString(this.roundDBL(in, this.roundValue_))) : "2^" + String.valueOf(Double.toString(this.roundDBL(in, this.roundValue_)))) : (this.logarithmic_ ? "1.0E" + String.valueOf((int)in + lowestExponent) : (this.logarithmic_ && !this.doubleSided_ ? "1.0E" + String.valueOf((int)in) : (in < 1.0E7 && din > 3.0 ? ((inLong = (long)in) < 10000L ? Long.toString((long)in) : (inLong < 100000L ? Double.toString(this.roundDBL(in / 10000.0, this.roundValue_)) + "E4" : (inLong < 1000000L ? Double.toString(this.roundDBL(in / 100000.0, this.roundValue_)) + "E5" : Double.toString(this.roundDBL(in / 1000000.0, this.roundValue_)) + "E6"))) : Double.toString(this.roundDBL(in, this.roundValue_)))));
            int sw = fm.stringWidth(s);
            if (in == 0.0) {
                if (y > finalUsedYDescrSpace) {
                    g2.drawString(s, x - sw - 4, y);
                }
            } else if (y + 4 > finalUsedYDescrSpace) {
                g2.drawString(s, x - sw - 4, y + 4);
            }
            in += din;
        }
        if (this.doubleSided_) {
            for (in = -din; y < y0 + rangeY && (y = y0 - (int)((double)rangeY * in / valueRange)) <= y0 + rangeY - 10 && !(in > Double.MAX_VALUE); in -= din) {
                g2.drawLine(x, y, x - 3, y);
                s = "";
                s = this.logarithmic_ ? "1.0E" + String.valueOf(Double.toString(this.roundDBL(in, this.roundValue_))) : "2^" + String.valueOf(Double.toString(this.roundDBL(in, this.roundValue_)));
                int sw = fm.stringWidth(s);
                if (y <= finalUsedYDescrSpace) continue;
                g2.drawString(s, x - sw - 4, y + 4);
            }
        }
        int count = 0;
        int amountOfMolecules = this.valuesToPaint_.size();
        int halfSDSize = sizeForOneBar / 4;
        if (halfSDSize < 1) {
            halfSDSize = 1;
        }
        for (String molName : this.molNames_) {
            int expCount = 0;
            for (String name : this.originalValueNames_) {
                double value = 0.0;
                double lowerSdValue = Double.NEGATIVE_INFINITY;
                double upperSdValue = Double.NEGATIVE_INFINITY;
                int ySDStart = -1;
                int ySDStop = -1;
                int xBarStart = this.leftMargin_ + sizeForOnePart * count + sizeForOnePart / (barDivisor * 2) + expCount * sizeForOneBar;
                if (this.doubleSided_) {
                    value = -1.0;
                }
                if (this.valuesToPaint_.get(molName).containsKey(name)) {
                    value = this.valuesToPaint_.get(molName).get(name);
                }
                if (this.sdsToPaint_ != null && this.sdsToPaint_.get(molName).containsKey(name)) {
                    double sdValue = this.sdsToPaint_.get(molName).get(name);
                    lowerSdValue = value - sdValue;
                    upperSdValue = value + sdValue;
                }
                if (this.doubleSided_) {
                    double rightValue = value;
                    if (this.logarithmic_) {
                        rightValue = Math.log10(rightValue);
                        if (upperSdValue > Double.NEGATIVE_INFINITY) {
                            lowerSdValue = Math.log10(lowerSdValue);
                            upperSdValue = Math.log10(upperSdValue);
                        }
                    } else {
                        rightValue = Math.log10(rightValue) / Math.log10(2.0);
                        if (upperSdValue > Double.NEGATIVE_INFINITY) {
                            lowerSdValue = Math.log10(lowerSdValue) / Math.log10(2.0);
                            upperSdValue = Math.log10(upperSdValue) / Math.log10(2.0);
                        }
                    }
                    int height = (int)((double)rangeY * rightValue / valueRange);
                    if (rightValue > 0.0) {
                        this.drawFilledBar(g2, name, xBarStart, y0 - height, sizeForOneBar, height);
                    } else {
                        this.drawFilledBar(g2, name, xBarStart, y0, sizeForOneBar, -height);
                    }
                    if (upperSdValue > Double.NEGATIVE_INFINITY) {
                        ySDStart = y0 - (int)((double)rangeY * lowerSdValue / valueRange);
                        ySDStop = y0 - (int)((double)rangeY * upperSdValue / valueRange);
                    }
                } else {
                    int height = (int)((double)rangeY * value / valueRange);
                    if (this.logarithmic_) {
                        height = (int)((double)rangeY * Math.log10(value * Math.pow(10.0, -lowestExponent)) / valueRange);
                        if (upperSdValue > Double.NEGATIVE_INFINITY) {
                            lowerSdValue = Math.log10(lowerSdValue * Math.pow(10.0, -lowestExponent));
                            upperSdValue = Math.log10(upperSdValue * Math.pow(10.0, -lowestExponent));
                        }
                    }
                    this.drawFilledBar(g2, name, xBarStart, y0 - height, sizeForOneBar, height);
                    if (upperSdValue > Double.NEGATIVE_INFINITY) {
                        ySDStart = y0 - (int)((double)rangeY * lowerSdValue / valueRange);
                        if (ySDStart > y0) {
                            ySDStart = y0;
                        }
                        ySDStop = y0 - (int)((double)rangeY * upperSdValue / valueRange);
                    }
                }
                if (upperSdValue > Double.NEGATIVE_INFINITY) {
                    g2.drawLine(xBarStart + sizeForOneBar / 2, ySDStart, xBarStart + sizeForOneBar / 2, ySDStop);
                    g2.drawLine(xBarStart + sizeForOneBar / 2 - halfSDSize, ySDStart, xBarStart + sizeForOneBar / 2 + halfSDSize, ySDStart);
                    g2.drawLine(xBarStart + sizeForOneBar / 2 - halfSDSize, ySDStop, xBarStart + sizeForOneBar / 2 + halfSDSize, ySDStop);
                }
                if (amountOfMolecules == 1) {
                    ++count;
                    continue;
                }
                ++expCount;
            }
            if (amountOfMolecules <= 1) continue;
            ++count;
        }
        if (!this.useMacSpecificSettings()) {
            g2.rotate(rotationAngle);
        }
        count = 0;
        for (String name : xDescrNames) {
            int sw = fm.stringWidth(name);
            int swXExtension = (int)((double)sw * Math.cos(-rotationAngle));
            int swYExtension = (int)((double)sw * Math.sin(-rotationAngle));
            int shXExtension = (int)((double)fm.getAscent() * Math.sin(-rotationAngle));
            int shYExtension = (int)((double)fm.getAscent() * Math.cos(-rotationAngle));
            int lengthDifference = longestName - sw;
            int lengthDifferenceYExtension = (int)((double)lengthDifference * Math.sin(-rotationAngle));
            int normalStringXCoordinate = this.leftMargin_ + sizeForOnePart * count + sizeForOnePart / 2 - swXExtension / 2 + shXExtension / 2;
            int normalStringYCoordinate = this.getHeight() - this.bottomMargin_ - lengthDifferenceYExtension - this.yLegendSize_;
            double value = 0.0;
            if (this.doubleSided_) {
                value = -1.0;
            }
            boolean lower1 = false;
            double lowerValue = Double.MAX_VALUE;
            double upperValue = 0.0;
            if (this.valuesToPaint_.size() > 1) {
                for (String expName : this.originalValueNames_) {
                    double myValue;
                    if (!this.valuesToPaint_.get(name).containsKey(expName)) continue;
                    double upperMyValue = myValue = this.valuesToPaint_.get(name).get(expName).doubleValue();
                    double lowerMyValue = myValue;
                    if (myValue > 0.0 && this.sdsToPaint_ != null && this.sdsToPaint_.get(name).containsKey(expName)) {
                        double sd = this.sdsToPaint_.get(name).get(expName);
                        upperMyValue += sd;
                        lowerMyValue -= sd;
                    }
                    if (myValue > 0.0 && lowerMyValue < lowerValue) {
                        lowerValue = lowerMyValue;
                    }
                    if (upperMyValue > upperValue) {
                        upperValue = upperMyValue;
                    }
                    if (!this.doubleSided_ || !(myValue > 0.0) || !(myValue < 1.0)) continue;
                    lower1 = true;
                }
                value = this.doubleSided_ && lower1 && upperValue > 0.0 && 1.0 / lowerValue > upperValue ? lowerValue : upperValue;
            } else if (this.valuesToPaint_.values().iterator().next().containsKey(this.originalValueNames_.get(count))) {
                value = this.valuesToPaint_.values().iterator().next().get(this.originalValueNames_.get(count));
            }
            if (this.sdsToPaint_ != null && this.sdsToPaint_.values().iterator().next().containsKey(name)) {
                double sdValue = this.sdsToPaint_.values().iterator().next().get(name);
                if (value > 0.0 && !Double.isNaN(sdValue) && !Double.isInfinite(sdValue)) {
                    value = this.doubleSided_ && value < 1.0 ? (value -= sdValue) : (value += sdValue);
                }
            }
            if (this.doubleSided_ && value > 0.0) {
                double rightValue = value;
                rightValue = this.logarithmic_ ? Math.log10(rightValue) : Math.log10(rightValue) / Math.log10(2.0);
                normalStringYCoordinate = y0 - (int)((double)rangeY * rightValue / valueRange) - this.xAxeDescrMargin_;
                if (value > 0.0 && value < 1.0) {
                    normalStringYCoordinate = y0 - (int)((double)rangeY * rightValue / valueRange) + 2 * this.xAxeDescrMargin_ + swYExtension;
                }
            }
            double coordinateRadius = Math.sqrt(Math.pow(normalStringXCoordinate, 2.0) + Math.pow(normalStringYCoordinate, 2.0));
            double angle = Math.atan((double)normalStringYCoordinate / (double)normalStringXCoordinate);
            if (this.useMacSpecificSettings()) {
                BufferedImage image = new BufferedImage(fm2.stringWidth(name), fm2.getHeight(), 2);
                Graphics2D g22 = (Graphics2D)image.getGraphics();
                g22.setColor(Color.BLACK);
                g22.setFont(bigFont);
                g22.drawString(name, 0, fm2.getAscent());
                int sw2 = fm2.stringWidth(name);
                int swXExtension2 = (int)((double)sw2 * Math.cos(-rotationAngle));
                int swYExtension2 = (int)((double)sw2 * Math.sin(-rotationAngle));
                int shYExtension2 = (int)((double)fm2.getHeight() * Math.cos(-rotationAngle));
                int shXExtension2 = (int)((double)fm2.getHeight() * Math.sin(-rotationAngle));
                BufferedImage image2 = new BufferedImage(swXExtension2 + shXExtension2, swYExtension2 + shYExtension2, 2);
                Graphics2D g23 = (Graphics2D)image2.getGraphics();
                g23.rotate(rotationAngle);
                boolean normalStringXCoordinate2 = false;
                int normalStringYCoordinate2 = swYExtension2;
                double coordinateRadius2 = Math.sqrt(Math.pow(0.0, 2.0) + Math.pow(normalStringYCoordinate2, 2.0));
                double angle2 = Math.atan((double)normalStringYCoordinate2 / (double)normalStringXCoordinate2);
                g23.drawImage((Image)image, (int)(coordinateRadius2 * Math.cos(angle2 - rotationAngle)), (int)(coordinateRadius2 * Math.sin(angle2 - rotationAngle)), null);
                g23.rotate(-rotationAngle);
                g2.drawImage(image2.getScaledInstance(swXExtension + shXExtension, swYExtension + shYExtension, 0), normalStringXCoordinate - shXExtension, normalStringYCoordinate - swXExtension - shYExtension, null);
            } else {
                g2.drawString(name, (int)(coordinateRadius * Math.cos(angle - rotationAngle)), (int)(coordinateRadius * Math.sin(angle - rotationAngle)));
            }
            ++count;
        }
        if (!this.useMacSpecificSettings()) {
            g2.rotate(-rotationAngle);
        }
    }

    private void drawFilledBar(Graphics2D g2, String colName, int x, int y, int w, int h) {
        Color color = Color.WHITE;
        color = this.valuesToPaint_.size() > 1 ? this.colors_.getColor(this.colorType_, colName) : this.colors_.getColor(0, "");
        if (!color.equals(Color.WHITE)) {
            g2.setColor(color);
            g2.fillRect(x, y, w, h);
            g2.setColor(Color.BLACK);
        }
        g2.drawRect(x, y, w, h);
    }

    protected int getLowerOrHigherExponent(double value, int exponentDivFactor, boolean higher) {
        return this.getLowerOrHigherExponent(value, exponentDivFactor, 10.0, higher);
    }

    protected int getLowerOrHigherExponent(double value, int exponentDivFactor, double basis, boolean higher) {
        int add = 0;
        if (higher) {
            ++add;
        }
        if (value / basis > 1.0) {
            return this.getLowerOrHigherExponent(value / basis, ++exponentDivFactor, basis, higher);
        }
        if (value / 1.0 > 1.0) {
            return exponentDivFactor + add;
        }
        return this.getLowerOrHigherExponent(value * basis, --exponentDivFactor, basis, higher);
    }

    private double roundDBL(double targetDBL, int decimalPlace) {
        BigDecimal bd = new BigDecimal(targetDBL);
        bd = bd.setScale(decimalPlace, 4);
        return bd.doubleValue();
    }

    public BufferedImage getImage() {
        BufferedImage chart = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        this.drawBarchart(chart.getGraphics());
        return chart;
    }

    public int getRoundValue() {
        return this.roundValue_;
    }

    private void activateColorChooser(String cellName) {
        String title = "Choose your color for ";
        title = this.colorType_ == 0 ? title + "default" : (this.colorType_ == 2 ? title + cellName : title + this.sampleLookup_.getDisplayName(cellName));
        this.colors_.showColorChooser(title, this.colorType_, cellName);
    }

    private void drawARectangle(Graphics2D g2) {
        g2.setColor(Color.BLACK);
        g2.drawRect(this.rectToDraw_.x, this.rectToDraw_.y, this.rectToDraw_.width, this.rectToDraw_.height);
    }

    private boolean isInColorRegion(int x, int y) {
        boolean isThere = false;
        if (x > this.leftMargin_ - this.marginLegend / 2 && x < this.leftMargin_ + this.w0_ - this.marginLegend / 2 && y > this.getHeight() - this.bottomMargin_ - this.yLegendSize_ + 2 && y < this.getHeight() - this.bottomMargin_ + 2) {
            isThere = true;
        }
        return isThere;
    }

    private String getYLegendCellName(int x, int y) {
        int[] cellPosition = this.getYLegendCellPosition(x, y);
        return this.getCellNameForPosition(cellPosition);
    }

    private String getCellNameForPosition(int[] cellPosition) {
        String itemName = null;
        int amountOfItems = 1;
        if (this.valuesToPaint_.size() > 1) {
            amountOfItems = this.originalValueNames_.size();
        }
        if (cellPosition[0] > -1 && cellPosition[0] < this.itemsYLegendRow_ && cellPosition[1] > -1 && cellPosition[1] * this.itemsYLegendRow_ + cellPosition[0] < amountOfItems) {
            itemName = this.valuesToPaint_.size() > 1 ? this.originalValueNames_.get(cellPosition[1] * this.itemsYLegendRow_ + cellPosition[0]) : this.molNames_.get(0);
        }
        return itemName;
    }

    private int[] getYLegendCellPosition(int x, int y) {
        int[] positions = new int[]{this.getYLegendColumn(x), this.getYLegendRow(y)};
        return positions;
    }

    private int getYLegendRow(int y) {
        int row = y / this.yLegendEntryHeight_;
        return row;
    }

    private int getYLegendColumn(int x) {
        int column = x / this.longestYLegend_;
        return column;
    }

    private Rectangle getRectangleForCell(int column, int row) {
        Rectangle rect = new Rectangle(this.leftMargin_ - this.marginLegend / 2 + column * this.longestYLegend_, this.getHeight() - this.bottomMargin_ - this.yLegendSize_ + 2 + this.yLegendEntryHeight_ * row, this.longestYLegend_, this.yLegendEntryHeight_);
        return rect;
    }

    public static Vector<String> extractDisplayNames(SampleLookup sampleLookup, Vector<String> originalValueNames) {
        Vector<String> displayNames = new Vector();
        if (sampleLookup == null) {
            displayNames = new Vector<String>(originalValueNames);
        } else {
            for (String name : originalValueNames) {
                displayNames.add(sampleLookup.getDisplayName(name));
            }
        }
        return displayNames;
    }

    private boolean useMacSpecificSettings() {
        return !this.ignorePlatformSettings_ && Settings.isOSMacAndJavaLookAndFeel();
    }

    private class MyListener
    extends MouseInputAdapter {
        private MyListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            Graphics2D g2 = (Graphics2D)e.getComponent().getGraphics();
            if (BarChart.this.rectToDraw_ != null) {
                g2.setColor(Color.WHITE);
                g2.drawRect(((BarChart)BarChart.this).rectToDraw_.x, ((BarChart)BarChart.this).rectToDraw_.y, ((BarChart)BarChart.this).rectToDraw_.width, ((BarChart)BarChart.this).rectToDraw_.height);
            }
            if (BarChart.this.isInColorRegion(x, y)) {
                int yInLegend = y - (BarChart.this.getHeight() - BarChart.this.bottomMargin_ - BarChart.this.yLegendSize_ + 2);
                int xInLegend = x - BarChart.this.leftMargin_ + BarChart.this.marginLegend / 2;
                int[] cellPosition = BarChart.this.getYLegendCellPosition(xInLegend, yInLegend);
                String yLegendCellName = BarChart.this.getCellNameForPosition(cellPosition);
                if (yLegendCellName != null && yLegendCellName.length() > 0) {
                    BarChart.this.rectToDraw_ = BarChart.this.getRectangleForCell(cellPosition[0], cellPosition[1]);
                    BarChart.this.drawARectangle(g2);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int y;
            int x = e.getX();
            if (BarChart.this.isInColorRegion(x, y = e.getY())) {
                int yInLegend = y - (BarChart.this.getHeight() - BarChart.this.bottomMargin_ - BarChart.this.yLegendSize_ + 2);
                int xInLegend = x - BarChart.this.leftMargin_ + BarChart.this.marginLegend / 2;
                String yLegendCellName = BarChart.this.getYLegendCellName(xInLegend, yInLegend);
                if (yLegendCellName != null && yLegendCellName.length() > 0) {
                    BarChart.this.activateColorChooser(yLegendCellName);
                }
            }
        }
    }
}

