/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.analysis.ComparativeAnalysis;
import at.tugraz.genome.lda.analysis.SampleLookup;
import at.tugraz.genome.lda.analysis.exception.CalculationNotPossibleException;
import at.tugraz.genome.lda.swing.BarChartPainter;
import at.tugraz.genome.lda.swing.ColorChooserDialog;
import at.tugraz.genome.lda.swing.HeatMapDrawing;
import at.tugraz.genome.lda.swing.ResultDisplaySettings;
import at.tugraz.genome.lda.swing.ResultSelectionSettings;
import at.tugraz.genome.lda.swing.StandardSelectionOverview;
import at.tugraz.genome.lda.utils.DoubleCalculator;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.ResultCompGroupVO;
import at.tugraz.genome.lda.vos.ResultCompVO;
import at.tugraz.genome.lda.vos.ResultDisplaySettingsVO;
import at.tugraz.genome.maspectras.utils.Calculator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ClassesOverviewPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 7904365893705072363L;
    private JCheckBox considerStandard_;
    private JCheckBox considerDilution_;
    private JButton buttonAccept_;
    private JButton buttonSearches_;
    private JPanel centerPanel_;
    private Vector<String> expNames_;
    private Hashtable<String, String> fromShortToExpName_;
    private ResultSelectionSettings selectionSettings_;
    private SampleLookup sampleLookup_;
    private Hashtable<String, ResultDisplaySettings> displaySettings_;
    private StandardSelectionOverview standardSelection_;
    private Hashtable<String, Hashtable<String, Integer>> isLookup_;
    private Hashtable<String, Hashtable<String, Integer>> esLookup_;
    private Hashtable<String, Hashtable<String, Hashtable<String, ResultCompVO>>> analysisResults_;
    private Hashtable<String, HeatMapDrawing> selectedIsotopes_;
    private ComparativeAnalysis analysisModule_;
    private ColorChooserDialog colorChooser_;

    public ClassesOverviewPanel(Vector<String> expNames, SampleLookup sampleLookup, ComparativeAnalysis analysisModule, Hashtable<String, ResultDisplaySettings> displaySettings, Hashtable<String, HeatMapDrawing> selectedIsotopes, Hashtable<String, Hashtable<String, Integer>> isLookup, Hashtable<String, Hashtable<String, Integer>> esLookup, Hashtable<String, Hashtable<String, Hashtable<String, ResultCompVO>>> analysisResults, ColorChooserDialog colorChooser) {
        this.expNames_ = expNames;
        this.sampleLookup_ = sampleLookup;
        this.displaySettings_ = displaySettings;
        this.isLookup_ = isLookup;
        this.esLookup_ = esLookup;
        this.analysisResults_ = analysisResults;
        this.selectedIsotopes_ = selectedIsotopes;
        this.analysisModule_ = analysisModule;
        this.colorChooser_ = colorChooser;
        this.init();
    }

    private Vector<String> getDisplayNames() {
        Vector<String> names = new Vector<String>();
        this.fromShortToExpName_ = new Hashtable();
        for (String name : this.expNames_) {
            String displayName = this.sampleLookup_.getDisplayName(name);
            names.add(displayName);
            this.fromShortToExpName_.put(displayName, name);
        }
        return names;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.centerPanel_ = new JPanel();
        this.add((Component)this.centerPanel_, "Center");
        this.initBottomPanel();
        this.selectionSettings_ = new ResultSelectionSettings(null, this.getDisplayNames(), true);
        this.selectionSettings_.addActionListener(this);
        this.standardSelection_ = new StandardSelectionOverview(this.displaySettings_, this, this.isLookup_, this.esLookup_);
    }

    private void initBottomPanel() {
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new GridBagLayout());
        this.considerStandard_ = new JCheckBox("consider standard");
        this.considerStandard_.setSelected(true);
        this.considerStandard_.setToolTipText("<html>Compare the analyte classes based on standards, or on the area without standardization</html>");
        inputPanel.add((Component)this.considerStandard_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.considerDilution_ = new JCheckBox("consider dilution");
        this.considerDilution_.setSelected(true);
        this.considerDilution_.setToolTipText("<html>Should the dilution be considered for the comparison of the classes?</html>");
        inputPanel.add((Component)this.considerDilution_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 0), 0, 0));
        bottomPanel.add((Component)inputPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel buttonPanel = new JPanel();
        this.buttonAccept_ = new JButton("Accept");
        this.buttonAccept_.addActionListener(this);
        this.buttonAccept_.setActionCommand("showAcceptOverview");
        this.buttonAccept_.setToolTipText("<html>Accept settings</html>");
        buttonPanel.add((Component)this.buttonAccept_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.buttonSearches_ = new JButton("Selected");
        this.buttonSearches_.addActionListener(this);
        this.buttonSearches_.setActionCommand("showSearches");
        this.buttonSearches_.setToolTipText("<html>Selection of experiments/groups that should be displayed in the heat map.</html>");
        buttonPanel.add((Component)this.buttonSearches_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        bottomPanel.add((Component)buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)bottomPanel, "South");
    }

    public void refreshNames() {
        this.selectionSettings_.refreshNames(this.getDisplayNames());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("showSearches")) {
            this.selectionSettings_.setVisible(true);
        }
        if (e.getActionCommand().equalsIgnoreCase("AcceptDisplaySettings")) {
            this.selectionSettings_.setVisible(false);
        }
        if (e.getActionCommand().equalsIgnoreCase("showAcceptOverview")) {
            if (this.considerStandard_.isSelected()) {
                this.standardSelection_.refreshInformationSections();
                this.standardSelection_.setVisible(true);
            } else {
                this.showOverviewBarChart();
            }
        }
        if (e.getActionCommand().equalsIgnoreCase("acceptSelectedStandards")) {
            this.standardSelection_.setVisible(false);
            this.showOverviewBarChart();
        }
        if (e.getActionCommand().equalsIgnoreCase("cancelSelectedStandards")) {
            this.standardSelection_.setVisible(false);
        }
    }

    private void showOverviewBarChart() {
        Vector<String> experiments = new Vector<String>();
        for (String displayName : this.selectionSettings_.getSelected()) {
            experiments.add(this.fromShortToExpName_.get(displayName));
        }
        Hashtable<String, Hashtable<String, ResultCompVO>> overviewResults = new Hashtable<String, Hashtable<String, ResultCompVO>>();
        Hashtable<String, Hashtable<String, Double>> dilutionFactors = null;
        if (this.analysisModule_.hasAbsoluteSettings()) {
            dilutionFactors = this.analysisModule_.getDilutionFactors();
        }
        Vector<String> classes = new Vector<String>();
        int maxIsotope = Integer.MAX_VALUE;
        boolean isGrouped = false;
        try {
            for (String group : this.analysisResults_.keySet()) {
                block4: for (String molName : this.analysisResults_.get(group).keySet()) {
                    for (String expName : this.analysisResults_.get(group).get(molName).keySet()) {
                        ResultCompVO compVO = this.analysisResults_.get(group).get(molName).get(expName);
                        if (compVO == null) continue;
                        if (compVO instanceof ResultCompGroupVO) {
                            isGrouped = true;
                            continue block4;
                        }
                        isGrouped = false;
                        continue block4;
                    }
                }
            }
            for (String group : this.analysisResults_.keySet()) {
                int isotopeGroup;
                Hashtable<String, Hashtable<String, ResultCompVO>> resultsOfGroup = this.analysisResults_.get(group);
                ResultDisplaySettingsVO displaySettings = this.displaySettings_.get(group).getSettingsVO();
                Object overviewOfOneExperiment = new Hashtable();
                if (overviewResults.containsKey(group)) {
                    overviewOfOneExperiment = (Hashtable)overviewResults.get(group);
                }
                if ((isotopeGroup = this.selectedIsotopes_.get(group).getSelectedIsotope() + 1) >= 0 && isotopeGroup < maxIsotope) {
                    maxIsotope = isotopeGroup;
                }
                boolean isOK = true;
                if (this.considerStandard_.isSelected() && displaySettings.getESStandMethod() == 0 && displaySettings.getISStandMethod() == 0) {
                    isOK = false;
                }
                if (!isOK) continue;
                classes.add(group);
                for (String expName : experiments) {
                    ResultCompVO compVO;
                    if (this.considerStandard_.isSelected() && displaySettings.getISStandMethod() == 0 && displaySettings.getESStandMethod() == 0) {
                        ((Hashtable)overviewOfOneExperiment).put(expName, new ResultCompVO(3, maxIsotope, new Vector<Double>()));
                        continue;
                    }
                    Hashtable<String, Hashtable> isoAreas = new Hashtable<String, Hashtable>();
                    for (int isoNr = 0; isoNr != isotopeGroup + 1; ++isoNr) {
                        for (String string : resultsOfGroup.keySet()) {
                            Hashtable<String, ResultCompVO> resultsOfMol = resultsOfGroup.get(string);
                            if (!resultsOfMol.containsKey(expName)) continue;
                            ResultCompVO compVO2 = resultsOfMol.get(expName);
                            if (isGrouped) {
                                Hashtable<String, ResultCompVO> groupVOs = ((ResultCompGroupVO)compVO2).getGroupingPartners();
                                for (String origExp : groupVOs.keySet()) {
                                    Hashtable nrHash = new Hashtable();
                                    if (isoAreas.containsKey(origExp)) {
                                        nrHash = (Hashtable)isoAreas.get(origExp);
                                    }
                                    double groupArea = 0.0;
                                    if (nrHash.containsKey(isoNr)) {
                                        groupArea = (Double)nrHash.get(isoNr);
                                    }
                                    nrHash.put(isoNr, groupArea += this.getCorrespondingArea(groupVOs.get(origExp), displaySettings, isoNr, dilutionFactors, group, origExp));
                                    isoAreas.put(origExp, nrHash);
                                }
                                continue;
                            }
                            Hashtable nrHash = new Hashtable();
                            if (isoAreas.containsKey(expName)) {
                                nrHash = (Hashtable)isoAreas.get(expName);
                            }
                            double groupArea = 0.0;
                            if (nrHash.containsKey(isoNr)) {
                                groupArea = (Double)nrHash.get(isoNr);
                            }
                            nrHash.put(isoNr, groupArea += this.getCorrespondingArea(compVO2, displaySettings, isoNr, dilutionFactors, group, expName));
                            isoAreas.put(expName, nrHash);
                        }
                    }
                    if (isGrouped) {
                        Hashtable<String, ResultCompVO> groupMembers = new Hashtable<String, ResultCompVO>();
                        for (String origExpName : isoAreas.keySet()) {
                            Hashtable values = (Hashtable)isoAreas.get(origExpName);
                            Vector<Double> areas = new Vector<Double>();
                            for (int isoNr = 0; isoNr != isotopeGroup + 1; ++isoNr) {
                                areas.add((Double)values.get(isoNr));
                            }
                            groupMembers.put(origExpName, new ResultCompVO(3, maxIsotope, areas));
                        }
                        compVO = new ResultCompGroupVO(groupMembers);
                    } else {
                        Vector<Double> areas = new Vector<Double>();
                        Hashtable hashtable = (Hashtable)isoAreas.values().iterator().next();
                        for (int isoNr = 0; isoNr != isotopeGroup + 1; ++isoNr) {
                            areas.add((Double)hashtable.get(isoNr));
                        }
                        compVO = new ResultCompVO(3, maxIsotope, areas);
                    }
                    ((Hashtable)overviewOfOneExperiment).put(expName, compVO);
                }
                overviewResults.put(group, (Hashtable<String, ResultCompVO>)overviewOfOneExperiment);
            }
            if (maxIsotope == Integer.MAX_VALUE) {
                maxIsotope = 1;
            }
            Hashtable totalAmounts = new Hashtable();
            Hashtable totalAmountsOfExp = new Hashtable();
            Hashtable totalSds = new Hashtable();
            Vector<Double> allValues = new Vector<Double>();
            for (String expName : experiments) {
                Vector<Double> totalAreas = new Vector<Double>();
                Vector<Double> sds = new Vector<Double>();
                Hashtable<String, Vector> singleAreasIso = new Hashtable<String, Vector>();
                for (int isoNr = 0; isoNr != maxIsotope + 1; ++isoNr) {
                    double area = 0.0;
                    Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
                    Vector<Double> stdvs = new Vector<Double>();
                    for (String group : this.analysisResults_.keySet()) {
                        if (!overviewResults.containsKey(group) || !overviewResults.get(group).containsKey(expName)) continue;
                        ResultCompVO compVO = overviewResults.get(group).get(expName);
                        double value = compVO.getOriginalArea(compVO.getAvailableIsotopeNr(isoNr));
                        area += value;
                        if (compVO instanceof ResultCompGroupVO) {
                            ResultCompGroupVO groupVO = (ResultCompGroupVO)compVO;
                            stdvs.add(groupVO.getOriginalAreaSD(compVO.getAvailableIsotopeNr(isoNr)));
                            for (String origExpName : groupVO.getGroupingPartners().keySet()) {
                                double singleExpArea = 0.0;
                                if (hashtable.containsKey(origExpName)) {
                                    singleExpArea = (Double)hashtable.get(origExpName);
                                }
                                hashtable.put(origExpName, singleExpArea += groupVO.getGroupingPartners().get(origExpName).getOriginalArea(compVO.getAvailableIsotopeNr(isoNr)));
                            }
                        }
                        if (!(value > 0.0) || isoNr != maxIsotope) continue;
                        allValues.add(value);
                    }
                    totalAreas.add(area);
                    if (!isGrouped) continue;
                    sds.add(Calculator.calculateSumStdevErrorPropagated(stdvs));
                    for (String origExp : hashtable.keySet()) {
                        Vector areas = new Vector();
                        if (singleAreasIso.containsKey(origExp)) {
                            areas = (Vector)singleAreasIso.get(origExp);
                        }
                        areas.add(hashtable.get(origExp));
                        singleAreasIso.put(origExp, areas);
                    }
                }
                totalAmounts.put(expName, totalAreas);
                if (!isGrouped) continue;
                totalSds.put(expName, sds);
                for (String origExp : singleAreasIso.keySet()) {
                    totalAmountsOfExp.put(origExp, singleAreasIso.get(origExp));
                }
            }
            String preferredUnit = "";
            String unit = "area [AU]";
            if (this.considerStandard_.isSelected() && this.analysisModule_.hasAbsoluteSettings()) {
                double median = DoubleCalculator.median(allValues);
                preferredUnit = StaticUtils.extractPreferredUnit(median);
                unit = StaticUtils.getCorrespondingUnit(new ResultDisplaySettingsVO("amount sample-volume", 0, 0, false, false), preferredUnit, true);
            }
            for (String group : overviewResults.keySet()) {
                for (String exp : ((Hashtable)overviewResults.get(group)).keySet()) {
                    ((ResultCompVO)((Hashtable)overviewResults.get(group)).get(exp)).setSumValueForPercentage((Vector)totalAmounts.get(exp));
                    if (!isGrouped) continue;
                    ResultCompGroupVO compVO = (ResultCompGroupVO)((Hashtable)overviewResults.get(group)).get(exp);
                    compVO.setSumPercentualMeans((Vector)totalAmounts.get(exp));
                    compVO.setSumPercentualSds((Vector)totalSds.get(exp));
                    Hashtable<String, ResultCompVO> hashes = ((ResultCompGroupVO)overviewResults.get(group).get(exp)).getGroupingPartners();
                    for (String origExp : hashes.keySet()) {
                        ResultCompVO groupVO = hashes.get(origExp);
                        groupVO.setSumValueForPercentage((Vector)totalAmountsOfExp.get(origExp));
                    }
                }
            }
            ResultDisplaySettingsVO settingVO = new ResultDisplaySettingsVO("relative value", 0, 0, false, false);
            this.centerPanel_.removeAll();
            BarChartPainter painter = new BarChartPainter(2, "Overview", classes, overviewResults, experiments, this.sampleLookup_, true, isGrouped, maxIsotope, false, isGrouped, settingVO, preferredUnit, unit, null, null, null, this.colorChooser_);
            this.remove(this.centerPanel_);
            this.centerPanel_ = painter;
            this.add(this.centerPanel_);
            this.invalidate();
            this.updateUI();
        }
        catch (CalculationNotPossibleException cnp) {
            new WarningMessage(new JFrame(), "Error", cnp.getMessage());
        }
    }

    private double getCorrespondingArea(ResultCompVO compVO, ResultDisplaySettingsVO displaySettings, int isoNr, Hashtable<String, Hashtable<String, Double>> dilutionFactors, String group, String expName) throws CalculationNotPossibleException {
        double area = 0.0;
        if (compVO.getType() == 0) {
            if (this.considerStandard_.isSelected()) {
                double amount = compVO.getAmountInProbeVolume(compVO.getAvailableIsotopeNr(isoNr), displaySettings.getISStandMethod(), displaySettings.getESStandMethod());
                if (!this.considerDilution_.isSelected() && dilutionFactors != null && dilutionFactors.containsKey(group) && dilutionFactors.get(group).containsKey(expName)) {
                    amount /= dilutionFactors.get(group).get(expName).doubleValue();
                }
                area += amount;
            } else {
                area += compVO.getStandardizedArea(compVO.getAvailableIsotopeNr(isoNr), 0, 0, this.considerDilution_.isSelected());
            }
        }
        return area;
    }

    public void cleanup() {
        if (this.selectionSettings_ != null) {
            this.selectionSettings_.removeActionListener(this);
            this.selectionSettings_.dispose();
            this.selectionSettings_ = null;
        }
        if (this.standardSelection_ != null) {
            this.standardSelection_.cleanup();
            this.standardSelection_ = null;
        }
    }
}

