/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.vos.ExportOptionsVO;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class ExportSettingsPanel
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1195564134976647401L;
    private ActionListener parent_;
    protected JCheckBox exportDeviation_;
    private JRadioButton standardDeviation_;
    private JTextField multStandardDeviation_;
    private JRadioButton standardErrorMean_;
    private JRadioButton columnAnalyte_;
    private JRadioButton columnExperiment_;
    protected JCheckBox exportRT_;
    protected JCheckBox exportRTDev_;
    private JCheckBox exportDoubleBondPositions_;
    private JRadioButton speciesLevel_;
    private JRadioButton chainLevel_;
    private JRadioButton positionLevel_;
    private JButton okButton_;
    private static final String CHANGE_SELECTION_STATUS = "changeSelectionStatus";
    public static final String CHANGE_RT_SELECTION_STATUS = "changeRTSelectionStatus";
    public static final String CHANGE_EXPORT_LEVEL_SELECTION_STATUS = "changeExportLevelSelectionStatus";

    public ExportSettingsPanel(boolean isGrouped, ActionListener parent) {
        super.setTitle("Export Options");
        this.parent_ = parent;
        this.setLocation(380, 240);
        this.setLayout(new GridBagLayout());
        if (isGrouped) {
            this.exportDeviation_ = new JCheckBox("export deviation value");
            this.exportDeviation_.setActionCommand(CHANGE_SELECTION_STATUS);
            this.exportDeviation_.addActionListener(this);
            this.exportDeviation_.setSelected(false);
            this.exportDeviation_.setEnabled(isGrouped);
            this.exportDeviation_.setToolTipText("<html>Should the deviation values be exported (standard deviation or standard error)?</html>");
            this.add((Component)this.exportDeviation_, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            ButtonGroup deviationGroup = new ButtonGroup();
            this.standardDeviation_ = new JRadioButton("standard deviation");
            this.standardDeviation_.setSelected(true);
            this.standardDeviation_.setEnabled(false);
            this.standardDeviation_.addItemListener(new SelectionItemListener("ChangeSD"));
            deviationGroup.add(this.standardDeviation_);
            this.standardDeviation_.setToolTipText("<html>Use the standard deviation?</html>");
            this.add((Component)this.standardDeviation_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.multStandardDeviation_ = new JTextField(3);
            this.multStandardDeviation_.setText("1.0");
            this.multStandardDeviation_.setEnabled(false);
            this.multStandardDeviation_.setInputVerifier(new DoubleVerifier());
            this.multStandardDeviation_.setToolTipText("<html>Single standard deviation, double standard deviation etc?</html>");
            this.add((Component)this.multStandardDeviation_, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.standardErrorMean_ = new JRadioButton("standard error mean");
            this.standardErrorMean_.setEnabled(false);
            this.standardErrorMean_.addItemListener(new SelectionItemListener("ChangeSD"));
            deviationGroup.add(this.standardErrorMean_);
            this.standardErrorMean_.setToolTipText("<html>Use the standard error?</html>");
            this.add((Component)this.standardErrorMean_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.add((Component)new JSeparator(0), new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        ButtonGroup columnGroup = new ButtonGroup();
        this.columnAnalyte_ = new JRadioButton("analytes in column");
        this.columnAnalyte_.setSelected(true);
        columnGroup.add(this.columnAnalyte_);
        this.columnAnalyte_.setToolTipText("<html>Table setup: analytes in columns and experiments/groups in rows</html>");
        this.add((Component)this.columnAnalyte_, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.columnExperiment_ = new JRadioButton("experiments in column");
        this.columnExperiment_.setSelected(false);
        columnGroup.add(this.columnExperiment_);
        this.columnExperiment_.setToolTipText("<html>Table setup: experiments/groups in columns and analytes in rows</html>");
        this.add((Component)this.columnExperiment_, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)new JSeparator(0), new GridBagConstraints(0, 5, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.exportRT_ = new JCheckBox("export retention-time");
        this.exportRT_.setActionCommand(CHANGE_RT_SELECTION_STATUS);
        this.exportRT_.addActionListener(this);
        this.exportRT_.setSelected(false);
        this.exportRT_.setToolTipText("<html>Should the retention time be exported?</html>");
        this.add((Component)this.exportRT_, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        if (isGrouped) {
            this.exportRTDev_ = new JCheckBox("export RT-stdev");
            this.exportRTDev_.addActionListener(this);
            this.exportRTDev_.setSelected(false);
            this.exportRTDev_.setEnabled(false);
            this.exportRTDev_.setToolTipText("<html>Should the standard deviation of the retention time be exported?</html>");
            this.add((Component)this.exportRTDev_, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.add((Component)new JSeparator(0), new GridBagConstraints(0, 8, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup speciesGroup = new ButtonGroup();
        this.speciesLevel_ = new JRadioButton("species level");
        this.speciesLevel_.setSelected(true);
        speciesGroup.add(this.speciesLevel_);
        this.speciesLevel_.setToolTipText("<html>Analytes shall be exported at molecular species level</html>");
        this.add((Component)this.speciesLevel_, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.chainLevel_ = new JRadioButton("chain level");
        this.chainLevel_.setSelected(false);
        speciesGroup.add(this.chainLevel_);
        this.chainLevel_.setToolTipText("<html>Analytes shall be exported at chain level</html>");
        this.add((Component)this.chainLevel_, new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.positionLevel_ = new JRadioButton("position level");
        this.positionLevel_.setSelected(false);
        speciesGroup.add(this.positionLevel_);
        this.positionLevel_.setToolTipText("<html>Analytes shall be exported at position level.<br/>A position will be exported if a majority for a position <br/>and no contradicting evidence is available.</html>");
        this.add((Component)this.positionLevel_, new GridBagConstraints(0, 11, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        if (LipidParameterSet.isOmegaInformationAvailable()) {
            this.speciesLevel_.setSelected(false);
            this.speciesLevel_.setActionCommand(CHANGE_EXPORT_LEVEL_SELECTION_STATUS);
            this.speciesLevel_.addActionListener(this);
            this.chainLevel_.setSelected(false);
            this.positionLevel_.setSelected(true);
            this.add((Component)new JSeparator(0), new GridBagConstraints(0, 12, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.exportDoubleBondPositions_ = new JCheckBox("export \u03c9 - double bond positions");
            this.exportDoubleBondPositions_.setActionCommand(CHANGE_EXPORT_LEVEL_SELECTION_STATUS);
            this.exportDoubleBondPositions_.addActionListener(this);
            this.exportDoubleBondPositions_.setSelected(true);
            this.exportDoubleBondPositions_.setToolTipText("<html>Analytes shall be exported at \u03c9 - double bond position level, where evidence is available.<br/>");
            this.add((Component)this.exportDoubleBondPositions_, new GridBagConstraints(0, 13, 2, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.add((Component)new JSeparator(0), new GridBagConstraints(0, 14, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.okButton_ = new JButton("OK");
        this.okButton_.setActionCommand("AcceptExportSettings");
        this.okButton_.setToolTipText("<html>Accept settings</html>");
        this.add((Component)this.okButton_, new GridBagConstraints(0, 15, 3, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        this.okButton_.addActionListener(this.parent_);
        this.setVisible(false);
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(CHANGE_SELECTION_STATUS)) {
            if (this.exportDeviation_.isSelected()) {
                this.standardDeviation_.setEnabled(true);
                this.multStandardDeviation_.setEnabled(true);
                this.standardErrorMean_.setEnabled(true);
            } else {
                this.standardDeviation_.setEnabled(false);
                this.multStandardDeviation_.setEnabled(false);
                this.standardErrorMean_.setEnabled(false);
            }
        } else if (e.getActionCommand().equalsIgnoreCase(CHANGE_RT_SELECTION_STATUS)) {
            if (this.exportRTDev_ != null) {
                if (this.exportRT_.isSelected()) {
                    this.exportRTDev_.setEnabled(true);
                } else {
                    this.exportRTDev_.setSelected(false);
                    this.exportRTDev_.setEnabled(false);
                }
            }
        } else if (e.getActionCommand().equals(CHANGE_EXPORT_LEVEL_SELECTION_STATUS) && this.exportDoubleBondPositions_.isSelected() && this.speciesLevel_.isSelected()) {
            new WarningMessage(new JFrame(), "Warning", "<html>On 'species level' the export of \u03c9 - double bond positions will only be performed for lipid classes with no more than one FA chain.<br/>To export all detected \u03c9 - double bond positions, select either 'chain level' or 'position level'!</html>");
        }
    }

    private boolean verifySDFactInput() {
        try {
            Double.parseDouble(this.multStandardDeviation_.getText());
            return true;
        }
        catch (NumberFormatException nfx) {
            new WarningMessage(new JFrame(), "Error", "SD value input must be in double format (xxx.xxx) and not " + this.multStandardDeviation_.getText());
            return false;
        }
    }

    public ExportOptionsVO getSettings() {
        int exportType = 0;
        String variationValue = null;
        if (this.exportDeviation_ != null && this.exportDeviation_.isSelected()) {
            if (this.standardDeviation_.isSelected()) {
                exportType = 1;
                variationValue = this.multStandardDeviation_.getText();
            } else {
                exportType = 2;
            }
        }
        boolean exportRTDev = false;
        if (this.exportRTDev_ != null && this.exportRTDev_.isSelected()) {
            exportRTDev = true;
        }
        boolean exportDoubleBondPositions = false;
        if (this.exportDoubleBondPositions_ != null && this.exportDoubleBondPositions_.isSelected()) {
            exportDoubleBondPositions = true;
        }
        short speciesType = 0;
        if (this.speciesLevel_.isSelected()) {
            speciesType = 0;
        } else if (this.chainLevel_.isSelected()) {
            speciesType = 1;
        } else if (this.positionLevel_.isSelected()) {
            speciesType = 2;
        }
        return new ExportOptionsVO(exportType, variationValue, this.columnAnalyte_.isSelected(), this.exportRT_.isSelected(), exportRTDev, exportDoubleBondPositions, 6, speciesType);
    }

    public void cleanup() {
        this.okButton_.removeActionListener(this.parent_);
        this.parent_ = null;
    }

    private class DoubleVerifier
    extends InputVerifier {
        private DoubleVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            return ExportSettingsPanel.this.verifySDFactInput();
        }
    }

    private class SelectionItemListener
    implements ItemListener {
        private String m_ctrl;

        public SelectionItemListener(String ctrl) {
            this.m_ctrl = ctrl;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (this.m_ctrl.equalsIgnoreCase("ChangeSD") && e.getStateChange() == 1) {
                if (ExportSettingsPanel.this.standardDeviation_.isSelected()) {
                    ExportSettingsPanel.this.multStandardDeviation_.setEnabled(true);
                } else {
                    ExportSettingsPanel.this.multStandardDeviation_.setEnabled(false);
                }
            }
        }
    }
}

