/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JLabel;

public class JHyperlink
extends JLabel
implements MouseListener {
    private static final long serialVersionUID = -7224370255158950845L;
    private URI uri = null;
    private Component parentComponent = this;

    public JHyperlink(String text, String uri) {
        this.setText("<html><u>" + text + "</u></html>");
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.initialize();
    }

    public URI getURI() {
        return this.uri;
    }

    private void initialize() {
        this.setForeground(Color.BLUE);
        this.setOpaque(false);
        this.setToolTipText(this.getURI().toString());
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 0 && Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            try {
                desktop.browse(this.getURI());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.parentComponent.setCursor(Cursor.getPredefinedCursor(12));
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.parentComponent.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        this.setForeground(Color.RED);
        this.parentComponent.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        this.setForeground(Color.BLUE);
        this.parentComponent.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void setParentComponent(Component parent) {
        this.parentComponent = parent;
    }
}

