/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.WarningMessage;
import at.tugraz.genome.lda.analysis.ComparativeNameExtractor;
import at.tugraz.genome.lda.exception.AbsoluteSettingsInputException;
import at.tugraz.genome.lda.swing.GroupsPanel;
import at.tugraz.genome.lda.swing.StandardsSettingsListener;
import at.tugraz.genome.lda.swing.StandardsSettingsPanel;
import at.tugraz.genome.lda.vos.LipidClassSettingVO;
import at.tugraz.genome.lda.vos.VolumeConcVO;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class LipidClassSettingsPanel
extends JPanel
implements ActionListener,
StandardsSettingsListener {
    private static final long serialVersionUID = 4681131520631813127L;
    private static final String CHANGE_IS_STATUS = "changeAllSettingsStatus";
    private static final String CHANGE_STAND_STATUS = "changeAllStandardsStatus";
    private JCheckBox allSettingsSame_;
    private JTabbedPane experimentTabs_;
    private JCheckBox allStandardsSame_;
    private JComboBox<String> alternativeClasses_;
    private String className_;
    private ComparativeNameExtractor extractor_;
    private StandardsSettingsPanel generalSettingsPanel_;
    private Hashtable<String, StandardsSettingsPanel> standardsSettings_;
    private GroupsPanel groupsPanel_;
    private boolean oneTimeExpCopied_;
    private boolean oneTimeStandCopied_;

    public LipidClassSettingsPanel(String className, ComparativeNameExtractor extractor, GroupsPanel groupsPanel) {
        this.className_ = className;
        this.extractor_ = extractor;
        this.groupsPanel_ = groupsPanel;
        this.oneTimeExpCopied_ = false;
        this.oneTimeStandCopied_ = false;
        this.initComponents();
    }

    private void initComponents() {
        Vector<String> isNames = this.extractor_.getISNames(this.className_);
        Vector<String> esNames = this.extractor_.getESNames(this.className_);
        if (isNames.isEmpty() && esNames.isEmpty()) {
            JLabel label1 = new JLabel("No standards were detected for this lipid class.");
            this.add((Component)label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            JLabel label2 = new JLabel("You may choose to use standards from another class: ");
            this.add((Component)label2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.alternativeClasses_ = new JComboBox<String>(this.extractor_.getAllClassNames());
            this.alternativeClasses_.setSelectedItem(this.className_);
            this.add(this.alternativeClasses_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.standardsSettings_ = new Hashtable();
            for (String expName : this.extractor_.getExpNamesInSequence()) {
                StandardsSettingsPanel expStandSettings = new StandardsSettingsPanel(expName, isNames, esNames, this);
                this.standardsSettings_.put(expName, expStandSettings);
            }
        } else {
            this.setLayout(new GridBagLayout());
            this.allSettingsSame_ = new JCheckBox("use same settings for all experiments");
            this.allSettingsSame_.setSelected(true);
            this.allSettingsSame_.setActionCommand(CHANGE_IS_STATUS);
            this.allSettingsSame_.addActionListener(this);
            this.allSettingsSame_.setToolTipText("<html>Are the concentrations and volumes of the standards the same in all experiments?</html>");
            this.add((Component)this.allSettingsSame_, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.allStandardsSame_ = new JCheckBox("use same settings for all standards");
            this.allStandardsSame_.setSelected(true);
            this.allStandardsSame_.setActionCommand(CHANGE_STAND_STATUS);
            this.allStandardsSame_.addActionListener(this);
            this.allStandardsSame_.setToolTipText("<html>Do all of the standards have the same volume and concentration?</html>");
            this.add((Component)this.allStandardsSame_, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.generalSettingsPanel_ = new StandardsSettingsPanel(null, isNames, esNames, this);
            this.add((Component)this.generalSettingsPanel_, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.experimentTabs_ = new JTabbedPane();
            this.add((Component)this.experimentTabs_, new GridBagConstraints(0, 2, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.standardsSettings_ = new Hashtable();
            int count = 0;
            for (String expName : this.extractor_.getExpNamesInSequence()) {
                StandardsSettingsPanel expStandSettings = new StandardsSettingsPanel(expName, isNames, esNames, this);
                this.standardsSettings_.put(expName, expStandSettings);
                this.experimentTabs_.addTab(this.extractor_.getExpNames().get(expName), expStandSettings);
                this.experimentTabs_.setToolTipTextAt(count, "<html>Standard settings for experiment " + expName + "</html>");
                ++count;
            }
            this.experimentTabs_.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase(CHANGE_IS_STATUS)) {
            this.changeVisibilitySettingsSame();
            this.invalidate();
            this.updateUI();
        }
        if (e.getActionCommand().equalsIgnoreCase(CHANGE_STAND_STATUS)) {
            this.changeVisibilityStandardsSame();
            this.invalidate();
            this.updateUI();
        }
    }

    public void changeVisibilitySettingsSame() {
        this.generalSettingsPanel_.setVisible(this.allSettingsSame_.isSelected());
        this.experimentTabs_.setVisible(!this.allSettingsSame_.isSelected());
        if (!this.oneTimeExpCopied_ && !this.allSettingsSame_.isSelected()) {
            for (StandardsSettingsPanel standardPanel : this.standardsSettings_.values()) {
                standardPanel.takeOverValues(this.generalSettingsPanel_, this.allStandardsSame_.isSelected());
            }
            this.oneTimeExpCopied_ = true;
        }
    }

    public void changeVisibilityStandardsSame() {
        this.generalSettingsPanel_.showSpecific(!this.allStandardsSame_.isSelected());
        if (!this.oneTimeStandCopied_ && !this.allStandardsSame_.isSelected()) {
            if (this.allSettingsSame_.isSelected()) {
                this.generalSettingsPanel_.copyGeneralSettingsToStandards();
            } else {
                for (StandardsSettingsPanel panel : this.standardsSettings_.values()) {
                    panel.copyGeneralSettingsToStandards();
                }
            }
            this.oneTimeStandCopied_ = true;
        }
        for (StandardsSettingsPanel panel : this.standardsSettings_.values()) {
            panel.showSpecific(!this.allStandardsSame_.isSelected());
        }
    }

    @Override
    public void applySettingsToAll(String experimentName, String molName) {
        StandardsSettingsPanel copyFrom = this.standardsSettings_.get(experimentName);
        for (String expName : this.standardsSettings_.keySet()) {
            if (expName.equalsIgnoreCase(experimentName)) continue;
            StandardsSettingsPanel panel = this.standardsSettings_.get(expName);
            panel.setInputValues(molName, copyFrom);
        }
    }

    @Override
    public void applySettingsToGroup(String experimentName, String molName) {
        StandardsSettingsPanel copyFrom = this.standardsSettings_.get(experimentName);
        Set<String> exps = this.groupsPanel_.getExpsOfGroupOneExpBelongsTo(experimentName, this.extractor_.getExpNamesInSequence());
        if (exps.size() > 0) {
            for (String expName : exps) {
                if (expName.equalsIgnoreCase(experimentName)) continue;
                StandardsSettingsPanel panel = this.standardsSettings_.get(expName);
                panel.setInputValues(molName, copyFrom);
            }
        } else {
            new WarningMessage(new JFrame(), "Warning", "This experiment does not belong to any group");
        }
    }

    public JCheckBox getAllSettingsSame() {
        return this.allSettingsSame_;
    }

    public JCheckBox getAllStandardsSame() {
        return this.allStandardsSame_;
    }

    public StandardsSettingsPanel getGeneralSettingsPanel() {
        return this.generalSettingsPanel_;
    }

    public Hashtable<String, StandardsSettingsPanel> getStandardsSettings() {
        return this.standardsSettings_;
    }

    public void cleanSettings() {
        this.oneTimeExpCopied_ = false;
        this.oneTimeStandCopied_ = false;
        if (this.allSettingsSame_ != null) {
            this.allSettingsSame_.setSelected(true);
        }
        if (this.allStandardsSame_ != null) {
            this.allStandardsSame_.setSelected(true);
        }
        if (this.generalSettingsPanel_ != null) {
            this.generalSettingsPanel_.setVisible(true);
            this.generalSettingsPanel_.cleanSettings();
        }
        if (this.experimentTabs_ != null) {
            this.experimentTabs_.setVisible(false);
        }
        for (StandardsSettingsPanel standSets : this.standardsSettings_.values()) {
            standSets.cleanSettings();
        }
    }

    public LipidClassSettingVO getSettings() throws AbsoluteSettingsInputException {
        Hashtable<String, Double> dilutionFactors = new Hashtable<String, Double>();
        Hashtable<String, Hashtable<String, VolumeConcVO>> esStandards = new Hashtable<String, Hashtable<String, VolumeConcVO>>();
        Hashtable<String, Hashtable<String, VolumeConcVO>> isStandards = new Hashtable<String, Hashtable<String, VolumeConcVO>>();
        for (String expName : this.standardsSettings_.keySet()) {
            String valueString = null;
            valueString = this.allSettingsSame_ != null && this.allSettingsSame_.isSelected() ? this.generalSettingsPanel_.getDilutionFactor().getText() : this.standardsSettings_.get(expName).getDilutionFactor().getText();
            Double value = 1.0;
            if (valueString != null && valueString.length() > 0) {
                value = new Double(valueString);
            }
            if (value < 1.0) {
                throw new AbsoluteSettingsInputException("The dilution factor must not be smaller than 1");
            }
            dilutionFactors.put(expName, value);
        }
        for (String expName : this.standardsSettings_.keySet()) {
            VolumeConcVO value;
            Hashtable<Object, Object> expsHash;
            if (this.generalSettingsPanel_ == null) continue;
            for (String esName : this.generalSettingsPanel_.getExtVolumeSettings().keySet()) {
                expsHash = new Hashtable();
                if (esStandards.containsKey(esName)) {
                    expsHash = esStandards.get(esName);
                }
                value = this.getVolConcVO(expName, esName, false);
                expsHash.put(expName, value);
                esStandards.put(esName, expsHash);
            }
            for (String isName : this.generalSettingsPanel_.getIntVolumeSettings().keySet()) {
                expsHash = new Hashtable();
                if (isStandards.containsKey(isName)) {
                    expsHash = isStandards.get(isName);
                }
                value = this.getVolConcVO(expName, isName, true);
                expsHash.put(expName, value);
                isStandards.put(isName, expsHash);
            }
        }
        return new LipidClassSettingVO(dilutionFactors, esStandards, isStandards);
    }

    private VolumeConcVO getVolConcVO(String expName, String standName, boolean isIS) throws AbsoluteSettingsInputException {
        VolumeConcVO value = null;
        try {
            value = this.allSettingsSame_.isSelected() ? (this.allStandardsSame_.isSelected() ? this.generalSettingsPanel_.getSettings(isIS) : this.generalSettingsPanel_.getSettings(standName, isIS)) : (this.getAllStandardsSame().isSelected() ? this.standardsSettings_.get(expName).getSettings(isIS) : this.standardsSettings_.get(expName).getSettings(standName, isIS));
        }
        catch (AbsoluteSettingsInputException ex) {
            String standType = "external";
            if (isIS) {
                standType = "internal";
            }
            if (this.allSettingsSame_.isSelected()) {
                if (this.allStandardsSame_.isSelected()) {
                    throw new AbsoluteSettingsInputException("You have to enter volume and concentration for your " + standType + " standard!");
                }
                throw new AbsoluteSettingsInputException("You have to enter volume and concentration for your " + standName + " standard!");
            }
            if (this.allStandardsSame_.isSelected()) {
                throw new AbsoluteSettingsInputException("You have to enter volume and concentration for your " + standType + " standard (e.g. " + expName + " is not filled out)!");
            }
            throw new AbsoluteSettingsInputException("You have to enter volume and concentration for your " + standName + " standard (e.g. " + expName + " is not filled out)!");
        }
        return value;
    }

    public String getChosenClass() {
        if (this.alternativeClasses_ == null) {
            return this.className_;
        }
        return (String)this.alternativeClasses_.getSelectedItem();
    }

    public boolean areStandardsAvailable() {
        return !this.extractor_.getISNames(this.className_).isEmpty() || !this.extractor_.getESNames(this.className_).isEmpty();
    }
}

