/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.swing.LipidomicsTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class LipidomicsTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 393014627701796523L;
    public static final Color BRIGHT_GREEN = new Color(200, 255, 200);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel renderedLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (column == 1) {
            renderedLabel.setHorizontalAlignment(4);
        } else {
            renderedLabel.setHorizontalAlignment(2);
        }
        LipidomicsTableModel model = (LipidomicsTableModel)table.getModel();
        if (!isSelected) {
            if (model.isPercentalSplitInstance(row)) {
                renderedLabel.setBackground(Color.ORANGE);
            } else if (model.isSplitInstance(row)) {
                renderedLabel.setBackground(Color.YELLOW);
            } else if (model.hasMS2Evidence(row)) {
                renderedLabel.setBackground(BRIGHT_GREEN);
            } else {
                renderedLabel.setBackground(Color.WHITE);
            }
            if (model.hasOmegaEvidenceConflict(row)) {
                renderedLabel.setForeground(Color.RED);
            } else {
                renderedLabel.setForeground(Color.BLACK);
            }
        }
        return renderedLabel;
    }
}

