/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import java.util.Vector;

public class Range {
    private float start_;
    private float stop_;

    public Range(float start, float stop) {
        this.start_ = start;
        this.stop_ = stop;
    }

    public boolean insideRange(double value) {
        return (double)this.start_ < value && value < (double)this.stop_;
    }

    public float getStart() {
        return this.start_;
    }

    public float getStop() {
        return this.stop_;
    }

    public String toString() {
        return this.start_ / 60.0f + "-" + this.stop_ / 60.0f;
    }

    public boolean overlap(Range vo) {
        return this.start_ < vo.getStart() && this.stop_ > vo.getStart() || vo.getStart() < this.start_ && vo.getStop() > this.start_;
    }

    public void combine(Range vo) {
        if (vo.getStart() < this.start_) {
            this.start_ = vo.getStart();
        }
        if (vo.getStop() > this.stop_) {
            this.stop_ = vo.getStop();
        }
    }

    public static Vector<Range> reduce(Range vo, Range reducer) {
        Vector<Range> ranges = new Vector<Range>();
        if (reducer.getStart() < vo.getStart() && vo.getStop() < reducer.getStop()) {
            return ranges;
        }
        if (!vo.overlap(reducer)) {
            ranges.add(vo);
        } else {
            if (vo.getStart() < reducer.getStart()) {
                ranges.add(new Range(vo.getStart(), reducer.getStart()));
            }
            if (vo.getStop() > reducer.getStop()) {
                ranges.add(new Range(reducer.getStop(), vo.getStop()));
            }
        }
        return ranges;
    }
}

