/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing;

import at.tugraz.genome.lda.msn.LipidomicsMSnSet;
import at.tugraz.genome.lda.msn.MSnAnalyzer;
import at.tugraz.genome.lda.quantification.LipidParameterSet;
import at.tugraz.genome.lda.utils.StaticUtils;
import at.tugraz.genome.lda.vos.DoubleStringVO;
import at.tugraz.genome.maspectras.utils.Calculator;
import at.tugraz.genome.voutils.GeneralComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RecalculateMSnDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -7564408227460237486L;
    private LipidParameterSet result_;
    private ActionListener parent_;
    private boolean acceptAllowed_ = true;
    private String className_;

    public RecalculateMSnDialog(String className, MSnAnalyzer analyzer, ActionListener parent) {
        this.className_ = className;
        this.parent_ = parent;
        this.setLayout(new BorderLayout());
        this.setLocation(380, 240);
        this.result_ = analyzer.getResult();
        this.initMainPanel(analyzer);
        this.initButtonPanel();
        this.pack();
        this.setVisible(true);
    }

    private void initMainPanel(MSnAnalyzer analyzer) {
        int status = analyzer.checkStatus();
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new GridBagLayout());
        if (status == 0) {
            JLabel label = new JLabel("There are no MSn spectra present!");
            centerPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
            label = new JLabel("Previous MSn detections will be deleted when you click accept");
            centerPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        } else if (status == 1) {
            JLabel label = new JLabel("The MSn recommendation is to reject this hit!");
            centerPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
            label = new JLabel("Please delete it yourself!");
            centerPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
            this.acceptAllowed_ = false;
        } else if (status == 2) {
            JLabel label = new JLabel("The species could be verified as " + this.className_ + " " + this.result_.getNameStringWithoutRt() + "!");
            centerPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
            label = new JLabel("There were no molecular species detectable");
            centerPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
            label = new JLabel("Please click accept when you want to store this recommendation");
            centerPanel.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        } else if (status > 2) {
            double relArea;
            JLabel label = new JLabel("The molecular species were identified:");
            centerPanel.add((Component)label, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1), 0, 0));
            float area = this.result_.getArea();
            LipidomicsMSnSet msn = (LipidomicsMSnSet)this.result_;
            ArrayList<DoubleStringVO> nameAreaVO = new ArrayList<DoubleStringVO>();
            Vector<String> detected = msn.getMSnIdentificationNamesWithSNPositions();
            for (String name : detected) {
                String extract = "";
                relArea = 0.0;
                extract = name.contains("(sn-") ? StaticUtils.removeSNPositions(name).replaceAll("_", "/") : name;
                relArea = msn.getRelativeIntensity(extract);
                nameAreaVO.add(new DoubleStringVO(name, relArea));
            }
            for (String names : detected) {
                String name = "";
                relArea = 0.0;
                if (names instanceof Vector) {
                    Vector nameSuggestions = (Vector)((Object)names);
                    relArea = msn.getRelativeIntensity((String)nameSuggestions.get(0));
                    for (String nameSuggestion : nameSuggestions) {
                        if (name.length() > 0) {
                            name = name + ";";
                        }
                        name = name + nameSuggestion;
                    }
                } else if (names instanceof String) {
                    name = names;
                    relArea = msn.getRelativeIntensity(name);
                }
                nameAreaVO.add(new DoubleStringVO(name, relArea));
            }
            Collections.sort(nameAreaVO, new GeneralComparator("at.tugraz.genome.lda.vos.DoubleStringVO", "getValue", "java.lang.Double"));
            int row = 1;
            for (int i = nameAreaVO.size() - 1; i != -1; --i) {
                DoubleStringVO vo = (DoubleStringVO)nameAreaVO.get(i);
                label = new JLabel(vo.getKey());
                centerPanel.add((Component)label, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 3, 1, 3), 0, 0));
                double value = vo.getValue();
                float relArea2 = area * (float)value;
                if (nameAreaVO.size() == 1) {
                    value = 1.0;
                    relArea2 = area;
                }
                label = new JLabel(Calculator.FormatNumberToString(value * 100.0, 2.0) + "%");
                centerPanel.add((Component)label, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 3, 1, 3), 0, 0));
                label = new JLabel(String.valueOf(relArea2));
                centerPanel.add((Component)label, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(1, 3, 1, 3), 0, 0));
                ++row;
            }
            label = new JLabel("Please click accept when you want to store this recommendation");
            centerPanel.add((Component)label, new GridBagConstraints(0, row, 3, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 1, 1), 0, 0));
        }
        this.add((Component)centerPanel, "Center");
    }

    private void initButtonPanel() {
        JPanel buttonPanel = new JPanel();
        if (this.acceptAllowed_) {
            JButton okButton = new JButton("Accept");
            okButton.setActionCommand("AcceptMSnRecalculation");
            okButton.setToolTipText("<html>Accept settings</html>");
            buttonPanel.add(okButton);
            okButton.addActionListener(this);
            okButton.addActionListener(this.parent_);
        }
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("DeclineMSnRecalculation");
        cancelButton.setToolTipText("<html>Cancel operation</html>");
        buttonPanel.add(cancelButton);
        cancelButton.addActionListener(this);
        cancelButton.addActionListener(this.parent_);
        this.setDefaultCloseOperation(2);
        this.add((Component)buttonPanel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equalsIgnoreCase("AcceptMSnRecalculation") || e.getActionCommand().equalsIgnoreCase("DeclineMSnRecalculation")) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public LipidParameterSet getResult() {
        return this.result_;
    }
}

