/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.swing.rdi;

import at.tugraz.genome.lda.WarningMessage;
import javax.swing.JFrame;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerRangeDocument
extends PlainDocument {
    private static final long serialVersionUID = -6496137843055033710L;
    private int min_;
    private int max_;

    public IntegerRangeDocument(int min, int max) {
        this.min_ = min;
        this.max_ = max;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String newText = this.getCleanedText(str);
        if (newText.equalsIgnoreCase("otherChars")) {
            return;
        }
        String oldText = this.getText(0, this.getLength());
        String textResult = oldText.substring(0, offs) + newText + oldText.substring(offs);
        if (this.checkInput(textResult, false)) {
            super.insertString(offs, newText, a);
        }
    }

    @Override
    public void remove(int offs, int length) throws BadLocationException {
        String oldText = this.getText(0, this.getLength());
        String textResult = oldText.substring(0, offs) + oldText.substring(offs + length);
        if (this.checkInput(textResult, true)) {
            super.remove(offs, length);
        }
    }

    @Override
    public void replace(int offs, int length, String str, AttributeSet a) throws BadLocationException {
        String newText = this.getCleanedText(str);
        if (newText.equalsIgnoreCase("otherChars")) {
            return;
        }
        String oldText = this.getText(0, this.getLength());
        String textResult = oldText.substring(0, offs) + newText + oldText.substring(offs + length);
        if (this.checkInput(textResult, false)) {
            super.insertString(offs, newText, a);
        }
    }

    private String getCleanedText(String str) {
        char[] chars = str.trim().toCharArray();
        String newText = "";
        boolean otherChars = false;
        for (int i = 0; i != chars.length; ++i) {
            if (Character.isDigit(chars[i])) {
                newText = newText + chars[i];
                continue;
            }
            otherChars = true;
        }
        if (otherChars) {
            new WarningMessage(new JFrame(), "Error", "Only digits are allowed for this field");
            return "otherChars";
        }
        return newText;
    }

    private boolean checkInput(String textResult, boolean allowNull) {
        if (textResult == null || textResult.length() == 0) {
            return allowNull;
        }
        try {
            int number = Integer.parseInt(textResult);
            if (number < this.min_) {
                new WarningMessage(new JFrame(), "Error", "The value must not be smaller than " + this.min_);
                return false;
            }
            if (number > this.max_) {
                new WarningMessage(new JFrame(), "Error", "The value must not be higher than " + this.max_);
                return false;
            }
            return true;
        }
        catch (NumberFormatException nfx) {
            return false;
        }
    }
}

