/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.utils;

import java.util.Hashtable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    public static final double BOLD_MULT = 1.4;
    public static final int CHAR_MULT = 256;
    public static final String EXCEL_TEMP_PREFIX = "~$";

    public static Hashtable<Integer, Object> getEntriesOfOneRow(Row row, boolean stringOnly) {
        Hashtable<Integer, Object> rowEntries = new Hashtable<Integer, Object>();
        for (int i = 0; row != null && i != row.getLastCellNum() + 1; ++i) {
            Cell cell = row.getCell(i);
            String contents = "";
            Double numeric = null;
            int cellType = -1;
            if (cell != null) {
                cellType = cell.getCellType();
            }
            if (cellType == 1) {
                contents = cell.getStringCellValue();
                try {
                    numeric = new Double(contents);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if ((cellType == 0 || cellType == 2) && (contents = String.valueOf(numeric = Double.valueOf(cell.getNumericCellValue()))).endsWith(".0")) {
                contents = contents.substring(0, contents.length() - ".0".length());
            }
            if (contents.length() <= 0) continue;
            if (numeric != null && !stringOnly) {
                rowEntries.put(i, numeric);
                continue;
            }
            rowEntries.put(i, contents);
        }
        return rowEntries;
    }

    public static XSSFCellStyle getMassListHeaderStyle(XSSFWorkbook wb) {
        XSSFCellStyle arial12style = wb.createCellStyle();
        XSSFFont arial12font = wb.createFont();
        arial12font.setBoldweight((short)700);
        arial12font.setFontName("Arial");
        arial12font.setFontHeightInPoints((short)12);
        arial12style.setFont(arial12font);
        arial12style.setAlignment((short)2);
        return arial12style;
    }

    public static XSSFCellStyle getMassListNumberStyle(XSSFWorkbook wb) {
        XSSFCellStyle numberStyle = wb.createCellStyle();
        numberStyle.setDataFormat(2);
        return numberStyle;
    }
}

