/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.vos;

import at.tugraz.genome.lda.exception.ChemicalFormulaException;
import at.tugraz.genome.lda.utils.StaticUtils;
import java.util.Hashtable;
import java.util.Objects;

public class AdductVO {
    private static final String ADDUCT_SEPARATOR = ";";
    private String adductName_;
    private String formulaString_;
    private Hashtable<String, Integer> formula_;
    private int charge_;
    private String fileName_;

    public AdductVO(String name, String formula, int charge, String fileName) throws ChemicalFormulaException {
        this.fileName_ = fileName;
        this.adductName_ = name;
        this.formulaString_ = formula;
        this.formula_ = StaticUtils.categorizeFormula(formula, true);
        this.charge_ = charge;
    }

    public AdductVO(String composite) throws ChemicalFormulaException {
        String[] split = composite.split(ADDUCT_SEPARATOR);
        this.adductName_ = split[0];
        this.formulaString_ = split[1];
        this.formula_ = StaticUtils.categorizeFormula(split[1], true);
        this.charge_ = Integer.parseInt(split[2]);
    }

    public AdductVO(AdductVO other) throws ChemicalFormulaException {
        this(other.getAdductName(), other.getFormulaString(), other.getCharge(), other.getFileName());
    }

    public String getAdductName() {
        return this.adductName_;
    }

    public String getFormulaString() {
        return this.formulaString_;
    }

    public Hashtable<String, Integer> getFormula() {
        return this.formula_;
    }

    public int getCharge() {
        return this.charge_;
    }

    public String getFileName() {
        return this.fileName_;
    }

    public void setAdductName(String adductName) {
        this.adductName_ = adductName;
    }

    public void setFormulaString(String formulaString) throws ChemicalFormulaException {
        this.formulaString_ = formulaString;
        this.formula_ = null;
        this.formula_ = StaticUtils.categorizeFormula(formulaString, true);
    }

    public void setCharge(int charge) {
        this.charge_ = charge;
    }

    public void setFileName(String filePath) {
        this.fileName_ = filePath;
    }

    public int hashCode() {
        return Objects.hash(this.adductName_, this.charge_, this.formula_, this.fileName_);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdductVO other = (AdductVO)obj;
        return Objects.equals(this.adductName_, other.adductName_) && this.charge_ == other.charge_ && Objects.equals(this.formula_, other.formula_) && Objects.equals(this.fileName_, other.fileName_);
    }
}

