/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import at.tugraz.genome.lda.swing.AbsoluteQuantSettingsPanel;
import at.tugraz.genome.lda.swing.ExpVolumeSettingsPanel;
import at.tugraz.genome.lda.swing.LipidClassSettingsPanel;
import at.tugraz.genome.lda.swing.PhysicalUnitInput;
import at.tugraz.genome.lda.swing.StandardsSettingsPanel;
import at.tugraz.genome.lda.xml.XMLFileLoader;
import java.io.File;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AbsoluteQuantSettingsWholeReader
extends XMLFileLoader {
    private AbsoluteQuantSettingsPanel quantSettingsPanel_;

    public AbsoluteQuantSettingsWholeReader(String fileName, AbsoluteQuantSettingsPanel quantSettingsPanel) throws SAXException {
        super(new File(fileName));
        this.quantSettingsPanel_ = quantSettingsPanel;
    }

    @Override
    public void parseXMLFile() throws SAXException {
        Element root;
        super.parseXMLFile();
        if (this.doc != null && (root = this.doc.getDocumentElement()).getNodeName().equalsIgnoreCase("abs-settings-whole")) {
            NodeList rootList = root.getChildNodes();
            for (int i = 0; i != rootList.getLength(); ++i) {
                int j;
                Node rootSubNode = rootList.item(i);
                if (rootSubNode.getNodeName().equalsIgnoreCase("exp-settings")) {
                    this.quantSettingsPanel_.cleanVolumeSettings();
                    NodeList experimentNodes = rootSubNode.getChildNodes();
                    for (j = 0; j != experimentNodes.getLength(); ++j) {
                        if (!experimentNodes.item(j).getNodeName().equalsIgnoreCase("exp-setting")) continue;
                        this.parseExperimentSettings((Element)experimentNodes.item(j));
                    }
                }
                if (!rootSubNode.getNodeName().equalsIgnoreCase("class-settings")) continue;
                this.quantSettingsPanel_.cleanClassSettings();
                NodeList classesNodes = rootSubNode.getChildNodes();
                for (j = 0; j != classesNodes.getLength(); ++j) {
                    if (!classesNodes.item(j).getNodeName().equalsIgnoreCase("class-setting")) continue;
                    this.parseClassesSettings((Element)classesNodes.item(j));
                }
            }
        }
    }

    private void parseExperimentSettings(Element experiment) {
        String name = experiment.getAttribute("name");
        ExpVolumeSettingsPanel volSet = this.quantSettingsPanel_.getVolumeSettings().get(name);
        if (volSet != null) {
            NodeList nl = experiment.getChildNodes();
            for (int i = 0; i != nl.getLength(); ++i) {
                if (!nl.item(i).getNodeName().equalsIgnoreCase("setting")) continue;
                Element setting = (Element)nl.item(i);
                String settingType = setting.getAttribute("name");
                if (settingType.equalsIgnoreCase("probe-volume")) {
                    this.setSetting(volSet.getProbeVolume(), setting);
                    continue;
                }
                if (settingType.equalsIgnoreCase("end-volume")) {
                    this.setSetting(volSet.getEndVolume(), setting);
                    continue;
                }
                if (settingType.equalsIgnoreCase("sample-weight")) {
                    this.setSetting(volSet.getSampleWeight(), setting);
                    continue;
                }
                if (settingType.equalsIgnoreCase("protein-concentration")) {
                    this.setSetting(volSet.getProteinConc(), setting);
                    continue;
                }
                if (!settingType.equalsIgnoreCase("neutral-lipid-concentration")) continue;
                this.setSetting(volSet.getNeutralConc(), setting);
            }
        }
    }

    private void parseClassesSettings(Element classSet) {
        String className = classSet.getAttribute("lipid-class");
        LipidClassSettingsPanel classPanel = this.quantSettingsPanel_.getClassSettings().get(className);
        if (classPanel == null) {
            return;
        }
        if (classPanel.getChosenClass() != className) {
            classPanel = this.quantSettingsPanel_.getClassSettings().get(classPanel.getChosenClass());
        }
        if (classPanel != null && classPanel.areStandardsAvailable()) {
            NodeList nl1 = classSet.getChildNodes();
            for (int i = 0; i != nl1.getLength(); ++i) {
                String nodeName = nl1.item(i).getNodeName();
                if (nodeName.equalsIgnoreCase("setting")) {
                    String value;
                    Element setting = (Element)nl1.item(i);
                    String settingType = setting.getAttribute("name");
                    if (settingType.equalsIgnoreCase("dilution-factor")) {
                        classPanel.getGeneralSettingsPanel().getDilutionFactor().setText(setting.getAttribute("value"));
                        continue;
                    }
                    if (settingType.equalsIgnoreCase("all-experiments-same")) {
                        value = setting.getAttribute("value");
                        if (value != null && value.equalsIgnoreCase("true")) {
                            classPanel.getAllSettingsSame().setSelected(true);
                        } else {
                            classPanel.getAllSettingsSame().setSelected(false);
                        }
                        classPanel.changeVisibilitySettingsSame();
                        continue;
                    }
                    if (!settingType.equalsIgnoreCase("all-standards-same")) continue;
                    value = setting.getAttribute("value");
                    if (value != null && value.equalsIgnoreCase("true")) {
                        classPanel.getAllStandardsSame().setSelected(true);
                    } else {
                        classPanel.getAllStandardsSame().setSelected(false);
                    }
                    classPanel.changeVisibilityStandardsSame();
                    continue;
                }
                if (nodeName.equalsIgnoreCase("es-setting")) {
                    Element esSetting = (Element)nl1.item(i);
                    StandardsSettingsPanel standSet = classPanel.getGeneralSettingsPanel();
                    this.setStandardSettingsPanel(standSet, esSetting, false);
                    continue;
                }
                if (nodeName.equalsIgnoreCase("is-setting")) {
                    Element isSetting = (Element)nl1.item(i);
                    StandardsSettingsPanel standSet = classPanel.getGeneralSettingsPanel();
                    this.setStandardSettingsPanel(standSet, isSetting, true);
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("exp-stand-settings")) continue;
                NodeList nl2 = nl1.item(i).getChildNodes();
                for (int j = 0; j != nl2.getLength(); ++j) {
                    if (!nl2.item(j).getNodeName().equalsIgnoreCase("exp-stand-setting")) continue;
                    Element expSetting = (Element)nl2.item(j);
                    String expName = expSetting.getAttribute("name");
                    StandardsSettingsPanel standSet = classPanel.getStandardsSettings().get(expName);
                    if (standSet == null) continue;
                    NodeList nl3 = expSetting.getChildNodes();
                    for (int k = 0; k != nl3.getLength(); ++k) {
                        String nl3NodeName = nl3.item(k).getNodeName();
                        if (nl3NodeName.equalsIgnoreCase("es-setting")) {
                            Element esSetting = (Element)nl3.item(k);
                            this.setStandardSettingsPanel(standSet, esSetting, false);
                            continue;
                        }
                        if (nl3NodeName.equalsIgnoreCase("is-setting")) {
                            Element isSetting = (Element)nl3.item(k);
                            this.setStandardSettingsPanel(standSet, isSetting, true);
                            continue;
                        }
                        if (!nl3NodeName.equalsIgnoreCase("setting")) continue;
                        String value = ((Element)nl3.item(k)).getAttribute("value");
                        standSet.getDilutionFactor().setText(value);
                    }
                }
            }
        }
    }

    private void setStandardSettingsPanel(StandardsSettingsPanel panel, Element setting, boolean isIS) {
        PhysicalUnitInput volumeInp = null;
        PhysicalUnitInput concInp = null;
        String name = setting.getAttribute("name");
        if (isIS) {
            if (name.equalsIgnoreCase("general")) {
                volumeInp = panel.getGeneralIntVolume();
                concInp = panel.getGeneralIntConc();
            } else {
                volumeInp = panel.getIntVolumeSettings().get(name);
                concInp = panel.getIntConcSettings().get(name);
            }
        } else if (name.equalsIgnoreCase("general")) {
            volumeInp = panel.getGeneralExtVolume();
            concInp = panel.getGeneralExtConc();
        } else {
            volumeInp = panel.getExtVolumeSettings().get(name);
            concInp = panel.getExtConcSettings().get(name);
        }
        if (volumeInp != null && concInp != null) {
            NodeList nl = setting.getChildNodes();
            for (int i = 0; i != nl.getLength(); ++i) {
                if (!nl.item(i).getNodeName().equalsIgnoreCase("setting")) continue;
                Element set = (Element)nl.item(i);
                String type = set.getAttribute("name");
                if (type.equalsIgnoreCase("int-volume") || type.equalsIgnoreCase("ext-volume")) {
                    this.setSetting(volumeInp, set);
                    continue;
                }
                if (!type.equalsIgnoreCase("int-concentration") && !type.equalsIgnoreCase("ext-concentration")) continue;
                this.setSetting(concInp, set);
            }
        }
    }

    private void setSetting(PhysicalUnitInput inputMask, Element setting) {
        String value = setting.getAttribute("value");
        String magn = setting.getAttribute("magnitude");
        inputMask.setInputValue(value, magn);
    }
}

