/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import at.tugraz.genome.lda.swing.AbsoluteQuantSettingsPanel;
import at.tugraz.genome.lda.swing.ExpVolumeSettingsPanel;
import at.tugraz.genome.lda.swing.LipidClassSettingsPanel;
import at.tugraz.genome.lda.swing.PhysicalUnitInput;
import at.tugraz.genome.lda.swing.StandardsSettingsPanel;
import at.tugraz.genome.lda.xml.XMLFileWriter;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbsoluteQuantSettingsWholeWriter
extends XMLFileWriter {
    String fileName_;
    AbsoluteQuantSettingsPanel quantSettingsPanel_;

    public AbsoluteQuantSettingsWholeWriter(String fileName, AbsoluteQuantSettingsPanel quantSettingsPanel) {
        this.fileName_ = fileName;
        this.quantSettingsPanel_ = quantSettingsPanel;
    }

    public void writeXMLFile() throws ParserConfigurationException, TransformerConfigurationException, TransformerException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        factory.setValidating(true);
        DOMImplementation implement = builder.getDOMImplementation();
        DocumentType docType = implement.createDocumentType("WholeSet", "ID", "WholeSet.dtd");
        Document newDoc = implement.createDocument("", "abs-settings-whole", docType);
        Element root = newDoc.getDocumentElement();
        Element experimentSettings = newDoc.createElement("exp-settings");
        Hashtable<String, ExpVolumeSettingsPanel> volumeSettings = this.quantSettingsPanel_.getVolumeSettings();
        for (String expName : volumeSettings.keySet()) {
            ExpVolumeSettingsPanel volSetPanel = volumeSettings.get(expName);
            Element expSetting = newDoc.createElement("exp-setting");
            expSetting.setAttribute("name", expName);
            experimentSettings.appendChild(expSetting);
            this.setPhysicalValuesOfSettingsTag(newDoc, expSetting, "probe-volume", volSetPanel.getProbeVolume());
            this.setPhysicalValuesOfSettingsTag(newDoc, expSetting, "end-volume", volSetPanel.getEndVolume());
            this.setPhysicalValuesOfSettingsTag(newDoc, expSetting, "sample-weight", volSetPanel.getSampleWeight());
            this.setPhysicalValuesOfSettingsTag(newDoc, expSetting, "protein-concentration", volSetPanel.getProteinConc());
            this.setPhysicalValuesOfSettingsTag(newDoc, expSetting, "neutral-lipid-concentration", volSetPanel.getNeutralConc());
        }
        root.appendChild(experimentSettings);
        Element classSettings = newDoc.createElement("class-settings");
        Hashtable<String, LipidClassSettingsPanel> classSets = this.quantSettingsPanel_.getClassSettings();
        for (String className : classSets.keySet()) {
            LipidClassSettingsPanel classPanel = classSets.get(className);
            if (classPanel.getAllSettingsSame() == null) continue;
            Element classSetting = newDoc.createElement("class-setting");
            classSetting.setAttribute("lipid-class", className);
            boolean allExpsSame = classPanel.getAllSettingsSame().isSelected();
            boolean allStandsSame = classPanel.getAllStandardsSame().isSelected();
            this.setPhysicalValuesOfSettingsTag(newDoc, classSetting, "all-experiments-same", String.valueOf(allExpsSame), "");
            this.setPhysicalValuesOfSettingsTag(newDoc, classSetting, "all-standards-same", String.valueOf(allStandsSame), "");
            if (allExpsSame) {
                this.generateStandardsSettingsTag(newDoc, classSetting, classPanel.getGeneralSettingsPanel(), allStandsSame);
            } else {
                Hashtable<String, StandardsSettingsPanel> expSettings = classPanel.getStandardsSettings();
                Element expStandSets = newDoc.createElement("exp-stand-settings");
                for (String expName : expSettings.keySet()) {
                    StandardsSettingsPanel expSetting = expSettings.get(expName);
                    Element expStandSet = newDoc.createElement("exp-stand-setting");
                    expStandSet.setAttribute("name", expName);
                    this.generateStandardsSettingsTag(newDoc, expStandSet, expSetting, allStandsSame);
                    expStandSets.appendChild(expStandSet);
                }
                classSetting.appendChild(expStandSets);
            }
            classSettings.appendChild(classSetting);
        }
        root.appendChild(classSettings);
        super.writeXMLFile(this.fileName_, newDoc);
    }

    private void generateStandardsSettingsTag(Document doc, Node parentNode, StandardsSettingsPanel settings, boolean allStandsSame) {
        if (settings.getDilutionFactor().getText() != null && settings.getDilutionFactor().getText().length() > 0) {
            this.setPhysicalValuesOfSettingsTag(doc, parentNode, "dilution-factor", settings.getDilutionFactor().getText(), "");
        }
        if (allStandsSame) {
            Element esSetting = doc.createElement("es-setting");
            esSetting.setAttribute("name", "general");
            this.setPhysicalValuesOfSettingsTag(doc, esSetting, "ext-volume", settings.getGeneralExtVolume());
            this.setPhysicalValuesOfSettingsTag(doc, esSetting, "ext-concentration", settings.getGeneralExtConc());
            parentNode.appendChild(esSetting);
            Element isSetting = doc.createElement("is-setting");
            isSetting.setAttribute("name", "general");
            this.setPhysicalValuesOfSettingsTag(doc, isSetting, "int-volume", settings.getGeneralIntVolume());
            this.setPhysicalValuesOfSettingsTag(doc, isSetting, "int-concentration", settings.getGeneralIntConc());
            parentNode.appendChild(isSetting);
        } else {
            Hashtable<String, PhysicalUnitInput> extVolSettings = settings.getExtVolumeSettings();
            for (String esName : extVolSettings.keySet()) {
                Element esSetting = doc.createElement("es-setting");
                esSetting.setAttribute("name", esName);
                this.setPhysicalValuesOfSettingsTag(doc, esSetting, "ext-volume", extVolSettings.get(esName));
                this.setPhysicalValuesOfSettingsTag(doc, esSetting, "ext-concentration", settings.getExtConcSettings().get(esName));
                parentNode.appendChild(esSetting);
            }
            Hashtable<String, PhysicalUnitInput> intVolSettings = settings.getIntVolumeSettings();
            for (String isName : intVolSettings.keySet()) {
                Element esSetting = doc.createElement("is-setting");
                esSetting.setAttribute("name", isName);
                this.setPhysicalValuesOfSettingsTag(doc, esSetting, "int-volume", intVolSettings.get(isName));
                this.setPhysicalValuesOfSettingsTag(doc, esSetting, "int-concentration", settings.getIntConcSettings().get(isName));
                parentNode.appendChild(esSetting);
            }
        }
    }

    private void setPhysicalValuesOfSettingsTag(Document doc, Node parentNode, String name, PhysicalUnitInput input) {
        this.setPhysicalValuesOfSettingsTag(doc, parentNode, name, input.getValue().getText(), (String)input.getUnitMagnitude().getSelectedItem());
    }

    private void setPhysicalValuesOfSettingsTag(Document doc, Node parentNode, String name, String value, String magnitude) {
        if (value != null && value.length() > 0) {
            Element el = doc.createElement("setting");
            el.setAttribute("name", name);
            el.setAttribute("magnitude", magnitude);
            el.setAttribute("value", value);
            parentNode.appendChild(el);
        }
    }
}

