/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import at.tugraz.genome.lda.exception.AbsoluteSettingsInputException;
import at.tugraz.genome.lda.xml.XMLFileWriter;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class CutoffSettingsWriter
extends XMLFileWriter {
    String fileName_;
    int maxIsotope_;
    Hashtable<String, String> cutoffs_;

    public CutoffSettingsWriter(String fileName, int maxIsotope, Hashtable<String, String> cutoffs) {
        this.fileName_ = fileName;
        this.maxIsotope_ = maxIsotope;
        this.cutoffs_ = cutoffs;
    }

    public void writeXMLFile() throws ParserConfigurationException, TransformerConfigurationException, TransformerException, IOException, AbsoluteSettingsInputException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        factory.setValidating(true);
        DOMImplementation implement = builder.getDOMImplementation();
        DocumentType docType = implement.createDocumentType("CutoffSet", "ID", "CutoffSet.dtd");
        Document newDoc = implement.createDocument("", "cutoff-settings", docType);
        Element root = newDoc.getDocumentElement();
        Element isotopeSetting = newDoc.createElement("isotope");
        isotopeSetting.appendChild(newDoc.createTextNode(String.valueOf(this.maxIsotope_)));
        root.appendChild(isotopeSetting);
        for (String className : this.cutoffs_.keySet()) {
            Element cutoff = newDoc.createElement("cutoff");
            cutoff.setAttribute("class", className);
            try {
                Double.parseDouble(this.cutoffs_.get(className));
            }
            catch (NumberFormatException ex) {
                throw new AbsoluteSettingsInputException("The cut-off of the class " + className + " is not correct! " + ex.getMessage());
            }
            cutoff.setAttribute("value", this.cutoffs_.get(className));
            root.appendChild(cutoff);
        }
        super.writeXMLFile(this.fileName_, newDoc);
    }
}

