/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import at.tugraz.genome.lda.LipidomicsConstants;
import at.tugraz.genome.lda.swing.Range;
import at.tugraz.genome.lda.xml.AbstractXMLSpectraReader;
import at.tugraz.genome.lda.xml.AddScan;
import at.tugraz.genome.maspectras.quantification.CgBase64;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgScan;
import at.tugraz.genome.maspectras.quantification.CgScanHeader;
import at.tugraz.genome.maspectras.quantification.MsMsScan;
import at.tugraz.genome.maspectras.utils.StringUtils;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Hashtable;
import java.util.Vector;

public class MzXMLReader
extends AbstractXMLSpectraReader {
    private CgScanHeader myHeader_;
    protected Vector<String> precursorMz_;
    private int lastMsLevel_;
    private static final String TAG_RUN = "msRun";
    private static final String TAG_PARENT_FILE = "parentFile";
    private static final String TAG_SCAN = "scan";
    private static final String TAG_PEAKS = "peaks";
    private static final String TAG_END_PEAKS = "</peaks>";
    private static final String TAG_PRECURSOR_MZ = "precursorMz";
    private static final String ATTRIBUTE_FILE_NAME = "fileName";
    private static final String ATTRIBUTE_SCAN_COUNT = "scanCount";
    private static final String ATTRIBUTE_START_TIME = "startTime";
    private static final String ATTRIBUTE_END_TIME = "endTime";
    private static final String ATTRIBUTE_NUM = "num";
    private static final String ATTRIBUTE_MS_LEVEL = "msLevel";
    private static final String ATTRIBUTE_LOW_MZ = "lowMz";
    private static final String ATTRIBUTE_HIGH_MZ = "highMz";
    private static final String ATTRIBUTE_PEAKS_COUNT = "peaksCount";
    private static final String ATTRIBUTE_POLARITY = "polarity";
    private static final String ATTRIBUTE_PRECURSOR_INTENSITY = "precursorIntensity";
    private static final String ATTRIBUTE_PRECISION = "precision";
    private static final String ATTRIBUTE_COMPRESSION_TYPE = "compressionType";
    private static final String ATTRIBUTE_RETENTION_TIME = "retentionTime";
    private static final String ATTRIBUTE_BASE_PEAK_MZ = "basePeakMz";
    private static final String ATTRIBUTE_BASE_PEAK_INTENSITY = "basePeakIntensity";
    private static final String ATTRIBUTE_TOTAL_ION_CURRENT = "totIonCurrent";
    private static final String ATTRIBUTE_BYTE_ORDER = "byteOrder";
    private static final String ATTRIBUTE_PAIR_ORDER = "pairOrder";
    private static final String ENTRY_PLUS = "+";
    private static final String ENTRY_MINUS = "-";
    private static final String ENTRY_ZLIB = "zlib";

    public MzXMLReader(AddScan[] callbacks, boolean parseMsMs) {
        super(callbacks, parseMsMs);
    }

    public MzXMLReader(AddScan[] callbacks, boolean parseMsMs, int multiplicationFactorForInt) {
        super(callbacks, parseMsMs, multiplicationFactorForInt);
    }

    @Override
    public String getTagRun() {
        return TAG_RUN;
    }

    @Override
    protected void readMsRun(boolean readOnlyRequiredInfoForMultiThreading) throws CgException {
        this.lastMsLevel_ = 0;
        this.myHeader_ = new CgScanHeader();
        this.writeMsRunAttributes(this.myHeader_);
        this.createAdderHeaders(this.myHeader_, readOnlyRequiredInfoForMultiThreading);
        try {
            int eventType;
            block6: do {
                eventType = this.reader_.getEventType();
                switch (eventType) {
                    case 1: {
                        if (this.reader_.getLocalName().equalsIgnoreCase(TAG_PARENT_FILE)) {
                            for (int i = 0; i < this.reader_.getAttributeCount(); ++i) {
                                if (!this.reader_.getAttributeLocalName(i).equalsIgnoreCase(ATTRIBUTE_FILE_NAME)) continue;
                                for (AddScan adder : this.adders_) {
                                    adder.addParentFileName(StringUtils.getFileNameWOSuffix(this.reader_.getAttributeValue(i)));
                                }
                            }
                            continue block6;
                        }
                        if (!this.reader_.getLocalName().equalsIgnoreCase(TAG_SCAN)) break;
                        if (readOnlyRequiredInfoForMultiThreading) {
                            this.readOnlyRequiredInfoForMultiThreading();
                            break;
                        }
                        this.readScan(null, null);
                        continue block6;
                    }
                    case 2: {
                        if (!this.reader_.getLocalName().equalsIgnoreCase(this.getTagRun())) break;
                        return;
                    }
                }
            } while ((eventType = this.reader_.next()) != 8);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CgException(ex.getMessage());
        }
    }

    private void writeMsRunAttributes(CgScanHeader myHeader_) {
        myHeader_.highestMSLevel = 1;
        for (int count = 0; count < this.reader_.getAttributeCount(); ++count) {
            if (this.reader_.getAttributeLocalName(count).equalsIgnoreCase(ATTRIBUTE_SCAN_COUNT)) {
                myHeader_.ScanCount = Integer.parseInt(this.reader_.getAttributeValue(count));
                continue;
            }
            if (this.reader_.getAttributeLocalName(count) == ATTRIBUTE_START_TIME) {
                myHeader_.StartTime = this.convertTimeFormat(this.reader_.getAttributeValue(count));
                continue;
            }
            if (this.reader_.getAttributeLocalName(count) != ATTRIBUTE_END_TIME) continue;
            myHeader_.EndTime = this.convertTimeFormat(this.reader_.getAttributeValue(count));
        }
    }

    protected float convertTimeFormat(String s) {
        if (s.startsWith("PT")) {
            s = s.substring(2);
        }
        if (s.endsWith("S")) {
            s = s.substring(0, s.length() - 1);
        }
        s = s.replace('e', 'E');
        return Float.parseFloat(s);
    }

    private void createAdderHeaders(CgScanHeader myHeader_, boolean readOnlyRequiredInfoForMultiThreading) throws CgException {
        if (this.adders_ != null && this.adders_.length > 0) {
            for (AddScan adder : this.adders_) {
                adder.AddHeader(myHeader_);
            }
        } else if (!readOnlyRequiredInfoForMultiThreading) {
            throw new CgException("No adder for Header and Scans defined.");
        }
    }

    @Override
    protected void readOnlyRequiredInfoForMultiThreading() throws CgException {
        int i;
        int num = -1;
        int msLevel = 0;
        float lowMz = 0.0f;
        float highMz = 0.0f;
        boolean lowMzFound = false;
        boolean highMzFound = false;
        String polarityString = "";
        int polarity = 0;
        int peaksCount = 0;
        float precursor = -1.0f;
        for (i = 0; i < this.reader_.getAttributeCount(); ++i) {
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_NUM) {
                num = Integer.parseInt(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_MS_LEVEL) {
                msLevel = Integer.parseInt(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_LOW_MZ) {
                lowMz = Float.parseFloat(this.reader_.getAttributeValue(i));
                lowMzFound = true;
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_HIGH_MZ) {
                highMz = Float.parseFloat(this.reader_.getAttributeValue(i));
                highMzFound = true;
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_PEAKS_COUNT) {
                peaksCount = Integer.parseInt(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) != ATTRIBUTE_POLARITY) continue;
            polarityString = this.reader_.getAttributeValue(i);
            if (polarityString.equalsIgnoreCase(ENTRY_PLUS)) {
                polarity = 1;
                continue;
            }
            if (polarityString.equalsIgnoreCase(ENTRY_MINUS)) {
                polarity = 2;
                continue;
            }
            throw new CgException(String.format("The scan contains an unknown polarity %s at scan number: %s", polarityString, num));
        }
        boolean foundMzBorders = false;
        if (lowMzFound && highMzFound) {
            foundMzBorders = true;
        } else if (msLevel == 1 && !this.myHeader_.hasMS1Scans) {
            this.setLowestMz(1000000000);
            this.setHighestMz(0);
        }
        if (msLevel == 1) {
            this.myHeader_.hasMS1Scans = true;
        }
        if (polarity != 0) {
            if (this.currentPolarity_ == 0) {
                this.currentPolarity_ = polarity;
            } else if (this.currentPolarity_ != polarity) {
                this.setPolaritySwitching(true);
            }
        }
        try {
            int eventType = this.reader_.next();
            block9: do {
                block2 : switch (eventType) {
                    case 1: {
                        if (this.reader_.getLocalName() == TAG_PEAKS) {
                            if (msLevel == 1) {
                                if (!foundMzBorders) {
                                    float[] maxima = this.getMaximaFromBinaryDataArray(peaksCount);
                                    lowMz = maxima[0];
                                    highMz = maxima[1];
                                }
                                this.setCurrentGlobalMaxima(lowMz, highMz);
                            } else if (!this.myHeader_.hasMS1Scans && LipidomicsConstants.isShotgun() > 0 && precursor >= 0.0f) {
                                this.setCurrentGlobalMaxima(precursor * 0.999f, precursor * 1.001f);
                            }
                            if (!this.getParseMsMs() || msLevel <= this.myHeader_.highestMSLevel) continue block9;
                            this.myHeader_.highestMSLevel = msLevel;
                            break;
                        }
                        if (this.reader_.getLocalName().equalsIgnoreCase(TAG_PRECURSOR_MZ) && !this.myHeader_.hasMS1Scans && LipidomicsConstants.isShotgun() > 0) {
                            int attributeCount = this.reader_.getAttributeCount();
                            for (i = 0; i < attributeCount; ++i) {
                                if (this.reader_.getAttributeLocalName(i) != ATTRIBUTE_PRECURSOR_INTENSITY) continue;
                                try {
                                    this.reader_.next();
                                    String childNode = this.reader_.getText().trim();
                                    if (childNode == null) continue;
                                    precursor = Float.parseFloat(childNode);
                                    break block2;
                                }
                                catch (Exception ex) {
                                    throw new CgException(ex.getMessage());
                                }
                            }
                            continue block9;
                        }
                        if (!this.reader_.getLocalName().equalsIgnoreCase(TAG_SCAN)) break;
                        this.readOnlyRequiredInfoForMultiThreading();
                        continue block9;
                    }
                    case 2: {
                        if (!this.reader_.getLocalName().equalsIgnoreCase(TAG_SCAN)) break;
                        return;
                    }
                }
            } while ((eventType = this.reader_.next()) != 8);
        }
        catch (Exception ex) {
            throw new CgException(ex.getMessage());
        }
    }

    @Override
    protected float[] getMaximaFromBinaryDataArray(int peaksCount) throws CgException {
        float[] maxima = new float[]{Float.MAX_VALUE, 0.0f};
        if (peaksCount < 1) {
            return maxima;
        }
        int precision = -1;
        String compressionType = null;
        CgBase64 cgb = new CgBase64();
        for (int i = 0; i < this.reader_.getAttributeCount(); ++i) {
            if (this.reader_.getAttributeLocalName(i).equalsIgnoreCase(ATTRIBUTE_PRECISION)) {
                precision = Integer.parseInt(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) != ATTRIBUTE_COMPRESSION_TYPE) continue;
            compressionType = this.reader_.getAttributeValue(i);
        }
        try {
            this.reader_.next();
            String s = this.reader_.getText().trim();
            if (s == null || s.equalsIgnoreCase(TAG_END_PEAKS)) {
                return maxima;
            }
            byte[] decoded = cgb.decode(s);
            if (compressionType != null && compressionType.equalsIgnoreCase(ENTRY_ZLIB)) {
                MzXMLReader.decompressZLIB(decoded);
            }
            ByteBuffer byteBuf = ByteBuffer.wrap(decoded);
            float lowestMzValue = Float.MAX_VALUE;
            float highestMzValue = 0.0f;
            if (precision == 64) {
                double[] doubleArray = new double[decoded.length / 8];
                DoubleBuffer doubleBuf = byteBuf.asDoubleBuffer();
                doubleBuf.get(doubleArray);
                lowestMzValue = (float)doubleArray[0];
                highestMzValue = (float)doubleArray[doubleArray.length - 2];
            } else {
                float[] floatArray = new float[decoded.length / 4];
                FloatBuffer floatBuf = byteBuf.asFloatBuffer();
                floatBuf.get(floatArray);
                lowestMzValue = floatArray[0];
                highestMzValue = floatArray[floatArray.length - 2];
            }
            maxima[0] = lowestMzValue;
            maxima[1] = highestMzValue;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CgException(ex.getMessage());
        }
        return maxima;
    }

    protected void readScan(Vector<CgScan> scBase1, Vector<Range> ranges1) throws CgException {
        int i;
        Vector<CgScan> baseScans = scBase1;
        Vector<Range> scanRanges = ranges1;
        CgScan sc = null;
        int num = 0;
        int msLevel = 0;
        int peaksCount = 0;
        float retentionTime = 0.0f;
        float lowMz = 0.0f;
        float highMz = 0.0f;
        float basePeakMz = 0.0f;
        float basePeakIntensity = 0.0f;
        float totIonCurrent = 0.0f;
        float precursorIntensity = 0.0f;
        String polarityString = "";
        int polarity = 0;
        boolean lowMzFound = false;
        boolean highMzFound = false;
        float precursorMz = -1.0f;
        for (i = 0; i < this.reader_.getAttributeCount(); ++i) {
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_NUM) {
                num = Integer.parseInt(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_MS_LEVEL) {
                msLevel = Integer.parseInt(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_PEAKS_COUNT) {
                peaksCount = Integer.parseInt(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_RETENTION_TIME) {
                retentionTime = this.convertTimeFormat(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_LOW_MZ) {
                lowMz = Float.parseFloat(this.reader_.getAttributeValue(i));
                lowMzFound = true;
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_HIGH_MZ) {
                highMz = Float.parseFloat(this.reader_.getAttributeValue(i));
                highMzFound = true;
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_BASE_PEAK_MZ) {
                basePeakMz = Float.parseFloat(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_BASE_PEAK_INTENSITY) {
                basePeakIntensity = Float.parseFloat(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_TOTAL_ION_CURRENT) {
                totIonCurrent = Float.parseFloat(this.reader_.getAttributeValue(i));
                continue;
            }
            if (this.reader_.getAttributeLocalName(i) != ATTRIBUTE_POLARITY) continue;
            polarityString = this.reader_.getAttributeValue(i);
            if (polarityString.equalsIgnoreCase(ENTRY_PLUS)) {
                polarity = 1;
                continue;
            }
            if (polarityString.equalsIgnoreCase(ENTRY_MINUS)) {
                polarity = 2;
                continue;
            }
            throw new CgException(String.format("The scan contains an unknown polarity %s at scan number: %s", polarityString, num));
        }
        boolean foundMzBorders = false;
        if (lowMzFound && highMzFound) {
            foundMzBorders = true;
        } else if (msLevel == 1 && !this.myHeader_.hasMS1Scans) {
            this.setLowestMz(1000000000);
            this.setHighestMz(0);
        }
        if (msLevel == 1) {
            this.myHeader_.hasMS1Scans = true;
        }
        if (polarity != 0) {
            if (this.currentPolarity_ == 0) {
                this.currentPolarity_ = polarity;
            } else if (this.currentPolarity_ != polarity) {
                this.setPolaritySwitching(true);
            }
        }
        if (msLevel < 3) {
            this.precursorMz_ = new Vector();
        } else if (this.lastMsLevel_ >= msLevel) {
            for (i = this.lastMsLevel_ + 1; i != msLevel; --i) {
                this.precursorMz_.remove(this.precursorMz_.size() - 1);
            }
        }
        this.lastMsLevel_ = msLevel;
        try {
            int eventType = this.reader_.next();
            block10: do {
                block2 : switch (eventType) {
                    case 1: {
                        if (this.reader_.getLocalName().equalsIgnoreCase(TAG_PEAKS)) {
                            if (msLevel == 1) {
                                if (msLevel > this.myHeader_.highestMSLevel) {
                                    this.myHeader_.highestMSLevel = msLevel;
                                }
                                sc = new CgScan(0);
                                sc.Num = num;
                                sc.MsLevel = msLevel;
                                sc.RetentionTime = retentionTime;
                                sc.LowMz = lowMz;
                                sc.HighMz = highMz;
                                sc.BasePeakMz = basePeakMz;
                                sc.BasePeakIntensity = basePeakIntensity;
                                sc.TotIonCurrent = totIonCurrent;
                                sc.setPolarity(polarity);
                                if (this.adders_ != null && this.adders_.length > 0) {
                                    Vector<CgScan> scans = new Vector<CgScan>();
                                    Vector<Range> ranges = new Vector<Range>();
                                    for (AddScan adder : this.adders_) {
                                        if (this.adders_.length == 1) {
                                            scans.add(sc);
                                        } else {
                                            scans.add(new CgScan(sc));
                                        }
                                        ranges.add(new Range(adder.getLowerThreshold(), adder.getUpperThreshold()));
                                    }
                                    this.readPeaks(scans, ranges, peaksCount, false, foundMzBorders);
                                    for (int j = 0; j != this.adders_.length; ++j) {
                                        AddScan adder = this.adders_[j];
                                        sc = scans.get(j);
                                        this.setCurrentGlobalMaxima(sc.LowMz, sc.HighMz);
                                        adder.AddScan(sc);
                                    }
                                    if (msLevel <= this.myHeader_.highestMSLevel) continue block10;
                                    this.myHeader_.highestMSLevel = msLevel;
                                    break;
                                }
                                throw new CgException("No adder for Header and Scans defined.");
                            }
                            if (!this.myHeader_.hasMS1Scans && LipidomicsConstants.isShotgun() > 0 && precursorMz >= 0.0f) {
                                sc = new CgScan(0);
                                sc.Num = num;
                                sc.MsLevel = 1;
                                sc.RetentionTime = retentionTime;
                                sc.BasePeakMz = basePeakMz;
                                sc.BasePeakIntensity = basePeakIntensity;
                                sc.TotIonCurrent = totIonCurrent;
                                sc.setPolarity(polarity);
                                if (this.adders_ != null && this.adders_.length > 0) {
                                    int k;
                                    Vector<CgScan> scans = new Vector<CgScan>();
                                    Vector<Range> ranges = new Vector<Range>();
                                    for (AddScan adder : this.adders_) {
                                        if (this.adders_.length == 1) {
                                            scans.add(sc);
                                        } else {
                                            scans.add(new CgScan(sc));
                                        }
                                        ranges.add(new Range(adder.getLowerThreshold(), adder.getUpperThreshold()));
                                    }
                                    Hashtable mzValues = new Hashtable();
                                    Hashtable intensities = new Hashtable();
                                    float mz = Float.parseFloat(this.getPrecursorMzString(this.precursorMz_));
                                    float intensity = totIonCurrent;
                                    for (k = 0; k != scans.size(); ++k) {
                                        mzValues.put(k, new Vector());
                                        intensities.put(k, new Vector());
                                        if (!(((Range)ranges.get(k)).getStart() <= mz) || !(mz < ((Range)ranges.get(k)).getStop())) continue;
                                        ((Vector)mzValues.get(k)).add(Float.valueOf(mz));
                                        ((Vector)intensities.get(k)).add(Float.valueOf(intensity));
                                    }
                                    for (k = 0; k != scans.size(); ++k) {
                                        CgScan aSc = (CgScan)scans.get(k);
                                        aSc.PeaksCount = ((Vector)mzValues.get(k)).size();
                                        aSc.Scan = new float[((Vector)mzValues.get(k)).size()][2];
                                        for (i = 0; i != ((Vector)mzValues.get(k)).size(); ++i) {
                                            aSc.Scan[i][0] = ((Float)((Vector)mzValues.get(k)).get(i)).floatValue();
                                            aSc.Scan[i][1] = ((Float)((Vector)intensities.get(k)).get(i)).floatValue();
                                        }
                                        if (aSc.PeaksCount <= 0 || foundMzBorders) continue;
                                        aSc.LowMz = mz * 0.999f;
                                        aSc.HighMz = mz * 1.001f;
                                    }
                                    for (int j = 0; j != this.adders_.length; ++j) {
                                        AddScan adder = this.adders_[j];
                                        sc = (CgScan)scans.get(j);
                                        this.setCurrentGlobalMaxima(sc.LowMz, sc.HighMz);
                                        adder.AddScan(sc);
                                    }
                                } else {
                                    throw new CgException("No adder for Header and Scans defined.");
                                }
                            }
                            if (baseScans == null) {
                                baseScans = new Vector();
                                scanRanges = new Vector();
                                for (AddScan adder : this.adders_) {
                                    if (adder.getLastBaseScan() == null) continue;
                                    baseScans.add(adder.getLastBaseScan());
                                    scanRanges.add(new Range(adder.getLowerThreshold(), adder.getUpperThreshold()));
                                }
                            }
                            if (baseScans.size() > 0) {
                                if (this.getParseMsMs()) {
                                    int j;
                                    MsMsScan msmsSc = new MsMsScan(peaksCount, num, msLevel, retentionTime, lowMz, highMz, basePeakMz, basePeakIntensity, totIonCurrent, this.getPrecursorMzString(this.precursorMz_), precursorIntensity, polarity);
                                    Vector<CgScan> qualifiedBaseScans = new Vector<CgScan>();
                                    Vector<Range> qualifiedRanges = new Vector<Range>();
                                    Vector<CgScan> ms2Scans = new Vector<CgScan>();
                                    for (j = 0; j != baseScans.size(); ++j) {
                                        Range range = scanRanges.get(j);
                                        float precMz = msmsSc.getMs1PrecursorMz();
                                        if (precMz < range.getStart() || range.getStop() <= precMz) continue;
                                        qualifiedBaseScans.add(baseScans.get(j));
                                        qualifiedRanges.add(range);
                                        ms2Scans.add(new MsMsScan(msmsSc));
                                    }
                                    if (qualifiedBaseScans.size() <= 0) continue block10;
                                    this.readPeaks(ms2Scans, qualifiedRanges, peaksCount, true, foundMzBorders);
                                    for (j = 0; j != qualifiedBaseScans.size(); ++j) {
                                        ((CgScan)qualifiedBaseScans.get(j)).AddSubscan(ms2Scans.get(j));
                                    }
                                    if (msLevel <= this.myHeader_.highestMSLevel) continue block10;
                                    this.myHeader_.highestMSLevel = msLevel;
                                    break;
                                }
                                for (CgScan scBase : baseScans) {
                                    scBase.AddSubscanNumber(num);
                                }
                                continue block10;
                            }
                            throw new CgException("No base scan for subscan.");
                        }
                        if (this.getParseMsMs() && this.reader_.getLocalName().equalsIgnoreCase(TAG_PRECURSOR_MZ)) {
                            int attributeCount = this.reader_.getAttributeCount();
                            for (i = 0; i < attributeCount; ++i) {
                                if (this.reader_.getAttributeLocalName(i) != ATTRIBUTE_PRECURSOR_INTENSITY) continue;
                                precursorIntensity = Float.parseFloat(this.reader_.getAttributeValue(i));
                                try {
                                    this.reader_.next();
                                    String childNode = this.reader_.getText().trim();
                                    if (childNode == null) continue;
                                    precursorMz = Float.parseFloat(childNode);
                                    this.precursorMz_.add(childNode);
                                    break block2;
                                }
                                catch (Exception ex) {
                                    throw new CgException(ex.getMessage());
                                }
                            }
                            continue block10;
                        }
                        if (!this.reader_.getLocalName().equalsIgnoreCase(TAG_SCAN)) break;
                        if (baseScans != null && baseScans.size() > 0) {
                            this.readScan(baseScans, scanRanges);
                            break;
                        }
                        baseScans = new Vector();
                        scanRanges = new Vector();
                        for (AddScan adder : this.adders_) {
                            if (adder.getLastBaseScan() == null) continue;
                            baseScans.add(adder.getLastBaseScan());
                            scanRanges.add(new Range(adder.getLowerThreshold(), adder.getUpperThreshold()));
                        }
                        this.readScan(baseScans, scanRanges);
                        continue block10;
                    }
                    case 2: {
                        if (!this.reader_.getLocalName().equalsIgnoreCase(TAG_SCAN)) break;
                        return;
                    }
                }
            } while ((eventType = this.reader_.next()) != 8);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CgException(ex.getMessage());
        }
    }

    protected void readPeaks(Vector<CgScan> scans, Vector<Range> ranges, int peaksCount, boolean msms, boolean foundMzBorders) throws CgException {
        int i;
        CgBase64 cgb = new CgBase64();
        String compressionType = null;
        int precision = -1;
        if (scans != null && scans.size() > 0) {
            String byteOrder = "";
            String pairOrder = "";
            for (i = 0; i < this.reader_.getAttributeCount(); ++i) {
                if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_PRECISION) {
                    precision = Integer.parseInt(this.reader_.getAttributeValue(i));
                }
                if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_BYTE_ORDER) {
                    byteOrder = this.reader_.getAttributeValue(i);
                    continue;
                }
                if (this.reader_.getAttributeLocalName(i) == ATTRIBUTE_PAIR_ORDER) {
                    pairOrder = this.reader_.getAttributeValue(i);
                    continue;
                }
                if (this.reader_.getAttributeLocalName(i) != ATTRIBUTE_COMPRESSION_TYPE) continue;
                compressionType = this.reader_.getAttributeValue(i);
            }
            for (CgScan scan : scans) {
                scan.Precision = precision;
                scan.ByteOrder = byteOrder;
                scan.PairOrder = pairOrder;
            }
        }
        float lowestMzValue = Float.MAX_VALUE;
        float highestMzValue = 0.0f;
        try {
            int k;
            float intensity;
            float mzValue;
            int j;
            this.reader_.next();
            if (this.reader_.getEventType() == 2) {
                return;
            }
            String s = this.reader_.getText().trim();
            if (scans == null || scans.size() == 0 || s == null || s.equalsIgnoreCase(TAG_END_PEAKS)) {
                return;
            }
            byte[] decoded = cgb.decode(s);
            if (compressionType != null && compressionType.equalsIgnoreCase(ENTRY_ZLIB)) {
                decoded = MzXMLReader.decompressZLIB(decoded);
            }
            ByteBuffer byteBuf = ByteBuffer.wrap(decoded);
            Hashtable mzValues = new Hashtable();
            Hashtable intensities = new Hashtable();
            for (int k2 = 0; k2 != scans.size(); ++k2) {
                mzValues.put(k2, new Vector());
                intensities.put(k2, new Vector());
            }
            if (precision == 64) {
                double[] doubleArray = new double[decoded.length / 8];
                DoubleBuffer doubleBuf = byteBuf.asDoubleBuffer();
                doubleBuf.get(doubleArray);
                j = 0;
                for (i = 0; i < peaksCount; ++i) {
                    mzValue = (float)doubleArray[j++];
                    intensity = (float)doubleArray[j++];
                    if (mzValue < lowestMzValue) {
                        lowestMzValue = mzValue;
                    }
                    if (mzValue > highestMzValue) {
                        highestMzValue = mzValue;
                    }
                    if (!msms && scans.size() > 1 && (mzValue < this.getMaxRange().getStart() || this.getMaxRange().getStop() <= mzValue)) continue;
                    for (k = 0; k != scans.size(); ++k) {
                        if (!msms && (!(ranges.get(k).getStart() <= mzValue) || !(mzValue < ranges.get(k).getStop()))) continue;
                        ((Vector)mzValues.get(k)).add(Float.valueOf(mzValue));
                        ((Vector)intensities.get(k)).add(Float.valueOf(intensity));
                    }
                }
            } else {
                float[] floatArray = new float[decoded.length / 4];
                FloatBuffer floatBuf = byteBuf.asFloatBuffer();
                floatBuf.get(floatArray);
                j = 0;
                for (i = 0; i < peaksCount; ++i) {
                    mzValue = floatArray[j++];
                    intensity = floatArray[j++];
                    if (mzValue < lowestMzValue) {
                        lowestMzValue = mzValue;
                    }
                    if (mzValue > highestMzValue) {
                        highestMzValue = mzValue;
                    }
                    if (!msms && scans.size() > 1 && (mzValue < this.getMaxRange().getStart() || this.getMaxRange().getStop() <= mzValue)) continue;
                    for (k = 0; k != scans.size(); ++k) {
                        if (!msms && (!(ranges.get(k).getStart() <= mzValue) || !(mzValue < ranges.get(k).getStop()))) continue;
                        ((Vector)mzValues.get(k)).add(Float.valueOf(mzValue));
                        ((Vector)intensities.get(k)).add(Float.valueOf(intensity));
                    }
                }
            }
            for (int k3 = 0; k3 != scans.size(); ++k3) {
                CgScan sc = scans.get(k3);
                sc.PeaksCount = ((Vector)mzValues.get(k3)).size();
                sc.Scan = new float[((Vector)mzValues.get(k3)).size()][2];
                for (i = 0; i != ((Vector)mzValues.get(k3)).size(); ++i) {
                    sc.Scan[i][0] = ((Float)((Vector)mzValues.get(k3)).get(i)).floatValue();
                    sc.Scan[i][1] = ((Float)((Vector)intensities.get(k3)).get(i)).floatValue();
                }
                if (sc.PeaksCount <= 0 || foundMzBorders) continue;
                sc.LowMz = lowestMzValue;
                sc.HighMz = highestMzValue;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CgException(ex.getMessage());
        }
    }
}

