/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import at.tugraz.genome.lda.utils.RangeInteger;
import at.tugraz.genome.lda.xml.AddScan;
import at.tugraz.genome.lda.xml.MzMLReader;
import at.tugraz.genome.lda.xml.MzXMLReader;
import at.tugraz.genome.lda.xml.RawToChromThread;
import at.tugraz.genome.lda.xml.XMLSpectraReader;
import at.tugraz.genome.maspectras.quantification.CgException;
import at.tugraz.genome.maspectras.quantification.CgScan;
import at.tugraz.genome.maspectras.quantification.CgScanHeader;
import at.tugraz.genome.maspectras.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class RawToChromTranslator
implements AddScan {
    private Hashtable<String, Integer> m_scanCount;
    private Hashtable<String, Hashtable<Integer, Integer>> polarity_scanCount_;
    private String m_fileName;
    private int lowestMz;
    private int highestMz;
    private Hashtable<String, String[]> chromFileName_;
    private Hashtable<String, String[]> indexFileName_;
    private Hashtable<String, String[]> headerFileName_;
    private Hashtable<String, String[]> retentionTimeFileName_;
    private Hashtable<Integer, Hashtable<Integer, RangeInteger>> threadBoundaries_;
    protected XMLSpectraReader m_reader;
    private Hashtable<Integer, RawToChromThread> translators_;
    private int multiplicationFactorForInt_ = 1000;
    private int lowestResolution_ = 1;
    private int elementsForBatchCalculation_ = 1000;
    private String fileType_;
    private int maxMBForChromTranslation_;
    private int numberOfThreads_;
    private boolean msms_;
    private int highestMsLevel_;
    private Hashtable<String, Hashtable<Integer, Hashtable<Integer, Integer>>> numberOfMs2Scans_;
    private boolean msmsInSeveralFiles_;
    private int msmsSeveralFilesHighestLevel_;
    private Hashtable<Integer, Integer> lowestMzs_;
    private Hashtable<Integer, Integer> highestMzs_;
    private Hashtable<Integer, Hashtable<String, Integer>> scanCounts_;
    private Hashtable<Integer, Hashtable<String, Hashtable<Integer, Integer>>> polarityScanCounts_;
    private Hashtable<String, CgScanHeader> headerHash_;
    private Hashtable<String, CgScan[]> scanHash_;
    private Hashtable<String, Hashtable<Integer, Integer>> highestMsLevelHash_;
    private String currentFileName_;
    private static final String NO_NAME_PLACEHOLDER = "";
    private Timer timer_;
    private boolean oneIterationFinished_ = false;
    private String errorString_ = null;
    private Hashtable<Integer, Integer> quantStatus_;
    private static final int STATUS_WAITING = 0;
    private static final int STATUS_CALCULATING = 1;
    private static final int STATUS_FINISHED = 2;
    private static final int BUFFER_SIZE = 4096;
    private float lowerThreshold_ = 0.0f;
    private float upperThreshold_ = 1000000.0f;
    private int numberOfIterations_;
    private boolean polaritySwitching_ = false;

    public RawToChromTranslator(String mzXMLPath, String fileType, int maxMBForChromTranslation, int multiplicationFactorForInt, int lowestResulution) {
        this(mzXMLPath, fileType, maxMBForChromTranslation);
        this.multiplicationFactorForInt_ = multiplicationFactorForInt;
        this.lowestResolution_ = lowestResulution;
        this.elementsForBatchCalculation_ = this.multiplicationFactorForInt_ / this.lowestResolution_;
    }

    private RawToChromTranslator(String mzXMLPath, String fileType, int maxMBForChromTranslation) {
        this.m_fileName = mzXMLPath;
        this.fileType_ = fileType;
        this.maxMBForChromTranslation_ = maxMBForChromTranslation;
        this.msms_ = false;
        this.highestMsLevelHash_ = new Hashtable();
        this.initStoreHashes();
        this.highestMsLevel_ = 1;
        this.numberOfThreads_ = 1;
    }

    public RawToChromTranslator(String mzXmlPath, String fileType, int maxMBForChromTranslation, int numberOfThreads, int multiplicationFactorForInt, int lowestResulution, boolean msms) {
        this(mzXmlPath, fileType, maxMBForChromTranslation, multiplicationFactorForInt, lowestResulution);
        this.msms_ = msms;
        this.numberOfThreads_ = numberOfThreads;
    }

    @Override
    public void AddHeader(CgScanHeader hx) throws CgException {
        this.currentFileName_ = NO_NAME_PLACEHOLDER;
        if (hx.fileName != null) {
            this.currentFileName_ = hx.fileName;
        }
        this.headerHash_.put(this.currentFileName_, hx);
        this.scanHash_.put(this.currentFileName_, new CgScan[hx.ScanCount]);
        this.m_scanCount.put(this.currentFileName_, 0);
        Hashtable<Integer, Integer> polarityScans = new Hashtable<Integer, Integer>();
        polarityScans.put(0, 0);
        polarityScans.put(1, 0);
        polarityScans.put(2, 0);
        this.polarity_scanCount_.put(this.currentFileName_, polarityScans);
    }

    @Override
    public void AddScan(CgScan sx) throws CgException {
        if (!this.scanHash_.containsKey(this.currentFileName_)) {
            throw new CgException("m_scans Array not allocated");
        }
        if (this.scanHash_.get(this.currentFileName_).length == this.m_scanCount.get(this.currentFileName_)) {
            return;
        }
        this.scanHash_.get((Object)this.currentFileName_)[this.m_scanCount.get((Object)this.currentFileName_).intValue()] = sx;
        this.m_scanCount.put(this.currentFileName_, this.m_scanCount.get(this.currentFileName_) + 1);
        this.polarity_scanCount_.get(this.currentFileName_).put(sx.getPolarity(), this.polarity_scanCount_.get(this.currentFileName_).get(sx.getPolarity()) + 1);
    }

    @Override
    public void setStartStopHeader(CgScanHeader hx) throws CgException {
        if (!this.headerHash_.containsKey(this.currentFileName_)) {
            throw new CgException("No header defined");
        }
        this.headerHash_.get((Object)this.currentFileName_).StartTime = hx.StartTime;
        this.headerHash_.get((Object)this.currentFileName_).EndTime = hx.EndTime;
    }

    @Override
    public CgScan getLastBaseScan() {
        for (int i = this.m_scanCount.get(this.currentFileName_) - 1; i > -1; --i) {
            if (!this.scanHash_.containsKey(this.currentFileName_) || this.scanHash_.get((Object)this.currentFileName_)[i].MsLevel != 1) continue;
            return this.scanHash_.get(this.currentFileName_)[i];
        }
        return null;
    }

    @Override
    public void addParentFileName(String fileName) throws CgException {
        if (this.currentFileName_.equalsIgnoreCase(NO_NAME_PLACEHOLDER)) {
            CgScanHeader header = this.headerHash_.get(this.currentFileName_);
            header.fileName = fileName;
            this.headerHash_.remove(this.currentFileName_);
            CgScan[] scans = this.scanHash_.get(this.currentFileName_);
            this.scanHash_.remove(this.currentFileName_);
            Integer count = this.m_scanCount.get(this.currentFileName_);
            this.m_scanCount.remove(this.currentFileName_);
            Hashtable<Integer, Integer> polarityCount = this.polarity_scanCount_.get(this.currentFileName_);
            this.polarity_scanCount_.remove(this.currentFileName_);
            this.currentFileName_ = fileName;
            header.fileName = fileName;
            this.headerHash_.put(this.currentFileName_, header);
            this.scanHash_.put(this.currentFileName_, scans);
            this.m_scanCount.put(this.currentFileName_, count);
            this.polarity_scanCount_.put(this.currentFileName_, polarityCount);
        }
    }

    public void translateToChromatograms() throws CgException {
        this.msmsInSeveralFiles_ = false;
        this.msmsSeveralFilesHighestLevel_ = 1;
        this.lowestMzs_ = new Hashtable();
        this.highestMzs_ = new Hashtable();
        this.scanCounts_ = new Hashtable();
        this.polarityScanCounts_ = new Hashtable();
        this.oneIterationFinished_ = false;
        this.errorString_ = null;
        if (this.msms_) {
            int msLevel = 2;
            while (new File(this.m_fileName + String.valueOf(msLevel)).exists()) {
                this.msmsInSeveralFiles_ = true;
                this.msmsSeveralFilesHighestLevel_ = msLevel++;
            }
            for (int i = this.msmsSeveralFilesHighestLevel_; i != 0; --i) {
                this.translateToChromatograms(i);
            }
        } else {
            this.translateToChromatograms(1);
        }
        try {
            this.writeHeaderFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CgException(e.getMessage());
        }
    }

    public Set<String> getOriginalFileNames() {
        return this.headerHash_.keySet();
    }

    private void translateToChromatograms(int msLevel) throws CgException {
        long time = System.currentTimeMillis();
        this.readHeaderInformation(msLevel);
        if (this.numberOfIterations_ > 1 || this.numberOfThreads_ > 1) {
            this.m_scanCount = new Hashtable();
        }
        String suffix = NO_NAME_PLACEHOLDER;
        if (msLevel > 1) {
            suffix = String.valueOf(msLevel);
        }
        this.initTranslatorObjects();
        for (int i = 0; i != this.numberOfIterations_; ++i) {
            System.out.println("Starting iteration: " + (i + 1));
            this.quantStatus_ = new Hashtable();
            for (int j = 0; j != this.numberOfThreads_; ++j) {
                RangeInteger threshold = this.getLowerUpperThreshold(i, j);
                String[] directories = new String[2];
                if (this.polaritySwitching_) {
                    directories[0] = this.getCorrespondingThreadDirectory(1, i, j);
                    directories[1] = this.getCorrespondingThreadDirectory(2, i, j);
                } else {
                    directories[0] = this.getCorrespondingThreadDirectory(0, i, j);
                    directories[1] = null;
                }
                RawToChromThread thread = new RawToChromThread(this.translators_.get(j));
                thread.setRequiredInformation(directories, threshold.getStart(), threshold.getStop());
                this.translators_.put(j, thread);
                this.quantStatus_.put(j, 0);
            }
            AddScan[] adders = this.getAdders();
            this.m_reader.setAdders(adders);
            if (this.numberOfIterations_ > 1 || this.numberOfThreads_ > 1) {
                this.m_reader.ReadFile(this.m_fileName + suffix);
            } else {
                this.translators_.get(0).setReadXmlContent(this.headerHash_, this.scanHash_, this.m_scanCount, this.polarity_scanCount_);
            }
            if (this.numberOfThreads_ > 1) {
                this.timer_ = new Timer();
                ThreadSupervisor supervisor = new ThreadSupervisor(msLevel, i);
                this.timer_.schedule((TimerTask)supervisor, 10L, 100L);
                while (!this.oneIterationFinished_) {
                    try {
                        this.wait(1000L);
                    }
                    catch (Exception directories) {}
                }
                try {
                    this.wait(500L);
                }
                catch (Exception directories) {
                    // empty catch block
                }
                this.oneIterationFinished_ = false;
                this.timer_.cancel();
                this.timer_ = null;
                supervisor = null;
                continue;
            }
            try {
                RawToChromThread singleThread = this.translators_.get(0);
                String dir = this.m_fileName.substring(0, this.m_fileName.lastIndexOf(".")) + ".chrom/";
                if (i > 0) {
                    dir = dir + String.valueOf(i) + "/";
                    File dirFile = new File(dir);
                    dirFile.mkdir();
                }
                singleThread.writeToChrom();
                if (i == 0) {
                    this.m_scanCount = singleThread.getm_scanCount();
                    this.polarity_scanCount_ = singleThread.getPolarityScanCount();
                    this.scanCounts_.put(msLevel, this.m_scanCount);
                    this.polarityScanCounts_.put(msLevel, this.polarity_scanCount_);
                    try {
                        singleThread.writeRetentionTimeFile(this.retentionTimeFileName_, this.polaritySwitching_);
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                        this.errorString_ = iox.getMessage();
                    }
                    this.numberOfMs2Scans_ = singleThread.getNumberOfMs2Scans();
                }
                singleThread.cleanUp();
                System.gc();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.errorString_ = ex.getMessage();
            }
        }
        for (RawToChromThread translator : this.translators_.values()) {
            translator = null;
        }
        this.translators_ = null;
        if (this.errorString_ != null) {
            throw new CgException(this.errorString_);
        }
        this.mergeResults();
        try {
            this.checkHighestMsLevel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Total time: " + (System.currentTimeMillis() - time) / 1000L + " secs");
    }

    private void mergeResults() {
        if (this.numberOfIterations_ > 1 || this.numberOfThreads_ > 1) {
            this.numberOfMs2Scans_ = new Hashtable();
            this.mergeResults(0);
            if (this.polaritySwitching_) {
                this.mergeResults(1);
            }
        }
    }

    private void mergeResults(int filePosition) {
        int totalSlices = this.numberOfIterations_ * this.numberOfThreads_;
        try {
            for (String key : this.headerHash_.keySet()) {
                String baseDir = this.getBaseDir(filePosition);
                if (this.msms_ && !this.msmsInSeveralFiles_) {
                    Hashtable<Integer, Hashtable<Object, Object>> msmsScans = new Hashtable();
                    if (this.numberOfMs2Scans_.containsKey(key)) {
                        msmsScans = this.numberOfMs2Scans_.get(key);
                    }
                    msmsScans.put(filePosition, new Hashtable());
                    this.numberOfMs2Scans_.put(key, msmsScans);
                }
                for (int i = 1; i <= this.highestMsLevel_; ++i) {
                    String levelSuffix = NO_NAME_PLACEHOLDER;
                    if (i > 1) {
                        levelSuffix = String.valueOf(i);
                    }
                    Hashtable<Integer, Integer> lines = new Hashtable<Integer, Integer>();
                    Hashtable<Integer, Long> indices = new Hashtable<Integer, Long>();
                    int count = 0;
                    long previousLength = 0L;
                    DataInputStream indexStream = new DataInputStream(new FileInputStream(this.indexFileName_.get(key)[filePosition] + levelSuffix));
                    count = this.readIndexFile(indexStream, lines, indices, count, previousLength);
                    indexStream.close();
                    previousLength += new File(this.chromFileName_.get(key)[filePosition] + levelSuffix).length();
                    for (int j = 1; j != totalSlices; ++j) {
                        String dir = baseDir + String.valueOf(j) + "/";
                        String indexFileName = dir + StringUtils.getJustFileName(this.indexFileName_.get(key)[filePosition]) + levelSuffix;
                        DataInputStream in = new DataInputStream(new FileInputStream(indexFileName));
                        count = this.readIndexFile(in, lines, indices, count, previousLength);
                        in.close();
                        previousLength += new File(dir + StringUtils.getJustFileName(this.chromFileName_.get(key)[filePosition]) + levelSuffix).length();
                    }
                    DataOutputStream streamIndex2 = new DataOutputStream(new FileOutputStream(this.indexFileName_.get(key)[filePosition] + levelSuffix));
                    for (int j = 0; j != count; ++j) {
                        streamIndex2.writeInt(lines.get(j));
                        streamIndex2.writeLong(indices.get(j));
                    }
                    streamIndex2.close();
                    if (i > 1) {
                        Hashtable<Integer, Float> retentionTimes = new Hashtable<Integer, Float>();
                        DataInputStream rttStream = new DataInputStream(new FileInputStream(this.retentionTimeFileName_.get(key)[filePosition] + levelSuffix));
                        this.readRetentionTimeFile(rttStream, retentionTimes);
                        rttStream.close();
                        for (int j = 1; j != totalSlices; ++j) {
                            String dir = baseDir + String.valueOf(j) + "/";
                            String rttFileName = dir + StringUtils.getJustFileName(this.retentionTimeFileName_.get(key)[filePosition]) + levelSuffix;
                            DataInputStream in = new DataInputStream(new FileInputStream(rttFileName));
                            this.readRetentionTimeFile(in, retentionTimes);
                            in.close();
                        }
                        ArrayList<Integer> scanNumbers = new ArrayList<Integer>(retentionTimes.keySet());
                        Collections.sort(scanNumbers);
                        DataOutputStream streamRtt2 = new DataOutputStream(new FileOutputStream(this.retentionTimeFileName_.get(key)[filePosition] + levelSuffix));
                        for (Integer scanNumber : scanNumbers) {
                            streamRtt2.writeInt(scanNumber);
                            streamRtt2.writeFloat(retentionTimes.get(scanNumber).floatValue());
                        }
                        streamRtt2.close();
                        this.numberOfMs2Scans_.get(key).get(filePosition).put(i, scanNumbers.size());
                    }
                    BufferedOutputStream streamChrom2 = new BufferedOutputStream(new FileOutputStream(this.chromFileName_.get(key)[filePosition] + levelSuffix, true));
                    for (int j = 1; j != totalSlices; ++j) {
                        String dir = baseDir + String.valueOf(j) + "/";
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(dir + StringUtils.getJustFileName(this.chromFileName_.get(key)[filePosition]) + levelSuffix));
                        RawToChromTranslator.append(in, streamChrom2);
                        in.close();
                    }
                    streamChrom2.close();
                }
                for (int j = 1; j != totalSlices; ++j) {
                    String dir = baseDir + String.valueOf(j) + "/";
                    File dirFile = new File(dir);
                    for (File file : dirFile.listFiles()) {
                        file.delete();
                    }
                    dirFile.delete();
                }
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
    }

    private void checkHighestMsLevel() throws IOException {
        for (String key : this.headerHash_.keySet()) {
            Hashtable<Integer, Integer> polarityMsLevels = this.highestMsLevelHash_.get(key);
            for (Integer filePosition : polarityMsLevels.keySet()) {
                int highestMsLevel;
                for (highestMsLevel = polarityMsLevels.get(filePosition).intValue(); highestMsLevel > 1; --highestMsLevel) {
                    String levelSuffix = String.valueOf(highestMsLevel);
                    File rttFile = new File(this.retentionTimeFileName_.get(key)[filePosition] + levelSuffix);
                    if (rttFile.length() != 0L) break;
                    File indexFile = new File(this.indexFileName_.get(key)[filePosition] + levelSuffix);
                    File chromFile = new File(this.chromFileName_.get(key)[filePosition] + levelSuffix);
                    chromFile.delete();
                    indexFile.delete();
                    rttFile.delete();
                }
                polarityMsLevels.put(filePosition, highestMsLevel);
            }
        }
    }

    private void readHeaderInformation(int msLevel) {
        block23: {
            String suffix = NO_NAME_PLACEHOLDER;
            this.chromFileName_ = new Hashtable();
            this.indexFileName_ = new Hashtable();
            this.headerFileName_ = new Hashtable();
            this.retentionTimeFileName_ = new Hashtable();
            if (msLevel > 1) {
                suffix = String.valueOf(msLevel);
            }
            this.m_scanCount = new Hashtable();
            this.threadBoundaries_ = new Hashtable();
            File fileInfo = new File(this.m_fileName + suffix);
            long fileSize = fileInfo.length();
            this.numberOfIterations_ = Integer.parseInt(Long.toString(fileSize / ((long)this.maxMBForChromTranslation_ * 1024L * 1024L))) + 1;
            System.out.println("Number of iterations: " + this.numberOfIterations_);
            try {
                AddScan[] adders;
                this.m_reader = null;
                String justFileName = NO_NAME_PLACEHOLDER;
                if (this.fileType_.equals("mzXML")) {
                    adders = new AddScan[]{this};
                    this.m_reader = new MzXMLReader(adders, this.msms_ && !this.msmsInSeveralFiles_, this.multiplicationFactorForInt_);
                    justFileName = this.m_fileName.endsWith(".mzXML") ? this.m_fileName.substring(0, this.m_fileName.length() - ".mzXML".length()) : this.m_fileName;
                }
                if (this.fileType_.equals("mzML")) {
                    adders = new AddScan[]{this};
                    this.m_reader = new MzMLReader(adders, this.msms_ && !this.msmsInSeveralFiles_, this.multiplicationFactorForInt_);
                    justFileName = this.m_fileName.endsWith(".mzML") ? this.m_fileName.substring(0, this.m_fileName.length() - ".mzML".length()) : this.m_fileName;
                }
                if (this.m_reader != null) {
                    if (this.numberOfIterations_ > 1 || this.numberOfThreads_ > 1) {
                        this.m_reader.ReadFile(this.m_fileName + suffix, true);
                    } else {
                        this.m_reader.ReadFile(this.m_fileName + suffix);
                    }
                    this.polaritySwitching_ = this.m_reader.usesPolaritySwitching();
                    if (this.headerHash_.size() == 1) {
                        String justTheName = StringUtils.getJustFileName(justFileName);
                        this.generateChromDirectoryAndFiles(justFileName, justTheName, this.headerHash_.keySet().iterator().next(), suffix);
                    } else if (this.headerHash_.size() > 1) {
                        String directory = StringUtils.extractDirName(this.m_fileName);
                        for (String name : this.headerHash_.keySet()) {
                            String chromDirName = directory + File.separator + name;
                            this.generateChromDirectoryAndFiles(chromDirName, name, name, suffix);
                        }
                    }
                    this.highestMz = this.m_reader.getHighestMz();
                    this.lowestMz = this.m_reader.getLowestMz();
                    this.lowestMzs_.put(msLevel, this.lowestMz);
                    this.highestMzs_.put(msLevel, this.highestMz);
                    int nrOfLLowResItems = this.highestMz - this.lowestMz;
                    int previousStartLine = 0;
                    for (int i = 0; i != this.numberOfIterations_; ++i) {
                        int lineNumber = (i + 1) * nrOfLLowResItems / this.numberOfIterations_;
                        if (i == this.numberOfIterations_ - 1) {
                            lineNumber = this.highestMz - this.lowestMz;
                        } else if (lineNumber % this.lowestResolution_ != 0) {
                            lineNumber = lineNumber % this.lowestResolution_ < this.lowestResolution_ - lineNumber % this.lowestResolution_ ? (lineNumber -= lineNumber % this.lowestResolution_) : (lineNumber += this.lowestResolution_ - lineNumber % this.lowestResolution_);
                        }
                        int previousThreadLine = previousStartLine;
                        Hashtable<Integer, RangeInteger> rangeBoundaries = new Hashtable<Integer, RangeInteger>();
                        for (int j = 0; j != this.numberOfThreads_; ++j) {
                            int threadLine = (j + 1) * (lineNumber - previousStartLine) / this.numberOfThreads_ + previousStartLine;
                            if (j == this.numberOfThreads_ - 1) {
                                threadLine = lineNumber;
                            } else if (threadLine % this.lowestResolution_ != 0) {
                                threadLine = threadLine % this.lowestResolution_ < this.lowestResolution_ - threadLine % this.lowestResolution_ ? (threadLine -= threadLine % this.lowestResolution_) : (threadLine += this.lowestResolution_ - threadLine % this.lowestResolution_);
                            }
                            rangeBoundaries.put(j, new RangeInteger(previousThreadLine + this.lowestMz, new Integer(threadLine + this.lowestMz)));
                            previousThreadLine = threadLine;
                        }
                        this.threadBoundaries_.put(i, rangeBoundaries);
                        previousStartLine = lineNumber;
                    }
                    break block23;
                }
                throw new CgException("No readable file format.");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (String fileName : this.headerHash_.keySet()) {
            if (this.headerHash_.get((Object)fileName).highestMSLevel > this.highestMsLevel_) {
                this.highestMsLevel_ = this.headerHash_.get((Object)fileName).highestMSLevel;
            }
            Hashtable<Integer, Integer> polarityMsLevels = new Hashtable<Integer, Integer>();
            polarityMsLevels.put(0, this.headerHash_.get((Object)fileName).highestMSLevel);
            if (this.polaritySwitching_) {
                polarityMsLevels.put(1, this.headerHash_.get((Object)fileName).highestMSLevel);
            }
            this.highestMsLevelHash_.put(fileName, polarityMsLevels);
        }
    }

    private void initTranslatorObjects() {
        this.translators_ = new Hashtable();
        for (int i = 0; i != this.numberOfThreads_; ++i) {
            RawToChromThread thread = new RawToChromThread(this.msms_, this.multiplicationFactorForInt_, this.lowestResolution_, this.highestMsLevel_);
            thread.setStaticInformation(this.elementsForBatchCalculation_, this.lowestMz, this.highestMz, this.chromFileName_, this.indexFileName_, this.retentionTimeFileName_);
            this.translators_.put(i, thread);
        }
    }

    private void writeHeaderFile() throws IOException {
        for (String key : this.headerFileName_.keySet()) {
            if (this.polaritySwitching_) {
                this.writeHeaderFile(this.headerFileName_.get(key)[0], key, 1);
                this.writeHeaderFile(this.headerFileName_.get(key)[1], key, 2);
                continue;
            }
            this.writeHeaderFile(this.headerFileName_.get(key)[0], key, 0);
        }
    }

    private void writeHeaderFile(String fileName, String key, int polarity) throws IOException {
        int filePosition = 0;
        if (polarity == 2) {
            filePosition = 1;
        }
        Properties props = new Properties();
        props.put("mzMultiplicationFactorForInt", String.valueOf(this.multiplicationFactorForInt_));
        props.put("lowestResolution", String.valueOf(this.lowestResolution_));
        props.put("lowestMz", String.valueOf(this.lowestMz));
        props.put("highestMz", String.valueOf(this.highestMz));
        props.put("numberOfScans", String.valueOf(this.getCorrectScanCount(key, polarity)));
        props.put("numberOfEntriesForIndex", String.valueOf(1000));
        props.put("indexFile", this.indexFileName_.get(key)[filePosition]);
        props.put("indexedFile", this.chromFileName_.get(key)[filePosition]);
        props.put("retentionTimeFile", this.retentionTimeFileName_.get(key)[filePosition]);
        int highestLevel = this.highestMsLevelHash_.get(key).get(filePosition);
        if (this.msmsInSeveralFiles_) {
            highestLevel = this.msmsSeveralFilesHighestLevel_;
        }
        props.put("msLevel", String.valueOf(highestLevel));
        if (this.msms_ && highestLevel > 1) {
            if (this.msmsInSeveralFiles_) {
                props.put("msmsType", "fullMSMSScan");
            } else {
                props.put("msmsType", "precursorFragmentation");
            }
            for (int i = 2; i <= highestLevel; ++i) {
                props.put("indexFile" + String.valueOf(i), this.indexFileName_.get(key)[filePosition] + String.valueOf(i));
                props.put("indexedFile" + String.valueOf(i), this.chromFileName_.get(key)[filePosition] + String.valueOf(i));
                props.put("retentionTimeFile" + String.valueOf(i), this.retentionTimeFileName_.get(key)[filePosition] + String.valueOf(i));
                if (this.msmsInSeveralFiles_) {
                    props.put("lowestMz" + String.valueOf(i), String.valueOf(this.lowestMzs_.get(i)));
                    props.put("highestMz" + String.valueOf(i), String.valueOf(this.highestMzs_.get(i)));
                    props.put("numberOfScans" + String.valueOf(i), String.valueOf(this.getCorrectScanCountMsMsSeveralFiles(i, key, polarity)));
                    continue;
                }
                props.put("numberOfScans" + String.valueOf(i), String.valueOf(this.numberOfMs2Scans_.get(key).get(filePosition).get(i)));
            }
        }
        if (this.polaritySwitching_) {
            String polarityString = null;
            if (polarity == 1) {
                polarityString = "positive";
            } else if (polarity == 2) {
                polarityString = "negative";
            }
            props.put("polaritySwitched", polarityString);
        }
        FileOutputStream stream = new FileOutputStream(fileName);
        props.store(stream, "Header");
        stream.close();
    }

    private RangeInteger getLowerUpperThreshold(int iterationNumber, int threadNumber) {
        return this.threadBoundaries_.get(iterationNumber).get(threadNumber);
    }

    private void generateChromDirectoryAndFiles(String chromDirName, String fileName, String key, String suffix) {
        if (this.polaritySwitching_) {
            this.generateChromFileNames(fileName + "_positive", chromDirName + "_positive" + ".chrom", key, suffix, 0);
            this.generateChromFileNames(fileName + "_negative", chromDirName + "_negative" + ".chrom", key, suffix, 1);
        } else {
            this.generateChromFileNames(fileName, chromDirName + ".chrom", key, suffix, 0);
        }
    }

    private void generateChromFileNames(String fileName, String chromDirPath, String key, String suffix, int position) {
        File chromDir = new File(chromDirPath);
        chromDir.mkdir();
        String filePath = chromDir.getAbsolutePath() + File.separator + fileName;
        String[] chromFiles = new String[]{null, null};
        String[] indexFiles = new String[]{null, null};
        String[] headerFiles = new String[]{null, null};
        String[] rtFiles = new String[]{null, null};
        if (this.chromFileName_.containsKey(key)) {
            chromFiles = this.chromFileName_.get(key);
            indexFiles = this.indexFileName_.get(key);
            headerFiles = this.headerFileName_.get(key);
            rtFiles = this.retentionTimeFileName_.get(key);
        }
        chromFiles[position] = filePath + ".chrom" + suffix;
        indexFiles[position] = filePath + ".idx" + suffix;
        headerFiles[position] = filePath + ".head" + suffix;
        rtFiles[position] = filePath + ".rtt" + suffix;
        this.chromFileName_.put(key, chromFiles);
        this.indexFileName_.put(key, indexFiles);
        this.headerFileName_.put(key, headerFiles);
        this.retentionTimeFileName_.put(key, rtFiles);
    }

    private String getCorrespondingThreadDirectory(int polarity, int iteration, int threadNr) {
        String dir = this.m_fileName.substring(0, this.m_fileName.lastIndexOf("."));
        if (polarity == 1) {
            dir = dir + "_positive";
        } else if (polarity == 2) {
            dir = dir + "_negative";
        }
        dir = dir + ".chrom/";
        int currentPiece = iteration * this.numberOfThreads_ + threadNr;
        if (currentPiece > 0) {
            dir = dir + String.valueOf(currentPiece) + "/";
            File dirFile = new File(dir);
            dirFile.mkdir();
        }
        return dir;
    }

    @Override
    public float getLowerThreshold() {
        return this.lowerThreshold_;
    }

    @Override
    public float getUpperThreshold() {
        return this.upperThreshold_;
    }

    private void initStoreHashes() {
        this.scanHash_ = new Hashtable();
        this.headerHash_ = new Hashtable();
        this.polarity_scanCount_ = new Hashtable();
    }

    private AddScan[] getAdders() {
        AddScan[] adders = new AddScan[this.translators_.size()];
        for (int i = 0; i != this.translators_.size(); ++i) {
            adders[i] = this.translators_.get(i);
        }
        return adders;
    }

    private String getBaseDir(int filePosition) {
        if (this.polaritySwitching_) {
            if (filePosition == 0) {
                return this.m_fileName.substring(0, this.m_fileName.lastIndexOf(".")) + "_positive" + ".chrom/";
            }
            if (filePosition == 1) {
                return this.m_fileName.substring(0, this.m_fileName.lastIndexOf(".")) + "_negative" + ".chrom/";
            }
            return null;
        }
        return this.m_fileName.substring(0, this.m_fileName.lastIndexOf(".")) + ".chrom/";
    }

    public static long append(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private int readIndexFile(DataInputStream inStream, Hashtable<Integer, Integer> lines, Hashtable<Integer, Long> indices, int count, long previousLength) throws IOException {
        int iteration = 0;
        while (inStream.available() > 0) {
            int currentLine = inStream.readInt();
            long bytesToSkip = inStream.readLong();
            if (iteration == 0 && count > 0) {
                while (lines.get(count - 1) + 1000 < currentLine) {
                    lines.put(count, lines.get(count - 1) + 1000);
                    indices.put(count, previousLength);
                    ++count;
                }
            }
            lines.put(new Integer(count), new Integer(currentLine));
            indices.put(new Integer(count), new Long(bytesToSkip) + previousLength);
            ++count;
            ++iteration;
        }
        return count;
    }

    private void readRetentionTimeFile(DataInputStream rttStream, Hashtable<Integer, Float> retentionTimes) throws IOException {
        while (rttStream.available() > 0) {
            int scanNumber = rttStream.readInt();
            float rtt = rttStream.readFloat();
            retentionTimes.put(scanNumber, Float.valueOf(rtt));
        }
    }

    private void handleTimerEvent(int msLevel) {
        boolean error = false;
        boolean stopThread = false;
        for (int i = 0; i != this.translators_.size(); ++i) {
            boolean isError = false;
            if (this.translators_.get(i) == null) {
                isError = true;
            }
            if (this.translators_.get(i) != null && this.translators_.get(i).finished() && this.quantStatus_.get(i) != 2) {
                RawToChromThread singleThread = this.translators_.get(i);
                if (this.translators_.get(i).getErrorString() != null) {
                    isError = true;
                } else {
                    if (i == 0) {
                        this.m_scanCount = singleThread.getm_scanCount();
                        this.polarity_scanCount_ = singleThread.getPolarityScanCount();
                        this.scanCounts_.put(msLevel, this.m_scanCount);
                        this.polarityScanCounts_.put(msLevel, this.polarity_scanCount_);
                        try {
                            singleThread.writeRetentionTimeFile(this.retentionTimeFileName_, this.polaritySwitching_);
                        }
                        catch (IOException iox) {
                            iox.printStackTrace();
                            this.errorString_ = iox.getMessage();
                            error = true;
                            stopThread = true;
                        }
                        this.numberOfMs2Scans_ = singleThread.getNumberOfMs2Scans();
                    }
                    singleThread.cleanUp();
                    System.gc();
                    this.quantStatus_.put(i, 2);
                }
            }
            if (!isError) continue;
            error = true;
            stopThread = true;
            this.errorString_ = this.translators_.get(i) != null ? this.translators_.get(i).getErrorString() : "There is no translator for unknown reason - contact the developer";
        }
        boolean allFinished = true;
        if (!error && this.translators_.size() > 0) {
            for (Integer status : this.quantStatus_.values()) {
                if (status == 2) continue;
                allFinished = false;
                break;
            }
            if (allFinished) {
                stopThread = true;
            }
        }
        if (stopThread) {
            if (!error) {
                // empty if block
            }
            this.oneIterationFinished_ = true;
        }
    }

    private int getCorrectScanCount(String key, int polarity) {
        if (polarity == 1 || polarity == 2) {
            return this.polarity_scanCount_.get(key).get(polarity);
        }
        return this.m_scanCount.get(key);
    }

    private int getCorrectScanCountMsMsSeveralFiles(int msLevel, String key, int polarity) {
        if (polarity == 1 || polarity == 2) {
            return this.polarityScanCounts_.get(msLevel).get(key).get(polarity);
        }
        return this.scanCounts_.get(msLevel).get(key);
    }

    public boolean isPolaritySwitched() {
        return this.polaritySwitching_;
    }

    private class ThreadSupervisor
    extends TimerTask {
        private int msLevel_;

        public ThreadSupervisor(int msLevel, int currentIteration) {
            this.msLevel_ = msLevel;
            this.startThreads(currentIteration);
        }

        @Override
        public void run() {
            try {
                if (!RawToChromTranslator.this.oneIterationFinished_) {
                    RawToChromTranslator.this.handleTimerEvent(this.msLevel_);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                RawToChromTranslator.this.errorString_ = ex.toString();
                RawToChromTranslator.this.oneIterationFinished_ = true;
            }
        }

        private void startThreads(int currentIteration) {
            for (int i = 0; i != RawToChromTranslator.this.numberOfThreads_; ++i) {
                RawToChromThread singleThread = (RawToChromThread)RawToChromTranslator.this.translators_.get(i);
                singleThread.start();
                RawToChromTranslator.this.quantStatus_.put(i, 1);
            }
        }
    }
}

