/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.lda.xml;

import at.tugraz.genome.lda.LipidDataAnalyzer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLFileLoader {
    protected File fn_;
    protected Document doc = null;

    public XMLFileLoader(File fn) {
        this.fn_ = fn;
    }

    public void parseXMLFile() throws SAXException {
        boolean validation = true;
        boolean ignoreWhitespace = true;
        boolean ignoreComments = true;
        boolean putCDATAIntoText = false;
        boolean createEntityRefs = false;
        if (this.fn_.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(validation);
            dbf.setIgnoringComments(ignoreComments);
            dbf.setIgnoringElementContentWhitespace(ignoreWhitespace);
            dbf.setCoalescing(putCDATAIntoText);
            dbf.setExpandEntityReferences(!createEntityRefs);
            String fullPath = LipidDataAnalyzer.class.getResource("LipidDataAnalyzer.class").toString();
            String pathToDTD = fullPath.substring(0, fullPath.length() - "at/tugraz/genome/lda/LipidDataAnalyzer.class".length()) + "dtds/";
            DocumentBuilder db = null;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException pce) {
                System.err.println(pce);
                JOptionPane.showConfirmDialog(null, "Error Initalising Parser! \n Can not start program", "Parser Error", -1, 0);
                System.exit(1);
            }
            db.setErrorHandler(new MyErrorHandler());
            this.doc = null;
            try {
                this.doc = db.parse(new BufferedInputStream(new FileInputStream(this.fn_)), pathToDTD);
                db = null;
            }
            catch (IOException ioe) {
                System.err.println(ioe);
            }
        } else {
            this.doc = null;
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

