package at.tugraz.genome.dbutilities;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

import org.andromda.core.common.StringUtilsHelper;
import org.apache.log4j.Logger;


/**
 * @author Juergen Hartler
 * @version 1.0
 */

public class OracleGenericDAOImpl extends GenericDAOImpl {

    
  /**
   * 
   * @param factory holds the parameters for the database connection
   */
    public OracleGenericDAOImpl(GenericDAOFactory factory) {
        log_.debug("OracleGenericDAOImpl");
        factory_ = factory;
    }

    /**
     * @return the primary key generator for the Oracle database
     */    
    public PKGenerator getPKGenerator(){
      return OraclePKGenerator.getInstance(factory_);
    }

    /**
     * 
     * @param input column name extracted from VO
     * @return database conform column name
     */
    protected String getDatabaseConformString (String input){
      return input;
    }

    /**
     * 
     * @param input table name extracted from VO
     * @return database conform table name
     */
    protected String getDatabaseConformTablename (String input){
      return input;
    }

}
